// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// LogService20210330GetRequest GetRequest is the request payload processed by the Get RPC.
//
// swagger:model log_service_20210330GetRequest
type LogService20210330GetRequest struct {

	// end defines the latest point in time from which to retrieve log entries.
	// Format: date-time
	End strfmt.DateTime `json:"end,omitempty"`

	// Specifies a page token to use to retrieve the next page.
	NextPageToken string `json:"next_page_token,omitempty"`

	// Specifies the list of per field ordering that should be used for sorting.
	OrderBy []string `json:"order_by"`

	// The max number of results per page that should be returned.
	PageSize int64 `json:"page_size,omitempty"`

	// start defines the earliest point in time from which to retrieve log
	// entries.
	// Format: date-time
	Start strfmt.DateTime `json:"start,omitempty"`

	// streams is the list of Log Streams to query from. At least one Log Stream
	// is required.
	Streams []*LogService20210330LogStream `json:"streams"`
}

// Validate validates this log service 20210330 get request
func (m *LogService20210330GetRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEnd(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStart(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStreams(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330GetRequest) validateEnd(formats strfmt.Registry) error {
	if swag.IsZero(m.End) { // not required
		return nil
	}

	if err := validate.FormatOf("end", "body", "date-time", m.End.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *LogService20210330GetRequest) validateStart(formats strfmt.Registry) error {
	if swag.IsZero(m.Start) { // not required
		return nil
	}

	if err := validate.FormatOf("start", "body", "date-time", m.Start.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *LogService20210330GetRequest) validateStreams(formats strfmt.Registry) error {
	if swag.IsZero(m.Streams) { // not required
		return nil
	}

	for i := 0; i < len(m.Streams); i++ {
		if swag.IsZero(m.Streams[i]) { // not required
			continue
		}

		if m.Streams[i] != nil {
			if err := m.Streams[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("streams" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("streams" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this log service 20210330 get request based on the context it is used
func (m *LogService20210330GetRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateStreams(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330GetRequest) contextValidateStreams(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Streams); i++ {

		if m.Streams[i] != nil {

			if swag.IsZero(m.Streams[i]) { // not required
				return nil
			}

			if err := m.Streams[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("streams" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("streams" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *LogService20210330GetRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LogService20210330GetRequest) UnmarshalBinary(b []byte) error {
	var res LogService20210330GetRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
