// Code generated by go-swagger; DO NOT EDIT.

package operation_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewListParams creates a new ListParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewListParams() *ListParams {
	return &ListParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewListParamsWithTimeout creates a new ListParams object
// with the ability to set a timeout on a request.
func NewListParamsWithTimeout(timeout time.Duration) *ListParams {
	return &ListParams{
		timeout: timeout,
	}
}

// NewListParamsWithContext creates a new ListParams object
// with the ability to set a context for a request.
func NewListParamsWithContext(ctx context.Context) *ListParams {
	return &ListParams{
		Context: ctx,
	}
}

// NewListParamsWithHTTPClient creates a new ListParams object
// with the ability to set a custom HTTPClient for a request.
func NewListParamsWithHTTPClient(client *http.Client) *ListParams {
	return &ListParams{
		HTTPClient: client,
	}
}

/*
ListParams contains all the parameters to send to the API endpoint

	for the list operation.

	Typically these are written to a http.Request.
*/
type ListParams struct {

	/* LinkedResourceDescription.

	     description is a human-friendly description for this link. This is
	used primarily for informational purposes such as error messages.
	*/
	LinkedResourceDescription *string

	/* LinkedResourceID.

	   id is the identifier for this resource.
	*/
	LinkedResourceID *string

	/* LinkedResourceLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	LinkedResourceLocationRegionProvider *string

	/* LinkedResourceLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	LinkedResourceLocationRegionRegion *string

	/* LinkedResourceType.

	     type is the unique type of the resource. Each service publishes a
	unique set of types. The type value is recommended to be formatted
	in "<org>.<type>" such as "hashicorp.hvn". This is to prevent conflicts
	in the future, but any string value will work.
	*/
	LinkedResourceType *string

	/* LinkedResourceUUID.

	   uuid is the unique UUID for this resource.
	*/
	LinkedResourceUUID *string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure").
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1").
	*/
	LocationRegionRegion *string

	/* PaginationNextPageToken.

	     Specifies a page token to use to retrieve the next page. Set this to the
	`next_page_token` returned by previous list requests to get the next page of
	results. If set, `previous_page_token` must not be set.
	*/
	PaginationNextPageToken *string

	/* PaginationPageSize.

	     The max number of results per page that should be returned. If the number
	of available results is larger than `page_size`, a `next_page_token` is
	returned which can be used to get the next page of results in subsequent
	requests. A value of zero will cause `page_size` to be defaulted.

	     Format: int64
	*/
	PaginationPageSize *int64

	/* PaginationPreviousPageToken.

	     Specifies a page token to use to retrieve the previous page. Set this to
	the `previous_page_token` returned by previous list requests to get the
	previous page of results. If set, `next_page_token` must not be set.
	*/
	PaginationPreviousPageToken *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the list params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListParams) WithDefaults() *ListParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the list params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ListParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the list params
func (o *ListParams) WithTimeout(timeout time.Duration) *ListParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the list params
func (o *ListParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the list params
func (o *ListParams) WithContext(ctx context.Context) *ListParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the list params
func (o *ListParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the list params
func (o *ListParams) WithHTTPClient(client *http.Client) *ListParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the list params
func (o *ListParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithLinkedResourceDescription adds the linkedResourceDescription to the list params
func (o *ListParams) WithLinkedResourceDescription(linkedResourceDescription *string) *ListParams {
	o.SetLinkedResourceDescription(linkedResourceDescription)
	return o
}

// SetLinkedResourceDescription adds the linkedResourceDescription to the list params
func (o *ListParams) SetLinkedResourceDescription(linkedResourceDescription *string) {
	o.LinkedResourceDescription = linkedResourceDescription
}

// WithLinkedResourceID adds the linkedResourceID to the list params
func (o *ListParams) WithLinkedResourceID(linkedResourceID *string) *ListParams {
	o.SetLinkedResourceID(linkedResourceID)
	return o
}

// SetLinkedResourceID adds the linkedResourceId to the list params
func (o *ListParams) SetLinkedResourceID(linkedResourceID *string) {
	o.LinkedResourceID = linkedResourceID
}

// WithLinkedResourceLocationRegionProvider adds the linkedResourceLocationRegionProvider to the list params
func (o *ListParams) WithLinkedResourceLocationRegionProvider(linkedResourceLocationRegionProvider *string) *ListParams {
	o.SetLinkedResourceLocationRegionProvider(linkedResourceLocationRegionProvider)
	return o
}

// SetLinkedResourceLocationRegionProvider adds the linkedResourceLocationRegionProvider to the list params
func (o *ListParams) SetLinkedResourceLocationRegionProvider(linkedResourceLocationRegionProvider *string) {
	o.LinkedResourceLocationRegionProvider = linkedResourceLocationRegionProvider
}

// WithLinkedResourceLocationRegionRegion adds the linkedResourceLocationRegionRegion to the list params
func (o *ListParams) WithLinkedResourceLocationRegionRegion(linkedResourceLocationRegionRegion *string) *ListParams {
	o.SetLinkedResourceLocationRegionRegion(linkedResourceLocationRegionRegion)
	return o
}

// SetLinkedResourceLocationRegionRegion adds the linkedResourceLocationRegionRegion to the list params
func (o *ListParams) SetLinkedResourceLocationRegionRegion(linkedResourceLocationRegionRegion *string) {
	o.LinkedResourceLocationRegionRegion = linkedResourceLocationRegionRegion
}

// WithLinkedResourceType adds the linkedResourceType to the list params
func (o *ListParams) WithLinkedResourceType(linkedResourceType *string) *ListParams {
	o.SetLinkedResourceType(linkedResourceType)
	return o
}

// SetLinkedResourceType adds the linkedResourceType to the list params
func (o *ListParams) SetLinkedResourceType(linkedResourceType *string) {
	o.LinkedResourceType = linkedResourceType
}

// WithLinkedResourceUUID adds the linkedResourceUUID to the list params
func (o *ListParams) WithLinkedResourceUUID(linkedResourceUUID *string) *ListParams {
	o.SetLinkedResourceUUID(linkedResourceUUID)
	return o
}

// SetLinkedResourceUUID adds the linkedResourceUuid to the list params
func (o *ListParams) SetLinkedResourceUUID(linkedResourceUUID *string) {
	o.LinkedResourceUUID = linkedResourceUUID
}

// WithLocationOrganizationID adds the locationOrganizationID to the list params
func (o *ListParams) WithLocationOrganizationID(locationOrganizationID string) *ListParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the list params
func (o *ListParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the list params
func (o *ListParams) WithLocationProjectID(locationProjectID string) *ListParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the list params
func (o *ListParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the list params
func (o *ListParams) WithLocationRegionProvider(locationRegionProvider *string) *ListParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the list params
func (o *ListParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the list params
func (o *ListParams) WithLocationRegionRegion(locationRegionRegion *string) *ListParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the list params
func (o *ListParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WithPaginationNextPageToken adds the paginationNextPageToken to the list params
func (o *ListParams) WithPaginationNextPageToken(paginationNextPageToken *string) *ListParams {
	o.SetPaginationNextPageToken(paginationNextPageToken)
	return o
}

// SetPaginationNextPageToken adds the paginationNextPageToken to the list params
func (o *ListParams) SetPaginationNextPageToken(paginationNextPageToken *string) {
	o.PaginationNextPageToken = paginationNextPageToken
}

// WithPaginationPageSize adds the paginationPageSize to the list params
func (o *ListParams) WithPaginationPageSize(paginationPageSize *int64) *ListParams {
	o.SetPaginationPageSize(paginationPageSize)
	return o
}

// SetPaginationPageSize adds the paginationPageSize to the list params
func (o *ListParams) SetPaginationPageSize(paginationPageSize *int64) {
	o.PaginationPageSize = paginationPageSize
}

// WithPaginationPreviousPageToken adds the paginationPreviousPageToken to the list params
func (o *ListParams) WithPaginationPreviousPageToken(paginationPreviousPageToken *string) *ListParams {
	o.SetPaginationPreviousPageToken(paginationPreviousPageToken)
	return o
}

// SetPaginationPreviousPageToken adds the paginationPreviousPageToken to the list params
func (o *ListParams) SetPaginationPreviousPageToken(paginationPreviousPageToken *string) {
	o.PaginationPreviousPageToken = paginationPreviousPageToken
}

// WriteToRequest writes these params to a swagger request
func (o *ListParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.LinkedResourceDescription != nil {

		// query param linked_resource.description
		var qrLinkedResourceDescription string

		if o.LinkedResourceDescription != nil {
			qrLinkedResourceDescription = *o.LinkedResourceDescription
		}
		qLinkedResourceDescription := qrLinkedResourceDescription
		if qLinkedResourceDescription != "" {

			if err := r.SetQueryParam("linked_resource.description", qLinkedResourceDescription); err != nil {
				return err
			}
		}
	}

	if o.LinkedResourceID != nil {

		// query param linked_resource.id
		var qrLinkedResourceID string

		if o.LinkedResourceID != nil {
			qrLinkedResourceID = *o.LinkedResourceID
		}
		qLinkedResourceID := qrLinkedResourceID
		if qLinkedResourceID != "" {

			if err := r.SetQueryParam("linked_resource.id", qLinkedResourceID); err != nil {
				return err
			}
		}
	}

	if o.LinkedResourceLocationRegionProvider != nil {

		// query param linked_resource.location.region.provider
		var qrLinkedResourceLocationRegionProvider string

		if o.LinkedResourceLocationRegionProvider != nil {
			qrLinkedResourceLocationRegionProvider = *o.LinkedResourceLocationRegionProvider
		}
		qLinkedResourceLocationRegionProvider := qrLinkedResourceLocationRegionProvider
		if qLinkedResourceLocationRegionProvider != "" {

			if err := r.SetQueryParam("linked_resource.location.region.provider", qLinkedResourceLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LinkedResourceLocationRegionRegion != nil {

		// query param linked_resource.location.region.region
		var qrLinkedResourceLocationRegionRegion string

		if o.LinkedResourceLocationRegionRegion != nil {
			qrLinkedResourceLocationRegionRegion = *o.LinkedResourceLocationRegionRegion
		}
		qLinkedResourceLocationRegionRegion := qrLinkedResourceLocationRegionRegion
		if qLinkedResourceLocationRegionRegion != "" {

			if err := r.SetQueryParam("linked_resource.location.region.region", qLinkedResourceLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if o.LinkedResourceType != nil {

		// query param linked_resource.type
		var qrLinkedResourceType string

		if o.LinkedResourceType != nil {
			qrLinkedResourceType = *o.LinkedResourceType
		}
		qLinkedResourceType := qrLinkedResourceType
		if qLinkedResourceType != "" {

			if err := r.SetQueryParam("linked_resource.type", qLinkedResourceType); err != nil {
				return err
			}
		}
	}

	if o.LinkedResourceUUID != nil {

		// query param linked_resource.uuid
		var qrLinkedResourceUUID string

		if o.LinkedResourceUUID != nil {
			qrLinkedResourceUUID = *o.LinkedResourceUUID
		}
		qLinkedResourceUUID := qrLinkedResourceUUID
		if qLinkedResourceUUID != "" {

			if err := r.SetQueryParam("linked_resource.uuid", qLinkedResourceUUID); err != nil {
				return err
			}
		}
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if o.PaginationNextPageToken != nil {

		// query param pagination.next_page_token
		var qrPaginationNextPageToken string

		if o.PaginationNextPageToken != nil {
			qrPaginationNextPageToken = *o.PaginationNextPageToken
		}
		qPaginationNextPageToken := qrPaginationNextPageToken
		if qPaginationNextPageToken != "" {

			if err := r.SetQueryParam("pagination.next_page_token", qPaginationNextPageToken); err != nil {
				return err
			}
		}
	}

	if o.PaginationPageSize != nil {

		// query param pagination.page_size
		var qrPaginationPageSize int64

		if o.PaginationPageSize != nil {
			qrPaginationPageSize = *o.PaginationPageSize
		}
		qPaginationPageSize := swag.FormatInt64(qrPaginationPageSize)
		if qPaginationPageSize != "" {

			if err := r.SetQueryParam("pagination.page_size", qPaginationPageSize); err != nil {
				return err
			}
		}
	}

	if o.PaginationPreviousPageToken != nil {

		// query param pagination.previous_page_token
		var qrPaginationPreviousPageToken string

		if o.PaginationPreviousPageToken != nil {
			qrPaginationPreviousPageToken = *o.PaginationPreviousPageToken
		}
		qPaginationPreviousPageToken := qrPaginationPreviousPageToken
		if qPaginationPreviousPageToken != "" {

			if err := r.SetQueryParam("pagination.previous_page_token", qPaginationPreviousPageToken); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
