// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2023-01-01/models"
)

// NewPackerServiceCreateVersionParams creates a new PackerServiceCreateVersionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPackerServiceCreateVersionParams() *PackerServiceCreateVersionParams {
	return &PackerServiceCreateVersionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPackerServiceCreateVersionParamsWithTimeout creates a new PackerServiceCreateVersionParams object
// with the ability to set a timeout on a request.
func NewPackerServiceCreateVersionParamsWithTimeout(timeout time.Duration) *PackerServiceCreateVersionParams {
	return &PackerServiceCreateVersionParams{
		timeout: timeout,
	}
}

// NewPackerServiceCreateVersionParamsWithContext creates a new PackerServiceCreateVersionParams object
// with the ability to set a context for a request.
func NewPackerServiceCreateVersionParamsWithContext(ctx context.Context) *PackerServiceCreateVersionParams {
	return &PackerServiceCreateVersionParams{
		Context: ctx,
	}
}

// NewPackerServiceCreateVersionParamsWithHTTPClient creates a new PackerServiceCreateVersionParams object
// with the ability to set a custom HTTPClient for a request.
func NewPackerServiceCreateVersionParamsWithHTTPClient(client *http.Client) *PackerServiceCreateVersionParams {
	return &PackerServiceCreateVersionParams{
		HTTPClient: client,
	}
}

/*
PackerServiceCreateVersionParams contains all the parameters to send to the API endpoint

	for the packer service create version operation.

	Typically these are written to a http.Request.
*/
type PackerServiceCreateVersionParams struct {

	// Body.
	Body *models.HashicorpCloudPacker20230101CreateVersionBody

	// BucketName.
	BucketName string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	/* LocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	LocationRegionProvider *string

	/* LocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	LocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the packer service create version params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceCreateVersionParams) WithDefaults() *PackerServiceCreateVersionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the packer service create version params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PackerServiceCreateVersionParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the packer service create version params
func (o *PackerServiceCreateVersionParams) WithTimeout(timeout time.Duration) *PackerServiceCreateVersionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the packer service create version params
func (o *PackerServiceCreateVersionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the packer service create version params
func (o *PackerServiceCreateVersionParams) WithContext(ctx context.Context) *PackerServiceCreateVersionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the packer service create version params
func (o *PackerServiceCreateVersionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the packer service create version params
func (o *PackerServiceCreateVersionParams) WithHTTPClient(client *http.Client) *PackerServiceCreateVersionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the packer service create version params
func (o *PackerServiceCreateVersionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the packer service create version params
func (o *PackerServiceCreateVersionParams) WithBody(body *models.HashicorpCloudPacker20230101CreateVersionBody) *PackerServiceCreateVersionParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the packer service create version params
func (o *PackerServiceCreateVersionParams) SetBody(body *models.HashicorpCloudPacker20230101CreateVersionBody) {
	o.Body = body
}

// WithBucketName adds the bucketName to the packer service create version params
func (o *PackerServiceCreateVersionParams) WithBucketName(bucketName string) *PackerServiceCreateVersionParams {
	o.SetBucketName(bucketName)
	return o
}

// SetBucketName adds the bucketName to the packer service create version params
func (o *PackerServiceCreateVersionParams) SetBucketName(bucketName string) {
	o.BucketName = bucketName
}

// WithLocationOrganizationID adds the locationOrganizationID to the packer service create version params
func (o *PackerServiceCreateVersionParams) WithLocationOrganizationID(locationOrganizationID string) *PackerServiceCreateVersionParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the packer service create version params
func (o *PackerServiceCreateVersionParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the packer service create version params
func (o *PackerServiceCreateVersionParams) WithLocationProjectID(locationProjectID string) *PackerServiceCreateVersionParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the packer service create version params
func (o *PackerServiceCreateVersionParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WithLocationRegionProvider adds the locationRegionProvider to the packer service create version params
func (o *PackerServiceCreateVersionParams) WithLocationRegionProvider(locationRegionProvider *string) *PackerServiceCreateVersionParams {
	o.SetLocationRegionProvider(locationRegionProvider)
	return o
}

// SetLocationRegionProvider adds the locationRegionProvider to the packer service create version params
func (o *PackerServiceCreateVersionParams) SetLocationRegionProvider(locationRegionProvider *string) {
	o.LocationRegionProvider = locationRegionProvider
}

// WithLocationRegionRegion adds the locationRegionRegion to the packer service create version params
func (o *PackerServiceCreateVersionParams) WithLocationRegionRegion(locationRegionRegion *string) *PackerServiceCreateVersionParams {
	o.SetLocationRegionRegion(locationRegionRegion)
	return o
}

// SetLocationRegionRegion adds the locationRegionRegion to the packer service create version params
func (o *PackerServiceCreateVersionParams) SetLocationRegionRegion(locationRegionRegion *string) {
	o.LocationRegionRegion = locationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *PackerServiceCreateVersionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param bucket_name
	if err := r.SetPathParam("bucket_name", o.BucketName); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if o.LocationRegionProvider != nil {

		// query param location.region.provider
		var qrLocationRegionProvider string

		if o.LocationRegionProvider != nil {
			qrLocationRegionProvider = *o.LocationRegionProvider
		}
		qLocationRegionProvider := qrLocationRegionProvider
		if qLocationRegionProvider != "" {

			if err := r.SetQueryParam("location.region.provider", qLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.LocationRegionRegion != nil {

		// query param location.region.region
		var qrLocationRegionRegion string

		if o.LocationRegionRegion != nil {
			qrLocationRegionRegion = *o.LocationRegionRegion
		}
		qLocationRegionRegion := qrLocationRegionRegion
		if qLocationRegionRegion != "" {

			if err := r.SetQueryParam("location.region.region", qLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
