// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2023-01-01/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceUpdateBuildReader is a Reader for the PackerServiceUpdateBuild structure.
type PackerServiceUpdateBuildReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceUpdateBuildReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceUpdateBuildOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceUpdateBuildDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceUpdateBuildOK creates a PackerServiceUpdateBuildOK with default headers values
func NewPackerServiceUpdateBuildOK() *PackerServiceUpdateBuildOK {
	return &PackerServiceUpdateBuildOK{}
}

/*
PackerServiceUpdateBuildOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceUpdateBuildOK struct {
	Payload *models.HashicorpCloudPacker20230101UpdateBuildResponse
}

// IsSuccess returns true when this packer service update build o k response has a 2xx status code
func (o *PackerServiceUpdateBuildOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service update build o k response has a 3xx status code
func (o *PackerServiceUpdateBuildOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service update build o k response has a 4xx status code
func (o *PackerServiceUpdateBuildOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service update build o k response has a 5xx status code
func (o *PackerServiceUpdateBuildOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service update build o k response a status code equal to that given
func (o *PackerServiceUpdateBuildOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the packer service update build o k response
func (o *PackerServiceUpdateBuildOK) Code() int {
	return 200
}

func (o *PackerServiceUpdateBuildOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}][%d] packerServiceUpdateBuildOK %s", 200, payload)
}

func (o *PackerServiceUpdateBuildOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}][%d] packerServiceUpdateBuildOK %s", 200, payload)
}

func (o *PackerServiceUpdateBuildOK) GetPayload() *models.HashicorpCloudPacker20230101UpdateBuildResponse {
	return o.Payload
}

func (o *PackerServiceUpdateBuildOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPacker20230101UpdateBuildResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceUpdateBuildDefault creates a PackerServiceUpdateBuildDefault with default headers values
func NewPackerServiceUpdateBuildDefault(code int) *PackerServiceUpdateBuildDefault {
	return &PackerServiceUpdateBuildDefault{
		_statusCode: code,
	}
}

/*
PackerServiceUpdateBuildDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceUpdateBuildDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this packer service update build default response has a 2xx status code
func (o *PackerServiceUpdateBuildDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service update build default response has a 3xx status code
func (o *PackerServiceUpdateBuildDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service update build default response has a 4xx status code
func (o *PackerServiceUpdateBuildDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service update build default response has a 5xx status code
func (o *PackerServiceUpdateBuildDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service update build default response a status code equal to that given
func (o *PackerServiceUpdateBuildDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the packer service update build default response
func (o *PackerServiceUpdateBuildDefault) Code() int {
	return o._statusCode
}

func (o *PackerServiceUpdateBuildDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}][%d] PackerService_UpdateBuild default %s", o._statusCode, payload)
}

func (o *PackerServiceUpdateBuildDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}][%d] PackerService_UpdateBuild default %s", o._statusCode, payload)
}

func (o *PackerServiceUpdateBuildDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *PackerServiceUpdateBuildDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
