// Code generated by go-swagger; DO NOT EDIT.

package resource_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewResourceServiceListParams creates a new ResourceServiceListParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewResourceServiceListParams() *ResourceServiceListParams {
	return &ResourceServiceListParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewResourceServiceListParamsWithTimeout creates a new ResourceServiceListParams object
// with the ability to set a timeout on a request.
func NewResourceServiceListParamsWithTimeout(timeout time.Duration) *ResourceServiceListParams {
	return &ResourceServiceListParams{
		timeout: timeout,
	}
}

// NewResourceServiceListParamsWithContext creates a new ResourceServiceListParams object
// with the ability to set a context for a request.
func NewResourceServiceListParamsWithContext(ctx context.Context) *ResourceServiceListParams {
	return &ResourceServiceListParams{
		Context: ctx,
	}
}

// NewResourceServiceListParamsWithHTTPClient creates a new ResourceServiceListParams object
// with the ability to set a custom HTTPClient for a request.
func NewResourceServiceListParamsWithHTTPClient(client *http.Client) *ResourceServiceListParams {
	return &ResourceServiceListParams{
		HTTPClient: client,
	}
}

/*
ResourceServiceListParams contains all the parameters to send to the API endpoint

	for the resource service list operation.

	Typically these are written to a http.Request.
*/
type ResourceServiceListParams struct {

	/* PaginationNextPageToken.

	     Specifies a page token to use to retrieve the next page. Set this to the
	`next_page_token` returned by previous list requests to get the next page of
	results. If set, `previous_page_token` must not be set.
	*/
	PaginationNextPageToken *string

	/* PaginationPageSize.

	     The max number of results per page that should be returned. If the number
	of available results is larger than `page_size`, a `next_page_token` is
	returned which can be used to get the next page of results in subsequent
	requests. A value of zero will cause `page_size` to be defaulted.

	     Format: int64
	*/
	PaginationPageSize *int64

	/* PaginationPreviousPageToken.

	     Specifies a page token to use to retrieve the previous page. Set this to
	the `previous_page_token` returned by previous list requests to get the
	previous page of results. If set, `next_page_token` must not be set.
	*/
	PaginationPreviousPageToken *string

	/* ScopeID.

	   id is the id of the object being referenced.
	*/
	ScopeID *string

	/* ScopeType.

	   ResourceType is the type of object being referenced.

	   Default: "UNKNOWN"
	*/
	ScopeType *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the resource service list params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ResourceServiceListParams) WithDefaults() *ResourceServiceListParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the resource service list params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ResourceServiceListParams) SetDefaults() {
	var (
		scopeTypeDefault = string("UNKNOWN")
	)

	val := ResourceServiceListParams{
		ScopeType: &scopeTypeDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the resource service list params
func (o *ResourceServiceListParams) WithTimeout(timeout time.Duration) *ResourceServiceListParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the resource service list params
func (o *ResourceServiceListParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the resource service list params
func (o *ResourceServiceListParams) WithContext(ctx context.Context) *ResourceServiceListParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the resource service list params
func (o *ResourceServiceListParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the resource service list params
func (o *ResourceServiceListParams) WithHTTPClient(client *http.Client) *ResourceServiceListParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the resource service list params
func (o *ResourceServiceListParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithPaginationNextPageToken adds the paginationNextPageToken to the resource service list params
func (o *ResourceServiceListParams) WithPaginationNextPageToken(paginationNextPageToken *string) *ResourceServiceListParams {
	o.SetPaginationNextPageToken(paginationNextPageToken)
	return o
}

// SetPaginationNextPageToken adds the paginationNextPageToken to the resource service list params
func (o *ResourceServiceListParams) SetPaginationNextPageToken(paginationNextPageToken *string) {
	o.PaginationNextPageToken = paginationNextPageToken
}

// WithPaginationPageSize adds the paginationPageSize to the resource service list params
func (o *ResourceServiceListParams) WithPaginationPageSize(paginationPageSize *int64) *ResourceServiceListParams {
	o.SetPaginationPageSize(paginationPageSize)
	return o
}

// SetPaginationPageSize adds the paginationPageSize to the resource service list params
func (o *ResourceServiceListParams) SetPaginationPageSize(paginationPageSize *int64) {
	o.PaginationPageSize = paginationPageSize
}

// WithPaginationPreviousPageToken adds the paginationPreviousPageToken to the resource service list params
func (o *ResourceServiceListParams) WithPaginationPreviousPageToken(paginationPreviousPageToken *string) *ResourceServiceListParams {
	o.SetPaginationPreviousPageToken(paginationPreviousPageToken)
	return o
}

// SetPaginationPreviousPageToken adds the paginationPreviousPageToken to the resource service list params
func (o *ResourceServiceListParams) SetPaginationPreviousPageToken(paginationPreviousPageToken *string) {
	o.PaginationPreviousPageToken = paginationPreviousPageToken
}

// WithScopeID adds the scopeID to the resource service list params
func (o *ResourceServiceListParams) WithScopeID(scopeID *string) *ResourceServiceListParams {
	o.SetScopeID(scopeID)
	return o
}

// SetScopeID adds the scopeId to the resource service list params
func (o *ResourceServiceListParams) SetScopeID(scopeID *string) {
	o.ScopeID = scopeID
}

// WithScopeType adds the scopeType to the resource service list params
func (o *ResourceServiceListParams) WithScopeType(scopeType *string) *ResourceServiceListParams {
	o.SetScopeType(scopeType)
	return o
}

// SetScopeType adds the scopeType to the resource service list params
func (o *ResourceServiceListParams) SetScopeType(scopeType *string) {
	o.ScopeType = scopeType
}

// WriteToRequest writes these params to a swagger request
func (o *ResourceServiceListParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.PaginationNextPageToken != nil {

		// query param pagination.next_page_token
		var qrPaginationNextPageToken string

		if o.PaginationNextPageToken != nil {
			qrPaginationNextPageToken = *o.PaginationNextPageToken
		}
		qPaginationNextPageToken := qrPaginationNextPageToken
		if qPaginationNextPageToken != "" {

			if err := r.SetQueryParam("pagination.next_page_token", qPaginationNextPageToken); err != nil {
				return err
			}
		}
	}

	if o.PaginationPageSize != nil {

		// query param pagination.page_size
		var qrPaginationPageSize int64

		if o.PaginationPageSize != nil {
			qrPaginationPageSize = *o.PaginationPageSize
		}
		qPaginationPageSize := swag.FormatInt64(qrPaginationPageSize)
		if qPaginationPageSize != "" {

			if err := r.SetQueryParam("pagination.page_size", qPaginationPageSize); err != nil {
				return err
			}
		}
	}

	if o.PaginationPreviousPageToken != nil {

		// query param pagination.previous_page_token
		var qrPaginationPreviousPageToken string

		if o.PaginationPreviousPageToken != nil {
			qrPaginationPreviousPageToken = *o.PaginationPreviousPageToken
		}
		qPaginationPreviousPageToken := qrPaginationPreviousPageToken
		if qPaginationPreviousPageToken != "" {

			if err := r.SetQueryParam("pagination.previous_page_token", qPaginationPreviousPageToken); err != nil {
				return err
			}
		}
	}

	if o.ScopeID != nil {

		// query param scope.id
		var qrScopeID string

		if o.ScopeID != nil {
			qrScopeID = *o.ScopeID
		}
		qScopeID := qrScopeID
		if qScopeID != "" {

			if err := r.SetQueryParam("scope.id", qScopeID); err != nil {
				return err
			}
		}
	}

	if o.ScopeType != nil {

		// query param scope.type
		var qrScopeType string

		if o.ScopeType != nil {
			qrScopeType = *o.ScopeType
		}
		qScopeType := qrScopeType
		if qScopeType != "" {

			if err := r.SetQueryParam("scope.type", qScopeType); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
