// Code generated by go-swagger; DO NOT EDIT.

package resource_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-resource-manager/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ResourceServiceListRolesReader is a Reader for the ResourceServiceListRoles structure.
type ResourceServiceListRolesReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ResourceServiceListRolesReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewResourceServiceListRolesOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewResourceServiceListRolesDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewResourceServiceListRolesOK creates a ResourceServiceListRolesOK with default headers values
func NewResourceServiceListRolesOK() *ResourceServiceListRolesOK {
	return &ResourceServiceListRolesOK{}
}

/*
ResourceServiceListRolesOK describes a response with status code 200, with default header values.

A successful response.
*/
type ResourceServiceListRolesOK struct {
	Payload *models.HashicorpCloudResourcemanagerListRolesResponse
}

// IsSuccess returns true when this resource service list roles o k response has a 2xx status code
func (o *ResourceServiceListRolesOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this resource service list roles o k response has a 3xx status code
func (o *ResourceServiceListRolesOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this resource service list roles o k response has a 4xx status code
func (o *ResourceServiceListRolesOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this resource service list roles o k response has a 5xx status code
func (o *ResourceServiceListRolesOK) IsServerError() bool {
	return false
}

// IsCode returns true when this resource service list roles o k response a status code equal to that given
func (o *ResourceServiceListRolesOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the resource service list roles o k response
func (o *ResourceServiceListRolesOK) Code() int {
	return 200
}

func (o *ResourceServiceListRolesOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/resource/roles][%d] resourceServiceListRolesOK %s", 200, payload)
}

func (o *ResourceServiceListRolesOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/resource/roles][%d] resourceServiceListRolesOK %s", 200, payload)
}

func (o *ResourceServiceListRolesOK) GetPayload() *models.HashicorpCloudResourcemanagerListRolesResponse {
	return o.Payload
}

func (o *ResourceServiceListRolesOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudResourcemanagerListRolesResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewResourceServiceListRolesDefault creates a ResourceServiceListRolesDefault with default headers values
func NewResourceServiceListRolesDefault(code int) *ResourceServiceListRolesDefault {
	return &ResourceServiceListRolesDefault{
		_statusCode: code,
	}
}

/*
ResourceServiceListRolesDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ResourceServiceListRolesDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this resource service list roles default response has a 2xx status code
func (o *ResourceServiceListRolesDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this resource service list roles default response has a 3xx status code
func (o *ResourceServiceListRolesDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this resource service list roles default response has a 4xx status code
func (o *ResourceServiceListRolesDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this resource service list roles default response has a 5xx status code
func (o *ResourceServiceListRolesDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this resource service list roles default response a status code equal to that given
func (o *ResourceServiceListRolesDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the resource service list roles default response
func (o *ResourceServiceListRolesDefault) Code() int {
	return o._statusCode
}

func (o *ResourceServiceListRolesDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/resource/roles][%d] ResourceService_ListRoles default %s", o._statusCode, payload)
}

func (o *ResourceServiceListRolesDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/resource/roles][%d] ResourceService_ListRoles default %s", o._statusCode, payload)
}

func (o *ResourceServiceListRolesDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ResourceServiceListRolesDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
