// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewReadArchitectureParams creates a new ReadArchitectureParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewReadArchitectureParams() *ReadArchitectureParams {
	return &ReadArchitectureParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewReadArchitectureParamsWithTimeout creates a new ReadArchitectureParams object
// with the ability to set a timeout on a request.
func NewReadArchitectureParamsWithTimeout(timeout time.Duration) *ReadArchitectureParams {
	return &ReadArchitectureParams{
		timeout: timeout,
	}
}

// NewReadArchitectureParamsWithContext creates a new ReadArchitectureParams object
// with the ability to set a context for a request.
func NewReadArchitectureParamsWithContext(ctx context.Context) *ReadArchitectureParams {
	return &ReadArchitectureParams{
		Context: ctx,
	}
}

// NewReadArchitectureParamsWithHTTPClient creates a new ReadArchitectureParams object
// with the ability to set a custom HTTPClient for a request.
func NewReadArchitectureParamsWithHTTPClient(client *http.Client) *ReadArchitectureParams {
	return &ReadArchitectureParams{
		HTTPClient: client,
	}
}

/*
ReadArchitectureParams contains all the parameters to send to the API endpoint

	for the read architecture operation.

	Typically these are written to a http.Request.
*/
type ReadArchitectureParams struct {

	/* Architecture.

	   The name of the Architecture.
	*/
	Architecture string

	/* Box.

	     The name segment of the Box. As an example, this field would represent the
	"vagrant" in "hashicorp/vagrant".
	*/
	Box string

	/* Provider.

	   The name of the Provider.
	*/
	Provider string

	/* Registry.

	     The Registry segment of the Box. As an example, this field would represent
	the "hashicorp" in "hashicorp/vagrant".
	*/
	Registry string

	/* Version.

	   The name of the Version for the Architecture.
	*/
	Version string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the read architecture params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ReadArchitectureParams) WithDefaults() *ReadArchitectureParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the read architecture params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ReadArchitectureParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the read architecture params
func (o *ReadArchitectureParams) WithTimeout(timeout time.Duration) *ReadArchitectureParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the read architecture params
func (o *ReadArchitectureParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the read architecture params
func (o *ReadArchitectureParams) WithContext(ctx context.Context) *ReadArchitectureParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the read architecture params
func (o *ReadArchitectureParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the read architecture params
func (o *ReadArchitectureParams) WithHTTPClient(client *http.Client) *ReadArchitectureParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the read architecture params
func (o *ReadArchitectureParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithArchitecture adds the architecture to the read architecture params
func (o *ReadArchitectureParams) WithArchitecture(architecture string) *ReadArchitectureParams {
	o.SetArchitecture(architecture)
	return o
}

// SetArchitecture adds the architecture to the read architecture params
func (o *ReadArchitectureParams) SetArchitecture(architecture string) {
	o.Architecture = architecture
}

// WithBox adds the box to the read architecture params
func (o *ReadArchitectureParams) WithBox(box string) *ReadArchitectureParams {
	o.SetBox(box)
	return o
}

// SetBox adds the box to the read architecture params
func (o *ReadArchitectureParams) SetBox(box string) {
	o.Box = box
}

// WithProvider adds the provider to the read architecture params
func (o *ReadArchitectureParams) WithProvider(provider string) *ReadArchitectureParams {
	o.SetProvider(provider)
	return o
}

// SetProvider adds the provider to the read architecture params
func (o *ReadArchitectureParams) SetProvider(provider string) {
	o.Provider = provider
}

// WithRegistry adds the registry to the read architecture params
func (o *ReadArchitectureParams) WithRegistry(registry string) *ReadArchitectureParams {
	o.SetRegistry(registry)
	return o
}

// SetRegistry adds the registry to the read architecture params
func (o *ReadArchitectureParams) SetRegistry(registry string) {
	o.Registry = registry
}

// WithVersion adds the version to the read architecture params
func (o *ReadArchitectureParams) WithVersion(version string) *ReadArchitectureParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the read architecture params
func (o *ReadArchitectureParams) SetVersion(version string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *ReadArchitectureParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param architecture
	if err := r.SetPathParam("architecture", o.Architecture); err != nil {
		return err
	}

	// path param box
	if err := r.SetPathParam("box", o.Box); err != nil {
		return err
	}

	// path param provider
	if err := r.SetPathParam("provider", o.Provider); err != nil {
		return err
	}

	// path param registry
	if err := r.SetPathParam("registry", o.Registry); err != nil {
		return err
	}

	// path param version
	if err := r.SetPathParam("version", o.Version); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
