// Code generated by go-swagger; DO NOT EDIT.

package vault_link_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-link-service/preview/2022-11-07/models"
)

// InspectRouterReader is a Reader for the InspectRouter structure.
type InspectRouterReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *InspectRouterReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewInspectRouterOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewInspectRouterDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewInspectRouterOK creates a InspectRouterOK with default headers values
func NewInspectRouterOK() *InspectRouterOK {
	return &InspectRouterOK{}
}

/*
InspectRouterOK describes a response with status code 200, with default header values.

A successful response.
*/
type InspectRouterOK struct {
	Payload *models.HashicorpCloudVaultLink20221107InspectRouterResponse
}

// IsSuccess returns true when this inspect router o k response has a 2xx status code
func (o *InspectRouterOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this inspect router o k response has a 3xx status code
func (o *InspectRouterOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this inspect router o k response has a 4xx status code
func (o *InspectRouterOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this inspect router o k response has a 5xx status code
func (o *InspectRouterOK) IsServerError() bool {
	return false
}

// IsCode returns true when this inspect router o k response a status code equal to that given
func (o *InspectRouterOK) IsCode(code int) bool {
	return code == 200
}

func (o *InspectRouterOK) Error() string {
	return fmt.Sprintf("[GET /vault-link/2022-11-07/organizations/{location.organization_id}/projects/{location.project_id}/{cluster_id}/inspect-router][%d] inspectRouterOK  %+v", 200, o.Payload)
}

func (o *InspectRouterOK) String() string {
	return fmt.Sprintf("[GET /vault-link/2022-11-07/organizations/{location.organization_id}/projects/{location.project_id}/{cluster_id}/inspect-router][%d] inspectRouterOK  %+v", 200, o.Payload)
}

func (o *InspectRouterOK) GetPayload() *models.HashicorpCloudVaultLink20221107InspectRouterResponse {
	return o.Payload
}

func (o *InspectRouterOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVaultLink20221107InspectRouterResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewInspectRouterDefault creates a InspectRouterDefault with default headers values
func NewInspectRouterDefault(code int) *InspectRouterDefault {
	return &InspectRouterDefault{
		_statusCode: code,
	}
}

/*
InspectRouterDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type InspectRouterDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// Code gets the status code for the inspect router default response
func (o *InspectRouterDefault) Code() int {
	return o._statusCode
}

// IsSuccess returns true when this inspect router default response has a 2xx status code
func (o *InspectRouterDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this inspect router default response has a 3xx status code
func (o *InspectRouterDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this inspect router default response has a 4xx status code
func (o *InspectRouterDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this inspect router default response has a 5xx status code
func (o *InspectRouterDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this inspect router default response a status code equal to that given
func (o *InspectRouterDefault) IsCode(code int) bool {
	return o._statusCode == code
}

func (o *InspectRouterDefault) Error() string {
	return fmt.Sprintf("[GET /vault-link/2022-11-07/organizations/{location.organization_id}/projects/{location.project_id}/{cluster_id}/inspect-router][%d] InspectRouter default  %+v", o._statusCode, o.Payload)
}

func (o *InspectRouterDefault) String() string {
	return fmt.Sprintf("[GET /vault-link/2022-11-07/organizations/{location.organization_id}/projects/{location.project_id}/{cluster_id}/inspect-router][%d] InspectRouter default  %+v", o._statusCode, o.Payload)
}

func (o *InspectRouterDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *InspectRouterDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
