// Code generated by go-swagger; DO NOT EDIT.

package integration_subscription_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-radar/preview/2023-05-01/models"
)

// DeleteIntegrationSubscriptionReader is a Reader for the DeleteIntegrationSubscription structure.
type DeleteIntegrationSubscriptionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteIntegrationSubscriptionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteIntegrationSubscriptionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDeleteIntegrationSubscriptionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDeleteIntegrationSubscriptionOK creates a DeleteIntegrationSubscriptionOK with default headers values
func NewDeleteIntegrationSubscriptionOK() *DeleteIntegrationSubscriptionOK {
	return &DeleteIntegrationSubscriptionOK{}
}

/*
DeleteIntegrationSubscriptionOK describes a response with status code 200, with default header values.

A successful response.
*/
type DeleteIntegrationSubscriptionOK struct {
	Payload interface{}
}

// IsSuccess returns true when this delete integration subscription o k response has a 2xx status code
func (o *DeleteIntegrationSubscriptionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete integration subscription o k response has a 3xx status code
func (o *DeleteIntegrationSubscriptionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete integration subscription o k response has a 4xx status code
func (o *DeleteIntegrationSubscriptionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete integration subscription o k response has a 5xx status code
func (o *DeleteIntegrationSubscriptionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete integration subscription o k response a status code equal to that given
func (o *DeleteIntegrationSubscriptionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete integration subscription o k response
func (o *DeleteIntegrationSubscriptionOK) Code() int {
	return 200
}

func (o *DeleteIntegrationSubscriptionOK) Error() string {
	return fmt.Sprintf("[DELETE /2023-05-01/vault-radar/projects/{location.project_id}/integrations/subscriptions/{id}][%d] deleteIntegrationSubscriptionOK  %+v", 200, o.Payload)
}

func (o *DeleteIntegrationSubscriptionOK) String() string {
	return fmt.Sprintf("[DELETE /2023-05-01/vault-radar/projects/{location.project_id}/integrations/subscriptions/{id}][%d] deleteIntegrationSubscriptionOK  %+v", 200, o.Payload)
}

func (o *DeleteIntegrationSubscriptionOK) GetPayload() interface{} {
	return o.Payload
}

func (o *DeleteIntegrationSubscriptionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteIntegrationSubscriptionDefault creates a DeleteIntegrationSubscriptionDefault with default headers values
func NewDeleteIntegrationSubscriptionDefault(code int) *DeleteIntegrationSubscriptionDefault {
	return &DeleteIntegrationSubscriptionDefault{
		_statusCode: code,
	}
}

/*
DeleteIntegrationSubscriptionDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type DeleteIntegrationSubscriptionDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this delete integration subscription default response has a 2xx status code
func (o *DeleteIntegrationSubscriptionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this delete integration subscription default response has a 3xx status code
func (o *DeleteIntegrationSubscriptionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this delete integration subscription default response has a 4xx status code
func (o *DeleteIntegrationSubscriptionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this delete integration subscription default response has a 5xx status code
func (o *DeleteIntegrationSubscriptionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this delete integration subscription default response a status code equal to that given
func (o *DeleteIntegrationSubscriptionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the delete integration subscription default response
func (o *DeleteIntegrationSubscriptionDefault) Code() int {
	return o._statusCode
}

func (o *DeleteIntegrationSubscriptionDefault) Error() string {
	return fmt.Sprintf("[DELETE /2023-05-01/vault-radar/projects/{location.project_id}/integrations/subscriptions/{id}][%d] DeleteIntegrationSubscription default  %+v", o._statusCode, o.Payload)
}

func (o *DeleteIntegrationSubscriptionDefault) String() string {
	return fmt.Sprintf("[DELETE /2023-05-01/vault-radar/projects/{location.project_id}/integrations/subscriptions/{id}][%d] DeleteIntegrationSubscription default  %+v", o._statusCode, o.Payload)
}

func (o *DeleteIntegrationSubscriptionDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *DeleteIntegrationSubscriptionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
