// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewCompleteVercelInstallationParams creates a new CompleteVercelInstallationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCompleteVercelInstallationParams() *CompleteVercelInstallationParams {
	return &CompleteVercelInstallationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCompleteVercelInstallationParamsWithTimeout creates a new CompleteVercelInstallationParams object
// with the ability to set a timeout on a request.
func NewCompleteVercelInstallationParamsWithTimeout(timeout time.Duration) *CompleteVercelInstallationParams {
	return &CompleteVercelInstallationParams{
		timeout: timeout,
	}
}

// NewCompleteVercelInstallationParamsWithContext creates a new CompleteVercelInstallationParams object
// with the ability to set a context for a request.
func NewCompleteVercelInstallationParamsWithContext(ctx context.Context) *CompleteVercelInstallationParams {
	return &CompleteVercelInstallationParams{
		Context: ctx,
	}
}

// NewCompleteVercelInstallationParamsWithHTTPClient creates a new CompleteVercelInstallationParams object
// with the ability to set a custom HTTPClient for a request.
func NewCompleteVercelInstallationParamsWithHTTPClient(client *http.Client) *CompleteVercelInstallationParams {
	return &CompleteVercelInstallationParams{
		HTTPClient: client,
	}
}

/*
CompleteVercelInstallationParams contains all the parameters to send to the API endpoint

	for the complete vercel installation operation.

	Typically these are written to a http.Request.
*/
type CompleteVercelInstallationParams struct {

	// Code.
	Code *string

	// ConfigurationID.
	ConfigurationID *string

	// State.
	State *string

	// TeamID.
	TeamID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the complete vercel installation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CompleteVercelInstallationParams) WithDefaults() *CompleteVercelInstallationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the complete vercel installation params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CompleteVercelInstallationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the complete vercel installation params
func (o *CompleteVercelInstallationParams) WithTimeout(timeout time.Duration) *CompleteVercelInstallationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the complete vercel installation params
func (o *CompleteVercelInstallationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the complete vercel installation params
func (o *CompleteVercelInstallationParams) WithContext(ctx context.Context) *CompleteVercelInstallationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the complete vercel installation params
func (o *CompleteVercelInstallationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the complete vercel installation params
func (o *CompleteVercelInstallationParams) WithHTTPClient(client *http.Client) *CompleteVercelInstallationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the complete vercel installation params
func (o *CompleteVercelInstallationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCode adds the code to the complete vercel installation params
func (o *CompleteVercelInstallationParams) WithCode(code *string) *CompleteVercelInstallationParams {
	o.SetCode(code)
	return o
}

// SetCode adds the code to the complete vercel installation params
func (o *CompleteVercelInstallationParams) SetCode(code *string) {
	o.Code = code
}

// WithConfigurationID adds the configurationID to the complete vercel installation params
func (o *CompleteVercelInstallationParams) WithConfigurationID(configurationID *string) *CompleteVercelInstallationParams {
	o.SetConfigurationID(configurationID)
	return o
}

// SetConfigurationID adds the configurationId to the complete vercel installation params
func (o *CompleteVercelInstallationParams) SetConfigurationID(configurationID *string) {
	o.ConfigurationID = configurationID
}

// WithState adds the state to the complete vercel installation params
func (o *CompleteVercelInstallationParams) WithState(state *string) *CompleteVercelInstallationParams {
	o.SetState(state)
	return o
}

// SetState adds the state to the complete vercel installation params
func (o *CompleteVercelInstallationParams) SetState(state *string) {
	o.State = state
}

// WithTeamID adds the teamID to the complete vercel installation params
func (o *CompleteVercelInstallationParams) WithTeamID(teamID *string) *CompleteVercelInstallationParams {
	o.SetTeamID(teamID)
	return o
}

// SetTeamID adds the teamId to the complete vercel installation params
func (o *CompleteVercelInstallationParams) SetTeamID(teamID *string) {
	o.TeamID = teamID
}

// WriteToRequest writes these params to a swagger request
func (o *CompleteVercelInstallationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Code != nil {

		// query param code
		var qrCode string

		if o.Code != nil {
			qrCode = *o.Code
		}
		qCode := qrCode
		if qCode != "" {

			if err := r.SetQueryParam("code", qCode); err != nil {
				return err
			}
		}
	}

	if o.ConfigurationID != nil {

		// query param configuration_id
		var qrConfigurationID string

		if o.ConfigurationID != nil {
			qrConfigurationID = *o.ConfigurationID
		}
		qConfigurationID := qrConfigurationID
		if qConfigurationID != "" {

			if err := r.SetQueryParam("configuration_id", qConfigurationID); err != nil {
				return err
			}
		}
	}

	if o.State != nil {

		// query param state
		var qrState string

		if o.State != nil {
			qrState = *o.State
		}
		qState := qrState
		if qState != "" {

			if err := r.SetQueryParam("state", qState); err != nil {
				return err
			}
		}
	}

	if o.TeamID != nil {

		// query param team_id
		var qrTeamID string

		if o.TeamID != nil {
			qrTeamID = *o.TeamID
		}
		qTeamID := qrTeamID
		if qTeamID != "" {

			if err := r.SetQueryParam("team_id", qTeamID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
