// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// BulkCreateAppKVSecretsReader is a Reader for the BulkCreateAppKVSecrets structure.
type BulkCreateAppKVSecretsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BulkCreateAppKVSecretsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewBulkCreateAppKVSecretsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewBulkCreateAppKVSecretsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewBulkCreateAppKVSecretsOK creates a BulkCreateAppKVSecretsOK with default headers values
func NewBulkCreateAppKVSecretsOK() *BulkCreateAppKVSecretsOK {
	return &BulkCreateAppKVSecretsOK{}
}

/*
BulkCreateAppKVSecretsOK describes a response with status code 200, with default header values.

A successful response.
*/
type BulkCreateAppKVSecretsOK struct {
	Payload *models.Secrets20231128BulkCreateAppKVSecretsResponse
}

// IsSuccess returns true when this bulk create app k v secrets o k response has a 2xx status code
func (o *BulkCreateAppKVSecretsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this bulk create app k v secrets o k response has a 3xx status code
func (o *BulkCreateAppKVSecretsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this bulk create app k v secrets o k response has a 4xx status code
func (o *BulkCreateAppKVSecretsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this bulk create app k v secrets o k response has a 5xx status code
func (o *BulkCreateAppKVSecretsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this bulk create app k v secrets o k response a status code equal to that given
func (o *BulkCreateAppKVSecretsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the bulk create app k v secrets o k response
func (o *BulkCreateAppKVSecretsOK) Code() int {
	return 200
}

func (o *BulkCreateAppKVSecretsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secret/kv:batch][%d] bulkCreateAppKVSecretsOK %s", 200, payload)
}

func (o *BulkCreateAppKVSecretsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secret/kv:batch][%d] bulkCreateAppKVSecretsOK %s", 200, payload)
}

func (o *BulkCreateAppKVSecretsOK) GetPayload() *models.Secrets20231128BulkCreateAppKVSecretsResponse {
	return o.Payload
}

func (o *BulkCreateAppKVSecretsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128BulkCreateAppKVSecretsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBulkCreateAppKVSecretsDefault creates a BulkCreateAppKVSecretsDefault with default headers values
func NewBulkCreateAppKVSecretsDefault(code int) *BulkCreateAppKVSecretsDefault {
	return &BulkCreateAppKVSecretsDefault{
		_statusCode: code,
	}
}

/*
BulkCreateAppKVSecretsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type BulkCreateAppKVSecretsDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this bulk create app k v secrets default response has a 2xx status code
func (o *BulkCreateAppKVSecretsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this bulk create app k v secrets default response has a 3xx status code
func (o *BulkCreateAppKVSecretsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this bulk create app k v secrets default response has a 4xx status code
func (o *BulkCreateAppKVSecretsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this bulk create app k v secrets default response has a 5xx status code
func (o *BulkCreateAppKVSecretsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this bulk create app k v secrets default response a status code equal to that given
func (o *BulkCreateAppKVSecretsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the bulk create app k v secrets default response
func (o *BulkCreateAppKVSecretsDefault) Code() int {
	return o._statusCode
}

func (o *BulkCreateAppKVSecretsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secret/kv:batch][%d] BulkCreateAppKVSecrets default %s", o._statusCode, payload)
}

func (o *BulkCreateAppKVSecretsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secret/kv:batch][%d] BulkCreateAppKVSecrets default %s", o._statusCode, payload)
}

func (o *BulkCreateAppKVSecretsDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *BulkCreateAppKVSecretsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
