// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// CreateAppKVSecretReader is a Reader for the CreateAppKVSecret structure.
type CreateAppKVSecretReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateAppKVSecretReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateAppKVSecretOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCreateAppKVSecretDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreateAppKVSecretOK creates a CreateAppKVSecretOK with default headers values
func NewCreateAppKVSecretOK() *CreateAppKVSecretOK {
	return &CreateAppKVSecretOK{}
}

/*
CreateAppKVSecretOK describes a response with status code 200, with default header values.

A successful response.
*/
type CreateAppKVSecretOK struct {
	Payload *models.Secrets20231128CreateAppKVSecretResponse
}

// IsSuccess returns true when this create app k v secret o k response has a 2xx status code
func (o *CreateAppKVSecretOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create app k v secret o k response has a 3xx status code
func (o *CreateAppKVSecretOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create app k v secret o k response has a 4xx status code
func (o *CreateAppKVSecretOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create app k v secret o k response has a 5xx status code
func (o *CreateAppKVSecretOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create app k v secret o k response a status code equal to that given
func (o *CreateAppKVSecretOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create app k v secret o k response
func (o *CreateAppKVSecretOK) Code() int {
	return 200
}

func (o *CreateAppKVSecretOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secret/kv][%d] createAppKVSecretOK %s", 200, payload)
}

func (o *CreateAppKVSecretOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secret/kv][%d] createAppKVSecretOK %s", 200, payload)
}

func (o *CreateAppKVSecretOK) GetPayload() *models.Secrets20231128CreateAppKVSecretResponse {
	return o.Payload
}

func (o *CreateAppKVSecretOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128CreateAppKVSecretResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateAppKVSecretDefault creates a CreateAppKVSecretDefault with default headers values
func NewCreateAppKVSecretDefault(code int) *CreateAppKVSecretDefault {
	return &CreateAppKVSecretDefault{
		_statusCode: code,
	}
}

/*
CreateAppKVSecretDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type CreateAppKVSecretDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this create app k v secret default response has a 2xx status code
func (o *CreateAppKVSecretDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this create app k v secret default response has a 3xx status code
func (o *CreateAppKVSecretDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this create app k v secret default response has a 4xx status code
func (o *CreateAppKVSecretDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this create app k v secret default response has a 5xx status code
func (o *CreateAppKVSecretDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this create app k v secret default response a status code equal to that given
func (o *CreateAppKVSecretDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the create app k v secret default response
func (o *CreateAppKVSecretDefault) Code() int {
	return o._statusCode
}

func (o *CreateAppKVSecretDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secret/kv][%d] CreateAppKVSecret default %s", o._statusCode, payload)
}

func (o *CreateAppKVSecretDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secret/kv][%d] CreateAppKVSecret default %s", o._statusCode, payload)
}

func (o *CreateAppKVSecretDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *CreateAppKVSecretDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
