// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// DeleteTwilioIntegrationReader is a Reader for the DeleteTwilioIntegration structure.
type DeleteTwilioIntegrationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteTwilioIntegrationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteTwilioIntegrationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDeleteTwilioIntegrationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDeleteTwilioIntegrationOK creates a DeleteTwilioIntegrationOK with default headers values
func NewDeleteTwilioIntegrationOK() *DeleteTwilioIntegrationOK {
	return &DeleteTwilioIntegrationOK{}
}

/*
DeleteTwilioIntegrationOK describes a response with status code 200, with default header values.

A successful response.
*/
type DeleteTwilioIntegrationOK struct {
	Payload models.Secrets20231128DeleteTwilioIntegrationResponse
}

// IsSuccess returns true when this delete twilio integration o k response has a 2xx status code
func (o *DeleteTwilioIntegrationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete twilio integration o k response has a 3xx status code
func (o *DeleteTwilioIntegrationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete twilio integration o k response has a 4xx status code
func (o *DeleteTwilioIntegrationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete twilio integration o k response has a 5xx status code
func (o *DeleteTwilioIntegrationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete twilio integration o k response a status code equal to that given
func (o *DeleteTwilioIntegrationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete twilio integration o k response
func (o *DeleteTwilioIntegrationOK) Code() int {
	return 200
}

func (o *DeleteTwilioIntegrationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/twilio/config/{name}][%d] deleteTwilioIntegrationOK %s", 200, payload)
}

func (o *DeleteTwilioIntegrationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/twilio/config/{name}][%d] deleteTwilioIntegrationOK %s", 200, payload)
}

func (o *DeleteTwilioIntegrationOK) GetPayload() models.Secrets20231128DeleteTwilioIntegrationResponse {
	return o.Payload
}

func (o *DeleteTwilioIntegrationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteTwilioIntegrationDefault creates a DeleteTwilioIntegrationDefault with default headers values
func NewDeleteTwilioIntegrationDefault(code int) *DeleteTwilioIntegrationDefault {
	return &DeleteTwilioIntegrationDefault{
		_statusCode: code,
	}
}

/*
DeleteTwilioIntegrationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type DeleteTwilioIntegrationDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this delete twilio integration default response has a 2xx status code
func (o *DeleteTwilioIntegrationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this delete twilio integration default response has a 3xx status code
func (o *DeleteTwilioIntegrationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this delete twilio integration default response has a 4xx status code
func (o *DeleteTwilioIntegrationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this delete twilio integration default response has a 5xx status code
func (o *DeleteTwilioIntegrationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this delete twilio integration default response a status code equal to that given
func (o *DeleteTwilioIntegrationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the delete twilio integration default response
func (o *DeleteTwilioIntegrationDefault) Code() int {
	return o._statusCode
}

func (o *DeleteTwilioIntegrationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/twilio/config/{name}][%d] DeleteTwilioIntegration default %s", o._statusCode, payload)
}

func (o *DeleteTwilioIntegrationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/twilio/config/{name}][%d] DeleteTwilioIntegration default %s", o._statusCode, payload)
}

func (o *DeleteTwilioIntegrationDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *DeleteTwilioIntegrationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
