// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// GetAzureIntegrationReader is a Reader for the GetAzureIntegration structure.
type GetAzureIntegrationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAzureIntegrationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetAzureIntegrationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetAzureIntegrationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetAzureIntegrationOK creates a GetAzureIntegrationOK with default headers values
func NewGetAzureIntegrationOK() *GetAzureIntegrationOK {
	return &GetAzureIntegrationOK{}
}

/*
GetAzureIntegrationOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetAzureIntegrationOK struct {
	Payload *models.Secrets20231128GetAzureIntegrationResponse
}

// IsSuccess returns true when this get azure integration o k response has a 2xx status code
func (o *GetAzureIntegrationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get azure integration o k response has a 3xx status code
func (o *GetAzureIntegrationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get azure integration o k response has a 4xx status code
func (o *GetAzureIntegrationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get azure integration o k response has a 5xx status code
func (o *GetAzureIntegrationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get azure integration o k response a status code equal to that given
func (o *GetAzureIntegrationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get azure integration o k response
func (o *GetAzureIntegrationOK) Code() int {
	return 200
}

func (o *GetAzureIntegrationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/azure/config/{name}][%d] getAzureIntegrationOK %s", 200, payload)
}

func (o *GetAzureIntegrationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/azure/config/{name}][%d] getAzureIntegrationOK %s", 200, payload)
}

func (o *GetAzureIntegrationOK) GetPayload() *models.Secrets20231128GetAzureIntegrationResponse {
	return o.Payload
}

func (o *GetAzureIntegrationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128GetAzureIntegrationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAzureIntegrationDefault creates a GetAzureIntegrationDefault with default headers values
func NewGetAzureIntegrationDefault(code int) *GetAzureIntegrationDefault {
	return &GetAzureIntegrationDefault{
		_statusCode: code,
	}
}

/*
GetAzureIntegrationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetAzureIntegrationDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this get azure integration default response has a 2xx status code
func (o *GetAzureIntegrationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get azure integration default response has a 3xx status code
func (o *GetAzureIntegrationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get azure integration default response has a 4xx status code
func (o *GetAzureIntegrationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get azure integration default response has a 5xx status code
func (o *GetAzureIntegrationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get azure integration default response a status code equal to that given
func (o *GetAzureIntegrationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get azure integration default response
func (o *GetAzureIntegrationDefault) Code() int {
	return o._statusCode
}

func (o *GetAzureIntegrationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/azure/config/{name}][%d] GetAzureIntegration default %s", o._statusCode, payload)
}

func (o *GetAzureIntegrationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/azure/config/{name}][%d] GetAzureIntegration default %s", o._statusCode, payload)
}

func (o *GetAzureIntegrationDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *GetAzureIntegrationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
