// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// ListAppSecretsReader is a Reader for the ListAppSecrets structure.
type ListAppSecretsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ListAppSecretsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewListAppSecretsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewListAppSecretsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewListAppSecretsOK creates a ListAppSecretsOK with default headers values
func NewListAppSecretsOK() *ListAppSecretsOK {
	return &ListAppSecretsOK{}
}

/*
ListAppSecretsOK describes a response with status code 200, with default header values.

A successful response.
*/
type ListAppSecretsOK struct {
	Payload *models.Secrets20231128ListAppSecretsResponse
}

// IsSuccess returns true when this list app secrets o k response has a 2xx status code
func (o *ListAppSecretsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this list app secrets o k response has a 3xx status code
func (o *ListAppSecretsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this list app secrets o k response has a 4xx status code
func (o *ListAppSecretsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this list app secrets o k response has a 5xx status code
func (o *ListAppSecretsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this list app secrets o k response a status code equal to that given
func (o *ListAppSecretsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the list app secrets o k response
func (o *ListAppSecretsOK) Code() int {
	return 200
}

func (o *ListAppSecretsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets][%d] listAppSecretsOK %s", 200, payload)
}

func (o *ListAppSecretsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets][%d] listAppSecretsOK %s", 200, payload)
}

func (o *ListAppSecretsOK) GetPayload() *models.Secrets20231128ListAppSecretsResponse {
	return o.Payload
}

func (o *ListAppSecretsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128ListAppSecretsResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewListAppSecretsDefault creates a ListAppSecretsDefault with default headers values
func NewListAppSecretsDefault(code int) *ListAppSecretsDefault {
	return &ListAppSecretsDefault{
		_statusCode: code,
	}
}

/*
ListAppSecretsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ListAppSecretsDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this list app secrets default response has a 2xx status code
func (o *ListAppSecretsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this list app secrets default response has a 3xx status code
func (o *ListAppSecretsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this list app secrets default response has a 4xx status code
func (o *ListAppSecretsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this list app secrets default response has a 5xx status code
func (o *ListAppSecretsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this list app secrets default response a status code equal to that given
func (o *ListAppSecretsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the list app secrets default response
func (o *ListAppSecretsDefault) Code() int {
	return o._statusCode
}

func (o *ListAppSecretsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets][%d] ListAppSecrets default %s", o._statusCode, payload)
}

func (o *ListAppSecretsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets][%d] ListAppSecrets default %s", o._statusCode, payload)
}

func (o *ListAppSecretsDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *ListAppSecretsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
