// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewRotateSecretParams creates a new RotateSecretParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRotateSecretParams() *RotateSecretParams {
	return &RotateSecretParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRotateSecretParamsWithTimeout creates a new RotateSecretParams object
// with the ability to set a timeout on a request.
func NewRotateSecretParamsWithTimeout(timeout time.Duration) *RotateSecretParams {
	return &RotateSecretParams{
		timeout: timeout,
	}
}

// NewRotateSecretParamsWithContext creates a new RotateSecretParams object
// with the ability to set a context for a request.
func NewRotateSecretParamsWithContext(ctx context.Context) *RotateSecretParams {
	return &RotateSecretParams{
		Context: ctx,
	}
}

// NewRotateSecretParamsWithHTTPClient creates a new RotateSecretParams object
// with the ability to set a custom HTTPClient for a request.
func NewRotateSecretParamsWithHTTPClient(client *http.Client) *RotateSecretParams {
	return &RotateSecretParams{
		HTTPClient: client,
	}
}

/*
RotateSecretParams contains all the parameters to send to the API endpoint

	for the rotate secret operation.

	Typically these are written to a http.Request.
*/
type RotateSecretParams struct {

	// AppName.
	AppName string

	// Body.
	Body models.SecretServiceRotateSecretBody

	// Name.
	Name string

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the rotate secret params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RotateSecretParams) WithDefaults() *RotateSecretParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the rotate secret params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RotateSecretParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the rotate secret params
func (o *RotateSecretParams) WithTimeout(timeout time.Duration) *RotateSecretParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the rotate secret params
func (o *RotateSecretParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the rotate secret params
func (o *RotateSecretParams) WithContext(ctx context.Context) *RotateSecretParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the rotate secret params
func (o *RotateSecretParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the rotate secret params
func (o *RotateSecretParams) WithHTTPClient(client *http.Client) *RotateSecretParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the rotate secret params
func (o *RotateSecretParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAppName adds the appName to the rotate secret params
func (o *RotateSecretParams) WithAppName(appName string) *RotateSecretParams {
	o.SetAppName(appName)
	return o
}

// SetAppName adds the appName to the rotate secret params
func (o *RotateSecretParams) SetAppName(appName string) {
	o.AppName = appName
}

// WithBody adds the body to the rotate secret params
func (o *RotateSecretParams) WithBody(body models.SecretServiceRotateSecretBody) *RotateSecretParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the rotate secret params
func (o *RotateSecretParams) SetBody(body models.SecretServiceRotateSecretBody) {
	o.Body = body
}

// WithName adds the name to the rotate secret params
func (o *RotateSecretParams) WithName(name string) *RotateSecretParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the rotate secret params
func (o *RotateSecretParams) SetName(name string) {
	o.Name = name
}

// WithOrganizationID adds the organizationID to the rotate secret params
func (o *RotateSecretParams) WithOrganizationID(organizationID string) *RotateSecretParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the rotate secret params
func (o *RotateSecretParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the rotate secret params
func (o *RotateSecretParams) WithProjectID(projectID string) *RotateSecretParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the rotate secret params
func (o *RotateSecretParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *RotateSecretParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param app_name
	if err := r.SetPathParam("app_name", o.AppName); err != nil {
		return err
	}
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
