// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewUpdateGatewayPoolParams creates a new UpdateGatewayPoolParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateGatewayPoolParams() *UpdateGatewayPoolParams {
	return &UpdateGatewayPoolParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateGatewayPoolParamsWithTimeout creates a new UpdateGatewayPoolParams object
// with the ability to set a timeout on a request.
func NewUpdateGatewayPoolParamsWithTimeout(timeout time.Duration) *UpdateGatewayPoolParams {
	return &UpdateGatewayPoolParams{
		timeout: timeout,
	}
}

// NewUpdateGatewayPoolParamsWithContext creates a new UpdateGatewayPoolParams object
// with the ability to set a context for a request.
func NewUpdateGatewayPoolParamsWithContext(ctx context.Context) *UpdateGatewayPoolParams {
	return &UpdateGatewayPoolParams{
		Context: ctx,
	}
}

// NewUpdateGatewayPoolParamsWithHTTPClient creates a new UpdateGatewayPoolParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateGatewayPoolParamsWithHTTPClient(client *http.Client) *UpdateGatewayPoolParams {
	return &UpdateGatewayPoolParams{
		HTTPClient: client,
	}
}

/*
UpdateGatewayPoolParams contains all the parameters to send to the API endpoint

	for the update gateway pool operation.

	Typically these are written to a http.Request.
*/
type UpdateGatewayPoolParams struct {

	// Body.
	Body *models.SecretServiceUpdateGatewayPoolBody

	// GatewayPoolName.
	GatewayPoolName string

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update gateway pool params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateGatewayPoolParams) WithDefaults() *UpdateGatewayPoolParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update gateway pool params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateGatewayPoolParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update gateway pool params
func (o *UpdateGatewayPoolParams) WithTimeout(timeout time.Duration) *UpdateGatewayPoolParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update gateway pool params
func (o *UpdateGatewayPoolParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update gateway pool params
func (o *UpdateGatewayPoolParams) WithContext(ctx context.Context) *UpdateGatewayPoolParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update gateway pool params
func (o *UpdateGatewayPoolParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update gateway pool params
func (o *UpdateGatewayPoolParams) WithHTTPClient(client *http.Client) *UpdateGatewayPoolParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update gateway pool params
func (o *UpdateGatewayPoolParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the update gateway pool params
func (o *UpdateGatewayPoolParams) WithBody(body *models.SecretServiceUpdateGatewayPoolBody) *UpdateGatewayPoolParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update gateway pool params
func (o *UpdateGatewayPoolParams) SetBody(body *models.SecretServiceUpdateGatewayPoolBody) {
	o.Body = body
}

// WithGatewayPoolName adds the gatewayPoolName to the update gateway pool params
func (o *UpdateGatewayPoolParams) WithGatewayPoolName(gatewayPoolName string) *UpdateGatewayPoolParams {
	o.SetGatewayPoolName(gatewayPoolName)
	return o
}

// SetGatewayPoolName adds the gatewayPoolName to the update gateway pool params
func (o *UpdateGatewayPoolParams) SetGatewayPoolName(gatewayPoolName string) {
	o.GatewayPoolName = gatewayPoolName
}

// WithOrganizationID adds the organizationID to the update gateway pool params
func (o *UpdateGatewayPoolParams) WithOrganizationID(organizationID string) *UpdateGatewayPoolParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the update gateway pool params
func (o *UpdateGatewayPoolParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the update gateway pool params
func (o *UpdateGatewayPoolParams) WithProjectID(projectID string) *UpdateGatewayPoolParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the update gateway pool params
func (o *UpdateGatewayPoolParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateGatewayPoolParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param gateway_pool_name
	if err := r.SetPathParam("gateway_pool_name", o.GatewayPoolName); err != nil {
		return err
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
