// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// Secrets20231128ConfluentIntegration secrets 20231128 confluent integration
//
// swagger:model secrets_20231128ConfluentIntegration
type Secrets20231128ConfluentIntegration struct {

	// capabilities
	Capabilities []*Secrets20231128Capability `json:"capabilities"`

	// created at
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// created by id
	CreatedByID string `json:"created_by_id,omitempty"`

	// name
	Name string `json:"name,omitempty"`

	// resource id
	ResourceID string `json:"resource_id,omitempty"`

	// resource name
	ResourceName string `json:"resource_name,omitempty"`

	// static credential details
	StaticCredentialDetails *Secrets20231128ConfluentStaticCredentialsResponse `json:"static_credential_details,omitempty"`

	// updated at
	// Format: date-time
	UpdatedAt strfmt.DateTime `json:"updated_at,omitempty"`

	// updated by id
	UpdatedByID string `json:"updated_by_id,omitempty"`

	// used by
	UsedBy map[string]Secrets20231128IntegrationUsage `json:"used_by,omitempty"`
}

// Validate validates this secrets 20231128 confluent integration
func (m *Secrets20231128ConfluentIntegration) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCapabilities(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStaticCredentialDetails(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUsedBy(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Secrets20231128ConfluentIntegration) validateCapabilities(formats strfmt.Registry) error {
	if swag.IsZero(m.Capabilities) { // not required
		return nil
	}

	for i := 0; i < len(m.Capabilities); i++ {
		if swag.IsZero(m.Capabilities[i]) { // not required
			continue
		}

		if m.Capabilities[i] != nil {
			if err := m.Capabilities[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("capabilities" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("capabilities" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Secrets20231128ConfluentIntegration) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Secrets20231128ConfluentIntegration) validateStaticCredentialDetails(formats strfmt.Registry) error {
	if swag.IsZero(m.StaticCredentialDetails) { // not required
		return nil
	}

	if m.StaticCredentialDetails != nil {
		if err := m.StaticCredentialDetails.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("static_credential_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("static_credential_details")
			}
			return err
		}
	}

	return nil
}

func (m *Secrets20231128ConfluentIntegration) validateUpdatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *Secrets20231128ConfluentIntegration) validateUsedBy(formats strfmt.Registry) error {
	if swag.IsZero(m.UsedBy) { // not required
		return nil
	}

	for k := range m.UsedBy {

		if err := validate.Required("used_by"+"."+k, "body", m.UsedBy[k]); err != nil {
			return err
		}
		if val, ok := m.UsedBy[k]; ok {
			if err := val.Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("used_by" + "." + k)
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("used_by" + "." + k)
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this secrets 20231128 confluent integration based on the context it is used
func (m *Secrets20231128ConfluentIntegration) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCapabilities(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStaticCredentialDetails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateUsedBy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Secrets20231128ConfluentIntegration) contextValidateCapabilities(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Capabilities); i++ {

		if m.Capabilities[i] != nil {

			if swag.IsZero(m.Capabilities[i]) { // not required
				return nil
			}

			if err := m.Capabilities[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("capabilities" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("capabilities" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *Secrets20231128ConfluentIntegration) contextValidateStaticCredentialDetails(ctx context.Context, formats strfmt.Registry) error {

	if m.StaticCredentialDetails != nil {

		if swag.IsZero(m.StaticCredentialDetails) { // not required
			return nil
		}

		if err := m.StaticCredentialDetails.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("static_credential_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("static_credential_details")
			}
			return err
		}
	}

	return nil
}

func (m *Secrets20231128ConfluentIntegration) contextValidateUsedBy(ctx context.Context, formats strfmt.Registry) error {

	for k := range m.UsedBy {

		if val, ok := m.UsedBy[k]; ok {
			if err := val.ContextValidate(ctx, formats); err != nil {
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *Secrets20231128ConfluentIntegration) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Secrets20231128ConfluentIntegration) UnmarshalBinary(b []byte) error {
	var res Secrets20231128ConfluentIntegration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
