// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-04-20/models"
)

// NewSealParams creates a new SealParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSealParams() *SealParams {
	return &SealParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSealParamsWithTimeout creates a new SealParams object
// with the ability to set a timeout on a request.
func NewSealParamsWithTimeout(timeout time.Duration) *SealParams {
	return &SealParams{
		timeout: timeout,
	}
}

// NewSealParamsWithContext creates a new SealParams object
// with the ability to set a context for a request.
func NewSealParamsWithContext(ctx context.Context) *SealParams {
	return &SealParams{
		Context: ctx,
	}
}

// NewSealParamsWithHTTPClient creates a new SealParams object
// with the ability to set a custom HTTPClient for a request.
func NewSealParamsWithHTTPClient(client *http.Client) *SealParams {
	return &SealParams{
		HTTPClient: client,
	}
}

/*
SealParams contains all the parameters to send to the API endpoint

	for the seal operation.

	Typically these are written to a http.Request.
*/
type SealParams struct {

	// Body.
	Body *models.HashicorpCloudVault20200420SealRequest

	// ClusterID.
	ClusterID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the seal params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SealParams) WithDefaults() *SealParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the seal params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SealParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the seal params
func (o *SealParams) WithTimeout(timeout time.Duration) *SealParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the seal params
func (o *SealParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the seal params
func (o *SealParams) WithContext(ctx context.Context) *SealParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the seal params
func (o *SealParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the seal params
func (o *SealParams) WithHTTPClient(client *http.Client) *SealParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the seal params
func (o *SealParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the seal params
func (o *SealParams) WithBody(body *models.HashicorpCloudVault20200420SealRequest) *SealParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the seal params
func (o *SealParams) SetBody(body *models.HashicorpCloudVault20200420SealRequest) {
	o.Body = body
}

// WithClusterID adds the clusterID to the seal params
func (o *SealParams) WithClusterID(clusterID string) *SealParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the seal params
func (o *SealParams) SetClusterID(clusterID string) {
	o.ClusterID = clusterID
}

// WithLocationOrganizationID adds the locationOrganizationID to the seal params
func (o *SealParams) WithLocationOrganizationID(locationOrganizationID string) *SealParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the seal params
func (o *SealParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the seal params
func (o *SealParams) WithLocationProjectID(locationProjectID string) *SealParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the seal params
func (o *SealParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *SealParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
