// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/validate"
)

// HashicorpCloudVault20200420ClusterState State is the state of the Vault cluster. Note that this state
// represents the abstract Vault cluster itself, not necessarily whether
// Vault cluster is currently available or not.
//
//   - UNSET: UNSET is a sentinel zero value so that an uninitialized value can be
//
// detected.
//   - PENDING: PENDING is the state the cluster is in while it is waiting to be created.
//   - CREATING: CREATING is the state the cluster is in while it is being provisioned for
//
// the first time.
//   - RUNNING: RUNNING is the steady state while the cluster is running.
//   - FAILED: FAILED is a failure state in which the cluster is unavailable and may
//
// required an operator restore action to recover.
//   - UPDATING: UPDATING is the state the cluster is in while undergoing a version
//
// update.
//   - RESTORING: RESTORING is the state the cluster is in while restoring from a snapshot.
//   - DELETING: DELETING is the state the cluster is in while it is being de-provisioned.
//   - DELETED: DELETED is the state the cluster is in when it has been de-provisioned. At
//
// this point, the cluster is eligible for garbage collection.
//   - SEALING: SEALING is the state the cluster is in when it is about to get sealed.
//   - SEALED: SEALED is the state the cluster is in while a cluster is sealed.
//   - UNSEALING: UNSEALING is the state the cluster is in when it is about to get unsealed.
//
// swagger:model hashicorp.cloud.vault_20200420.Cluster.State
type HashicorpCloudVault20200420ClusterState string

func NewHashicorpCloudVault20200420ClusterState(value HashicorpCloudVault20200420ClusterState) *HashicorpCloudVault20200420ClusterState {
	return &value
}

// Pointer returns a pointer to a freshly-allocated HashicorpCloudVault20200420ClusterState.
func (m HashicorpCloudVault20200420ClusterState) Pointer() *HashicorpCloudVault20200420ClusterState {
	return &m
}

const (

	// HashicorpCloudVault20200420ClusterStateUNSET captures enum value "UNSET"
	HashicorpCloudVault20200420ClusterStateUNSET HashicorpCloudVault20200420ClusterState = "UNSET"

	// HashicorpCloudVault20200420ClusterStatePENDING captures enum value "PENDING"
	HashicorpCloudVault20200420ClusterStatePENDING HashicorpCloudVault20200420ClusterState = "PENDING"

	// HashicorpCloudVault20200420ClusterStateCREATING captures enum value "CREATING"
	HashicorpCloudVault20200420ClusterStateCREATING HashicorpCloudVault20200420ClusterState = "CREATING"

	// HashicorpCloudVault20200420ClusterStateRUNNING captures enum value "RUNNING"
	HashicorpCloudVault20200420ClusterStateRUNNING HashicorpCloudVault20200420ClusterState = "RUNNING"

	// HashicorpCloudVault20200420ClusterStateFAILED captures enum value "FAILED"
	HashicorpCloudVault20200420ClusterStateFAILED HashicorpCloudVault20200420ClusterState = "FAILED"

	// HashicorpCloudVault20200420ClusterStateUPDATING captures enum value "UPDATING"
	HashicorpCloudVault20200420ClusterStateUPDATING HashicorpCloudVault20200420ClusterState = "UPDATING"

	// HashicorpCloudVault20200420ClusterStateRESTORING captures enum value "RESTORING"
	HashicorpCloudVault20200420ClusterStateRESTORING HashicorpCloudVault20200420ClusterState = "RESTORING"

	// HashicorpCloudVault20200420ClusterStateDELETING captures enum value "DELETING"
	HashicorpCloudVault20200420ClusterStateDELETING HashicorpCloudVault20200420ClusterState = "DELETING"

	// HashicorpCloudVault20200420ClusterStateDELETED captures enum value "DELETED"
	HashicorpCloudVault20200420ClusterStateDELETED HashicorpCloudVault20200420ClusterState = "DELETED"

	// HashicorpCloudVault20200420ClusterStateSEALING captures enum value "SEALING"
	HashicorpCloudVault20200420ClusterStateSEALING HashicorpCloudVault20200420ClusterState = "SEALING"

	// HashicorpCloudVault20200420ClusterStateSEALED captures enum value "SEALED"
	HashicorpCloudVault20200420ClusterStateSEALED HashicorpCloudVault20200420ClusterState = "SEALED"

	// HashicorpCloudVault20200420ClusterStateUNSEALING captures enum value "UNSEALING"
	HashicorpCloudVault20200420ClusterStateUNSEALING HashicorpCloudVault20200420ClusterState = "UNSEALING"
)

// for schema
var hashicorpCloudVault20200420ClusterStateEnum []interface{}

func init() {
	var res []HashicorpCloudVault20200420ClusterState
	if err := json.Unmarshal([]byte(`["UNSET","PENDING","CREATING","RUNNING","FAILED","UPDATING","RESTORING","DELETING","DELETED","SEALING","SEALED","UNSEALING"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		hashicorpCloudVault20200420ClusterStateEnum = append(hashicorpCloudVault20200420ClusterStateEnum, v)
	}
}

func (m HashicorpCloudVault20200420ClusterState) validateHashicorpCloudVault20200420ClusterStateEnum(path, location string, value HashicorpCloudVault20200420ClusterState) error {
	if err := validate.EnumCase(path, location, value, hashicorpCloudVault20200420ClusterStateEnum, true); err != nil {
		return err
	}
	return nil
}

// Validate validates this hashicorp cloud vault 20200420 cluster state
func (m HashicorpCloudVault20200420ClusterState) Validate(formats strfmt.Registry) error {
	var res []error

	// value enum
	if err := m.validateHashicorpCloudVault20200420ClusterStateEnum("", "body", m); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// ContextValidate validates this hashicorp cloud vault 20200420 cluster state based on context it is used
func (m HashicorpCloudVault20200420ClusterState) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}
