// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// NewWaypointServiceStartingActionParams creates a new WaypointServiceStartingActionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceStartingActionParams() *WaypointServiceStartingActionParams {
	return &WaypointServiceStartingActionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceStartingActionParamsWithTimeout creates a new WaypointServiceStartingActionParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceStartingActionParamsWithTimeout(timeout time.Duration) *WaypointServiceStartingActionParams {
	return &WaypointServiceStartingActionParams{
		timeout: timeout,
	}
}

// NewWaypointServiceStartingActionParamsWithContext creates a new WaypointServiceStartingActionParams object
// with the ability to set a context for a request.
func NewWaypointServiceStartingActionParamsWithContext(ctx context.Context) *WaypointServiceStartingActionParams {
	return &WaypointServiceStartingActionParams{
		Context: ctx,
	}
}

// NewWaypointServiceStartingActionParamsWithHTTPClient creates a new WaypointServiceStartingActionParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceStartingActionParamsWithHTTPClient(client *http.Client) *WaypointServiceStartingActionParams {
	return &WaypointServiceStartingActionParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceStartingActionParams contains all the parameters to send to the API endpoint

	for the waypoint service starting action operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceStartingActionParams struct {

	// Body.
	Body *models.HashicorpCloudWaypointWaypointServiceStartingActionBody

	// NamespaceID.
	NamespaceID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service starting action params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceStartingActionParams) WithDefaults() *WaypointServiceStartingActionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service starting action params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceStartingActionParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service starting action params
func (o *WaypointServiceStartingActionParams) WithTimeout(timeout time.Duration) *WaypointServiceStartingActionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service starting action params
func (o *WaypointServiceStartingActionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service starting action params
func (o *WaypointServiceStartingActionParams) WithContext(ctx context.Context) *WaypointServiceStartingActionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service starting action params
func (o *WaypointServiceStartingActionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service starting action params
func (o *WaypointServiceStartingActionParams) WithHTTPClient(client *http.Client) *WaypointServiceStartingActionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service starting action params
func (o *WaypointServiceStartingActionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the waypoint service starting action params
func (o *WaypointServiceStartingActionParams) WithBody(body *models.HashicorpCloudWaypointWaypointServiceStartingActionBody) *WaypointServiceStartingActionParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the waypoint service starting action params
func (o *WaypointServiceStartingActionParams) SetBody(body *models.HashicorpCloudWaypointWaypointServiceStartingActionBody) {
	o.Body = body
}

// WithNamespaceID adds the namespaceID to the waypoint service starting action params
func (o *WaypointServiceStartingActionParams) WithNamespaceID(namespaceID string) *WaypointServiceStartingActionParams {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service starting action params
func (o *WaypointServiceStartingActionParams) SetNamespaceID(namespaceID string) {
	o.NamespaceID = namespaceID
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceStartingActionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param namespace.id
	if err := r.SetPathParam("namespace.id", o.NamespaceID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
