// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// WaypointServiceDeleteAgentGroupReader is a Reader for the WaypointServiceDeleteAgentGroup structure.
type WaypointServiceDeleteAgentGroupReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceDeleteAgentGroupReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceDeleteAgentGroupOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceDeleteAgentGroupDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceDeleteAgentGroupOK creates a WaypointServiceDeleteAgentGroupOK with default headers values
func NewWaypointServiceDeleteAgentGroupOK() *WaypointServiceDeleteAgentGroupOK {
	return &WaypointServiceDeleteAgentGroupOK{}
}

/*
WaypointServiceDeleteAgentGroupOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceDeleteAgentGroupOK struct {
	Payload models.HashicorpCloudWaypointDeleteAgentGroupResponse
}

// IsSuccess returns true when this waypoint service delete agent group o k response has a 2xx status code
func (o *WaypointServiceDeleteAgentGroupOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service delete agent group o k response has a 3xx status code
func (o *WaypointServiceDeleteAgentGroupOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service delete agent group o k response has a 4xx status code
func (o *WaypointServiceDeleteAgentGroupOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service delete agent group o k response has a 5xx status code
func (o *WaypointServiceDeleteAgentGroupOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service delete agent group o k response a status code equal to that given
func (o *WaypointServiceDeleteAgentGroupOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service delete agent group o k response
func (o *WaypointServiceDeleteAgentGroupOK) Code() int {
	return 200
}

func (o *WaypointServiceDeleteAgentGroupOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/agent/group/{name}][%d] waypointServiceDeleteAgentGroupOK %s", 200, payload)
}

func (o *WaypointServiceDeleteAgentGroupOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/agent/group/{name}][%d] waypointServiceDeleteAgentGroupOK %s", 200, payload)
}

func (o *WaypointServiceDeleteAgentGroupOK) GetPayload() models.HashicorpCloudWaypointDeleteAgentGroupResponse {
	return o.Payload
}

func (o *WaypointServiceDeleteAgentGroupOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceDeleteAgentGroupDefault creates a WaypointServiceDeleteAgentGroupDefault with default headers values
func NewWaypointServiceDeleteAgentGroupDefault(code int) *WaypointServiceDeleteAgentGroupDefault {
	return &WaypointServiceDeleteAgentGroupDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceDeleteAgentGroupDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceDeleteAgentGroupDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service delete agent group default response has a 2xx status code
func (o *WaypointServiceDeleteAgentGroupDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service delete agent group default response has a 3xx status code
func (o *WaypointServiceDeleteAgentGroupDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service delete agent group default response has a 4xx status code
func (o *WaypointServiceDeleteAgentGroupDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service delete agent group default response has a 5xx status code
func (o *WaypointServiceDeleteAgentGroupDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service delete agent group default response a status code equal to that given
func (o *WaypointServiceDeleteAgentGroupDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service delete agent group default response
func (o *WaypointServiceDeleteAgentGroupDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceDeleteAgentGroupDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/agent/group/{name}][%d] WaypointService_DeleteAgentGroup default %s", o._statusCode, payload)
}

func (o *WaypointServiceDeleteAgentGroupDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/agent/group/{name}][%d] WaypointService_DeleteAgentGroup default %s", o._statusCode, payload)
}

func (o *WaypointServiceDeleteAgentGroupDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceDeleteAgentGroupDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
