// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewWaypointServiceListActionRuns2Params creates a new WaypointServiceListActionRuns2Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceListActionRuns2Params() *WaypointServiceListActionRuns2Params {
	return &WaypointServiceListActionRuns2Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceListActionRuns2ParamsWithTimeout creates a new WaypointServiceListActionRuns2Params object
// with the ability to set a timeout on a request.
func NewWaypointServiceListActionRuns2ParamsWithTimeout(timeout time.Duration) *WaypointServiceListActionRuns2Params {
	return &WaypointServiceListActionRuns2Params{
		timeout: timeout,
	}
}

// NewWaypointServiceListActionRuns2ParamsWithContext creates a new WaypointServiceListActionRuns2Params object
// with the ability to set a context for a request.
func NewWaypointServiceListActionRuns2ParamsWithContext(ctx context.Context) *WaypointServiceListActionRuns2Params {
	return &WaypointServiceListActionRuns2Params{
		Context: ctx,
	}
}

// NewWaypointServiceListActionRuns2ParamsWithHTTPClient creates a new WaypointServiceListActionRuns2Params object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceListActionRuns2ParamsWithHTTPClient(client *http.Client) *WaypointServiceListActionRuns2Params {
	return &WaypointServiceListActionRuns2Params{
		HTTPClient: client,
	}
}

/*
WaypointServiceListActionRuns2Params contains all the parameters to send to the API endpoint

	for the waypoint service list action runs2 operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceListActionRuns2Params struct {

	/* ActionID.

	   The id of the action config being listed
	*/
	ActionID *string

	/* ActionName.

	   The name of the action being listed (will only be used if id not provided)
	*/
	ActionName string

	// NamespaceID.
	NamespaceID *string

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID string

	/* NamespaceLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	NamespaceLocationRegionProvider *string

	/* NamespaceLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	NamespaceLocationRegionRegion *string

	/* PaginationNextPageToken.

	     Specifies a page token to use to retrieve the next page. Set this to the
	`next_page_token` returned by previous list requests to get the next page of
	results. If set, `previous_page_token` must not be set.
	*/
	PaginationNextPageToken *string

	/* PaginationPageSize.

	     The max number of results per page that should be returned. If the number
	of available results is larger than `page_size`, a `next_page_token` is
	returned which can be used to get the next page of results in subsequent
	requests. A value of zero will cause `page_size` to be defaulted.

	     Format: int64
	*/
	PaginationPageSize *int64

	/* PaginationPreviousPageToken.

	     Specifies a page token to use to retrieve the previous page. Set this to
	the `previous_page_token` returned by previous list requests to get the
	previous page of results. If set, `next_page_token` must not be set.
	*/
	PaginationPreviousPageToken *string

	// ScopeApplicationID.
	ScopeApplicationID *string

	// ScopeApplicationName.
	ScopeApplicationName *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service list action runs2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceListActionRuns2Params) WithDefaults() *WaypointServiceListActionRuns2Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service list action runs2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceListActionRuns2Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) WithTimeout(timeout time.Duration) *WaypointServiceListActionRuns2Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) WithContext(ctx context.Context) *WaypointServiceListActionRuns2Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) WithHTTPClient(client *http.Client) *WaypointServiceListActionRuns2Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithActionID adds the actionID to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) WithActionID(actionID *string) *WaypointServiceListActionRuns2Params {
	o.SetActionID(actionID)
	return o
}

// SetActionID adds the actionId to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) SetActionID(actionID *string) {
	o.ActionID = actionID
}

// WithActionName adds the actionName to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) WithActionName(actionName string) *WaypointServiceListActionRuns2Params {
	o.SetActionName(actionName)
	return o
}

// SetActionName adds the actionName to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) SetActionName(actionName string) {
	o.ActionName = actionName
}

// WithNamespaceID adds the namespaceID to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) WithNamespaceID(namespaceID *string) *WaypointServiceListActionRuns2Params {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) SetNamespaceID(namespaceID *string) {
	o.NamespaceID = namespaceID
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) *WaypointServiceListActionRuns2Params {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) WithNamespaceLocationProjectID(namespaceLocationProjectID string) *WaypointServiceListActionRuns2Params {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) SetNamespaceLocationProjectID(namespaceLocationProjectID string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WithNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) WithNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) *WaypointServiceListActionRuns2Params {
	o.SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider)
	return o
}

// SetNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) {
	o.NamespaceLocationRegionProvider = namespaceLocationRegionProvider
}

// WithNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) WithNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) *WaypointServiceListActionRuns2Params {
	o.SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion)
	return o
}

// SetNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) {
	o.NamespaceLocationRegionRegion = namespaceLocationRegionRegion
}

// WithPaginationNextPageToken adds the paginationNextPageToken to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) WithPaginationNextPageToken(paginationNextPageToken *string) *WaypointServiceListActionRuns2Params {
	o.SetPaginationNextPageToken(paginationNextPageToken)
	return o
}

// SetPaginationNextPageToken adds the paginationNextPageToken to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) SetPaginationNextPageToken(paginationNextPageToken *string) {
	o.PaginationNextPageToken = paginationNextPageToken
}

// WithPaginationPageSize adds the paginationPageSize to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) WithPaginationPageSize(paginationPageSize *int64) *WaypointServiceListActionRuns2Params {
	o.SetPaginationPageSize(paginationPageSize)
	return o
}

// SetPaginationPageSize adds the paginationPageSize to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) SetPaginationPageSize(paginationPageSize *int64) {
	o.PaginationPageSize = paginationPageSize
}

// WithPaginationPreviousPageToken adds the paginationPreviousPageToken to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) WithPaginationPreviousPageToken(paginationPreviousPageToken *string) *WaypointServiceListActionRuns2Params {
	o.SetPaginationPreviousPageToken(paginationPreviousPageToken)
	return o
}

// SetPaginationPreviousPageToken adds the paginationPreviousPageToken to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) SetPaginationPreviousPageToken(paginationPreviousPageToken *string) {
	o.PaginationPreviousPageToken = paginationPreviousPageToken
}

// WithScopeApplicationID adds the scopeApplicationID to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) WithScopeApplicationID(scopeApplicationID *string) *WaypointServiceListActionRuns2Params {
	o.SetScopeApplicationID(scopeApplicationID)
	return o
}

// SetScopeApplicationID adds the scopeApplicationId to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) SetScopeApplicationID(scopeApplicationID *string) {
	o.ScopeApplicationID = scopeApplicationID
}

// WithScopeApplicationName adds the scopeApplicationName to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) WithScopeApplicationName(scopeApplicationName *string) *WaypointServiceListActionRuns2Params {
	o.SetScopeApplicationName(scopeApplicationName)
	return o
}

// SetScopeApplicationName adds the scopeApplicationName to the waypoint service list action runs2 params
func (o *WaypointServiceListActionRuns2Params) SetScopeApplicationName(scopeApplicationName *string) {
	o.ScopeApplicationName = scopeApplicationName
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceListActionRuns2Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ActionID != nil {

		// query param action_id
		var qrActionID string

		if o.ActionID != nil {
			qrActionID = *o.ActionID
		}
		qActionID := qrActionID
		if qActionID != "" {

			if err := r.SetQueryParam("action_id", qActionID); err != nil {
				return err
			}
		}
	}

	// path param action_name
	if err := r.SetPathParam("action_name", o.ActionName); err != nil {
		return err
	}

	if o.NamespaceID != nil {

		// query param namespace.id
		var qrNamespaceID string

		if o.NamespaceID != nil {
			qrNamespaceID = *o.NamespaceID
		}
		qNamespaceID := qrNamespaceID
		if qNamespaceID != "" {

			if err := r.SetQueryParam("namespace.id", qNamespaceID); err != nil {
				return err
			}
		}
	}

	// path param namespace.location.organization_id
	if err := r.SetPathParam("namespace.location.organization_id", o.NamespaceLocationOrganizationID); err != nil {
		return err
	}

	// path param namespace.location.project_id
	if err := r.SetPathParam("namespace.location.project_id", o.NamespaceLocationProjectID); err != nil {
		return err
	}

	if o.NamespaceLocationRegionProvider != nil {

		// query param namespace.location.region.provider
		var qrNamespaceLocationRegionProvider string

		if o.NamespaceLocationRegionProvider != nil {
			qrNamespaceLocationRegionProvider = *o.NamespaceLocationRegionProvider
		}
		qNamespaceLocationRegionProvider := qrNamespaceLocationRegionProvider
		if qNamespaceLocationRegionProvider != "" {

			if err := r.SetQueryParam("namespace.location.region.provider", qNamespaceLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionRegion != nil {

		// query param namespace.location.region.region
		var qrNamespaceLocationRegionRegion string

		if o.NamespaceLocationRegionRegion != nil {
			qrNamespaceLocationRegionRegion = *o.NamespaceLocationRegionRegion
		}
		qNamespaceLocationRegionRegion := qrNamespaceLocationRegionRegion
		if qNamespaceLocationRegionRegion != "" {

			if err := r.SetQueryParam("namespace.location.region.region", qNamespaceLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if o.PaginationNextPageToken != nil {

		// query param pagination.next_page_token
		var qrPaginationNextPageToken string

		if o.PaginationNextPageToken != nil {
			qrPaginationNextPageToken = *o.PaginationNextPageToken
		}
		qPaginationNextPageToken := qrPaginationNextPageToken
		if qPaginationNextPageToken != "" {

			if err := r.SetQueryParam("pagination.next_page_token", qPaginationNextPageToken); err != nil {
				return err
			}
		}
	}

	if o.PaginationPageSize != nil {

		// query param pagination.page_size
		var qrPaginationPageSize int64

		if o.PaginationPageSize != nil {
			qrPaginationPageSize = *o.PaginationPageSize
		}
		qPaginationPageSize := swag.FormatInt64(qrPaginationPageSize)
		if qPaginationPageSize != "" {

			if err := r.SetQueryParam("pagination.page_size", qPaginationPageSize); err != nil {
				return err
			}
		}
	}

	if o.PaginationPreviousPageToken != nil {

		// query param pagination.previous_page_token
		var qrPaginationPreviousPageToken string

		if o.PaginationPreviousPageToken != nil {
			qrPaginationPreviousPageToken = *o.PaginationPreviousPageToken
		}
		qPaginationPreviousPageToken := qrPaginationPreviousPageToken
		if qPaginationPreviousPageToken != "" {

			if err := r.SetQueryParam("pagination.previous_page_token", qPaginationPreviousPageToken); err != nil {
				return err
			}
		}
	}

	if o.ScopeApplicationID != nil {

		// query param scope.application.id
		var qrScopeApplicationID string

		if o.ScopeApplicationID != nil {
			qrScopeApplicationID = *o.ScopeApplicationID
		}
		qScopeApplicationID := qrScopeApplicationID
		if qScopeApplicationID != "" {

			if err := r.SetQueryParam("scope.application.id", qScopeApplicationID); err != nil {
				return err
			}
		}
	}

	if o.ScopeApplicationName != nil {

		// query param scope.application.name
		var qrScopeApplicationName string

		if o.ScopeApplicationName != nil {
			qrScopeApplicationName = *o.ScopeApplicationName
		}
		qScopeApplicationName := qrScopeApplicationName
		if qScopeApplicationName != "" {

			if err := r.SetQueryParam("scope.application.name", qScopeApplicationName); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
