// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointServiceListNoCodeModules2Params creates a new WaypointServiceListNoCodeModules2Params object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceListNoCodeModules2Params() *WaypointServiceListNoCodeModules2Params {
	return &WaypointServiceListNoCodeModules2Params{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceListNoCodeModules2ParamsWithTimeout creates a new WaypointServiceListNoCodeModules2Params object
// with the ability to set a timeout on a request.
func NewWaypointServiceListNoCodeModules2ParamsWithTimeout(timeout time.Duration) *WaypointServiceListNoCodeModules2Params {
	return &WaypointServiceListNoCodeModules2Params{
		timeout: timeout,
	}
}

// NewWaypointServiceListNoCodeModules2ParamsWithContext creates a new WaypointServiceListNoCodeModules2Params object
// with the ability to set a context for a request.
func NewWaypointServiceListNoCodeModules2ParamsWithContext(ctx context.Context) *WaypointServiceListNoCodeModules2Params {
	return &WaypointServiceListNoCodeModules2Params{
		Context: ctx,
	}
}

// NewWaypointServiceListNoCodeModules2ParamsWithHTTPClient creates a new WaypointServiceListNoCodeModules2Params object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceListNoCodeModules2ParamsWithHTTPClient(client *http.Client) *WaypointServiceListNoCodeModules2Params {
	return &WaypointServiceListNoCodeModules2Params{
		HTTPClient: client,
	}
}

/*
WaypointServiceListNoCodeModules2Params contains all the parameters to send to the API endpoint

	for the waypoint service list no code modules2 operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceListNoCodeModules2Params struct {

	// NamespaceID.
	NamespaceID *string

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID string

	/* NamespaceLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	NamespaceLocationRegionProvider *string

	/* NamespaceLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	NamespaceLocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service list no code modules2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceListNoCodeModules2Params) WithDefaults() *WaypointServiceListNoCodeModules2Params {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service list no code modules2 params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceListNoCodeModules2Params) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service list no code modules2 params
func (o *WaypointServiceListNoCodeModules2Params) WithTimeout(timeout time.Duration) *WaypointServiceListNoCodeModules2Params {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service list no code modules2 params
func (o *WaypointServiceListNoCodeModules2Params) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service list no code modules2 params
func (o *WaypointServiceListNoCodeModules2Params) WithContext(ctx context.Context) *WaypointServiceListNoCodeModules2Params {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service list no code modules2 params
func (o *WaypointServiceListNoCodeModules2Params) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service list no code modules2 params
func (o *WaypointServiceListNoCodeModules2Params) WithHTTPClient(client *http.Client) *WaypointServiceListNoCodeModules2Params {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service list no code modules2 params
func (o *WaypointServiceListNoCodeModules2Params) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithNamespaceID adds the namespaceID to the waypoint service list no code modules2 params
func (o *WaypointServiceListNoCodeModules2Params) WithNamespaceID(namespaceID *string) *WaypointServiceListNoCodeModules2Params {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service list no code modules2 params
func (o *WaypointServiceListNoCodeModules2Params) SetNamespaceID(namespaceID *string) {
	o.NamespaceID = namespaceID
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service list no code modules2 params
func (o *WaypointServiceListNoCodeModules2Params) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) *WaypointServiceListNoCodeModules2Params {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service list no code modules2 params
func (o *WaypointServiceListNoCodeModules2Params) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service list no code modules2 params
func (o *WaypointServiceListNoCodeModules2Params) WithNamespaceLocationProjectID(namespaceLocationProjectID string) *WaypointServiceListNoCodeModules2Params {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service list no code modules2 params
func (o *WaypointServiceListNoCodeModules2Params) SetNamespaceLocationProjectID(namespaceLocationProjectID string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WithNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service list no code modules2 params
func (o *WaypointServiceListNoCodeModules2Params) WithNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) *WaypointServiceListNoCodeModules2Params {
	o.SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider)
	return o
}

// SetNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service list no code modules2 params
func (o *WaypointServiceListNoCodeModules2Params) SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) {
	o.NamespaceLocationRegionProvider = namespaceLocationRegionProvider
}

// WithNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service list no code modules2 params
func (o *WaypointServiceListNoCodeModules2Params) WithNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) *WaypointServiceListNoCodeModules2Params {
	o.SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion)
	return o
}

// SetNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service list no code modules2 params
func (o *WaypointServiceListNoCodeModules2Params) SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) {
	o.NamespaceLocationRegionRegion = namespaceLocationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceListNoCodeModules2Params) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.NamespaceID != nil {

		// query param namespace.id
		var qrNamespaceID string

		if o.NamespaceID != nil {
			qrNamespaceID = *o.NamespaceID
		}
		qNamespaceID := qrNamespaceID
		if qNamespaceID != "" {

			if err := r.SetQueryParam("namespace.id", qNamespaceID); err != nil {
				return err
			}
		}
	}

	// path param namespace.location.organization_id
	if err := r.SetPathParam("namespace.location.organization_id", o.NamespaceLocationOrganizationID); err != nil {
		return err
	}

	// path param namespace.location.project_id
	if err := r.SetPathParam("namespace.location.project_id", o.NamespaceLocationProjectID); err != nil {
		return err
	}

	if o.NamespaceLocationRegionProvider != nil {

		// query param namespace.location.region.provider
		var qrNamespaceLocationRegionProvider string

		if o.NamespaceLocationRegionProvider != nil {
			qrNamespaceLocationRegionProvider = *o.NamespaceLocationRegionProvider
		}
		qNamespaceLocationRegionProvider := qrNamespaceLocationRegionProvider
		if qNamespaceLocationRegionProvider != "" {

			if err := r.SetQueryParam("namespace.location.region.provider", qNamespaceLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionRegion != nil {

		// query param namespace.location.region.region
		var qrNamespaceLocationRegionRegion string

		if o.NamespaceLocationRegionRegion != nil {
			qrNamespaceLocationRegionRegion = *o.NamespaceLocationRegionRegion
		}
		qNamespaceLocationRegionRegion := qrNamespaceLocationRegionRegion
		if qNamespaceLocationRegionRegion != "" {

			if err := r.SetQueryParam("namespace.location.region.region", qNamespaceLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
