// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package operator_api

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/minio/console/models"
)

// DescribePodOKCode is the HTTP code returned for type DescribePodOK
const DescribePodOKCode int = 200

/*
DescribePodOK A successful response.

swagger:response describePodOK
*/
type DescribePodOK struct {

	/*
	  In: Body
	*/
	Payload *models.DescribePodWrapper `json:"body,omitempty"`
}

// NewDescribePodOK creates DescribePodOK with default headers values
func NewDescribePodOK() *DescribePodOK {

	return &DescribePodOK{}
}

// WithPayload adds the payload to the describe pod o k response
func (o *DescribePodOK) WithPayload(payload *models.DescribePodWrapper) *DescribePodOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the describe pod o k response
func (o *DescribePodOK) SetPayload(payload *models.DescribePodWrapper) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DescribePodOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
DescribePodDefault Generic error response.

swagger:response describePodDefault
*/
type DescribePodDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.Error `json:"body,omitempty"`
}

// NewDescribePodDefault creates DescribePodDefault with default headers values
func NewDescribePodDefault(code int) *DescribePodDefault {
	if code <= 0 {
		code = 500
	}

	return &DescribePodDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the describe pod default response
func (o *DescribePodDefault) WithStatusCode(code int) *DescribePodDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the describe pod default response
func (o *DescribePodDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the describe pod default response
func (o *DescribePodDefault) WithPayload(payload *models.Error) *DescribePodDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the describe pod default response
func (o *DescribePodDefault) SetPayload(payload *models.Error) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *DescribePodDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
