// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const AGPLV3LightLogo = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={"min-icon"}
    fill={"currentcolor"}
    {...props}
    viewBox="0 0 59.801 10.087"
  >
    <path
      d="M48.083-9.8H46.55L42.567,0h1.281l1.071-2.674h4.753L50.75,0h1.323ZM47.3-8.582l1.9,4.739H45.388ZM59.353-9.947A4.9,4.9,0,0,0,54.278-4.9,4.894,4.894,0,0,0,59.3.14c2.968,0,4.774-2.247,4.774-5.1,0-.1-.007-.2-.014-.308H59.78v1.148h2.94A3.173,3.173,0,0,1,59.3-1.036,3.673,3.673,0,0,1,55.566-4.9a3.686,3.686,0,0,1,3.787-3.864,3.723,3.723,0,0,1,2.891,1.316l.9-.875A4.969,4.969,0,0,0,59.353-9.947ZM71.428-3.92c2.212,0,3.465-1.106,3.465-2.94S73.64-9.8,71.428-9.8H67.7V0h1.232V-3.92ZM71.4-8.638c1.449,0,2.212.588,2.212,1.778S72.849-5.082,71.4-5.082H68.936V-8.638ZM85.239-1.169H79.625V-9.8H78.393V0h6.846ZM93.695-6.65H92.484l-2.24,5.5-2.233-5.5H86.765l2.8,6.657h1.344Zm5.194-3.29a3.5,3.5,0,0,0-3.045,1.484l.854.721a2.581,2.581,0,0,1,2.114-1.1c1.183,0,2.1.637,2.1,1.666,0,1.12-.924,1.68-2.093,1.68h-1.26V-4.4h1.26c1.274,0,2.31.616,2.31,1.715,0,1.169-.994,1.722-2.177,1.722a3.409,3.409,0,0,1-2.443-1.008l-.756.8A4.139,4.139,0,0,0,98.98.14c1.736,0,3.388-.9,3.388-2.779a2.417,2.417,0,0,0-1.708-2.31,2.342,2.342,0,0,0,1.484-2.275C102.144-8.841,100.835-9.94,98.889-9.94Z"
      transform="translate(-42.567 9.947)"
      fill="#bccee6"
    />
  </svg>
);

export default AGPLV3LightLogo;
