// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const ChangeAccessPolicyIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={"min-icon"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="clip-path">
        <rect
          id="Rectángulo_1045"
          data-name="Rectángulo 1045"
          width="256"
          height="230.638"
          fill="none"
        />
      </clipPath>
      <clipPath id="clip-Change_Access_Policy">
        <rect width="256" height="256" />
      </clipPath>
    </defs>
    <g
      id="Change_Access_Policy"
      data-name="Change Access Policy"
      clipPath="url(#clip-Change_Access_Policy)"
    >
      <rect width="256" height="256" fill="#fff" />
      <g id="Change_Access_Policy_Icon" data-name="Change Access Policy Icon">
        <g id="Grupo_2432" data-name="Grupo 2432" transform="translate(0 13)">
          <g id="Grupo_2431" data-name="Grupo 2431">
            <path
              id="Trazado_7195"
              data-name="Trazado 7195"
              d="M230.943,74.7A72.225,72.225,0,0,0,217.05,30.786,74.4,74.4,0,0,0,82.376,74.139a73.1,73.1,0,0,0,3.216,21.5L0,181.212v49.426H49.426l2.217-2.22L38.01,214.786l17.257-17.257L68.9,211.161l14.776-14.778L70.043,182.753,87.3,165.5l13.629,13.63L135,145.045a73.794,73.794,0,0,0,41.481.594A45.523,45.523,0,1,0,230.943,74.7m15.771,40.663a35.971,35.971,0,1,1-35.971-35.971,35.971,35.971,0,0,1,35.971,35.971M228.838,99.516A8.172,8.172,0,0,0,222.913,97a8.71,8.71,0,0,0-6,2.447l-22.22,22.245a2.041,2.041,0,0,0-.593,1.112L191.8,134a2.062,2.062,0,0,0,.593,1.928,2.246,2.246,0,0,0,1.555.593.938.938,0,0,0,.444-.074l11.11-2.152a2.036,2.036,0,0,0,1.111-.593l22.219-22.245a8.511,8.511,0,0,0,0-11.938M148.261,65.9a16.475,16.475,0,1,1,16.475,16.475A16.475,16.475,0,0,1,148.261,65.9"
              transform="translate(0 0)"
            />
          </g>
        </g>
        <rect
          id="Rectángulo_1046"
          data-name="Rectángulo 1046"
          width="256"
          height="256"
          fill="none"
        />
      </g>
    </g>
  </svg>
);

export default ChangeAccessPolicyIcon;
