// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import React, { SVGProps } from "react";

import "./loader.styles.css";

const Loader = (props: SVGProps<SVGSVGElement>) => {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 280 280"
      shapeRendering="geometricPrecision"
      textRendering="geometricPrecision"
      className={"min-loader"}
      {...props}
    >
      <g
        id="eB8dk2fHKWC2_tr"
        transform="translate(139.785027,140.086989) rotate(45.236493)"
      >
        <g id="eB8dk2fHKWC2_ts" transform="scale(1,0.995019)">
          <g id="eB8dk2fHKWC2" transform="translate(-127.784998,-128.086989)">
            <g>
              <path
                id="eB8dk2fHKWC4"
                d="M85.4,249.8c23.68,5.5,48.32,7.57,72.25,2.34c24-5.25,45.3-18.59,61.62-36.79c8.57-9.56-5.53-23.75-14.14-14.14-14.23,15.89-31.86,27.05-52.79,31.65-20.31,4.46-41.55,2.33-61.61-2.34-12.54-2.91-17.88,16.36-5.33,19.28c0,0,0,0,0,0Z"
                fill="#113053"
              />
            </g>
            <g>
              <path
                id="eB8dk2fHKWC6"
                d="M249.74,169.63c5.5-23.68,7.57-48.32,2.34-72.25-5.25-24-18.59-45.3-36.79-61.62-9.56-8.57-23.75,5.53-14.14,14.14c15.89,14.23,27.05,31.86,31.65,52.79c4.46,20.31,2.33,41.55-2.34,61.61-2.92,12.54,16.36,17.88,19.28,5.33c0,0,0,0,0,0Z"
                fill="#113053"
              />
            </g>
            <g>
              <path
                id="eB8dk2fHKWC8"
                d="M171.68,7.71c-23.51-6.2-48.07-8.99-72.15-4.46C75.39,7.79,53.7,20.49,36.85,38.21c-8.84,9.31,4.83,23.9,13.72,14.55c14.7-15.46,32.65-26.1,53.7-30.08c20.43-3.86,41.6-1.1,61.52,4.15c12.43,3.28,18.35-15.83,5.89-19.12c0,0,0,0,0,0Z"
                fill="#113053"
              />
            </g>
            <g>
              <path
                id="eB8dk2fHKWC10"
                d="M5.83,85.46c-5.5,23.68-7.57,48.32-2.34,72.25c5.25,24,18.59,45.3,36.79,61.62c9.56,8.57,23.75-5.53,14.14-14.14-15.89-14.23-27.05-31.86-31.65-52.79-4.46-20.31-2.33-41.55,2.34-61.61C28.03,78.25,8.75,72.91,5.83,85.46v0Z"
                transform="translate(.194904 0.217549)"
                fill="#113053"
              />
            </g>
          </g>
        </g>
      </g>
      <g
        id="eB8dk2fHKWC11_ts"
        transform="translate(139.784999,140.086986) scale(1,1)"
      >
        <g
          id="eB8dk2fHKWC11"
          transform="translate(-127.999996,-128.000003)"
          opacity="0"
        >
          <path
            d="M234.23,128c0-58.67-47.56-106.23-106.23-106.23s-106.23,47.56-106.23,106.23s47.56,106.23,106.23,106.23c58.64-.06,106.17-47.59,106.23-106.23m21.25,0c0,70.4-57.07,127.48-127.48,127.48s-127.48-57.08-127.48-127.48s57.08-127.48,127.48-127.48s127.48,57.08,127.48,127.48Z"
            fill="#113053"
          />
        </g>
      </g>
      <g
        id="eB8dk2fHKWC13_tr"
        transform="translate(139.785004,140.086979) rotate(0)"
      >
        <g
          id="eB8dk2fHKWC13"
          transform="translate(-127.999968,-127.995139)"
          opacity="0"
        >
          <path
            d="M128,0.47h.33c.36,0,.73,0,1.09.01h.17c5.45.09,9.79,4.57,9.73,10.02-.07,5.51-4.57,9.93-10.07,9.91h-1.24c-5.51-.04-9.96-4.51-9.96-10.02-.01-5.45,4.39-9.88,9.84-9.91h.11ZM245.62,118.39h.03c5.45.01,9.86,4.42,9.88,9.87c0,.04,0,.08,0,.12v0c0,.12,0,.24,0,.36v0c0,.01,0,.03,0,.04v.09c0,.37,0,.73-.01,1.09-.11,5.45-4.6,9.78-10.05,9.7-5.51-.08-9.92-4.6-9.88-10.1l.01-1.24c.06-5.49,4.52-9.92,10.02-9.93ZM126.01,235.58h.12l1.24.01c5.51.07,9.93,4.57,9.9,10.08-.04,5.48-4.51,9.89-9.99,9.85-.01,0-.02,0-.03,0h-.46-.19l-.82-.01h-.12c-5.45-.12-9.77-4.63-9.67-10.07.09-5.47,4.55-9.85,10.02-9.86ZM10.4,115.63h.2c5.51.12,9.89,4.65,9.82,10.16l-.02,1.24c-.09,5.5-4.59,9.91-10.1,9.88-5.45-.04-9.85-4.47-9.83-9.93c0-.04,0-.08,0-.12v0c0-.36,0-.73.01-1.09v-.09v0c0-.13,0-.27.01-.41.14-5.37,4.54-9.64,9.91-9.64Z"
            fill="#113053"
          />
        </g>
      </g>
    </svg>
  );
};

export default Loader;
