// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package bucket

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
)

// NewDeleteRemoteBucketParams creates a new DeleteRemoteBucketParams object
//
// There are no default values defined in the spec.
func NewDeleteRemoteBucketParams() DeleteRemoteBucketParams {

	return DeleteRemoteBucketParams{}
}

// DeleteRemoteBucketParams contains all the bound params for the delete remote bucket operation
// typically these are obtained from a http.Request
//
// swagger:parameters DeleteRemoteBucket
type DeleteRemoteBucketParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*
	  Required: true
	  In: path
	*/
	Arn string
	/*
	  Required: true
	  In: path
	*/
	SourceBucketName string
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewDeleteRemoteBucketParams() beforehand.
func (o *DeleteRemoteBucketParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	rArn, rhkArn, _ := route.Params.GetOK("arn")
	if err := o.bindArn(rArn, rhkArn, route.Formats); err != nil {
		res = append(res, err)
	}

	rSourceBucketName, rhkSourceBucketName, _ := route.Params.GetOK("source-bucket-name")
	if err := o.bindSourceBucketName(rSourceBucketName, rhkSourceBucketName, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindArn binds and validates parameter Arn from path.
func (o *DeleteRemoteBucketParams) bindArn(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// Parameter is provided by construction from the route
	o.Arn = raw

	return nil
}

// bindSourceBucketName binds and validates parameter SourceBucketName from path.
func (o *DeleteRemoteBucketParams) bindSourceBucketName(rawData []string, hasKey bool, formats strfmt.Registry) error {
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// Parameter is provided by construction from the route
	o.SourceBucketName = raw

	return nil
}
