// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package configuration

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/minio/console/models"
)

// ListConfigOKCode is the HTTP code returned for type ListConfigOK
const ListConfigOKCode int = 200

/*
ListConfigOK A successful response.

swagger:response listConfigOK
*/
type ListConfigOK struct {

	/*
	  In: Body
	*/
	Payload *models.ListConfigResponse `json:"body,omitempty"`
}

// NewListConfigOK creates ListConfigOK with default headers values
func NewListConfigOK() *ListConfigOK {

	return &ListConfigOK{}
}

// WithPayload adds the payload to the list config o k response
func (o *ListConfigOK) WithPayload(payload *models.ListConfigResponse) *ListConfigOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the list config o k response
func (o *ListConfigOK) SetPayload(payload *models.ListConfigResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ListConfigOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
ListConfigDefault Generic error response.

swagger:response listConfigDefault
*/
type ListConfigDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.APIError `json:"body,omitempty"`
}

// NewListConfigDefault creates ListConfigDefault with default headers values
func NewListConfigDefault(code int) *ListConfigDefault {
	if code <= 0 {
		code = 500
	}

	return &ListConfigDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the list config default response
func (o *ListConfigDefault) WithStatusCode(code int) *ListConfigDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the list config default response
func (o *ListConfigDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the list config default response
func (o *ListConfigDefault) WithPayload(payload *models.APIError) *ListConfigDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the list config default response
func (o *ListConfigDefault) SetPayload(payload *models.APIError) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *ListConfigDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
