// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// SetBucketPolicyRequest set bucket policy request
//
// swagger:model setBucketPolicyRequest
type SetBucketPolicyRequest struct {

	// access
	// Required: true
	Access *BucketAccess `json:"access"`

	// definition
	Definition string `json:"definition,omitempty"`
}

// Validate validates this set bucket policy request
func (m *SetBucketPolicyRequest) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAccess(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SetBucketPolicyRequest) validateAccess(formats strfmt.Registry) error {

	if err := validate.Required("access", "body", m.Access); err != nil {
		return err
	}

	if err := validate.Required("access", "body", m.Access); err != nil {
		return err
	}

	if m.Access != nil {
		if err := m.Access.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("access")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this set bucket policy request based on the context it is used
func (m *SetBucketPolicyRequest) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAccess(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *SetBucketPolicyRequest) contextValidateAccess(ctx context.Context, formats strfmt.Registry) error {

	if m.Access != nil {

		if err := m.Access.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("access")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("access")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *SetBucketPolicyRequest) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *SetBucketPolicyRequest) UnmarshalBinary(b []byte) error {
	var res SetBucketPolicyRequest
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
