// Copyright 2015 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package yang

import (
	"testing"
)

func TestCamelCase(t *testing.T) {
	tests := []struct {
		in, want string
	}{
		{"one", "One"},
		{"one_two", "OneTwo"},
		{"__one__two__three__four", "XOne_Two_Three_Four"},
		{"one.two.three", "OneTwoThree"},
		{"one.two.three.", "OneTwoThree_"},
		{"_my_field_name_2", "XMyFieldName_2"},
		{"Something_Capped", "Something_Capped"},
		{"_Foo-bar", "XFooBar"},
		{"my_Name", "My_Name"},
		{"OneTwo", "OneTwo"},
		{"_", "X"},
		{"_a_", "XA_"},
		{"ietf-interface", "IETFInterface"},
		{"ietf-interface-1", "IETFInterface_1"},
		{"out-unicast.pkts", "OutUnicastPkts"},
		// Invalid input conversion behaviours:
		{"one/two", "One/two"},
		{"/one/two", "/one/two"},
		{"one:two", "One:two"},
		{"::one::two", "::one::two"},
		{"one|two", "One|two"},
		{"one||two", "One||two"},
	}
	for _, tc := range tests {
		if got := CamelCase(tc.in); got != tc.want {
			t.Errorf("CamelCase(%q) = %q, want %q", tc.in, got, tc.want)
		}
	}
}
