// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"strings"
)

// HostPortScanLevelEnum Enum with underlying type: string
type HostPortScanLevelEnum string

// Set of constants representing the allowable values for HostPortScanLevelEnum
const (
	HostPortScanLevelNone     HostPortScanLevelEnum = "NONE"
	HostPortScanLevelLight    HostPortScanLevelEnum = "LIGHT"
	HostPortScanLevelStandard HostPortScanLevelEnum = "STANDARD"
)

var mappingHostPortScanLevelEnum = map[string]HostPortScanLevelEnum{
	"NONE":     HostPortScanLevelNone,
	"LIGHT":    HostPortScanLevelLight,
	"STANDARD": HostPortScanLevelStandard,
}

var mappingHostPortScanLevelEnumLowerCase = map[string]HostPortScanLevelEnum{
	"none":     HostPortScanLevelNone,
	"light":    HostPortScanLevelLight,
	"standard": HostPortScanLevelStandard,
}

// GetHostPortScanLevelEnumValues Enumerates the set of values for HostPortScanLevelEnum
func GetHostPortScanLevelEnumValues() []HostPortScanLevelEnum {
	values := make([]HostPortScanLevelEnum, 0)
	for _, v := range mappingHostPortScanLevelEnum {
		values = append(values, v)
	}
	return values
}

// GetHostPortScanLevelEnumStringValues Enumerates the set of values in String for HostPortScanLevelEnum
func GetHostPortScanLevelEnumStringValues() []string {
	return []string{
		"NONE",
		"LIGHT",
		"STANDARD",
	}
}

// GetMappingHostPortScanLevelEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingHostPortScanLevelEnum(val string) (HostPortScanLevelEnum, bool) {
	enum, ok := mappingHostPortScanLevelEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
