// Copyright (c) 2016, 2018, 2025, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

package vulnerabilityscanning

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"net/http"
	"strings"
)

// ListHostPortScanResultsRequest wrapper for the ListHostPortScanResults operation
//
// # See also
//
// Click https://docs.oracle.com/en-us/iaas/tools/go-sdk-examples/latest/vulnerabilityscanning/ListHostPortScanResults.go.html to see an example of how to use ListHostPortScanResultsRequest.
type ListHostPortScanResultsRequest struct {

	// The ID of the compartment in which to list resources.
	CompartmentId *string `mandatory:"true" contributesTo:"query" name:"compartmentId"`

	// The ID of a compute instance
	InstanceId *string `mandatory:"false" contributesTo:"query" name:"instanceId"`

	// Parameter to filter by highestProblemSeverity for scan results
	HighestProblemSeverity ListHostPortScanResultsHighestProblemSeverityEnum `mandatory:"false" contributesTo:"query" name:"highestProblemSeverity" omitEmpty:"true"`

	// Date and time on or after which scans were started, as described in RFC 3339 (https://tools.ietf.org/rfc/rfc3339)
	TimeStartedGreaterThanOrEqualTo *common.SDKTime `mandatory:"false" contributesTo:"query" name:"timeStartedGreaterThanOrEqualTo"`

	// Date and time on or before which scans were started, as described in RFC 3339 (https://tools.ietf.org/rfc/rfc3339)
	TimeStartedLessThanOrEqualTo *common.SDKTime `mandatory:"false" contributesTo:"query" name:"timeStartedLessThanOrEqualTo"`

	// The sort order to use, either 'ASC' or 'DESC'.
	SortOrder ListHostPortScanResultsSortOrderEnum `mandatory:"false" contributesTo:"query" name:"sortOrder" omitEmpty:"true"`

	// The field to sort by. Only one sort order may be provided. Default order is descending. If no value is specified timeFinished is default.
	SortBy ListHostPortScanResultsSortByEnum `mandatory:"false" contributesTo:"query" name:"sortBy" omitEmpty:"true"`

	// The maximum number of items to return.
	Limit *int `mandatory:"false" contributesTo:"query" name:"limit"`

	// The page token representing the page at which to start retrieving results. This is usually retrieved from a previous list call.
	Page *string `mandatory:"false" contributesTo:"query" name:"page"`

	// The client request ID for tracing.
	OpcRequestId *string `mandatory:"false" contributesTo:"header" name:"opc-request-id"`

	// A filter to return only resources that match the entire display name given.
	DisplayName *string `mandatory:"false" contributesTo:"query" name:"displayName"`

	// A flag to return only the latest scan result of an instance.
	IsLatestOnly *bool `mandatory:"false" contributesTo:"query" name:"isLatestOnly"`

	// Metadata about the request. This information will not be transmitted to the service, but
	// represents information that the SDK will consume to drive retry behavior.
	RequestMetadata common.RequestMetadata
}

func (request ListHostPortScanResultsRequest) String() string {
	return common.PointerString(request)
}

// HTTPRequest implements the OCIRequest interface
func (request ListHostPortScanResultsRequest) HTTPRequest(method, path string, binaryRequestBody *common.OCIReadSeekCloser, extraHeaders map[string]string) (http.Request, error) {

	_, err := request.ValidateEnumValue()
	if err != nil {
		return http.Request{}, err
	}
	return common.MakeDefaultHTTPRequestWithTaggedStructAndExtraHeaders(method, path, request, extraHeaders)
}

// BinaryRequestBody implements the OCIRequest interface
func (request ListHostPortScanResultsRequest) BinaryRequestBody() (*common.OCIReadSeekCloser, bool) {

	return nil, false

}

// RetryPolicy implements the OCIRetryableRequest interface. This retrieves the specified retry policy.
func (request ListHostPortScanResultsRequest) RetryPolicy() *common.RetryPolicy {
	return request.RequestMetadata.RetryPolicy
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (request ListHostPortScanResultsRequest) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingListHostPortScanResultsHighestProblemSeverityEnum(string(request.HighestProblemSeverity)); !ok && request.HighestProblemSeverity != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for HighestProblemSeverity: %s. Supported values are: %s.", request.HighestProblemSeverity, strings.Join(GetListHostPortScanResultsHighestProblemSeverityEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListHostPortScanResultsSortOrderEnum(string(request.SortOrder)); !ok && request.SortOrder != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortOrder: %s. Supported values are: %s.", request.SortOrder, strings.Join(GetListHostPortScanResultsSortOrderEnumStringValues(), ",")))
	}
	if _, ok := GetMappingListHostPortScanResultsSortByEnum(string(request.SortBy)); !ok && request.SortBy != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SortBy: %s. Supported values are: %s.", request.SortBy, strings.Join(GetListHostPortScanResultsSortByEnumStringValues(), ",")))
	}
	if len(errMessage) > 0 {
		return true, fmt.Errorf("%s", strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// ListHostPortScanResultsResponse wrapper for the ListHostPortScanResults operation
type ListHostPortScanResultsResponse struct {

	// The underlying http response
	RawResponse *http.Response

	// A list of HostPortScanResultSummaryCollection instances
	HostPortScanResultSummaryCollection `presentIn:"body"`

	// Unique Oracle-assigned identifier for the request. If you need to contact
	// Oracle about a particular request, please provide the request ID.
	OpcRequestId *string `presentIn:"header" name:"opc-request-id"`

	// For pagination of a list of items. When paging through a list, if this header appears in the response,
	// then a partial list might have been returned. Include this value as the `page` parameter for the
	// subsequent GET request to get the next batch of items.
	OpcNextPage *string `presentIn:"header" name:"opc-next-page"`
}

func (response ListHostPortScanResultsResponse) String() string {
	return common.PointerString(response)
}

// HTTPResponse implements the OCIResponse interface
func (response ListHostPortScanResultsResponse) HTTPResponse() *http.Response {
	return response.RawResponse
}

// ListHostPortScanResultsHighestProblemSeverityEnum Enum with underlying type: string
type ListHostPortScanResultsHighestProblemSeverityEnum string

// Set of constants representing the allowable values for ListHostPortScanResultsHighestProblemSeverityEnum
const (
	ListHostPortScanResultsHighestProblemSeverityNone     ListHostPortScanResultsHighestProblemSeverityEnum = "NONE"
	ListHostPortScanResultsHighestProblemSeverityLow      ListHostPortScanResultsHighestProblemSeverityEnum = "LOW"
	ListHostPortScanResultsHighestProblemSeverityMedium   ListHostPortScanResultsHighestProblemSeverityEnum = "MEDIUM"
	ListHostPortScanResultsHighestProblemSeverityHigh     ListHostPortScanResultsHighestProblemSeverityEnum = "HIGH"
	ListHostPortScanResultsHighestProblemSeverityCritical ListHostPortScanResultsHighestProblemSeverityEnum = "CRITICAL"
)

var mappingListHostPortScanResultsHighestProblemSeverityEnum = map[string]ListHostPortScanResultsHighestProblemSeverityEnum{
	"NONE":     ListHostPortScanResultsHighestProblemSeverityNone,
	"LOW":      ListHostPortScanResultsHighestProblemSeverityLow,
	"MEDIUM":   ListHostPortScanResultsHighestProblemSeverityMedium,
	"HIGH":     ListHostPortScanResultsHighestProblemSeverityHigh,
	"CRITICAL": ListHostPortScanResultsHighestProblemSeverityCritical,
}

var mappingListHostPortScanResultsHighestProblemSeverityEnumLowerCase = map[string]ListHostPortScanResultsHighestProblemSeverityEnum{
	"none":     ListHostPortScanResultsHighestProblemSeverityNone,
	"low":      ListHostPortScanResultsHighestProblemSeverityLow,
	"medium":   ListHostPortScanResultsHighestProblemSeverityMedium,
	"high":     ListHostPortScanResultsHighestProblemSeverityHigh,
	"critical": ListHostPortScanResultsHighestProblemSeverityCritical,
}

// GetListHostPortScanResultsHighestProblemSeverityEnumValues Enumerates the set of values for ListHostPortScanResultsHighestProblemSeverityEnum
func GetListHostPortScanResultsHighestProblemSeverityEnumValues() []ListHostPortScanResultsHighestProblemSeverityEnum {
	values := make([]ListHostPortScanResultsHighestProblemSeverityEnum, 0)
	for _, v := range mappingListHostPortScanResultsHighestProblemSeverityEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostPortScanResultsHighestProblemSeverityEnumStringValues Enumerates the set of values in String for ListHostPortScanResultsHighestProblemSeverityEnum
func GetListHostPortScanResultsHighestProblemSeverityEnumStringValues() []string {
	return []string{
		"NONE",
		"LOW",
		"MEDIUM",
		"HIGH",
		"CRITICAL",
	}
}

// GetMappingListHostPortScanResultsHighestProblemSeverityEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostPortScanResultsHighestProblemSeverityEnum(val string) (ListHostPortScanResultsHighestProblemSeverityEnum, bool) {
	enum, ok := mappingListHostPortScanResultsHighestProblemSeverityEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListHostPortScanResultsSortOrderEnum Enum with underlying type: string
type ListHostPortScanResultsSortOrderEnum string

// Set of constants representing the allowable values for ListHostPortScanResultsSortOrderEnum
const (
	ListHostPortScanResultsSortOrderAsc  ListHostPortScanResultsSortOrderEnum = "ASC"
	ListHostPortScanResultsSortOrderDesc ListHostPortScanResultsSortOrderEnum = "DESC"
)

var mappingListHostPortScanResultsSortOrderEnum = map[string]ListHostPortScanResultsSortOrderEnum{
	"ASC":  ListHostPortScanResultsSortOrderAsc,
	"DESC": ListHostPortScanResultsSortOrderDesc,
}

var mappingListHostPortScanResultsSortOrderEnumLowerCase = map[string]ListHostPortScanResultsSortOrderEnum{
	"asc":  ListHostPortScanResultsSortOrderAsc,
	"desc": ListHostPortScanResultsSortOrderDesc,
}

// GetListHostPortScanResultsSortOrderEnumValues Enumerates the set of values for ListHostPortScanResultsSortOrderEnum
func GetListHostPortScanResultsSortOrderEnumValues() []ListHostPortScanResultsSortOrderEnum {
	values := make([]ListHostPortScanResultsSortOrderEnum, 0)
	for _, v := range mappingListHostPortScanResultsSortOrderEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostPortScanResultsSortOrderEnumStringValues Enumerates the set of values in String for ListHostPortScanResultsSortOrderEnum
func GetListHostPortScanResultsSortOrderEnumStringValues() []string {
	return []string{
		"ASC",
		"DESC",
	}
}

// GetMappingListHostPortScanResultsSortOrderEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostPortScanResultsSortOrderEnum(val string) (ListHostPortScanResultsSortOrderEnum, bool) {
	enum, ok := mappingListHostPortScanResultsSortOrderEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}

// ListHostPortScanResultsSortByEnum Enum with underlying type: string
type ListHostPortScanResultsSortByEnum string

// Set of constants representing the allowable values for ListHostPortScanResultsSortByEnum
const (
	ListHostPortScanResultsSortByTimestarted            ListHostPortScanResultsSortByEnum = "timeStarted"
	ListHostPortScanResultsSortByTimefinished           ListHostPortScanResultsSortByEnum = "timeFinished"
	ListHostPortScanResultsSortByOpenportcount          ListHostPortScanResultsSortByEnum = "openPortCount"
	ListHostPortScanResultsSortByHighestproblemseverity ListHostPortScanResultsSortByEnum = "highestProblemSeverity"
	ListHostPortScanResultsSortByTimecompleted          ListHostPortScanResultsSortByEnum = "timeCompleted"
)

var mappingListHostPortScanResultsSortByEnum = map[string]ListHostPortScanResultsSortByEnum{
	"timeStarted":            ListHostPortScanResultsSortByTimestarted,
	"timeFinished":           ListHostPortScanResultsSortByTimefinished,
	"openPortCount":          ListHostPortScanResultsSortByOpenportcount,
	"highestProblemSeverity": ListHostPortScanResultsSortByHighestproblemseverity,
	"timeCompleted":          ListHostPortScanResultsSortByTimecompleted,
}

var mappingListHostPortScanResultsSortByEnumLowerCase = map[string]ListHostPortScanResultsSortByEnum{
	"timestarted":            ListHostPortScanResultsSortByTimestarted,
	"timefinished":           ListHostPortScanResultsSortByTimefinished,
	"openportcount":          ListHostPortScanResultsSortByOpenportcount,
	"highestproblemseverity": ListHostPortScanResultsSortByHighestproblemseverity,
	"timecompleted":          ListHostPortScanResultsSortByTimecompleted,
}

// GetListHostPortScanResultsSortByEnumValues Enumerates the set of values for ListHostPortScanResultsSortByEnum
func GetListHostPortScanResultsSortByEnumValues() []ListHostPortScanResultsSortByEnum {
	values := make([]ListHostPortScanResultsSortByEnum, 0)
	for _, v := range mappingListHostPortScanResultsSortByEnum {
		values = append(values, v)
	}
	return values
}

// GetListHostPortScanResultsSortByEnumStringValues Enumerates the set of values in String for ListHostPortScanResultsSortByEnum
func GetListHostPortScanResultsSortByEnumStringValues() []string {
	return []string{
		"timeStarted",
		"timeFinished",
		"openPortCount",
		"highestProblemSeverity",
		"timeCompleted",
	}
}

// GetMappingListHostPortScanResultsSortByEnum performs case Insensitive comparison on enum value and return the desired enum
func GetMappingListHostPortScanResultsSortByEnum(val string) (ListHostPortScanResultsSortByEnum, bool) {
	enum, ok := mappingListHostPortScanResultsSortByEnumLowerCase[strings.ToLower(val)]
	return enum, ok
}
