// AUTO GENERATED by tools/loadmeta.go
package services_test

import (
	. "github.com/onsi/ginkgo/v2"
	. "github.com/onsi/gomega"
	"github.com/softlayer/softlayer-go/services"
	"github.com/softlayer/softlayer-go/session/sessionfakes"
)

var _ = Describe("Product Tests", func() {
	var slsession *sessionfakes.FakeSLSession
	BeforeEach(func() {
		slsession = &sessionfakes.FakeSLSession{}
	})

	Context("Testing SoftLayer_Product_Item service", func() {
		var sl_service services.Product_Item
		BeforeEach(func() {
			sl_service = services.GetProductItemService(slsession)
		})
		Context("SoftLayer_Product_Item Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Product_Item Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Product_Item::getActivePresaleEvents", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActivePresaleEvents()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getActiveUsagePrices", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveUsagePrices()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getAttributes", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAttributes()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getAvailabilityAttributes", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAvailabilityAttributes()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getBillingType", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBillingType()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getBundle", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBundle()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getBundleItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBundleItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getCapacityMaximum", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCapacityMaximum()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getCapacityMinimum", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCapacityMinimum()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getCapacityRestrictedProductFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCapacityRestrictedProductFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getCategories", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCategories()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getConfigurationTemplates", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetConfigurationTemplates()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getConflicts", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetConflicts()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getCoreRestrictedItemFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCoreRestrictedItemFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getDowngradeItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetDowngradeItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getDowngradeItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetDowngradeItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getGlobalCategoryConflicts", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetGlobalCategoryConflicts()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getHardwareGenericComponentModel", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetHardwareGenericComponentModel()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getHideFromPortalFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetHideFromPortalFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getIneligibleForAccountDiscountFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetIneligibleForAccountDiscountFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getInventory", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetInventory()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getIsEngineeredServerProduct", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetIsEngineeredServerProduct()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getItemCategory", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetItemCategory()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getLocalDiskFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetLocalDiskFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getLocationConflicts", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetLocationConflicts()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getM2ControllerFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetM2ControllerFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getM2DriveFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetM2DriveFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getMinimumNvmeBays", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetMinimumNvmeBays()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getNvmeDiskFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetNvmeDiskFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getObjectStorageClusterGeolocationType", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObjectStorageClusterGeolocationType()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getObjectStorageItemFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObjectStorageItemFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getObjectStorageServiceClass", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObjectStorageServiceClass()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getPackages", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPackages()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getPcieDriveFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPcieDriveFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getPhysicalCoreCapacity", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPhysicalCoreCapacity()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getPresaleEvents", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPresaleEvents()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getPrices", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPrices()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getPrivateInterfaceCount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPrivateInterfaceCount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getPublicInterfaceCount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPublicInterfaceCount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getRequirements", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetRequirements()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getRules", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetRules()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getSoftwareDescription", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetSoftwareDescription()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getSpeedSelectServerCoreCount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetSpeedSelectServerCoreCount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getSpeedSelectServerFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetSpeedSelectServerFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getSupportedBiosSettingsProfiles", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetSupportedBiosSettingsProfiles()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getTaxCategory", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTaxCategory()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getThirdPartyPolicyAssignments", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetThirdPartyPolicyAssignments()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getThirdPartySupportVendor", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetThirdPartySupportVendor()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getTotalPhysicalCoreCapacity", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTotalPhysicalCoreCapacity()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getTotalPhysicalCoreCount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTotalPhysicalCoreCount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getTotalProcessorCapacity", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTotalProcessorCapacity()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getUpgradeItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetUpgradeItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item::getUpgradeItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetUpgradeItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Product_Item_Category service", func() {
		var sl_service services.Product_Item_Category
		BeforeEach(func() {
			sl_service = services.GetProductItemCategoryService(slsession)
		})
		Context("SoftLayer_Product_Item_Category Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Product_Item_Category Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Product_Item_Category::getAdditionalProductsForCategory", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAdditionalProductsForCategory()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Category::getBandwidthCategories", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBandwidthCategories()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Category::getBillingItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBillingItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Category::getComputingCategories", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetComputingCategories(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Category::getCustomUsageRatesCategories", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCustomUsageRatesCategories(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Category::getExternalResourceCategories", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetExternalResourceCategories()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Category::getGroup", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetGroup()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Category::getGroups", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetGroups()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Category::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Category::getObjectStorageCategories", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObjectStorageCategories(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Category::getOrderOptions", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrderOptions()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Category::getPackageConfigurations", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPackageConfigurations()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Category::getPresetConfigurations", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPresetConfigurations()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Category::getQuestionReferences", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetQuestionReferences()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Category::getQuestions", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetQuestions()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Category::getSoftwareCategories", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetSoftwareCategories()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Category::getSubnetCategories", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetSubnetCategories()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Category::getTopLevelCategories", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTopLevelCategories(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Category::getValidCancelableServiceItemCategories", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetValidCancelableServiceItemCategories()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Category::getVlanCategories", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetVlanCategories()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Product_Item_Category_Group service", func() {
		var sl_service services.Product_Item_Category_Group
		BeforeEach(func() {
			sl_service = services.GetProductItemCategoryGroupService(slsession)
		})
		Context("SoftLayer_Product_Item_Category_Group Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Product_Item_Category_Group Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Product_Item_Category_Group::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Product_Item_Policy_Assignment service", func() {
		var sl_service services.Product_Item_Policy_Assignment
		BeforeEach(func() {
			sl_service = services.GetProductItemPolicyAssignmentService(slsession)
		})
		Context("SoftLayer_Product_Item_Policy_Assignment Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Product_Item_Policy_Assignment Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Product_Item_Policy_Assignment::acceptFromTicket", func() {
			It("API Call Test", func() {
				_, err := sl_service.AcceptFromTicket(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Policy_Assignment::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Policy_Assignment::getPolicyDocumentContents", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPolicyDocumentContents()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Policy_Assignment::getPolicyName", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPolicyName()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Policy_Assignment::getProduct", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetProduct()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Product_Item_Price service", func() {
		var sl_service services.Product_Item_Price
		BeforeEach(func() {
			sl_service = services.GetProductItemPriceService(slsession)
		})
		Context("SoftLayer_Product_Item_Price Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Product_Item_Price Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Product_Item_Price::getAccountRestrictions", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAccountRestrictions()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getAttributes", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAttributes()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getBareMetalReservedCapacityFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBareMetalReservedCapacityFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getBigDataOsJournalDiskFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBigDataOsJournalDiskFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getBundleReferences", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBundleReferences()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getCapacityRestrictionMaximum", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCapacityRestrictionMaximum()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getCapacityRestrictionMinimum", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCapacityRestrictionMinimum()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getCapacityRestrictionType", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCapacityRestrictionType()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getCategories", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCategories()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getDedicatedHostInstanceFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetDedicatedHostInstanceFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getDefinedSoftwareLicenseFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetDefinedSoftwareLicenseFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getEligibilityStrategy", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetEligibilityStrategy()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getOrderPremiums", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrderPremiums()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getPackageReferences", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPackageReferences()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getPackages", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPackages()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getPresetConfigurations", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPresetConfigurations()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getPriceType", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPriceType()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getPricingLocationGroup", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPricingLocationGroup()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getRequiredCoreCount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetRequiredCoreCount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getReservedCapacityInstanceFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetReservedCapacityInstanceFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price::getUsageRatePrices", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetUsageRatePrices(nil, nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Product_Item_Price_Premium service", func() {
		var sl_service services.Product_Item_Price_Premium
		BeforeEach(func() {
			sl_service = services.GetProductItemPricePremiumService(slsession)
		})
		Context("SoftLayer_Product_Item_Price_Premium Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Product_Item_Price_Premium Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Product_Item_Price_Premium::getItemPrice", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetItemPrice()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price_Premium::getLocation", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetLocation()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price_Premium::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Item_Price_Premium::getPackage", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPackage()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Product_Order service", func() {
		var sl_service services.Product_Order
		BeforeEach(func() {
			sl_service = services.GetProductOrderService(slsession)
		})
		Context("SoftLayer_Product_Order Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Product_Order Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Product_Order::checkItemAvailability", func() {
			It("API Call Test", func() {
				_, err := sl_service.CheckItemAvailability(nil, nil, nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Order::checkItemAvailabilityForImageTemplate", func() {
			It("API Call Test", func() {
				_, err := sl_service.CheckItemAvailabilityForImageTemplate(nil, nil, nil, nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Order::checkItemConflicts", func() {
			It("API Call Test", func() {
				_, err := sl_service.CheckItemConflicts(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Order::getExternalPaymentAuthorizationReceipt", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetExternalPaymentAuthorizationReceipt(nil, nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Order::getNetworks", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetNetworks(nil, nil, nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Order::getResellerOrder", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetResellerOrder(GetOrderContainer())
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Order::getTaxCalculationResult", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTaxCalculationResult(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Order::getVlans", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetVlans(nil, nil, nil, nil, nil, nil, nil, nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Order::placeOrder", func() {
			It("API Call Test", func() {
				_, err := sl_service.PlaceOrder(GetOrderContainer(), nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Order::placeQuote", func() {
			It("API Call Test", func() {
				_, err := sl_service.PlaceQuote(GetOrderContainer())
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Order::processExternalPaymentAuthorization", func() {
			It("API Call Test", func() {
				_, err := sl_service.ProcessExternalPaymentAuthorization(nil, nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Order::requiredItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.RequiredItems(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Order::verifyOrder", func() {
			It("API Call Test", func() {
				_, err := sl_service.VerifyOrder(GetOrderContainer())
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Product_Package service", func() {
		var sl_service services.Product_Package
		BeforeEach(func() {
			sl_service = services.GetProductPackageService(slsession)
		})
		Context("SoftLayer_Product_Package Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Product_Package Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Product_Package::getAccountRestrictedActivePresets", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAccountRestrictedActivePresets()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getAccountRestrictedCategories", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAccountRestrictedCategories()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getAccountRestrictedPricesFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAccountRestrictedPricesFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getActiveItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getActivePackagesByAttribute", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActivePackagesByAttribute(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getActivePresets", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActivePresets()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getActivePrivateHostedCloudPackages", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActivePrivateHostedCloudPackages()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getActiveRamItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveRamItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getActiveServerItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveServerItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getActiveSoftwareItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveSoftwareItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getActiveUsagePrices", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveUsagePrices()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getActiveUsageRatePrices", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetActiveUsageRatePrices(nil, nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getAdditionalServiceFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAdditionalServiceFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getAllObjects", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAllObjects()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getAttributes", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAttributes()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getAvailableLocations", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAvailableLocations()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getAvailablePackagesForImageTemplate", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAvailablePackagesForImageTemplate(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getAvailableStorageUnits", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAvailableStorageUnits()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getCategories", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCategories()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getCdnItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCdnItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getCloudStorageItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCloudStorageItems(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getConfiguration", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetConfiguration()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getDefaultBootCategoryCode", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetDefaultBootCategoryCode()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getDefaultRamItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetDefaultRamItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getDeploymentNodeType", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetDeploymentNodeType()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getDeploymentPackages", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetDeploymentPackages()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getDeploymentType", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetDeploymentType()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getDeployments", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetDeployments()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getDisallowCustomDiskPartitions", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetDisallowCustomDiskPartitions()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getFirstOrderStep", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetFirstOrderStep()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getGatewayApplianceFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetGatewayApplianceFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getGpuFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetGpuFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getHourlyBillingAvailableFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetHourlyBillingAvailableFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getHourlyOnlyOrders", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetHourlyOnlyOrders()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getItemAvailabilityTypes", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetItemAvailabilityTypes()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getItemConflicts", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetItemConflicts()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getItemLocationConflicts", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetItemLocationConflicts()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getItemPriceReferences", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetItemPriceReferences()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getItemPrices", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetItemPrices()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getItemPricesFromSoftwareDescriptions", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetItemPricesFromSoftwareDescriptions(nil, nil, nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getItemsFromImageTemplate", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetItemsFromImageTemplate(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getLocations", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetLocations()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getLowestServerPrice", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetLowestServerPrice()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getMaximumPortSpeed", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetMaximumPortSpeed()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getMessageQueueItems", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetMessageQueueItems()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getMinimumPortSpeed", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetMinimumPortSpeed()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getMongoDbEngineeredFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetMongoDbEngineeredFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getNoUpgradesFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetNoUpgradesFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getNonEuCompliantFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetNonEuCompliantFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getObjectStorageDatacenters", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObjectStorageDatacenters()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getObjectStorageLocationGroups", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObjectStorageLocationGroups()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getOrderPremiums", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrderPremiums()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getPopLocationAvailabilityFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPopLocationAvailabilityFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getPreconfiguredFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPreconfiguredFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getPresetConfigurationRequiredFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPresetConfigurationRequiredFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getPreventVlanSelectionFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPreventVlanSelectionFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getPrivateHostedCloudPackageFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPrivateHostedCloudPackageFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getPrivateHostedCloudPackageType", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPrivateHostedCloudPackageType()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getPrivateNetworkOnlyFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPrivateNetworkOnlyFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getQuantaStorPackageFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetQuantaStorPackageFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getRaidDiskRestrictionFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetRaidDiskRestrictionFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getRedundantPowerFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetRedundantPowerFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getRegions", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetRegions()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getStandardCategories", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetStandardCategories()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getTopLevelItemCategoryCode", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTopLevelItemCategoryCode()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package::getType", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetType()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Product_Package_Preset service", func() {
		var sl_service services.Product_Package_Preset
		BeforeEach(func() {
			sl_service = services.GetProductPackagePresetService(slsession)
		})
		Context("SoftLayer_Product_Package_Preset Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Product_Package_Preset Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Product_Package_Preset::getAllObjects", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAllObjects()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Preset::getAvailableStorageUnits", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAvailableStorageUnits()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Preset::getBareMetalReservedFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetBareMetalReservedFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Preset::getCategories", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCategories()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Preset::getComputeGroup", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetComputeGroup()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Preset::getConfiguration", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetConfiguration()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Preset::getDisallowedComputeGroupUpgradeFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetDisallowedComputeGroupUpgradeFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Preset::getFixedConfigurationFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetFixedConfigurationFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Preset::getLocations", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetLocations()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Preset::getLowestPresetServerPrice", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetLowestPresetServerPrice()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Preset::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Preset::getPackage", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPackage()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Preset::getPackageConfiguration", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPackageConfiguration()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Preset::getPrices", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPrices()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Preset::getStorageGroupTemplateArrays", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetStorageGroupTemplateArrays()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Preset::getTotalMinimumHourlyFee", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTotalMinimumHourlyFee()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Preset::getTotalMinimumRecurringFee", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTotalMinimumRecurringFee()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Product_Package_Server service", func() {
		var sl_service services.Product_Package_Server
		BeforeEach(func() {
			sl_service = services.GetProductPackageServerService(slsession)
		})
		Context("SoftLayer_Product_Package_Server Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Product_Package_Server Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Product_Package_Server::getAllObjects", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAllObjects()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Server::getCatalog", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCatalog()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Server::getItem", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetItem()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Server::getItemPrice", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetItemPrice()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Server::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Server::getPackage", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPackage()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Server::getPreset", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPreset()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Product_Package_Server_Option service", func() {
		var sl_service services.Product_Package_Server_Option
		BeforeEach(func() {
			sl_service = services.GetProductPackageServerOptionService(slsession)
		})
		Context("SoftLayer_Product_Package_Server_Option Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Product_Package_Server_Option Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Product_Package_Server_Option::getAllOptions", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAllOptions()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Server_Option::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Server_Option::getOptions", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOptions(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Product_Package_Type service", func() {
		var sl_service services.Product_Package_Type
		BeforeEach(func() {
			sl_service = services.GetProductPackageTypeService(slsession)
		})
		Context("SoftLayer_Product_Package_Type Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Product_Package_Type Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Product_Package_Type::getAllObjects", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAllObjects()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Type::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Package_Type::getPackages", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetPackages()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Product_Promotion service", func() {
		var sl_service services.Product_Promotion
		BeforeEach(func() {
			sl_service = services.GetProductPromotionService(slsession)
		})
		Context("SoftLayer_Product_Promotion Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Product_Promotion Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Product_Promotion::findByPromoCode", func() {
			It("API Call Test", func() {
				_, err := sl_service.FindByPromoCode(nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Promotion::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

	Context("Testing SoftLayer_Product_Upgrade_Request service", func() {
		var sl_service services.Product_Upgrade_Request
		BeforeEach(func() {
			sl_service = services.GetProductUpgradeRequestService(slsession)
		})
		Context("SoftLayer_Product_Upgrade_Request Set Options", func() {
			It("Set Options properly", func() {
				t_id := 1234
				t_filter := "{'testFilter':{'test'}}"
				t_limit := 100
				t_offset := 5
				sl_service = sl_service.Id(t_id).Filter(t_filter).Offset(t_offset).Limit(t_limit)
				Expect(sl_service.Options.Id).To(HaveValue(Equal(t_id)))
				Expect(sl_service.Options.Filter).To(HaveValue(Equal(t_filter)))
				Expect(sl_service.Options.Limit).To(HaveValue(Equal(t_limit)))
				Expect(sl_service.Options.Offset).To(HaveValue(Equal(t_offset)))
			})
		})
		Context("SoftLayer_Product_Upgrade_Request Set Mask", func() {
			It("Set Options properly", func() {
				t_mask1 := "mask[test,test2]"
				sl_service = sl_service.Mask(t_mask1)
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
				// Mask("test,test2") should set the mask to be "mask[test,test2]" aka t_mask1
				sl_service = sl_service.Mask("test,test2")
				Expect(sl_service.Options.Mask).To(HaveValue(Equal(t_mask1)))
			})
		})
		Context("SoftLayer_Product_Upgrade_Request::approveChanges", func() {
			It("API Call Test", func() {
				_, err := sl_service.ApproveChanges()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Upgrade_Request::getAccount", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetAccount()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Upgrade_Request::getCompletedFlag", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetCompletedFlag()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Upgrade_Request::getInvoice", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetInvoice()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Upgrade_Request::getObject", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetObject()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Upgrade_Request::getOrder", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetOrder()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Upgrade_Request::getServer", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetServer()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Upgrade_Request::getStatus", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetStatus()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Upgrade_Request::getTicket", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetTicket()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Upgrade_Request::getUser", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetUser()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Upgrade_Request::getVirtualGuest", func() {
			It("API Call Test", func() {
				_, err := sl_service.GetVirtualGuest()
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
		Context("SoftLayer_Product_Upgrade_Request::updateMaintenanceWindow", func() {
			It("API Call Test", func() {
				_, err := sl_service.UpdateMaintenanceWindow(nil, nil)
				Expect(err).To(Succeed())
				Expect(slsession.DoRequestCallCount()).To(Equal(1))
			})
		})
	})

})
