;; Web Assembly SIMD-related type conversion tests

(module
  ;; Integer to floating point
  (func (export "f32x4.convert_i32x4_s") (param v128) (result v128)
    (f32x4.convert_i32x4_s (local.get 0)))
  (func (export "f32x4.convert_i32x4_u") (param v128) (result v128)
    (f32x4.convert_i32x4_u (local.get 0)))

  (func (export "f64x2.convert_low_i32x4_s") (param v128) (result v128)
    (f64x2.convert_low_i32x4_s (local.get 0)))
  (func (export "f64x2.convert_low_i32x4_u") (param v128) (result v128)
    (f64x2.convert_low_i32x4_u (local.get 0)))

  ;; Integer to integer narrowing
  (func (export "i8x16.narrow_i16x8_s") (param v128 v128) (result v128)
    (i8x16.narrow_i16x8_s (local.get 0) (local.get 1)))
  (func (export "i8x16.narrow_i16x8_u") (param v128 v128) (result v128)
    (i8x16.narrow_i16x8_u (local.get 0) (local.get 1)))
  (func (export "i16x8.narrow_i32x4_s") (param v128 v128) (result v128)
    (i16x8.narrow_i32x4_s (local.get 0) (local.get 1)))
  (func (export "i16x8.narrow_i32x4_u") (param v128 v128) (result v128)
    (i16x8.narrow_i32x4_u (local.get 0)(local.get 1)))

  ;; Float to float promote/demote
  (func (export "f64x2.promote_low_f32x4") (param v128) (result v128)
    (f64x2.promote_low_f32x4 (local.get 0)))
  (func (export "f32x4.demote_f64x2_zero") (param v128) (result v128)
    (f32x4.demote_f64x2_zero (local.get 0)))
)

;; f64x2.promote_low_f32x4
;; Float constants copied from test/core/conversions.wast.

(assert_return (invoke "f64x2.promote_low_f32x4" (v128.const f32x4 0.0 0.0 0.0 0.0))
                                                 (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.promote_low_f32x4" (v128.const f32x4 -0.0 -0.0 -0.0 -0.0))
                                                 (v128.const f64x2 -0.0 -0.0))
(assert_return (invoke "f64x2.promote_low_f32x4" (v128.const f32x4 0x1p-149 0x1p-149 0x1p-149 0x1p-149))
                                                 (v128.const f64x2 0x1p-149 0x1p-149))
(assert_return (invoke "f64x2.promote_low_f32x4" (v128.const f32x4 -0x1p-149 -0x1p-149 -0x1p-149 -0x1p-149))
                                                 (v128.const f64x2 -0x1p-149 -0x1p-149))
(assert_return (invoke "f64x2.promote_low_f32x4" (v128.const f32x4 1.0 1.0 1.0 1.0))
                                                 (v128.const f64x2 1.0 1.0))
(assert_return (invoke "f64x2.promote_low_f32x4" (v128.const f32x4 -1.0 -1.0 -1.0 -1.0))
                                                 (v128.const f64x2 -1.0 -1.0))
(assert_return (invoke "f64x2.promote_low_f32x4" (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127 -0x1.fffffep+127))
                                                 (v128.const f64x2 -0x1.fffffep+127 -0x1.fffffep+127))
(assert_return (invoke "f64x2.promote_low_f32x4" (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127 0x1.fffffep+127))
                                                 (v128.const f64x2 0x1.fffffep+127 0x1.fffffep+127))
;; Generated randomly by picking a random int and reinterpret it to float.
(assert_return (invoke "f64x2.promote_low_f32x4" (v128.const f32x4 0x1p-119 0x1p-119 0x1p-119 0x1p-119))
                                                 (v128.const f64x2 0x1p-119 0x1p-119))
;; Generated randomly by picking a random float.
(assert_return (invoke "f64x2.promote_low_f32x4" (v128.const f32x4 0x1.8f867ep+125 0x1.8f867ep+125 0x1.8f867ep+125 0x1.8f867ep+125))
                                                 (v128.const f64x2 6.6382536710104395e+37 6.6382536710104395e+37))
(assert_return (invoke "f64x2.promote_low_f32x4" (v128.const f32x4 inf inf inf inf))
                                                 (v128.const f64x2 inf inf))
(assert_return (invoke "f64x2.promote_low_f32x4" (v128.const f32x4 -inf -inf -inf -inf))
                                                 (v128.const f64x2 -inf -inf))
(assert_return (invoke "f64x2.promote_low_f32x4" (v128.const f32x4 nan nan nan nan))
                                                 (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.promote_low_f32x4" (v128.const f32x4 nan:0x200000 nan:0x200000 nan:0x200000 nan:0x200000))
                                                 (v128.const f64x2 nan:arithmetic nan:arithmetic))
(assert_return (invoke "f64x2.promote_low_f32x4" (v128.const f32x4 -nan -nan -nan -nan))
                                                 (v128.const f64x2 nan:canonical nan:canonical))
(assert_return (invoke "f64x2.promote_low_f32x4" (v128.const f32x4 -nan:0x200000 -nan:0x200000 -nan:0x200000 -nan:0x200000))
                                                 (v128.const f64x2 nan:arithmetic nan:arithmetic))

;; f32x4.demote_f64x2_zero
;; Float constants copied from test/core/conversions.wast.

(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0.0 0.0))
                                                 (v128.const f32x4 0.0 0.0 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 -0.0 -0.0))
                                                 (v128.const f32x4 -0.0 -0.0 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x0.0000000000001p-1022 0x0.0000000000001p-1022))
                                                 (v128.const f32x4 0.0 0.0 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 -0x0.0000000000001p-1022 -0x0.0000000000001p-1022))
                                                 (v128.const f32x4 -0.0 -0.0 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 1.0 1.0))
                                                 (v128.const f32x4 1.0 1.0 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 -1.0 -1.0))
                                                 (v128.const f32x4 -1.0 -1.0 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.fffffe0000000p-127 0x1.fffffe0000000p-127))
                                                 (v128.const f32x4 0x1p-126 0x1p-126 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 -0x1.fffffe0000000p-127 -0x1.fffffe0000000p-127))
                                                 (v128.const f32x4 -0x1p-126 -0x1p-126 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.fffffdfffffffp-127 0x1.fffffdfffffffp-127))
                                                 (v128.const f32x4 0x1.fffffcp-127 0x1.fffffcp-127 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 -0x1.fffffdfffffffp-127 -0x1.fffffdfffffffp-127))
                                                 (v128.const f32x4 -0x1.fffffcp-127 -0x1.fffffcp-127 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1p-149 0x1p-149))
                                                 (v128.const f32x4 0x1p-149 0x1p-149 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 -0x1p-149 -0x1p-149))
                                                 (v128.const f32x4 -0x1p-149 -0x1p-149 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.fffffd0000000p+127 0x1.fffffd0000000p+127))
                                                 (v128.const f32x4 0x1.fffffcp+127 0x1.fffffcp+127 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 -0x1.fffffd0000000p+127 -0x1.fffffd0000000p+127))
                                                 (v128.const f32x4 -0x1.fffffcp+127 -0x1.fffffcp+127 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.fffffd0000001p+127 0x1.fffffd0000001p+127))
                                                 (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 -0x1.fffffd0000001p+127 -0x1.fffffd0000001p+127))
                                                 (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.fffffep+127 0x1.fffffep+127))
                                                 (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 -0x1.fffffep+127 -0x1.fffffep+127))
                                                 (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.fffffefffffffp+127 0x1.fffffefffffffp+127))
                                                 (v128.const f32x4 0x1.fffffep+127 0x1.fffffep+127 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 -0x1.fffffefffffffp+127 -0x1.fffffefffffffp+127))
                                                 (v128.const f32x4 -0x1.fffffep+127 -0x1.fffffep+127 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.ffffffp+127 0x1.ffffffp+127))
                                                 (v128.const f32x4 inf inf 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 -0x1.ffffffp+127 -0x1.ffffffp+127))
                                                 (v128.const f32x4 -inf -inf 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1p-119 0x1p-119))
                                                 (v128.const f32x4 0x1p-119 0x1p-119 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.8f867ep+125 0x1.8f867ep+125))
                                                 (v128.const f32x4 0x1.8f867ep+125 0x1.8f867ep+125 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 inf inf))
                                                 (v128.const f32x4 inf inf 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 -inf -inf))
                                                 (v128.const f32x4 -inf -inf 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.0000000000001p+0 0x1.0000000000001p+0))
                                                 (v128.const f32x4 1.0 1.0 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.fffffffffffffp-1 0x1.fffffffffffffp-1))
                                                 (v128.const f32x4 1.0 1.0 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.0000010000000p+0 0x1.0000010000000p+0))
                                                 (v128.const f32x4 0x1.000000p+0 0x1.000000p+0 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.0000010000001p+0 0x1.0000010000001p+0))
                                                 (v128.const f32x4 0x1.000002p+0 0x1.000002p+0 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.000002fffffffp+0 0x1.000002fffffffp+0))
                                                 (v128.const f32x4 0x1.000002p+0 0x1.000002p+0 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.0000030000000p+0 0x1.0000030000000p+0))
                                                 (v128.const f32x4 0x1.000004p+0 0x1.000004p+0 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.0000050000000p+0 0x1.0000050000000p+0))
                                                 (v128.const f32x4 0x1.000004p+0 0x1.000004p+0 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.0000010000000p+24 0x1.0000010000000p+24))
                                                 (v128.const f32x4 0x1.0p+24 0x1.0p+24 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.0000010000001p+24 0x1.0000010000001p+24))
                                                 (v128.const f32x4 0x1.000002p+24 0x1.000002p+24 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.000002fffffffp+24 0x1.000002fffffffp+24))
                                                 (v128.const f32x4 0x1.000002p+24 0x1.000002p+24 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.0000030000000p+24 0x1.0000030000000p+24))
                                                 (v128.const f32x4 0x1.000004p+24 0x1.000004p+24 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.4eae4f7024c7p+108 0x1.4eae4f7024c7p+108))
                                                 (v128.const f32x4 0x1.4eae5p+108 0x1.4eae5p+108 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.a12e71e358685p-113 0x1.a12e71e358685p-113))
                                                 (v128.const f32x4 0x1.a12e72p-113 0x1.a12e72p-113 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.cb98354d521ffp-127 0x1.cb98354d521ffp-127))
                                                 (v128.const f32x4 0x1.cb9834p-127 0x1.cb9834p-127 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 -0x1.6972b30cfb562p+1 -0x1.6972b30cfb562p+1))
                                                 (v128.const f32x4 -0x1.6972b4p+1 -0x1.6972b4p+1 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 -0x1.bedbe4819d4c4p+112 -0x1.bedbe4819d4c4p+112))
                                                 (v128.const f32x4 -0x1.bedbe4p+112 -0x1.bedbe4p+112 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 nan nan))
                                                 (v128.const f32x4 nan:canonical nan:canonical 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 nan:0x4000000000000 nan:0x4000000000000))
                                                 (v128.const f32x4 nan:arithmetic nan:arithmetic 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 -nan -nan))
                                                 (v128.const f32x4 nan:canonical nan:canonical 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 -nan:0x4000000000000 -nan:0x4000000000000))
                                                 (v128.const f32x4 nan:arithmetic nan:arithmetic 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1p-1022 0x1p-1022))
                                                 (v128.const f32x4 0.0 0.0 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 -0x1p-1022 -0x1p-1022))
                                                 (v128.const f32x4 -0.0 -0.0 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.0p-150 0x1.0p-150))
                                                 (v128.const f32x4 0.0 0.0 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 -0x1.0p-150 -0x1.0p-150))
                                                 (v128.const f32x4 -0.0 -0.0 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 0x1.0000000000001p-150 0x1.0000000000001p-150))
                                                 (v128.const f32x4 0x1p-149 0x1p-149 0 0))
(assert_return (invoke "f32x4.demote_f64x2_zero" (v128.const f64x2 -0x1.0000000000001p-150 -0x1.0000000000001p-150))
                                                 (v128.const f32x4 -0x1p-149 -0x1p-149 0 0))


;; Integer to floating point
;; f32x4.convert_i32x4_s

(assert_return (invoke "f32x4.convert_i32x4_s" (v128.const i32x4 0 0 0 0))
                                               (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.convert_i32x4_s" (v128.const i32x4 1 1 1 1))
                                               (v128.const f32x4 1.0 1.0 1.0 1.0))
(assert_return (invoke "f32x4.convert_i32x4_s" (v128.const i32x4 -1 -1 -1 -1))
                                               (v128.const f32x4 -1.0 -1.0 -1.0 -1.0))
(assert_return (invoke "f32x4.convert_i32x4_s" (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
                                               (v128.const f32x4 2147483647.0 2147483647.0 2147483647.0 2147483647.0))
(assert_return (invoke "f32x4.convert_i32x4_s" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
                                               (v128.const f32x4 -2147483648.0 -2147483648.0 -2147483648.0 -2147483648.0))
(assert_return (invoke "f32x4.convert_i32x4_s" (v128.const i32x4 1234567890 1234567890 1234567890 1234567890))
                                               (v128.const f32x4 0x1.26580cp+30 0x1.26580cp+30 0x1.26580cp+30 0x1.26580cp+30))
(assert_return (invoke "f32x4.convert_i32x4_s" (v128.const i32x4 0_123_456_792 0_123_456_792 0_123_456_792 0_123_456_792))
                                               (v128.const f32x4 123456792.0 123456792.0 123456792.0 123456792.0))
(assert_return (invoke "f32x4.convert_i32x4_s" (v128.const i32x4 0x0_1234_5680 0x0_1234_5680 0x0_1234_5680 0x0_1234_5680))
                                               (v128.const f32x4 305419904.0 305419904.0 305419904.0 305419904.0))
;; Test rounding directions.

(assert_return (invoke "f32x4.convert_i32x4_s" (v128.const i32x4 16777217 16777217 16777217 16777217))
                                               (v128.const f32x4 16777216.0 16777216.0 16777216.0 16777216.0))
(assert_return (invoke "f32x4.convert_i32x4_s" (v128.const i32x4 -16777217 -16777217 -16777217 -16777217))
                                               (v128.const f32x4 -16777216.0 -16777216.0 -16777216.0 -16777216.0))
(assert_return (invoke "f32x4.convert_i32x4_s" (v128.const i32x4 16777219 16777219 16777219 16777219))
                                               (v128.const f32x4 16777220.0 16777220.0 16777220.0 16777220.0))
(assert_return (invoke "f32x4.convert_i32x4_s" (v128.const i32x4 -16777219 -16777219 -16777219 -16777219))
                                               (v128.const f32x4 -16777220.0 -16777220.0 -16777220.0 -16777220.0))
(assert_return (invoke "f32x4.convert_i32x4_s" (v128.const i32x4 0 -1 0x7fffffff 0x80000000))
                                               (v128.const f32x4 0.0 -1.0 2147483647.0 -2147483648.0))

;; f32x4.convert_i32x4_u

(assert_return (invoke "f32x4.convert_i32x4_u" (v128.const i32x4 0 0 0 0))
                                               (v128.const f32x4 0.0 0.0 0.0 0.0))
(assert_return (invoke "f32x4.convert_i32x4_u" (v128.const i32x4 1 1 1 1))
                                               (v128.const f32x4 1.0 1.0 1.0 1.0))
(assert_return (invoke "f32x4.convert_i32x4_u" (v128.const i32x4 -1 -1 -1 -1))
                                               (v128.const f32x4 4294967295.0 4294967295.0 4294967295.0 4294967295.0))
(assert_return (invoke "f32x4.convert_i32x4_u" (v128.const i32x4 2147483647 2147483647 2147483647 2147483647))
                                               (v128.const f32x4 2147483648.0 2147483648.0 2147483648.0 2147483648.0))
(assert_return (invoke "f32x4.convert_i32x4_u" (v128.const i32x4 -2147483648 -2147483648 -2147483648 -2147483648))
                                               (v128.const f32x4 2147483648.0 2147483648.0 2147483648.0 2147483648.0))
(assert_return (invoke "f32x4.convert_i32x4_u" (v128.const i32x4 0x12345678 0x12345678 0x12345678 0x12345678))
                                               (v128.const f32x4 0x1.234568p+28 0x1.234568p+28 0x1.234568p+28 0x1.234568p+28))
(assert_return (invoke "f32x4.convert_i32x4_u" (v128.const i32x4 0x80000080 0x80000080 0x80000080 0x80000080))
                                               (v128.const f32x4 0x1.000000p+31 0x1.000000p+31 0x1.000000p+31 0x1.000000p+31))
(assert_return (invoke "f32x4.convert_i32x4_u" (v128.const i32x4 0x80000081 0x80000081 0x80000081 0x80000081))
                                               (v128.const f32x4 0x1.000002p+31 0x1.000002p+31 0x1.000002p+31 0x1.000002p+31))
(assert_return (invoke "f32x4.convert_i32x4_u" (v128.const i32x4 0x80000082 0x80000082 0x80000082 0x80000082))
                                               (v128.const f32x4 0x1.000002p+31 0x1.000002p+31 0x1.000002p+31 0x1.000002p+31))
(assert_return (invoke "f32x4.convert_i32x4_u" (v128.const i32x4 0xfffffe80 0xfffffe80 0xfffffe80 0xfffffe80))
                                               (v128.const f32x4 0x1.fffffcp+31 0x1.fffffcp+31 0x1.fffffcp+31 0x1.fffffcp+31))
(assert_return (invoke "f32x4.convert_i32x4_u" (v128.const i32x4 0xfffffe81 0xfffffe81 0xfffffe81 0xfffffe81))
                                               (v128.const f32x4 0x1.fffffep+31 0x1.fffffep+31 0x1.fffffep+31 0x1.fffffep+31))
(assert_return (invoke "f32x4.convert_i32x4_u" (v128.const i32x4 0xfffffe82 0xfffffe82 0xfffffe82 0xfffffe82))
                                               (v128.const f32x4 0x1.fffffep+31 0x1.fffffep+31 0x1.fffffep+31 0x1.fffffep+31))
(assert_return (invoke "f32x4.convert_i32x4_u" (v128.const i32x4 0_123_456_792 0_123_456_792 0_123_456_792 0_123_456_792))
                                               (v128.const f32x4 123456792.0 123456792.0 123456792.0 123456792.0))
(assert_return (invoke "f32x4.convert_i32x4_u" (v128.const i32x4 0x0_90AB_cdef 0x0_90AB_cdef 0x0_90AB_cdef 0x0_90AB_cdef))
                                               (v128.const f32x4 2427178496.0 2427178496.0 2427178496.0 2427178496.0))
;; Test rounding directions.

(assert_return (invoke "f32x4.convert_i32x4_u" (v128.const i32x4 16777217 16777217 16777217 16777217))
                                               (v128.const f32x4 16777216.0 16777216.0 16777216.0 16777216.0))
(assert_return (invoke "f32x4.convert_i32x4_u" (v128.const i32x4 16777219 16777219 16777219 16777219))
                                               (v128.const f32x4 16777220.0 16777220.0 16777220.0 16777220.0))
(assert_return (invoke "f32x4.convert_i32x4_u" (v128.const i32x4 0 -1 0x7fffffff 0x80000000))
                                               (v128.const f32x4 0.0 4294967295.0 2147483647.0 2147483648.0))

;; f64x2.convert_i32x4_s
;; constants copied from test/core/conversions.wast.

(assert_return (invoke "f64x2.convert_low_i32x4_s" (v128.const i32x4 1 1 0 0))
                                                   (v128.const f64x2 1.0 1.0))
(assert_return (invoke "f64x2.convert_low_i32x4_s" (v128.const i32x4 -1 -1 0 0))
                                                   (v128.const f64x2 -1.0 -1.0))
(assert_return (invoke "f64x2.convert_low_i32x4_s" (v128.const i32x4 0 0 0 0))
                                                   (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.convert_low_i32x4_s" (v128.const i32x4 2147483647 2147483647 0 0))
                                                   (v128.const f64x2 2147483647 2147483647))
(assert_return (invoke "f64x2.convert_low_i32x4_s" (v128.const i32x4 -2147483648 -2147483648 0 0))
                                                   (v128.const f64x2 -2147483648 -2147483648))
(assert_return (invoke "f64x2.convert_low_i32x4_s" (v128.const i32x4 987654321 987654321 0 0))
                                                   (v128.const f64x2 987654321 987654321))

;; f64x2.convert_i32x4_u
;; constants copied from test/core/conversions.wast.

(assert_return (invoke "f64x2.convert_low_i32x4_u" (v128.const i32x4 1 1 0 0))
                                                   (v128.const f64x2 1.0 1.0))
(assert_return (invoke "f64x2.convert_low_i32x4_u" (v128.const i32x4 0 0 0 0))
                                                   (v128.const f64x2 0.0 0.0))
(assert_return (invoke "f64x2.convert_low_i32x4_u" (v128.const i32x4 2147483647 2147483647 0 0))
                                                   (v128.const f64x2 2147483647 2147483647))
(assert_return (invoke "f64x2.convert_low_i32x4_u" (v128.const i32x4 -2147483648 -2147483648 0 0))
                                                   (v128.const f64x2 2147483648 2147483648))
(assert_return (invoke "f64x2.convert_low_i32x4_u" (v128.const i32x4 0xffffffff 0xffffffff 0 0))
                                                   (v128.const f64x2 4294967295.0 4294967295.0))

;; Integer to integer narrowing
;; i8x16.narrow_i16x8_s

(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                              (v128.const i16x8 0 0 0 0 0 0 0 0))
                                              (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                              (v128.const i16x8 1 1 1 1 1 1 1 1))
                                              (v128.const i8x16 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                              (v128.const i16x8 0 0 0 0 0 0 0 0))
                                              (v128.const i8x16 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                              (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                              (v128.const i8x16 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                              (v128.const i16x8 0 0 0 0 0 0 0 0))
                                              (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                              (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                              (v128.const i8x16 1 1 1 1 1 1 1 1 -1 -1 -1 -1 -1 -1 -1 -1))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                              (v128.const i16x8 1 1 1 1 1 1 1 1))
                                              (v128.const i8x16 -1 -1 -1 -1 -1 -1 -1 -1 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e)
                                              (v128.const i16x8 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
                                              (v128.const i8x16 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f)
                                              (v128.const i16x8 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e))
                                              (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f)
                                              (v128.const i16x8 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
                                              (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                              (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
                                              (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f)
                                              (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
                                              (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                              (v128.const i16x8 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
                                              (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f)
                                              (v128.const i16x8 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
                                              (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff)
                                              (v128.const i16x8 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
                                              (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 -0x7f -0x7f -0x7f -0x7f -0x7f -0x7f -0x7f -0x7f)
                                              (v128.const i16x8 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80))
                                              (v128.const i8x16 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80)
                                              (v128.const i16x8 -0x7f -0x7f -0x7f -0x7f -0x7f -0x7f -0x7f -0x7f))
                                              (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x81 0x81 0x81 0x81 0x81 0x81 0x81 0x81))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80)
                                              (v128.const i16x8 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80))
                                              (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 -0x81 -0x81 -0x81 -0x81 -0x81 -0x81 -0x81 -0x81)
                                              (v128.const i16x8 -0x81 -0x81 -0x81 -0x81 -0x81 -0x81 -0x81 -0x81))
                                              (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 -0x81 -0x81 -0x81 -0x81 -0x81 -0x81 -0x81 -0x81)
                                              (v128.const i16x8 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80))
                                              (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80)
                                              (v128.const i16x8 -0x81 -0x81 -0x81 -0x81 -0x81 -0x81 -0x81 -0x81))
                                              (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80)
                                              (v128.const i16x8 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
                                              (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80)
                                              (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
                                              (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 -0x81 -0x81 -0x81 -0x81 -0x81 -0x81 -0x81 -0x81)
                                              (v128.const i16x8 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
                                              (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80 -0x80)
                                              (v128.const i16x8 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
                                              (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 -0x81 -0x81 -0x81 -0x81 -0x81 -0x81 -0x81 -0x81)
                                              (v128.const i16x8 0x100 0x100 0x100 0x100 0x100 0x100 0x100 0x100))
                                              (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 -0x8000 -0x8000 -0x8000 -0x8000 -0x8000 -0x8000 -0x8000 -0x8000)
                                              (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                              (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 012_345 012_345 012_345 012_345 012_345 012_345 012_345 012_345)
                                              (v128.const i16x8 056_789 056_789 056_789 056_789 056_789 056_789 056_789 056_789))
                                              (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.narrow_i16x8_s" (v128.const i16x8 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234)
                                              (v128.const i16x8 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678 0x0_5678))
                                              (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
;; i8x16.narrow_i16x8_u

(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                              (v128.const i16x8 0 0 0 0 0 0 0 0))
                                              (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                              (v128.const i16x8 1 1 1 1 1 1 1 1))
                                              (v128.const i8x16 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                              (v128.const i16x8 0 0 0 0 0 0 0 0))
                                              (v128.const i8x16 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                              (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                              (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                              (v128.const i16x8 0 0 0 0 0 0 0 0))
                                              (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 1 1 1 1 1 1 1 1)
                                              (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1))
                                              (v128.const i8x16 1 1 1 1 1 1 1 1 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                              (v128.const i16x8 1 1 1 1 1 1 1 1))
                                              (v128.const i8x16 0 0 0 0 0 0 0 0 1 1 1 1 1 1 1 1))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e)
                                              (v128.const i16x8 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
                                              (v128.const i8x16 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f)
                                              (v128.const i16x8 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e))
                                              (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e 0x7e))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f)
                                              (v128.const i16x8 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
                                              (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                              (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
                                              (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f)
                                              (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
                                              (v128.const i8x16 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80)
                                              (v128.const i16x8 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
                                              (v128.const i8x16 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x80 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f 0x7f))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 0xfe 0xfe 0xfe 0xfe 0xfe 0xfe 0xfe 0xfe)
                                              (v128.const i16x8 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
                                              (v128.const i8x16 0xfe 0xfe 0xfe 0xfe 0xfe 0xfe 0xfe 0xfe 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff)
                                              (v128.const i16x8 0xfe 0xfe 0xfe 0xfe 0xfe 0xfe 0xfe 0xfe))
                                              (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xfe 0xfe 0xfe 0xfe 0xfe 0xfe 0xfe 0xfe))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff)
                                              (v128.const i16x8 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
                                              (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 0x100 0x100 0x100 0x100 0x100 0x100 0x100 0x100)
                                              (v128.const i16x8 0x100 0x100 0x100 0x100 0x100 0x100 0x100 0x100))
                                              (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff)
                                              (v128.const i16x8 0x100 0x100 0x100 0x100 0x100 0x100 0x100 0x100))
                                              (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 0x100 0x100 0x100 0x100 0x100 0x100 0x100 0x100)
                                              (v128.const i16x8 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
                                              (v128.const i8x16 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                              (v128.const i16x8 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
                                              (v128.const i8x16 0 0 0 0 0 0 0 0 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 0 0 0 0 0 0 0 0)
                                              (v128.const i16x8 0x100 0x100 0x100 0x100 0x100 0x100 0x100 0x100))
                                              (v128.const i8x16 0 0 0 0 0 0 0 0 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                              (v128.const i16x8 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
                                              (v128.const i8x16 0 0 0 0 0 0 0 0 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 -1 -1 -1 -1 -1 -1 -1 -1)
                                              (v128.const i16x8 0x100 0x100 0x100 0x100 0x100 0x100 0x100 0x100))
                                              (v128.const i8x16 0 0 0 0 0 0 0 0 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 -0x8000 -0x8000 -0x8000 -0x8000 -0x8000 -0x8000 -0x8000 -0x8000)
                                              (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
                                              (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 056_789 056_789 056_789 056_789 056_789 056_789 056_789 056_789)
                                              (v128.const i16x8 012_345 012_345 012_345 012_345 012_345 012_345 012_345 012_345))
                                              (v128.const i8x16 0 0 0 0 0 0 0 0 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
(assert_return (invoke "i8x16.narrow_i16x8_u" (v128.const i16x8 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB 0x0_90AB)
                                              (v128.const i16x8 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234 0x0_1234))
                                              (v128.const i8x16 0 0 0 0 0 0 0 0 0xff 0xff 0xff 0xff 0xff 0xff 0xff 0xff))
;; i16x8.narrow_i32x4_s

(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 0 0 0 0)
                                              (v128.const i32x4 0 0 0 0))
                                              (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 0 0 0 0)
                                              (v128.const i32x4 1 1 1 1))
                                              (v128.const i16x8 0 0 0 0 1 1 1 1))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 1 1 1 1)
                                              (v128.const i32x4 0 0 0 0))
                                              (v128.const i16x8 1 1 1 1 0 0 0 0))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 0 0 0 0)
                                              (v128.const i32x4 -1 -1 -1 -1))
                                              (v128.const i16x8 0 0 0 0 -1 -1 -1 -1))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 -1 -1 -1 -1)
                                              (v128.const i32x4 0 0 0 0))
                                              (v128.const i16x8 -1 -1 -1 -1 0 0 0 0))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 1 1 1 1)
                                              (v128.const i32x4 -1 -1 -1 -1))
                                              (v128.const i16x8 1 1 1 1 -1 -1 -1 -1))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 -1 -1 -1 -1)
                                              (v128.const i32x4 1 1 1 1))
                                              (v128.const i16x8 -1 -1 -1 -1 1 1 1 1))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 0x7ffe 0x7ffe 0x7ffe 0x7ffe)
                                              (v128.const i32x4 0x7fff 0x7fff 0x7fff 0x7fff))
                                              (v128.const i16x8 0x7ffe 0x7ffe 0x7ffe 0x7ffe 0x7fff 0x7fff 0x7fff 0x7fff))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 0x7fff 0x7fff 0x7fff 0x7fff)
                                              (v128.const i32x4 0x7ffe 0x7ffe 0x7ffe 0x7ffe))
                                              (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7ffe 0x7ffe 0x7ffe 0x7ffe))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 0x7fff 0x7fff 0x7fff 0x7fff)
                                              (v128.const i32x4 0x7fff 0x7fff 0x7fff 0x7fff))
                                              (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 0x8000 0x8000 0x8000 0x8000)
                                              (v128.const i32x4 0x8000 0x8000 0x8000 0x8000))
                                              (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 0x7fff 0x7fff 0x7fff 0x7fff)
                                              (v128.const i32x4 0x8000 0x8000 0x8000 0x8000))
                                              (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 0x8000 0x8000 0x8000 0x8000)
                                              (v128.const i32x4 0x7fff 0x7fff 0x7fff 0x7fff))
                                              (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 0x7fff 0x7fff 0x7fff 0x7fff)
                                              (v128.const i32x4 0xffff 0xffff 0xffff 0xffff))
                                              (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 0xffff 0xffff 0xffff 0xffff)
                                              (v128.const i32x4 0x7fff 0x7fff 0x7fff 0x7fff))
                                              (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 -0x7fff -0x7fff -0x7fff -0x7fff)
                                              (v128.const i32x4 -0x8000 -0x8000 -0x8000 -0x8000))
                                              (v128.const i16x8 0x8001 0x8001 0x8001 0x8001 0x8000 0x8000 0x8000 0x8000))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 -0x8000 -0x8000 -0x8000 -0x8000)
                                              (v128.const i32x4 -0x7fff -0x7fff -0x7fff -0x7fff))
                                              (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8001 0x8001 0x8001 0x8001))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 -0x8000 -0x8000 -0x8000 -0x8000)
                                              (v128.const i32x4 -0x8000 -0x8000 -0x8000 -0x8000))
                                              (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 -0x8001 -0x8001 -0x8001 -0x8001)
                                              (v128.const i32x4 -0x8001 -0x8001 -0x8001 -0x8001))
                                              (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 -0x8001 -0x8001 -0x8001 -0x8001)
                                              (v128.const i32x4 -0x8000 -0x8000 -0x8000 -0x8000))
                                              (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 -0x8000 -0x8000 -0x8000 -0x8000)
                                              (v128.const i32x4 -0x8001 -0x8001 -0x8001 -0x8001))
                                              (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000 0x8000))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 -0x8000 -0x8000 -0x8000 -0x8000)
                                              (v128.const i32x4 0x7fff 0x7fff 0x7fff 0x7fff))
                                              (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x7fff 0x7fff 0x7fff 0x7fff))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 -0x8000 -0x8000 -0x8000 -0x8000)
                                              (v128.const i32x4 0x8000 0x8000 0x8000 0x8000))
                                              (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x7fff 0x7fff 0x7fff 0x7fff))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 -0x8001 -0x8001 -0x8001 -0x8001)
                                              (v128.const i32x4 0x7fff 0x7fff 0x7fff 0x7fff))
                                              (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x7fff 0x7fff 0x7fff 0x7fff))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 -0x8000 -0x8000 -0x8000 -0x8000)
                                              (v128.const i32x4 0xffff 0xffff 0xffff 0xffff))
                                              (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x7fff 0x7fff 0x7fff 0x7fff))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 -0x8001 -0x8001 -0x8001 -0x8001)
                                              (v128.const i32x4 0x10000 0x10000 0x10000 0x10000))
                                              (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x7fff 0x7fff 0x7fff 0x7fff))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 -0x8000000 -0x8000000 -0x8000000 -0x8000000)
                                              (v128.const i32x4 0xffffffff 0xffffffff 0xffffffff 0xffffffff))
                                              (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0xffff 0xffff 0xffff 0xffff))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 0_123_456_789 0_123_456_789 0_123_456_789 0_123_456_789)
                                              (v128.const i32x4 01_234_567_890 01_234_567_890 01_234_567_890 01_234_567_890))
                                              (v128.const i16x8 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff 0x7fff))
(assert_return (invoke "i16x8.narrow_i32x4_s" (v128.const i32x4 0x0_90AB_cdef 0x0_90AB_cdef 0x0_90AB_cdef 0x0_90AB_cdef)
                                              (v128.const i32x4 0x0_1234_5678 0x0_1234_5678 0x0_1234_5678 0x0_1234_5678))
                                              (v128.const i16x8 0x8000 0x8000 0x8000 0x8000 0x7fff 0x7fff 0x7fff 0x7fff))
;; i16x8.narrow_i32x4_u

(assert_return (invoke "i16x8.narrow_i32x4_u" (v128.const i32x4 0 0 0 0)
                                              (v128.const i32x4 0 0 0 0))
                                              (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.narrow_i32x4_u" (v128.const i32x4 0 0 0 0)
                                              (v128.const i32x4 1 1 1 1))
                                              (v128.const i16x8 0 0 0 0 1 1 1 1))
(assert_return (invoke "i16x8.narrow_i32x4_u" (v128.const i32x4 1 1 1 1)
                                              (v128.const i32x4 0 0 0 0))
                                              (v128.const i16x8 1 1 1 1 0 0 0 0))
(assert_return (invoke "i16x8.narrow_i32x4_u" (v128.const i32x4 0 0 0 0)
                                              (v128.const i32x4 -1 -1 -1 -1))
                                              (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.narrow_i32x4_u" (v128.const i32x4 -1 -1 -1 -1)
                                              (v128.const i32x4 0 0 0 0))
                                              (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.narrow_i32x4_u" (v128.const i32x4 1 1 1 1)
                                              (v128.const i32x4 -1 -1 -1 -1))
                                              (v128.const i16x8 1 1 1 1 0 0 0 0))
(assert_return (invoke "i16x8.narrow_i32x4_u" (v128.const i32x4 -1 -1 -1 -1)
                                              (v128.const i32x4 1 1 1 1))
                                              (v128.const i16x8 0 0 0 0 1 1 1 1))
(assert_return (invoke "i16x8.narrow_i32x4_u" (v128.const i32x4 0xfffe 0xfffe 0xfffe 0xfffe)
                                              (v128.const i32x4 0xffff 0xffff 0xffff 0xffff))
                                              (v128.const i16x8 0xfffe 0xfffe 0xfffe 0xfffe 0xffff 0xffff 0xffff 0xffff))
(assert_return (invoke "i16x8.narrow_i32x4_u" (v128.const i32x4 0xffff 0xffff 0xffff 0xffff)
                                              (v128.const i32x4 0xfffe 0xfffe 0xfffe 0xfffe))
                                              (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xfffe 0xfffe 0xfffe 0xfffe))
(assert_return (invoke "i16x8.narrow_i32x4_u" (v128.const i32x4 0xffff 0xffff 0xffff 0xffff)
                                              (v128.const i32x4 0xffff 0xffff 0xffff 0xffff))
                                              (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
(assert_return (invoke "i16x8.narrow_i32x4_u" (v128.const i32x4 0x10000 0x10000 0x10000 0x10000)
                                              (v128.const i32x4 0x10000 0x10000 0x10000 0x10000))
                                              (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
(assert_return (invoke "i16x8.narrow_i32x4_u" (v128.const i32x4 0xffff 0xffff 0xffff 0xffff)
                                              (v128.const i32x4 0x10000 0x10000 0x10000 0x10000))
                                              (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
(assert_return (invoke "i16x8.narrow_i32x4_u" (v128.const i32x4 0x10000 0x10000 0x10000 0x10000)
                                              (v128.const i32x4 0xffff 0xffff 0xffff 0xffff))
                                              (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
(assert_return (invoke "i16x8.narrow_i32x4_u" (v128.const i32x4 0 0 0 0)
                                              (v128.const i32x4 0xffff 0xffff 0xffff 0xffff))
                                              (v128.const i16x8 0 0 0 0 0xffff 0xffff 0xffff 0xffff))
(assert_return (invoke "i16x8.narrow_i32x4_u" (v128.const i32x4 0 0 0 0)
                                              (v128.const i32x4 0x10000 0x10000 0x10000 0x10000))
                                              (v128.const i16x8 0 0 0 0 0xffff 0xffff 0xffff 0xffff))
(assert_return (invoke "i16x8.narrow_i32x4_u" (v128.const i32x4 -1 -1 -1 -1)
                                              (v128.const i32x4 0xffff 0xffff 0xffff 0xffff))
                                              (v128.const i16x8 0 0 0 0 0xffff 0xffff 0xffff 0xffff))
(assert_return (invoke "i16x8.narrow_i32x4_u" (v128.const i32x4 -1 -1 -1 -1)
                                              (v128.const i32x4 0x10000 0x10000 0x10000 0x10000))
                                              (v128.const i16x8 0 0 0 0 0xffff 0xffff 0xffff 0xffff))
(assert_return (invoke "i16x8.narrow_i32x4_u" (v128.const i32x4 -0x80000000 -0x80000000 -0x80000000 -0x80000000)
                                              (v128.const i32x4 0xffffffff 0xffffffff 0xffffffff 0xffffffff))
                                              (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8.narrow_i32x4_u" (v128.const i32x4 0_123_456_789 0_123_456_789 0_123_456_789 0_123_456_789)
                                              (v128.const i32x4 01_234_567_890 01_234_567_890 01_234_567_890 01_234_567_890))
                                              (v128.const i16x8 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff 0xffff))
(assert_return (invoke "i16x8.narrow_i32x4_u" (v128.const i32x4 0x0_90AB_cdef 0x0_90AB_cdef 0x0_90AB_cdef 0x0_90AB_cdef)
                                              (v128.const i32x4 0x0_1234_5678 0x0_1234_5678 0x0_1234_5678 0x0_1234_5678))
                                              (v128.const i16x8 0 0 0 0 0xffff 0xffff 0xffff 0xffff))


;; Unknown operator

(assert_malformed (module quote
  "(func (result v128) (i32x4.trunc_sat_f32x4 (v128.const f32x4 0.0 0.0 0.0 0.0)))")
  "unknown operator")
(assert_malformed (module quote
  "(func (result v128) (i32x4.trunc_s_sat_f32x4 (v128.const f32x4 -2.0 -1.0 1.0 2.0)))")
  "unknown operator")
(assert_malformed (module quote
  "(func (result v128) (i32x4.trunc_u_sat_f32x4 (v128.const f32x4 -2.0 -1.0 1.0 2.0)))")
  "unknown operator")
(assert_malformed (module quote
  "(func (result v128) (i32x4.convert_f32x4 (v128.const f32x4 -1 0 1 2)))")
  "unknown operator")
(assert_malformed (module quote
  "(func (result v128) (i32x4.convert_s_f32x4 (v128.const f32x4 -1 0 1 2)))")
  "unknown operator")
(assert_malformed (module quote
  "(func (result v128) (i32x4.convert_u_f32x4 (v128.const f32x4 -1 0 1 2)))")
  "unknown operator")

(assert_malformed (module quote
  "(func (result v128) (i64x2.trunc_sat_f64x2_s (v128.const f64x2 0.0 0.0)))")
  "unknown operator")
(assert_malformed (module quote
  "(func (result v128) (i64x2.trunc_sat_f64x2_u (v128.const f64x2 -2.0 -1.0)))")
  "unknown operator")
(assert_malformed (module quote
  "(func (result v128) (f64x2.convert_i64x2_s (v128.const i64x2 1 2)))")
  "unknown operator")
(assert_malformed (module quote
  "(func (result v128) (f64x2.convert_i64x2_u (v128.const i64x2 1 2)))")
  "unknown operator")

(assert_malformed (module quote
    "(func (result v128) (i8x16.narrow_i16x8 (v128.const i16x8 0 0 0 0 0 0 0 0) (v128.const i16x8 0 0 0 0 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i16x8.narrow_i8x16 (v128.const i16x8 0 0 0 0 0 0 0 0) (v128.const i16x8 0 0 0 0 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i16x8.narrow_i8x16_s (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i16x8.narrow_i8x16_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i16x8.narrow_i32x4 (v128.const i16x8 0 0 0 0 0 0 0 0) (v128.const i16x8 0 0 0 0 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i32x4.narrow_i16x8 (v128.const i16x8 0 0 0 0 0 0 0 0) (v128.const i16x8 0 0 0 0 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i32x4.narrow_i16x8_s (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i32x4.narrow_i16x8_u (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0) (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)))")
    "unknown operator")

(assert_malformed (module quote
    "(func (result v128) (i16x8.extend_low_i8x16 (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i8x16.extend_low_i16x8_s (v128.const i16x8 0 0 0 0 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i8x16.extend_low_i16x8_u (v128.const i16x8 0 0 0 0 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i16x8.extend_high_i8x16 (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i8x16.extend_high_i16x8_s (v128.const i16x8 0 0 0 0 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i8x16.extend_high_i16x8_u (v128.const i16x8 0 0 0 0 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i32x4.extend_low_i16x8 (v128.const i16x8 0 0 0 0 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i16x8.extend_low_i32x4_s (v128.const i32x4 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i16x8.extend_low_i32x4_u (v128.const i32x4 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i32x4.extend_high_i16x8 (v128.const i16x8 0 0 0 0 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i16x8.extend_high_i32x4_s (v128.const i32x4 0 0 0 0)))")
    "unknown operator")
(assert_malformed (module quote
    "(func (result v128) (i16x8.extend_high_i32x4_u (v128.const i32x4 0 0 0 0)))")
    "unknown operator")


;; Type mismatch

(assert_invalid (module (func (result v128) (f32x4.convert_i32x4_s (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f32x4.convert_i32x4_s (i64.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f32x4.convert_i32x4_u (i32.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (f32x4.convert_i32x4_u (i64.const 0)))) "type mismatch")

(assert_invalid (module (func (result v128) (i8x16.narrow_i16x8_s (i32.const 0) (i64.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i8x16.narrow_i16x8_u (i32.const 0) (i64.const 0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i16x8.narrow_i32x4_s (f32.const 0.0) (f64.const 0.0)))) "type mismatch")
(assert_invalid (module (func (result v128) (i16x8.narrow_i32x4_s (f32.const 0.0) (f64.const 0.0)))) "type mismatch")


;; Combinations

(module
  (func (export "f32x4_convert_i32x4_s_add") (param v128 v128) (result v128)
    (f32x4.convert_i32x4_s (i32x4.add (local.get 0) (local.get 1))))
  (func (export "f32x4_convert_i32x4_s_sub") (param  v128 v128) (result v128)
    (f32x4.convert_i32x4_s (i32x4.sub (local.get 0) (local.get 1))))
  (func (export "f32x4_convert_i32x4_u_mul") (param  v128 v128) (result v128)
    (f32x4.convert_i32x4_u (i32x4.mul (local.get 0) (local.get 1))))

  (func (export "i16x8_low_extend_narrow_ss") (param v128 v128) (result v128)
    (i16x8.extend_low_i8x16_s (i8x16.narrow_i16x8_s (local.get 0) (local.get 1))))
  (func (export "i16x8_low_extend_narrow_su") (param v128 v128) (result v128)
    (i16x8.extend_low_i8x16_s (i8x16.narrow_i16x8_u (local.get 0) (local.get 1))))
  (func (export "i16x8_high_extend_narrow_ss") (param v128 v128) (result v128)
    (i16x8.extend_low_i8x16_s (i8x16.narrow_i16x8_s (local.get 0) (local.get 1))))
  (func (export "i16x8_high_extend_narrow_su") (param v128 v128) (result v128)
    (i16x8.extend_low_i8x16_s (i8x16.narrow_i16x8_u (local.get 0) (local.get 1))))
  (func (export "i16x8_low_extend_narrow_uu") (param v128 v128) (result v128)
    (i16x8.extend_low_i8x16_u (i8x16.narrow_i16x8_u (local.get 0) (local.get 1))))
  (func (export "i16x8_low_extend_narrow_us") (param v128 v128) (result v128)
    (i16x8.extend_low_i8x16_u (i8x16.narrow_i16x8_s (local.get 0) (local.get 1))))
  (func (export "i16x8_high_extend_narrow_uu") (param v128 v128) (result v128)
    (i16x8.extend_low_i8x16_u (i8x16.narrow_i16x8_u (local.get 0) (local.get 1))))
  (func (export "i16x8_high_extend_narrow_us") (param v128 v128) (result v128)
    (i16x8.extend_low_i8x16_u (i8x16.narrow_i16x8_s (local.get 0) (local.get 1))))

  (func (export "i32x4_low_extend_narrow_ss") (param v128 v128) (result v128)
    (i32x4.extend_low_i16x8_s (i16x8.narrow_i32x4_s (local.get 0) (local.get 1))))
  (func (export "i32x4_low_extend_narrow_su") (param v128 v128) (result v128)
    (i32x4.extend_low_i16x8_s (i16x8.narrow_i32x4_u (local.get 0) (local.get 1))))
  (func (export "i32x4_high_extend_narrow_ss") (param v128 v128) (result v128)
    (i32x4.extend_low_i16x8_s (i16x8.narrow_i32x4_s (local.get 0) (local.get 1))))
  (func (export "i32x4_high_extend_narrow_su") (param v128 v128) (result v128)
    (i32x4.extend_low_i16x8_s (i16x8.narrow_i32x4_u (local.get 0) (local.get 1))))
  (func (export "i32x4_low_extend_narrow_uu") (param v128 v128) (result v128)
    (i32x4.extend_low_i16x8_u (i16x8.narrow_i32x4_u (local.get 0) (local.get 1))))
  (func (export "i32x4_low_extend_narrow_us") (param v128 v128) (result v128)
    (i32x4.extend_low_i16x8_u (i16x8.narrow_i32x4_s (local.get 0) (local.get 1))))
  (func (export "i32x4_high_extend_narrow_uu") (param v128 v128) (result v128)
    (i32x4.extend_low_i16x8_u (i16x8.narrow_i32x4_u (local.get 0) (local.get 1))))
  (func (export "i32x4_high_extend_narrow_us") (param v128 v128) (result v128)
    (i32x4.extend_low_i16x8_u (i16x8.narrow_i32x4_s (local.get 0) (local.get 1))))
)

(assert_return (invoke "f32x4_convert_i32x4_s_add" (v128.const i32x4 1 2 3 4)
                                                   (v128.const i32x4 2 3 4 5))
                                                   (v128.const f32x4 3.0 5.0 7.0 9.0))
(assert_return (invoke "f32x4_convert_i32x4_s_sub" (v128.const i32x4 0 1 2 3)
                                                   (v128.const i32x4 1 1 1 1))
                                                   (v128.const f32x4 -1.0 0.0 1.0 2.0))
(assert_return (invoke "f32x4_convert_i32x4_u_mul" (v128.const i32x4 1 2 3 4)
                                                   (v128.const i32x4 1 2 3 4))
                                                   (v128.const f32x4 1.0 4.0 9.0 16.0))

(assert_return (invoke "i16x8_low_extend_narrow_ss" (v128.const i16x8 -0x8000 -0x7fff 0x7fff 0x8000 -0x8000 -0x7fff 0x7fff 0x8000)
                                                    (v128.const i16x8 -0x8000 -0x7fff 0x7fff 0x8000 -0x8000 -0x7fff 0x7fff 0x8000))
                                                    (v128.const i16x8 0xff80 0xff80 0x7f 0xff80 0xff80 0xff80 0x7f 0xff80))
(assert_return (invoke "i16x8_low_extend_narrow_su" (v128.const i16x8 -0x8000 -0x7fff 0x7fff 0xffff -0x8000 -0x7fff 0x7fff 0xffff)
                                                    (v128.const i16x8 -0x8000 -0x7fff 0x7fff 0xffff -0x8000 -0x7fff 0x7fff 0xffff))
                                                    (v128.const i16x8 0 0 0xffff 0 0 0 0xffff 0))
(assert_return (invoke "i16x8_high_extend_narrow_ss" (v128.const i16x8 -0x8000 -0x7fff 0x7fff 0x8000 -0x8000 -0x7fff 0x7fff 0x8000)
                                                     (v128.const i16x8 -0x8000 -0x7fff 0x7fff 0x8000 -0x8000 -0x7fff 0x7fff 0x8000))
                                                     (v128.const i16x8 0xff80 0xff80 0x7f 0xff80 0xff80 0xff80 0x7f 0xff80))
(assert_return (invoke "i16x8_high_extend_narrow_su" (v128.const i16x8 -0x8000 -0x7fff 0x7fff 0xffff -0x8000 -0x7fff 0x7fff 0xffff)
                                                     (v128.const i16x8 -0x8000 -0x7fff 0x7fff 0xffff -0x8000 -0x7fff 0x7fff 0xffff))
                                                     (v128.const i16x8 0 0 0xffff 0 0 0 0xffff 0))
(assert_return (invoke "i16x8_low_extend_narrow_uu" (v128.const i16x8 -0x8000 -0x7fff 0x8000 0xffff -0x8000 -0x7fff 0x8000 0xffff)
                                                    (v128.const i16x8 -0x8000 -0x7fff 0x8000 0xffff -0x8000 -0x7fff 0x8000 0xffff))
                                                    (v128.const i16x8 0 0 0 0 0 0 0 0))
(assert_return (invoke "i16x8_low_extend_narrow_us" (v128.const i16x8 -0x8000 -0x7fff 0x7fff 0x8000 -0x8000 -0x7fff 0x7fff 0x8000)
                                                    (v128.const i16x8 -0x8000 -0x7fff 0x7fff 0x8000 -0x8000 -0x7fff 0x7fff 0x8000))
                                                    (v128.const i16x8 0x80 0x80 0x7f 0x80 0x80 0x80 0x7f 0x80))
(assert_return (invoke "i16x8_high_extend_narrow_uu" (v128.const i16x8 -0x8000 -0x7fff 0x7fff 0xffff -0x8000 -0x7fff 0x7fff 0xffff)
                                                     (v128.const i16x8 -0x8000 -0x7fff 0x7fff 0xffff -0x8000 -0x7fff 0x7fff 0xffff))
                                                     (v128.const i16x8 0 0 0xff 0 0 0 0xff 0))
(assert_return (invoke "i16x8_high_extend_narrow_us" (v128.const i16x8 -0x8000 -0x7fff 0x7fff 0x8000 -0x8000 -0x7fff 0x7fff 0x8000)
                                                     (v128.const i16x8 -0x8000 -0x7fff 0x7fff 0x8000 -0x8000 -0x7fff 0x7fff 0x8000))
                                                     (v128.const i16x8 0x80 0x80 0x7f 0x80 0x80 0x80 0x7f 0x80))

(assert_return (invoke "i32x4_low_extend_narrow_ss" (v128.const i32x4 -0x80000000 -0x7fffffff 0x7fffffff 0x8000000)
                                                    (v128.const i32x4 -0x80000000 -0x7fffffff 0x7fffffff 0x8000000))
                                                    (v128.const i32x4 0xffff8000 0xffff8000 0x7fff 0x7fff))
(assert_return (invoke "i32x4_low_extend_narrow_su" (v128.const i32x4 -0x80000000 -0x7fffffff 0x7fffffff 0xffffffff)
                                                    (v128.const i32x4 -0x80000000 -0x7fffffff 0x7fffffff 0xffffffff))
                                                    (v128.const i32x4 0 0 0xffffffff 0))
(assert_return (invoke "i32x4_high_extend_narrow_ss" (v128.const i32x4 -0x80000000 -0x7fffffff 0x7fffffff 0x8000000)
                                                     (v128.const i32x4 -0x80000000 -0x7fffffff 0x7fffffff 0x8000000))
                                                     (v128.const i32x4 0xffff8000 0xffff8000 0x7fff 0x7fff))
(assert_return (invoke "i32x4_high_extend_narrow_su" (v128.const i32x4 -0x80000000 -0x7fffffff 0x7fffffff 0xffffffff)
                                                     (v128.const i32x4 -0x80000000 -0x7fffffff 0x7fffffff 0xffffffff))
                                                     (v128.const i32x4 0 0 0xffffffff 0))
(assert_return (invoke "i32x4_low_extend_narrow_uu" (v128.const i32x4 -0x80000000 -0x7fffffff 0x7fffffff 0xffffffff)
                                                    (v128.const i32x4 -0x80000000 -0x7fffffff 0x7fffffff 0xffffffff))
                                                    (v128.const i32x4 0 0 0xffff 0))
(assert_return (invoke "i32x4_low_extend_narrow_us" (v128.const i32x4 -0x80000000 -0x7fffffff 0x7fffffff 0x8000000)
                                                    (v128.const i32x4 -0x80000000 -0x7fffffff 0x7fffffff 0x8000000))
                                                    (v128.const i32x4 0x8000 0x8000 0x7fff 0x7fff))
(assert_return (invoke "i32x4_high_extend_narrow_uu" (v128.const i32x4 -0x80000000 -0x7fffffff 0x7fffffff 0xffffffff)
                                                     (v128.const i32x4 -0x80000000 -0x7fffffff 0x7fffffff 0xffffffff))
                                                     (v128.const i32x4 0 0 0xffff 0))
(assert_return (invoke "i32x4_high_extend_narrow_us" (v128.const i32x4 -0x80000000 -0x7fffffff 0x7fffffff 0x8000000)
                                                     (v128.const i32x4 -0x80000000 -0x7fffffff 0x7fffffff 0x8000000))
                                                     (v128.const i32x4 0x8000 0x8000 0x7fff 0x7fff))

;; Test operation with empty argument

(assert_invalid
  (module
    (func $f32x4.convert_i32x4_s-arg-empty (result v128)
      (f32x4.convert_i32x4_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $f32x4.convert_i32x4_u-arg-empty (result v128)
      (f32x4.convert_i32x4_u)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.narrow_i16x8_s-1st-arg-empty (result v128)
      (i8x16.narrow_i16x8_s (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.narrow_i16x8_s-arg-empty (result v128)
      (i8x16.narrow_i16x8_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.narrow_i16x8_u-1st-arg-empty (result v128)
      (i8x16.narrow_i16x8_u (v128.const i16x8 0 0 0 0 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i8x16.narrow_i16x8_u-arg-empty (result v128)
      (i8x16.narrow_i16x8_u)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.narrow_i32x4_s-1st-arg-empty (result v128)
      (i16x8.narrow_i32x4_s (v128.const i32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.narrow_i32x4_s-arg-empty (result v128)
      (i16x8.narrow_i32x4_s)
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.narrow_i32x4_u-1st-arg-empty (result v128)
      (i16x8.narrow_i32x4_u (v128.const i32x4 0 0 0 0))
    )
  )
  "type mismatch"
)
(assert_invalid
  (module
    (func $i16x8.narrow_i32x4_u-arg-empty (result v128)
      (i16x8.narrow_i32x4_u)
    )
  )
  "type mismatch"
)
