// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"testing"

	"github.com/stretchr/testify/assert"

	otlpmetrics "go.opentelemetry.io/collector/pdata/internal/data/protogen/metrics/v1"
)

func TestCopyOrigExponentialHistogramDataPointSlice(t *testing.T) {
	src := []*otlpmetrics.ExponentialHistogramDataPoint{}
	dest := []*otlpmetrics.ExponentialHistogramDataPoint{}
	// Test CopyTo empty
	dest = CopyOrigExponentialHistogramDataPointSlice(dest, src)
	assert.Equal(t, []*otlpmetrics.ExponentialHistogramDataPoint{}, dest)

	// Test CopyTo larger slice
	src = GenerateOrigTestExponentialHistogramDataPointSlice()
	dest = CopyOrigExponentialHistogramDataPointSlice(dest, src)
	assert.Equal(t, GenerateOrigTestExponentialHistogramDataPointSlice(), dest)

	// Test CopyTo same size slice
	dest = CopyOrigExponentialHistogramDataPointSlice(dest, src)
	assert.Equal(t, GenerateOrigTestExponentialHistogramDataPointSlice(), dest)

	// Test CopyTo smaller size slice
	dest = CopyOrigExponentialHistogramDataPointSlice(dest, []*otlpmetrics.ExponentialHistogramDataPoint{})
	assert.Len(t, dest, 0)

	// Test CopyTo larger slice with enough capacity
	dest = CopyOrigExponentialHistogramDataPointSlice(dest, src)
	assert.Equal(t, GenerateOrigTestExponentialHistogramDataPointSlice(), dest)
}
