// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"encoding/binary"
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// SpanLink is a pointer from the current span to another span in the same trace or in a
// different trace.
// See Link definition in OTLP: https://github.com/open-telemetry/opentelemetry-proto/blob/main/opentelemetry/proto/trace/v1/trace.proto
type SpanLink struct {
	TraceId                TraceID
	SpanId                 SpanID
	TraceState             string
	Attributes             []KeyValue
	DroppedAttributesCount uint32
	Flags                  uint32
}

var (
	protoPoolSpanLink = sync.Pool{
		New: func() any {
			return &SpanLink{}
		},
	}
)

func NewSpanLink() *SpanLink {
	if !UseProtoPooling.IsEnabled() {
		return &SpanLink{}
	}
	return protoPoolSpanLink.Get().(*SpanLink)
}

func DeleteSpanLink(orig *SpanLink, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	DeleteTraceID(&orig.TraceId, false)
	DeleteSpanID(&orig.SpanId, false)
	for i := range orig.Attributes {
		DeleteKeyValue(&orig.Attributes[i], false)
	}

	orig.Reset()
	if nullable {
		protoPoolSpanLink.Put(orig)
	}
}

func CopySpanLink(dest, src *SpanLink) *SpanLink {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewSpanLink()
	}
	CopyTraceID(&dest.TraceId, &src.TraceId)

	CopySpanID(&dest.SpanId, &src.SpanId)

	dest.TraceState = src.TraceState

	dest.Attributes = CopyKeyValueSlice(dest.Attributes, src.Attributes)

	dest.DroppedAttributesCount = src.DroppedAttributesCount

	dest.Flags = src.Flags

	return dest
}

func CopySpanLinkSlice(dest, src []SpanLink) []SpanLink {
	var newDest []SpanLink
	if cap(dest) < len(src) {
		newDest = make([]SpanLink, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteSpanLink(&dest[i], false)
		}
	}
	for i := range src {
		CopySpanLink(&newDest[i], &src[i])
	}
	return newDest
}

func CopySpanLinkPtrSlice(dest, src []*SpanLink) []*SpanLink {
	var newDest []*SpanLink
	if cap(dest) < len(src) {
		newDest = make([]*SpanLink, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewSpanLink()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteSpanLink(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewSpanLink()
		}
	}
	for i := range src {
		CopySpanLink(newDest[i], src[i])
	}
	return newDest
}

func (orig *SpanLink) Reset() {
	*orig = SpanLink{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *SpanLink) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if !orig.TraceId.IsEmpty() {
		dest.WriteObjectField("traceId")
		orig.TraceId.MarshalJSON(dest)
	}
	if !orig.SpanId.IsEmpty() {
		dest.WriteObjectField("spanId")
		orig.SpanId.MarshalJSON(dest)
	}
	if orig.TraceState != "" {
		dest.WriteObjectField("traceState")
		dest.WriteString(orig.TraceState)
	}
	if len(orig.Attributes) > 0 {
		dest.WriteObjectField("attributes")
		dest.WriteArrayStart()
		orig.Attributes[0].MarshalJSON(dest)
		for i := 1; i < len(orig.Attributes); i++ {
			dest.WriteMore()
			orig.Attributes[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	if orig.DroppedAttributesCount != uint32(0) {
		dest.WriteObjectField("droppedAttributesCount")
		dest.WriteUint32(orig.DroppedAttributesCount)
	}
	if orig.Flags != uint32(0) {
		dest.WriteObjectField("flags")
		dest.WriteUint32(orig.Flags)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *SpanLink) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "traceId", "trace_id":

			orig.TraceId.UnmarshalJSON(iter)
		case "spanId", "span_id":

			orig.SpanId.UnmarshalJSON(iter)
		case "traceState", "trace_state":
			orig.TraceState = iter.ReadString()
		case "attributes":
			for iter.ReadArray() {
				orig.Attributes = append(orig.Attributes, KeyValue{})
				orig.Attributes[len(orig.Attributes)-1].UnmarshalJSON(iter)
			}

		case "droppedAttributesCount", "dropped_attributes_count":
			orig.DroppedAttributesCount = iter.ReadUint32()
		case "flags":
			orig.Flags = iter.ReadUint32()
		default:
			iter.Skip()
		}
	}
}

func (orig *SpanLink) SizeProto() int {
	var n int
	var l int
	_ = l
	l = orig.TraceId.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	l = orig.SpanId.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	l = len(orig.TraceState)
	if l > 0 {
		n += 1 + proto.Sov(uint64(l)) + l
	}
	for i := range orig.Attributes {
		l = orig.Attributes[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.DroppedAttributesCount != 0 {
		n += 1 + proto.Sov(uint64(orig.DroppedAttributesCount))
	}
	if orig.Flags != 0 {
		n += 5
	}
	return n
}

func (orig *SpanLink) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	l = orig.TraceId.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0xa

	l = orig.SpanId.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x12

	l = len(orig.TraceState)
	if l > 0 {
		pos -= l
		copy(buf[pos:], orig.TraceState)
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x1a
	}
	for i := len(orig.Attributes) - 1; i >= 0; i-- {
		l = orig.Attributes[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0x22
	}
	if orig.DroppedAttributesCount != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.DroppedAttributesCount))
		pos--
		buf[pos] = 0x28
	}
	if orig.Flags != 0 {
		pos -= 4
		binary.LittleEndian.PutUint32(buf[pos:], uint32(orig.Flags))
		pos--
		buf[pos] = 0x35
	}
	return len(buf) - pos
}

func (orig *SpanLink) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceId", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.TraceId.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field SpanId", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.SpanId.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 3:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field TraceState", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.TraceState = string(buf[startPos:pos])

		case 4:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Attributes", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.Attributes = append(orig.Attributes, KeyValue{})
			err = orig.Attributes[len(orig.Attributes)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 5:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field DroppedAttributesCount", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.DroppedAttributesCount = uint32(num)

		case 6:
			if wireType != proto.WireTypeI32 {
				return fmt.Errorf("proto: wrong wireType = %d for field Flags", wireType)
			}
			var num uint32
			num, pos, err = proto.ConsumeI32(buf, pos)
			if err != nil {
				return err
			}

			orig.Flags = uint32(num)
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestSpanLink() *SpanLink {
	orig := NewSpanLink()
	orig.TraceId = *GenTestTraceID()
	orig.SpanId = *GenTestSpanID()
	orig.TraceState = "test_tracestate"
	orig.Attributes = []KeyValue{{}, *GenTestKeyValue()}
	orig.DroppedAttributesCount = uint32(13)
	orig.Flags = uint32(13)
	return orig
}

func GenTestSpanLinkPtrSlice() []*SpanLink {
	orig := make([]*SpanLink, 5)
	orig[0] = NewSpanLink()
	orig[1] = GenTestSpanLink()
	orig[2] = NewSpanLink()
	orig[3] = GenTestSpanLink()
	orig[4] = NewSpanLink()
	return orig
}

func GenTestSpanLinkSlice() []SpanLink {
	orig := make([]SpanLink, 5)
	orig[1] = *GenTestSpanLink()
	orig[3] = *GenTestSpanLink()
	return orig
}
