// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package run provides access to the Cloud Run Admin API.
//
// For product documentation, see: https://cloud.google.com/run/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/run/v1"
//	...
//	ctx := context.Background()
//	runService, err := run.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	runService, err := run.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	runService, err := run.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package run // import "google.golang.org/api/run/v1"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "run:v1"
const apiName = "run"
const apiVersion = "v1"
const basePath = "https://run.googleapis.com/"
const basePathTemplate = "https://run.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://run.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new APIService.
func NewService(ctx context.Context, opts ...option.ClientOption) (*APIService, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &APIService{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Namespaces = NewNamespacesService(s)
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new APIService. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*APIService, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type APIService struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Namespaces *NamespacesService

	Projects *ProjectsService
}

func (s *APIService) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewNamespacesService(s *APIService) *NamespacesService {
	rs := &NamespacesService{s: s}
	rs.Authorizeddomains = NewNamespacesAuthorizeddomainsService(s)
	rs.Configurations = NewNamespacesConfigurationsService(s)
	rs.Domainmappings = NewNamespacesDomainmappingsService(s)
	rs.Executions = NewNamespacesExecutionsService(s)
	rs.Jobs = NewNamespacesJobsService(s)
	rs.Revisions = NewNamespacesRevisionsService(s)
	rs.Routes = NewNamespacesRoutesService(s)
	rs.Services = NewNamespacesServicesService(s)
	rs.Tasks = NewNamespacesTasksService(s)
	rs.Workerpools = NewNamespacesWorkerpoolsService(s)
	return rs
}

type NamespacesService struct {
	s *APIService

	Authorizeddomains *NamespacesAuthorizeddomainsService

	Configurations *NamespacesConfigurationsService

	Domainmappings *NamespacesDomainmappingsService

	Executions *NamespacesExecutionsService

	Jobs *NamespacesJobsService

	Revisions *NamespacesRevisionsService

	Routes *NamespacesRoutesService

	Services *NamespacesServicesService

	Tasks *NamespacesTasksService

	Workerpools *NamespacesWorkerpoolsService
}

func NewNamespacesAuthorizeddomainsService(s *APIService) *NamespacesAuthorizeddomainsService {
	rs := &NamespacesAuthorizeddomainsService{s: s}
	return rs
}

type NamespacesAuthorizeddomainsService struct {
	s *APIService
}

func NewNamespacesConfigurationsService(s *APIService) *NamespacesConfigurationsService {
	rs := &NamespacesConfigurationsService{s: s}
	return rs
}

type NamespacesConfigurationsService struct {
	s *APIService
}

func NewNamespacesDomainmappingsService(s *APIService) *NamespacesDomainmappingsService {
	rs := &NamespacesDomainmappingsService{s: s}
	return rs
}

type NamespacesDomainmappingsService struct {
	s *APIService
}

func NewNamespacesExecutionsService(s *APIService) *NamespacesExecutionsService {
	rs := &NamespacesExecutionsService{s: s}
	return rs
}

type NamespacesExecutionsService struct {
	s *APIService
}

func NewNamespacesJobsService(s *APIService) *NamespacesJobsService {
	rs := &NamespacesJobsService{s: s}
	return rs
}

type NamespacesJobsService struct {
	s *APIService
}

func NewNamespacesRevisionsService(s *APIService) *NamespacesRevisionsService {
	rs := &NamespacesRevisionsService{s: s}
	return rs
}

type NamespacesRevisionsService struct {
	s *APIService
}

func NewNamespacesRoutesService(s *APIService) *NamespacesRoutesService {
	rs := &NamespacesRoutesService{s: s}
	return rs
}

type NamespacesRoutesService struct {
	s *APIService
}

func NewNamespacesServicesService(s *APIService) *NamespacesServicesService {
	rs := &NamespacesServicesService{s: s}
	return rs
}

type NamespacesServicesService struct {
	s *APIService
}

func NewNamespacesTasksService(s *APIService) *NamespacesTasksService {
	rs := &NamespacesTasksService{s: s}
	return rs
}

type NamespacesTasksService struct {
	s *APIService
}

func NewNamespacesWorkerpoolsService(s *APIService) *NamespacesWorkerpoolsService {
	rs := &NamespacesWorkerpoolsService{s: s}
	return rs
}

type NamespacesWorkerpoolsService struct {
	s *APIService
}

func NewProjectsService(s *APIService) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Authorizeddomains = NewProjectsAuthorizeddomainsService(s)
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *APIService

	Authorizeddomains *ProjectsAuthorizeddomainsService

	Locations *ProjectsLocationsService
}

func NewProjectsAuthorizeddomainsService(s *APIService) *ProjectsAuthorizeddomainsService {
	rs := &ProjectsAuthorizeddomainsService{s: s}
	return rs
}

type ProjectsAuthorizeddomainsService struct {
	s *APIService
}

func NewProjectsLocationsService(s *APIService) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Authorizeddomains = NewProjectsLocationsAuthorizeddomainsService(s)
	rs.Configurations = NewProjectsLocationsConfigurationsService(s)
	rs.Domainmappings = NewProjectsLocationsDomainmappingsService(s)
	rs.Jobs = NewProjectsLocationsJobsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.Revisions = NewProjectsLocationsRevisionsService(s)
	rs.Routes = NewProjectsLocationsRoutesService(s)
	rs.Services = NewProjectsLocationsServicesService(s)
	rs.Workerpools = NewProjectsLocationsWorkerpoolsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *APIService

	Authorizeddomains *ProjectsLocationsAuthorizeddomainsService

	Configurations *ProjectsLocationsConfigurationsService

	Domainmappings *ProjectsLocationsDomainmappingsService

	Jobs *ProjectsLocationsJobsService

	Operations *ProjectsLocationsOperationsService

	Revisions *ProjectsLocationsRevisionsService

	Routes *ProjectsLocationsRoutesService

	Services *ProjectsLocationsServicesService

	Workerpools *ProjectsLocationsWorkerpoolsService
}

func NewProjectsLocationsAuthorizeddomainsService(s *APIService) *ProjectsLocationsAuthorizeddomainsService {
	rs := &ProjectsLocationsAuthorizeddomainsService{s: s}
	return rs
}

type ProjectsLocationsAuthorizeddomainsService struct {
	s *APIService
}

func NewProjectsLocationsConfigurationsService(s *APIService) *ProjectsLocationsConfigurationsService {
	rs := &ProjectsLocationsConfigurationsService{s: s}
	return rs
}

type ProjectsLocationsConfigurationsService struct {
	s *APIService
}

func NewProjectsLocationsDomainmappingsService(s *APIService) *ProjectsLocationsDomainmappingsService {
	rs := &ProjectsLocationsDomainmappingsService{s: s}
	return rs
}

type ProjectsLocationsDomainmappingsService struct {
	s *APIService
}

func NewProjectsLocationsJobsService(s *APIService) *ProjectsLocationsJobsService {
	rs := &ProjectsLocationsJobsService{s: s}
	return rs
}

type ProjectsLocationsJobsService struct {
	s *APIService
}

func NewProjectsLocationsOperationsService(s *APIService) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *APIService
}

func NewProjectsLocationsRevisionsService(s *APIService) *ProjectsLocationsRevisionsService {
	rs := &ProjectsLocationsRevisionsService{s: s}
	return rs
}

type ProjectsLocationsRevisionsService struct {
	s *APIService
}

func NewProjectsLocationsRoutesService(s *APIService) *ProjectsLocationsRoutesService {
	rs := &ProjectsLocationsRoutesService{s: s}
	return rs
}

type ProjectsLocationsRoutesService struct {
	s *APIService
}

func NewProjectsLocationsServicesService(s *APIService) *ProjectsLocationsServicesService {
	rs := &ProjectsLocationsServicesService{s: s}
	return rs
}

type ProjectsLocationsServicesService struct {
	s *APIService
}

func NewProjectsLocationsWorkerpoolsService(s *APIService) *ProjectsLocationsWorkerpoolsService {
	rs := &ProjectsLocationsWorkerpoolsService{s: s}
	return rs
}

type ProjectsLocationsWorkerpoolsService struct {
	s *APIService
}

// Addressable: Information for connecting over HTTP(s).
type Addressable struct {
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Url") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Url") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Addressable) MarshalJSON() ([]byte, error) {
	type NoMethod Addressable
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuditConfig: Specifies the audit configuration for a service. The
// configuration determines which permission types are logged, and what
// identities, if any, are exempted from logging. An AuditConfig must have one
// or more AuditLogConfigs. If there are AuditConfigs for both `allServices`
// and a specific service, the union of the two AuditConfigs is used for that
// service: the log_types specified in each AuditConfig are enabled, and the
// exempted_members in each AuditLogConfig are exempted. Example Policy with
// multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
// "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
// "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
// "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
// "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
// sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
// logging. It also exempts `jose@example.com` from DATA_READ logging, and
// `aliya@example.com` from DATA_WRITE logging.
type AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of permission.
	AuditLogConfigs []*AuditLogConfig `json:"auditLogConfigs,omitempty"`
	// Service: Specifies a service that will be enabled for audit logging. For
	// example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices`
	// is a special value that covers all services.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditLogConfigs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuditLogConfig: Provides the configuration for logging a type of
// permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ",
// "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
// "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while
// exempting jose@example.com from DATA_READ logging.
type AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging for this
	// type of permission. Follows the same format of Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`
	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExemptedMembers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod AuditLogConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AuthorizedDomain: A domain that a user has been authorized to administer. To
// authorize use of a domain, verify ownership via Search Console
// (https://search.google.com/search-console/welcome).
type AuthorizedDomain struct {
	// Id: Relative name of the domain authorized for use. Example: `example.com`.
	Id string `json:"id,omitempty"`
	// Name: Deprecated Read only. Full path to the `AuthorizedDomain` resource in
	// the API. Example: `projects/myproject/authorizedDomains/example.com`.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Id") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Id") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AuthorizedDomain) MarshalJSON() ([]byte, error) {
	type NoMethod AuthorizedDomain
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Binding: Associates `members`, or principals, with a `role`.
type Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the current
	// request. If the condition evaluates to `false`, then this binding does not
	// apply to the current request. However, a different role binding might grant
	// the same role to one or more of the principals in this binding. To learn
	// which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *Expr `json:"condition,omitempty"`
	// Members: Specifies the principals requesting access for a Google Cloud
	// resource. `members` can have the following values: * `allUsers`: A special
	// identifier that represents anyone who is on the internet; with or without a
	// Google account. * `allAuthenticatedUsers`: A special identifier that
	// represents anyone who is authenticated with a Google account or a service
	// account. Does not include identities that come from external identity
	// providers (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address that
	// represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An
	// identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
	// `group:{emailid}`: An email address that represents a Google group. For
	// example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
	// (primary) that represents all the users of that domain. For example,
	// `google.com` or `example.com`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/sub
	// ject/{subject_attribute_value}`: A single identity in a workforce identity
	// pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// attribute.{attribute_name}/{attribute_value}`: All workforce identities with
	// a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// *`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/global/wo
	// rkloadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
	// identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/group/{group_id}`: A workload identity pool
	// group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}
	// `: All identities in a workload identity pool with a certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/*`: All identities in a workload identity
	// pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently deleted. For
	// example, `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered user
	// retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a service account that has been recently
	// deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
	// service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains the
	// role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email
	// address (plus unique identifier) representing a Google group that has been
	// recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is recovered,
	// this value reverts to `group:{emailid}` and the recovered group retains the
	// role in the binding. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool
	// _id}/subject/{subject_attribute_value}`: Deleted single identity in a
	// workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-po
	// ol-id/subject/my-subject-attribute-value`.
	Members []string `json:"members,omitempty"`
	// Role: Role that is assigned to the list of `members`, or principals. For
	// example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview
	// of the IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Binding) MarshalJSON() ([]byte, error) {
	type NoMethod Binding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CSIVolumeSource: Storage volume source using the Container Storage
// Interface.
type CSIVolumeSource struct {
	// Driver: name of the CSI driver for the requested storage system. Cloud Run
	// supports the following drivers: * gcsfuse.run.googleapis.com : Mount a Cloud
	// Storage Bucket as a volume.
	Driver string `json:"driver,omitempty"`
	// ReadOnly: If true, mount the volume as read only. Defaults to false.
	ReadOnly bool `json:"readOnly,omitempty"`
	// VolumeAttributes: stores driver specific attributes. For Google Cloud
	// Storage volumes, the following attributes are supported: * bucketName: the
	// name of the Cloud Storage bucket to mount. The Cloud Run Service identity
	// must have access to this bucket. * mountOptions: comma-separated list of
	// mount options to pass to the gcsfuse.
	VolumeAttributes map[string]string `json:"volumeAttributes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Driver") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Driver") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CSIVolumeSource) MarshalJSON() ([]byte, error) {
	type NoMethod CSIVolumeSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CancelExecutionRequest: Request message for cancelling an execution.
type CancelExecutionRequest struct {
}

// ConfigMapEnvSource: Not supported by Cloud Run. ConfigMapEnvSource selects a
// ConfigMap to populate the environment variables with. The contents of the
// target ConfigMap's Data field will represent the key-value pairs as
// environment variables.
type ConfigMapEnvSource struct {
	// LocalObjectReference: This field should not be used directly as it is meant
	// to be inlined directly into the message. Use the "name" field instead.
	LocalObjectReference *LocalObjectReference `json:"localObjectReference,omitempty"`
	// Name: The ConfigMap to select from.
	Name string `json:"name,omitempty"`
	// Optional: Specify whether the ConfigMap must be defined.
	Optional bool `json:"optional,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LocalObjectReference") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LocalObjectReference") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigMapEnvSource) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigMapEnvSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigMapKeySelector: Not supported by Cloud Run.
type ConfigMapKeySelector struct {
	// Key: Required. Not supported by Cloud Run.
	Key string `json:"key,omitempty"`
	// LocalObjectReference: Not supported by Cloud Run.
	LocalObjectReference *LocalObjectReference `json:"localObjectReference,omitempty"`
	// Name: Required. Not supported by Cloud Run.
	Name string `json:"name,omitempty"`
	// Optional: Not supported by Cloud Run.
	Optional bool `json:"optional,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigMapKeySelector) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigMapKeySelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigMapVolumeSource: Not supported by Cloud Run. Adapts a ConfigMap into a
// volume. The contents of the target ConfigMap's Data field will be presented
// in a volume as files using the keys in the Data field as the file names,
// unless the items element is populated with specific mappings of keys to
// paths.
type ConfigMapVolumeSource struct {
	// DefaultMode: (Optional) Integer representation of mode bits to use on
	// created files by default. Must be a value between 01 and 0777 (octal). If 0
	// or not set, it will default to 0644. Directories within the path are not
	// affected by this setting. Notes * Internally, a umask of 0222 will be
	// applied to any non-zero value. * This is an integer representation of the
	// mode bits. So, the octal integer value should look exactly as the chmod
	// numeric notation with a leading zero. Some examples: for chmod 777 (a=rwx),
	// set to 0777 (octal) or 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640
	// (octal) or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755
	// (octal) or 493 (base-10). * This might be in conflict with other options
	// that affect the file mode, like fsGroup, and the result can be other mode
	// bits set.
	DefaultMode int64 `json:"defaultMode,omitempty"`
	// Items: (Optional) If unspecified, each key-value pair in the Data field of
	// the referenced Secret will be projected into the volume as a file whose name
	// is the key and content is the value. If specified, the listed keys will be
	// projected into the specified paths, and unlisted keys will not be present.
	// If a key is specified that is not present in the Secret, the volume setup
	// will error unless it is marked optional.
	Items []*KeyToPath `json:"items,omitempty"`
	// Name: Name of the config.
	Name string `json:"name,omitempty"`
	// Optional: (Optional) Specify whether the Secret or its keys must be defined.
	Optional bool `json:"optional,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultMode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigMapVolumeSource) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigMapVolumeSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Configuration: Configuration represents the "floating HEAD" of a linear
// history of Revisions, and optionally how the containers those revisions
// reference are built. Users create new Revisions by updating the
// Configuration's spec. The "latest created" revision's name is available
// under status, as is the "latest ready" revision's name.
type Configuration struct {
	// ApiVersion: The API version for this call such as "serving.knative.dev/v1".
	ApiVersion string `json:"apiVersion,omitempty"`
	// Kind: The kind of resource, in this case always "Configuration".
	Kind string `json:"kind,omitempty"`
	// Metadata: Metadata associated with this Configuration, including name,
	// namespace, labels, and annotations.
	Metadata *ObjectMeta `json:"metadata,omitempty"`
	// Spec: Spec holds the desired state of the Configuration (from the client).
	Spec *ConfigurationSpec `json:"spec,omitempty"`
	// Status: Status communicates the observed state of the Configuration (from
	// the controller).
	Status *ConfigurationStatus `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Configuration) MarshalJSON() ([]byte, error) {
	type NoMethod Configuration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigurationSpec: ConfigurationSpec holds the desired state of the
// Configuration (from the client).
type ConfigurationSpec struct {
	// Template: Template holds the latest specification for the Revision to be
	// stamped out.
	Template *RevisionTemplate `json:"template,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Template") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Template") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigurationSpec) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigurationSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConfigurationStatus: ConfigurationStatus communicates the observed state of
// the Configuration (from the controller).
type ConfigurationStatus struct {
	// Conditions: Conditions communicate information about ongoing/complete
	// reconciliation processes that bring the "spec" inline with the observed
	// state of the world.
	Conditions []*GoogleCloudRunV1Condition `json:"conditions,omitempty"`
	// LatestCreatedRevisionName: LatestCreatedRevisionName is the last revision
	// that was created from this Configuration. It might not be ready yet, so for
	// the latest ready revision, use LatestReadyRevisionName.
	LatestCreatedRevisionName string `json:"latestCreatedRevisionName,omitempty"`
	// LatestReadyRevisionName: LatestReadyRevisionName holds the name of the
	// latest Revision stamped out from this Configuration that has had its "Ready"
	// condition become "True".
	LatestReadyRevisionName string `json:"latestReadyRevisionName,omitempty"`
	// ObservedGeneration: ObservedGeneration is the 'Generation' of the
	// Configuration that was last processed by the controller. The observed
	// generation is updated even if the controller failed to process the spec and
	// create the Revision. Clients polling for completed reconciliation should
	// poll until observedGeneration = metadata.generation, and the Ready
	// condition's status is True or False.
	ObservedGeneration int64 `json:"observedGeneration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conditions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conditions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConfigurationStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ConfigurationStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Container: A single application container. This specifies both the container
// to run, the command to run in the container and the arguments to supply to
// it. Note that additional arguments may be supplied by the system to the
// container at runtime.
type Container struct {
	// Args: Arguments to the entrypoint. The docker image's CMD is used if this is
	// not provided. Variable references are not supported in Cloud Run.
	Args []string `json:"args,omitempty"`
	// Command: Entrypoint array. Not executed within a shell. The docker image's
	// ENTRYPOINT is used if this is not provided. Variable references are not
	// supported in Cloud Run.
	Command []string `json:"command,omitempty"`
	// Env: List of environment variables to set in the container. EnvVar with
	// duplicate names are generally allowed; if referencing a secret, the name
	// must be unique for the container. For non-secret EnvVar names, the Container
	// will only get the last-declared one.
	Env []*EnvVar `json:"env,omitempty"`
	// EnvFrom: Not supported by Cloud Run.
	EnvFrom []*EnvFromSource `json:"envFrom,omitempty"`
	// Image: Required. Name of the container image in Dockerhub, Google Artifact
	// Registry, or Google Container Registry. If the host is not provided,
	// Dockerhub is assumed.
	Image string `json:"image,omitempty"`
	// ImagePullPolicy: Image pull policy. One of Always, Never, IfNotPresent.
	// Defaults to Always if :latest tag is specified, or IfNotPresent otherwise.
	ImagePullPolicy string `json:"imagePullPolicy,omitempty"`
	// LivenessProbe: Periodic probe of container liveness. Container will be
	// restarted if the probe fails.
	LivenessProbe *Probe `json:"livenessProbe,omitempty"`
	// Name: Name of the container specified as a DNS_LABEL (RFC 1123).
	Name string `json:"name,omitempty"`
	// Ports: List of ports to expose from the container. Only a single port can be
	// specified. The specified ports must be listening on all interfaces (0.0.0.0)
	// within the container to be accessible. If omitted, a port number will be
	// chosen and passed to the container through the PORT environment variable for
	// the container to listen on.
	Ports []*ContainerPort `json:"ports,omitempty"`
	// ReadinessProbe: Readiness probe to be used for health checks.
	ReadinessProbe *Probe `json:"readinessProbe,omitempty"`
	// Resources: Compute Resources required by this container.
	Resources *ResourceRequirements `json:"resources,omitempty"`
	// SecurityContext: Not supported by Cloud Run.
	SecurityContext *SecurityContext `json:"securityContext,omitempty"`
	// StartupProbe: Startup probe of application within the container. All other
	// probes are disabled if a startup probe is provided, until it succeeds.
	// Container will not receive traffic if the probe fails. If not provided, a
	// default startup probe with TCP socket action is used.
	StartupProbe *Probe `json:"startupProbe,omitempty"`
	// TerminationMessagePath: Path at which the file to which the container's
	// termination message will be written is mounted into the container's
	// filesystem. Message written is intended to be brief final status, such as an
	// assertion failure message. Will be truncated by the node if greater than
	// 4096 bytes. The total message length across all containers will be limited
	// to 12kb. Defaults to /dev/termination-log.
	TerminationMessagePath string `json:"terminationMessagePath,omitempty"`
	// TerminationMessagePolicy: Indicate how the termination message should be
	// populated. File will use the contents of terminationMessagePath to populate
	// the container status message on both success and failure.
	// FallbackToLogsOnError will use the last chunk of container log output if the
	// termination message file is empty and the container exited with an error.
	// The log output is limited to 2048 bytes or 80 lines, whichever is smaller.
	// Defaults to File. Cannot be updated.
	TerminationMessagePolicy string `json:"terminationMessagePolicy,omitempty"`
	// VolumeMounts: Volume to mount into the container's filesystem. Only supports
	// SecretVolumeSources. Pod volumes to mount into the container's filesystem.
	VolumeMounts []*VolumeMount `json:"volumeMounts,omitempty"`
	// WorkingDir: Container's working directory. If not specified, the container
	// runtime's default will be used, which might be configured in the container
	// image.
	WorkingDir string `json:"workingDir,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Args") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Args") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Container) MarshalJSON() ([]byte, error) {
	type NoMethod Container
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ContainerOverride: Per container override specification.
type ContainerOverride struct {
	// Args: Arguments to the entrypoint. The specified arguments replace and
	// override any existing entrypoint arguments. Must be empty if `clear_args` is
	// set to true.
	Args []string `json:"args,omitempty"`
	// ClearArgs: Optional. Set to True to clear all existing arguments.
	ClearArgs bool `json:"clearArgs,omitempty"`
	// Env: List of environment variables to set in the container. All specified
	// environment variables are merged with existing environment variables. When
	// the specified environment variables exist, these values override any
	// existing values.
	Env []*EnvVar `json:"env,omitempty"`
	// Name: The name of the container specified as a DNS_LABEL.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Args") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Args") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ContainerOverride) MarshalJSON() ([]byte, error) {
	type NoMethod ContainerOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ContainerPort: ContainerPort represents a network port in a single
// container.
type ContainerPort struct {
	// ContainerPort: Port number the container listens on. If present, this must
	// be a valid port number, 0 < x < 65536. If not present, it will default to
	// port 8080. For more information, see
	// https://cloud.google.com/run/docs/container-contract#port
	ContainerPort int64 `json:"containerPort,omitempty"`
	// Name: If specified, used to specify which protocol to use. Allowed values
	// are "http1" and "h2c".
	Name string `json:"name,omitempty"`
	// Protocol: Protocol for port. Must be "TCP". Defaults to "TCP".
	Protocol string `json:"protocol,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContainerPort") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainerPort") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ContainerPort) MarshalJSON() ([]byte, error) {
	type NoMethod ContainerPort
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DomainMapping: Resource to hold the state and status of a user's domain
// mapping. NOTE: This resource is currently in Beta.
type DomainMapping struct {
	// ApiVersion: The API version for this call such as "domains.cloudrun.com/v1".
	ApiVersion string `json:"apiVersion,omitempty"`
	// Kind: The kind of resource, in this case "DomainMapping".
	Kind string `json:"kind,omitempty"`
	// Metadata: Metadata associated with this BuildTemplate.
	Metadata *ObjectMeta `json:"metadata,omitempty"`
	// Spec: The spec for this DomainMapping.
	Spec *DomainMappingSpec `json:"spec,omitempty"`
	// Status: The current status of the DomainMapping.
	Status *DomainMappingStatus `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DomainMapping) MarshalJSON() ([]byte, error) {
	type NoMethod DomainMapping
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DomainMappingSpec: The desired state of the Domain Mapping.
type DomainMappingSpec struct {
	// CertificateMode: The mode of the certificate.
	//
	// Possible values:
	//   "CERTIFICATE_MODE_UNSPECIFIED"
	//   "NONE" - Do not provision an HTTPS certificate.
	//   "AUTOMATIC" - Automatically provisions an HTTPS certificate via GoogleCA.
	CertificateMode string `json:"certificateMode,omitempty"`
	// ForceOverride: If set, the mapping will override any mapping set before this
	// spec was set. It is recommended that the user leaves this empty to receive
	// an error warning about a potential conflict and only set it once the
	// respective UI has given such a warning.
	ForceOverride bool `json:"forceOverride,omitempty"`
	// RouteName: The name of the Knative Route that this DomainMapping applies to.
	// The route must exist.
	RouteName string `json:"routeName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CertificateMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertificateMode") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DomainMappingSpec) MarshalJSON() ([]byte, error) {
	type NoMethod DomainMappingSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DomainMappingStatus: The current state of the Domain Mapping.
type DomainMappingStatus struct {
	// Conditions: Array of observed DomainMappingConditions, indicating the
	// current state of the DomainMapping.
	Conditions []*GoogleCloudRunV1Condition `json:"conditions,omitempty"`
	// MappedRouteName: The name of the route that the mapping currently points to.
	MappedRouteName string `json:"mappedRouteName,omitempty"`
	// ObservedGeneration: ObservedGeneration is the 'Generation' of the
	// DomainMapping that was last processed by the controller. Clients polling for
	// completed reconciliation should poll until observedGeneration =
	// metadata.generation and the Ready condition's status is True or False.
	ObservedGeneration int64 `json:"observedGeneration,omitempty"`
	// ResourceRecords: The resource records required to configure this domain
	// mapping. These records must be added to the domain's DNS configuration in
	// order to serve the application via this domain mapping.
	ResourceRecords []*ResourceRecord `json:"resourceRecords,omitempty"`
	// Url: Optional. Not supported by Cloud Run.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conditions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conditions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DomainMappingStatus) MarshalJSON() ([]byte, error) {
	type NoMethod DomainMappingStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// EmptyDirVolumeSource: In memory (tmpfs) ephemeral storage. It is ephemeral
// in the sense that when the sandbox is taken down, the data is destroyed with
// it (it does not persist across sandbox runs).
type EmptyDirVolumeSource struct {
	// Medium: The medium on which the data is stored. The default is "" which
	// means to use the node's default medium. Must be an empty string (default) or
	// Memory. More info:
	// https://kubernetes.io/docs/concepts/storage/volumes#emptydir
	Medium string `json:"medium,omitempty"`
	// SizeLimit: Limit on the storage usable by this EmptyDir volume. The size
	// limit is also applicable for memory medium. The maximum usage on memory
	// medium EmptyDir would be the minimum value between the SizeLimit specified
	// here and the sum of memory limits of all containers. The default is nil
	// which means that the limit is undefined. More info:
	// https://cloud.google.com/run/docs/configuring/in-memory-volumes#configure-volume.
	// Info in Kubernetes:
	// https://kubernetes.io/docs/concepts/storage/volumes/#emptydir
	SizeLimit string `json:"sizeLimit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Medium") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Medium") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EmptyDirVolumeSource) MarshalJSON() ([]byte, error) {
	type NoMethod EmptyDirVolumeSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EnvFromSource: Not supported by Cloud Run. EnvFromSource represents the
// source of a set of ConfigMaps
type EnvFromSource struct {
	// ConfigMapRef: The ConfigMap to select from
	ConfigMapRef *ConfigMapEnvSource `json:"configMapRef,omitempty"`
	// Prefix: An optional identifier to prepend to each key in the ConfigMap. Must
	// be a C_IDENTIFIER.
	Prefix string `json:"prefix,omitempty"`
	// SecretRef: The Secret to select from
	SecretRef *SecretEnvSource `json:"secretRef,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfigMapRef") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfigMapRef") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EnvFromSource) MarshalJSON() ([]byte, error) {
	type NoMethod EnvFromSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EnvVar: EnvVar represents an environment variable present in a Container.
type EnvVar struct {
	// Name: Required. Name of the environment variable.
	Name string `json:"name,omitempty"`
	// Value: Value of the environment variable. Defaults to "". Variable
	// references are not supported in Cloud Run.
	Value string `json:"value,omitempty"`
	// ValueFrom: Source for the environment variable's value. Only supports
	// secret_key_ref. Cannot be used if value is not empty.
	ValueFrom *EnvVarSource `json:"valueFrom,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EnvVar) MarshalJSON() ([]byte, error) {
	type NoMethod EnvVar
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// EnvVarSource: EnvVarSource represents a source for the value of an EnvVar.
type EnvVarSource struct {
	// ConfigMapKeyRef: Not supported by Cloud Run. Not supported in Cloud Run.
	ConfigMapKeyRef *ConfigMapKeySelector `json:"configMapKeyRef,omitempty"`
	// SecretKeyRef: Selects a key (version) of a secret in Secret Manager.
	SecretKeyRef *SecretKeySelector `json:"secretKeyRef,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfigMapKeyRef") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfigMapKeyRef") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s EnvVarSource) MarshalJSON() ([]byte, error) {
	type NoMethod EnvVarSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecAction: Not supported by Cloud Run. ExecAction describes a "run in
// container" action.
type ExecAction struct {
	// Command: Command is the command line to execute inside the container, the
	// working directory for the command is root ('/') in the container's
	// filesystem. The command is simply exec'd, it is not run inside a shell, so
	// traditional shell instructions ('|', etc) won't work. To use a shell, you
	// need to explicitly call out to that shell. Exit status of 0 is treated as
	// live/healthy and non-zero is unhealthy.
	Command []string `json:"command,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Command") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Command") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecAction) MarshalJSON() ([]byte, error) {
	type NoMethod ExecAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Execution: Execution represents the configuration of a single execution. An
// execution is an immutable resource that references a container image which
// is run to completion.
type Execution struct {
	// ApiVersion: Optional. APIVersion defines the versioned schema of this
	// representation of an object. Servers should convert recognized schemas to
	// the latest internal value, and may reject unrecognized values.
	ApiVersion string `json:"apiVersion,omitempty"`
	// Kind: Optional. Kind is a string value representing the REST resource this
	// object represents. Servers may infer this from the endpoint the client
	// submits requests to. Cannot be updated. In CamelCase.
	Kind string `json:"kind,omitempty"`
	// Metadata: Optional. Standard object's metadata.
	Metadata *ObjectMeta `json:"metadata,omitempty"`
	// Spec: Optional. Specification of the desired behavior of an execution.
	Spec *ExecutionSpec `json:"spec,omitempty"`
	// Status: Output only. Current status of an execution.
	Status *ExecutionStatus `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Execution) MarshalJSON() ([]byte, error) {
	type NoMethod Execution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecutionReference: Reference to an Execution. Use /Executions.GetExecution
// with the given name to get full execution including the latest status.
type ExecutionReference struct {
	// CompletionStatus: Optional. Status for the execution completion.
	//
	// Possible values:
	//   "COMPLETION_STATUS_UNSPECIFIED" - The default value. This value is used if
	// the state is omitted.
	//   "EXECUTION_SUCCEEDED" - Job execution has succeeded.
	//   "EXECUTION_FAILED" - Job execution has failed.
	//   "EXECUTION_RUNNING" - Job execution is running normally.
	//   "EXECUTION_PENDING" - Waiting for backing resources to be provisioned.
	//   "EXECUTION_CANCELLED" - Job execution has been cancelled by the user.
	CompletionStatus string `json:"completionStatus,omitempty"`
	// CompletionTimestamp: Optional. Completion timestamp of the execution.
	CompletionTimestamp string `json:"completionTimestamp,omitempty"`
	// CreationTimestamp: Optional. Creation timestamp of the execution.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`
	// DeletionTimestamp: Optional. The read-only soft deletion timestamp of the
	// execution.
	DeletionTimestamp string `json:"deletionTimestamp,omitempty"`
	// Name: Optional. Name of the execution.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletionStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletionStatus") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecutionReference) MarshalJSON() ([]byte, error) {
	type NoMethod ExecutionReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecutionSpec: ExecutionSpec describes how the execution will look.
type ExecutionSpec struct {
	// Parallelism: Optional. Specifies the maximum desired number of tasks the
	// execution should run at given time. When the job is run, if this field is 0
	// or unset, the maximum possible value will be used for that execution. The
	// actual number of tasks running in steady state will be less than this number
	// when there are fewer tasks waiting to be completed, i.e. when the work left
	// to do is less than max parallelism.
	Parallelism int64 `json:"parallelism,omitempty"`
	// TaskCount: Optional. Specifies the desired number of tasks the execution
	// should run. Setting to 1 means that parallelism is limited to 1 and the
	// success of that task signals the success of the execution. Defaults to 1.
	TaskCount int64 `json:"taskCount,omitempty"`
	// Template: Optional. The template used to create tasks for this execution.
	Template *TaskTemplateSpec `json:"template,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parallelism") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parallelism") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecutionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod ExecutionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecutionStatus: ExecutionStatus represents the current state of an
// Execution.
type ExecutionStatus struct {
	// CancelledCount: Optional. The number of tasks which reached phase Cancelled.
	CancelledCount int64 `json:"cancelledCount,omitempty"`
	// CompletionTime: Optional. Represents the time that the execution was
	// completed. It is not guaranteed to be set in happens-before order across
	// separate operations. It is represented in RFC3339 form and is in UTC.
	// +optional
	CompletionTime string `json:"completionTime,omitempty"`
	// Conditions: Optional. Conditions communicate information about
	// ongoing/complete reconciliation processes that bring the "spec" inline with
	// the observed state of the world. Execution-specific conditions include: *
	// `ResourcesAvailable`: `True` when underlying resources have been
	// provisioned. * `Started`: `True` when the execution has started to execute.
	// * `Completed`: `True` when the execution has succeeded. `False` when the
	// execution has failed.
	Conditions []*GoogleCloudRunV1Condition `json:"conditions,omitempty"`
	// FailedCount: Optional. The number of tasks which reached phase Failed.
	FailedCount int64 `json:"failedCount,omitempty"`
	// LogUri: Optional. URI where logs for this execution can be found in Cloud
	// Console.
	LogUri string `json:"logUri,omitempty"`
	// ObservedGeneration: Optional. The 'generation' of the execution that was
	// last processed by the controller.
	ObservedGeneration int64 `json:"observedGeneration,omitempty"`
	// RetriedCount: Optional. The number of tasks which have retried at least
	// once.
	RetriedCount int64 `json:"retriedCount,omitempty"`
	// RunningCount: Optional. The number of actively running tasks.
	RunningCount int64 `json:"runningCount,omitempty"`
	// StartTime: Optional. Represents the time that the execution started to run.
	// It is not guaranteed to be set in happens-before order across separate
	// operations. It is represented in RFC3339 form and is in UTC.
	StartTime string `json:"startTime,omitempty"`
	// SucceededCount: Optional. The number of tasks which reached phase Succeeded.
	SucceededCount int64 `json:"succeededCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CancelledCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CancelledCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecutionStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ExecutionStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExecutionTemplateSpec: ExecutionTemplateSpec describes the metadata and spec
// an Execution should have when created from a job.
type ExecutionTemplateSpec struct {
	// Metadata: Optional. Optional metadata for this Execution, including labels
	// and annotations. The following annotation keys set properties of the created
	// execution: * `run.googleapis.com/cloudsql-instances` sets Cloud SQL
	// connections. Multiple values should be comma separated. *
	// `run.googleapis.com/vpc-access-connector` sets a Serverless VPC Access
	// connector. * `run.googleapis.com/vpc-access-egress` sets VPC egress.
	// Supported values are `all-traffic`, `all` (deprecated), and
	// `private-ranges-only`. `all-traffic` and `all` provide the same
	// functionality. `all` is deprecated but will continue to be supported. Prefer
	// `all-traffic`.
	Metadata *ObjectMeta `json:"metadata,omitempty"`
	// Spec: Required. ExecutionSpec holds the desired configuration for executions
	// of this job.
	Spec *ExecutionSpec `json:"spec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecutionTemplateSpec) MarshalJSON() ([]byte, error) {
	type NoMethod ExecutionTemplateSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Expr: Represents a textual expression in the Common Expression Language
// (CEL) syntax. CEL is a C-like expression language. The syntax and semantics
// of CEL are documented at https://github.com/google/cel-spec. Example
// (Comparison): title: "Summary size limit" description: "Determines if a
// summary is less than 100 chars" expression: "document.summary.size() < 100"
// Example (Equality): title: "Requestor is owner" description: "Determines if
// requestor is the document owner" expression: "document.owner ==
// request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type Expr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Expr) MarshalJSON() ([]byte, error) {
	type NoMethod Expr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GRPCAction: GRPCAction describes an action involving a GRPC port.
type GRPCAction struct {
	// Port: Port number of the gRPC service. Number must be in the range 1 to
	// 65535.
	Port int64 `json:"port,omitempty"`
	// Service: Service is the name of the service to place in the gRPC
	// HealthCheckRequest. If this is not specified, the default behavior is
	// defined by gRPC.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Port") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Port") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GRPCAction) MarshalJSON() ([]byte, error) {
	type NoMethod GRPCAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV1Condition: Conditions show the status of reconciliation
// progress on a given resource. Most resource use a top-level condition type
// "Ready" or "Completed" to show overall status with other conditions to
// checkpoint each stage of reconciliation. Note that if metadata.Generation
// does not equal status.ObservedGeneration, the conditions shown may not be
// relevant for the current spec.
type GoogleCloudRunV1Condition struct {
	// LastTransitionTime: Optional. Last time the condition transitioned from one
	// status to another.
	LastTransitionTime string `json:"lastTransitionTime,omitempty"`
	// Message: Optional. Human readable message indicating details about the
	// current status.
	Message string `json:"message,omitempty"`
	// Reason: Optional. One-word CamelCase reason for the condition's last
	// transition. These are intended to be stable, unique values which the client
	// may use to trigger error handling logic, whereas messages which may be
	// changed later by the server.
	Reason string `json:"reason,omitempty"`
	// Severity: Optional. How to interpret this condition. One of Error, Warning,
	// or Info. Conditions of severity Info do not contribute to resource
	// readiness.
	Severity string `json:"severity,omitempty"`
	// Status: Status of the condition, one of True, False, Unknown.
	Status string `json:"status,omitempty"`
	// Type: type is used to communicate the status of the reconciliation process.
	// Types common to all resources include: * "Ready" or "Completed": True when
	// the Resource is ready.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LastTransitionTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LastTransitionTime") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV1Condition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV1Condition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1ApprovalConfig: ApprovalConfig describes
// configuration for manual approval of a build.
type GoogleDevtoolsCloudbuildV1ApprovalConfig struct {
	// ApprovalRequired: Whether or not approval is needed. If this is set on a
	// build, it will become pending when created, and will need to be explicitly
	// approved to start.
	ApprovalRequired bool `json:"approvalRequired,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApprovalRequired") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApprovalRequired") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1ApprovalConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1ApprovalConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1ApprovalResult: ApprovalResult describes the
// decision and associated metadata of a manual approval of a build.
type GoogleDevtoolsCloudbuildV1ApprovalResult struct {
	// ApprovalTime: Output only. The time when the approval decision was made.
	ApprovalTime string `json:"approvalTime,omitempty"`
	// ApproverAccount: Output only. Email of the user that called the ApproveBuild
	// API to approve or reject a build at the time that the API was called.
	ApproverAccount string `json:"approverAccount,omitempty"`
	// Comment: Optional. An optional comment for this manual approval result.
	Comment string `json:"comment,omitempty"`
	// Decision: Required. The decision of this manual approval.
	//
	// Possible values:
	//   "DECISION_UNSPECIFIED" - Default enum type. This should not be used.
	//   "APPROVED" - Build is approved.
	//   "REJECTED" - Build is rejected.
	Decision string `json:"decision,omitempty"`
	// Url: Optional. An optional URL tied to this manual approval result. This
	// field is essentially the same as comment, except that it will be rendered by
	// the UI differently. An example use case is a link to an external job that
	// approved this Build.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApprovalTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApprovalTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1ApprovalResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1ApprovalResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1ArtifactObjects: Files in the workspace to upload
// to Cloud Storage upon successful completion of all build steps.
type GoogleDevtoolsCloudbuildV1ArtifactObjects struct {
	// Location: Cloud Storage bucket and optional object path, in the form
	// "gs://bucket/path/to/somewhere/". (see Bucket Name Requirements
	// (https://cloud.google.com/storage/docs/bucket-naming#requirements)). Files
	// in the workspace matching any path pattern will be uploaded to Cloud Storage
	// with this location as a prefix.
	Location string `json:"location,omitempty"`
	// Paths: Path globs used to match files in the build's workspace.
	Paths []string `json:"paths,omitempty"`
	// Timing: Output only. Stores timing information for pushing all artifact
	// objects.
	Timing *GoogleDevtoolsCloudbuildV1TimeSpan `json:"timing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Location") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Location") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1ArtifactObjects) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1ArtifactObjects
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1Artifacts: Artifacts produced by a build that
// should be uploaded upon successful completion of all build steps.
type GoogleDevtoolsCloudbuildV1Artifacts struct {
	// GoModules: Optional. A list of Go modules to be uploaded to Artifact
	// Registry upon successful completion of all build steps. If any objects fail
	// to be pushed, the build is marked FAILURE.
	GoModules []*GoogleDevtoolsCloudbuildV1GoModule `json:"goModules,omitempty"`
	// Images: A list of images to be pushed upon the successful completion of all
	// build steps. The images will be pushed using the builder service account's
	// credentials. The digests of the pushed images will be stored in the Build
	// resource's results field. If any of the images fail to be pushed, the build
	// is marked FAILURE.
	Images []string `json:"images,omitempty"`
	// MavenArtifacts: A list of Maven artifacts to be uploaded to Artifact
	// Registry upon successful completion of all build steps. Artifacts in the
	// workspace matching specified paths globs will be uploaded to the specified
	// Artifact Registry repository using the builder service account's
	// credentials. If any artifacts fail to be pushed, the build is marked
	// FAILURE.
	MavenArtifacts []*GoogleDevtoolsCloudbuildV1MavenArtifact `json:"mavenArtifacts,omitempty"`
	// NpmPackages: A list of npm packages to be uploaded to Artifact Registry upon
	// successful completion of all build steps. Npm packages in the specified
	// paths will be uploaded to the specified Artifact Registry repository using
	// the builder service account's credentials. If any packages fail to be
	// pushed, the build is marked FAILURE.
	NpmPackages []*GoogleDevtoolsCloudbuildV1NpmPackage `json:"npmPackages,omitempty"`
	// Objects: A list of objects to be uploaded to Cloud Storage upon successful
	// completion of all build steps. Files in the workspace matching specified
	// paths globs will be uploaded to the specified Cloud Storage location using
	// the builder service account's credentials. The location and generation of
	// the uploaded objects will be stored in the Build resource's results field.
	// If any objects fail to be pushed, the build is marked FAILURE.
	Objects *GoogleDevtoolsCloudbuildV1ArtifactObjects `json:"objects,omitempty"`
	// PythonPackages: A list of Python packages to be uploaded to Artifact
	// Registry upon successful completion of all build steps. The build service
	// account credentials will be used to perform the upload. If any objects fail
	// to be pushed, the build is marked FAILURE.
	PythonPackages []*GoogleDevtoolsCloudbuildV1PythonPackage `json:"pythonPackages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GoModules") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GoModules") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1Artifacts) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1Artifacts
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1Build: A build resource in the Cloud Build API. At
// a high level, a `Build` describes where to find source code, how to build it
// (for example, the builder image to run on the source), and where to store
// the built artifacts. Fields can include the following variables, which will
// be expanded when the build is created: - $PROJECT_ID: the project ID of the
// build. - $PROJECT_NUMBER: the project number of the build. - $LOCATION: the
// location/region of the build. - $BUILD_ID: the autogenerated ID of the
// build. - $REPO_NAME: the source repository name specified by RepoSource. -
// $BRANCH_NAME: the branch name specified by RepoSource. - $TAG_NAME: the tag
// name specified by RepoSource. - $REVISION_ID or $COMMIT_SHA: the commit SHA
// specified by RepoSource or resolved from the specified branch or tag. -
// $SHORT_SHA: first 7 characters of $REVISION_ID or $COMMIT_SHA.
type GoogleDevtoolsCloudbuildV1Build struct {
	// Approval: Output only. Describes this build's approval configuration,
	// status, and result.
	Approval *GoogleDevtoolsCloudbuildV1BuildApproval `json:"approval,omitempty"`
	// Artifacts: Artifacts produced by the build that should be uploaded upon
	// successful completion of all build steps.
	Artifacts *GoogleDevtoolsCloudbuildV1Artifacts `json:"artifacts,omitempty"`
	// AvailableSecrets: Secrets and secret environment variables.
	AvailableSecrets *GoogleDevtoolsCloudbuildV1Secrets `json:"availableSecrets,omitempty"`
	// BuildTriggerId: Output only. The ID of the `BuildTrigger` that triggered
	// this build, if it was triggered automatically.
	BuildTriggerId string `json:"buildTriggerId,omitempty"`
	// CreateTime: Output only. Time at which the request to create the build was
	// received.
	CreateTime string `json:"createTime,omitempty"`
	// Dependencies: Optional. Dependencies that the Cloud Build worker will fetch
	// before executing user steps.
	Dependencies []*GoogleDevtoolsCloudbuildV1Dependency `json:"dependencies,omitempty"`
	// FailureInfo: Output only. Contains information about the build when
	// status=FAILURE.
	FailureInfo *GoogleDevtoolsCloudbuildV1FailureInfo `json:"failureInfo,omitempty"`
	// FinishTime: Output only. Time at which execution of the build was finished.
	// The difference between finish_time and start_time is the duration of the
	// build's execution.
	FinishTime string `json:"finishTime,omitempty"`
	// GitConfig: Optional. Configuration for git operations.
	GitConfig *GoogleDevtoolsCloudbuildV1GitConfig `json:"gitConfig,omitempty"`
	// Id: Output only. Unique identifier of the build.
	Id string `json:"id,omitempty"`
	// Images: A list of images to be pushed upon the successful completion of all
	// build steps. The images are pushed using the builder service account's
	// credentials. The digests of the pushed images will be stored in the `Build`
	// resource's results field. If any of the images fail to be pushed, the build
	// status is marked `FAILURE`.
	Images []string `json:"images,omitempty"`
	// LogUrl: Output only. URL to logs for this build in Google Cloud Console.
	LogUrl string `json:"logUrl,omitempty"`
	// LogsBucket: Cloud Storage bucket where logs should be written (see Bucket
	// Name Requirements
	// (https://cloud.google.com/storage/docs/bucket-naming#requirements)). Logs
	// file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
	LogsBucket string `json:"logsBucket,omitempty"`
	// Name: Output only. The 'Build' name with format:
	// `projects/{project}/locations/{location}/builds/{build}`, where {build} is a
	// unique identifier generated by the service.
	Name string `json:"name,omitempty"`
	// Options: Special options for this build.
	Options *GoogleDevtoolsCloudbuildV1BuildOptions `json:"options,omitempty"`
	// ProjectId: Output only. ID of the project.
	ProjectId string `json:"projectId,omitempty"`
	// QueueTtl: TTL in queue for this build. If provided and the build is enqueued
	// longer than this value, the build will expire and the build status will be
	// `EXPIRED`. The TTL starts ticking from create_time.
	QueueTtl string `json:"queueTtl,omitempty"`
	// Results: Output only. Results of the build.
	Results *GoogleDevtoolsCloudbuildV1Results `json:"results,omitempty"`
	// Secrets: Secrets to decrypt using Cloud Key Management Service. Note: Secret
	// Manager is the recommended technique for managing sensitive data with Cloud
	// Build. Use `available_secrets` to configure builds to access secrets from
	// Secret Manager. For instructions, see:
	// https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
	Secrets []*GoogleDevtoolsCloudbuildV1Secret `json:"secrets,omitempty"`
	// ServiceAccount: IAM service account whose credentials will be used at build
	// runtime. Must be of the format
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. ACCOUNT can be email
	// address or uniqueId of the service account.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// Source: Optional. The location of the source files to build.
	Source *GoogleDevtoolsCloudbuildV1Source `json:"source,omitempty"`
	// SourceProvenance: Output only. A permanent fixed identifier for source.
	SourceProvenance *GoogleDevtoolsCloudbuildV1SourceProvenance `json:"sourceProvenance,omitempty"`
	// StartTime: Output only. Time at which execution of the build was started.
	StartTime string `json:"startTime,omitempty"`
	// Status: Output only. Status of the build.
	//
	// Possible values:
	//   "STATUS_UNKNOWN" - Status of the build is unknown.
	//   "PENDING" - Build has been created and is pending execution and queuing.
	// It has not been queued.
	//   "QUEUED" - Build or step is queued; work has not yet begun.
	//   "WORKING" - Build or step is being executed.
	//   "SUCCESS" - Build or step finished successfully.
	//   "FAILURE" - Build or step failed to complete successfully.
	//   "INTERNAL_ERROR" - Build or step failed due to an internal cause.
	//   "TIMEOUT" - Build or step took longer than was allowed.
	//   "CANCELLED" - Build or step was canceled by a user.
	//   "EXPIRED" - Build was enqueued for longer than the value of `queue_ttl`.
	Status string `json:"status,omitempty"`
	// StatusDetail: Output only. Customer-readable message about the current
	// status.
	StatusDetail string `json:"statusDetail,omitempty"`
	// Steps: Required. The operations to be performed on the workspace.
	Steps []*GoogleDevtoolsCloudbuildV1BuildStep `json:"steps,omitempty"`
	// Substitutions: Substitutions data for `Build` resource.
	Substitutions map[string]string `json:"substitutions,omitempty"`
	// Tags: Tags for annotation of a `Build`. These are not docker tags.
	Tags []string `json:"tags,omitempty"`
	// Timeout: Amount of time that this build should be allowed to run, to second
	// granularity. If this amount of time elapses, work on the build will cease
	// and the build status will be `TIMEOUT`. `timeout` starts ticking from
	// `startTime`. Default time is 60 minutes.
	Timeout string `json:"timeout,omitempty"`
	// Timing: Output only. Stores timing information for phases of the build.
	// Valid keys are: * BUILD: time to execute all build steps. * PUSH: time to
	// push all artifacts including docker images and non docker artifacts. *
	// FETCHSOURCE: time to fetch source. * SETUPBUILD: time to set up build. If
	// the build does not specify source or images, these keys will not be
	// included.
	Timing map[string]GoogleDevtoolsCloudbuildV1TimeSpan `json:"timing,omitempty"`
	// Warnings: Output only. Non-fatal problems encountered during the execution
	// of the build.
	Warnings []*GoogleDevtoolsCloudbuildV1Warning `json:"warnings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Approval") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Approval") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1Build) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1Build
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1BuildApproval: BuildApproval describes a build's
// approval configuration, state, and result.
type GoogleDevtoolsCloudbuildV1BuildApproval struct {
	// Config: Output only. Configuration for manual approval of this build.
	Config *GoogleDevtoolsCloudbuildV1ApprovalConfig `json:"config,omitempty"`
	// Result: Output only. Result of manual approval for this Build.
	Result *GoogleDevtoolsCloudbuildV1ApprovalResult `json:"result,omitempty"`
	// State: Output only. The state of this build's approval.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default enum type. This should not be used.
	//   "PENDING" - Build approval is pending.
	//   "APPROVED" - Build approval has been approved.
	//   "REJECTED" - Build approval has been rejected.
	//   "CANCELLED" - Build was cancelled while it was still pending approval.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1BuildApproval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1BuildApproval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1BuildOperationMetadata: Metadata for build
// operations.
type GoogleDevtoolsCloudbuildV1BuildOperationMetadata struct {
	// Build: The build that the operation is tracking.
	Build *GoogleDevtoolsCloudbuildV1Build `json:"build,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Build") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Build") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1BuildOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1BuildOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1BuildOptions: Optional arguments to enable
// specific features of builds.
type GoogleDevtoolsCloudbuildV1BuildOptions struct {
	// AutomapSubstitutions: Option to include built-in and custom substitutions as
	// env variables for all build steps.
	AutomapSubstitutions bool `json:"automapSubstitutions,omitempty"`
	// DefaultLogsBucketBehavior: Optional. Option to specify how default logs
	// buckets are setup.
	//
	// Possible values:
	//   "DEFAULT_LOGS_BUCKET_BEHAVIOR_UNSPECIFIED" - Unspecified.
	//   "REGIONAL_USER_OWNED_BUCKET" - Bucket is located in user-owned project in
	// the same region as the build. The builder service account must have access
	// to create and write to Cloud Storage buckets in the build project.
	//   "LEGACY_BUCKET" - Bucket is located in a Google-owned project and is not
	// regionalized.
	DefaultLogsBucketBehavior string `json:"defaultLogsBucketBehavior,omitempty"`
	// DiskSizeGb: Requested disk size for the VM that runs the build. Note that
	// this is *NOT* "disk free"; some of the space will be used by the operating
	// system and build utilities. Also note that this is the minimum disk size
	// that will be allocated for the build -- the build may run with a larger disk
	// than requested. At present, the maximum disk size is 4000GB; builds that
	// request more than the maximum are rejected with an error.
	DiskSizeGb int64 `json:"diskSizeGb,omitempty,string"`
	// DynamicSubstitutions: Option to specify whether or not to apply bash style
	// string operations to the substitutions. NOTE: this is always enabled for
	// triggered builds and cannot be overridden in the build configuration file.
	DynamicSubstitutions bool `json:"dynamicSubstitutions,omitempty"`
	// EnableStructuredLogging: Optional. Option to specify whether structured
	// logging is enabled. If true, JSON-formatted logs are parsed as structured
	// logs.
	EnableStructuredLogging bool `json:"enableStructuredLogging,omitempty"`
	// Env: A list of global environment variable definitions that will exist for
	// all build steps in this build. If a variable is defined in both globally and
	// in a build step, the variable will use the build step value. The elements
	// are of the form "KEY=VALUE" for the environment variable "KEY" being given
	// the value "VALUE".
	Env []string `json:"env,omitempty"`
	// LogStreamingOption: Option to define build log streaming behavior to Cloud
	// Storage.
	//
	// Possible values:
	//   "STREAM_DEFAULT" - Service may automatically determine build log streaming
	// behavior.
	//   "STREAM_ON" - Build logs should be streamed to Cloud Storage.
	//   "STREAM_OFF" - Build logs should not be streamed to Cloud Storage; they
	// will be written when the build is completed.
	LogStreamingOption string `json:"logStreamingOption,omitempty"`
	// Logging: Option to specify the logging mode, which determines if and where
	// build logs are stored.
	//
	// Possible values:
	//   "LOGGING_UNSPECIFIED" - The service determines the logging mode. The
	// default is `LEGACY`. Do not rely on the default logging behavior as it may
	// change in the future.
	//   "LEGACY" - Build logs are stored in Cloud Logging and Cloud Storage.
	//   "GCS_ONLY" - Build logs are stored in Cloud Storage.
	//   "STACKDRIVER_ONLY" - This option is the same as CLOUD_LOGGING_ONLY.
	//   "CLOUD_LOGGING_ONLY" - Build logs are stored in Cloud Logging. Selecting
	// this option will not allow [logs
	// streaming](https://cloud.google.com/sdk/gcloud/reference/builds/log).
	//   "NONE" - Turn off all logging. No build logs will be captured.
	Logging string `json:"logging,omitempty"`
	// MachineType: Compute Engine machine type on which to run the build.
	//
	// Possible values:
	//   "UNSPECIFIED" - Standard machine type.
	//   "N1_HIGHCPU_8" - Highcpu machine with 8 CPUs.
	//   "N1_HIGHCPU_32" - Highcpu machine with 32 CPUs.
	//   "E2_HIGHCPU_8" - Highcpu e2 machine with 8 CPUs.
	//   "E2_HIGHCPU_32" - Highcpu e2 machine with 32 CPUs.
	//   "E2_MEDIUM" - E2 machine with 1 CPU.
	MachineType string `json:"machineType,omitempty"`
	// Pool: Optional. Specification for execution on a `WorkerPool`. See running
	// builds in a private pool
	// (https://cloud.google.com/build/docs/private-pools/run-builds-in-private-pool)
	// for more information.
	Pool *GoogleDevtoolsCloudbuildV1PoolOption `json:"pool,omitempty"`
	// PubsubTopic: Optional. Option to specify the Pub/Sub topic to receive build
	// status updates.
	PubsubTopic string `json:"pubsubTopic,omitempty"`
	// RequestedVerifyOption: Requested verifiability options.
	//
	// Possible values:
	//   "NOT_VERIFIED" - Not a verifiable build (the default).
	//   "VERIFIED" - Build must be verified.
	RequestedVerifyOption string `json:"requestedVerifyOption,omitempty"`
	// SecretEnv: A list of global environment variables, which are encrypted using
	// a Cloud Key Management Service crypto key. These values must be specified in
	// the build's `Secret`. These variables will be available to all build steps
	// in this build.
	SecretEnv []string `json:"secretEnv,omitempty"`
	// SourceProvenanceHash: Requested hash for SourceProvenance.
	//
	// Possible values:
	//   "NONE" - No hash requested.
	//   "SHA256" - Use a sha256 hash.
	//   "MD5" - Use a md5 hash.
	//   "GO_MODULE_H1" - Dirhash of a Go module's source code which is then
	// hex-encoded.
	//   "SHA512" - Use a sha512 hash.
	SourceProvenanceHash []string `json:"sourceProvenanceHash,omitempty"`
	// SubstitutionOption: Option to specify behavior when there is an error in the
	// substitution checks. NOTE: this is always set to ALLOW_LOOSE for triggered
	// builds and cannot be overridden in the build configuration file.
	//
	// Possible values:
	//   "MUST_MATCH" - Fails the build if error in substitutions checks, like
	// missing a substitution in the template or in the map.
	//   "ALLOW_LOOSE" - Do not fail the build if error in substitutions checks.
	SubstitutionOption string `json:"substitutionOption,omitempty"`
	// Volumes: Global list of volumes to mount for ALL build steps Each volume is
	// created as an empty volume prior to starting the build process. Upon
	// completion of the build, volumes and their contents are discarded. Global
	// volume names and paths cannot conflict with the volumes defined a build
	// step. Using a global volume in a build with only one step is not valid as it
	// is indicative of a build request with an incorrect configuration.
	Volumes []*GoogleDevtoolsCloudbuildV1Volume `json:"volumes,omitempty"`
	// WorkerPool: This field deprecated; please use `pool.name` instead.
	WorkerPool string `json:"workerPool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutomapSubstitutions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutomapSubstitutions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1BuildOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1BuildOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1BuildStep: A step in the build pipeline.
type GoogleDevtoolsCloudbuildV1BuildStep struct {
	// AllowExitCodes: Allow this build step to fail without failing the entire
	// build if and only if the exit code is one of the specified codes. If
	// allow_failure is also specified, this field will take precedence.
	AllowExitCodes []int64 `json:"allowExitCodes,omitempty"`
	// AllowFailure: Allow this build step to fail without failing the entire
	// build. If false, the entire build will fail if this step fails. Otherwise,
	// the build will succeed, but this step will still have a failure status.
	// Error information will be reported in the failure_detail field.
	AllowFailure bool `json:"allowFailure,omitempty"`
	// Args: A list of arguments that will be presented to the step when it is
	// started. If the image used to run the step's container has an entrypoint,
	// the `args` are used as arguments to that entrypoint. If the image does not
	// define an entrypoint, the first element in args is used as the entrypoint,
	// and the remainder will be used as arguments.
	Args []string `json:"args,omitempty"`
	// AutomapSubstitutions: Option to include built-in and custom substitutions as
	// env variables for this build step. This option will override the global
	// option in BuildOption.
	AutomapSubstitutions bool `json:"automapSubstitutions,omitempty"`
	// Dir: Working directory to use when running this step's container. If this
	// value is a relative path, it is relative to the build's working directory.
	// If this value is absolute, it may be outside the build's working directory,
	// in which case the contents of the path may not be persisted across build
	// step executions, unless a `volume` for that path is specified. If the build
	// specifies a `RepoSource` with `dir` and a step with a `dir`, which specifies
	// an absolute path, the `RepoSource` `dir` is ignored for the step's
	// execution.
	Dir string `json:"dir,omitempty"`
	// Entrypoint: Entrypoint to be used instead of the build step image's default
	// entrypoint. If unset, the image's default entrypoint is used.
	Entrypoint string `json:"entrypoint,omitempty"`
	// Env: A list of environment variable definitions to be used when running a
	// step. The elements are of the form "KEY=VALUE" for the environment variable
	// "KEY" being given the value "VALUE".
	Env []string `json:"env,omitempty"`
	// ExitCode: Output only. Return code from running the step.
	ExitCode int64 `json:"exitCode,omitempty"`
	// Id: Unique identifier for this build step, used in `wait_for` to reference
	// this build step as a dependency.
	Id string `json:"id,omitempty"`
	// Name: Required. The name of the container image that will run this
	// particular build step. If the image is available in the host's Docker
	// daemon's cache, it will be run directly. If not, the host will attempt to
	// pull the image first, using the builder service account's credentials if
	// necessary. The Docker daemon's cache will already have the latest versions
	// of all of the officially supported build steps
	// (https://github.com/GoogleCloudPlatform/cloud-builders
	// (https://github.com/GoogleCloudPlatform/cloud-builders)). The Docker daemon
	// will also have cached many of the layers for some popular images, like
	// "ubuntu", "debian", but they will be refreshed at the time you attempt to
	// use them. If you built an image in a previous build step, it will be stored
	// in the host's Docker daemon's cache and is available to use as the name for
	// a later build step.
	Name string `json:"name,omitempty"`
	// PullTiming: Output only. Stores timing information for pulling this build
	// step's builder image only.
	PullTiming *GoogleDevtoolsCloudbuildV1TimeSpan `json:"pullTiming,omitempty"`
	// Script: A shell script to be executed in the step. When script is provided,
	// the user cannot specify the entrypoint or args.
	Script string `json:"script,omitempty"`
	// SecretEnv: A list of environment variables which are encrypted using a Cloud
	// Key Management Service crypto key. These values must be specified in the
	// build's `Secret`.
	SecretEnv []string `json:"secretEnv,omitempty"`
	// Status: Output only. Status of the build step. At this time, build step
	// status is only updated on build completion; step status is not updated in
	// real-time as the build progresses.
	//
	// Possible values:
	//   "STATUS_UNKNOWN" - Status of the build is unknown.
	//   "PENDING" - Build has been created and is pending execution and queuing.
	// It has not been queued.
	//   "QUEUED" - Build or step is queued; work has not yet begun.
	//   "WORKING" - Build or step is being executed.
	//   "SUCCESS" - Build or step finished successfully.
	//   "FAILURE" - Build or step failed to complete successfully.
	//   "INTERNAL_ERROR" - Build or step failed due to an internal cause.
	//   "TIMEOUT" - Build or step took longer than was allowed.
	//   "CANCELLED" - Build or step was canceled by a user.
	//   "EXPIRED" - Build was enqueued for longer than the value of `queue_ttl`.
	Status string `json:"status,omitempty"`
	// Timeout: Time limit for executing this build step. If not defined, the step
	// has no time limit and will be allowed to continue to run until either it
	// completes or the build itself times out.
	Timeout string `json:"timeout,omitempty"`
	// Timing: Output only. Stores timing information for executing this build
	// step.
	Timing *GoogleDevtoolsCloudbuildV1TimeSpan `json:"timing,omitempty"`
	// Volumes: List of volumes to mount into the build step. Each volume is
	// created as an empty volume prior to execution of the build step. Upon
	// completion of the build, volumes and their contents are discarded. Using a
	// named volume in only one step is not valid as it is indicative of a build
	// request with an incorrect configuration.
	Volumes []*GoogleDevtoolsCloudbuildV1Volume `json:"volumes,omitempty"`
	// WaitFor: The ID(s) of the step(s) that this build step depends on. This
	// build step will not start until all the build steps in `wait_for` have
	// completed successfully. If `wait_for` is empty, this build step will start
	// when all previous build steps in the `Build.Steps` list have completed
	// successfully.
	WaitFor []string `json:"waitFor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowExitCodes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowExitCodes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1BuildStep) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1BuildStep
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1BuiltImage: An image built by the pipeline.
type GoogleDevtoolsCloudbuildV1BuiltImage struct {
	// ArtifactRegistryPackage: Output only. Path to the artifact in Artifact
	// Registry.
	ArtifactRegistryPackage string `json:"artifactRegistryPackage,omitempty"`
	// Digest: Docker Registry 2.0 digest.
	Digest string `json:"digest,omitempty"`
	// Name: Name used to push the container image to Google Container Registry, as
	// presented to `docker push`.
	Name string `json:"name,omitempty"`
	// PushTiming: Output only. Stores timing information for pushing the specified
	// image.
	PushTiming *GoogleDevtoolsCloudbuildV1TimeSpan `json:"pushTiming,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArtifactRegistryPackage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArtifactRegistryPackage") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1BuiltImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1BuiltImage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1ConnectedRepository: Location of the source in a
// 2nd-gen Google Cloud Build repository resource.
type GoogleDevtoolsCloudbuildV1ConnectedRepository struct {
	// Dir: Optional. Directory, relative to the source root, in which to run the
	// build.
	Dir string `json:"dir,omitempty"`
	// Repository: Required. Name of the Google Cloud Build repository, formatted
	// as `projects/*/locations/*/connections/*/repositories/*`.
	Repository string `json:"repository,omitempty"`
	// Revision: Required. The revision to fetch from the Git repository such as a
	// branch, a tag, a commit SHA, or any Git ref.
	Revision string `json:"revision,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dir") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dir") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1ConnectedRepository) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1ConnectedRepository
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1Dependency: A dependency that the Cloud Build
// worker will fetch before executing user steps.
type GoogleDevtoolsCloudbuildV1Dependency struct {
	// Empty: If set to true disable all dependency fetching (ignoring the default
	// source as well).
	Empty bool `json:"empty,omitempty"`
	// GitSource: Represents a git repository as a build dependency.
	GitSource *GoogleDevtoolsCloudbuildV1GitSourceDependency `json:"gitSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Empty") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Empty") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1Dependency) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1Dependency
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1DeveloperConnectConfig: This config defines the
// location of a source through Developer Connect.
type GoogleDevtoolsCloudbuildV1DeveloperConnectConfig struct {
	// Dir: Required. Directory, relative to the source root, in which to run the
	// build.
	Dir string `json:"dir,omitempty"`
	// GitRepositoryLink: Required. The Developer Connect Git repository link,
	// formatted as `projects/*/locations/*/connections/*/gitRepositoryLink/*`.
	GitRepositoryLink string `json:"gitRepositoryLink,omitempty"`
	// Revision: Required. The revision to fetch from the Git repository such as a
	// branch, a tag, a commit SHA, or any Git ref.
	Revision string `json:"revision,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dir") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dir") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1DeveloperConnectConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1DeveloperConnectConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1FailureInfo: A fatal problem encountered during
// the execution of the build.
type GoogleDevtoolsCloudbuildV1FailureInfo struct {
	// Detail: Explains the failure issue in more detail using hard-coded text.
	Detail string `json:"detail,omitempty"`
	// Type: The name of the failure.
	//
	// Possible values:
	//   "FAILURE_TYPE_UNSPECIFIED" - Type unspecified
	//   "PUSH_FAILED" - Unable to push the image to the repository.
	//   "PUSH_IMAGE_NOT_FOUND" - Final image not found.
	//   "PUSH_NOT_AUTHORIZED" - Unauthorized push of the final image.
	//   "LOGGING_FAILURE" - Backend logging failures. Should retry.
	//   "USER_BUILD_STEP" - A build step has failed.
	//   "FETCH_SOURCE_FAILED" - The source fetching has failed.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Detail") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Detail") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1FailureInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1FailureInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1FileHashes: Container message for hashes of byte
// content of files, used in SourceProvenance messages to verify integrity of
// source input to the build.
type GoogleDevtoolsCloudbuildV1FileHashes struct {
	// FileHash: Collection of file hashes.
	FileHash []*GoogleDevtoolsCloudbuildV1Hash `json:"fileHash,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileHash") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileHash") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1FileHashes) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1FileHashes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1GitConfig: GitConfig is a configuration for git
// operations.
type GoogleDevtoolsCloudbuildV1GitConfig struct {
	// Http: Configuration for HTTP related git operations.
	Http *GoogleDevtoolsCloudbuildV1HttpConfig `json:"http,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Http") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Http") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1GitConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1GitConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1GitSource: Location of the source in any
// accessible Git repository.
type GoogleDevtoolsCloudbuildV1GitSource struct {
	// Dir: Optional. Directory, relative to the source root, in which to run the
	// build. This must be a relative path. If a step's `dir` is specified and is
	// an absolute path, this value is ignored for that step's execution.
	Dir string `json:"dir,omitempty"`
	// Revision: Optional. The revision to fetch from the Git repository such as a
	// branch, a tag, a commit SHA, or any Git ref. Cloud Build uses `git fetch` to
	// fetch the revision from the Git repository; therefore make sure that the
	// string you provide for `revision` is parsable by the command. For
	// information on string values accepted by `git fetch`, see
	// https://git-scm.com/docs/gitrevisions#_specifying_revisions. For information
	// on `git fetch`, see https://git-scm.com/docs/git-fetch.
	Revision string `json:"revision,omitempty"`
	// Url: Required. Location of the Git repo to build. This will be used as a
	// `git remote`, see https://git-scm.com/docs/git-remote.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dir") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dir") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1GitSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1GitSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1GitSourceDependency: Represents a git repository
// as a build dependency.
type GoogleDevtoolsCloudbuildV1GitSourceDependency struct {
	// Depth: Optional. How much history should be fetched for the build (default
	// 1, -1 for all history).
	Depth int64 `json:"depth,omitempty,string"`
	// DestPath: Required. Where should the files be placed on the worker.
	DestPath string `json:"destPath,omitempty"`
	// RecurseSubmodules: Optional. True if submodules should be fetched too
	// (default false).
	RecurseSubmodules bool `json:"recurseSubmodules,omitempty"`
	// Repository: Required. The kind of repo (url or dev connect).
	Repository *GoogleDevtoolsCloudbuildV1GitSourceRepository `json:"repository,omitempty"`
	// Revision: Required. The revision that we will fetch the repo at.
	Revision string `json:"revision,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Depth") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Depth") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1GitSourceDependency) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1GitSourceDependency
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1GitSourceRepository: A repository for a git
// source.
type GoogleDevtoolsCloudbuildV1GitSourceRepository struct {
	// DeveloperConnect: The Developer Connect Git repository link formatted as
	// `projects/*/locations/*/connections/*/gitRepositoryLink/*`
	DeveloperConnect string `json:"developerConnect,omitempty"`
	// Url: Location of the Git repository.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeveloperConnect") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeveloperConnect") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1GitSourceRepository) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1GitSourceRepository
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1GoModule: Go module to upload to Artifact Registry
// upon successful completion of all build steps. A module refers to all
// dependencies in a go.mod file.
type GoogleDevtoolsCloudbuildV1GoModule struct {
	// ModulePath: Optional. The Go module's "module path". e.g. example.com/foo/v2
	ModulePath string `json:"modulePath,omitempty"`
	// ModuleVersion: Optional. The Go module's semantic version in the form
	// vX.Y.Z. e.g. v0.1.1 Pre-release identifiers can also be added by appending a
	// dash and dot separated ASCII alphanumeric characters and hyphens. e.g.
	// v0.2.3-alpha.x.12m.5
	ModuleVersion string `json:"moduleVersion,omitempty"`
	// RepositoryLocation: Optional. Location of the Artifact Registry repository.
	// i.e. us-east1 Defaults to the build’s location.
	RepositoryLocation string `json:"repositoryLocation,omitempty"`
	// RepositoryName: Optional. Artifact Registry repository name. Specified Go
	// modules will be zipped and uploaded to Artifact Registry with this location
	// as a prefix. e.g. my-go-repo
	RepositoryName string `json:"repositoryName,omitempty"`
	// RepositoryProjectId: Optional. Project ID of the Artifact Registry
	// repository. Defaults to the build project.
	RepositoryProjectId string `json:"repositoryProjectId,omitempty"`
	// SourcePath: Optional. Source path of the go.mod file in the build's
	// workspace. If not specified, this will default to the current directory.
	// e.g. ~/code/go/mypackage
	SourcePath string `json:"sourcePath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModulePath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModulePath") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1GoModule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1GoModule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1Hash: Container message for hash values.
type GoogleDevtoolsCloudbuildV1Hash struct {
	// Type: The type of hash that was performed.
	//
	// Possible values:
	//   "NONE" - No hash requested.
	//   "SHA256" - Use a sha256 hash.
	//   "MD5" - Use a md5 hash.
	//   "GO_MODULE_H1" - Dirhash of a Go module's source code which is then
	// hex-encoded.
	//   "SHA512" - Use a sha512 hash.
	Type string `json:"type,omitempty"`
	// Value: The hash value.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1Hash) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1Hash
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1HttpConfig: HttpConfig is a configuration for HTTP
// related git operations.
type GoogleDevtoolsCloudbuildV1HttpConfig struct {
	// ProxySecretVersionName: SecretVersion resource of the HTTP proxy URL. The
	// Service Account used in the build (either the default Service Account or
	// user-specified Service Account) should have `secretmanager.versions.access`
	// permissions on this secret. The proxy URL should be in format
	// `protocol://@]proxyhost[:port]`.
	ProxySecretVersionName string `json:"proxySecretVersionName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProxySecretVersionName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProxySecretVersionName") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1HttpConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1HttpConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1InlineSecret: Pairs a set of secret environment
// variables mapped to encrypted values with the Cloud KMS key to use to
// decrypt the value.
type GoogleDevtoolsCloudbuildV1InlineSecret struct {
	// EnvMap: Map of environment variable name to its encrypted value. Secret
	// environment variables must be unique across all of a build's secrets, and
	// must be used by at least one build step. Values can be at most 64 KB in
	// size. There can be at most 100 secret values across all of a build's
	// secrets.
	EnvMap map[string]string `json:"envMap,omitempty"`
	// KmsKeyName: Resource name of Cloud KMS crypto key to decrypt the encrypted
	// value. In format: projects/*/locations/*/keyRings/*/cryptoKeys/*
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnvMap") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnvMap") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1InlineSecret) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1InlineSecret
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1MavenArtifact: A Maven artifact to upload to
// Artifact Registry upon successful completion of all build steps.
type GoogleDevtoolsCloudbuildV1MavenArtifact struct {
	// ArtifactId: Maven `artifactId` value used when uploading the artifact to
	// Artifact Registry.
	ArtifactId string `json:"artifactId,omitempty"`
	// DeployFolder: Optional. Path to a folder containing the files to upload to
	// Artifact Registry. This can be either an absolute path, e.g.
	// `/workspace/my-app/target/`, or a relative path from /workspace, e.g.
	// `my-app/target/`. This field is mutually exclusive with the `path` field.
	DeployFolder string `json:"deployFolder,omitempty"`
	// GroupId: Maven `groupId` value used when uploading the artifact to Artifact
	// Registry.
	GroupId string `json:"groupId,omitempty"`
	// Path: Optional. Path to an artifact in the build's workspace to be uploaded
	// to Artifact Registry. This can be either an absolute path, e.g.
	// /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar or a relative path from
	// /workspace, e.g. my-app/target/my-app-1.0.SNAPSHOT.jar.
	Path string `json:"path,omitempty"`
	// Repository: Artifact Registry repository, in the form
	// "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY" Artifact in the
	// workspace specified by path will be uploaded to Artifact Registry with this
	// location as a prefix.
	Repository string `json:"repository,omitempty"`
	// Version: Maven `version` value used when uploading the artifact to Artifact
	// Registry.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArtifactId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArtifactId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1MavenArtifact) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1MavenArtifact
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1NpmPackage: Npm package to upload to Artifact
// Registry upon successful completion of all build steps.
type GoogleDevtoolsCloudbuildV1NpmPackage struct {
	// PackagePath: Optional. Path to the package.json. e.g.
	// workspace/path/to/package Only one of `archive` or `package_path` can be
	// specified.
	PackagePath string `json:"packagePath,omitempty"`
	// Repository: Artifact Registry repository, in the form
	// "https://$REGION-npm.pkg.dev/$PROJECT/$REPOSITORY" Npm package in the
	// workspace specified by path will be zipped and uploaded to Artifact Registry
	// with this location as a prefix.
	Repository string `json:"repository,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PackagePath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PackagePath") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1NpmPackage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1NpmPackage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1PoolOption: Details about how a build should be
// executed on a `WorkerPool`. See running builds in a private pool
// (https://cloud.google.com/build/docs/private-pools/run-builds-in-private-pool)
// for more information.
type GoogleDevtoolsCloudbuildV1PoolOption struct {
	// Name: The `WorkerPool` resource to execute the build on. You must have
	// `cloudbuild.workerpools.use` on the project hosting the WorkerPool. Format
	// projects/{project}/locations/{location}/workerPools/{workerPoolId}
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1PoolOption) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1PoolOption
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1PythonPackage: Python package to upload to
// Artifact Registry upon successful completion of all build steps. A package
// can encapsulate multiple objects to be uploaded to a single repository.
type GoogleDevtoolsCloudbuildV1PythonPackage struct {
	// Paths: Path globs used to match files in the build's workspace. For Python/
	// Twine, this is usually `dist/*`, and sometimes additionally an `.asc` file.
	Paths []string `json:"paths,omitempty"`
	// Repository: Artifact Registry repository, in the form
	// "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY" Files in the workspace
	// matching any path pattern will be uploaded to Artifact Registry with this
	// location as a prefix.
	Repository string `json:"repository,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Paths") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Paths") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1PythonPackage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1PythonPackage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1RepoSource: Location of the source in a Google
// Cloud Source Repository.
type GoogleDevtoolsCloudbuildV1RepoSource struct {
	// BranchName: Regex matching branches to build. The syntax of the regular
	// expressions accepted is the syntax accepted by RE2 and described at
	// https://github.com/google/re2/wiki/Syntax
	BranchName string `json:"branchName,omitempty"`
	// CommitSha: Explicit commit SHA to build.
	CommitSha string `json:"commitSha,omitempty"`
	// Dir: Optional. Directory, relative to the source root, in which to run the
	// build. This must be a relative path. If a step's `dir` is specified and is
	// an absolute path, this value is ignored for that step's execution.
	Dir string `json:"dir,omitempty"`
	// InvertRegex: Optional. Only trigger a build if the revision regex does NOT
	// match the revision regex.
	InvertRegex bool `json:"invertRegex,omitempty"`
	// ProjectId: Optional. ID of the project that owns the Cloud Source
	// Repository. If omitted, the project ID requesting the build is assumed.
	ProjectId string `json:"projectId,omitempty"`
	// RepoName: Required. Name of the Cloud Source Repository.
	RepoName string `json:"repoName,omitempty"`
	// Substitutions: Optional. Substitutions to use in a triggered build. Should
	// only be used with RunBuildTrigger
	Substitutions map[string]string `json:"substitutions,omitempty"`
	// TagName: Regex matching tags to build. The syntax of the regular expressions
	// accepted is the syntax accepted by RE2 and described at
	// https://github.com/google/re2/wiki/Syntax
	TagName string `json:"tagName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BranchName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BranchName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1RepoSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1RepoSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1Results: Artifacts created by the build pipeline.
type GoogleDevtoolsCloudbuildV1Results struct {
	// ArtifactManifest: Path to the artifact manifest for non-container artifacts
	// uploaded to Cloud Storage. Only populated when artifacts are uploaded to
	// Cloud Storage.
	ArtifactManifest string `json:"artifactManifest,omitempty"`
	// ArtifactTiming: Time to push all non-container artifacts to Cloud Storage.
	ArtifactTiming *GoogleDevtoolsCloudbuildV1TimeSpan `json:"artifactTiming,omitempty"`
	// BuildStepImages: List of build step digests, in the order corresponding to
	// build step indices.
	BuildStepImages []string `json:"buildStepImages,omitempty"`
	// BuildStepOutputs: List of build step outputs, produced by builder images, in
	// the order corresponding to build step indices. Cloud Builders
	// (https://cloud.google.com/cloud-build/docs/cloud-builders) can produce this
	// output by writing to `$BUILDER_OUTPUT/output`. Only the first 50KB of data
	// is stored. Note that the `$BUILDER_OUTPUT` variable is read-only and can't
	// be substituted.
	BuildStepOutputs []string `json:"buildStepOutputs,omitempty"`
	// GoModules: Optional. Go module artifacts uploaded to Artifact Registry at
	// the end of the build.
	GoModules []*GoogleDevtoolsCloudbuildV1UploadedGoModule `json:"goModules,omitempty"`
	// Images: Container images that were built as a part of the build.
	Images []*GoogleDevtoolsCloudbuildV1BuiltImage `json:"images,omitempty"`
	// MavenArtifacts: Maven artifacts uploaded to Artifact Registry at the end of
	// the build.
	MavenArtifacts []*GoogleDevtoolsCloudbuildV1UploadedMavenArtifact `json:"mavenArtifacts,omitempty"`
	// NpmPackages: Npm packages uploaded to Artifact Registry at the end of the
	// build.
	NpmPackages []*GoogleDevtoolsCloudbuildV1UploadedNpmPackage `json:"npmPackages,omitempty"`
	// NumArtifacts: Number of non-container artifacts uploaded to Cloud Storage.
	// Only populated when artifacts are uploaded to Cloud Storage.
	NumArtifacts int64 `json:"numArtifacts,omitempty,string"`
	// PythonPackages: Python artifacts uploaded to Artifact Registry at the end of
	// the build.
	PythonPackages []*GoogleDevtoolsCloudbuildV1UploadedPythonPackage `json:"pythonPackages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArtifactManifest") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArtifactManifest") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1Results) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1Results
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1Secret: Pairs a set of secret environment
// variables containing encrypted values with the Cloud KMS key to use to
// decrypt the value. Note: Use `kmsKeyName` with `available_secrets` instead
// of using `kmsKeyName` with `secret`. For instructions see:
// https://cloud.google.com/cloud-build/docs/securing-builds/use-encrypted-credentials.
type GoogleDevtoolsCloudbuildV1Secret struct {
	// KmsKeyName: Cloud KMS key name to use to decrypt these envs.
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// SecretEnv: Map of environment variable name to its encrypted value. Secret
	// environment variables must be unique across all of a build's secrets, and
	// must be used by at least one build step. Values can be at most 64 KB in
	// size. There can be at most 100 secret values across all of a build's
	// secrets.
	SecretEnv map[string]string `json:"secretEnv,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KmsKeyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKeyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1Secret) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1Secret
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1SecretManagerSecret: Pairs a secret environment
// variable with a SecretVersion in Secret Manager.
type GoogleDevtoolsCloudbuildV1SecretManagerSecret struct {
	// Env: Environment variable name to associate with the secret. Secret
	// environment variables must be unique across all of a build's secrets, and
	// must be used by at least one build step.
	Env string `json:"env,omitempty"`
	// VersionName: Resource name of the SecretVersion. In format:
	// projects/*/secrets/*/versions/*
	VersionName string `json:"versionName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Env") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Env") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1SecretManagerSecret) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1SecretManagerSecret
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1Secrets: Secrets and secret environment variables.
type GoogleDevtoolsCloudbuildV1Secrets struct {
	// Inline: Secrets encrypted with KMS key and the associated secret environment
	// variable.
	Inline []*GoogleDevtoolsCloudbuildV1InlineSecret `json:"inline,omitempty"`
	// SecretManager: Secrets in Secret Manager and associated secret environment
	// variable.
	SecretManager []*GoogleDevtoolsCloudbuildV1SecretManagerSecret `json:"secretManager,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Inline") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Inline") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1Secrets) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1Secrets
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1Source: Location of the source in a supported
// storage service.
type GoogleDevtoolsCloudbuildV1Source struct {
	// ConnectedRepository: Optional. If provided, get the source from this 2nd-gen
	// Google Cloud Build repository resource.
	ConnectedRepository *GoogleDevtoolsCloudbuildV1ConnectedRepository `json:"connectedRepository,omitempty"`
	// DeveloperConnectConfig: If provided, get the source from this Developer
	// Connect config.
	DeveloperConnectConfig *GoogleDevtoolsCloudbuildV1DeveloperConnectConfig `json:"developerConnectConfig,omitempty"`
	// GitSource: If provided, get the source from this Git repository.
	GitSource *GoogleDevtoolsCloudbuildV1GitSource `json:"gitSource,omitempty"`
	// RepoSource: If provided, get the source from this location in a Cloud Source
	// Repository.
	RepoSource *GoogleDevtoolsCloudbuildV1RepoSource `json:"repoSource,omitempty"`
	// StorageSource: If provided, get the source from this location in Cloud
	// Storage.
	StorageSource *GoogleDevtoolsCloudbuildV1StorageSource `json:"storageSource,omitempty"`
	// StorageSourceManifest: If provided, get the source from this manifest in
	// Cloud Storage. This feature is in Preview; see description here
	// (https://github.com/GoogleCloudPlatform/cloud-builders/tree/master/gcs-fetcher).
	StorageSourceManifest *GoogleDevtoolsCloudbuildV1StorageSourceManifest `json:"storageSourceManifest,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectedRepository") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectedRepository") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1Source) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1Source
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1SourceProvenance: Provenance of the source. Ways
// to find the original source, or verify that some source was used for this
// build.
type GoogleDevtoolsCloudbuildV1SourceProvenance struct {
	// FileHashes: Output only. Hash(es) of the build source, which can be used to
	// verify that the original source integrity was maintained in the build. Note
	// that `FileHashes` will only be populated if `BuildOptions` has requested a
	// `SourceProvenanceHash`. The keys to this map are file paths used as build
	// source and the values contain the hash values for those files. If the build
	// source came in a single package such as a gzipped tarfile (`.tar.gz`), the
	// `FileHash` will be for the single path to that file.
	FileHashes map[string]GoogleDevtoolsCloudbuildV1FileHashes `json:"fileHashes,omitempty"`
	// ResolvedConnectedRepository: Output only. A copy of the build's
	// `source.connected_repository`, if exists, with any revisions resolved.
	ResolvedConnectedRepository *GoogleDevtoolsCloudbuildV1ConnectedRepository `json:"resolvedConnectedRepository,omitempty"`
	// ResolvedGitSource: Output only. A copy of the build's `source.git_source`,
	// if exists, with any revisions resolved.
	ResolvedGitSource *GoogleDevtoolsCloudbuildV1GitSource `json:"resolvedGitSource,omitempty"`
	// ResolvedRepoSource: A copy of the build's `source.repo_source`, if exists,
	// with any revisions resolved.
	ResolvedRepoSource *GoogleDevtoolsCloudbuildV1RepoSource `json:"resolvedRepoSource,omitempty"`
	// ResolvedStorageSource: A copy of the build's `source.storage_source`, if
	// exists, with any generations resolved.
	ResolvedStorageSource *GoogleDevtoolsCloudbuildV1StorageSource `json:"resolvedStorageSource,omitempty"`
	// ResolvedStorageSourceManifest: A copy of the build's
	// `source.storage_source_manifest`, if exists, with any revisions resolved.
	// This feature is in Preview.
	ResolvedStorageSourceManifest *GoogleDevtoolsCloudbuildV1StorageSourceManifest `json:"resolvedStorageSourceManifest,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileHashes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileHashes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1SourceProvenance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1SourceProvenance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1StorageSource: Location of the source in an
// archive file in Cloud Storage.
type GoogleDevtoolsCloudbuildV1StorageSource struct {
	// Bucket: Cloud Storage bucket containing the source (see Bucket Name
	// Requirements
	// (https://cloud.google.com/storage/docs/bucket-naming#requirements)).
	Bucket string `json:"bucket,omitempty"`
	// Generation: Optional. Cloud Storage generation for the object. If the
	// generation is omitted, the latest generation will be used.
	Generation int64 `json:"generation,omitempty,string"`
	// Object: Required. Cloud Storage object containing the source. This object
	// must be a zipped (`.zip`) or gzipped archive file (`.tar.gz`) containing
	// source to build.
	Object string `json:"object,omitempty"`
	// SourceFetcher: Optional. Option to specify the tool to fetch the source file
	// for the build.
	//
	// Possible values:
	//   "SOURCE_FETCHER_UNSPECIFIED" - Unspecified defaults to GSUTIL.
	//   "GSUTIL" - Use the "gsutil" tool to download the source file.
	//   "GCS_FETCHER" - Use the Cloud Storage Fetcher tool to download the source
	// file.
	SourceFetcher string `json:"sourceFetcher,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bucket") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bucket") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1StorageSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1StorageSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1StorageSourceManifest: Location of the source
// manifest in Cloud Storage. This feature is in Preview; see description here
// (https://github.com/GoogleCloudPlatform/cloud-builders/tree/master/gcs-fetcher).
type GoogleDevtoolsCloudbuildV1StorageSourceManifest struct {
	// Bucket: Required. Cloud Storage bucket containing the source manifest (see
	// Bucket Name Requirements
	// (https://cloud.google.com/storage/docs/bucket-naming#requirements)).
	Bucket string `json:"bucket,omitempty"`
	// Generation: Cloud Storage generation for the object. If the generation is
	// omitted, the latest generation will be used.
	Generation int64 `json:"generation,omitempty,string"`
	// Object: Required. Cloud Storage object containing the source manifest. This
	// object must be a JSON file.
	Object string `json:"object,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bucket") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bucket") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1StorageSourceManifest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1StorageSourceManifest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1TimeSpan: Start and end times for a build
// execution phase.
type GoogleDevtoolsCloudbuildV1TimeSpan struct {
	// EndTime: End of time span.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Start of time span.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1TimeSpan) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1TimeSpan
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1UploadedGoModule: A Go module artifact uploaded to
// Artifact Registry using the GoModule directive.
type GoogleDevtoolsCloudbuildV1UploadedGoModule struct {
	// ArtifactRegistryPackage: Output only. Path to the artifact in Artifact
	// Registry.
	ArtifactRegistryPackage string `json:"artifactRegistryPackage,omitempty"`
	// FileHashes: Hash types and values of the Go Module Artifact.
	FileHashes *GoogleDevtoolsCloudbuildV1FileHashes `json:"fileHashes,omitempty"`
	// PushTiming: Output only. Stores timing information for pushing the specified
	// artifact.
	PushTiming *GoogleDevtoolsCloudbuildV1TimeSpan `json:"pushTiming,omitempty"`
	// Uri: URI of the uploaded artifact.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArtifactRegistryPackage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArtifactRegistryPackage") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1UploadedGoModule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1UploadedGoModule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1UploadedMavenArtifact: A Maven artifact uploaded
// using the MavenArtifact directive.
type GoogleDevtoolsCloudbuildV1UploadedMavenArtifact struct {
	// ArtifactRegistryPackage: Output only. Path to the artifact in Artifact
	// Registry.
	ArtifactRegistryPackage string `json:"artifactRegistryPackage,omitempty"`
	// FileHashes: Hash types and values of the Maven Artifact.
	FileHashes *GoogleDevtoolsCloudbuildV1FileHashes `json:"fileHashes,omitempty"`
	// PushTiming: Output only. Stores timing information for pushing the specified
	// artifact.
	PushTiming *GoogleDevtoolsCloudbuildV1TimeSpan `json:"pushTiming,omitempty"`
	// Uri: URI of the uploaded artifact.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArtifactRegistryPackage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArtifactRegistryPackage") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1UploadedMavenArtifact) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1UploadedMavenArtifact
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1UploadedNpmPackage: An npm package uploaded to
// Artifact Registry using the NpmPackage directive.
type GoogleDevtoolsCloudbuildV1UploadedNpmPackage struct {
	// ArtifactRegistryPackage: Output only. Path to the artifact in Artifact
	// Registry.
	ArtifactRegistryPackage string `json:"artifactRegistryPackage,omitempty"`
	// FileHashes: Hash types and values of the npm package.
	FileHashes *GoogleDevtoolsCloudbuildV1FileHashes `json:"fileHashes,omitempty"`
	// PushTiming: Output only. Stores timing information for pushing the specified
	// artifact.
	PushTiming *GoogleDevtoolsCloudbuildV1TimeSpan `json:"pushTiming,omitempty"`
	// Uri: URI of the uploaded npm package.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArtifactRegistryPackage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArtifactRegistryPackage") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1UploadedNpmPackage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1UploadedNpmPackage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1UploadedPythonPackage: Artifact uploaded using the
// PythonPackage directive.
type GoogleDevtoolsCloudbuildV1UploadedPythonPackage struct {
	// ArtifactRegistryPackage: Output only. Path to the artifact in Artifact
	// Registry.
	ArtifactRegistryPackage string `json:"artifactRegistryPackage,omitempty"`
	// FileHashes: Hash types and values of the Python Artifact.
	FileHashes *GoogleDevtoolsCloudbuildV1FileHashes `json:"fileHashes,omitempty"`
	// PushTiming: Output only. Stores timing information for pushing the specified
	// artifact.
	PushTiming *GoogleDevtoolsCloudbuildV1TimeSpan `json:"pushTiming,omitempty"`
	// Uri: URI of the uploaded artifact.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArtifactRegistryPackage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArtifactRegistryPackage") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1UploadedPythonPackage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1UploadedPythonPackage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1Volume: Volume describes a Docker container volume
// which is mounted into build steps in order to persist files across build
// step execution.
type GoogleDevtoolsCloudbuildV1Volume struct {
	// Name: Name of the volume to mount. Volume names must be unique per build
	// step and must be valid names for Docker volumes. Each named volume must be
	// used by at least two build steps.
	Name string `json:"name,omitempty"`
	// Path: Path at which to mount the volume. Paths must be absolute and cannot
	// conflict with other volume paths on the same build step or with certain
	// reserved volume paths.
	Path string `json:"path,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1Volume) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1Volume
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1Warning: A non-fatal problem encountered during
// the execution of the build.
type GoogleDevtoolsCloudbuildV1Warning struct {
	// Priority: The priority for this warning.
	//
	// Possible values:
	//   "PRIORITY_UNSPECIFIED" - Should not be used.
	//   "INFO" - e.g. deprecation warnings and alternative feature highlights.
	//   "WARNING" - e.g. automated detection of possible issues with the build.
	//   "ALERT" - e.g. alerts that a feature used in the build is pending removal
	Priority string `json:"priority,omitempty"`
	// Text: Explanation of the warning generated.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Priority") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Priority") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1Warning) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1Warning
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`
	// Unreachable: Unordered list. Unreachable resources. Populated when the
	// request sets `ListOperationsRequest.return_partial_success` and reads across
	// collections. For example, when attempting to list all resources across all
	// supported locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningWaitOperationRequest: The request message for
// Operations.WaitOperation.
type GoogleLongrunningWaitOperationRequest struct {
	// Timeout: The maximum duration to wait before timing out. If left blank, the
	// wait will be at most the time permitted by the underlying HTTP/RPC protocol.
	// If RPC context deadline is also specified, the shorter one will be used.
	Timeout string `json:"timeout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Timeout") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Timeout") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningWaitOperationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningWaitOperationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleRpcStatus: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs and RPC
// APIs. It is used by gRPC (https://github.com/grpc). Each `Status` message
// contains three pieces of data: error code, error message, and error details.
// You can find out more about this error model and how to work with it in the
// API Design Guide (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HTTPGetAction: HTTPGetAction describes an action based on HTTP Get requests.
type HTTPGetAction struct {
	// Host: Not supported by Cloud Run.
	Host string `json:"host,omitempty"`
	// HttpHeaders: Custom headers to set in the request. HTTP allows repeated
	// headers.
	HttpHeaders []*HTTPHeader `json:"httpHeaders,omitempty"`
	// Path: Path to access on the HTTP server.
	Path string `json:"path,omitempty"`
	// Port: Port number to access on the container. Number must be in the range 1
	// to 65535.
	Port int64 `json:"port,omitempty"`
	// Scheme: Not supported by Cloud Run.
	Scheme string `json:"scheme,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Host") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Host") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HTTPGetAction) MarshalJSON() ([]byte, error) {
	type NoMethod HTTPGetAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// HTTPHeader: HTTPHeader describes a custom header to be used in HTTP probes
type HTTPHeader struct {
	// Name: Required. The header field name
	Name string `json:"name,omitempty"`
	// Value: The header field value
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s HTTPHeader) MarshalJSON() ([]byte, error) {
	type NoMethod HTTPHeader
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstanceSplit: Holds a single instance split entry for the Worker.
// Allocations can be done to a specific Revision name, or pointing to the
// latest Ready Revision.
type InstanceSplit struct {
	// LatestRevision: Uses the "status.latestReadyRevisionName" to determine the
	// instance split target. When it changes, workloads will automatically migrate
	// from the prior "latest ready" revision to the new one.
	LatestRevision bool `json:"latestRevision,omitempty"`
	// Percent: Optional. Specifies percent of the instance split to this Revision.
	// This defaults to zero if unspecified.
	Percent int64 `json:"percent,omitempty"`
	// RevisionName: Revision to which to assign this portion of instances.
	RevisionName string `json:"revisionName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LatestRevision") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LatestRevision") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstanceSplit) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceSplit
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Job: Job represents the configuration of a single job, which references a
// container image which is run to completion.
type Job struct {
	// ApiVersion: Optional. APIVersion defines the versioned schema of this
	// representation of an object. Servers should convert recognized schemas to
	// the latest internal value, and may reject unrecognized values.
	ApiVersion string `json:"apiVersion,omitempty"`
	// Kind: Optional. Kind is a string value representing the REST resource this
	// object represents. Servers may infer this from the endpoint the client
	// submits requests to. Cannot be updated. In CamelCase.
	Kind string `json:"kind,omitempty"`
	// Metadata: Optional. Standard object's metadata.
	Metadata *ObjectMeta `json:"metadata,omitempty"`
	// Spec: Optional. Specification of the desired behavior of a job.
	Spec *JobSpec `json:"spec,omitempty"`
	// Status: Output only. Current status of a job.
	Status *JobStatus `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Job) MarshalJSON() ([]byte, error) {
	type NoMethod Job
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobSpec: JobSpec describes how the job will look.
type JobSpec struct {
	// RunExecutionToken: A unique string used as a suffix for creating a new
	// execution. The Job will become ready when the execution is successfully
	// completed. The sum of job name and token length must be fewer than 63
	// characters.
	RunExecutionToken string `json:"runExecutionToken,omitempty"`
	// StartExecutionToken: A unique string used as a suffix for creating a new
	// execution. The Job will become ready when the execution is successfully
	// started. The sum of job name and token length must be fewer than 63
	// characters.
	StartExecutionToken string `json:"startExecutionToken,omitempty"`
	// Template: Optional. Describes the execution that will be created when
	// running a job.
	Template *ExecutionTemplateSpec `json:"template,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RunExecutionToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RunExecutionToken") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobSpec) MarshalJSON() ([]byte, error) {
	type NoMethod JobSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// JobStatus: JobStatus represents the current state of a Job.
type JobStatus struct {
	// Conditions: Conditions communicate information about ongoing/complete
	// reconciliation processes that bring the "spec" inline with the observed
	// state of the world. Job-specific conditions include: * `Ready`: `True` when
	// the job is ready to be executed.
	Conditions []*GoogleCloudRunV1Condition `json:"conditions,omitempty"`
	// ExecutionCount: Number of executions created for this job.
	ExecutionCount int64 `json:"executionCount,omitempty"`
	// LatestCreatedExecution: A pointer to the most recently created execution for
	// this job. This is set regardless of the eventual state of the execution.
	LatestCreatedExecution *ExecutionReference `json:"latestCreatedExecution,omitempty"`
	// ObservedGeneration: The 'generation' of the job that was last processed by
	// the controller.
	ObservedGeneration int64 `json:"observedGeneration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conditions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conditions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s JobStatus) MarshalJSON() ([]byte, error) {
	type NoMethod JobStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// KeyToPath: Maps a string key to a path within a volume.
type KeyToPath struct {
	// Key: The Cloud Secret Manager secret version. Can be 'latest' for the latest
	// value, or an integer or a secret alias for a specific version. The key to
	// project.
	Key string `json:"key,omitempty"`
	// Mode: (Optional) Mode bits to use on this file, must be a value between 01
	// and 0777 (octal). If 0 or not set, the Volume's default mode will be used.
	// Notes * Internally, a umask of 0222 will be applied to any non-zero value. *
	// This is an integer representation of the mode bits. So, the octal integer
	// value should look exactly as the chmod numeric notation with a leading zero.
	// Some examples: for chmod 777 (a=rwx), set to 0777 (octal) or 511 (base-10).
	// For chmod 640 (u=rw,g=r), set to 0640 (octal) or 416 (base-10). For chmod
	// 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493 (base-10). * This might be
	// in conflict with other options that affect the file mode, like fsGroup, and
	// the result can be other mode bits set.
	Mode int64 `json:"mode,omitempty"`
	// Path: The relative path of the file to map the key to. May not be an
	// absolute path. May not contain the path element '..'. May not start with the
	// string '..'.
	Path string `json:"path,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s KeyToPath) MarshalJSON() ([]byte, error) {
	type NoMethod KeyToPath
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListAuthorizedDomainsResponse: A list of Authorized Domains.
type ListAuthorizedDomainsResponse struct {
	// Domains: The authorized domains belonging to the user.
	Domains []*AuthorizedDomain `json:"domains,omitempty"`
	// NextPageToken: Continuation token for fetching the next page of results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Domains") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Domains") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListAuthorizedDomainsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAuthorizedDomainsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListConfigurationsResponse: ListConfigurationsResponse is a list of
// Configuration resources.
type ListConfigurationsResponse struct {
	// ApiVersion: The API version for this call such as "serving.knative.dev/v1".
	ApiVersion string `json:"apiVersion,omitempty"`
	// Items: List of Configurations.
	Items []*Configuration `json:"items,omitempty"`
	// Kind: The kind of this resource, in this case "ConfigurationList".
	Kind string `json:"kind,omitempty"`
	// Metadata: Metadata associated with this Configuration list.
	Metadata *ListMeta `json:"metadata,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListConfigurationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListConfigurationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListDomainMappingsResponse: ListDomainMappingsResponse is a list of
// DomainMapping resources.
type ListDomainMappingsResponse struct {
	// ApiVersion: The API version for this call such as "domains.cloudrun.com/v1".
	ApiVersion string `json:"apiVersion,omitempty"`
	// Items: List of DomainMappings.
	Items []*DomainMapping `json:"items,omitempty"`
	// Kind: The kind of this resource, in this case "DomainMappingList".
	Kind string `json:"kind,omitempty"`
	// Metadata: Metadata associated with this DomainMapping list.
	Metadata *ListMeta `json:"metadata,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListDomainMappingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListDomainMappingsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListExecutionsResponse: ListExecutionsResponse is a list of Executions
// resources.
type ListExecutionsResponse struct {
	// ApiVersion: The API version for this call such as "run.googleapis.com/v1".
	ApiVersion string `json:"apiVersion,omitempty"`
	// Items: List of Executions.
	Items []*Execution `json:"items,omitempty"`
	// Kind: The kind of this resource, in this case "ExecutionsList".
	Kind string `json:"kind,omitempty"`
	// Metadata: Metadata associated with this executions list.
	Metadata *ListMeta `json:"metadata,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListExecutionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListExecutionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListJobsResponse: ListJobsResponse is a list of Jobs resources.
type ListJobsResponse struct {
	// ApiVersion: The API version for this call such as "run.googleapis.com/v1".
	ApiVersion string `json:"apiVersion,omitempty"`
	// Items: List of Jobs.
	Items []*Job `json:"items,omitempty"`
	// Kind: The kind of this resource, in this case "JobsList".
	Kind string `json:"kind,omitempty"`
	// Metadata: Metadata associated with this jobs list.
	Metadata *ListMeta `json:"metadata,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListLocationsResponse: The response message for Locations.ListLocations.
type ListLocationsResponse struct {
	// Locations: A list of locations that matches the specified filter in the
	// request.
	Locations []*Location `json:"locations,omitempty"`
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Locations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListLocationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListLocationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListMeta: Metadata for synthetic resources like List. In Cloud Run, all List
// Resources Responses will have a ListMeta instead of ObjectMeta.
type ListMeta struct {
	// Continue: Continuation token is a value emitted when the count of items is
	// larger than the user/system limit. To retrieve the next page of items, pass
	// the value of `continue` as the next request's `page_token`.
	Continue string `json:"continue,omitempty"`
	// ResourceVersion: Opaque string that identifies the server's internal version
	// of this object. It can be used by clients to determine when objects have
	// changed. If the message is passed back to the server, it must be left
	// unmodified.
	ResourceVersion string `json:"resourceVersion,omitempty"`
	// SelfLink: URL representing this object.
	SelfLink string `json:"selfLink,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Continue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Continue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListMeta) MarshalJSON() ([]byte, error) {
	type NoMethod ListMeta
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListRevisionsResponse: ListRevisionsResponse is a list of Revision
// resources.
type ListRevisionsResponse struct {
	// ApiVersion: The API version for this call such as "serving.knative.dev/v1".
	ApiVersion string `json:"apiVersion,omitempty"`
	// Items: List of Revisions.
	Items []*Revision `json:"items,omitempty"`
	// Kind: The kind of this resource, in this case "RevisionList".
	Kind string `json:"kind,omitempty"`
	// Metadata: Metadata associated with this revision list.
	Metadata *ListMeta `json:"metadata,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListRevisionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListRevisionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListRoutesResponse: ListRoutesResponse is a list of Route resources.
type ListRoutesResponse struct {
	// ApiVersion: The API version for this call such as "serving.knative.dev/v1".
	ApiVersion string `json:"apiVersion,omitempty"`
	// Items: List of Routes.
	Items []*Route `json:"items,omitempty"`
	// Kind: The kind of this resource, in this case always "RouteList".
	Kind string `json:"kind,omitempty"`
	// Metadata: Metadata associated with this Route list.
	Metadata *ListMeta `json:"metadata,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListRoutesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListRoutesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListServicesResponse: A list of Service resources.
type ListServicesResponse struct {
	// ApiVersion: The API version for this call; returns "serving.knative.dev/v1".
	ApiVersion string `json:"apiVersion,omitempty"`
	// Items: List of Services.
	Items []*Service `json:"items,omitempty"`
	// Kind: The kind of this resource; returns "ServiceList".
	Kind string `json:"kind,omitempty"`
	// Metadata: Metadata associated with this Service list.
	Metadata *ListMeta `json:"metadata,omitempty"`
	// Unreachable: For calls against the global endpoint, returns the list of
	// Cloud locations that could not be reached. For regional calls, this field is
	// not used.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListServicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListServicesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListTasksResponse: ListTasksResponse is a list of Tasks resources.
type ListTasksResponse struct {
	// ApiVersion: The API version for this call such as "run.googleapis.com/v1".
	ApiVersion string `json:"apiVersion,omitempty"`
	// Items: List of Tasks.
	Items []*Task `json:"items,omitempty"`
	// Kind: The kind of this resource, in this case "TasksList".
	Kind string `json:"kind,omitempty"`
	// Metadata: Metadata associated with this tasks list.
	Metadata *ListMeta `json:"metadata,omitempty"`
	// Unreachable: Locations that could not be reached.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListTasksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListTasksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListWorkerPoolsResponse: A list of WorkerPool resources.
type ListWorkerPoolsResponse struct {
	// ApiVersion: The API version for this call; returns "run.googleapis.com/v1".
	ApiVersion string `json:"apiVersion,omitempty"`
	// Items: List of WorkerPools.
	Items []*WorkerPool `json:"items,omitempty"`
	// Kind: The kind of this resource; returns "WorkerPoolList".
	Kind string `json:"kind,omitempty"`
	// Metadata: Metadata associated with this WorkerPool list.
	Metadata *ListMeta `json:"metadata,omitempty"`
	// Unreachable: For calls against the global endpoint, returns the list of
	// Cloud locations that could not be reached. For regional calls, this field is
	// not used.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListWorkerPoolsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListWorkerPoolsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LocalObjectReference: Not supported by Cloud Run. LocalObjectReference
// contains enough information to let you locate the referenced object inside
// the same namespace.
type LocalObjectReference struct {
	// Name: Name of the referent.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LocalObjectReference) MarshalJSON() ([]byte, error) {
	type NoMethod LocalObjectReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Location: A resource that represents a Google Cloud location.
type Location struct {
	// DisplayName: The friendly name for this location, typically a nearby city
	// name. For example, "Tokyo".
	DisplayName string `json:"displayName,omitempty"`
	// Labels: Cross-service attributes for the location. For example
	// {"cloud.googleapis.com/region": "us-east1"}
	Labels map[string]string `json:"labels,omitempty"`
	// LocationId: The canonical id for this location. For example: "us-east1".
	LocationId string `json:"locationId,omitempty"`
	// Metadata: Service-specific metadata. For example the available capacity at
	// the given location.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: Resource name for the location, which may vary between
	// implementations. For example:
	// "projects/example-project/locations/us-east1"
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Location) MarshalJSON() ([]byte, error) {
	type NoMethod Location
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// NFSVolumeSource: Represents a persistent volume that will be mounted using
// NFS. This volume will be shared between all instances of the resource and
// data will not be deleted when the instance is shut down.
type NFSVolumeSource struct {
	// Path: Path that is exported by the NFS server.
	Path string `json:"path,omitempty"`
	// ReadOnly: If true, mount the NFS volume as read only. Defaults to false.
	ReadOnly bool `json:"readOnly,omitempty"`
	// Server: Hostname or IP address of the NFS server.
	Server string `json:"server,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Path") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Path") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s NFSVolumeSource) MarshalJSON() ([]byte, error) {
	type NoMethod NFSVolumeSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ObjectMeta: google.cloud.run.meta.v1.ObjectMeta is metadata that all
// persisted resources must have, which includes all objects users must create.
type ObjectMeta struct {
	// Annotations: Unstructured key value map stored with a resource that may be
	// set by external tools to store and retrieve arbitrary metadata. They are not
	// queryable and should be preserved when modifying objects. In Cloud Run,
	// annotations with 'run.googleapis.com/' and 'autoscaling.knative.dev' are
	// restricted, and the accepted annotations will be different depending on the
	// resource type. * `autoscaling.knative.dev/maxScale`: Revision. *
	// `autoscaling.knative.dev/minScale`: Revision. *
	// `run.googleapis.com/base-images`: Service, Revision. *
	// `run.googleapis.com/binary-authorization-breakglass`: Service, Job, *
	// `run.googleapis.com/binary-authorization`: Service, Job, Execution. *
	// `run.googleapis.com/build-base-image`: Service. *
	// `run.googleapis.com/build-enable-automatic-updates`: Service. *
	// `run.googleapis.com/build-environment-variables`: Service. *
	// `run.googleapis.com/build-function-target`: Service. *
	// `run.googleapis.com/build-id`: Service. *
	// `run.googleapis.com/build-image-uri`: Service. *
	// `run.googleapis.com/build-name`: Service. *
	// `run.googleapis.com/build-service-account`: Service. *
	// `run.googleapis.com/build-source-location`: Service. *
	// `run.googleapis.com/build-worker-pool`: Service. *
	// `run.googleapis.com/client-name`: All resources. *
	// `run.googleapis.com/cloudsql-instances`: Revision, Execution. *
	// `run.googleapis.com/container-dependencies`: Revision . *
	// `run.googleapis.com/cpu-throttling`: Revision. *
	// `run.googleapis.com/custom-audiences`: Service. *
	// `run.googleapis.com/default-url-disabled`: Service. *
	// `run.googleapis.com/description`: Service. *
	// `run.googleapis.com/encryption-key-shutdown-hours`: Revision *
	// `run.googleapis.com/encryption-key`: Revision, Execution. *
	// `run.googleapis.com/execution-environment`: Revision, Execution. *
	// `run.googleapis.com/gc-traffic-tags`: Service. *
	// `run.googleapis.com/gpu-zonal-redundancy-disabled`: Revision. *
	// `run.googleapis.com/health-check-disabled`: Revision. *
	// `run.googleapis.com/ingress`: Service. * `run.googleapis.com/launch-stage`:
	// Service, Job. * `run.googleapis.com/minScale`: Service. *
	// `run.googleapis.com/maxScale`: Service. *
	// `run.googleapis.com/manualInstanceCount`: Service. *
	// `run.googleapis.com/network-interfaces`: Revision, Execution. *
	// `run.googleapis.com/post-key-revocation-action-type`: Revision.
	// `run.googleapis.com/scalingMode`: Service. * `run.googleapis.com/secrets`:
	// Revision, Execution. * `run.googleapis.com/secure-session-agent`: Revision.
	// * `run.googleapis.com/sessionAffinity`: Revision. *
	// `run.googleapis.com/startup-cpu-boost`: Revision. *
	// `run.googleapis.com/vpc-access-connector`: Revision, Execution. *
	// `run.googleapis.com/vpc-access-egress`: Revision, Execution.
	Annotations map[string]string `json:"annotations,omitempty"`
	// ClusterName: Not supported by Cloud Run
	ClusterName string `json:"clusterName,omitempty"`
	// CreationTimestamp: UTC timestamp representing the server time when this
	// object was created.
	CreationTimestamp string `json:"creationTimestamp,omitempty"`
	// DeletionGracePeriodSeconds: Not supported by Cloud Run
	DeletionGracePeriodSeconds int64 `json:"deletionGracePeriodSeconds,omitempty"`
	// DeletionTimestamp: The read-only soft deletion timestamp for this resource.
	// In Cloud Run, users are not able to set this field. Instead, they must call
	// the corresponding Delete API.
	DeletionTimestamp string `json:"deletionTimestamp,omitempty"`
	// Finalizers: Not supported by Cloud Run
	Finalizers []string `json:"finalizers,omitempty"`
	// GenerateName: Not supported by Cloud Run
	GenerateName string `json:"generateName,omitempty"`
	// Generation: A system-provided sequence number representing a specific
	// generation of the desired state.
	Generation int64 `json:"generation,omitempty"`
	// Labels: Map of string keys and values that can be used to organize and
	// categorize (scope and select) objects. May match selectors of replication
	// controllers and routes.
	Labels map[string]string `json:"labels,omitempty"`
	// Name: Required. The name of the resource. Name is required when creating
	// top-level resources (Service, Job), must be unique within a Cloud Run
	// project/region, and cannot be changed once created.
	Name string `json:"name,omitempty"`
	// Namespace: Required. Defines the space within each name must be unique
	// within a Cloud Run region. In Cloud Run, it must be project ID or number.
	Namespace string `json:"namespace,omitempty"`
	// OwnerReferences: Not supported by Cloud Run
	OwnerReferences []*OwnerReference `json:"ownerReferences,omitempty"`
	// ResourceVersion: Opaque, system-generated value that represents the internal
	// version of this object that can be used by clients to determine when objects
	// have changed. May be used for optimistic concurrency, change detection, and
	// the watch operation on a resource or set of resources. Clients must treat
	// these values as opaque and passed unmodified back to the server or omit the
	// value to disable conflict-detection.
	ResourceVersion string `json:"resourceVersion,omitempty"`
	// SelfLink: URL representing this object.
	SelfLink string `json:"selfLink,omitempty"`
	// Uid: Unique, system-generated identifier for this resource.
	Uid string `json:"uid,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ObjectMeta) MarshalJSON() ([]byte, error) {
	type NoMethod ObjectMeta
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Overrides: RunJob Overrides that contains Execution fields to be overridden
// on the go.
type Overrides struct {
	// ContainerOverrides: Per container override specification.
	ContainerOverrides []*ContainerOverride `json:"containerOverrides,omitempty"`
	// TaskCount: The desired number of tasks the execution should run. Will
	// replace existing task_count value.
	TaskCount int64 `json:"taskCount,omitempty"`
	// TimeoutSeconds: Duration in seconds the task may be active before the system
	// will actively try to mark it failed and kill associated containers. Will
	// replace existing timeout_seconds value.
	TimeoutSeconds int64 `json:"timeoutSeconds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContainerOverrides") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainerOverrides") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Overrides) MarshalJSON() ([]byte, error) {
	type NoMethod Overrides
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OwnerReference: This is not supported or used by Cloud Run.
type OwnerReference struct {
	// ApiVersion: This is not supported or used by Cloud Run.
	ApiVersion string `json:"apiVersion,omitempty"`
	// BlockOwnerDeletion: This is not supported or used by Cloud Run.
	BlockOwnerDeletion bool `json:"blockOwnerDeletion,omitempty"`
	// Controller: This is not supported or used by Cloud Run.
	Controller bool `json:"controller,omitempty"`
	// Kind: This is not supported or used by Cloud Run.
	Kind string `json:"kind,omitempty"`
	// Name: This is not supported or used by Cloud Run.
	Name string `json:"name,omitempty"`
	// Uid: This is not supported or used by Cloud Run.
	Uid string `json:"uid,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OwnerReference) MarshalJSON() ([]byte, error) {
	type NoMethod OwnerReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Policy: An Identity and Access Management (IAM) policy, which specifies
// access controls for Google Cloud resources. A `Policy` is a collection of
// `bindings`. A `binding` binds one or more `members`, or principals, to a
// single `role`. Principals can be user accounts, service accounts, Google
// groups, and domains (such as G Suite). A `role` is a named list of
// permissions; each `role` can be an IAM predefined role or a user-created
// custom role. For some types of Google Cloud resources, a `binding` can also
// specify a `condition`, which is a logical expression that allows access to a
// resource only if the expression evaluates to `true`. A condition can add
// constraints based on attributes of the request, the resource, or both. To
// learn which resources support conditions in their IAM policies, see the IAM
// documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies). **JSON
// example:** ``` { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
// "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
// "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
// role: roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access after
// Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
// etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
// see the IAM documentation (https://cloud.google.com/iam/docs/).
type Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this policy.
	AuditConfigs []*AuditConfig `json:"auditConfigs,omitempty"`
	// Bindings: Associates a list of `members`, or principals, with a `role`.
	// Optionally, may specify a `condition` that determines how and when the
	// `bindings` are applied. Each of the `bindings` must contain at least one
	// principal. The `bindings` in a `Policy` can refer to up to 1,500 principals;
	// up to 250 of these principals can be Google groups. Each occurrence of a
	// principal counts towards these limits. For example, if the `bindings` grant
	// 50 different roles to `user:alice@example.com`, and not to any other
	// principal, then you can add another 1,450 principals to the `bindings` in
	// the `Policy`.
	Bindings []*Binding `json:"bindings,omitempty"`
	// Etag: `etag` is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of a policy from overwriting each other. It is
	// strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform policy updates in order to avoid race
	// conditions: An `etag` is returned in the response to `getIamPolicy`, and
	// systems are expected to put that etag in the request to `setIamPolicy` to
	// ensure that their change will be applied to the same version of the policy.
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`
	// Version: Specifies the format of the policy. Valid values are `0`, `1`, and
	// `3`. Requests that specify an invalid value are rejected. Any operation that
	// affects conditional role bindings must specify version `3`. This requirement
	// applies to the following operations: * Getting a policy that includes a
	// conditional role binding * Adding a conditional role binding to a policy *
	// Changing a conditional role binding in a policy * Removing any role binding,
	// with or without a condition, from a policy that includes conditions
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost. If a policy does not
	// include any conditions, operations on that policy may specify any valid
	// version or leave the field unset. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Policy) MarshalJSON() ([]byte, error) {
	type NoMethod Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Probe: Probe describes a health check to be performed against a container to
// determine whether it is alive or ready to receive traffic.
type Probe struct {
	// Exec: Not supported by Cloud Run.
	Exec *ExecAction `json:"exec,omitempty"`
	// FailureThreshold: Minimum consecutive failures for the probe to be
	// considered failed after having succeeded. Defaults to 3. Minimum value is 1.
	FailureThreshold int64 `json:"failureThreshold,omitempty"`
	// Grpc: GRPCAction specifies an action involving a GRPC port.
	Grpc *GRPCAction `json:"grpc,omitempty"`
	// HttpGet: HTTPGet specifies the http request to perform.
	HttpGet *HTTPGetAction `json:"httpGet,omitempty"`
	// InitialDelaySeconds: Number of seconds after the container has started
	// before the probe is initiated. Defaults to 0 seconds. Minimum value is 0.
	// Maximum value for liveness probe is 3600. Maximum value for startup probe is
	// 240.
	InitialDelaySeconds int64 `json:"initialDelaySeconds,omitempty"`
	// PeriodSeconds: How often (in seconds) to perform the probe. Default to 10
	// seconds. Minimum value is 1. Maximum value for liveness probe is 3600.
	// Maximum value for startup probe is 240. Must be greater or equal than
	// timeout_seconds.
	PeriodSeconds int64 `json:"periodSeconds,omitempty"`
	// SuccessThreshold: Minimum consecutive successes for the probe to be
	// considered successful after having failed. Must be 1 if set.
	SuccessThreshold int64 `json:"successThreshold,omitempty"`
	// TcpSocket: TCPSocket specifies an action involving a TCP port.
	TcpSocket *TCPSocketAction `json:"tcpSocket,omitempty"`
	// TimeoutSeconds: Number of seconds after which the probe times out. Defaults
	// to 1 second. Minimum value is 1. Maximum value is 3600. Must be smaller than
	// period_seconds; if period_seconds is not set, must be less or equal than 10.
	TimeoutSeconds int64 `json:"timeoutSeconds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Exec") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Exec") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Probe) MarshalJSON() ([]byte, error) {
	type NoMethod Probe
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResourceRecord: A DNS resource record.
type ResourceRecord struct {
	// Name: Relative name of the object affected by this record. Only applicable
	// for `CNAME` records. Example: 'www'.
	Name string `json:"name,omitempty"`
	// Rrdata: Data for this record. Values vary by record type, as defined in RFC
	// 1035 (section 5) and RFC 1034 (section 3.6.1).
	Rrdata string `json:"rrdata,omitempty"`
	// Type: Resource record type. Example: `AAAA`.
	//
	// Possible values:
	//   "RECORD_TYPE_UNSPECIFIED" - An unknown resource record.
	//   "A" - An A resource record. Data is an IPv4 address.
	//   "AAAA" - An AAAA resource record. Data is an IPv6 address.
	//   "CNAME" - A CNAME resource record. Data is a domain name to be aliased.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceRecord) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceRecord
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ResourceRequirements: ResourceRequirements describes the compute resource
// requirements.
type ResourceRequirements struct {
	// Limits: Limits describes the maximum amount of compute resources allowed.
	// Only 'cpu', 'memory' and 'nvidia.com/gpu' keys are supported. * For
	// supported 'cpu' values, go to
	// https://cloud.google.com/run/docs/configuring/cpu. * For supported 'memory'
	// values and syntax, go to
	// https://cloud.google.com/run/docs/configuring/memory-limits. * The only
	// supported 'nvidia.com/gpu' value is '1'.
	Limits map[string]string `json:"limits,omitempty"`
	// Requests: Requests describes the minimum amount of compute resources
	// required. Only `cpu` and `memory` are supported. If Requests is omitted for
	// a container, it defaults to Limits if that is explicitly specified,
	// otherwise to an implementation-defined value. * For supported 'cpu' values,
	// go to https://cloud.google.com/run/docs/configuring/cpu. * For supported
	// 'memory' values and syntax, go to
	// https://cloud.google.com/run/docs/configuring/memory-limits
	Requests map[string]string `json:"requests,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Limits") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Limits") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ResourceRequirements) MarshalJSON() ([]byte, error) {
	type NoMethod ResourceRequirements
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Revision: Revision is an immutable snapshot of code and configuration. A
// revision references a container image. Revisions are created by updates to a
// Configuration. See also:
// https://github.com/knative/specs/blob/main/specs/serving/overview.md#revision
type Revision struct {
	// ApiVersion: The API version for this call such as "serving.knative.dev/v1".
	ApiVersion string `json:"apiVersion,omitempty"`
	// Kind: The kind of this resource, in this case "Revision".
	Kind string `json:"kind,omitempty"`
	// Metadata: Metadata associated with this Revision, including name, namespace,
	// labels, and annotations.
	Metadata *ObjectMeta `json:"metadata,omitempty"`
	// Spec: Spec holds the desired state of the Revision (from the client).
	Spec *RevisionSpec `json:"spec,omitempty"`
	// Status: Status communicates the observed state of the Revision (from the
	// controller).
	Status *RevisionStatus `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Revision) MarshalJSON() ([]byte, error) {
	type NoMethod Revision
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RevisionSpec: RevisionSpec holds the desired state of the Revision (from the
// client).
type RevisionSpec struct {
	// ContainerConcurrency: ContainerConcurrency specifies the maximum allowed
	// in-flight (concurrent) requests per container instance of the Revision. If
	// not specified or 0, defaults to 80 when requested CPU >= 1 and defaults to 1
	// when requested CPU < 1.
	ContainerConcurrency int64 `json:"containerConcurrency,omitempty"`
	// Containers: Required. Containers holds the list which define the units of
	// execution for this Revision. In the context of a Revision, we disallow a
	// number of fields on this Container, including: name and lifecycle.
	Containers []*Container `json:"containers,omitempty"`
	// EnableServiceLinks: Not supported by Cloud Run.
	EnableServiceLinks bool `json:"enableServiceLinks,omitempty"`
	// ImagePullSecrets: Not supported by Cloud Run.
	ImagePullSecrets []*LocalObjectReference `json:"imagePullSecrets,omitempty"`
	// NodeSelector: Optional. The Node Selector configuration. Map of selector key
	// to a value which matches a node.
	NodeSelector map[string]string `json:"nodeSelector,omitempty"`
	// RuntimeClassName: Optional. Runtime. Leave unset for default.
	RuntimeClassName string `json:"runtimeClassName,omitempty"`
	// ServiceAccountName: Email address of the IAM service account associated with
	// the revision of the service. The service account represents the identity of
	// the running revision, and determines what permissions the revision has. If
	// not provided, the revision will use the project's default service account.
	ServiceAccountName string `json:"serviceAccountName,omitempty"`
	// TimeoutSeconds: Optional. TimeoutSeconds holds the max duration the instance
	// is allowed for responding to a request. Cloud Run: defaults to 300 seconds
	// (5 minutes). Maximum allowed value is 3600 seconds (1 hour).
	TimeoutSeconds int64     `json:"timeoutSeconds,omitempty"`
	Volumes        []*Volume `json:"volumes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContainerConcurrency") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainerConcurrency") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RevisionSpec) MarshalJSON() ([]byte, error) {
	type NoMethod RevisionSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RevisionStatus: RevisionStatus communicates the observed state of the
// Revision (from the controller).
type RevisionStatus struct {
	// Conditions: Conditions communicate information about ongoing/complete
	// reconciliation processes that bring the "spec" inline with the observed
	// state of the world. As a Revision is being prepared, it will incrementally
	// update conditions. Revision-specific conditions include: *
	// `ResourcesAvailable`: `True` when underlying resources have been
	// provisioned. * `ContainerHealthy`: `True` when the Revision readiness check
	// completes. * `Active`: `True` when the Revision may receive traffic.
	Conditions []*GoogleCloudRunV1Condition `json:"conditions,omitempty"`
	// DesiredReplicas: Output only. The configured number of instances running
	// this revision. For Cloud Run, this only includes instances provisioned using
	// the minScale annotation. It does not include instances created by
	// autoscaling.
	DesiredReplicas int64 `json:"desiredReplicas,omitempty"`
	// ImageDigest: ImageDigest holds the resolved digest for the image specified
	// within .Spec.Container.Image. The digest is resolved during the creation of
	// Revision. This field holds the digest value regardless of whether a tag or
	// digest was originally specified in the Container object.
	ImageDigest string `json:"imageDigest,omitempty"`
	// LogUrl: Optional. Specifies the generated logging url for this particular
	// revision based on the revision url template specified in the controller's
	// config.
	LogUrl string `json:"logUrl,omitempty"`
	// ObservedGeneration: ObservedGeneration is the 'Generation' of the Revision
	// that was last processed by the controller. Clients polling for completed
	// reconciliation should poll until observedGeneration = metadata.generation,
	// and the Ready condition's status is True or False.
	ObservedGeneration int64 `json:"observedGeneration,omitempty"`
	// ServiceName: Not currently used by Cloud Run.
	ServiceName string `json:"serviceName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conditions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conditions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RevisionStatus) MarshalJSON() ([]byte, error) {
	type NoMethod RevisionStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RevisionTemplate: RevisionTemplateSpec describes the data a revision should
// have when created from a template.
type RevisionTemplate struct {
	// Metadata: Optional metadata for this Revision, including labels and
	// annotations. Name will be generated by the Configuration. The following
	// annotation keys set properties of the created revision: *
	// `autoscaling.knative.dev/minScale` sets the minimum number of instances. *
	// `autoscaling.knative.dev/maxScale` sets the maximum number of instances. *
	// `run.googleapis.com/cloudsql-instances` sets Cloud SQL connections. Multiple
	// values should be comma separated. *
	// `run.googleapis.com/health-check-disabled`: if true, deploy-time startup
	// probes will not run for this revision. *
	// `run.googleapis.com/vpc-access-connector` sets a Serverless VPC Access
	// connector. * `run.googleapis.com/vpc-access-egress` sets VPC egress.
	// Supported values are `all-traffic`, `all` (deprecated), and
	// `private-ranges-only`. `all-traffic` and `all` provide the same
	// functionality. `all` is deprecated but will continue to be supported. Prefer
	// `all-traffic`.
	Metadata *ObjectMeta `json:"metadata,omitempty"`
	// Spec: RevisionSpec holds the desired state of the Revision (from the
	// client).
	Spec *RevisionSpec `json:"spec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RevisionTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod RevisionTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Route: Route is responsible for configuring ingress over a collection of
// Revisions. Some of the Revisions a Route distributes traffic over may be
// specified by referencing the Configuration responsible for creating them; in
// these cases the Route is additionally responsible for monitoring the
// Configuration for "latest ready" revision changes, and smoothly rolling out
// latest revisions. Cloud Run currently supports referencing a single
// Configuration to automatically deploy the "latest ready" Revision from that
// Configuration.
type Route struct {
	// ApiVersion: The API version for this call such as "serving.knative.dev/v1".
	ApiVersion string `json:"apiVersion,omitempty"`
	// Kind: The kind of this resource, in this case always "Route".
	Kind string `json:"kind,omitempty"`
	// Metadata: Metadata associated with this Route, including name, namespace,
	// labels, and annotations.
	Metadata *ObjectMeta `json:"metadata,omitempty"`
	// Spec: Spec holds the desired state of the Route (from the client).
	Spec *RouteSpec `json:"spec,omitempty"`
	// Status: Status communicates the observed state of the Route (from the
	// controller).
	Status *RouteStatus `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Route) MarshalJSON() ([]byte, error) {
	type NoMethod Route
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RouteSpec: RouteSpec holds the desired state of the Route (from the client).
type RouteSpec struct {
	// Traffic: Traffic specifies how to distribute traffic over a collection of
	// Knative Revisions and Configurations. Cloud Run currently supports a single
	// configurationName.
	Traffic []*TrafficTarget `json:"traffic,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Traffic") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Traffic") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RouteSpec) MarshalJSON() ([]byte, error) {
	type NoMethod RouteSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RouteStatus: RouteStatus communicates the observed state of the Route (from
// the controller).
type RouteStatus struct {
	// Address: Similar to url, information on where the service is available on
	// HTTP.
	Address *Addressable `json:"address,omitempty"`
	// Conditions: Conditions communicates information about ongoing/complete
	// reconciliation processes that bring the "spec" inline with the observed
	// state of the world.
	Conditions []*GoogleCloudRunV1Condition `json:"conditions,omitempty"`
	// ObservedGeneration: ObservedGeneration is the 'Generation' of the Route that
	// was last processed by the controller. Clients polling for completed
	// reconciliation should poll until observedGeneration = metadata.generation
	// and the Ready condition's status is True or False. Note that providing a
	// TrafficTarget that has latest_revision=True will result in a Route that does
	// not increment either its metadata.generation or its observedGeneration, as
	// new "latest ready" revisions from the Configuration are processed without an
	// update to the Route's spec.
	ObservedGeneration int64 `json:"observedGeneration,omitempty"`
	// Traffic: Traffic holds the configured traffic distribution. These entries
	// will always contain RevisionName references. When ConfigurationName appears
	// in the spec, this will hold the LatestReadyRevisionName that was last
	// observed.
	Traffic []*TrafficTarget `json:"traffic,omitempty"`
	// Url: URL holds the url that will distribute traffic over the provided
	// traffic targets. It generally has the form:
	// `https://{route-hash}-{project-hash}-{cluster-level-suffix}.a.run.app`
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Address") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Address") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RouteStatus) MarshalJSON() ([]byte, error) {
	type NoMethod RouteStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RunJobRequest: Request message for creating a new execution of a job.
type RunJobRequest struct {
	// Overrides: Optional. Overrides existing job configuration for one specific
	// new job execution only, using the specified values to update the job
	// configuration for the new execution.
	Overrides *Overrides `json:"overrides,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Overrides") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Overrides") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RunJobRequest) MarshalJSON() ([]byte, error) {
	type NoMethod RunJobRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SecretEnvSource: Not supported by Cloud Run. SecretEnvSource selects a
// Secret to populate the environment variables with. The contents of the
// target Secret's Data field will represent the key-value pairs as environment
// variables.
type SecretEnvSource struct {
	// LocalObjectReference: This field should not be used directly as it is meant
	// to be inlined directly into the message. Use the "name" field instead.
	LocalObjectReference *LocalObjectReference `json:"localObjectReference,omitempty"`
	// Name: The Secret to select from.
	Name string `json:"name,omitempty"`
	// Optional: Specify whether the Secret must be defined
	Optional bool `json:"optional,omitempty"`
	// ForceSendFields is a list of field names (e.g. "LocalObjectReference") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "LocalObjectReference") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SecretEnvSource) MarshalJSON() ([]byte, error) {
	type NoMethod SecretEnvSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SecretKeySelector: SecretKeySelector selects a key of a Secret.
type SecretKeySelector struct {
	// Key: Required. A Cloud Secret Manager secret version. Must be 'latest' for
	// the latest version, an integer for a specific version, or a version alias.
	// The key of the secret to select from. Must be a valid secret key.
	Key string `json:"key,omitempty"`
	// LocalObjectReference: This field should not be used directly as it is meant
	// to be inlined directly into the message. Use the "name" field instead.
	LocalObjectReference *LocalObjectReference `json:"localObjectReference,omitempty"`
	// Name: The name of the secret in Cloud Secret Manager. By default, the secret
	// is assumed to be in the same project. If the secret is in another project,
	// you must define an alias. An alias definition has the form:
	// :projects//secrets/. If multiple alias definitions are needed, they must be
	// separated by commas. The alias definitions must be set on the
	// run.googleapis.com/secrets annotation. The name of the secret in the pod's
	// namespace to select from.
	Name string `json:"name,omitempty"`
	// Optional: Specify whether the Secret or its key must be defined.
	Optional bool `json:"optional,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Key") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Key") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SecretKeySelector) MarshalJSON() ([]byte, error) {
	type NoMethod SecretKeySelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SecretVolumeSource: A volume representing a secret stored in Google Secret
// Manager. The secret's value will be presented as the content of a file whose
// name is defined in the item path. If no items are defined, the name of the
// file is the secret_name. The contents of the target Secret's Data field will
// be presented in a volume as files using the keys in the Data field as the
// file names.
type SecretVolumeSource struct {
	// DefaultMode: Integer representation of mode bits to use on created files by
	// default. Must be a value between 01 and 0777 (octal). If 0 or not set, it
	// will default to 0444. Directories within the path are not affected by this
	// setting. Notes * Internally, a umask of 0222 will be applied to any non-zero
	// value. * This is an integer representation of the mode bits. So, the octal
	// integer value should look exactly as the chmod numeric notation with a
	// leading zero. Some examples: for chmod 777 (a=rwx), set to 0777 (octal) or
	// 511 (base-10). For chmod 640 (u=rw,g=r), set to 0640 (octal) or 416
	// (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493
	// (base-10). * This might be in conflict with other options that affect the
	// file mode, like fsGroup, and the result can be other mode bits set.
	DefaultMode int64 `json:"defaultMode,omitempty"`
	// Items: A list of secret versions to mount in the volume. If no items are
	// specified, the volume will expose a file with the same name as the secret
	// name. The contents of the file will be the data in the latest version of the
	// secret. If items are specified, the key will be used as the version to fetch
	// from Cloud Secret Manager and the path will be the name of the file exposed
	// in the volume. When items are defined, they must specify both a key and a
	// path.
	Items []*KeyToPath `json:"items,omitempty"`
	// Optional: Not supported by Cloud Run.
	Optional bool `json:"optional,omitempty"`
	// SecretName: The name of the secret in Cloud Secret Manager. By default, the
	// secret is assumed to be in the same project. If the secret is in another
	// project, you must define an alias. An alias definition has the form:
	// :projects//secrets/. If multiple alias definitions are needed, they must be
	// separated by commas. The alias definitions must be set on the
	// run.googleapis.com/secrets annotation. Name of the secret in the container's
	// namespace to use.
	SecretName string `json:"secretName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultMode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SecretVolumeSource) MarshalJSON() ([]byte, error) {
	type NoMethod SecretVolumeSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SecurityContext: Not supported by Cloud Run. SecurityContext holds security
// configuration that will be applied to a container. Some fields are present
// in both SecurityContext and PodSecurityContext. When both are set, the
// values in SecurityContext take precedence.
type SecurityContext struct {
	// RunAsUser: The UID to run the entrypoint of the container process. Defaults
	// to user specified in image metadata if unspecified. May also be set in
	// PodSecurityContext. If set in both SecurityContext and PodSecurityContext,
	// the value specified in SecurityContext takes precedence.
	RunAsUser int64 `json:"runAsUser,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RunAsUser") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RunAsUser") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SecurityContext) MarshalJSON() ([]byte, error) {
	type NoMethod SecurityContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Service: Service acts as a top-level container that manages a set of Routes
// and Configurations which implement a network service. Service exists to
// provide a singular abstraction which can be access controlled, reasoned
// about, and which encapsulates software lifecycle decisions such as rollout
// policy and team resource ownership. Service acts only as an orchestrator of
// the underlying Routes and Configurations (much as a kubernetes Deployment
// orchestrates ReplicaSets). The Service's controller will track the statuses
// of its owned Configuration and Route, reflecting their statuses and
// conditions as its own.
type Service struct {
	// ApiVersion: The API version for this call. It must be
	// "serving.knative.dev/v1".
	ApiVersion string `json:"apiVersion,omitempty"`
	// Kind: The kind of resource. It must be "Service".
	Kind string `json:"kind,omitempty"`
	// Metadata: Metadata associated with this Service, including name, namespace,
	// labels, and annotations. In Cloud Run, annotations with
	// 'run.googleapis.com/' and 'autoscaling.knative.dev' are restricted, and the
	// accepted annotations will be different depending on the resource type. The
	// following Cloud Run-specific annotations are accepted in
	// Service.metadata.annotations. *
	// `run.googleapis.com/binary-authorization-breakglass` *
	// `run.googleapis.com/binary-authorization` * `run.googleapis.com/client-name`
	// * `run.googleapis.com/custom-audiences` *
	// `run.googleapis.com/default-url-disabled` * `run.googleapis.com/description`
	// * `run.googleapis.com/gc-traffic-tags` * `run.googleapis.com/ingress` *
	// `run.googleapis.com/ingress` sets the ingress settings for the Service. See
	// the ingress settings documentation (/run/docs/securing/ingress) for details
	// on configuring ingress settings. * `run.googleapis.com/ingress-status` is
	// output-only and contains the currently active ingress settings for the
	// Service. `run.googleapis.com/ingress-status` may differ from
	// `run.googleapis.com/ingress` while the system is processing a change to
	// `run.googleapis.com/ingress` or if the system failed to process a change to
	// `run.googleapis.com/ingress`. When the system has processed all changes
	// successfully `run.googleapis.com/ingress-status` and
	// `run.googleapis.com/ingress` are equal.
	Metadata *ObjectMeta `json:"metadata,omitempty"`
	// Spec: Holds the desired state of the Service (from the client).
	Spec *ServiceSpec `json:"spec,omitempty"`
	// Status: Communicates the system-controlled state of the Service.
	Status *ServiceStatus `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Service) MarshalJSON() ([]byte, error) {
	type NoMethod Service
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceSpec: ServiceSpec holds the desired state of the Route (from the
// client), which is used to manipulate the underlying Route and
// Configuration(s).
type ServiceSpec struct {
	// Template: Holds the latest specification for the Revision to be stamped out.
	Template *RevisionTemplate `json:"template,omitempty"`
	// Traffic: Specifies how to distribute traffic over a collection of Knative
	// Revisions and Configurations to the Service's main URL.
	Traffic []*TrafficTarget `json:"traffic,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Template") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Template") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceSpec) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ServiceStatus: The current state of the Service. Output only.
type ServiceStatus struct {
	// Address: Similar to url, information on where the service is available on
	// HTTP.
	Address *Addressable `json:"address,omitempty"`
	// Conditions: Conditions communicate information about ongoing/complete
	// reconciliation processes that bring the `spec` inline with the observed
	// state of the world. Service-specific conditions include: *
	// `ConfigurationsReady`: `True` when the underlying Configuration is ready. *
	// `RoutesReady`: `True` when the underlying Route is ready. * `Ready`: `True`
	// when all underlying resources are ready.
	Conditions []*GoogleCloudRunV1Condition `json:"conditions,omitempty"`
	// LatestCreatedRevisionName: Name of the last revision that was created from
	// this Service's Configuration. It might not be ready yet, for that use
	// LatestReadyRevisionName.
	LatestCreatedRevisionName string `json:"latestCreatedRevisionName,omitempty"`
	// LatestReadyRevisionName: Name of the latest Revision from this Service's
	// Configuration that has had its `Ready` condition become `True`.
	LatestReadyRevisionName string `json:"latestReadyRevisionName,omitempty"`
	// ObservedGeneration: Returns the generation last seen by the system. Clients
	// polling for completed reconciliation should poll until observedGeneration =
	// metadata.generation and the Ready condition's status is True or False.
	ObservedGeneration int64 `json:"observedGeneration,omitempty"`
	// Traffic: Holds the configured traffic distribution. These entries will
	// always contain RevisionName references. When ConfigurationName appears in
	// the spec, this will hold the LatestReadyRevisionName that we last observed.
	Traffic []*TrafficTarget `json:"traffic,omitempty"`
	// Url: URL that will distribute traffic over the provided traffic targets. It
	// generally has the form
	// `https://{route-hash}-{project-hash}-{cluster-level-suffix}.a.run.app`
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Address") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Address") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ServiceStatus) MarshalJSON() ([]byte, error) {
	type NoMethod ServiceStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SetIamPolicyRequest: Request message for `SetIamPolicy` method.
type SetIamPolicyRequest struct {
	// Policy: REQUIRED: The complete policy to be applied to the `resource`. The
	// size of the policy is limited to a few 10s of KB. An empty policy is a valid
	// policy but certain Google Cloud services (such as Projects) might reject
	// them.
	Policy *Policy `json:"policy,omitempty"`
	// UpdateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
	// modify. Only the fields in the mask will be modified. If no mask is
	// provided, the following default mask is used: `paths: "bindings, etag"
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SetIamPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: Status is a return value for calls that don't return other objects.
type Status struct {
	// Code: Suggested HTTP return code for this status, 0 if not set.
	Code int64 `json:"code,omitempty"`
	// Details: Extended data associated with the reason. Each reason may define
	// its own extended details. This field is optional and the data returned is
	// not guaranteed to conform to any schema except that defined by the reason
	// type.
	Details *StatusDetails `json:"details,omitempty"`
	// Message: A human-readable description of the status of this operation.
	Message string `json:"message,omitempty"`
	// Metadata: Standard list metadata.
	Metadata *ListMeta `json:"metadata,omitempty"`
	// Reason: A machine-readable description of why this operation is in the
	// "Failure" status. If this value is empty there is no information available.
	// A Reason clarifies an HTTP status code but does not override it.
	Reason string `json:"reason,omitempty"`
	// Status: Status of the operation. One of: "Success" or "Failure".
	Status string `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StatusCause: StatusCause provides more information about an api.Status
// failure, including cases when multiple errors are encountered.
type StatusCause struct {
	// Field: The field of the resource that has caused this error, as named by its
	// JSON serialization. May include dot and postfix notation for nested
	// attributes. Arrays are zero-indexed. Fields may appear more than once in an
	// array of causes due to fields having multiple errors. Examples: "name" - the
	// field "name" on the current resource "items[0].name" - the field "name" on
	// the first array entry in "items"
	Field string `json:"field,omitempty"`
	// Message: A human-readable description of the cause of the error. This field
	// may be presented as-is to a reader.
	Message string `json:"message,omitempty"`
	// Reason: A machine-readable description of the cause of the error. If this
	// value is empty there is no information available.
	Reason string `json:"reason,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Field") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Field") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StatusCause) MarshalJSON() ([]byte, error) {
	type NoMethod StatusCause
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// StatusDetails: StatusDetails is a set of additional properties that MAY be
// set by the server to provide additional information about a response. The
// Reason field of a Status object defines what attributes will be set. Clients
// must ignore fields that do not match the defined type of each attribute, and
// should assume that any attribute may be empty, invalid, or under defined.
type StatusDetails struct {
	// Causes: The Causes array includes more details associated with the
	// StatusReason failure. Not all StatusReasons may provide detailed causes.
	Causes []*StatusCause `json:"causes,omitempty"`
	// Group: The group attribute of the resource associated with the status
	// StatusReason.
	Group string `json:"group,omitempty"`
	// Kind: The kind attribute of the resource associated with the status
	// StatusReason. On some operations may differ from the requested resource
	// Kind.
	Kind string `json:"kind,omitempty"`
	// Name: The name attribute of the resource associated with the status
	// StatusReason (when there is a single name which can be described).
	Name string `json:"name,omitempty"`
	// RetryAfterSeconds: If specified, the time in seconds before the operation
	// should be retried. Some errors may indicate the client must take an
	// alternate action - for those errors this field may indicate how long to wait
	// before taking the alternate action.
	RetryAfterSeconds int64 `json:"retryAfterSeconds,omitempty"`
	// Uid: UID of the resource. (when there is a single resource which can be
	// described).
	Uid string `json:"uid,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Causes") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Causes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s StatusDetails) MarshalJSON() ([]byte, error) {
	type NoMethod StatusDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TCPSocketAction: TCPSocketAction describes an action based on opening a
// socket
type TCPSocketAction struct {
	// Host: Not supported by Cloud Run.
	Host string `json:"host,omitempty"`
	// Port: Port number to access on the container. Number must be in the range 1
	// to 65535.
	Port int64 `json:"port,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Host") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Host") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TCPSocketAction) MarshalJSON() ([]byte, error) {
	type NoMethod TCPSocketAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Task: Task represents a single run of a container to completion.
type Task struct {
	// ApiVersion: Optional. APIVersion defines the versioned schema of this
	// representation of an object. Servers should convert recognized schemas to
	// the latest internal value, and may reject unrecognized values.
	ApiVersion string `json:"apiVersion,omitempty"`
	// Kind: Optional. Kind is a string value representing the REST resource this
	// object represents. Servers may infer this from the endpoint the client
	// submits requests to. Cannot be updated. In CamelCase.
	Kind string `json:"kind,omitempty"`
	// Metadata: Optional. Standard object's metadata.
	Metadata *ObjectMeta `json:"metadata,omitempty"`
	// Spec: Optional. Specification of the desired behavior of a task.
	Spec *TaskSpec `json:"spec,omitempty"`
	// Status: Output only. Current status of a task.
	Status *TaskStatus `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Task) MarshalJSON() ([]byte, error) {
	type NoMethod Task
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TaskAttemptResult: Result of a task attempt.
type TaskAttemptResult struct {
	// ExitCode: Optional. The exit code of this attempt. This may be unset if the
	// container was unable to exit cleanly with a code due to some other failure.
	// See status field for possible failure details. At most one of exit_code or
	// term_signal will be set.
	ExitCode int64 `json:"exitCode,omitempty"`
	// Status: Optional. The status of this attempt. If the status code is OK, then
	// the attempt succeeded.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// TermSignal: Optional. Termination signal of the container. This is set to
	// non-zero if the container is terminated by the system. At most one of
	// exit_code or term_signal will be set.
	TermSignal int64 `json:"termSignal,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExitCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExitCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TaskAttemptResult) MarshalJSON() ([]byte, error) {
	type NoMethod TaskAttemptResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TaskSpec: TaskSpec is a description of a task.
type TaskSpec struct {
	// Containers: Optional. List of containers belonging to the task. We disallow
	// a number of fields on this Container.
	Containers []*Container `json:"containers,omitempty"`
	// MaxRetries: Optional. Number of retries allowed per task, before marking
	// this job failed. Defaults to 3.
	MaxRetries int64 `json:"maxRetries,omitempty"`
	// NodeSelector: Optional. The Node Selector configuration. Map of selector key
	// to a value which matches a node.
	NodeSelector map[string]string `json:"nodeSelector,omitempty"`
	// ServiceAccountName: Optional. Email address of the IAM service account
	// associated with the task of a job execution. The service account represents
	// the identity of the running task, and determines what permissions the task
	// has. If not provided, the task will use the project's default service
	// account.
	ServiceAccountName string `json:"serviceAccountName,omitempty"`
	// TimeoutSeconds: Optional. Duration in seconds the task may be active before
	// the system will actively try to mark it failed and kill associated
	// containers. This applies per attempt of a task, meaning each retry can run
	// for the full timeout. Defaults to 600 seconds.
	TimeoutSeconds int64 `json:"timeoutSeconds,omitempty,string"`
	// Volumes: Optional. List of volumes that can be mounted by containers
	// belonging to the task.
	Volumes []*Volume `json:"volumes,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Containers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Containers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TaskSpec) MarshalJSON() ([]byte, error) {
	type NoMethod TaskSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TaskStatus: TaskStatus represents the status of a task.
type TaskStatus struct {
	// CompletionTime: Optional. Represents time when the task was completed. It is
	// not guaranteed to be set in happens-before order across separate operations.
	// It is represented in RFC3339 form and is in UTC.
	CompletionTime string `json:"completionTime,omitempty"`
	// Conditions: Optional. Conditions communicate information about
	// ongoing/complete reconciliation processes that bring the "spec" inline with
	// the observed state of the world. Task-specific conditions include: *
	// `Started`: `True` when the task has started to execute. * `Completed`:
	// `True` when the task has succeeded. `False` when the task has failed.
	Conditions []*GoogleCloudRunV1Condition `json:"conditions,omitempty"`
	// Index: Required. Index of the task, unique per execution, and beginning at
	// 0.
	Index int64 `json:"index,omitempty"`
	// LastAttemptResult: Optional. Result of the last attempt of this task.
	LastAttemptResult *TaskAttemptResult `json:"lastAttemptResult,omitempty"`
	// LogUri: Optional. URI where logs for this task can be found in Cloud
	// Console.
	LogUri string `json:"logUri,omitempty"`
	// ObservedGeneration: Optional. The 'generation' of the task that was last
	// processed by the controller.
	ObservedGeneration int64 `json:"observedGeneration,omitempty"`
	// Retried: Optional. The number of times this task was retried. Instances are
	// retried when they fail up to the maxRetries limit.
	Retried int64 `json:"retried,omitempty"`
	// StartTime: Optional. Represents time when the task started to run. It is not
	// guaranteed to be set in happens-before order across separate operations. It
	// is represented in RFC3339 form and is in UTC.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletionTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletionTime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TaskStatus) MarshalJSON() ([]byte, error) {
	type NoMethod TaskStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TaskTemplateSpec: TaskTemplateSpec describes the data a task should have
// when created from a template.
type TaskTemplateSpec struct {
	// Spec: Optional. Specification of the desired behavior of the task.
	Spec *TaskSpec `json:"spec,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Spec") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Spec") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TaskTemplateSpec) MarshalJSON() ([]byte, error) {
	type NoMethod TaskTemplateSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsRequest: Request message for `TestIamPermissions` method.
type TestIamPermissionsRequest struct {
	// Permissions: The set of permissions to check for the `resource`. Permissions
	// with wildcards (such as `*` or `storage.*`) are not allowed. For more
	// information see IAM Overview
	// (https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `json:"permissions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TestIamPermissionsResponse: Response message for `TestIamPermissions`
// method.
type TestIamPermissionsResponse struct {
	// Permissions: A subset of `TestPermissionsRequest.permissions` that the
	// caller is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TestIamPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TestIamPermissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TrafficTarget: TrafficTarget holds a single entry of the routing table for a
// Route.
type TrafficTarget struct {
	// ConfigurationName: [Deprecated] Not supported in Cloud Run. It must be
	// empty.
	ConfigurationName string `json:"configurationName,omitempty"`
	// LatestRevision: Uses the "status.latestReadyRevisionName" of the Service to
	// determine the traffic target. When it changes, traffic will automatically
	// migrate from the prior "latest ready" revision to the new one. This field
	// must be false if RevisionName is set. This field defaults to true otherwise.
	// If the field is set to true on Status, this means that the Revision was
	// resolved from the Service's latest ready revision.
	LatestRevision bool `json:"latestRevision,omitempty"`
	// Percent: Percent specifies percent of the traffic to this Revision or
	// Configuration. This defaults to zero if unspecified.
	Percent int64 `json:"percent,omitempty"`
	// RevisionName: Points this traffic target to a specific Revision. This field
	// is mutually exclusive with latest_revision.
	RevisionName string `json:"revisionName,omitempty"`
	// Tag: Tag is used to expose a dedicated url for referencing this target
	// exclusively.
	Tag string `json:"tag,omitempty"`
	// Url: Output only. URL displays the URL for accessing tagged traffic targets.
	// URL is displayed in status, and is disallowed on spec. URL must contain a
	// scheme (e.g. https://) and a hostname, but may not contain anything else
	// (e.g. basic auth, url path, etc.)
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfigurationName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfigurationName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TrafficTarget) MarshalJSON() ([]byte, error) {
	type NoMethod TrafficTarget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Volume: Volume represents a named volume in a container.
type Volume struct {
	// ConfigMap: Not supported in Cloud Run.
	ConfigMap *ConfigMapVolumeSource `json:"configMap,omitempty"`
	// Csi: Volume specified by the Container Storage Interface driver
	Csi *CSIVolumeSource `json:"csi,omitempty"`
	// EmptyDir: Ephemeral storage used as a shared volume.
	EmptyDir *EmptyDirVolumeSource `json:"emptyDir,omitempty"`
	// Name: Volume's name. In Cloud Run Fully Managed, the name 'cloudsql' is
	// reserved.
	Name string           `json:"name,omitempty"`
	Nfs  *NFSVolumeSource `json:"nfs,omitempty"`
	// Secret: The secret's value will be presented as the content of a file whose
	// name is defined in the item path. If no items are defined, the name of the
	// file is the secretName.
	Secret *SecretVolumeSource `json:"secret,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConfigMap") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConfigMap") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Volume) MarshalJSON() ([]byte, error) {
	type NoMethod Volume
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// VolumeMount: VolumeMount describes a mounting of a Volume within a
// container.
type VolumeMount struct {
	// MountPath: Required. Path within the container at which the volume should be
	// mounted. Must not contain ':'.
	MountPath string `json:"mountPath,omitempty"`
	// Name: Required. The name of the volume. There must be a corresponding Volume
	// with the same name.
	Name string `json:"name,omitempty"`
	// ReadOnly: Sets the mount to be read-only or read-write. Not used by Cloud
	// Run.
	ReadOnly bool `json:"readOnly,omitempty"`
	// SubPath: Path within the volume from which the container's volume should be
	// mounted. Defaults to "" (volume's root).
	SubPath string `json:"subPath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MountPath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MountPath") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s VolumeMount) MarshalJSON() ([]byte, error) {
	type NoMethod VolumeMount
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkerPool: WorkerPool acts as a top-level container that manages a set
// instance splits among a set of Revisions and a template for creating new
// Revisions.
type WorkerPool struct {
	// ApiVersion: The API version for this call. It must be
	// "run.googleapis.com/v1".
	ApiVersion string `json:"apiVersion,omitempty"`
	// Kind: The kind of resource. It must be "WorkerPool".
	Kind string `json:"kind,omitempty"`
	// Metadata: Metadata associated with this WorkerPool, including name,
	// namespace, labels, and annotations. In Cloud Run, annotations with
	// 'run.googleapis.com/' and 'autoscaling.knative.dev' are restricted, and the
	// accepted annotations will be different depending on the resource type. The
	// following Cloud Run-specific annotations are accepted in
	// WorkerPool.metadata.annotations. *
	// `run.googleapis.com/binary-authorization-breakglass` *
	// `run.googleapis.com/binary-authorization` * `run.googleapis.com/client-name`
	// * `run.googleapis.com/description`
	Metadata *ObjectMeta `json:"metadata,omitempty"`
	// Spec: Holds the desired state of the WorkerPool (from the client).
	Spec *WorkerPoolSpec `json:"spec,omitempty"`
	// Status: Communicates the system-controlled state of the WorkerPool.
	Status *WorkerPoolStatus `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkerPool) MarshalJSON() ([]byte, error) {
	type NoMethod WorkerPool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkerPoolSpec: WorkerPoolSpec holds the desired state of the WorkerPool's
// template and instance splits.
type WorkerPoolSpec struct {
	// InstanceSplits: Specifies how to distribute instances over a collection of
	// Revisions.
	InstanceSplits []*InstanceSplit `json:"instanceSplits,omitempty"`
	// Template: Holds the latest specification for the Revision to be stamped out.
	Template *RevisionTemplate `json:"template,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InstanceSplits") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InstanceSplits") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkerPoolSpec) MarshalJSON() ([]byte, error) {
	type NoMethod WorkerPoolSpec
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// WorkerPoolStatus: The current state of the WorkerPool. Output only.
type WorkerPoolStatus struct {
	// Conditions: Conditions communicate information about ongoing/complete
	// reconciliation processes that bring the `spec` inline with the observed
	// state of the world. * `Ready`: `True` when all underlying resources are
	// ready.
	Conditions []*GoogleCloudRunV1Condition `json:"conditions,omitempty"`
	// InstanceSplits: Holds the configured workload distribution. These entries
	// will always contain RevisionName references. When ConfigurationName appears
	// in the spec, this will hold the LatestReadyRevisionName that we last
	// observed.
	InstanceSplits []*InstanceSplit `json:"instanceSplits,omitempty"`
	// LatestCreatedRevisionName: Name of the last revision that was created from
	// this WorkerPool's template. It might not be ready yet, for that use
	// LatestReadyRevisionName.
	LatestCreatedRevisionName string `json:"latestCreatedRevisionName,omitempty"`
	// LatestReadyRevisionName: Name of the latest Revision from this WorkerPool's
	// template that has had its `Ready` condition become `True`.
	LatestReadyRevisionName string `json:"latestReadyRevisionName,omitempty"`
	// ObservedGeneration: Returns the generation last seen by the system. Clients
	// polling for completed reconciliation should poll until observedGeneration =
	// metadata.generation and the Ready condition's status is True or False.
	ObservedGeneration int64 `json:"observedGeneration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Conditions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Conditions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s WorkerPoolStatus) MarshalJSON() ([]byte, error) {
	type NoMethod WorkerPoolStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type NamespacesAuthorizeddomainsListCall struct {
	s            *APIService
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List authorized domains.
//
//   - parent: Name of the parent Project resource. Example:
//     `projects/myproject`.
func (r *NamespacesAuthorizeddomainsService) List(parent string) *NamespacesAuthorizeddomainsListCall {
	c := &NamespacesAuthorizeddomainsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum results to return
// per page.
func (c *NamespacesAuthorizeddomainsListCall) PageSize(pageSize int64) *NamespacesAuthorizeddomainsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Continuation token for
// fetching the next page of results.
func (c *NamespacesAuthorizeddomainsListCall) PageToken(pageToken string) *NamespacesAuthorizeddomainsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesAuthorizeddomainsListCall) Fields(s ...googleapi.Field) *NamespacesAuthorizeddomainsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *NamespacesAuthorizeddomainsListCall) IfNoneMatch(entityTag string) *NamespacesAuthorizeddomainsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesAuthorizeddomainsListCall) Context(ctx context.Context) *NamespacesAuthorizeddomainsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesAuthorizeddomainsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesAuthorizeddomainsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/domains.cloudrun.com/v1/{+parent}/authorizeddomains")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.authorizeddomains.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.authorizeddomains.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAuthorizedDomainsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *NamespacesAuthorizeddomainsListCall) Do(opts ...googleapi.CallOption) (*ListAuthorizedDomainsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAuthorizedDomainsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.authorizeddomains.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *NamespacesAuthorizeddomainsListCall) Pages(ctx context.Context, f func(*ListAuthorizedDomainsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type NamespacesConfigurationsGetCall struct {
	s            *APIService
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get information about a configuration.
//
//   - name: The name of the configuration to retrieve. For Cloud Run, replace
//     {namespace_id} with the project ID or number.
func (r *NamespacesConfigurationsService) Get(name string) *NamespacesConfigurationsGetCall {
	c := &NamespacesConfigurationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesConfigurationsGetCall) Fields(s ...googleapi.Field) *NamespacesConfigurationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *NamespacesConfigurationsGetCall) IfNoneMatch(entityTag string) *NamespacesConfigurationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesConfigurationsGetCall) Context(ctx context.Context) *NamespacesConfigurationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesConfigurationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesConfigurationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/serving.knative.dev/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.configurations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.configurations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Configuration.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesConfigurationsGetCall) Do(opts ...googleapi.CallOption) (*Configuration, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Configuration{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.configurations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesConfigurationsListCall struct {
	s            *APIService
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List configurations. Results are sorted by creation time, descending.
//
//   - parent: The namespace from which the configurations should be listed. For
//     Cloud Run, replace {namespace_id} with the project ID or number.
func (r *NamespacesConfigurationsService) List(parent string) *NamespacesConfigurationsListCall {
	c := &NamespacesConfigurationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Continue sets the optional parameter "continue": Encoded string to continue
// paging.
func (c *NamespacesConfigurationsListCall) Continue(continue_ string) *NamespacesConfigurationsListCall {
	c.urlParams_.Set("continue", continue_)
	return c
}

// FieldSelector sets the optional parameter "fieldSelector": Not supported by
// Cloud Run.
func (c *NamespacesConfigurationsListCall) FieldSelector(fieldSelector string) *NamespacesConfigurationsListCall {
	c.urlParams_.Set("fieldSelector", fieldSelector)
	return c
}

// IncludeUninitialized sets the optional parameter "includeUninitialized": Not
// supported by Cloud Run.
func (c *NamespacesConfigurationsListCall) IncludeUninitialized(includeUninitialized bool) *NamespacesConfigurationsListCall {
	c.urlParams_.Set("includeUninitialized", fmt.Sprint(includeUninitialized))
	return c
}

// LabelSelector sets the optional parameter "labelSelector": Allows to filter
// resources based on a label. Supported operations are =, !=, exists, in, and
// notIn.
func (c *NamespacesConfigurationsListCall) LabelSelector(labelSelector string) *NamespacesConfigurationsListCall {
	c.urlParams_.Set("labelSelector", labelSelector)
	return c
}

// Limit sets the optional parameter "limit": The maximum number of the records
// that should be returned.
func (c *NamespacesConfigurationsListCall) Limit(limit int64) *NamespacesConfigurationsListCall {
	c.urlParams_.Set("limit", fmt.Sprint(limit))
	return c
}

// ResourceVersion sets the optional parameter "resourceVersion": Not supported
// by Cloud Run.
func (c *NamespacesConfigurationsListCall) ResourceVersion(resourceVersion string) *NamespacesConfigurationsListCall {
	c.urlParams_.Set("resourceVersion", resourceVersion)
	return c
}

// Watch sets the optional parameter "watch": Not supported by Cloud Run.
func (c *NamespacesConfigurationsListCall) Watch(watch bool) *NamespacesConfigurationsListCall {
	c.urlParams_.Set("watch", fmt.Sprint(watch))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesConfigurationsListCall) Fields(s ...googleapi.Field) *NamespacesConfigurationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *NamespacesConfigurationsListCall) IfNoneMatch(entityTag string) *NamespacesConfigurationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesConfigurationsListCall) Context(ctx context.Context) *NamespacesConfigurationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesConfigurationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesConfigurationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/serving.knative.dev/v1/{+parent}/configurations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.configurations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.configurations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListConfigurationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *NamespacesConfigurationsListCall) Do(opts ...googleapi.CallOption) (*ListConfigurationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListConfigurationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.configurations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesDomainmappingsCreateCall struct {
	s             *APIService
	parent        string
	domainmapping *DomainMapping
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Create: Create a new domain mapping.
//
//   - parent: The namespace in which the domain mapping should be created. For
//     Cloud Run (fully managed), replace {namespace} with the project ID or
//     number. It takes the form namespaces/{namespace}. For example:
//     namespaces/PROJECT_ID.
func (r *NamespacesDomainmappingsService) Create(parent string, domainmapping *DomainMapping) *NamespacesDomainmappingsCreateCall {
	c := &NamespacesDomainmappingsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.domainmapping = domainmapping
	return c
}

// DryRun sets the optional parameter "dryRun": Indicates that the server
// should validate the request and populate default values without persisting
// the request. Supported values: `all`
func (c *NamespacesDomainmappingsCreateCall) DryRun(dryRun string) *NamespacesDomainmappingsCreateCall {
	c.urlParams_.Set("dryRun", dryRun)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesDomainmappingsCreateCall) Fields(s ...googleapi.Field) *NamespacesDomainmappingsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesDomainmappingsCreateCall) Context(ctx context.Context) *NamespacesDomainmappingsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesDomainmappingsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesDomainmappingsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.domainmapping)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/domains.cloudrun.com/v1/{+parent}/domainmappings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.domainmappings.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.domainmappings.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *DomainMapping.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesDomainmappingsCreateCall) Do(opts ...googleapi.CallOption) (*DomainMapping, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DomainMapping{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.domainmappings.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesDomainmappingsDeleteCall struct {
	s          *APIService
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a domain mapping.
//
//   - name: The name of the domain mapping to delete. For Cloud Run (fully
//     managed), replace {namespace} with the project ID or number. It takes the
//     form namespaces/{namespace}. For example: namespaces/PROJECT_ID.
func (r *NamespacesDomainmappingsService) Delete(name string) *NamespacesDomainmappingsDeleteCall {
	c := &NamespacesDomainmappingsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ApiVersion sets the optional parameter "apiVersion": Cloud Run currently
// ignores this parameter.
func (c *NamespacesDomainmappingsDeleteCall) ApiVersion(apiVersion string) *NamespacesDomainmappingsDeleteCall {
	c.urlParams_.Set("apiVersion", apiVersion)
	return c
}

// DryRun sets the optional parameter "dryRun": Indicates that the server
// should validate the request and populate default values without persisting
// the request. Supported values: `all`
func (c *NamespacesDomainmappingsDeleteCall) DryRun(dryRun string) *NamespacesDomainmappingsDeleteCall {
	c.urlParams_.Set("dryRun", dryRun)
	return c
}

// Kind sets the optional parameter "kind": Cloud Run currently ignores this
// parameter.
func (c *NamespacesDomainmappingsDeleteCall) Kind(kind string) *NamespacesDomainmappingsDeleteCall {
	c.urlParams_.Set("kind", kind)
	return c
}

// PropagationPolicy sets the optional parameter "propagationPolicy": Specifies
// the propagation policy of delete. Cloud Run currently ignores this setting,
// and deletes in the background. Please see
// kubernetes.io/docs/concepts/architecture/garbage-collection/ for more
// information.
func (c *NamespacesDomainmappingsDeleteCall) PropagationPolicy(propagationPolicy string) *NamespacesDomainmappingsDeleteCall {
	c.urlParams_.Set("propagationPolicy", propagationPolicy)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesDomainmappingsDeleteCall) Fields(s ...googleapi.Field) *NamespacesDomainmappingsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesDomainmappingsDeleteCall) Context(ctx context.Context) *NamespacesDomainmappingsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesDomainmappingsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesDomainmappingsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/domains.cloudrun.com/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.domainmappings.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.domainmappings.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Status.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesDomainmappingsDeleteCall) Do(opts ...googleapi.CallOption) (*Status, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Status{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.domainmappings.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesDomainmappingsGetCall struct {
	s            *APIService
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get information about a domain mapping.
//
//   - name: The name of the domain mapping to retrieve. For Cloud Run (fully
//     managed), replace {namespace} with the project ID or number. It takes the
//     form namespaces/{namespace}. For example: namespaces/PROJECT_ID.
func (r *NamespacesDomainmappingsService) Get(name string) *NamespacesDomainmappingsGetCall {
	c := &NamespacesDomainmappingsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesDomainmappingsGetCall) Fields(s ...googleapi.Field) *NamespacesDomainmappingsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *NamespacesDomainmappingsGetCall) IfNoneMatch(entityTag string) *NamespacesDomainmappingsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesDomainmappingsGetCall) Context(ctx context.Context) *NamespacesDomainmappingsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesDomainmappingsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesDomainmappingsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/domains.cloudrun.com/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.domainmappings.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.domainmappings.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *DomainMapping.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesDomainmappingsGetCall) Do(opts ...googleapi.CallOption) (*DomainMapping, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DomainMapping{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.domainmappings.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesDomainmappingsListCall struct {
	s            *APIService
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List all domain mappings.
//
//   - parent: The namespace from which the domain mappings should be listed. For
//     Cloud Run (fully managed), replace {namespace} with the project ID or
//     number. It takes the form namespaces/{namespace}. For example:
//     namespaces/PROJECT_ID.
func (r *NamespacesDomainmappingsService) List(parent string) *NamespacesDomainmappingsListCall {
	c := &NamespacesDomainmappingsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Continue sets the optional parameter "continue": Encoded string to continue
// paging.
func (c *NamespacesDomainmappingsListCall) Continue(continue_ string) *NamespacesDomainmappingsListCall {
	c.urlParams_.Set("continue", continue_)
	return c
}

// FieldSelector sets the optional parameter "fieldSelector": Allows to filter
// resources based on a specific value for a field name. Send this in a query
// string format. i.e. 'metadata.name%3Dlorem'. Not currently used by Cloud
// Run.
func (c *NamespacesDomainmappingsListCall) FieldSelector(fieldSelector string) *NamespacesDomainmappingsListCall {
	c.urlParams_.Set("fieldSelector", fieldSelector)
	return c
}

// IncludeUninitialized sets the optional parameter "includeUninitialized": Not
// currently used by Cloud Run.
func (c *NamespacesDomainmappingsListCall) IncludeUninitialized(includeUninitialized bool) *NamespacesDomainmappingsListCall {
	c.urlParams_.Set("includeUninitialized", fmt.Sprint(includeUninitialized))
	return c
}

// LabelSelector sets the optional parameter "labelSelector": Allows to filter
// resources based on a label. Supported operations are =, !=, exists, in, and
// notIn.
func (c *NamespacesDomainmappingsListCall) LabelSelector(labelSelector string) *NamespacesDomainmappingsListCall {
	c.urlParams_.Set("labelSelector", labelSelector)
	return c
}

// Limit sets the optional parameter "limit": The maximum number of records
// that should be returned.
func (c *NamespacesDomainmappingsListCall) Limit(limit int64) *NamespacesDomainmappingsListCall {
	c.urlParams_.Set("limit", fmt.Sprint(limit))
	return c
}

// ResourceVersion sets the optional parameter "resourceVersion": The baseline
// resource version from which the list or watch operation should start. Not
// currently used by Cloud Run.
func (c *NamespacesDomainmappingsListCall) ResourceVersion(resourceVersion string) *NamespacesDomainmappingsListCall {
	c.urlParams_.Set("resourceVersion", resourceVersion)
	return c
}

// Watch sets the optional parameter "watch": Flag that indicates that the
// client expects to watch this resource as well. Not currently used by Cloud
// Run.
func (c *NamespacesDomainmappingsListCall) Watch(watch bool) *NamespacesDomainmappingsListCall {
	c.urlParams_.Set("watch", fmt.Sprint(watch))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesDomainmappingsListCall) Fields(s ...googleapi.Field) *NamespacesDomainmappingsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *NamespacesDomainmappingsListCall) IfNoneMatch(entityTag string) *NamespacesDomainmappingsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesDomainmappingsListCall) Context(ctx context.Context) *NamespacesDomainmappingsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesDomainmappingsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesDomainmappingsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/domains.cloudrun.com/v1/{+parent}/domainmappings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.domainmappings.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.domainmappings.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDomainMappingsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *NamespacesDomainmappingsListCall) Do(opts ...googleapi.CallOption) (*ListDomainMappingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDomainMappingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.domainmappings.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesExecutionsCancelCall struct {
	s                      *APIService
	name                   string
	cancelexecutionrequest *CancelExecutionRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Cancel: Cancel an execution.
//
//   - name: The name of the execution to cancel. Replace {namespace} with the
//     project ID or number. It takes the form namespaces/{namespace}. For
//     example: namespaces/PROJECT_ID.
func (r *NamespacesExecutionsService) Cancel(name string, cancelexecutionrequest *CancelExecutionRequest) *NamespacesExecutionsCancelCall {
	c := &NamespacesExecutionsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.cancelexecutionrequest = cancelexecutionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesExecutionsCancelCall) Fields(s ...googleapi.Field) *NamespacesExecutionsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesExecutionsCancelCall) Context(ctx context.Context) *NamespacesExecutionsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesExecutionsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesExecutionsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.cancelexecutionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.executions.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.executions.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Execution.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesExecutionsCancelCall) Do(opts ...googleapi.CallOption) (*Execution, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Execution{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.executions.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesExecutionsDeleteCall struct {
	s          *APIService
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete an execution.
//
//   - name: The name of the execution to delete. Replace {namespace} with the
//     project ID or number. It takes the form namespaces/{namespace}. For
//     example: namespaces/PROJECT_ID.
func (r *NamespacesExecutionsService) Delete(name string) *NamespacesExecutionsDeleteCall {
	c := &NamespacesExecutionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ApiVersion sets the optional parameter "apiVersion": Cloud Run currently
// ignores this parameter.
func (c *NamespacesExecutionsDeleteCall) ApiVersion(apiVersion string) *NamespacesExecutionsDeleteCall {
	c.urlParams_.Set("apiVersion", apiVersion)
	return c
}

// Kind sets the optional parameter "kind": Cloud Run currently ignores this
// parameter.
func (c *NamespacesExecutionsDeleteCall) Kind(kind string) *NamespacesExecutionsDeleteCall {
	c.urlParams_.Set("kind", kind)
	return c
}

// PropagationPolicy sets the optional parameter "propagationPolicy": Specifies
// the propagation policy of delete. Cloud Run currently ignores this setting.
func (c *NamespacesExecutionsDeleteCall) PropagationPolicy(propagationPolicy string) *NamespacesExecutionsDeleteCall {
	c.urlParams_.Set("propagationPolicy", propagationPolicy)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesExecutionsDeleteCall) Fields(s ...googleapi.Field) *NamespacesExecutionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesExecutionsDeleteCall) Context(ctx context.Context) *NamespacesExecutionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesExecutionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesExecutionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.executions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.executions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Status.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesExecutionsDeleteCall) Do(opts ...googleapi.CallOption) (*Status, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Status{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.executions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesExecutionsGetCall struct {
	s            *APIService
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get information about an execution.
//
//   - name: The name of the execution to retrieve. Replace {namespace} with the
//     project ID or number. It takes the form namespaces/{namespace}. For
//     example: namespaces/PROJECT_ID.
func (r *NamespacesExecutionsService) Get(name string) *NamespacesExecutionsGetCall {
	c := &NamespacesExecutionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesExecutionsGetCall) Fields(s ...googleapi.Field) *NamespacesExecutionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *NamespacesExecutionsGetCall) IfNoneMatch(entityTag string) *NamespacesExecutionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesExecutionsGetCall) Context(ctx context.Context) *NamespacesExecutionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesExecutionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesExecutionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.executions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.executions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Execution.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesExecutionsGetCall) Do(opts ...googleapi.CallOption) (*Execution, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Execution{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.executions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesExecutionsListCall struct {
	s            *APIService
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List executions. Results are sorted by creation time, descending.
//
//   - parent: The namespace from which the executions should be listed. Replace
//     {namespace} with the project ID or number. It takes the form
//     namespaces/{namespace}. For example: namespaces/PROJECT_ID.
func (r *NamespacesExecutionsService) List(parent string) *NamespacesExecutionsListCall {
	c := &NamespacesExecutionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Continue sets the optional parameter "continue": Optional encoded string to
// continue paging.
func (c *NamespacesExecutionsListCall) Continue(continue_ string) *NamespacesExecutionsListCall {
	c.urlParams_.Set("continue", continue_)
	return c
}

// FieldSelector sets the optional parameter "fieldSelector": Not supported by
// Cloud Run.
func (c *NamespacesExecutionsListCall) FieldSelector(fieldSelector string) *NamespacesExecutionsListCall {
	c.urlParams_.Set("fieldSelector", fieldSelector)
	return c
}

// IncludeUninitialized sets the optional parameter "includeUninitialized": Not
// supported by Cloud Run.
func (c *NamespacesExecutionsListCall) IncludeUninitialized(includeUninitialized bool) *NamespacesExecutionsListCall {
	c.urlParams_.Set("includeUninitialized", fmt.Sprint(includeUninitialized))
	return c
}

// LabelSelector sets the optional parameter "labelSelector": Allows to filter
// resources based on a label. Supported operations are =, !=, exists, in, and
// notIn.
func (c *NamespacesExecutionsListCall) LabelSelector(labelSelector string) *NamespacesExecutionsListCall {
	c.urlParams_.Set("labelSelector", labelSelector)
	return c
}

// Limit sets the optional parameter "limit": The maximum number of the records
// that should be returned.
func (c *NamespacesExecutionsListCall) Limit(limit int64) *NamespacesExecutionsListCall {
	c.urlParams_.Set("limit", fmt.Sprint(limit))
	return c
}

// ResourceVersion sets the optional parameter "resourceVersion": Not supported
// by Cloud Run.
func (c *NamespacesExecutionsListCall) ResourceVersion(resourceVersion string) *NamespacesExecutionsListCall {
	c.urlParams_.Set("resourceVersion", resourceVersion)
	return c
}

// Watch sets the optional parameter "watch": Not supported by Cloud Run.
func (c *NamespacesExecutionsListCall) Watch(watch bool) *NamespacesExecutionsListCall {
	c.urlParams_.Set("watch", fmt.Sprint(watch))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesExecutionsListCall) Fields(s ...googleapi.Field) *NamespacesExecutionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *NamespacesExecutionsListCall) IfNoneMatch(entityTag string) *NamespacesExecutionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesExecutionsListCall) Context(ctx context.Context) *NamespacesExecutionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesExecutionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesExecutionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1/{+parent}/executions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.executions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.executions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListExecutionsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *NamespacesExecutionsListCall) Do(opts ...googleapi.CallOption) (*ListExecutionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListExecutionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.executions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesJobsCreateCall struct {
	s          *APIService
	parent     string
	job        *Job
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Create a job.
//
//   - parent: The namespace in which the job should be created. Replace
//     {namespace} with the project ID or number. It takes the form
//     namespaces/{namespace}. For example: namespaces/PROJECT_ID.
func (r *NamespacesJobsService) Create(parent string, job *Job) *NamespacesJobsCreateCall {
	c := &NamespacesJobsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.job = job
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesJobsCreateCall) Fields(s ...googleapi.Field) *NamespacesJobsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesJobsCreateCall) Context(ctx context.Context) *NamespacesJobsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesJobsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesJobsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.job)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1/{+parent}/jobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.jobs.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.jobs.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Job.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesJobsCreateCall) Do(opts ...googleapi.CallOption) (*Job, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Job{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.jobs.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesJobsDeleteCall struct {
	s          *APIService
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a job.
//
//   - name: The name of the job to delete. Replace {namespace} with the project
//     ID or number. It takes the form namespaces/{namespace}. For example:
//     namespaces/PROJECT_ID.
func (r *NamespacesJobsService) Delete(name string) *NamespacesJobsDeleteCall {
	c := &NamespacesJobsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ApiVersion sets the optional parameter "apiVersion": Cloud Run currently
// ignores this parameter.
func (c *NamespacesJobsDeleteCall) ApiVersion(apiVersion string) *NamespacesJobsDeleteCall {
	c.urlParams_.Set("apiVersion", apiVersion)
	return c
}

// Kind sets the optional parameter "kind": Cloud Run currently ignores this
// parameter.
func (c *NamespacesJobsDeleteCall) Kind(kind string) *NamespacesJobsDeleteCall {
	c.urlParams_.Set("kind", kind)
	return c
}

// PropagationPolicy sets the optional parameter "propagationPolicy": Specifies
// the propagation policy of delete. Cloud Run currently ignores this setting,
// and deletes in the background. Please see
// kubernetes.io/docs/concepts/workloads/controllers/garbage-collection/ for
// more information.
func (c *NamespacesJobsDeleteCall) PropagationPolicy(propagationPolicy string) *NamespacesJobsDeleteCall {
	c.urlParams_.Set("propagationPolicy", propagationPolicy)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesJobsDeleteCall) Fields(s ...googleapi.Field) *NamespacesJobsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesJobsDeleteCall) Context(ctx context.Context) *NamespacesJobsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesJobsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesJobsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.jobs.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.jobs.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Status.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesJobsDeleteCall) Do(opts ...googleapi.CallOption) (*Status, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Status{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.jobs.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesJobsGetCall struct {
	s            *APIService
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get information about a job.
//
//   - name: The name of the job to retrieve. It takes the form
//     namespaces/{namespace}/jobs/{job_name} and the `endpoint` must be
//     regional. Replace {namespace} with the project ID or number.
func (r *NamespacesJobsService) Get(name string) *NamespacesJobsGetCall {
	c := &NamespacesJobsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesJobsGetCall) Fields(s ...googleapi.Field) *NamespacesJobsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *NamespacesJobsGetCall) IfNoneMatch(entityTag string) *NamespacesJobsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesJobsGetCall) Context(ctx context.Context) *NamespacesJobsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesJobsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesJobsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.jobs.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.jobs.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Job.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesJobsGetCall) Do(opts ...googleapi.CallOption) (*Job, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Job{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.jobs.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesJobsListCall struct {
	s            *APIService
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List jobs. Results are sorted by creation time, descending.
//
//   - parent: The namespace from which the jobs should be listed. Replace
//     {namespace} with the project ID or number. It takes the form
//     namespaces/{namespace}. For example: namespaces/PROJECT_ID.
func (r *NamespacesJobsService) List(parent string) *NamespacesJobsListCall {
	c := &NamespacesJobsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Continue sets the optional parameter "continue": Optional encoded string to
// continue paging.
func (c *NamespacesJobsListCall) Continue(continue_ string) *NamespacesJobsListCall {
	c.urlParams_.Set("continue", continue_)
	return c
}

// FieldSelector sets the optional parameter "fieldSelector": Not supported by
// Cloud Run.
func (c *NamespacesJobsListCall) FieldSelector(fieldSelector string) *NamespacesJobsListCall {
	c.urlParams_.Set("fieldSelector", fieldSelector)
	return c
}

// IncludeUninitialized sets the optional parameter "includeUninitialized": Not
// supported by Cloud Run.
func (c *NamespacesJobsListCall) IncludeUninitialized(includeUninitialized bool) *NamespacesJobsListCall {
	c.urlParams_.Set("includeUninitialized", fmt.Sprint(includeUninitialized))
	return c
}

// LabelSelector sets the optional parameter "labelSelector": Allows to filter
// resources based on a label. Supported operations are =, !=, exists, in, and
// notIn.
func (c *NamespacesJobsListCall) LabelSelector(labelSelector string) *NamespacesJobsListCall {
	c.urlParams_.Set("labelSelector", labelSelector)
	return c
}

// Limit sets the optional parameter "limit": The maximum number of records
// that should be returned.
func (c *NamespacesJobsListCall) Limit(limit int64) *NamespacesJobsListCall {
	c.urlParams_.Set("limit", fmt.Sprint(limit))
	return c
}

// ResourceVersion sets the optional parameter "resourceVersion": Not supported
// by Cloud Run.
func (c *NamespacesJobsListCall) ResourceVersion(resourceVersion string) *NamespacesJobsListCall {
	c.urlParams_.Set("resourceVersion", resourceVersion)
	return c
}

// Watch sets the optional parameter "watch": Not supported by Cloud Run.
func (c *NamespacesJobsListCall) Watch(watch bool) *NamespacesJobsListCall {
	c.urlParams_.Set("watch", fmt.Sprint(watch))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesJobsListCall) Fields(s ...googleapi.Field) *NamespacesJobsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *NamespacesJobsListCall) IfNoneMatch(entityTag string) *NamespacesJobsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesJobsListCall) Context(ctx context.Context) *NamespacesJobsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesJobsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesJobsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1/{+parent}/jobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.jobs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.jobs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListJobsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *NamespacesJobsListCall) Do(opts ...googleapi.CallOption) (*ListJobsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListJobsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.jobs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesJobsReplaceJobCall struct {
	s          *APIService
	name       string
	job        *Job
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// ReplaceJob: Replace a job. Only the spec and metadata labels and annotations
// are modifiable. After the Replace request, Cloud Run will work to make the
// 'status' match the requested 'spec'. May provide metadata.resourceVersion to
// enforce update from last read for optimistic concurrency control.
//
//   - name: The name of the job being replaced. Replace {namespace} with the
//     project ID or number. It takes the form namespaces/{namespace}. For
//     example: namespaces/PROJECT_ID.
func (r *NamespacesJobsService) ReplaceJob(name string, job *Job) *NamespacesJobsReplaceJobCall {
	c := &NamespacesJobsReplaceJobCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.job = job
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesJobsReplaceJobCall) Fields(s ...googleapi.Field) *NamespacesJobsReplaceJobCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesJobsReplaceJobCall) Context(ctx context.Context) *NamespacesJobsReplaceJobCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesJobsReplaceJobCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesJobsReplaceJobCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.job)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.jobs.replaceJob", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.jobs.replaceJob" call.
// Any non-2xx status code is an error. Response headers are in either
// *Job.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesJobsReplaceJobCall) Do(opts ...googleapi.CallOption) (*Job, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Job{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.jobs.replaceJob", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesJobsRunCall struct {
	s             *APIService
	name          string
	runjobrequest *RunJobRequest
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Run: Trigger creation of a new execution of this job.
//
//   - name: The name of the job to run. Replace {namespace} with the project ID
//     or number. It takes the form namespaces/{namespace}. For example:
//     namespaces/PROJECT_ID.
func (r *NamespacesJobsService) Run(name string, runjobrequest *RunJobRequest) *NamespacesJobsRunCall {
	c := &NamespacesJobsRunCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.runjobrequest = runjobrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesJobsRunCall) Fields(s ...googleapi.Field) *NamespacesJobsRunCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesJobsRunCall) Context(ctx context.Context) *NamespacesJobsRunCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesJobsRunCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesJobsRunCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.runjobrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1/{+name}:run")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.jobs.run", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.jobs.run" call.
// Any non-2xx status code is an error. Response headers are in either
// *Execution.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesJobsRunCall) Do(opts ...googleapi.CallOption) (*Execution, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Execution{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.jobs.run", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesRevisionsDeleteCall struct {
	s          *APIService
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a revision.
//
//   - name: The name of the revision to delete. For Cloud Run (fully managed),
//     replace {namespace} with the project ID or number. It takes the form
//     namespaces/{namespace}. For example: namespaces/PROJECT_ID.
func (r *NamespacesRevisionsService) Delete(name string) *NamespacesRevisionsDeleteCall {
	c := &NamespacesRevisionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ApiVersion sets the optional parameter "apiVersion": Cloud Run currently
// ignores this parameter.
func (c *NamespacesRevisionsDeleteCall) ApiVersion(apiVersion string) *NamespacesRevisionsDeleteCall {
	c.urlParams_.Set("apiVersion", apiVersion)
	return c
}

// DryRun sets the optional parameter "dryRun": Indicates that the server
// should validate the request and populate default values without persisting
// the request. Supported values: `all`
func (c *NamespacesRevisionsDeleteCall) DryRun(dryRun string) *NamespacesRevisionsDeleteCall {
	c.urlParams_.Set("dryRun", dryRun)
	return c
}

// Kind sets the optional parameter "kind": Cloud Run currently ignores this
// parameter.
func (c *NamespacesRevisionsDeleteCall) Kind(kind string) *NamespacesRevisionsDeleteCall {
	c.urlParams_.Set("kind", kind)
	return c
}

// PropagationPolicy sets the optional parameter "propagationPolicy": Specifies
// the propagation policy of delete. Cloud Run currently ignores this setting,
// and deletes in the background.
func (c *NamespacesRevisionsDeleteCall) PropagationPolicy(propagationPolicy string) *NamespacesRevisionsDeleteCall {
	c.urlParams_.Set("propagationPolicy", propagationPolicy)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesRevisionsDeleteCall) Fields(s ...googleapi.Field) *NamespacesRevisionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesRevisionsDeleteCall) Context(ctx context.Context) *NamespacesRevisionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesRevisionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesRevisionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/serving.knative.dev/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.revisions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.revisions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Status.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesRevisionsDeleteCall) Do(opts ...googleapi.CallOption) (*Status, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Status{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.revisions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesRevisionsGetCall struct {
	s            *APIService
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get information about a revision.
//
//   - name: The name of the revision to retrieve. For Cloud Run (fully managed),
//     replace {namespace} with the project ID or number. It takes the form
//     namespaces/{namespace}. For example: namespaces/PROJECT_ID.
func (r *NamespacesRevisionsService) Get(name string) *NamespacesRevisionsGetCall {
	c := &NamespacesRevisionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesRevisionsGetCall) Fields(s ...googleapi.Field) *NamespacesRevisionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *NamespacesRevisionsGetCall) IfNoneMatch(entityTag string) *NamespacesRevisionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesRevisionsGetCall) Context(ctx context.Context) *NamespacesRevisionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesRevisionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesRevisionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/serving.knative.dev/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.revisions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.revisions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Revision.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesRevisionsGetCall) Do(opts ...googleapi.CallOption) (*Revision, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Revision{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.revisions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesRevisionsListCall struct {
	s            *APIService
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List revisions. Results are sorted by creation time, descending.
//
//   - parent: The namespace from which the revisions should be listed. For Cloud
//     Run (fully managed), replace {namespace} with the project ID or number. It
//     takes the form namespaces/{namespace}. For example: namespaces/PROJECT_ID.
func (r *NamespacesRevisionsService) List(parent string) *NamespacesRevisionsListCall {
	c := &NamespacesRevisionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Continue sets the optional parameter "continue": Encoded string to continue
// paging.
func (c *NamespacesRevisionsListCall) Continue(continue_ string) *NamespacesRevisionsListCall {
	c.urlParams_.Set("continue", continue_)
	return c
}

// FieldSelector sets the optional parameter "fieldSelector": Allows to filter
// resources based on a specific value for a field name. Send this in a query
// string format. i.e. 'metadata.name%3Dlorem'. Not currently used by Cloud
// Run.
func (c *NamespacesRevisionsListCall) FieldSelector(fieldSelector string) *NamespacesRevisionsListCall {
	c.urlParams_.Set("fieldSelector", fieldSelector)
	return c
}

// IncludeUninitialized sets the optional parameter "includeUninitialized": Not
// currently used by Cloud Run.
func (c *NamespacesRevisionsListCall) IncludeUninitialized(includeUninitialized bool) *NamespacesRevisionsListCall {
	c.urlParams_.Set("includeUninitialized", fmt.Sprint(includeUninitialized))
	return c
}

// LabelSelector sets the optional parameter "labelSelector": Allows to filter
// resources based on a label. Supported operations are =, !=, exists, in, and
// notIn.
func (c *NamespacesRevisionsListCall) LabelSelector(labelSelector string) *NamespacesRevisionsListCall {
	c.urlParams_.Set("labelSelector", labelSelector)
	return c
}

// Limit sets the optional parameter "limit": The maximum number of records
// that should be returned.
func (c *NamespacesRevisionsListCall) Limit(limit int64) *NamespacesRevisionsListCall {
	c.urlParams_.Set("limit", fmt.Sprint(limit))
	return c
}

// ResourceVersion sets the optional parameter "resourceVersion": The baseline
// resource version from which the list or watch operation should start. Not
// currently used by Cloud Run.
func (c *NamespacesRevisionsListCall) ResourceVersion(resourceVersion string) *NamespacesRevisionsListCall {
	c.urlParams_.Set("resourceVersion", resourceVersion)
	return c
}

// Watch sets the optional parameter "watch": Flag that indicates that the
// client expects to watch this resource as well. Not currently used by Cloud
// Run.
func (c *NamespacesRevisionsListCall) Watch(watch bool) *NamespacesRevisionsListCall {
	c.urlParams_.Set("watch", fmt.Sprint(watch))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesRevisionsListCall) Fields(s ...googleapi.Field) *NamespacesRevisionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *NamespacesRevisionsListCall) IfNoneMatch(entityTag string) *NamespacesRevisionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesRevisionsListCall) Context(ctx context.Context) *NamespacesRevisionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesRevisionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesRevisionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/serving.knative.dev/v1/{+parent}/revisions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.revisions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.revisions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListRevisionsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *NamespacesRevisionsListCall) Do(opts ...googleapi.CallOption) (*ListRevisionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListRevisionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.revisions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesRoutesGetCall struct {
	s            *APIService
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get information about a route.
//
//   - name: The name of the route to retrieve. For Cloud Run (fully managed),
//     replace {namespace} with the project ID or number. It takes the form
//     namespaces/{namespace}. For example: namespaces/PROJECT_ID.
func (r *NamespacesRoutesService) Get(name string) *NamespacesRoutesGetCall {
	c := &NamespacesRoutesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesRoutesGetCall) Fields(s ...googleapi.Field) *NamespacesRoutesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *NamespacesRoutesGetCall) IfNoneMatch(entityTag string) *NamespacesRoutesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesRoutesGetCall) Context(ctx context.Context) *NamespacesRoutesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesRoutesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesRoutesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/serving.knative.dev/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.routes.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.routes.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Route.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesRoutesGetCall) Do(opts ...googleapi.CallOption) (*Route, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Route{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.routes.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesRoutesListCall struct {
	s            *APIService
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List routes. Results are sorted by creation time, descending.
//
//   - parent: The namespace from which the routes should be listed. For Cloud
//     Run (fully managed), replace {namespace} with the project ID or number. It
//     takes the form namespaces/{namespace}. For example: namespaces/PROJECT_ID.
func (r *NamespacesRoutesService) List(parent string) *NamespacesRoutesListCall {
	c := &NamespacesRoutesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Continue sets the optional parameter "continue": Encoded string to continue
// paging.
func (c *NamespacesRoutesListCall) Continue(continue_ string) *NamespacesRoutesListCall {
	c.urlParams_.Set("continue", continue_)
	return c
}

// FieldSelector sets the optional parameter "fieldSelector": Allows to filter
// resources based on a specific value for a field name. Send this in a query
// string format. i.e. 'metadata.name%3Dlorem'. Not currently used by Cloud
// Run.
func (c *NamespacesRoutesListCall) FieldSelector(fieldSelector string) *NamespacesRoutesListCall {
	c.urlParams_.Set("fieldSelector", fieldSelector)
	return c
}

// IncludeUninitialized sets the optional parameter "includeUninitialized": Not
// currently used by Cloud Run.
func (c *NamespacesRoutesListCall) IncludeUninitialized(includeUninitialized bool) *NamespacesRoutesListCall {
	c.urlParams_.Set("includeUninitialized", fmt.Sprint(includeUninitialized))
	return c
}

// LabelSelector sets the optional parameter "labelSelector": Allows to filter
// resources based on a label. Supported operations are =, !=, exists, in, and
// notIn.
func (c *NamespacesRoutesListCall) LabelSelector(labelSelector string) *NamespacesRoutesListCall {
	c.urlParams_.Set("labelSelector", labelSelector)
	return c
}

// Limit sets the optional parameter "limit": The maximum number of records
// that should be returned.
func (c *NamespacesRoutesListCall) Limit(limit int64) *NamespacesRoutesListCall {
	c.urlParams_.Set("limit", fmt.Sprint(limit))
	return c
}

// ResourceVersion sets the optional parameter "resourceVersion": The baseline
// resource version from which the list or watch operation should start. Not
// currently used by Cloud Run.
func (c *NamespacesRoutesListCall) ResourceVersion(resourceVersion string) *NamespacesRoutesListCall {
	c.urlParams_.Set("resourceVersion", resourceVersion)
	return c
}

// Watch sets the optional parameter "watch": Flag that indicates that the
// client expects to watch this resource as well. Not currently used by Cloud
// Run.
func (c *NamespacesRoutesListCall) Watch(watch bool) *NamespacesRoutesListCall {
	c.urlParams_.Set("watch", fmt.Sprint(watch))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesRoutesListCall) Fields(s ...googleapi.Field) *NamespacesRoutesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *NamespacesRoutesListCall) IfNoneMatch(entityTag string) *NamespacesRoutesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesRoutesListCall) Context(ctx context.Context) *NamespacesRoutesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesRoutesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesRoutesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/serving.knative.dev/v1/{+parent}/routes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.routes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.routes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListRoutesResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *NamespacesRoutesListCall) Do(opts ...googleapi.CallOption) (*ListRoutesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListRoutesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.routes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesServicesCreateCall struct {
	s          *APIService
	parent     string
	service    *Service
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new Service. Service creation will trigger a new
// deployment. Use GetService, and check service.status to determine if the
// Service is ready.
//
//   - parent: The resource's parent. In Cloud Run, it may be one of the
//     following: * `{project_id_or_number}` *
//     `namespaces/{project_id_or_number}` *
//     `namespaces/{project_id_or_number}/services` *
//     `projects/{project_id_or_number}/locations/{region}` *
//     `projects/{project_id_or_number}/regions/{region}`.
func (r *NamespacesServicesService) Create(parent string, service *Service) *NamespacesServicesCreateCall {
	c := &NamespacesServicesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.service = service
	return c
}

// DryRun sets the optional parameter "dryRun": Indicates that the server
// should validate the request and populate default values without persisting
// the request. Supported values: `all`
func (c *NamespacesServicesCreateCall) DryRun(dryRun string) *NamespacesServicesCreateCall {
	c.urlParams_.Set("dryRun", dryRun)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesServicesCreateCall) Fields(s ...googleapi.Field) *NamespacesServicesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesServicesCreateCall) Context(ctx context.Context) *NamespacesServicesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesServicesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesServicesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.service)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/serving.knative.dev/v1/{+parent}/services")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.services.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.services.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Service.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesServicesCreateCall) Do(opts ...googleapi.CallOption) (*Service, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Service{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.services.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesServicesDeleteCall struct {
	s          *APIService
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the provided service. This will cause the Service to stop
// serving traffic and will delete all associated Revisions.
//
//   - name: The fully qualified name of the service to delete. It can be any of
//     the following forms: *
//     `namespaces/{project_id_or_number}/services/{service_name}` (only when the
//     `endpoint` is regional) *
//     `projects/{project_id_or_number}/locations/{region}/services/{service_name}
//     ` *
//     `projects/{project_id_or_number}/regions/{region}/services/{service_name}`.
func (r *NamespacesServicesService) Delete(name string) *NamespacesServicesDeleteCall {
	c := &NamespacesServicesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ApiVersion sets the optional parameter "apiVersion": Not supported, and
// ignored by Cloud Run.
func (c *NamespacesServicesDeleteCall) ApiVersion(apiVersion string) *NamespacesServicesDeleteCall {
	c.urlParams_.Set("apiVersion", apiVersion)
	return c
}

// DryRun sets the optional parameter "dryRun": Indicates that the server
// should validate the request and populate default values without persisting
// the request. Supported values: `all`
func (c *NamespacesServicesDeleteCall) DryRun(dryRun string) *NamespacesServicesDeleteCall {
	c.urlParams_.Set("dryRun", dryRun)
	return c
}

// Kind sets the optional parameter "kind": Not supported, and ignored by Cloud
// Run.
func (c *NamespacesServicesDeleteCall) Kind(kind string) *NamespacesServicesDeleteCall {
	c.urlParams_.Set("kind", kind)
	return c
}

// PropagationPolicy sets the optional parameter "propagationPolicy": Not
// supported, and ignored by Cloud Run.
func (c *NamespacesServicesDeleteCall) PropagationPolicy(propagationPolicy string) *NamespacesServicesDeleteCall {
	c.urlParams_.Set("propagationPolicy", propagationPolicy)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesServicesDeleteCall) Fields(s ...googleapi.Field) *NamespacesServicesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesServicesDeleteCall) Context(ctx context.Context) *NamespacesServicesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesServicesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesServicesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/serving.knative.dev/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.services.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.services.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Status.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesServicesDeleteCall) Do(opts ...googleapi.CallOption) (*Status, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Status{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.services.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesServicesGetCall struct {
	s            *APIService
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a service.
//
//   - name: The fully qualified name of the service to retrieve. It can be any
//     of the following forms: *
//     `namespaces/{project_id_or_number}/services/{service_name}` (only when the
//     `endpoint` is regional) *
//     `projects/{project_id_or_number}/locations/{region}/services/{service_name}
//     ` *
//     `projects/{project_id_or_number}/regions/{region}/services/{service_name}`.
func (r *NamespacesServicesService) Get(name string) *NamespacesServicesGetCall {
	c := &NamespacesServicesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesServicesGetCall) Fields(s ...googleapi.Field) *NamespacesServicesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *NamespacesServicesGetCall) IfNoneMatch(entityTag string) *NamespacesServicesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesServicesGetCall) Context(ctx context.Context) *NamespacesServicesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesServicesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesServicesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/serving.knative.dev/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.services.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.services.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Service.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesServicesGetCall) Do(opts ...googleapi.CallOption) (*Service, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Service{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.services.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesServicesListCall struct {
	s            *APIService
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists services for the given project and region. Results are sorted by
// creation time, descending.
//
//   - parent: The parent from where the resources should be listed. In Cloud
//     Run, it may be one of the following: * `{project_id_or_number}` *
//     `namespaces/{project_id_or_number}` *
//     `namespaces/{project_id_or_number}/services` *
//     `projects/{project_id_or_number}/locations/{region}` *
//     `projects/{project_id_or_number}/regions/{region}`.
func (r *NamespacesServicesService) List(parent string) *NamespacesServicesListCall {
	c := &NamespacesServicesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Continue sets the optional parameter "continue": Encoded string to continue
// paging.
func (c *NamespacesServicesListCall) Continue(continue_ string) *NamespacesServicesListCall {
	c.urlParams_.Set("continue", continue_)
	return c
}

// FieldSelector sets the optional parameter "fieldSelector": Not supported,
// and ignored by Cloud Run.
func (c *NamespacesServicesListCall) FieldSelector(fieldSelector string) *NamespacesServicesListCall {
	c.urlParams_.Set("fieldSelector", fieldSelector)
	return c
}

// IncludeUninitialized sets the optional parameter "includeUninitialized": Not
// supported, and ignored by Cloud Run.
func (c *NamespacesServicesListCall) IncludeUninitialized(includeUninitialized bool) *NamespacesServicesListCall {
	c.urlParams_.Set("includeUninitialized", fmt.Sprint(includeUninitialized))
	return c
}

// LabelSelector sets the optional parameter "labelSelector": Allows to filter
// resources based on a label. Supported operations are =, !=, exists, in, and
// notIn.
func (c *NamespacesServicesListCall) LabelSelector(labelSelector string) *NamespacesServicesListCall {
	c.urlParams_.Set("labelSelector", labelSelector)
	return c
}

// Limit sets the optional parameter "limit": The maximum number of records
// that should be returned.
func (c *NamespacesServicesListCall) Limit(limit int64) *NamespacesServicesListCall {
	c.urlParams_.Set("limit", fmt.Sprint(limit))
	return c
}

// ResourceVersion sets the optional parameter "resourceVersion": Not
// supported, and ignored by Cloud Run.
func (c *NamespacesServicesListCall) ResourceVersion(resourceVersion string) *NamespacesServicesListCall {
	c.urlParams_.Set("resourceVersion", resourceVersion)
	return c
}

// Watch sets the optional parameter "watch": Not supported, and ignored by
// Cloud Run.
func (c *NamespacesServicesListCall) Watch(watch bool) *NamespacesServicesListCall {
	c.urlParams_.Set("watch", fmt.Sprint(watch))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesServicesListCall) Fields(s ...googleapi.Field) *NamespacesServicesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *NamespacesServicesListCall) IfNoneMatch(entityTag string) *NamespacesServicesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesServicesListCall) Context(ctx context.Context) *NamespacesServicesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesServicesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesServicesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/serving.knative.dev/v1/{+parent}/services")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.services.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.services.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListServicesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *NamespacesServicesListCall) Do(opts ...googleapi.CallOption) (*ListServicesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListServicesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.services.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesServicesReplaceServiceCall struct {
	s          *APIService
	name       string
	service    *Service
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// ReplaceService: Replaces a service. Only the spec and metadata labels and
// annotations are modifiable. After the Update request, Cloud Run will work to
// make the 'status' match the requested 'spec'. May provide
// metadata.resourceVersion to enforce update from last read for optimistic
// concurrency control.
//
//   - name: The fully qualified name of the service to replace. It can be any of
//     the following forms: *
//     `namespaces/{project_id_or_number}/services/{service_name}` (only when the
//     `endpoint` is regional) *
//     `projects/{project_id_or_number}/locations/{region}/services/{service_name}
//     ` *
//     `projects/{project_id_or_number}/regions/{region}/services/{service_name}`.
func (r *NamespacesServicesService) ReplaceService(name string, service *Service) *NamespacesServicesReplaceServiceCall {
	c := &NamespacesServicesReplaceServiceCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.service = service
	return c
}

// DryRun sets the optional parameter "dryRun": Indicates that the server
// should validate the request and populate default values without persisting
// the request. Supported values: `all`
func (c *NamespacesServicesReplaceServiceCall) DryRun(dryRun string) *NamespacesServicesReplaceServiceCall {
	c.urlParams_.Set("dryRun", dryRun)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesServicesReplaceServiceCall) Fields(s ...googleapi.Field) *NamespacesServicesReplaceServiceCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesServicesReplaceServiceCall) Context(ctx context.Context) *NamespacesServicesReplaceServiceCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesServicesReplaceServiceCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesServicesReplaceServiceCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.service)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/serving.knative.dev/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.services.replaceService", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.services.replaceService" call.
// Any non-2xx status code is an error. Response headers are in either
// *Service.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesServicesReplaceServiceCall) Do(opts ...googleapi.CallOption) (*Service, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Service{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.services.replaceService", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesTasksGetCall struct {
	s            *APIService
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get information about a task.
//
//   - name: The name of the task to retrieve. Replace {namespace} with the
//     project ID or number. It takes the form namespaces/{namespace}. For
//     example: namespaces/PROJECT_ID.
func (r *NamespacesTasksService) Get(name string) *NamespacesTasksGetCall {
	c := &NamespacesTasksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesTasksGetCall) Fields(s ...googleapi.Field) *NamespacesTasksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *NamespacesTasksGetCall) IfNoneMatch(entityTag string) *NamespacesTasksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesTasksGetCall) Context(ctx context.Context) *NamespacesTasksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesTasksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesTasksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.tasks.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.tasks.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Task.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesTasksGetCall) Do(opts ...googleapi.CallOption) (*Task, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Task{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.tasks.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesTasksListCall struct {
	s            *APIService
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List tasks.
//
//   - parent: The namespace from which the tasks should be listed. Replace
//     {namespace} with the project ID or number. It takes the form
//     namespaces/{namespace}. For example: namespaces/PROJECT_ID.
func (r *NamespacesTasksService) List(parent string) *NamespacesTasksListCall {
	c := &NamespacesTasksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Continue sets the optional parameter "continue": Optional encoded string to
// continue paging.
func (c *NamespacesTasksListCall) Continue(continue_ string) *NamespacesTasksListCall {
	c.urlParams_.Set("continue", continue_)
	return c
}

// FieldSelector sets the optional parameter "fieldSelector": Not supported by
// Cloud Run.
func (c *NamespacesTasksListCall) FieldSelector(fieldSelector string) *NamespacesTasksListCall {
	c.urlParams_.Set("fieldSelector", fieldSelector)
	return c
}

// IncludeUninitialized sets the optional parameter "includeUninitialized": Not
// supported by Cloud Run.
func (c *NamespacesTasksListCall) IncludeUninitialized(includeUninitialized bool) *NamespacesTasksListCall {
	c.urlParams_.Set("includeUninitialized", fmt.Sprint(includeUninitialized))
	return c
}

// LabelSelector sets the optional parameter "labelSelector": Allows to filter
// resources based on a label. Supported operations are =, !=, exists, in, and
// notIn. For example, to list all tasks of execution "foo" in succeeded state:
// `run.googleapis.com/execution=foo,run.googleapis.com/runningState=Succeeded`.
//
//	Supported states are: * `Pending`: Initial state of all tasks. The task has
//
// not yet started but eventually will. * `Running`: Container instances for
// this task are running or will be running shortly. * `Succeeded`: No more
// container instances to run for the task, and the last attempt succeeded. *
// `Failed`: No more container instances to run for the task, and the last
// attempt failed. This task has run out of retry attempts. * `Cancelled`: Task
// was running but got stopped because its parent execution has been aborted. *
// `Abandoned`: The task has not yet started and never will because its parent
// execution has been aborted.
func (c *NamespacesTasksListCall) LabelSelector(labelSelector string) *NamespacesTasksListCall {
	c.urlParams_.Set("labelSelector", labelSelector)
	return c
}

// Limit sets the optional parameter "limit": The maximum number of records
// that should be returned.
func (c *NamespacesTasksListCall) Limit(limit int64) *NamespacesTasksListCall {
	c.urlParams_.Set("limit", fmt.Sprint(limit))
	return c
}

// ResourceVersion sets the optional parameter "resourceVersion": Not supported
// by Cloud Run.
func (c *NamespacesTasksListCall) ResourceVersion(resourceVersion string) *NamespacesTasksListCall {
	c.urlParams_.Set("resourceVersion", resourceVersion)
	return c
}

// Watch sets the optional parameter "watch": Not supported by Cloud Run.
func (c *NamespacesTasksListCall) Watch(watch bool) *NamespacesTasksListCall {
	c.urlParams_.Set("watch", fmt.Sprint(watch))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesTasksListCall) Fields(s ...googleapi.Field) *NamespacesTasksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *NamespacesTasksListCall) IfNoneMatch(entityTag string) *NamespacesTasksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesTasksListCall) Context(ctx context.Context) *NamespacesTasksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesTasksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesTasksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1/{+parent}/tasks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.tasks.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.tasks.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListTasksResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *NamespacesTasksListCall) Do(opts ...googleapi.CallOption) (*ListTasksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListTasksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.tasks.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesWorkerpoolsCreateCall struct {
	s          *APIService
	parent     string
	workerpool *WorkerPool
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new WorkerPool. WorkerPool creation will trigger a new
// deployment. Use GetWorkerPool, and check worker_pool.status to determine if
// the WorkerPool is ready.
//
//   - parent: The resource's parent. In Cloud Run, it may be one of the
//     following: * `{project_id_or_number}` *
//     `namespaces/{project_id_or_number}` *
//     `namespaces/{project_id_or_number}/workerpools` *
//     `projects/{project_id_or_number}/locations/{region}` *
//     `projects/{project_id_or_number}/regions/{region}`.
func (r *NamespacesWorkerpoolsService) Create(parent string, workerpool *WorkerPool) *NamespacesWorkerpoolsCreateCall {
	c := &NamespacesWorkerpoolsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.workerpool = workerpool
	return c
}

// DryRun sets the optional parameter "dryRun": Indicates that the server
// should validate the request and populate default values without persisting
// the request. Supported values: `all`
func (c *NamespacesWorkerpoolsCreateCall) DryRun(dryRun string) *NamespacesWorkerpoolsCreateCall {
	c.urlParams_.Set("dryRun", dryRun)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesWorkerpoolsCreateCall) Fields(s ...googleapi.Field) *NamespacesWorkerpoolsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesWorkerpoolsCreateCall) Context(ctx context.Context) *NamespacesWorkerpoolsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesWorkerpoolsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesWorkerpoolsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.workerpool)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1/{+parent}/workerpools")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.workerpools.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.workerpools.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *WorkerPool.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesWorkerpoolsCreateCall) Do(opts ...googleapi.CallOption) (*WorkerPool, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &WorkerPool{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.workerpools.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesWorkerpoolsDeleteCall struct {
	s          *APIService
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the provided worker pool. This will cause the WorkerPool to
// stop all instances and will delete all associated WorkerPoolRevisions.
//
//   - name: The fully qualified name of the worker pool to delete. It can be any
//     of the following forms: *
//     `namespaces/{project_id_or_number}/workerpools/{worker_pool_name}` (only
//     when the `endpoint` is regional) *
//     `projects/{project_id_or_number}/locations/{region}/workerpools/{worker_poo
//     l_name}` *
//     `projects/{project_id_or_number}/regions/{region}/workerpools/{worker_pool_
//     name}`.
func (r *NamespacesWorkerpoolsService) Delete(name string) *NamespacesWorkerpoolsDeleteCall {
	c := &NamespacesWorkerpoolsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// DryRun sets the optional parameter "dryRun": Indicates that the server
// should validate the request and populate default values without persisting
// the request. Supported values: `all`
func (c *NamespacesWorkerpoolsDeleteCall) DryRun(dryRun string) *NamespacesWorkerpoolsDeleteCall {
	c.urlParams_.Set("dryRun", dryRun)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesWorkerpoolsDeleteCall) Fields(s ...googleapi.Field) *NamespacesWorkerpoolsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesWorkerpoolsDeleteCall) Context(ctx context.Context) *NamespacesWorkerpoolsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesWorkerpoolsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesWorkerpoolsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.workerpools.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.workerpools.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Status.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesWorkerpoolsDeleteCall) Do(opts ...googleapi.CallOption) (*Status, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Status{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.workerpools.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesWorkerpoolsGetCall struct {
	s            *APIService
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a worker pool.
//
//   - name: The fully qualified name of the worker pool to retrieve. It can be
//     any of the following forms: *
//     `namespaces/{project_id_or_number}/workerpools/{worker_pool_name}` (only
//     when the `endpoint` is regional) *
//     `projects/{project_id_or_number}/locations/{region}/workerpools/{worker_poo
//     l_name}` *
//     `projects/{project_id_or_number}/regions/{region}/workerpools/{worker_pool_
//     name}`.
func (r *NamespacesWorkerpoolsService) Get(name string) *NamespacesWorkerpoolsGetCall {
	c := &NamespacesWorkerpoolsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesWorkerpoolsGetCall) Fields(s ...googleapi.Field) *NamespacesWorkerpoolsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *NamespacesWorkerpoolsGetCall) IfNoneMatch(entityTag string) *NamespacesWorkerpoolsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesWorkerpoolsGetCall) Context(ctx context.Context) *NamespacesWorkerpoolsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesWorkerpoolsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesWorkerpoolsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.workerpools.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.workerpools.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *WorkerPool.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesWorkerpoolsGetCall) Do(opts ...googleapi.CallOption) (*WorkerPool, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &WorkerPool{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.workerpools.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesWorkerpoolsListCall struct {
	s            *APIService
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists worker pools for the given project and region. Results are
// sorted by creation time, descending.
//
//   - parent: The parent from where the resources should be listed. In Cloud
//     Run, it may be one of the following: * `{project_id_or_number}` *
//     `namespaces/{project_id_or_number}` *
//     `namespaces/{project_id_or_number}/workerpools` *
//     `projects/{project_id_or_number}/locations/{region}` *
//     `projects/{project_id_or_number}/regions/{region}`.
func (r *NamespacesWorkerpoolsService) List(parent string) *NamespacesWorkerpoolsListCall {
	c := &NamespacesWorkerpoolsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Continue sets the optional parameter "continue": Encoded string to continue
// paging.
func (c *NamespacesWorkerpoolsListCall) Continue(continue_ string) *NamespacesWorkerpoolsListCall {
	c.urlParams_.Set("continue", continue_)
	return c
}

// LabelSelector sets the optional parameter "labelSelector": =, !=, exists,
// in, and notIn.
func (c *NamespacesWorkerpoolsListCall) LabelSelector(labelSelector string) *NamespacesWorkerpoolsListCall {
	c.urlParams_.Set("labelSelector", labelSelector)
	return c
}

// Limit sets the optional parameter "limit": The maximum number of records
// that should be returned.
func (c *NamespacesWorkerpoolsListCall) Limit(limit int64) *NamespacesWorkerpoolsListCall {
	c.urlParams_.Set("limit", fmt.Sprint(limit))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesWorkerpoolsListCall) Fields(s ...googleapi.Field) *NamespacesWorkerpoolsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *NamespacesWorkerpoolsListCall) IfNoneMatch(entityTag string) *NamespacesWorkerpoolsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesWorkerpoolsListCall) Context(ctx context.Context) *NamespacesWorkerpoolsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesWorkerpoolsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesWorkerpoolsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1/{+parent}/workerpools")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.workerpools.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.workerpools.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListWorkerPoolsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *NamespacesWorkerpoolsListCall) Do(opts ...googleapi.CallOption) (*ListWorkerPoolsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListWorkerPoolsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.workerpools.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type NamespacesWorkerpoolsReplaceWorkerPoolCall struct {
	s          *APIService
	name       string
	workerpool *WorkerPool
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// ReplaceWorkerPool: Replaces a worker pool. Only the spec and metadata labels
// and annotations are modifiable. After the Update request, Cloud Run will
// work to make the 'status' match the requested 'spec'. May provide
// metadata.resourceVersion to enforce update from last read for optimistic
// concurrency control.
//
//   - name: The fully qualified name of the worker pool to replace. It can be
//     any of the following forms: *
//     `namespaces/{project_id_or_number}/workerpools/{worker_pool_name}` (only
//     when the `endpoint` is regional) *
//     `projects/{project_id_or_number}/locations/{region}/workerpools/{worker_poo
//     l_name}` *
//     `projects/{project_id_or_number}/regions/{region}/workerpools/{worker_pool_
//     name}`.
func (r *NamespacesWorkerpoolsService) ReplaceWorkerPool(name string, workerpool *WorkerPool) *NamespacesWorkerpoolsReplaceWorkerPoolCall {
	c := &NamespacesWorkerpoolsReplaceWorkerPoolCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.workerpool = workerpool
	return c
}

// DryRun sets the optional parameter "dryRun": Indicates that the server
// should validate the request and populate default values without persisting
// the request. Supported values: `all`
func (c *NamespacesWorkerpoolsReplaceWorkerPoolCall) DryRun(dryRun string) *NamespacesWorkerpoolsReplaceWorkerPoolCall {
	c.urlParams_.Set("dryRun", dryRun)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *NamespacesWorkerpoolsReplaceWorkerPoolCall) Fields(s ...googleapi.Field) *NamespacesWorkerpoolsReplaceWorkerPoolCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *NamespacesWorkerpoolsReplaceWorkerPoolCall) Context(ctx context.Context) *NamespacesWorkerpoolsReplaceWorkerPoolCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *NamespacesWorkerpoolsReplaceWorkerPoolCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *NamespacesWorkerpoolsReplaceWorkerPoolCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.workerpool)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "apis/run.googleapis.com/v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.namespaces.workerpools.replaceWorkerPool", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.namespaces.workerpools.replaceWorkerPool" call.
// Any non-2xx status code is an error. Response headers are in either
// *WorkerPool.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *NamespacesWorkerpoolsReplaceWorkerPoolCall) Do(opts ...googleapi.CallOption) (*WorkerPool, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &WorkerPool{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.namespaces.workerpools.replaceWorkerPool", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsAuthorizeddomainsListCall struct {
	s            *APIService
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List authorized domains.
//
//   - parent: Name of the parent Project resource. Example:
//     `projects/myproject`.
func (r *ProjectsAuthorizeddomainsService) List(parent string) *ProjectsAuthorizeddomainsListCall {
	c := &ProjectsAuthorizeddomainsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum results to return
// per page.
func (c *ProjectsAuthorizeddomainsListCall) PageSize(pageSize int64) *ProjectsAuthorizeddomainsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Continuation token for
// fetching the next page of results.
func (c *ProjectsAuthorizeddomainsListCall) PageToken(pageToken string) *ProjectsAuthorizeddomainsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsAuthorizeddomainsListCall) Fields(s ...googleapi.Field) *ProjectsAuthorizeddomainsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsAuthorizeddomainsListCall) IfNoneMatch(entityTag string) *ProjectsAuthorizeddomainsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsAuthorizeddomainsListCall) Context(ctx context.Context) *ProjectsAuthorizeddomainsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsAuthorizeddomainsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsAuthorizeddomainsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/authorizeddomains")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.authorizeddomains.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.authorizeddomains.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAuthorizedDomainsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsAuthorizeddomainsListCall) Do(opts ...googleapi.CallOption) (*ListAuthorizedDomainsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAuthorizedDomainsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.authorizeddomains.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsAuthorizeddomainsListCall) Pages(ctx context.Context, f func(*ListAuthorizedDomainsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsListCall struct {
	s            *APIService
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists information about the supported locations for this service.
//
// - name: The resource that owns the locations collection, if applicable.
func (r *ProjectsLocationsService) List(name string) *ProjectsLocationsListCall {
	c := &ProjectsLocationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ExtraLocationTypes sets the optional parameter "extraLocationTypes": Do not
// use this field. It is unsupported and is ignored unless explicitly
// documented otherwise. This is primarily for internal usage.
func (c *ProjectsLocationsListCall) ExtraLocationTypes(extraLocationTypes ...string) *ProjectsLocationsListCall {
	c.urlParams_.SetMulti("extraLocationTypes", append([]string{}, extraLocationTypes...))
	return c
}

// Filter sets the optional parameter "filter": A filter to narrow down results
// to a preferred subset. The filtering language accepts strings like
// "displayName=tokyo", and is documented in more detail in AIP-160
// (https://google.aip.dev/160).
func (c *ProjectsLocationsListCall) Filter(filter string) *ProjectsLocationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// results to return. If not set, the service selects a default.
func (c *ProjectsLocationsListCall) PageSize(pageSize int64) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from the `next_page_token` field in the response. Send that page token to
// receive the subsequent page.
func (c *ProjectsLocationsListCall) PageToken(pageToken string) *ProjectsLocationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsListCall) Context(ctx context.Context) *ProjectsLocationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/locations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListLocationsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsListCall) Do(opts ...googleapi.CallOption) (*ListLocationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListLocationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsListCall) Pages(ctx context.Context, f func(*ListLocationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsAuthorizeddomainsListCall struct {
	s            *APIService
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List authorized domains.
//
//   - parent: Name of the parent Project resource. Example:
//     `projects/myproject`.
func (r *ProjectsLocationsAuthorizeddomainsService) List(parent string) *ProjectsLocationsAuthorizeddomainsListCall {
	c := &ProjectsLocationsAuthorizeddomainsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum results to return
// per page.
func (c *ProjectsLocationsAuthorizeddomainsListCall) PageSize(pageSize int64) *ProjectsLocationsAuthorizeddomainsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Continuation token for
// fetching the next page of results.
func (c *ProjectsLocationsAuthorizeddomainsListCall) PageToken(pageToken string) *ProjectsLocationsAuthorizeddomainsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsAuthorizeddomainsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsAuthorizeddomainsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsAuthorizeddomainsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsAuthorizeddomainsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsAuthorizeddomainsListCall) Context(ctx context.Context) *ProjectsLocationsAuthorizeddomainsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsAuthorizeddomainsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsAuthorizeddomainsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/authorizeddomains")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.authorizeddomains.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.authorizeddomains.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListAuthorizedDomainsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsAuthorizeddomainsListCall) Do(opts ...googleapi.CallOption) (*ListAuthorizedDomainsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListAuthorizedDomainsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.authorizeddomains.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsAuthorizeddomainsListCall) Pages(ctx context.Context, f func(*ListAuthorizedDomainsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsConfigurationsGetCall struct {
	s            *APIService
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get information about a configuration.
//
//   - name: The name of the configuration to retrieve. For Cloud Run, replace
//     {namespace_id} with the project ID or number.
func (r *ProjectsLocationsConfigurationsService) Get(name string) *ProjectsLocationsConfigurationsGetCall {
	c := &ProjectsLocationsConfigurationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConfigurationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsConfigurationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConfigurationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsConfigurationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConfigurationsGetCall) Context(ctx context.Context) *ProjectsLocationsConfigurationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConfigurationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConfigurationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.configurations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.configurations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Configuration.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsConfigurationsGetCall) Do(opts ...googleapi.CallOption) (*Configuration, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Configuration{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.configurations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsConfigurationsListCall struct {
	s            *APIService
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List configurations. Results are sorted by creation time, descending.
//
//   - parent: The namespace from which the configurations should be listed. For
//     Cloud Run, replace {namespace_id} with the project ID or number.
func (r *ProjectsLocationsConfigurationsService) List(parent string) *ProjectsLocationsConfigurationsListCall {
	c := &ProjectsLocationsConfigurationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Continue sets the optional parameter "continue": Encoded string to continue
// paging.
func (c *ProjectsLocationsConfigurationsListCall) Continue(continue_ string) *ProjectsLocationsConfigurationsListCall {
	c.urlParams_.Set("continue", continue_)
	return c
}

// FieldSelector sets the optional parameter "fieldSelector": Not supported by
// Cloud Run.
func (c *ProjectsLocationsConfigurationsListCall) FieldSelector(fieldSelector string) *ProjectsLocationsConfigurationsListCall {
	c.urlParams_.Set("fieldSelector", fieldSelector)
	return c
}

// IncludeUninitialized sets the optional parameter "includeUninitialized": Not
// supported by Cloud Run.
func (c *ProjectsLocationsConfigurationsListCall) IncludeUninitialized(includeUninitialized bool) *ProjectsLocationsConfigurationsListCall {
	c.urlParams_.Set("includeUninitialized", fmt.Sprint(includeUninitialized))
	return c
}

// LabelSelector sets the optional parameter "labelSelector": Allows to filter
// resources based on a label. Supported operations are =, !=, exists, in, and
// notIn.
func (c *ProjectsLocationsConfigurationsListCall) LabelSelector(labelSelector string) *ProjectsLocationsConfigurationsListCall {
	c.urlParams_.Set("labelSelector", labelSelector)
	return c
}

// Limit sets the optional parameter "limit": The maximum number of the records
// that should be returned.
func (c *ProjectsLocationsConfigurationsListCall) Limit(limit int64) *ProjectsLocationsConfigurationsListCall {
	c.urlParams_.Set("limit", fmt.Sprint(limit))
	return c
}

// ResourceVersion sets the optional parameter "resourceVersion": Not supported
// by Cloud Run.
func (c *ProjectsLocationsConfigurationsListCall) ResourceVersion(resourceVersion string) *ProjectsLocationsConfigurationsListCall {
	c.urlParams_.Set("resourceVersion", resourceVersion)
	return c
}

// Watch sets the optional parameter "watch": Not supported by Cloud Run.
func (c *ProjectsLocationsConfigurationsListCall) Watch(watch bool) *ProjectsLocationsConfigurationsListCall {
	c.urlParams_.Set("watch", fmt.Sprint(watch))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsConfigurationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsConfigurationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsConfigurationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsConfigurationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsConfigurationsListCall) Context(ctx context.Context) *ProjectsLocationsConfigurationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsConfigurationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsConfigurationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/configurations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.configurations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.configurations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListConfigurationsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsConfigurationsListCall) Do(opts ...googleapi.CallOption) (*ListConfigurationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListConfigurationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.configurations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDomainmappingsCreateCall struct {
	s             *APIService
	parent        string
	domainmapping *DomainMapping
	urlParams_    gensupport.URLParams
	ctx_          context.Context
	header_       http.Header
}

// Create: Create a new domain mapping.
//
//   - parent: The namespace in which the domain mapping should be created. For
//     Cloud Run (fully managed), replace {namespace} with the project ID or
//     number. It takes the form namespaces/{namespace}. For example:
//     namespaces/PROJECT_ID.
func (r *ProjectsLocationsDomainmappingsService) Create(parent string, domainmapping *DomainMapping) *ProjectsLocationsDomainmappingsCreateCall {
	c := &ProjectsLocationsDomainmappingsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.domainmapping = domainmapping
	return c
}

// DryRun sets the optional parameter "dryRun": Indicates that the server
// should validate the request and populate default values without persisting
// the request. Supported values: `all`
func (c *ProjectsLocationsDomainmappingsCreateCall) DryRun(dryRun string) *ProjectsLocationsDomainmappingsCreateCall {
	c.urlParams_.Set("dryRun", dryRun)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDomainmappingsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsDomainmappingsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDomainmappingsCreateCall) Context(ctx context.Context) *ProjectsLocationsDomainmappingsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDomainmappingsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDomainmappingsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.domainmapping)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/domainmappings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.domainmappings.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.domainmappings.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *DomainMapping.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDomainmappingsCreateCall) Do(opts ...googleapi.CallOption) (*DomainMapping, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DomainMapping{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.domainmappings.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDomainmappingsDeleteCall struct {
	s          *APIService
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a domain mapping.
//
//   - name: The name of the domain mapping to delete. For Cloud Run (fully
//     managed), replace {namespace} with the project ID or number. It takes the
//     form namespaces/{namespace}. For example: namespaces/PROJECT_ID.
func (r *ProjectsLocationsDomainmappingsService) Delete(name string) *ProjectsLocationsDomainmappingsDeleteCall {
	c := &ProjectsLocationsDomainmappingsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ApiVersion sets the optional parameter "apiVersion": Cloud Run currently
// ignores this parameter.
func (c *ProjectsLocationsDomainmappingsDeleteCall) ApiVersion(apiVersion string) *ProjectsLocationsDomainmappingsDeleteCall {
	c.urlParams_.Set("apiVersion", apiVersion)
	return c
}

// DryRun sets the optional parameter "dryRun": Indicates that the server
// should validate the request and populate default values without persisting
// the request. Supported values: `all`
func (c *ProjectsLocationsDomainmappingsDeleteCall) DryRun(dryRun string) *ProjectsLocationsDomainmappingsDeleteCall {
	c.urlParams_.Set("dryRun", dryRun)
	return c
}

// Kind sets the optional parameter "kind": Cloud Run currently ignores this
// parameter.
func (c *ProjectsLocationsDomainmappingsDeleteCall) Kind(kind string) *ProjectsLocationsDomainmappingsDeleteCall {
	c.urlParams_.Set("kind", kind)
	return c
}

// PropagationPolicy sets the optional parameter "propagationPolicy": Specifies
// the propagation policy of delete. Cloud Run currently ignores this setting,
// and deletes in the background. Please see
// kubernetes.io/docs/concepts/architecture/garbage-collection/ for more
// information.
func (c *ProjectsLocationsDomainmappingsDeleteCall) PropagationPolicy(propagationPolicy string) *ProjectsLocationsDomainmappingsDeleteCall {
	c.urlParams_.Set("propagationPolicy", propagationPolicy)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDomainmappingsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsDomainmappingsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDomainmappingsDeleteCall) Context(ctx context.Context) *ProjectsLocationsDomainmappingsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDomainmappingsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDomainmappingsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.domainmappings.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.domainmappings.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Status.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDomainmappingsDeleteCall) Do(opts ...googleapi.CallOption) (*Status, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Status{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.domainmappings.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDomainmappingsGetCall struct {
	s            *APIService
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get information about a domain mapping.
//
//   - name: The name of the domain mapping to retrieve. For Cloud Run (fully
//     managed), replace {namespace} with the project ID or number. It takes the
//     form namespaces/{namespace}. For example: namespaces/PROJECT_ID.
func (r *ProjectsLocationsDomainmappingsService) Get(name string) *ProjectsLocationsDomainmappingsGetCall {
	c := &ProjectsLocationsDomainmappingsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDomainmappingsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsDomainmappingsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDomainmappingsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsDomainmappingsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDomainmappingsGetCall) Context(ctx context.Context) *ProjectsLocationsDomainmappingsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDomainmappingsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDomainmappingsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.domainmappings.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.domainmappings.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *DomainMapping.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsDomainmappingsGetCall) Do(opts ...googleapi.CallOption) (*DomainMapping, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DomainMapping{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.domainmappings.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsDomainmappingsListCall struct {
	s            *APIService
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List all domain mappings.
//
//   - parent: The namespace from which the domain mappings should be listed. For
//     Cloud Run (fully managed), replace {namespace} with the project ID or
//     number. It takes the form namespaces/{namespace}. For example:
//     namespaces/PROJECT_ID.
func (r *ProjectsLocationsDomainmappingsService) List(parent string) *ProjectsLocationsDomainmappingsListCall {
	c := &ProjectsLocationsDomainmappingsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Continue sets the optional parameter "continue": Encoded string to continue
// paging.
func (c *ProjectsLocationsDomainmappingsListCall) Continue(continue_ string) *ProjectsLocationsDomainmappingsListCall {
	c.urlParams_.Set("continue", continue_)
	return c
}

// FieldSelector sets the optional parameter "fieldSelector": Allows to filter
// resources based on a specific value for a field name. Send this in a query
// string format. i.e. 'metadata.name%3Dlorem'. Not currently used by Cloud
// Run.
func (c *ProjectsLocationsDomainmappingsListCall) FieldSelector(fieldSelector string) *ProjectsLocationsDomainmappingsListCall {
	c.urlParams_.Set("fieldSelector", fieldSelector)
	return c
}

// IncludeUninitialized sets the optional parameter "includeUninitialized": Not
// currently used by Cloud Run.
func (c *ProjectsLocationsDomainmappingsListCall) IncludeUninitialized(includeUninitialized bool) *ProjectsLocationsDomainmappingsListCall {
	c.urlParams_.Set("includeUninitialized", fmt.Sprint(includeUninitialized))
	return c
}

// LabelSelector sets the optional parameter "labelSelector": Allows to filter
// resources based on a label. Supported operations are =, !=, exists, in, and
// notIn.
func (c *ProjectsLocationsDomainmappingsListCall) LabelSelector(labelSelector string) *ProjectsLocationsDomainmappingsListCall {
	c.urlParams_.Set("labelSelector", labelSelector)
	return c
}

// Limit sets the optional parameter "limit": The maximum number of records
// that should be returned.
func (c *ProjectsLocationsDomainmappingsListCall) Limit(limit int64) *ProjectsLocationsDomainmappingsListCall {
	c.urlParams_.Set("limit", fmt.Sprint(limit))
	return c
}

// ResourceVersion sets the optional parameter "resourceVersion": The baseline
// resource version from which the list or watch operation should start. Not
// currently used by Cloud Run.
func (c *ProjectsLocationsDomainmappingsListCall) ResourceVersion(resourceVersion string) *ProjectsLocationsDomainmappingsListCall {
	c.urlParams_.Set("resourceVersion", resourceVersion)
	return c
}

// Watch sets the optional parameter "watch": Flag that indicates that the
// client expects to watch this resource as well. Not currently used by Cloud
// Run.
func (c *ProjectsLocationsDomainmappingsListCall) Watch(watch bool) *ProjectsLocationsDomainmappingsListCall {
	c.urlParams_.Set("watch", fmt.Sprint(watch))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsDomainmappingsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsDomainmappingsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsDomainmappingsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsDomainmappingsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsDomainmappingsListCall) Context(ctx context.Context) *ProjectsLocationsDomainmappingsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsDomainmappingsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsDomainmappingsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/domainmappings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.domainmappings.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.domainmappings.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListDomainMappingsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsDomainmappingsListCall) Do(opts ...googleapi.CallOption) (*ListDomainMappingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListDomainMappingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.domainmappings.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsJobsGetIamPolicyCall struct {
	s            *APIService
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Get the IAM Access Control policy currently in effect for the
// given job. This result does not include any inherited policies.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsJobsService) GetIamPolicy(resource string) *ProjectsLocationsJobsGetIamPolicyCall {
	c := &ProjectsLocationsJobsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsJobsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsJobsGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsJobsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsJobsGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsJobsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsJobsGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsJobsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsJobsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.jobs.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsJobsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsJobsSetIamPolicyCall struct {
	s                   *APIService
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the IAM Access control policy for the specified job.
// Overwrites any existing policy.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsJobsService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsJobsSetIamPolicyCall {
	c := &ProjectsLocationsJobsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsJobsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsJobsSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsJobsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsJobsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.jobs.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsJobsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsJobsTestIamPermissionsCall struct {
	s                         *APIService
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// job. There are no permissions required for making this API call.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsJobsService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsJobsTestIamPermissionsCall {
	c := &ProjectsLocationsJobsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsJobsTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsJobsTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsJobsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsJobsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.jobs.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsJobsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsDeleteCall struct {
	s          *APIService
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsOperationsService) Delete(name string) *ProjectsLocationsOperationsDeleteCall {
	c := &ProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *APIService
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *APIService
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: To query for all of the operations for a project.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": A filter for matching the
// completed or in-progress operations. The supported formats of *filter* are:
// To query for only completed operations: done:true To query for only ongoing
// operations: done:false Must be empty to query for all of the latest
// operations for the given parent project.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// records that should be returned. Requested page size cannot exceed 100. If
// not set or set to less than or equal to 0, the default page size is 100. .
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token identifying which
// result to start with, which is returned by a previous list call.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// When set to `true`, operations that are reachable are returned as normal,
// and those that are unreachable are returned in the
// ListOperationsResponse.unreachable field. This can only be `true` when
// reading across collections. For example, when `parent` is set to
// "projects/example/locations/-". This field is not supported by default and
// will result in an `UNIMPLEMENTED` error if set unless explicitly documented
// otherwise in service or product specific documentation.
func (c *ProjectsLocationsOperationsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsOperationsWaitCall struct {
	s                                     *APIService
	name                                  string
	googlelongrunningwaitoperationrequest *GoogleLongrunningWaitOperationRequest
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Wait: Waits until the specified long-running operation is done or reaches at
// most a specified timeout, returning the latest state. If the operation is
// already done, the latest state is immediately returned. If the timeout
// specified is greater than the default HTTP/RPC timeout, the HTTP/RPC timeout
// is used. If the server does not support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Note that this method is on a best-effort
// basis. It may return the latest state before the specified timeout
// (including immediately), meaning even an immediate response is no guarantee
// that the operation is done.
//
// - name: The name of the operation resource to wait on.
func (r *ProjectsLocationsOperationsService) Wait(name string, googlelongrunningwaitoperationrequest *GoogleLongrunningWaitOperationRequest) *ProjectsLocationsOperationsWaitCall {
	c := &ProjectsLocationsOperationsWaitCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlelongrunningwaitoperationrequest = googlelongrunningwaitoperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsWaitCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsWaitCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsWaitCall) Context(ctx context.Context) *ProjectsLocationsOperationsWaitCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsWaitCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsWaitCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlelongrunningwaitoperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}:wait")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.operations.wait", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.operations.wait" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsWaitCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.operations.wait", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRevisionsDeleteCall struct {
	s          *APIService
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Delete a revision.
//
//   - name: The name of the revision to delete. For Cloud Run (fully managed),
//     replace {namespace} with the project ID or number. It takes the form
//     namespaces/{namespace}. For example: namespaces/PROJECT_ID.
func (r *ProjectsLocationsRevisionsService) Delete(name string) *ProjectsLocationsRevisionsDeleteCall {
	c := &ProjectsLocationsRevisionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ApiVersion sets the optional parameter "apiVersion": Cloud Run currently
// ignores this parameter.
func (c *ProjectsLocationsRevisionsDeleteCall) ApiVersion(apiVersion string) *ProjectsLocationsRevisionsDeleteCall {
	c.urlParams_.Set("apiVersion", apiVersion)
	return c
}

// DryRun sets the optional parameter "dryRun": Indicates that the server
// should validate the request and populate default values without persisting
// the request. Supported values: `all`
func (c *ProjectsLocationsRevisionsDeleteCall) DryRun(dryRun string) *ProjectsLocationsRevisionsDeleteCall {
	c.urlParams_.Set("dryRun", dryRun)
	return c
}

// Kind sets the optional parameter "kind": Cloud Run currently ignores this
// parameter.
func (c *ProjectsLocationsRevisionsDeleteCall) Kind(kind string) *ProjectsLocationsRevisionsDeleteCall {
	c.urlParams_.Set("kind", kind)
	return c
}

// PropagationPolicy sets the optional parameter "propagationPolicy": Specifies
// the propagation policy of delete. Cloud Run currently ignores this setting,
// and deletes in the background.
func (c *ProjectsLocationsRevisionsDeleteCall) PropagationPolicy(propagationPolicy string) *ProjectsLocationsRevisionsDeleteCall {
	c.urlParams_.Set("propagationPolicy", propagationPolicy)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRevisionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsRevisionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRevisionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsRevisionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRevisionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRevisionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.revisions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.revisions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Status.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRevisionsDeleteCall) Do(opts ...googleapi.CallOption) (*Status, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Status{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.revisions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRevisionsGetCall struct {
	s            *APIService
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get information about a revision.
//
//   - name: The name of the revision to retrieve. For Cloud Run (fully managed),
//     replace {namespace} with the project ID or number. It takes the form
//     namespaces/{namespace}. For example: namespaces/PROJECT_ID.
func (r *ProjectsLocationsRevisionsService) Get(name string) *ProjectsLocationsRevisionsGetCall {
	c := &ProjectsLocationsRevisionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRevisionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsRevisionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRevisionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsRevisionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRevisionsGetCall) Context(ctx context.Context) *ProjectsLocationsRevisionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRevisionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRevisionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.revisions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.revisions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Revision.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRevisionsGetCall) Do(opts ...googleapi.CallOption) (*Revision, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Revision{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.revisions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRevisionsListCall struct {
	s            *APIService
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List revisions. Results are sorted by creation time, descending.
//
//   - parent: The namespace from which the revisions should be listed. For Cloud
//     Run (fully managed), replace {namespace} with the project ID or number. It
//     takes the form namespaces/{namespace}. For example: namespaces/PROJECT_ID.
func (r *ProjectsLocationsRevisionsService) List(parent string) *ProjectsLocationsRevisionsListCall {
	c := &ProjectsLocationsRevisionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Continue sets the optional parameter "continue": Encoded string to continue
// paging.
func (c *ProjectsLocationsRevisionsListCall) Continue(continue_ string) *ProjectsLocationsRevisionsListCall {
	c.urlParams_.Set("continue", continue_)
	return c
}

// FieldSelector sets the optional parameter "fieldSelector": Allows to filter
// resources based on a specific value for a field name. Send this in a query
// string format. i.e. 'metadata.name%3Dlorem'. Not currently used by Cloud
// Run.
func (c *ProjectsLocationsRevisionsListCall) FieldSelector(fieldSelector string) *ProjectsLocationsRevisionsListCall {
	c.urlParams_.Set("fieldSelector", fieldSelector)
	return c
}

// IncludeUninitialized sets the optional parameter "includeUninitialized": Not
// currently used by Cloud Run.
func (c *ProjectsLocationsRevisionsListCall) IncludeUninitialized(includeUninitialized bool) *ProjectsLocationsRevisionsListCall {
	c.urlParams_.Set("includeUninitialized", fmt.Sprint(includeUninitialized))
	return c
}

// LabelSelector sets the optional parameter "labelSelector": Allows to filter
// resources based on a label. Supported operations are =, !=, exists, in, and
// notIn.
func (c *ProjectsLocationsRevisionsListCall) LabelSelector(labelSelector string) *ProjectsLocationsRevisionsListCall {
	c.urlParams_.Set("labelSelector", labelSelector)
	return c
}

// Limit sets the optional parameter "limit": The maximum number of records
// that should be returned.
func (c *ProjectsLocationsRevisionsListCall) Limit(limit int64) *ProjectsLocationsRevisionsListCall {
	c.urlParams_.Set("limit", fmt.Sprint(limit))
	return c
}

// ResourceVersion sets the optional parameter "resourceVersion": The baseline
// resource version from which the list or watch operation should start. Not
// currently used by Cloud Run.
func (c *ProjectsLocationsRevisionsListCall) ResourceVersion(resourceVersion string) *ProjectsLocationsRevisionsListCall {
	c.urlParams_.Set("resourceVersion", resourceVersion)
	return c
}

// Watch sets the optional parameter "watch": Flag that indicates that the
// client expects to watch this resource as well. Not currently used by Cloud
// Run.
func (c *ProjectsLocationsRevisionsListCall) Watch(watch bool) *ProjectsLocationsRevisionsListCall {
	c.urlParams_.Set("watch", fmt.Sprint(watch))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRevisionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsRevisionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRevisionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsRevisionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRevisionsListCall) Context(ctx context.Context) *ProjectsLocationsRevisionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRevisionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRevisionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/revisions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.revisions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.revisions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListRevisionsResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsRevisionsListCall) Do(opts ...googleapi.CallOption) (*ListRevisionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListRevisionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.revisions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRoutesGetCall struct {
	s            *APIService
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Get information about a route.
//
//   - name: The name of the route to retrieve. For Cloud Run (fully managed),
//     replace {namespace} with the project ID or number. It takes the form
//     namespaces/{namespace}. For example: namespaces/PROJECT_ID.
func (r *ProjectsLocationsRoutesService) Get(name string) *ProjectsLocationsRoutesGetCall {
	c := &ProjectsLocationsRoutesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRoutesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsRoutesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRoutesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsRoutesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRoutesGetCall) Context(ctx context.Context) *ProjectsLocationsRoutesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRoutesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRoutesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.routes.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.routes.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Route.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsRoutesGetCall) Do(opts ...googleapi.CallOption) (*Route, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Route{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.routes.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsRoutesListCall struct {
	s            *APIService
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: List routes. Results are sorted by creation time, descending.
//
//   - parent: The namespace from which the routes should be listed. For Cloud
//     Run (fully managed), replace {namespace} with the project ID or number. It
//     takes the form namespaces/{namespace}. For example: namespaces/PROJECT_ID.
func (r *ProjectsLocationsRoutesService) List(parent string) *ProjectsLocationsRoutesListCall {
	c := &ProjectsLocationsRoutesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Continue sets the optional parameter "continue": Encoded string to continue
// paging.
func (c *ProjectsLocationsRoutesListCall) Continue(continue_ string) *ProjectsLocationsRoutesListCall {
	c.urlParams_.Set("continue", continue_)
	return c
}

// FieldSelector sets the optional parameter "fieldSelector": Allows to filter
// resources based on a specific value for a field name. Send this in a query
// string format. i.e. 'metadata.name%3Dlorem'. Not currently used by Cloud
// Run.
func (c *ProjectsLocationsRoutesListCall) FieldSelector(fieldSelector string) *ProjectsLocationsRoutesListCall {
	c.urlParams_.Set("fieldSelector", fieldSelector)
	return c
}

// IncludeUninitialized sets the optional parameter "includeUninitialized": Not
// currently used by Cloud Run.
func (c *ProjectsLocationsRoutesListCall) IncludeUninitialized(includeUninitialized bool) *ProjectsLocationsRoutesListCall {
	c.urlParams_.Set("includeUninitialized", fmt.Sprint(includeUninitialized))
	return c
}

// LabelSelector sets the optional parameter "labelSelector": Allows to filter
// resources based on a label. Supported operations are =, !=, exists, in, and
// notIn.
func (c *ProjectsLocationsRoutesListCall) LabelSelector(labelSelector string) *ProjectsLocationsRoutesListCall {
	c.urlParams_.Set("labelSelector", labelSelector)
	return c
}

// Limit sets the optional parameter "limit": The maximum number of records
// that should be returned.
func (c *ProjectsLocationsRoutesListCall) Limit(limit int64) *ProjectsLocationsRoutesListCall {
	c.urlParams_.Set("limit", fmt.Sprint(limit))
	return c
}

// ResourceVersion sets the optional parameter "resourceVersion": The baseline
// resource version from which the list or watch operation should start. Not
// currently used by Cloud Run.
func (c *ProjectsLocationsRoutesListCall) ResourceVersion(resourceVersion string) *ProjectsLocationsRoutesListCall {
	c.urlParams_.Set("resourceVersion", resourceVersion)
	return c
}

// Watch sets the optional parameter "watch": Flag that indicates that the
// client expects to watch this resource as well. Not currently used by Cloud
// Run.
func (c *ProjectsLocationsRoutesListCall) Watch(watch bool) *ProjectsLocationsRoutesListCall {
	c.urlParams_.Set("watch", fmt.Sprint(watch))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsRoutesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsRoutesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsRoutesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsRoutesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsRoutesListCall) Context(ctx context.Context) *ProjectsLocationsRoutesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsRoutesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsRoutesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/routes")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.routes.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.routes.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListRoutesResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsRoutesListCall) Do(opts ...googleapi.CallOption) (*ListRoutesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListRoutesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.routes.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServicesCreateCall struct {
	s          *APIService
	parent     string
	service    *Service
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Creates a new Service. Service creation will trigger a new
// deployment. Use GetService, and check service.status to determine if the
// Service is ready.
//
//   - parent: The resource's parent. In Cloud Run, it may be one of the
//     following: * `{project_id_or_number}` *
//     `namespaces/{project_id_or_number}` *
//     `namespaces/{project_id_or_number}/services` *
//     `projects/{project_id_or_number}/locations/{region}` *
//     `projects/{project_id_or_number}/regions/{region}`.
func (r *ProjectsLocationsServicesService) Create(parent string, service *Service) *ProjectsLocationsServicesCreateCall {
	c := &ProjectsLocationsServicesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.service = service
	return c
}

// DryRun sets the optional parameter "dryRun": Indicates that the server
// should validate the request and populate default values without persisting
// the request. Supported values: `all`
func (c *ProjectsLocationsServicesCreateCall) DryRun(dryRun string) *ProjectsLocationsServicesCreateCall {
	c.urlParams_.Set("dryRun", dryRun)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesCreateCall) Context(ctx context.Context) *ProjectsLocationsServicesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.service)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/services")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.services.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.services.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *Service.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesCreateCall) Do(opts ...googleapi.CallOption) (*Service, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Service{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.services.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServicesDeleteCall struct {
	s          *APIService
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the provided service. This will cause the Service to stop
// serving traffic and will delete all associated Revisions.
//
//   - name: The fully qualified name of the service to delete. It can be any of
//     the following forms: *
//     `namespaces/{project_id_or_number}/services/{service_name}` (only when the
//     `endpoint` is regional) *
//     `projects/{project_id_or_number}/locations/{region}/services/{service_name}
//     ` *
//     `projects/{project_id_or_number}/regions/{region}/services/{service_name}`.
func (r *ProjectsLocationsServicesService) Delete(name string) *ProjectsLocationsServicesDeleteCall {
	c := &ProjectsLocationsServicesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// ApiVersion sets the optional parameter "apiVersion": Not supported, and
// ignored by Cloud Run.
func (c *ProjectsLocationsServicesDeleteCall) ApiVersion(apiVersion string) *ProjectsLocationsServicesDeleteCall {
	c.urlParams_.Set("apiVersion", apiVersion)
	return c
}

// DryRun sets the optional parameter "dryRun": Indicates that the server
// should validate the request and populate default values without persisting
// the request. Supported values: `all`
func (c *ProjectsLocationsServicesDeleteCall) DryRun(dryRun string) *ProjectsLocationsServicesDeleteCall {
	c.urlParams_.Set("dryRun", dryRun)
	return c
}

// Kind sets the optional parameter "kind": Not supported, and ignored by Cloud
// Run.
func (c *ProjectsLocationsServicesDeleteCall) Kind(kind string) *ProjectsLocationsServicesDeleteCall {
	c.urlParams_.Set("kind", kind)
	return c
}

// PropagationPolicy sets the optional parameter "propagationPolicy": Not
// supported, and ignored by Cloud Run.
func (c *ProjectsLocationsServicesDeleteCall) PropagationPolicy(propagationPolicy string) *ProjectsLocationsServicesDeleteCall {
	c.urlParams_.Set("propagationPolicy", propagationPolicy)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesDeleteCall) Context(ctx context.Context) *ProjectsLocationsServicesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.services.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.services.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Status.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesDeleteCall) Do(opts ...googleapi.CallOption) (*Status, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Status{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.services.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServicesGetCall struct {
	s            *APIService
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a service.
//
//   - name: The fully qualified name of the service to retrieve. It can be any
//     of the following forms: *
//     `namespaces/{project_id_or_number}/services/{service_name}` (only when the
//     `endpoint` is regional) *
//     `projects/{project_id_or_number}/locations/{region}/services/{service_name}
//     ` *
//     `projects/{project_id_or_number}/regions/{region}/services/{service_name}`.
func (r *ProjectsLocationsServicesService) Get(name string) *ProjectsLocationsServicesGetCall {
	c := &ProjectsLocationsServicesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsServicesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsServicesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesGetCall) Context(ctx context.Context) *ProjectsLocationsServicesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.services.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.services.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Service.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesGetCall) Do(opts ...googleapi.CallOption) (*Service, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Service{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.services.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServicesGetIamPolicyCall struct {
	s            *APIService
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the IAM Access Control policy currently in effect for the
// given Cloud Run service. This result does not include any inherited
// policies.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsServicesService) GetIamPolicy(resource string) *ProjectsLocationsServicesGetIamPolicyCall {
	c := &ProjectsLocationsServicesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsServicesGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsServicesGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsServicesGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsServicesGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsServicesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.services.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.services.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.services.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServicesListCall struct {
	s            *APIService
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists services for the given project and region. Results are sorted by
// creation time, descending.
//
//   - parent: The parent from where the resources should be listed. In Cloud
//     Run, it may be one of the following: * `{project_id_or_number}` *
//     `namespaces/{project_id_or_number}` *
//     `namespaces/{project_id_or_number}/services` *
//     `projects/{project_id_or_number}/locations/{region}` *
//     `projects/{project_id_or_number}/regions/{region}`.
func (r *ProjectsLocationsServicesService) List(parent string) *ProjectsLocationsServicesListCall {
	c := &ProjectsLocationsServicesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Continue sets the optional parameter "continue": Encoded string to continue
// paging.
func (c *ProjectsLocationsServicesListCall) Continue(continue_ string) *ProjectsLocationsServicesListCall {
	c.urlParams_.Set("continue", continue_)
	return c
}

// FieldSelector sets the optional parameter "fieldSelector": Not supported,
// and ignored by Cloud Run.
func (c *ProjectsLocationsServicesListCall) FieldSelector(fieldSelector string) *ProjectsLocationsServicesListCall {
	c.urlParams_.Set("fieldSelector", fieldSelector)
	return c
}

// IncludeUninitialized sets the optional parameter "includeUninitialized": Not
// supported, and ignored by Cloud Run.
func (c *ProjectsLocationsServicesListCall) IncludeUninitialized(includeUninitialized bool) *ProjectsLocationsServicesListCall {
	c.urlParams_.Set("includeUninitialized", fmt.Sprint(includeUninitialized))
	return c
}

// LabelSelector sets the optional parameter "labelSelector": Allows to filter
// resources based on a label. Supported operations are =, !=, exists, in, and
// notIn.
func (c *ProjectsLocationsServicesListCall) LabelSelector(labelSelector string) *ProjectsLocationsServicesListCall {
	c.urlParams_.Set("labelSelector", labelSelector)
	return c
}

// Limit sets the optional parameter "limit": The maximum number of records
// that should be returned.
func (c *ProjectsLocationsServicesListCall) Limit(limit int64) *ProjectsLocationsServicesListCall {
	c.urlParams_.Set("limit", fmt.Sprint(limit))
	return c
}

// ResourceVersion sets the optional parameter "resourceVersion": Not
// supported, and ignored by Cloud Run.
func (c *ProjectsLocationsServicesListCall) ResourceVersion(resourceVersion string) *ProjectsLocationsServicesListCall {
	c.urlParams_.Set("resourceVersion", resourceVersion)
	return c
}

// Watch sets the optional parameter "watch": Not supported, and ignored by
// Cloud Run.
func (c *ProjectsLocationsServicesListCall) Watch(watch bool) *ProjectsLocationsServicesListCall {
	c.urlParams_.Set("watch", fmt.Sprint(watch))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsServicesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsServicesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesListCall) Context(ctx context.Context) *ProjectsLocationsServicesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+parent}/services")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.services.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.services.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListServicesResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsServicesListCall) Do(opts ...googleapi.CallOption) (*ListServicesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListServicesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.services.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServicesReplaceServiceCall struct {
	s          *APIService
	name       string
	service    *Service
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// ReplaceService: Replaces a service. Only the spec and metadata labels and
// annotations are modifiable. After the Update request, Cloud Run will work to
// make the 'status' match the requested 'spec'. May provide
// metadata.resourceVersion to enforce update from last read for optimistic
// concurrency control.
//
//   - name: The fully qualified name of the service to replace. It can be any of
//     the following forms: *
//     `namespaces/{project_id_or_number}/services/{service_name}` (only when the
//     `endpoint` is regional) *
//     `projects/{project_id_or_number}/locations/{region}/services/{service_name}
//     ` *
//     `projects/{project_id_or_number}/regions/{region}/services/{service_name}`.
func (r *ProjectsLocationsServicesService) ReplaceService(name string, service *Service) *ProjectsLocationsServicesReplaceServiceCall {
	c := &ProjectsLocationsServicesReplaceServiceCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.service = service
	return c
}

// DryRun sets the optional parameter "dryRun": Indicates that the server
// should validate the request and populate default values without persisting
// the request. Supported values: `all`
func (c *ProjectsLocationsServicesReplaceServiceCall) DryRun(dryRun string) *ProjectsLocationsServicesReplaceServiceCall {
	c.urlParams_.Set("dryRun", dryRun)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesReplaceServiceCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesReplaceServiceCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesReplaceServiceCall) Context(ctx context.Context) *ProjectsLocationsServicesReplaceServiceCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesReplaceServiceCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesReplaceServiceCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.service)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.services.replaceService", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.services.replaceService" call.
// Any non-2xx status code is an error. Response headers are in either
// *Service.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesReplaceServiceCall) Do(opts ...googleapi.CallOption) (*Service, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Service{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.services.replaceService", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServicesSetIamPolicyCall struct {
	s                   *APIService
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the IAM Access control policy for the specified Service.
// Overwrites any existing policy.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsServicesService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsServicesSetIamPolicyCall {
	c := &ProjectsLocationsServicesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsServicesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.services.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.services.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.services.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServicesTestIamPermissionsCall struct {
	s                         *APIService
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// Project. There are no permissions required for making this API call.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsServicesService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsServicesTestIamPermissionsCall {
	c := &ProjectsLocationsServicesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsServicesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.services.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.services.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.services.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWorkerpoolsGetIamPolicyCall struct {
	s            *APIService
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Get the IAM Access Control policy currently in effect for the
// given worker pool. This result does not include any inherited policies.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsWorkerpoolsService) GetIamPolicy(resource string) *ProjectsLocationsWorkerpoolsGetIamPolicyCall {
	c := &ProjectsLocationsWorkerpoolsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsWorkerpoolsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsWorkerpoolsGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkerpoolsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkerpoolsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsWorkerpoolsGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsWorkerpoolsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkerpoolsGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsWorkerpoolsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkerpoolsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkerpoolsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.workerpools.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.workerpools.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkerpoolsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.workerpools.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWorkerpoolsSetIamPolicyCall struct {
	s                   *APIService
	resource            string
	setiampolicyrequest *SetIamPolicyRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// SetIamPolicy: Sets the IAM Access control policy for the specified worker
// pool. Overwrites any existing policy.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsWorkerpoolsService) SetIamPolicy(resource string, setiampolicyrequest *SetIamPolicyRequest) *ProjectsLocationsWorkerpoolsSetIamPolicyCall {
	c := &ProjectsLocationsWorkerpoolsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.setiampolicyrequest = setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkerpoolsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkerpoolsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkerpoolsSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsWorkerpoolsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkerpoolsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkerpoolsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.workerpools.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.workerpools.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *Policy.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkerpoolsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.workerpools.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWorkerpoolsTestIamPermissionsCall struct {
	s                         *APIService
	resource                  string
	testiampermissionsrequest *TestIamPermissionsRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// worker pool. There are no permissions required for making this API call.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsWorkerpoolsService) TestIamPermissions(resource string, testiampermissionsrequest *TestIamPermissionsRequest) *ProjectsLocationsWorkerpoolsTestIamPermissionsCall {
	c := &ProjectsLocationsWorkerpoolsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.testiampermissionsrequest = testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkerpoolsTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkerpoolsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkerpoolsTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsWorkerpoolsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkerpoolsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkerpoolsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v1/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.workerpools.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.workerpools.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *TestIamPermissionsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkerpoolsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.workerpools.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
