// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package run provides access to the Cloud Run Admin API.
//
// For product documentation, see: https://cloud.google.com/run/
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/run/v2"
//	...
//	ctx := context.Background()
//	runService, err := run.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	runService, err := run.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	runService, err := run.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package run // import "google.golang.org/api/run/v2"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "run:v2"
const apiName = "run"
const apiVersion = "v2"
const basePath = "https://run.googleapis.com/"
const basePathTemplate = "https://run.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://run.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.Projects = NewProjectsService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Projects *ProjectsService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Locations = NewProjectsLocationsService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Locations *ProjectsLocationsService
}

func NewProjectsLocationsService(s *Service) *ProjectsLocationsService {
	rs := &ProjectsLocationsService{s: s}
	rs.Builds = NewProjectsLocationsBuildsService(s)
	rs.Jobs = NewProjectsLocationsJobsService(s)
	rs.Operations = NewProjectsLocationsOperationsService(s)
	rs.Services = NewProjectsLocationsServicesService(s)
	rs.WorkerPools = NewProjectsLocationsWorkerPoolsService(s)
	return rs
}

type ProjectsLocationsService struct {
	s *Service

	Builds *ProjectsLocationsBuildsService

	Jobs *ProjectsLocationsJobsService

	Operations *ProjectsLocationsOperationsService

	Services *ProjectsLocationsServicesService

	WorkerPools *ProjectsLocationsWorkerPoolsService
}

func NewProjectsLocationsBuildsService(s *Service) *ProjectsLocationsBuildsService {
	rs := &ProjectsLocationsBuildsService{s: s}
	return rs
}

type ProjectsLocationsBuildsService struct {
	s *Service
}

func NewProjectsLocationsJobsService(s *Service) *ProjectsLocationsJobsService {
	rs := &ProjectsLocationsJobsService{s: s}
	rs.Executions = NewProjectsLocationsJobsExecutionsService(s)
	return rs
}

type ProjectsLocationsJobsService struct {
	s *Service

	Executions *ProjectsLocationsJobsExecutionsService
}

func NewProjectsLocationsJobsExecutionsService(s *Service) *ProjectsLocationsJobsExecutionsService {
	rs := &ProjectsLocationsJobsExecutionsService{s: s}
	rs.Tasks = NewProjectsLocationsJobsExecutionsTasksService(s)
	return rs
}

type ProjectsLocationsJobsExecutionsService struct {
	s *Service

	Tasks *ProjectsLocationsJobsExecutionsTasksService
}

func NewProjectsLocationsJobsExecutionsTasksService(s *Service) *ProjectsLocationsJobsExecutionsTasksService {
	rs := &ProjectsLocationsJobsExecutionsTasksService{s: s}
	return rs
}

type ProjectsLocationsJobsExecutionsTasksService struct {
	s *Service
}

func NewProjectsLocationsOperationsService(s *Service) *ProjectsLocationsOperationsService {
	rs := &ProjectsLocationsOperationsService{s: s}
	return rs
}

type ProjectsLocationsOperationsService struct {
	s *Service
}

func NewProjectsLocationsServicesService(s *Service) *ProjectsLocationsServicesService {
	rs := &ProjectsLocationsServicesService{s: s}
	rs.Revisions = NewProjectsLocationsServicesRevisionsService(s)
	return rs
}

type ProjectsLocationsServicesService struct {
	s *Service

	Revisions *ProjectsLocationsServicesRevisionsService
}

func NewProjectsLocationsServicesRevisionsService(s *Service) *ProjectsLocationsServicesRevisionsService {
	rs := &ProjectsLocationsServicesRevisionsService{s: s}
	return rs
}

type ProjectsLocationsServicesRevisionsService struct {
	s *Service
}

func NewProjectsLocationsWorkerPoolsService(s *Service) *ProjectsLocationsWorkerPoolsService {
	rs := &ProjectsLocationsWorkerPoolsService{s: s}
	rs.Revisions = NewProjectsLocationsWorkerPoolsRevisionsService(s)
	return rs
}

type ProjectsLocationsWorkerPoolsService struct {
	s *Service

	Revisions *ProjectsLocationsWorkerPoolsRevisionsService
}

func NewProjectsLocationsWorkerPoolsRevisionsService(s *Service) *ProjectsLocationsWorkerPoolsRevisionsService {
	rs := &ProjectsLocationsWorkerPoolsRevisionsService{s: s}
	return rs
}

type ProjectsLocationsWorkerPoolsRevisionsService struct {
	s *Service
}

// GoogleCloudRunV2BinaryAuthorization: Settings for Binary Authorization
// feature.
type GoogleCloudRunV2BinaryAuthorization struct {
	// BreakglassJustification: Optional. If present, indicates to use Breakglass
	// using this justification. If use_default is False, then it must be empty.
	// For more information on breakglass, see
	// https://cloud.google.com/binary-authorization/docs/using-breakglass
	BreakglassJustification string `json:"breakglassJustification,omitempty"`
	// Policy: Optional. The path to a binary authorization policy. Format:
	// `projects/{project}/platforms/cloudRun/{policy-name}`
	Policy string `json:"policy,omitempty"`
	// UseDefault: Optional. If True, indicates to use the default project's binary
	// authorization policy. If False, binary authorization will be disabled.
	UseDefault bool `json:"useDefault,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BreakglassJustification") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BreakglassJustification") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2BinaryAuthorization) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2BinaryAuthorization
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2BuildConfig: Describes the Build step of the function that
// builds a container from the given source.
type GoogleCloudRunV2BuildConfig struct {
	// BaseImage: Optional. The base image used to build the function.
	BaseImage string `json:"baseImage,omitempty"`
	// EnableAutomaticUpdates: Optional. Sets whether the function will receive
	// automatic base image updates.
	EnableAutomaticUpdates bool `json:"enableAutomaticUpdates,omitempty"`
	// EnvironmentVariables: Optional. User-provided build-time environment
	// variables for the function
	EnvironmentVariables map[string]string `json:"environmentVariables,omitempty"`
	// FunctionTarget: Optional. The name of the function (as defined in source
	// code) that will be executed. Defaults to the resource name suffix, if not
	// specified. For backward compatibility, if function with given name is not
	// found, then the system will try to use function named "function".
	FunctionTarget string `json:"functionTarget,omitempty"`
	// ImageUri: Optional. Artifact Registry URI to store the built image.
	ImageUri string `json:"imageUri,omitempty"`
	// Name: Output only. The Cloud Build name of the latest successful deployment
	// of the function.
	Name string `json:"name,omitempty"`
	// ServiceAccount: Optional. Service account to be used for building the
	// container. The format of this field is
	// `projects/{projectId}/serviceAccounts/{serviceAccountEmail}`.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// SourceLocation: The Cloud Storage bucket URI where the function source code
	// is located.
	SourceLocation string `json:"sourceLocation,omitempty"`
	// WorkerPool: Optional. Name of the Cloud Build Custom Worker Pool that should
	// be used to build the Cloud Run function. The format of this field is
	// `projects/{project}/locations/{region}/workerPools/{workerPool}` where
	// `{project}` and `{region}` are the project id and region respectively where
	// the worker pool is defined and `{workerPool}` is the short name of the
	// worker pool.
	WorkerPool string `json:"workerPool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseImage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseImage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2BuildConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2BuildConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2BuildInfo: Build information of the image.
type GoogleCloudRunV2BuildInfo struct {
	// FunctionTarget: Output only. Entry point of the function when the image is a
	// Cloud Run function.
	FunctionTarget string `json:"functionTarget,omitempty"`
	// SourceLocation: Output only. Source code location of the image.
	SourceLocation string `json:"sourceLocation,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FunctionTarget") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FunctionTarget") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2BuildInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2BuildInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2BuildpacksBuild: Build the source using Buildpacks.
type GoogleCloudRunV2BuildpacksBuild struct {
	// BaseImage: Optional. The base image to use for the build.
	BaseImage string `json:"baseImage,omitempty"`
	// CacheImageUri: Optional. cache_image_uri is the GCR/AR URL where the cache
	// image will be stored. cache_image_uri is optional and omitting it will
	// disable caching. This URL must be stable across builds. It is used to derive
	// a build-specific temporary URL by substituting the tag with the build ID.
	// The build will clean up the temporary image on a best-effort basis.
	CacheImageUri string `json:"cacheImageUri,omitempty"`
	// EnableAutomaticUpdates: Optional. Whether or not the application container
	// will be enrolled in automatic base image updates. When true, the application
	// will be built on a scratch base image, so the base layers can be appended at
	// run time.
	EnableAutomaticUpdates bool `json:"enableAutomaticUpdates,omitempty"`
	// EnvironmentVariables: Optional. User-provided build-time environment
	// variables.
	EnvironmentVariables map[string]string `json:"environmentVariables,omitempty"`
	// FunctionTarget: Optional. Name of the function target if the source is a
	// function source. Required for function builds.
	FunctionTarget string `json:"functionTarget,omitempty"`
	// ProjectDescriptor: Optional. project_descriptor stores the path to the
	// project descriptor file. When empty, it means that there is no project
	// descriptor file in the source.
	ProjectDescriptor string `json:"projectDescriptor,omitempty"`
	// Runtime: The runtime name, e.g. 'go113'. Leave blank for generic builds.
	Runtime string `json:"runtime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BaseImage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseImage") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2BuildpacksBuild) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2BuildpacksBuild
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2CancelExecutionRequest: Request message for deleting an
// Execution.
type GoogleCloudRunV2CancelExecutionRequest struct {
	// Etag: A system-generated fingerprint for this version of the resource. This
	// may be used to detect modification conflict during updates.
	Etag string `json:"etag,omitempty"`
	// ValidateOnly: Indicates that the request should be validated without
	// actually cancelling any resources.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2CancelExecutionRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2CancelExecutionRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2CloudSqlInstance: Represents a set of Cloud SQL instances.
// Each one will be available under /cloudsql/[instance]. Visit
// https://cloud.google.com/sql/docs/mysql/connect-run for more information on
// how to connect Cloud SQL and Cloud Run.
type GoogleCloudRunV2CloudSqlInstance struct {
	// Instances: The Cloud SQL instance connection names, as can be found in
	// https://console.cloud.google.com/sql/instances. Visit
	// https://cloud.google.com/sql/docs/mysql/connect-run for more information on
	// how to connect Cloud SQL and Cloud Run. Format:
	// {project}:{location}:{instance}
	Instances []string `json:"instances,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Instances") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Instances") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2CloudSqlInstance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2CloudSqlInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2CloudStorageSource: Cloud Storage source.
type GoogleCloudRunV2CloudStorageSource struct {
	// Bucket: Required. The Cloud Storage bucket name.
	Bucket string `json:"bucket,omitempty"`
	// Generation: Optional. The Cloud Storage object generation.
	Generation int64 `json:"generation,omitempty,string"`
	// Object: Required. The Cloud Storage object name.
	Object string `json:"object,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bucket") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bucket") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2CloudStorageSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2CloudStorageSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2Condition: Defines a status condition for a resource.
type GoogleCloudRunV2Condition struct {
	// ExecutionReason: Output only. A reason for the execution condition.
	//
	// Possible values:
	//   "EXECUTION_REASON_UNDEFINED" - Default value.
	//   "JOB_STATUS_SERVICE_POLLING_ERROR" - Internal system error getting
	// execution status. System will retry.
	//   "NON_ZERO_EXIT_CODE" - A task reached its retry limit and the last attempt
	// failed due to the user container exiting with a non-zero exit code.
	//   "CANCELLED" - The execution was cancelled by users.
	//   "CANCELLING" - The execution is in the process of being cancelled.
	//   "DELETED" - The execution was deleted.
	//   "DELAYED_START_PENDING" - A delayed execution is waiting for a start time.
	ExecutionReason string `json:"executionReason,omitempty"`
	// LastTransitionTime: Last time the condition transitioned from one status to
	// another.
	LastTransitionTime string `json:"lastTransitionTime,omitempty"`
	// Message: Human readable message indicating details about the current status.
	Message string `json:"message,omitempty"`
	// Reason: Output only. A common (service-level) reason for this condition.
	//
	// Possible values:
	//   "COMMON_REASON_UNDEFINED" - Default value.
	//   "UNKNOWN" - Reason unknown. Further details will be in message.
	//   "REVISION_FAILED" - Revision creation process failed.
	//   "PROGRESS_DEADLINE_EXCEEDED" - Timed out waiting for completion.
	//   "CONTAINER_MISSING" - The container image path is incorrect.
	//   "CONTAINER_PERMISSION_DENIED" - Insufficient permissions on the container
	// image.
	//   "CONTAINER_IMAGE_UNAUTHORIZED" - Container image is not authorized by
	// policy.
	//   "CONTAINER_IMAGE_AUTHORIZATION_CHECK_FAILED" - Container image policy
	// authorization check failed.
	//   "ENCRYPTION_KEY_PERMISSION_DENIED" - Insufficient permissions on
	// encryption key.
	//   "ENCRYPTION_KEY_CHECK_FAILED" - Permission check on encryption key failed.
	//   "SECRETS_ACCESS_CHECK_FAILED" - At least one Access check on secrets
	// failed.
	//   "WAITING_FOR_OPERATION" - Waiting for operation to complete.
	//   "IMMEDIATE_RETRY" - System will retry immediately.
	//   "POSTPONED_RETRY" - System will retry later; current attempt failed.
	//   "INTERNAL" - An internal error occurred. Further information may be in the
	// message.
	//   "VPC_NETWORK_NOT_FOUND" - User-provided VPC network was not found.
	Reason string `json:"reason,omitempty"`
	// RevisionReason: Output only. A reason for the revision condition.
	//
	// Possible values:
	//   "REVISION_REASON_UNDEFINED" - Default value.
	//   "PENDING" - Revision in Pending state.
	//   "RESERVE" - Revision is in Reserve state.
	//   "RETIRED" - Revision is Retired.
	//   "RETIRING" - Revision is being retired.
	//   "RECREATING" - Revision is being recreated.
	//   "HEALTH_CHECK_CONTAINER_ERROR" - There was a health check error.
	//   "CUSTOMIZED_PATH_RESPONSE_PENDING" - Health check failed due to user error
	// from customized path of the container. System will retry.
	//   "MIN_INSTANCES_NOT_PROVISIONED" - A revision with min_instance_count > 0
	// was created and is reserved, but it was not configured to serve traffic, so
	// it's not live. This can also happen momentarily during traffic migration.
	//   "ACTIVE_REVISION_LIMIT_REACHED" - The maximum allowed number of active
	// revisions has been reached.
	//   "NO_DEPLOYMENT" - There was no deployment defined. This value is no longer
	// used, but Services created in older versions of the API might contain this
	// value.
	//   "HEALTH_CHECK_SKIPPED" - A revision's container has no port specified
	// since the revision is of a manually scaled service with 0 instance count
	//   "MIN_INSTANCES_WARMING" - A revision with min_instance_count > 0 was
	// created and is waiting for enough instances to begin a traffic migration.
	RevisionReason string `json:"revisionReason,omitempty"`
	// Severity: How to interpret failures of this condition, one of Error,
	// Warning, Info
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Unspecified severity
	//   "ERROR" - Error severity.
	//   "WARNING" - Warning severity.
	//   "INFO" - Info severity.
	Severity string `json:"severity,omitempty"`
	// State: State of the condition.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - The default value. This value is used if the state
	// is omitted.
	//   "CONDITION_PENDING" - Transient state: Reconciliation has not started yet.
	//   "CONDITION_RECONCILING" - Transient state: reconciliation is still in
	// progress.
	//   "CONDITION_FAILED" - Terminal state: Reconciliation did not succeed.
	//   "CONDITION_SUCCEEDED" - Terminal state: Reconciliation completed
	// successfully.
	State string `json:"state,omitempty"`
	// Type: type is used to communicate the status of the reconciliation process.
	// See also:
	// https://github.com/knative/serving/blob/main/docs/spec/errors.md#error-conditions-and-reporting
	// Types common to all resources include: * "Ready": True when the Resource is
	// ready.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExecutionReason") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExecutionReason") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2Condition) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2Condition
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2Container: A single application container. This specifies
// both the container to run, the command to run in the container and the
// arguments to supply to it. Note that additional arguments can be supplied by
// the system to the container at runtime.
type GoogleCloudRunV2Container struct {
	// Args: Arguments to the entrypoint. The docker image's CMD is used if this is
	// not provided.
	Args []string `json:"args,omitempty"`
	// BaseImageUri: Base image for this container. Only supported for services. If
	// set, it indicates that the service is enrolled into automatic base image
	// update.
	BaseImageUri string `json:"baseImageUri,omitempty"`
	// BuildInfo: Output only. The build info of the container image.
	BuildInfo *GoogleCloudRunV2BuildInfo `json:"buildInfo,omitempty"`
	// Command: Entrypoint array. Not executed within a shell. The docker image's
	// ENTRYPOINT is used if this is not provided.
	Command []string `json:"command,omitempty"`
	// DependsOn: Names of the containers that must start before this container.
	DependsOn []string `json:"dependsOn,omitempty"`
	// Env: List of environment variables to set in the container.
	Env []*GoogleCloudRunV2EnvVar `json:"env,omitempty"`
	// Image: Required. Name of the container image in Dockerhub, Google Artifact
	// Registry, or Google Container Registry. If the host is not provided,
	// Dockerhub is assumed.
	Image string `json:"image,omitempty"`
	// LivenessProbe: Periodic probe of container liveness. Container will be
	// restarted if the probe fails.
	LivenessProbe *GoogleCloudRunV2Probe `json:"livenessProbe,omitempty"`
	// Name: Name of the container specified as a DNS_LABEL (RFC 1123).
	Name string `json:"name,omitempty"`
	// Ports: List of ports to expose from the container. Only a single port can be
	// specified. The specified ports must be listening on all interfaces (0.0.0.0)
	// within the container to be accessible. If omitted, a port number will be
	// chosen and passed to the container through the PORT environment variable for
	// the container to listen on.
	Ports []*GoogleCloudRunV2ContainerPort `json:"ports,omitempty"`
	// Resources: Compute Resource requirements by this container.
	Resources *GoogleCloudRunV2ResourceRequirements `json:"resources,omitempty"`
	// SourceCode: Optional. Location of the source.
	SourceCode *GoogleCloudRunV2SourceCode `json:"sourceCode,omitempty"`
	// StartupProbe: Startup probe of application within the container. All other
	// probes are disabled if a startup probe is provided, until it succeeds.
	// Container will not be added to service endpoints if the probe fails.
	StartupProbe *GoogleCloudRunV2Probe `json:"startupProbe,omitempty"`
	// VolumeMounts: Volume to mount into the container's filesystem.
	VolumeMounts []*GoogleCloudRunV2VolumeMount `json:"volumeMounts,omitempty"`
	// WorkingDir: Container's working directory. If not specified, the container
	// runtime's default will be used, which might be configured in the container
	// image.
	WorkingDir string `json:"workingDir,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Args") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Args") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2Container) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2Container
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2ContainerOverride: Per-container override specification.
type GoogleCloudRunV2ContainerOverride struct {
	// Args: Optional. Arguments to the entrypoint. Will replace existing args for
	// override.
	Args []string `json:"args,omitempty"`
	// ClearArgs: Optional. True if the intention is to clear out existing args
	// list.
	ClearArgs bool `json:"clearArgs,omitempty"`
	// Env: List of environment variables to set in the container. Will be merged
	// with existing env for override.
	Env []*GoogleCloudRunV2EnvVar `json:"env,omitempty"`
	// Name: The name of the container specified as a DNS_LABEL.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Args") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Args") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2ContainerOverride) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2ContainerOverride
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2ContainerPort: ContainerPort represents a network port in a
// single container.
type GoogleCloudRunV2ContainerPort struct {
	// ContainerPort: Port number the container listens on. This must be a valid
	// TCP port number, 0 < container_port < 65536.
	ContainerPort int64 `json:"containerPort,omitempty"`
	// Name: If specified, used to specify which protocol to use. Allowed values
	// are "http1" and "h2c".
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContainerPort") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainerPort") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2ContainerPort) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2ContainerPort
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2DockerBuild: Build the source using Docker. This means the
// source has a Dockerfile.
type GoogleCloudRunV2DockerBuild struct {
}

// GoogleCloudRunV2EmptyDirVolumeSource: In memory (tmpfs) ephemeral storage.
// It is ephemeral in the sense that when the sandbox is taken down, the data
// is destroyed with it (it does not persist across sandbox runs).
type GoogleCloudRunV2EmptyDirVolumeSource struct {
	// Medium: The medium on which the data is stored. Acceptable values today is
	// only MEMORY or none. When none, the default will currently be backed by
	// memory but could change over time. +optional
	//
	// Possible values:
	//   "MEDIUM_UNSPECIFIED" - When not specified, falls back to the default
	// implementation which is currently in memory (this may change over time).
	//   "MEMORY" - Explicitly set the EmptyDir to be in memory. Uses tmpfs.
	Medium string `json:"medium,omitempty"`
	// SizeLimit: Limit on the storage usable by this EmptyDir volume. The size
	// limit is also applicable for memory medium. The maximum usage on memory
	// medium EmptyDir would be the minimum value between the SizeLimit specified
	// here and the sum of memory limits of all containers. The default is nil
	// which means that the limit is undefined. More info:
	// https://cloud.google.com/run/docs/configuring/in-memory-volumes#configure-volume.
	// Info in Kubernetes:
	// https://kubernetes.io/docs/concepts/storage/volumes/#emptydir
	SizeLimit string `json:"sizeLimit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Medium") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Medium") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2EmptyDirVolumeSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2EmptyDirVolumeSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2EnvVar: EnvVar represents an environment variable present in
// a Container.
type GoogleCloudRunV2EnvVar struct {
	// Name: Required. Name of the environment variable. Must not exceed 32768
	// characters.
	Name string `json:"name,omitempty"`
	// Value: Literal value of the environment variable. Defaults to "", and the
	// maximum length is 32768 bytes. Variable references are not supported in
	// Cloud Run.
	Value string `json:"value,omitempty"`
	// ValueSource: Source for the environment variable's value.
	ValueSource *GoogleCloudRunV2EnvVarSource `json:"valueSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2EnvVar) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2EnvVar
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2EnvVarSource: EnvVarSource represents a source for the value
// of an EnvVar.
type GoogleCloudRunV2EnvVarSource struct {
	// SecretKeyRef: Selects a secret and a specific version from Cloud Secret
	// Manager.
	SecretKeyRef *GoogleCloudRunV2SecretKeySelector `json:"secretKeyRef,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SecretKeyRef") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SecretKeyRef") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2EnvVarSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2EnvVarSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2Execution: Execution represents the configuration of a
// single execution. A execution an immutable resource that references a
// container image which is run to completion.
type GoogleCloudRunV2Execution struct {
	// Annotations: Output only. Unstructured key value map that may be set by
	// external tools to store and arbitrary metadata. They are not queryable and
	// should be preserved when modifying objects.
	Annotations map[string]string `json:"annotations,omitempty"`
	// CancelledCount: Output only. The number of tasks which reached phase
	// Cancelled.
	CancelledCount int64 `json:"cancelledCount,omitempty"`
	// CompletionTime: Output only. Represents time when the execution was
	// completed. It is not guaranteed to be set in happens-before order across
	// separate operations.
	CompletionTime string `json:"completionTime,omitempty"`
	// Conditions: Output only. The Condition of this Execution, containing its
	// readiness status, and detailed error information in case it did not reach
	// the desired state.
	Conditions []*GoogleCloudRunV2Condition `json:"conditions,omitempty"`
	// CreateTime: Output only. Represents time when the execution was acknowledged
	// by the execution controller. It is not guaranteed to be set in
	// happens-before order across separate operations.
	CreateTime string `json:"createTime,omitempty"`
	// Creator: Output only. Email address of the authenticated creator.
	Creator string `json:"creator,omitempty"`
	// DeleteTime: Output only. For a deleted resource, the deletion time. It is
	// only populated as a response to a Delete request.
	DeleteTime string `json:"deleteTime,omitempty"`
	// Etag: Output only. A system-generated fingerprint for this version of the
	// resource. May be used to detect modification conflict during updates.
	Etag string `json:"etag,omitempty"`
	// ExpireTime: Output only. For a deleted resource, the time after which it
	// will be permamently deleted. It is only populated as a response to a Delete
	// request.
	ExpireTime string `json:"expireTime,omitempty"`
	// FailedCount: Output only. The number of tasks which reached phase Failed.
	FailedCount int64 `json:"failedCount,omitempty"`
	// Generation: Output only. A number that monotonically increases every time
	// the user modifies the desired state.
	Generation int64 `json:"generation,omitempty,string"`
	// Job: Output only. The name of the parent Job.
	Job string `json:"job,omitempty"`
	// Labels: Output only. Unstructured key value map that can be used to organize
	// and categorize objects. User-provided labels are shared with Google's
	// billing system, so they can be used to filter, or break down billing charges
	// by team, component, environment, state, etc. For more information, visit
	// https://cloud.google.com/resource-manager/docs/creating-managing-labels or
	// https://cloud.google.com/run/docs/configuring/labels
	Labels map[string]string `json:"labels,omitempty"`
	// LaunchStage: The least stable launch stage needed to create this resource,
	// as defined by Google Cloud Platform Launch Stages
	// (https://cloud.google.com/terms/launch-stages). Cloud Run supports `ALPHA`,
	// `BETA`, and `GA`. Note that this value might not be what was used as input.
	// For example, if ALPHA was provided as input in the parent resource, but only
	// BETA and GA-level features are were, this field will be BETA.
	//
	// Possible values:
	//   "LAUNCH_STAGE_UNSPECIFIED" - Do not use this default value.
	//   "UNIMPLEMENTED" - The feature is not yet implemented. Users can not use
	// it.
	//   "PRELAUNCH" - Prelaunch features are hidden from users and are only
	// visible internally.
	//   "EARLY_ACCESS" - Early Access features are limited to a closed group of
	// testers. To use these features, you must sign up in advance and sign a
	// Trusted Tester agreement (which includes confidentiality provisions). These
	// features may be unstable, changed in backward-incompatible ways, and are not
	// guaranteed to be released.
	//   "ALPHA" - Alpha is a limited availability test for releases before they
	// are cleared for widespread use. By Alpha, all significant design issues are
	// resolved and we are in the process of verifying functionality. Alpha
	// customers need to apply for access, agree to applicable terms, and have
	// their projects allowlisted. Alpha releases don't have to be feature
	// complete, no SLAs are provided, and there are no technical support
	// obligations, but they will be far enough along that customers can actually
	// use them in test environments or for limited-use tests -- just like they
	// would in normal production cases.
	//   "BETA" - Beta is the point at which we are ready to open a release for any
	// customer to use. There are no SLA or technical support obligations in a Beta
	// release. Products will be complete from a feature perspective, but may have
	// some open outstanding issues. Beta releases are suitable for limited
	// production use cases.
	//   "GA" - GA features are open to all developers and are considered stable
	// and fully qualified for production use.
	//   "DEPRECATED" - Deprecated features are scheduled to be shut down and
	// removed. For more information, see the "Deprecation Policy" section of our
	// [Terms of Service](https://cloud.google.com/terms/) and the [Google Cloud
	// Platform Subject to the Deprecation
	// Policy](https://cloud.google.com/terms/deprecation) documentation.
	LaunchStage string `json:"launchStage,omitempty"`
	// LogUri: Output only. URI where logs for this execution can be found in Cloud
	// Console.
	LogUri string `json:"logUri,omitempty"`
	// Name: Output only. The unique name of this Execution.
	Name string `json:"name,omitempty"`
	// ObservedGeneration: Output only. The generation of this Execution. See
	// comments in `reconciling` for additional information on reconciliation
	// process in Cloud Run.
	ObservedGeneration int64 `json:"observedGeneration,omitempty,string"`
	// Parallelism: Output only. Specifies the maximum desired number of tasks the
	// execution should run at any given time. Must be <= task_count. The actual
	// number of tasks running in steady state will be less than this number when
	// ((.spec.task_count - .status.successful) < .spec.parallelism), i.e. when the
	// work left to do is less than max parallelism.
	Parallelism int64 `json:"parallelism,omitempty"`
	// Reconciling: Output only. Indicates whether the resource's reconciliation is
	// still in progress. See comments in `Job.reconciling` for additional
	// information on reconciliation process in Cloud Run.
	Reconciling bool `json:"reconciling,omitempty"`
	// RetriedCount: Output only. The number of tasks which have retried at least
	// once.
	RetriedCount int64 `json:"retriedCount,omitempty"`
	// RunningCount: Output only. The number of actively running tasks.
	RunningCount int64 `json:"runningCount,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// StartTime: Output only. Represents time when the execution started to run.
	// It is not guaranteed to be set in happens-before order across separate
	// operations.
	StartTime string `json:"startTime,omitempty"`
	// SucceededCount: Output only. The number of tasks which reached phase
	// Succeeded.
	SucceededCount int64 `json:"succeededCount,omitempty"`
	// TaskCount: Output only. Specifies the desired number of tasks the execution
	// should run. Setting to 1 means that parallelism is limited to 1 and the
	// success of that task signals the success of the execution.
	TaskCount int64 `json:"taskCount,omitempty"`
	// Template: Output only. The template used to create tasks for this execution.
	Template *GoogleCloudRunV2TaskTemplate `json:"template,omitempty"`
	// Uid: Output only. Server assigned unique identifier for the Execution. The
	// value is a UUID4 string and guaranteed to remain unchanged until the
	// resource is deleted.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. The last-modified time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2Execution) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2Execution
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2ExecutionReference: Reference to an Execution. Use
// /Executions.GetExecution with the given name to get full execution including
// the latest status.
type GoogleCloudRunV2ExecutionReference struct {
	// CompletionStatus: Status for the execution completion.
	//
	// Possible values:
	//   "COMPLETION_STATUS_UNSPECIFIED" - The default value. This value is used if
	// the state is omitted.
	//   "EXECUTION_SUCCEEDED" - Job execution has succeeded.
	//   "EXECUTION_FAILED" - Job execution has failed.
	//   "EXECUTION_RUNNING" - Job execution is running normally.
	//   "EXECUTION_PENDING" - Waiting for backing resources to be provisioned.
	//   "EXECUTION_CANCELLED" - Job execution has been cancelled by the user.
	CompletionStatus string `json:"completionStatus,omitempty"`
	// CompletionTime: Creation timestamp of the execution.
	CompletionTime string `json:"completionTime,omitempty"`
	// CreateTime: Creation timestamp of the execution.
	CreateTime string `json:"createTime,omitempty"`
	// DeleteTime: The deletion time of the execution. It is only populated as a
	// response to a Delete request.
	DeleteTime string `json:"deleteTime,omitempty"`
	// Name: Name of the execution.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompletionStatus") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompletionStatus") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2ExecutionReference) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2ExecutionReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2ExecutionTemplate: ExecutionTemplate describes the data an
// execution should have when created from a template.
type GoogleCloudRunV2ExecutionTemplate struct {
	// Annotations: Unstructured key value map that may be set by external tools to
	// store and arbitrary metadata. They are not queryable and should be preserved
	// when modifying objects. Cloud Run API v2 does not support annotations with
	// `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or
	// `autoscaling.knative.dev` namespaces, and they will be rejected. All system
	// annotations in v1 now have a corresponding field in v2 ExecutionTemplate.
	// This field follows Kubernetes annotations' namespacing, limits, and rules.
	Annotations map[string]string `json:"annotations,omitempty"`
	// Labels: Unstructured key value map that can be used to organize and
	// categorize objects. User-provided labels are shared with Google's billing
	// system, so they can be used to filter, or break down billing charges by
	// team, component, environment, state, etc. For more information, visit
	// https://cloud.google.com/resource-manager/docs/creating-managing-labels or
	// https://cloud.google.com/run/docs/configuring/labels. Cloud Run API v2 does
	// not support labels with `run.googleapis.com`, `cloud.googleapis.com`,
	// `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they
	// will be rejected. All system labels in v1 now have a corresponding field in
	// v2 ExecutionTemplate.
	Labels map[string]string `json:"labels,omitempty"`
	// Parallelism: Optional. Specifies the maximum desired number of tasks the
	// execution should run at given time. When the job is run, if this field is 0
	// or unset, the maximum possible value will be used for that execution. The
	// actual number of tasks running in steady state will be less than this number
	// when there are fewer tasks waiting to be completed remaining, i.e. when the
	// work left to do is less than max parallelism.
	Parallelism int64 `json:"parallelism,omitempty"`
	// TaskCount: Specifies the desired number of tasks the execution should run.
	// Setting to 1 means that parallelism is limited to 1 and the success of that
	// task signals the success of the execution. Defaults to 1.
	TaskCount int64 `json:"taskCount,omitempty"`
	// Template: Required. Describes the task(s) that will be created when
	// executing an execution.
	Template *GoogleCloudRunV2TaskTemplate `json:"template,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2ExecutionTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2ExecutionTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2ExportImageRequest: Request message for exporting Cloud Run
// image.
type GoogleCloudRunV2ExportImageRequest struct {
	// DestinationRepo: Required. The export destination url (the Artifact Registry
	// repo).
	DestinationRepo string `json:"destinationRepo,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DestinationRepo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DestinationRepo") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2ExportImageRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2ExportImageRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2ExportImageResponse: ExportImageResponse contains an
// operation Id to track the image export operation.
type GoogleCloudRunV2ExportImageResponse struct {
	// OperationId: An operation ID used to track the status of image exports tied
	// to the original pod ID in the request.
	OperationId string `json:"operationId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "OperationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OperationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2ExportImageResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2ExportImageResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2ExportStatusResponse: ExportStatusResponse contains the
// status of image export operation, with the status of each image export job.
type GoogleCloudRunV2ExportStatusResponse struct {
	// ImageExportStatuses: The status of each image export job.
	ImageExportStatuses []*GoogleCloudRunV2ImageExportStatus `json:"imageExportStatuses,omitempty"`
	// OperationId: The operation id.
	OperationId string `json:"operationId,omitempty"`
	// OperationState: Output only. The state of the overall export operation.
	//
	// Possible values:
	//   "OPERATION_STATE_UNSPECIFIED" - State unspecified.
	//   "IN_PROGRESS" - Operation still in progress.
	//   "FINISHED" - Operation finished.
	OperationState string `json:"operationState,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ImageExportStatuses") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImageExportStatuses") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2ExportStatusResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2ExportStatusResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2GCSVolumeSource: Represents a volume backed by a Cloud
// Storage bucket using Cloud Storage FUSE.
type GoogleCloudRunV2GCSVolumeSource struct {
	// Bucket: Cloud Storage Bucket name.
	Bucket string `json:"bucket,omitempty"`
	// MountOptions: A list of additional flags to pass to the gcsfuse CLI. Options
	// should be specified without the leading "--".
	MountOptions []string `json:"mountOptions,omitempty"`
	// ReadOnly: If true, the volume will be mounted as read only for all mounts.
	ReadOnly bool `json:"readOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bucket") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bucket") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2GCSVolumeSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2GCSVolumeSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2GRPCAction: GRPCAction describes an action involving a GRPC
// port.
type GoogleCloudRunV2GRPCAction struct {
	// Port: Optional. Port number of the gRPC service. Number must be in the range
	// 1 to 65535. If not specified, defaults to the exposed port of the container,
	// which is the value of container.ports[0].containerPort.
	Port int64 `json:"port,omitempty"`
	// Service: Optional. Service is the name of the service to place in the gRPC
	// HealthCheckRequest (see
	// https://github.com/grpc/grpc/blob/master/doc/health-checking.md ). If this
	// is not specified, the default behavior is defined by gRPC.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Port") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Port") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2GRPCAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2GRPCAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2HTTPGetAction: HTTPGetAction describes an action based on
// HTTP Get requests.
type GoogleCloudRunV2HTTPGetAction struct {
	// HttpHeaders: Optional. Custom headers to set in the request. HTTP allows
	// repeated headers.
	HttpHeaders []*GoogleCloudRunV2HTTPHeader `json:"httpHeaders,omitempty"`
	// Path: Optional. Path to access on the HTTP server. Defaults to '/'.
	Path string `json:"path,omitempty"`
	// Port: Optional. Port number to access on the container. Must be in the range
	// 1 to 65535. If not specified, defaults to the exposed port of the container,
	// which is the value of container.ports[0].containerPort.
	Port int64 `json:"port,omitempty"`
	// ForceSendFields is a list of field names (e.g. "HttpHeaders") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "HttpHeaders") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2HTTPGetAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2HTTPGetAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2HTTPHeader: HTTPHeader describes a custom header to be used
// in HTTP probes
type GoogleCloudRunV2HTTPHeader struct {
	// Name: Required. The header field name
	Name string `json:"name,omitempty"`
	// Value: Optional. The header field value
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2HTTPHeader) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2HTTPHeader
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2ImageExportStatus: The status of an image export job.
type GoogleCloudRunV2ImageExportStatus struct {
	// ExportJobState: Output only. Has the image export job finished (regardless
	// of successful or failure).
	//
	// Possible values:
	//   "EXPORT_JOB_STATE_UNSPECIFIED" - State unspecified.
	//   "IN_PROGRESS" - Job still in progress.
	//   "FINISHED" - Job finished.
	ExportJobState string `json:"exportJobState,omitempty"`
	// ExportedImageDigest: The exported image ID as it will appear in Artifact
	// Registry.
	ExportedImageDigest string `json:"exportedImageDigest,omitempty"`
	// Status: The status of the export task if done.
	Status *UtilStatusProto `json:"status,omitempty"`
	// Tag: The image tag as it will appear in Artifact Registry.
	Tag string `json:"tag,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExportJobState") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExportJobState") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2ImageExportStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2ImageExportStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2InstanceSplit: Holds a single instance split entry for the
// Worker. Allocations can be done to a specific Revision name, or pointing to
// the latest Ready Revision.
type GoogleCloudRunV2InstanceSplit struct {
	// Percent: Specifies percent of the instance split to this Revision. This
	// defaults to zero if unspecified.
	Percent int64 `json:"percent,omitempty"`
	// Revision: Revision to which to assign this portion of instances, if split
	// allocation is by revision.
	Revision string `json:"revision,omitempty"`
	// Type: The allocation type for this instance split.
	//
	// Possible values:
	//   "INSTANCE_SPLIT_ALLOCATION_TYPE_UNSPECIFIED" - Unspecified instance
	// allocation type.
	//   "INSTANCE_SPLIT_ALLOCATION_TYPE_LATEST" - Allocates instances to the
	// Service's latest ready Revision.
	//   "INSTANCE_SPLIT_ALLOCATION_TYPE_REVISION" - Allocates instances to a
	// Revision by name.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Percent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Percent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2InstanceSplit) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2InstanceSplit
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2InstanceSplitStatus: Represents the observed state of a
// single `InstanceSplit` entry.
type GoogleCloudRunV2InstanceSplitStatus struct {
	// Percent: Specifies percent of the instance split to this Revision.
	Percent int64 `json:"percent,omitempty"`
	// Revision: Revision to which this instance split is assigned.
	Revision string `json:"revision,omitempty"`
	// Type: The allocation type for this instance split.
	//
	// Possible values:
	//   "INSTANCE_SPLIT_ALLOCATION_TYPE_UNSPECIFIED" - Unspecified instance
	// allocation type.
	//   "INSTANCE_SPLIT_ALLOCATION_TYPE_LATEST" - Allocates instances to the
	// Service's latest ready Revision.
	//   "INSTANCE_SPLIT_ALLOCATION_TYPE_REVISION" - Allocates instances to a
	// Revision by name.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Percent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Percent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2InstanceSplitStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2InstanceSplitStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2Job: Job represents the configuration of a single job, which
// references a container image that is run to completion.
type GoogleCloudRunV2Job struct {
	// Annotations: Unstructured key value map that may be set by external tools to
	// store and arbitrary metadata. They are not queryable and should be preserved
	// when modifying objects. Cloud Run API v2 does not support annotations with
	// `run.googleapis.com`, `cloud.googleapis.com`, `serving.knative.dev`, or
	// `autoscaling.knative.dev` namespaces, and they will be rejected on new
	// resources. All system annotations in v1 now have a corresponding field in v2
	// Job. This field follows Kubernetes annotations' namespacing, limits, and
	// rules.
	Annotations map[string]string `json:"annotations,omitempty"`
	// BinaryAuthorization: Settings for the Binary Authorization feature.
	BinaryAuthorization *GoogleCloudRunV2BinaryAuthorization `json:"binaryAuthorization,omitempty"`
	// Client: Arbitrary identifier for the API client.
	Client string `json:"client,omitempty"`
	// ClientVersion: Arbitrary version identifier for the API client.
	ClientVersion string `json:"clientVersion,omitempty"`
	// Conditions: Output only. The Conditions of all other associated
	// sub-resources. They contain additional diagnostics information in case the
	// Job does not reach its desired state. See comments in `reconciling` for
	// additional information on reconciliation process in Cloud Run.
	Conditions []*GoogleCloudRunV2Condition `json:"conditions,omitempty"`
	// CreateTime: Output only. The creation time.
	CreateTime string `json:"createTime,omitempty"`
	// Creator: Output only. Email address of the authenticated creator.
	Creator string `json:"creator,omitempty"`
	// DeleteTime: Output only. The deletion time. It is only populated as a
	// response to a Delete request.
	DeleteTime string `json:"deleteTime,omitempty"`
	// Etag: Optional. A system-generated fingerprint for this version of the
	// resource. May be used to detect modification conflict during updates.
	Etag string `json:"etag,omitempty"`
	// ExecutionCount: Output only. Number of executions created for this job.
	ExecutionCount int64 `json:"executionCount,omitempty"`
	// ExpireTime: Output only. For a deleted resource, the time after which it
	// will be permamently deleted.
	ExpireTime string `json:"expireTime,omitempty"`
	// Generation: Output only. A number that monotonically increases every time
	// the user modifies the desired state.
	Generation int64 `json:"generation,omitempty,string"`
	// Labels: Unstructured key value map that can be used to organize and
	// categorize objects. User-provided labels are shared with Google's billing
	// system, so they can be used to filter, or break down billing charges by
	// team, component, environment, state, etc. For more information, visit
	// https://cloud.google.com/resource-manager/docs/creating-managing-labels or
	// https://cloud.google.com/run/docs/configuring/labels. Cloud Run API v2 does
	// not support labels with `run.googleapis.com`, `cloud.googleapis.com`,
	// `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they
	// will be rejected. All system labels in v1 now have a corresponding field in
	// v2 Job.
	Labels map[string]string `json:"labels,omitempty"`
	// LastModifier: Output only. Email address of the last authenticated modifier.
	LastModifier string `json:"lastModifier,omitempty"`
	// LatestCreatedExecution: Output only. Name of the last created execution.
	LatestCreatedExecution *GoogleCloudRunV2ExecutionReference `json:"latestCreatedExecution,omitempty"`
	// LaunchStage: The launch stage as defined by Google Cloud Platform Launch
	// Stages (https://cloud.google.com/terms/launch-stages). Cloud Run supports
	// `ALPHA`, `BETA`, and `GA`. If no value is specified, GA is assumed. Set the
	// launch stage to a preview stage on input to allow use of preview features in
	// that stage. On read (or output), describes whether the resource uses preview
	// features. For example, if ALPHA is provided as input, but only BETA and
	// GA-level features are used, this field will be BETA on output.
	//
	// Possible values:
	//   "LAUNCH_STAGE_UNSPECIFIED" - Do not use this default value.
	//   "UNIMPLEMENTED" - The feature is not yet implemented. Users can not use
	// it.
	//   "PRELAUNCH" - Prelaunch features are hidden from users and are only
	// visible internally.
	//   "EARLY_ACCESS" - Early Access features are limited to a closed group of
	// testers. To use these features, you must sign up in advance and sign a
	// Trusted Tester agreement (which includes confidentiality provisions). These
	// features may be unstable, changed in backward-incompatible ways, and are not
	// guaranteed to be released.
	//   "ALPHA" - Alpha is a limited availability test for releases before they
	// are cleared for widespread use. By Alpha, all significant design issues are
	// resolved and we are in the process of verifying functionality. Alpha
	// customers need to apply for access, agree to applicable terms, and have
	// their projects allowlisted. Alpha releases don't have to be feature
	// complete, no SLAs are provided, and there are no technical support
	// obligations, but they will be far enough along that customers can actually
	// use them in test environments or for limited-use tests -- just like they
	// would in normal production cases.
	//   "BETA" - Beta is the point at which we are ready to open a release for any
	// customer to use. There are no SLA or technical support obligations in a Beta
	// release. Products will be complete from a feature perspective, but may have
	// some open outstanding issues. Beta releases are suitable for limited
	// production use cases.
	//   "GA" - GA features are open to all developers and are considered stable
	// and fully qualified for production use.
	//   "DEPRECATED" - Deprecated features are scheduled to be shut down and
	// removed. For more information, see the "Deprecation Policy" section of our
	// [Terms of Service](https://cloud.google.com/terms/) and the [Google Cloud
	// Platform Subject to the Deprecation
	// Policy](https://cloud.google.com/terms/deprecation) documentation.
	LaunchStage string `json:"launchStage,omitempty"`
	// Name: The fully qualified name of this Job. Format:
	// projects/{project}/locations/{location}/jobs/{job}
	Name string `json:"name,omitempty"`
	// ObservedGeneration: Output only. The generation of this Job. See comments in
	// `reconciling` for additional information on reconciliation process in Cloud
	// Run.
	ObservedGeneration int64 `json:"observedGeneration,omitempty,string"`
	// Reconciling: Output only. Returns true if the Job is currently being acted
	// upon by the system to bring it into the desired state. When a new Job is
	// created, or an existing one is updated, Cloud Run will asynchronously
	// perform all necessary steps to bring the Job to the desired state. This
	// process is called reconciliation. While reconciliation is in process,
	// `observed_generation` and `latest_succeeded_execution`, will have transient
	// values that might mismatch the intended state: Once reconciliation is over
	// (and this field is false), there are two possible outcomes: reconciliation
	// succeeded and the state matches the Job, or there was an error, and
	// reconciliation failed. This state can be found in
	// `terminal_condition.state`. If reconciliation succeeded, the following
	// fields will match: `observed_generation` and `generation`,
	// `latest_succeeded_execution` and `latest_created_execution`. If
	// reconciliation failed, `observed_generation` and
	// `latest_succeeded_execution` will have the state of the last succeeded
	// execution or empty for newly created Job. Additional information on the
	// failure can be found in `terminal_condition` and `conditions`.
	Reconciling bool `json:"reconciling,omitempty"`
	// RunExecutionToken: A unique string used as a suffix for creating a new
	// execution. The Job will become ready when the execution is successfully
	// completed. The sum of job name and token length must be fewer than 63
	// characters.
	RunExecutionToken string `json:"runExecutionToken,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// StartExecutionToken: A unique string used as a suffix creating a new
	// execution. The Job will become ready when the execution is successfully
	// started. The sum of job name and token length must be fewer than 63
	// characters.
	StartExecutionToken string `json:"startExecutionToken,omitempty"`
	// Template: Required. The template used to create executions for this Job.
	Template *GoogleCloudRunV2ExecutionTemplate `json:"template,omitempty"`
	// TerminalCondition: Output only. The Condition of this Job, containing its
	// readiness status, and detailed error information in case it did not reach
	// the desired state.
	TerminalCondition *GoogleCloudRunV2Condition `json:"terminalCondition,omitempty"`
	// Uid: Output only. Server assigned unique identifier for the Execution. The
	// value is a UUID4 string and guaranteed to remain unchanged until the
	// resource is deleted.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. The last-modified time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2Job) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2Job
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2ListExecutionsResponse: Response message containing a list
// of Executions.
type GoogleCloudRunV2ListExecutionsResponse struct {
	// Executions: The resulting list of Executions.
	Executions []*GoogleCloudRunV2Execution `json:"executions,omitempty"`
	// NextPageToken: A token indicating there are more items than page_size. Use
	// it in the next ListExecutions request to continue.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Executions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Executions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2ListExecutionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2ListExecutionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2ListJobsResponse: Response message containing a list of
// Jobs.
type GoogleCloudRunV2ListJobsResponse struct {
	// Jobs: The resulting list of Jobs.
	Jobs []*GoogleCloudRunV2Job `json:"jobs,omitempty"`
	// NextPageToken: A token indicating there are more items than page_size. Use
	// it in the next ListJobs request to continue.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Jobs") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Jobs") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2ListJobsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2ListJobsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2ListRevisionsResponse: Response message containing a list of
// Revisions.
type GoogleCloudRunV2ListRevisionsResponse struct {
	// NextPageToken: A token indicating there are more items than page_size. Use
	// it in the next ListRevisions request to continue.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Revisions: The resulting list of Revisions.
	Revisions []*GoogleCloudRunV2Revision `json:"revisions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2ListRevisionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2ListRevisionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2ListServicesResponse: Response message containing a list of
// Services.
type GoogleCloudRunV2ListServicesResponse struct {
	// NextPageToken: A token indicating there are more items than page_size. Use
	// it in the next ListServices request to continue.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Services: The resulting list of Services.
	Services []*GoogleCloudRunV2Service `json:"services,omitempty"`
	// Unreachable: Output only. For global requests, returns the list of regions
	// that could not be reached within the deadline.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2ListServicesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2ListServicesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2ListTasksResponse: Response message containing a list of
// Tasks.
type GoogleCloudRunV2ListTasksResponse struct {
	// NextPageToken: A token indicating there are more items than page_size. Use
	// it in the next ListTasks request to continue.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Tasks: The resulting list of Tasks.
	Tasks []*GoogleCloudRunV2Task `json:"tasks,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2ListTasksResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2ListTasksResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2ListWorkerPoolsResponse: Response message containing a list
// of WorkerPools.
type GoogleCloudRunV2ListWorkerPoolsResponse struct {
	// NextPageToken: A token indicating there are more items than page_size. Use
	// it in the next ListWorkerPools request to continue.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// WorkerPools: The resulting list of WorkerPools.
	WorkerPools []*GoogleCloudRunV2WorkerPool `json:"workerPools,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2ListWorkerPoolsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2ListWorkerPoolsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2Metadata: Metadata represents the JSON encoded generated
// customer metadata.
type GoogleCloudRunV2Metadata struct {
	// Metadata: JSON encoded Google-generated Customer Metadata for a given
	// resource/project.
	Metadata string `json:"metadata,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Metadata") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metadata") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2Metadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2Metadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2MultiRegionSettings: Settings for multi-region deployment.
type GoogleCloudRunV2MultiRegionSettings struct {
	// MultiRegionId: Optional. System-generated unique id for the multi-region
	// Service.
	MultiRegionId string `json:"multiRegionId,omitempty"`
	// Regions: Required. List of regions to deploy to, including primary region.
	Regions []string `json:"regions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MultiRegionId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MultiRegionId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2MultiRegionSettings) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2MultiRegionSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2NFSVolumeSource: Represents an NFS mount.
type GoogleCloudRunV2NFSVolumeSource struct {
	// Path: Path that is exported by the NFS server.
	Path string `json:"path,omitempty"`
	// ReadOnly: If true, the volume will be mounted as read only for all mounts.
	ReadOnly bool `json:"readOnly,omitempty"`
	// Server: Hostname or IP address of the NFS server
	Server string `json:"server,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Path") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Path") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2NFSVolumeSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2NFSVolumeSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2NetworkInterface: Direct VPC egress settings.
type GoogleCloudRunV2NetworkInterface struct {
	// Network: Optional. The VPC network that the Cloud Run resource will be able
	// to send traffic to. At least one of network or subnetwork must be specified.
	// If both network and subnetwork are specified, the given VPC subnetwork must
	// belong to the given VPC network. If network is not specified, it will be
	// looked up from the subnetwork.
	Network string `json:"network,omitempty"`
	// Subnetwork: Optional. The VPC subnetwork that the Cloud Run resource will
	// get IPs from. At least one of network or subnetwork must be specified. If
	// both network and subnetwork are specified, the given VPC subnetwork must
	// belong to the given VPC network. If subnetwork is not specified, the
	// subnetwork with the same name with the network will be used.
	Subnetwork string `json:"subnetwork,omitempty"`
	// Tags: Optional. Network tags applied to this Cloud Run resource.
	Tags []string `json:"tags,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Network") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Network") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2NetworkInterface) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2NetworkInterface
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2NodeSelector: Hardware constraints configuration.
type GoogleCloudRunV2NodeSelector struct {
	// Accelerator: Required. GPU accelerator type to attach to an instance.
	Accelerator string `json:"accelerator,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Accelerator") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Accelerator") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2NodeSelector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2NodeSelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2Overrides: RunJob Overrides that contains Execution fields
// to be overridden.
type GoogleCloudRunV2Overrides struct {
	// ContainerOverrides: Per container override specification.
	ContainerOverrides []*GoogleCloudRunV2ContainerOverride `json:"containerOverrides,omitempty"`
	// TaskCount: Optional. The desired number of tasks the execution should run.
	// Will replace existing task_count value.
	TaskCount int64 `json:"taskCount,omitempty"`
	// Timeout: Duration in seconds the task may be active before the system will
	// actively try to mark it failed and kill associated containers. Will replace
	// existing timeout_seconds value.
	Timeout string `json:"timeout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ContainerOverrides") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ContainerOverrides") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2Overrides) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2Overrides
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2Probe: Probe describes a health check to be performed
// against a container to determine whether it is alive or ready to receive
// traffic.
type GoogleCloudRunV2Probe struct {
	// FailureThreshold: Optional. Minimum consecutive failures for the probe to be
	// considered failed after having succeeded. Defaults to 3. Minimum value is 1.
	FailureThreshold int64 `json:"failureThreshold,omitempty"`
	// Grpc: Optional. GRPC specifies an action involving a gRPC port. Exactly one
	// of httpGet, tcpSocket, or grpc must be specified.
	Grpc *GoogleCloudRunV2GRPCAction `json:"grpc,omitempty"`
	// HttpGet: Optional. HTTPGet specifies the http request to perform. Exactly
	// one of httpGet, tcpSocket, or grpc must be specified.
	HttpGet *GoogleCloudRunV2HTTPGetAction `json:"httpGet,omitempty"`
	// InitialDelaySeconds: Optional. Number of seconds after the container has
	// started before the probe is initiated. Defaults to 0 seconds. Minimum value
	// is 0. Maximum value for liveness probe is 3600. Maximum value for startup
	// probe is 240.
	InitialDelaySeconds int64 `json:"initialDelaySeconds,omitempty"`
	// PeriodSeconds: Optional. How often (in seconds) to perform the probe.
	// Default to 10 seconds. Minimum value is 1. Maximum value for liveness probe
	// is 3600. Maximum value for startup probe is 240. Must be greater or equal
	// than timeout_seconds.
	PeriodSeconds int64 `json:"periodSeconds,omitempty"`
	// TcpSocket: Optional. TCPSocket specifies an action involving a TCP port.
	// Exactly one of httpGet, tcpSocket, or grpc must be specified.
	TcpSocket *GoogleCloudRunV2TCPSocketAction `json:"tcpSocket,omitempty"`
	// TimeoutSeconds: Optional. Number of seconds after which the probe times out.
	// Defaults to 1 second. Minimum value is 1. Maximum value is 3600. Must be
	// smaller than period_seconds.
	TimeoutSeconds int64 `json:"timeoutSeconds,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailureThreshold") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailureThreshold") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2Probe) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2Probe
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2ResourceRequirements: ResourceRequirements describes the
// compute resource requirements.
type GoogleCloudRunV2ResourceRequirements struct {
	// CpuIdle: Determines whether CPU is only allocated during requests (true by
	// default). However, if ResourceRequirements is set, the caller must
	// explicitly set this field to true to preserve the default behavior.
	CpuIdle bool `json:"cpuIdle,omitempty"`
	// Limits: Only `memory`, `cpu` and `nvidia.com/gpu` keys in the map are
	// supported. Notes: * The only supported values for CPU are '1', '2', '4', and
	// '8'. Setting 4 CPU requires at least 2Gi of memory. For more information, go
	// to https://cloud.google.com/run/docs/configuring/cpu. * For supported
	// 'memory' values and syntax, go to
	// https://cloud.google.com/run/docs/configuring/memory-limits * The only
	// supported 'nvidia.com/gpu' value is '1'.
	Limits map[string]string `json:"limits,omitempty"`
	// StartupCpuBoost: Determines whether CPU should be boosted on startup of a
	// new container instance above the requested CPU threshold, this can help
	// reduce cold-start latency.
	StartupCpuBoost bool `json:"startupCpuBoost,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CpuIdle") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CpuIdle") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2ResourceRequirements) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2ResourceRequirements
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2Revision: A Revision is an immutable snapshot of code and
// configuration. A Revision references a container image. Revisions are only
// created by updates to its parent Service.
type GoogleCloudRunV2Revision struct {
	// Annotations: Output only. Unstructured key value map that may be set by
	// external tools to store and arbitrary metadata. They are not queryable and
	// should be preserved when modifying objects.
	Annotations map[string]string `json:"annotations,omitempty"`
	// Conditions: Output only. The Condition of this Revision, containing its
	// readiness status, and detailed error information in case it did not reach a
	// serving state.
	Conditions []*GoogleCloudRunV2Condition `json:"conditions,omitempty"`
	// Containers: Holds the single container that defines the unit of execution
	// for this Revision.
	Containers []*GoogleCloudRunV2Container `json:"containers,omitempty"`
	// CreateTime: Output only. The creation time.
	CreateTime string `json:"createTime,omitempty"`
	// Creator: Output only. Email address of the authenticated creator.
	Creator string `json:"creator,omitempty"`
	// DeleteTime: Output only. For a deleted resource, the deletion time. It is
	// only populated as a response to a Delete request.
	DeleteTime string `json:"deleteTime,omitempty"`
	// EncryptionKey: A reference to a customer managed encryption key (CMEK) to
	// use to encrypt this container image. For more information, go to
	// https://cloud.google.com/run/docs/securing/using-cmek
	EncryptionKey string `json:"encryptionKey,omitempty"`
	// EncryptionKeyRevocationAction: The action to take if the encryption key is
	// revoked.
	//
	// Possible values:
	//   "ENCRYPTION_KEY_REVOCATION_ACTION_UNSPECIFIED" - Unspecified
	//   "PREVENT_NEW" - Prevents the creation of new instances.
	//   "SHUTDOWN" - Shuts down existing instances, and prevents creation of new
	// ones.
	EncryptionKeyRevocationAction string `json:"encryptionKeyRevocationAction,omitempty"`
	// EncryptionKeyShutdownDuration: If encryption_key_revocation_action is
	// SHUTDOWN, the duration before shutting down all instances. The minimum
	// increment is 1 hour.
	EncryptionKeyShutdownDuration string `json:"encryptionKeyShutdownDuration,omitempty"`
	// Etag: Output only. A system-generated fingerprint for this version of the
	// resource. May be used to detect modification conflict during updates.
	Etag string `json:"etag,omitempty"`
	// ExecutionEnvironment: The execution environment being used to host this
	// Revision.
	//
	// Possible values:
	//   "EXECUTION_ENVIRONMENT_UNSPECIFIED" - Unspecified
	//   "EXECUTION_ENVIRONMENT_GEN1" - Uses the First Generation environment.
	//   "EXECUTION_ENVIRONMENT_GEN2" - Uses Second Generation environment.
	ExecutionEnvironment string `json:"executionEnvironment,omitempty"`
	// ExpireTime: Output only. For a deleted resource, the time after which it
	// will be permamently deleted. It is only populated as a response to a Delete
	// request.
	ExpireTime string `json:"expireTime,omitempty"`
	// Generation: Output only. A number that monotonically increases every time
	// the user modifies the desired state.
	Generation int64 `json:"generation,omitempty,string"`
	// GpuZonalRedundancyDisabled: Optional. Output only. True if GPU zonal
	// redundancy is disabled on this revision.
	GpuZonalRedundancyDisabled bool `json:"gpuZonalRedundancyDisabled,omitempty"`
	// Labels: Output only. Unstructured key value map that can be used to organize
	// and categorize objects. User-provided labels are shared with Google's
	// billing system, so they can be used to filter, or break down billing charges
	// by team, component, environment, state, etc. For more information, visit
	// https://cloud.google.com/resource-manager/docs/creating-managing-labels or
	// https://cloud.google.com/run/docs/configuring/labels.
	Labels map[string]string `json:"labels,omitempty"`
	// LaunchStage: The least stable launch stage needed to create this resource,
	// as defined by Google Cloud Platform Launch Stages
	// (https://cloud.google.com/terms/launch-stages). Cloud Run supports `ALPHA`,
	// `BETA`, and `GA`. Note that this value might not be what was used as input.
	// For example, if ALPHA was provided as input in the parent resource, but only
	// BETA and GA-level features are were, this field will be BETA.
	//
	// Possible values:
	//   "LAUNCH_STAGE_UNSPECIFIED" - Do not use this default value.
	//   "UNIMPLEMENTED" - The feature is not yet implemented. Users can not use
	// it.
	//   "PRELAUNCH" - Prelaunch features are hidden from users and are only
	// visible internally.
	//   "EARLY_ACCESS" - Early Access features are limited to a closed group of
	// testers. To use these features, you must sign up in advance and sign a
	// Trusted Tester agreement (which includes confidentiality provisions). These
	// features may be unstable, changed in backward-incompatible ways, and are not
	// guaranteed to be released.
	//   "ALPHA" - Alpha is a limited availability test for releases before they
	// are cleared for widespread use. By Alpha, all significant design issues are
	// resolved and we are in the process of verifying functionality. Alpha
	// customers need to apply for access, agree to applicable terms, and have
	// their projects allowlisted. Alpha releases don't have to be feature
	// complete, no SLAs are provided, and there are no technical support
	// obligations, but they will be far enough along that customers can actually
	// use them in test environments or for limited-use tests -- just like they
	// would in normal production cases.
	//   "BETA" - Beta is the point at which we are ready to open a release for any
	// customer to use. There are no SLA or technical support obligations in a Beta
	// release. Products will be complete from a feature perspective, but may have
	// some open outstanding issues. Beta releases are suitable for limited
	// production use cases.
	//   "GA" - GA features are open to all developers and are considered stable
	// and fully qualified for production use.
	//   "DEPRECATED" - Deprecated features are scheduled to be shut down and
	// removed. For more information, see the "Deprecation Policy" section of our
	// [Terms of Service](https://cloud.google.com/terms/) and the [Google Cloud
	// Platform Subject to the Deprecation
	// Policy](https://cloud.google.com/terms/deprecation) documentation.
	LaunchStage string `json:"launchStage,omitempty"`
	// LogUri: Output only. The Google Console URI to obtain logs for the Revision.
	LogUri string `json:"logUri,omitempty"`
	// MaxInstanceRequestConcurrency: Sets the maximum number of requests that each
	// serving instance can receive.
	MaxInstanceRequestConcurrency int64 `json:"maxInstanceRequestConcurrency,omitempty"`
	// Name: Output only. The unique name of this Revision.
	Name string `json:"name,omitempty"`
	// NodeSelector: The node selector for the revision.
	NodeSelector *GoogleCloudRunV2NodeSelector `json:"nodeSelector,omitempty"`
	// ObservedGeneration: Output only. The generation of this Revision currently
	// serving traffic. See comments in `reconciling` for additional information on
	// reconciliation process in Cloud Run.
	ObservedGeneration int64 `json:"observedGeneration,omitempty,string"`
	// Reconciling: Output only. Indicates whether the resource's reconciliation is
	// still in progress. See comments in `Service.reconciling` for additional
	// information on reconciliation process in Cloud Run.
	Reconciling bool `json:"reconciling,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// Scaling: Scaling settings for this revision.
	Scaling *GoogleCloudRunV2RevisionScaling `json:"scaling,omitempty"`
	// ScalingStatus: Output only. The current effective scaling settings for the
	// revision.
	ScalingStatus *GoogleCloudRunV2RevisionScalingStatus `json:"scalingStatus,omitempty"`
	// Service: Output only. The name of the parent service.
	Service string `json:"service,omitempty"`
	// ServiceAccount: Email address of the IAM service account associated with the
	// revision of the service. The service account represents the identity of the
	// running revision, and determines what permissions the revision has.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ServiceMesh: Enables service mesh connectivity.
	ServiceMesh *GoogleCloudRunV2ServiceMesh `json:"serviceMesh,omitempty"`
	// SessionAffinity: Enable session affinity.
	SessionAffinity bool `json:"sessionAffinity,omitempty"`
	// Timeout: Max allowed time for an instance to respond to a request.
	Timeout string `json:"timeout,omitempty"`
	// Uid: Output only. Server assigned unique identifier for the Revision. The
	// value is a UUID4 string and guaranteed to remain unchanged until the
	// resource is deleted.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. The last-modified time.
	UpdateTime string `json:"updateTime,omitempty"`
	// Volumes: A list of Volumes to make available to containers.
	Volumes []*GoogleCloudRunV2Volume `json:"volumes,omitempty"`
	// VpcAccess: VPC Access configuration for this Revision. For more information,
	// visit https://cloud.google.com/run/docs/configuring/connecting-vpc.
	VpcAccess *GoogleCloudRunV2VpcAccess `json:"vpcAccess,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2Revision) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2Revision
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2RevisionScaling: Settings for revision-level scaling
// settings.
type GoogleCloudRunV2RevisionScaling struct {
	// MaxInstanceCount: Optional. Maximum number of serving instances that this
	// resource should have. When unspecified, the field is set to the server
	// default value of 100. For more information see
	// https://cloud.google.com/run/docs/configuring/max-instances
	MaxInstanceCount int64 `json:"maxInstanceCount,omitempty"`
	// MinInstanceCount: Optional. Minimum number of serving instances that this
	// resource should have.
	MinInstanceCount int64 `json:"minInstanceCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaxInstanceCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaxInstanceCount") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2RevisionScaling) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2RevisionScaling
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2RevisionScalingStatus: Effective settings for the current
// revision
type GoogleCloudRunV2RevisionScalingStatus struct {
	// DesiredMinInstanceCount: The current number of min instances provisioned for
	// this revision.
	DesiredMinInstanceCount int64 `json:"desiredMinInstanceCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DesiredMinInstanceCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DesiredMinInstanceCount") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2RevisionScalingStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2RevisionScalingStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2RevisionTemplate: RevisionTemplate describes the data a
// revision should have when created from a template.
type GoogleCloudRunV2RevisionTemplate struct {
	// Annotations: Optional. Unstructured key value map that may be set by
	// external tools to store and arbitrary metadata. They are not queryable and
	// should be preserved when modifying objects. Cloud Run API v2 does not
	// support annotations with `run.googleapis.com`, `cloud.googleapis.com`,
	// `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they
	// will be rejected. All system annotations in v1 now have a corresponding
	// field in v2 RevisionTemplate. This field follows Kubernetes annotations'
	// namespacing, limits, and rules.
	Annotations map[string]string `json:"annotations,omitempty"`
	// Containers: Holds the single container that defines the unit of execution
	// for this Revision.
	Containers []*GoogleCloudRunV2Container `json:"containers,omitempty"`
	// EncryptionKey: A reference to a customer managed encryption key (CMEK) to
	// use to encrypt this container image. For more information, go to
	// https://cloud.google.com/run/docs/securing/using-cmek
	EncryptionKey string `json:"encryptionKey,omitempty"`
	// EncryptionKeyRevocationAction: Optional. The action to take if the
	// encryption key is revoked.
	//
	// Possible values:
	//   "ENCRYPTION_KEY_REVOCATION_ACTION_UNSPECIFIED" - Unspecified
	//   "PREVENT_NEW" - Prevents the creation of new instances.
	//   "SHUTDOWN" - Shuts down existing instances, and prevents creation of new
	// ones.
	EncryptionKeyRevocationAction string `json:"encryptionKeyRevocationAction,omitempty"`
	// EncryptionKeyShutdownDuration: Optional. If encryption_key_revocation_action
	// is SHUTDOWN, the duration before shutting down all instances. The minimum
	// increment is 1 hour.
	EncryptionKeyShutdownDuration string `json:"encryptionKeyShutdownDuration,omitempty"`
	// ExecutionEnvironment: Optional. The sandbox environment to host this
	// Revision.
	//
	// Possible values:
	//   "EXECUTION_ENVIRONMENT_UNSPECIFIED" - Unspecified
	//   "EXECUTION_ENVIRONMENT_GEN1" - Uses the First Generation environment.
	//   "EXECUTION_ENVIRONMENT_GEN2" - Uses Second Generation environment.
	ExecutionEnvironment string `json:"executionEnvironment,omitempty"`
	// GpuZonalRedundancyDisabled: Optional. True if GPU zonal redundancy is
	// disabled on this revision.
	GpuZonalRedundancyDisabled bool `json:"gpuZonalRedundancyDisabled,omitempty"`
	// HealthCheckDisabled: Optional. Disables health checking containers during
	// deployment.
	HealthCheckDisabled bool `json:"healthCheckDisabled,omitempty"`
	// Labels: Optional. Unstructured key value map that can be used to organize
	// and categorize objects. User-provided labels are shared with Google's
	// billing system, so they can be used to filter, or break down billing charges
	// by team, component, environment, state, etc. For more information, visit
	// https://cloud.google.com/resource-manager/docs/creating-managing-labels or
	// https://cloud.google.com/run/docs/configuring/labels. Cloud Run API v2 does
	// not support labels with `run.googleapis.com`, `cloud.googleapis.com`,
	// `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they
	// will be rejected. All system labels in v1 now have a corresponding field in
	// v2 RevisionTemplate.
	Labels map[string]string `json:"labels,omitempty"`
	// MaxInstanceRequestConcurrency: Optional. Sets the maximum number of requests
	// that each serving instance can receive. If not specified or 0, concurrency
	// defaults to 80 when requested `CPU >= 1` and defaults to 1 when requested
	// `CPU < 1`.
	MaxInstanceRequestConcurrency int64 `json:"maxInstanceRequestConcurrency,omitempty"`
	// NodeSelector: Optional. The node selector for the revision template.
	NodeSelector *GoogleCloudRunV2NodeSelector `json:"nodeSelector,omitempty"`
	// Revision: Optional. The unique name for the revision. If this field is
	// omitted, it will be automatically generated based on the Service name.
	Revision string `json:"revision,omitempty"`
	// Scaling: Optional. Scaling settings for this Revision.
	Scaling *GoogleCloudRunV2RevisionScaling `json:"scaling,omitempty"`
	// ServiceAccount: Optional. Email address of the IAM service account
	// associated with the revision of the service. The service account represents
	// the identity of the running revision, and determines what permissions the
	// revision has. If not provided, the revision will use the project's default
	// service account.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ServiceMesh: Optional. Enables service mesh connectivity.
	ServiceMesh *GoogleCloudRunV2ServiceMesh `json:"serviceMesh,omitempty"`
	// SessionAffinity: Optional. Enable session affinity.
	SessionAffinity bool `json:"sessionAffinity,omitempty"`
	// Timeout: Optional. Max allowed time for an instance to respond to a request.
	Timeout string `json:"timeout,omitempty"`
	// Volumes: Optional. A list of Volumes to make available to containers.
	Volumes []*GoogleCloudRunV2Volume `json:"volumes,omitempty"`
	// VpcAccess: Optional. VPC Access configuration to use for this Revision. For
	// more information, visit
	// https://cloud.google.com/run/docs/configuring/connecting-vpc.
	VpcAccess *GoogleCloudRunV2VpcAccess `json:"vpcAccess,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2RevisionTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2RevisionTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2RunJobRequest: Request message to create a new Execution of
// a Job.
type GoogleCloudRunV2RunJobRequest struct {
	// Etag: A system-generated fingerprint for this version of the resource. May
	// be used to detect modification conflict during updates.
	Etag string `json:"etag,omitempty"`
	// Overrides: Overrides specification for a given execution of a job. If
	// provided, overrides will be applied to update the execution or task spec.
	Overrides *GoogleCloudRunV2Overrides `json:"overrides,omitempty"`
	// ValidateOnly: Indicates that the request should be validated without
	// actually deleting any resources.
	ValidateOnly bool `json:"validateOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Etag") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Etag") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2RunJobRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2RunJobRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2SecretKeySelector: SecretEnvVarSource represents a source
// for the value of an EnvVar.
type GoogleCloudRunV2SecretKeySelector struct {
	// Secret: Required. The name of the secret in Cloud Secret Manager. Format:
	// {secret_name} if the secret is in the same project.
	// projects/{project}/secrets/{secret_name} if the secret is in a different
	// project.
	Secret string `json:"secret,omitempty"`
	// Version: The Cloud Secret Manager secret version. Can be 'latest' for the
	// latest version, an integer for a specific version, or a version alias.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Secret") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Secret") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2SecretKeySelector) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2SecretKeySelector
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2SecretVolumeSource: The secret's value will be presented as
// the content of a file whose name is defined in the item path. If no items
// are defined, the name of the file is the secret.
type GoogleCloudRunV2SecretVolumeSource struct {
	// DefaultMode: Integer representation of mode bits to use on created files by
	// default. Must be a value between 0000 and 0777 (octal), defaulting to 0444.
	// Directories within the path are not affected by this setting. Notes *
	// Internally, a umask of 0222 will be applied to any non-zero value. * This is
	// an integer representation of the mode bits. So, the octal integer value
	// should look exactly as the chmod numeric notation with a leading zero. Some
	// examples: for chmod 640 (u=rw,g=r), set to 0640 (octal) or 416 (base-10).
	// For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or 493 (base-10). *
	// This might be in conflict with other options that affect the file mode, like
	// fsGroup, and the result can be other mode bits set. This might be in
	// conflict with other options that affect the file mode, like fsGroup, and as
	// a result, other mode bits could be set.
	DefaultMode int64 `json:"defaultMode,omitempty"`
	// Items: If unspecified, the volume will expose a file whose name is the
	// secret, relative to VolumeMount.mount_path + VolumeMount.sub_path. If
	// specified, the key will be used as the version to fetch from Cloud Secret
	// Manager and the path will be the name of the file exposed in the volume.
	// When items are defined, they must specify a path and a version.
	Items []*GoogleCloudRunV2VersionToPath `json:"items,omitempty"`
	// Secret: Required. The name of the secret in Cloud Secret Manager. Format:
	// {secret} if the secret is in the same project.
	// projects/{project}/secrets/{secret} if the secret is in a different project.
	Secret string `json:"secret,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DefaultMode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DefaultMode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2SecretVolumeSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2SecretVolumeSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2Service: Service acts as a top-level container that manages
// a set of configurations and revision templates which implement a network
// service. Service exists to provide a singular abstraction which can be
// access controlled, reasoned about, and which encapsulates software lifecycle
// decisions such as rollout policy and team resource ownership.
type GoogleCloudRunV2Service struct {
	// Annotations: Optional. Unstructured key value map that may be set by
	// external tools to store and arbitrary metadata. They are not queryable and
	// should be preserved when modifying objects. Cloud Run API v2 does not
	// support annotations with `run.googleapis.com`, `cloud.googleapis.com`,
	// `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they
	// will be rejected in new resources. All system annotations in v1 now have a
	// corresponding field in v2 Service. This field follows Kubernetes
	// annotations' namespacing, limits, and rules.
	Annotations map[string]string `json:"annotations,omitempty"`
	// BinaryAuthorization: Optional. Settings for the Binary Authorization
	// feature.
	BinaryAuthorization *GoogleCloudRunV2BinaryAuthorization `json:"binaryAuthorization,omitempty"`
	// BuildConfig: Optional. Configuration for building a Cloud Run function.
	BuildConfig *GoogleCloudRunV2BuildConfig `json:"buildConfig,omitempty"`
	// Client: Arbitrary identifier for the API client.
	Client string `json:"client,omitempty"`
	// ClientVersion: Arbitrary version identifier for the API client.
	ClientVersion string `json:"clientVersion,omitempty"`
	// Conditions: Output only. The Conditions of all other associated
	// sub-resources. They contain additional diagnostics information in case the
	// Service does not reach its Serving state. See comments in `reconciling` for
	// additional information on reconciliation process in Cloud Run.
	Conditions []*GoogleCloudRunV2Condition `json:"conditions,omitempty"`
	// CreateTime: Output only. The creation time.
	CreateTime string `json:"createTime,omitempty"`
	// Creator: Output only. Email address of the authenticated creator.
	Creator string `json:"creator,omitempty"`
	// CustomAudiences: One or more custom audiences that you want this service to
	// support. Specify each custom audience as the full URL in a string. The
	// custom audiences are encoded in the token and used to authenticate requests.
	// For more information, see
	// https://cloud.google.com/run/docs/configuring/custom-audiences.
	CustomAudiences []string `json:"customAudiences,omitempty"`
	// DefaultUriDisabled: Optional. Disables public resolution of the default URI
	// of this service.
	DefaultUriDisabled bool `json:"defaultUriDisabled,omitempty"`
	// DeleteTime: Output only. The deletion time. It is only populated as a
	// response to a Delete request.
	DeleteTime string `json:"deleteTime,omitempty"`
	// Description: User-provided description of the Service. This field currently
	// has a 512-character limit.
	Description string `json:"description,omitempty"`
	// Etag: Optional. A system-generated fingerprint for this version of the
	// resource. May be used to detect modification conflict during updates.
	Etag string `json:"etag,omitempty"`
	// ExpireTime: Output only. For a deleted resource, the time after which it
	// will be permanently deleted.
	ExpireTime string `json:"expireTime,omitempty"`
	// Generation: Output only. A number that monotonically increases every time
	// the user modifies the desired state. Please note that unlike v1, this is an
	// int64 value. As with most Google APIs, its JSON representation will be a
	// `string` instead of an `integer`.
	Generation int64 `json:"generation,omitempty,string"`
	// IapEnabled: Optional. IAP settings on the Service.
	IapEnabled bool `json:"iapEnabled,omitempty"`
	// Ingress: Optional. Provides the ingress settings for this Service. On
	// output, returns the currently observed ingress settings, or
	// INGRESS_TRAFFIC_UNSPECIFIED if no revision is active.
	//
	// Possible values:
	//   "INGRESS_TRAFFIC_UNSPECIFIED" - Unspecified
	//   "INGRESS_TRAFFIC_ALL" - All inbound traffic is allowed.
	//   "INGRESS_TRAFFIC_INTERNAL_ONLY" - Only internal traffic is allowed.
	//   "INGRESS_TRAFFIC_INTERNAL_LOAD_BALANCER" - Both internal and Google Cloud
	// Load Balancer traffic is allowed.
	//   "INGRESS_TRAFFIC_NONE" - No ingress traffic is allowed.
	Ingress string `json:"ingress,omitempty"`
	// InvokerIamDisabled: Optional. Disables IAM permission check for
	// run.routes.invoke for callers of this service. For more information, visit
	// https://cloud.google.com/run/docs/securing/managing-access#invoker_check.
	InvokerIamDisabled bool `json:"invokerIamDisabled,omitempty"`
	// Labels: Optional. Unstructured key value map that can be used to organize
	// and categorize objects. User-provided labels are shared with Google's
	// billing system, so they can be used to filter, or break down billing charges
	// by team, component, environment, state, etc. For more information, visit
	// https://cloud.google.com/resource-manager/docs/creating-managing-labels or
	// https://cloud.google.com/run/docs/configuring/labels. Cloud Run API v2 does
	// not support labels with `run.googleapis.com`, `cloud.googleapis.com`,
	// `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they
	// will be rejected. All system labels in v1 now have a corresponding field in
	// v2 Service.
	Labels map[string]string `json:"labels,omitempty"`
	// LastModifier: Output only. Email address of the last authenticated modifier.
	LastModifier string `json:"lastModifier,omitempty"`
	// LatestCreatedRevision: Output only. Name of the last created revision. See
	// comments in `reconciling` for additional information on reconciliation
	// process in Cloud Run.
	LatestCreatedRevision string `json:"latestCreatedRevision,omitempty"`
	// LatestReadyRevision: Output only. Name of the latest revision that is
	// serving traffic. See comments in `reconciling` for additional information on
	// reconciliation process in Cloud Run.
	LatestReadyRevision string `json:"latestReadyRevision,omitempty"`
	// LaunchStage: Optional. The launch stage as defined by Google Cloud Platform
	// Launch Stages (https://cloud.google.com/terms/launch-stages). Cloud Run
	// supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA is assumed.
	// Set the launch stage to a preview stage on input to allow use of preview
	// features in that stage. On read (or output), describes whether the resource
	// uses preview features. For example, if ALPHA is provided as input, but only
	// BETA and GA-level features are used, this field will be BETA on output.
	//
	// Possible values:
	//   "LAUNCH_STAGE_UNSPECIFIED" - Do not use this default value.
	//   "UNIMPLEMENTED" - The feature is not yet implemented. Users can not use
	// it.
	//   "PRELAUNCH" - Prelaunch features are hidden from users and are only
	// visible internally.
	//   "EARLY_ACCESS" - Early Access features are limited to a closed group of
	// testers. To use these features, you must sign up in advance and sign a
	// Trusted Tester agreement (which includes confidentiality provisions). These
	// features may be unstable, changed in backward-incompatible ways, and are not
	// guaranteed to be released.
	//   "ALPHA" - Alpha is a limited availability test for releases before they
	// are cleared for widespread use. By Alpha, all significant design issues are
	// resolved and we are in the process of verifying functionality. Alpha
	// customers need to apply for access, agree to applicable terms, and have
	// their projects allowlisted. Alpha releases don't have to be feature
	// complete, no SLAs are provided, and there are no technical support
	// obligations, but they will be far enough along that customers can actually
	// use them in test environments or for limited-use tests -- just like they
	// would in normal production cases.
	//   "BETA" - Beta is the point at which we are ready to open a release for any
	// customer to use. There are no SLA or technical support obligations in a Beta
	// release. Products will be complete from a feature perspective, but may have
	// some open outstanding issues. Beta releases are suitable for limited
	// production use cases.
	//   "GA" - GA features are open to all developers and are considered stable
	// and fully qualified for production use.
	//   "DEPRECATED" - Deprecated features are scheduled to be shut down and
	// removed. For more information, see the "Deprecation Policy" section of our
	// [Terms of Service](https://cloud.google.com/terms/) and the [Google Cloud
	// Platform Subject to the Deprecation
	// Policy](https://cloud.google.com/terms/deprecation) documentation.
	LaunchStage string `json:"launchStage,omitempty"`
	// MultiRegionSettings: Optional. Settings for multi-region deployment.
	MultiRegionSettings *GoogleCloudRunV2MultiRegionSettings `json:"multiRegionSettings,omitempty"`
	// Name: Identifier. The fully qualified name of this Service. In
	// CreateServiceRequest, this field is ignored, and instead composed from
	// CreateServiceRequest.parent and CreateServiceRequest.service_id. Format:
	// projects/{project}/locations/{location}/services/{service_id}
	Name string `json:"name,omitempty"`
	// ObservedGeneration: Output only. The generation of this Service currently
	// serving traffic. See comments in `reconciling` for additional information on
	// reconciliation process in Cloud Run. Please note that unlike v1, this is an
	// int64 value. As with most Google APIs, its JSON representation will be a
	// `string` instead of an `integer`.
	ObservedGeneration int64 `json:"observedGeneration,omitempty,string"`
	// Reconciling: Output only. Returns true if the Service is currently being
	// acted upon by the system to bring it into the desired state. When a new
	// Service is created, or an existing one is updated, Cloud Run will
	// asynchronously perform all necessary steps to bring the Service to the
	// desired serving state. This process is called reconciliation. While
	// reconciliation is in process, `observed_generation`,
	// `latest_ready_revision`, `traffic_statuses`, and `uri` will have transient
	// values that might mismatch the intended state: Once reconciliation is over
	// (and this field is false), there are two possible outcomes: reconciliation
	// succeeded and the serving state matches the Service, or there was an error,
	// and reconciliation failed. This state can be found in
	// `terminal_condition.state`. If reconciliation succeeded, the following
	// fields will match: `traffic` and `traffic_statuses`, `observed_generation`
	// and `generation`, `latest_ready_revision` and `latest_created_revision`. If
	// reconciliation failed, `traffic_statuses`, `observed_generation`, and
	// `latest_ready_revision` will have the state of the last serving revision, or
	// empty for newly created Services. Additional information on the failure can
	// be found in `terminal_condition` and `conditions`.
	Reconciling bool `json:"reconciling,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// Scaling: Optional. Specifies service-level scaling settings
	Scaling *GoogleCloudRunV2ServiceScaling `json:"scaling,omitempty"`
	// Template: Required. The template used to create revisions for this Service.
	Template *GoogleCloudRunV2RevisionTemplate `json:"template,omitempty"`
	// TerminalCondition: Output only. The Condition of this Service, containing
	// its readiness status, and detailed error information in case it did not
	// reach a serving state. See comments in `reconciling` for additional
	// information on reconciliation process in Cloud Run.
	TerminalCondition *GoogleCloudRunV2Condition `json:"terminalCondition,omitempty"`
	// ThreatDetectionEnabled: Output only. True if Cloud Run Threat Detection
	// monitoring is enabled for the parent project of this Service.
	ThreatDetectionEnabled bool `json:"threatDetectionEnabled,omitempty"`
	// Traffic: Optional. Specifies how to distribute traffic over a collection of
	// Revisions belonging to the Service. If traffic is empty or not provided,
	// defaults to 100% traffic to the latest `Ready` Revision.
	Traffic []*GoogleCloudRunV2TrafficTarget `json:"traffic,omitempty"`
	// TrafficStatuses: Output only. Detailed status information for corresponding
	// traffic targets. See comments in `reconciling` for additional information on
	// reconciliation process in Cloud Run.
	TrafficStatuses []*GoogleCloudRunV2TrafficTargetStatus `json:"trafficStatuses,omitempty"`
	// Uid: Output only. Server assigned unique identifier for the trigger. The
	// value is a UUID4 string and guaranteed to remain unchanged until the
	// resource is deleted.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. The last-modified time.
	UpdateTime string `json:"updateTime,omitempty"`
	// Uri: Output only. The main URI in which this Service is serving traffic.
	Uri string `json:"uri,omitempty"`
	// Urls: Output only. All URLs serving traffic for this Service.
	Urls []string `json:"urls,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2Service) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2Service
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2ServiceMesh: Settings for Cloud Service Mesh. For more
// information see https://cloud.google.com/service-mesh/docs/overview.
type GoogleCloudRunV2ServiceMesh struct {
	// Mesh: The Mesh resource name. Format:
	// `projects/{project}/locations/global/meshes/{mesh}`, where `{project}` can
	// be project id or number.
	Mesh string `json:"mesh,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Mesh") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Mesh") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2ServiceMesh) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2ServiceMesh
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2ServiceScaling: Scaling settings applied at the service
// level rather than at the revision level.
type GoogleCloudRunV2ServiceScaling struct {
	// ManualInstanceCount: Optional. total instance count for the service in
	// manual scaling mode. This number of instances is divided among all revisions
	// with specified traffic based on the percent of traffic they are receiving.
	ManualInstanceCount int64 `json:"manualInstanceCount,omitempty"`
	// MaxInstanceCount: Optional. total max instances for the service. This number
	// of instances is divided among all revisions with specified traffic based on
	// the percent of traffic they are receiving.
	MaxInstanceCount int64 `json:"maxInstanceCount,omitempty"`
	// MinInstanceCount: Optional. total min instances for the service. This number
	// of instances is divided among all revisions with specified traffic based on
	// the percent of traffic they are receiving.
	MinInstanceCount int64 `json:"minInstanceCount,omitempty"`
	// ScalingMode: Optional. The scaling mode for the service.
	//
	// Possible values:
	//   "SCALING_MODE_UNSPECIFIED" - Unspecified.
	//   "AUTOMATIC" - Scale based on traffic between min and max instances.
	//   "MANUAL" - Scale to exactly min instances and ignore max instances.
	ScalingMode string `json:"scalingMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ManualInstanceCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ManualInstanceCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2ServiceScaling) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2ServiceScaling
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2SourceCode: Source type for the container.
type GoogleCloudRunV2SourceCode struct {
	// CloudStorageSource: The source is a Cloud Storage bucket.
	CloudStorageSource *GoogleCloudRunV2CloudStorageSource `json:"cloudStorageSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CloudStorageSource") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudStorageSource") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2SourceCode) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2SourceCode
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2StorageSource: Location of the source in an archive file in
// Google Cloud Storage.
type GoogleCloudRunV2StorageSource struct {
	// Bucket: Required. Google Cloud Storage bucket containing the source (see
	// Bucket Name Requirements
	// (https://cloud.google.com/storage/docs/bucket-naming#requirements)).
	Bucket string `json:"bucket,omitempty"`
	// Generation: Optional. Google Cloud Storage generation for the object. If the
	// generation is omitted, the latest generation will be used.
	Generation int64 `json:"generation,omitempty,string"`
	// Object: Required. Google Cloud Storage object containing the source. This
	// object must be a gzipped archive file (`.tar.gz`) containing source to
	// build.
	Object string `json:"object,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bucket") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bucket") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2StorageSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2StorageSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2SubmitBuildRequest: Request message for submitting a Build.
type GoogleCloudRunV2SubmitBuildRequest struct {
	// BuildpackBuild: Build the source using Buildpacks.
	BuildpackBuild *GoogleCloudRunV2BuildpacksBuild `json:"buildpackBuild,omitempty"`
	// Client: Optional. The client that initiated the build request.
	Client string `json:"client,omitempty"`
	// DockerBuild: Build the source using Docker. This means the source has a
	// Dockerfile.
	DockerBuild *GoogleCloudRunV2DockerBuild `json:"dockerBuild,omitempty"`
	// ImageUri: Required. Artifact Registry URI to store the built image.
	ImageUri string `json:"imageUri,omitempty"`
	// MachineType: Optional. The machine type from default pool to use for the
	// build. If left blank, cloudbuild will use a sensible default. Currently only
	// E2_HIGHCPU_8 is supported. If worker_pool is set, this field will be
	// ignored.
	MachineType string `json:"machineType,omitempty"`
	// ReleaseTrack: Optional. The release track of the client that initiated the
	// build request.
	//
	// Possible values:
	//   "LAUNCH_STAGE_UNSPECIFIED" - Do not use this default value.
	//   "UNIMPLEMENTED" - The feature is not yet implemented. Users can not use
	// it.
	//   "PRELAUNCH" - Prelaunch features are hidden from users and are only
	// visible internally.
	//   "EARLY_ACCESS" - Early Access features are limited to a closed group of
	// testers. To use these features, you must sign up in advance and sign a
	// Trusted Tester agreement (which includes confidentiality provisions). These
	// features may be unstable, changed in backward-incompatible ways, and are not
	// guaranteed to be released.
	//   "ALPHA" - Alpha is a limited availability test for releases before they
	// are cleared for widespread use. By Alpha, all significant design issues are
	// resolved and we are in the process of verifying functionality. Alpha
	// customers need to apply for access, agree to applicable terms, and have
	// their projects allowlisted. Alpha releases don't have to be feature
	// complete, no SLAs are provided, and there are no technical support
	// obligations, but they will be far enough along that customers can actually
	// use them in test environments or for limited-use tests -- just like they
	// would in normal production cases.
	//   "BETA" - Beta is the point at which we are ready to open a release for any
	// customer to use. There are no SLA or technical support obligations in a Beta
	// release. Products will be complete from a feature perspective, but may have
	// some open outstanding issues. Beta releases are suitable for limited
	// production use cases.
	//   "GA" - GA features are open to all developers and are considered stable
	// and fully qualified for production use.
	//   "DEPRECATED" - Deprecated features are scheduled to be shut down and
	// removed. For more information, see the "Deprecation Policy" section of our
	// [Terms of Service](https://cloud.google.com/terms/) and the [Google Cloud
	// Platform Subject to the Deprecation
	// Policy](https://cloud.google.com/terms/deprecation) documentation.
	ReleaseTrack string `json:"releaseTrack,omitempty"`
	// ServiceAccount: Optional. The service account to use for the build. If not
	// set, the default Cloud Build service account for the project will be used.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// StorageSource: Required. Source for the build.
	StorageSource *GoogleCloudRunV2StorageSource `json:"storageSource,omitempty"`
	// Tags: Optional. Additional tags to annotate the build.
	Tags []string `json:"tags,omitempty"`
	// WorkerPool: Optional. Name of the Cloud Build Custom Worker Pool that should
	// be used to build the function. The format of this field is
	// `projects/{project}/locations/{region}/workerPools/{workerPool}` where
	// `{project}` and `{region}` are the project id and region respectively where
	// the worker pool is defined and `{workerPool}` is the short name of the
	// worker pool.
	WorkerPool string `json:"workerPool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BuildpackBuild") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BuildpackBuild") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2SubmitBuildRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2SubmitBuildRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2SubmitBuildResponse: Response message for submitting a
// Build.
type GoogleCloudRunV2SubmitBuildResponse struct {
	// BaseImageUri: URI of the base builder image in Artifact Registry being used
	// in the build. Used to opt into automatic base image updates.
	BaseImageUri string `json:"baseImageUri,omitempty"`
	// BaseImageWarning: Warning message for the base image.
	BaseImageWarning string `json:"baseImageWarning,omitempty"`
	// BuildOperation: Cloud Build operation to be polled via CloudBuild API.
	BuildOperation *GoogleLongrunningOperation `json:"buildOperation,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BaseImageUri") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BaseImageUri") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2SubmitBuildResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2SubmitBuildResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2TCPSocketAction: TCPSocketAction describes an action based
// on opening a socket
type GoogleCloudRunV2TCPSocketAction struct {
	// Port: Optional. Port number to access on the container. Must be in the range
	// 1 to 65535. If not specified, defaults to the exposed port of the container,
	// which is the value of container.ports[0].containerPort.
	Port int64 `json:"port,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Port") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Port") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2TCPSocketAction) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2TCPSocketAction
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2Task: Task represents a single run of a container to
// completion.
type GoogleCloudRunV2Task struct {
	// Annotations: Output only. Unstructured key value map that may be set by
	// external tools to store and arbitrary metadata. They are not queryable and
	// should be preserved when modifying objects.
	Annotations map[string]string `json:"annotations,omitempty"`
	// CompletionTime: Output only. Represents time when the Task was completed. It
	// is not guaranteed to be set in happens-before order across separate
	// operations.
	CompletionTime string `json:"completionTime,omitempty"`
	// Conditions: Output only. The Condition of this Task, containing its
	// readiness status, and detailed error information in case it did not reach
	// the desired state.
	Conditions []*GoogleCloudRunV2Condition `json:"conditions,omitempty"`
	// Containers: Holds the single container that defines the unit of execution
	// for this task.
	Containers []*GoogleCloudRunV2Container `json:"containers,omitempty"`
	// CreateTime: Output only. Represents time when the task was created by the
	// system. It is not guaranteed to be set in happens-before order across
	// separate operations.
	CreateTime string `json:"createTime,omitempty"`
	// DeleteTime: Output only. For a deleted resource, the deletion time. It is
	// only populated as a response to a Delete request.
	DeleteTime string `json:"deleteTime,omitempty"`
	// EncryptionKey: Output only. A reference to a customer managed encryption key
	// (CMEK) to use to encrypt this container image. For more information, go to
	// https://cloud.google.com/run/docs/securing/using-cmek
	EncryptionKey string `json:"encryptionKey,omitempty"`
	// Etag: Output only. A system-generated fingerprint for this version of the
	// resource. May be used to detect modification conflict during updates.
	Etag string `json:"etag,omitempty"`
	// Execution: Output only. The name of the parent Execution.
	Execution string `json:"execution,omitempty"`
	// ExecutionEnvironment: The execution environment being used to host this
	// Task.
	//
	// Possible values:
	//   "EXECUTION_ENVIRONMENT_UNSPECIFIED" - Unspecified
	//   "EXECUTION_ENVIRONMENT_GEN1" - Uses the First Generation environment.
	//   "EXECUTION_ENVIRONMENT_GEN2" - Uses Second Generation environment.
	ExecutionEnvironment string `json:"executionEnvironment,omitempty"`
	// ExpireTime: Output only. For a deleted resource, the time after which it
	// will be permamently deleted. It is only populated as a response to a Delete
	// request.
	ExpireTime string `json:"expireTime,omitempty"`
	// Generation: Output only. A number that monotonically increases every time
	// the user modifies the desired state.
	Generation int64 `json:"generation,omitempty,string"`
	// GpuZonalRedundancyDisabled: Optional. Output only. True if GPU zonal
	// redundancy is disabled on this task.
	GpuZonalRedundancyDisabled bool `json:"gpuZonalRedundancyDisabled,omitempty"`
	// Index: Output only. Index of the Task, unique per execution, and beginning
	// at 0.
	Index int64 `json:"index,omitempty"`
	// Job: Output only. The name of the parent Job.
	Job string `json:"job,omitempty"`
	// Labels: Output only. Unstructured key value map that can be used to organize
	// and categorize objects. User-provided labels are shared with Google's
	// billing system, so they can be used to filter, or break down billing charges
	// by team, component, environment, state, etc. For more information, visit
	// https://cloud.google.com/resource-manager/docs/creating-managing-labels or
	// https://cloud.google.com/run/docs/configuring/labels
	Labels map[string]string `json:"labels,omitempty"`
	// LastAttemptResult: Output only. Result of the last attempt of this Task.
	LastAttemptResult *GoogleCloudRunV2TaskAttemptResult `json:"lastAttemptResult,omitempty"`
	// LogUri: Output only. URI where logs for this execution can be found in Cloud
	// Console.
	LogUri string `json:"logUri,omitempty"`
	// MaxRetries: Number of retries allowed per Task, before marking this Task
	// failed.
	MaxRetries int64 `json:"maxRetries,omitempty"`
	// Name: Output only. The unique name of this Task.
	Name string `json:"name,omitempty"`
	// NodeSelector: Output only. The node selector for the task.
	NodeSelector *GoogleCloudRunV2NodeSelector `json:"nodeSelector,omitempty"`
	// ObservedGeneration: Output only. The generation of this Task. See comments
	// in `Job.reconciling` for additional information on reconciliation process in
	// Cloud Run.
	ObservedGeneration int64 `json:"observedGeneration,omitempty,string"`
	// Reconciling: Output only. Indicates whether the resource's reconciliation is
	// still in progress. See comments in `Job.reconciling` for additional
	// information on reconciliation process in Cloud Run.
	Reconciling bool `json:"reconciling,omitempty"`
	// Retried: Output only. The number of times this Task was retried. Tasks are
	// retried when they fail up to the maxRetries limit.
	Retried int64 `json:"retried,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// ScheduledTime: Output only. Represents time when the task was scheduled to
	// run by the system. It is not guaranteed to be set in happens-before order
	// across separate operations.
	ScheduledTime string `json:"scheduledTime,omitempty"`
	// ServiceAccount: Email address of the IAM service account associated with the
	// Task of a Job. The service account represents the identity of the running
	// task, and determines what permissions the task has. If not provided, the
	// task will use the project's default service account.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// StartTime: Output only. Represents time when the task started to run. It is
	// not guaranteed to be set in happens-before order across separate operations.
	StartTime string `json:"startTime,omitempty"`
	// Timeout: Max allowed time duration the Task may be active before the system
	// will actively try to mark it failed and kill associated containers. This
	// applies per attempt of a task, meaning each retry can run for the full
	// timeout.
	Timeout string `json:"timeout,omitempty"`
	// Uid: Output only. Server assigned unique identifier for the Task. The value
	// is a UUID4 string and guaranteed to remain unchanged until the resource is
	// deleted.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. The last-modified time.
	UpdateTime string `json:"updateTime,omitempty"`
	// Volumes: A list of Volumes to make available to containers.
	Volumes []*GoogleCloudRunV2Volume `json:"volumes,omitempty"`
	// VpcAccess: Output only. VPC Access configuration to use for this Task. For
	// more information, visit
	// https://cloud.google.com/run/docs/configuring/connecting-vpc.
	VpcAccess *GoogleCloudRunV2VpcAccess `json:"vpcAccess,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2Task) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2Task
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2TaskAttemptResult: Result of a task attempt.
type GoogleCloudRunV2TaskAttemptResult struct {
	// ExitCode: Output only. The exit code of this attempt. This may be unset if
	// the container was unable to exit cleanly with a code due to some other
	// failure. See status field for possible failure details. At most one of
	// exit_code or term_signal will be set.
	ExitCode int64 `json:"exitCode,omitempty"`
	// Status: Output only. The status of this attempt. If the status code is OK,
	// then the attempt succeeded.
	Status *GoogleRpcStatus `json:"status,omitempty"`
	// TermSignal: Output only. Termination signal of the container. This is set to
	// non-zero if the container is terminated by the system. At most one of
	// exit_code or term_signal will be set.
	TermSignal int64 `json:"termSignal,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExitCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExitCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2TaskAttemptResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2TaskAttemptResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2TaskTemplate: TaskTemplate describes the data a task should
// have when created from a template.
type GoogleCloudRunV2TaskTemplate struct {
	// Containers: Holds the single container that defines the unit of execution
	// for this task.
	Containers []*GoogleCloudRunV2Container `json:"containers,omitempty"`
	// EncryptionKey: A reference to a customer managed encryption key (CMEK) to
	// use to encrypt this container image. For more information, go to
	// https://cloud.google.com/run/docs/securing/using-cmek
	EncryptionKey string `json:"encryptionKey,omitempty"`
	// ExecutionEnvironment: Optional. The execution environment being used to host
	// this Task.
	//
	// Possible values:
	//   "EXECUTION_ENVIRONMENT_UNSPECIFIED" - Unspecified
	//   "EXECUTION_ENVIRONMENT_GEN1" - Uses the First Generation environment.
	//   "EXECUTION_ENVIRONMENT_GEN2" - Uses Second Generation environment.
	ExecutionEnvironment string `json:"executionEnvironment,omitempty"`
	// GpuZonalRedundancyDisabled: Optional. True if GPU zonal redundancy is
	// disabled on this task template.
	GpuZonalRedundancyDisabled bool `json:"gpuZonalRedundancyDisabled,omitempty"`
	// MaxRetries: Number of retries allowed per Task, before marking this Task
	// failed. Defaults to 3.
	MaxRetries int64 `json:"maxRetries,omitempty"`
	// NodeSelector: Optional. The node selector for the task template.
	NodeSelector *GoogleCloudRunV2NodeSelector `json:"nodeSelector,omitempty"`
	// ServiceAccount: Optional. Email address of the IAM service account
	// associated with the Task of a Job. The service account represents the
	// identity of the running task, and determines what permissions the task has.
	// If not provided, the task will use the project's default service account.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// Timeout: Optional. Max allowed time duration the Task may be active before
	// the system will actively try to mark it failed and kill associated
	// containers. This applies per attempt of a task, meaning each retry can run
	// for the full timeout. Defaults to 600 seconds.
	Timeout string `json:"timeout,omitempty"`
	// Volumes: Optional. A list of Volumes to make available to containers.
	Volumes []*GoogleCloudRunV2Volume `json:"volumes,omitempty"`
	// VpcAccess: Optional. VPC Access configuration to use for this Task. For more
	// information, visit
	// https://cloud.google.com/run/docs/configuring/connecting-vpc.
	VpcAccess *GoogleCloudRunV2VpcAccess `json:"vpcAccess,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Containers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Containers") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2TaskTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2TaskTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2TrafficTarget: Holds a single traffic routing entry for the
// Service. Allocations can be done to a specific Revision name, or pointing to
// the latest Ready Revision.
type GoogleCloudRunV2TrafficTarget struct {
	// Percent: Specifies percent of the traffic to this Revision. This defaults to
	// zero if unspecified.
	Percent int64 `json:"percent,omitempty"`
	// Revision: Revision to which to send this portion of traffic, if traffic
	// allocation is by revision.
	Revision string `json:"revision,omitempty"`
	// Tag: Indicates a string to be part of the URI to exclusively reference this
	// target.
	Tag string `json:"tag,omitempty"`
	// Type: The allocation type for this traffic target.
	//
	// Possible values:
	//   "TRAFFIC_TARGET_ALLOCATION_TYPE_UNSPECIFIED" - Unspecified instance
	// allocation type.
	//   "TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST" - Allocates instances to the
	// Service's latest ready Revision.
	//   "TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION" - Allocates instances to a
	// Revision by name.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Percent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Percent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2TrafficTarget) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2TrafficTarget
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2TrafficTargetStatus: Represents the observed state of a
// single `TrafficTarget` entry.
type GoogleCloudRunV2TrafficTargetStatus struct {
	// Percent: Specifies percent of the traffic to this Revision.
	Percent int64 `json:"percent,omitempty"`
	// Revision: Revision to which this traffic is sent.
	Revision string `json:"revision,omitempty"`
	// Tag: Indicates the string used in the URI to exclusively reference this
	// target.
	Tag string `json:"tag,omitempty"`
	// Type: The allocation type for this traffic target.
	//
	// Possible values:
	//   "TRAFFIC_TARGET_ALLOCATION_TYPE_UNSPECIFIED" - Unspecified instance
	// allocation type.
	//   "TRAFFIC_TARGET_ALLOCATION_TYPE_LATEST" - Allocates instances to the
	// Service's latest ready Revision.
	//   "TRAFFIC_TARGET_ALLOCATION_TYPE_REVISION" - Allocates instances to a
	// Revision by name.
	Type string `json:"type,omitempty"`
	// Uri: Displays the target URI.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Percent") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Percent") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2TrafficTargetStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2TrafficTargetStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2VersionToPath: VersionToPath maps a specific version of a
// secret to a relative file to mount to, relative to VolumeMount's mount_path.
type GoogleCloudRunV2VersionToPath struct {
	// Mode: Integer octal mode bits to use on this file, must be a value between
	// 01 and 0777 (octal). If 0 or not set, the Volume's default mode will be
	// used. Notes * Internally, a umask of 0222 will be applied to any non-zero
	// value. * This is an integer representation of the mode bits. So, the octal
	// integer value should look exactly as the chmod numeric notation with a
	// leading zero. Some examples: for chmod 640 (u=rw,g=r), set to 0640 (octal)
	// or 416 (base-10). For chmod 755 (u=rwx,g=rx,o=rx), set to 0755 (octal) or
	// 493 (base-10). * This might be in conflict with other options that affect
	// the file mode, like fsGroup, and the result can be other mode bits set.
	Mode int64 `json:"mode,omitempty"`
	// Path: Required. The relative path of the secret in the container.
	Path string `json:"path,omitempty"`
	// Version: The Cloud Secret Manager secret version. Can be 'latest' for the
	// latest value, or an integer or a secret alias for a specific version.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Mode") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Mode") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2VersionToPath) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2VersionToPath
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2Volume: Volume represents a named volume in a container.
type GoogleCloudRunV2Volume struct {
	// CloudSqlInstance: For Cloud SQL volumes, contains the specific instances
	// that should be mounted. Visit
	// https://cloud.google.com/sql/docs/mysql/connect-run for more information on
	// how to connect Cloud SQL and Cloud Run.
	CloudSqlInstance *GoogleCloudRunV2CloudSqlInstance `json:"cloudSqlInstance,omitempty"`
	// EmptyDir: Ephemeral storage used as a shared volume.
	EmptyDir *GoogleCloudRunV2EmptyDirVolumeSource `json:"emptyDir,omitempty"`
	// Gcs: Persistent storage backed by a Google Cloud Storage bucket.
	Gcs *GoogleCloudRunV2GCSVolumeSource `json:"gcs,omitempty"`
	// Name: Required. Volume's name.
	Name string `json:"name,omitempty"`
	// Nfs: For NFS Voumes, contains the path to the nfs Volume
	Nfs *GoogleCloudRunV2NFSVolumeSource `json:"nfs,omitempty"`
	// Secret: Secret represents a secret that should populate this volume.
	Secret *GoogleCloudRunV2SecretVolumeSource `json:"secret,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CloudSqlInstance") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloudSqlInstance") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2Volume) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2Volume
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2VolumeMount: VolumeMount describes a mounting of a Volume
// within a container.
type GoogleCloudRunV2VolumeMount struct {
	// MountPath: Required. Path within the container at which the volume should be
	// mounted. Must not contain ':'. For Cloud SQL volumes, it can be left empty,
	// or must otherwise be `/cloudsql`. All instances defined in the Volume will
	// be available as `/cloudsql/[instance]`. For more information on Cloud SQL
	// volumes, visit https://cloud.google.com/sql/docs/mysql/connect-run
	MountPath string `json:"mountPath,omitempty"`
	// Name: Required. This must match the Name of a Volume.
	Name string `json:"name,omitempty"`
	// SubPath: Optional. Path within the volume from which the container's volume
	// should be mounted. Defaults to "" (volume's root).
	SubPath string `json:"subPath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MountPath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MountPath") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2VolumeMount) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2VolumeMount
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2VpcAccess: VPC Access settings. For more information on
// sending traffic to a VPC network, visit
// https://cloud.google.com/run/docs/configuring/connecting-vpc.
type GoogleCloudRunV2VpcAccess struct {
	// Connector: VPC Access connector name. Format:
	// `projects/{project}/locations/{location}/connectors/{connector}`, where
	// `{project}` can be project id or number. For more information on sending
	// traffic to a VPC network via a connector, visit
	// https://cloud.google.com/run/docs/configuring/vpc-connectors.
	Connector string `json:"connector,omitempty"`
	// Egress: Optional. Traffic VPC egress settings. If not provided, it defaults
	// to PRIVATE_RANGES_ONLY.
	//
	// Possible values:
	//   "VPC_EGRESS_UNSPECIFIED" - Unspecified
	//   "ALL_TRAFFIC" - All outbound traffic is routed through the VPC connector.
	//   "PRIVATE_RANGES_ONLY" - Only private IP ranges are routed through the VPC
	// connector.
	Egress string `json:"egress,omitempty"`
	// NetworkInterfaces: Optional. Direct VPC egress settings. Currently only
	// single network interface is supported.
	NetworkInterfaces []*GoogleCloudRunV2NetworkInterface `json:"networkInterfaces,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Connector") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Connector") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2VpcAccess) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2VpcAccess
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2WorkerPool: WorkerPool acts as a top-level container that
// manages a set of configurations and revision templates which implement a
// pull-based workload. WorkerPool exists to provide a singular abstraction
// which can be access controlled, reasoned about, and which encapsulates
// software lifecycle decisions such as rollout policy and team resource
// ownership.
type GoogleCloudRunV2WorkerPool struct {
	// Annotations: Optional. Unstructured key value map that may be set by
	// external tools to store and arbitrary metadata. They are not queryable and
	// should be preserved when modifying objects. Cloud Run API v2 does not
	// support annotations with `run.googleapis.com`, `cloud.googleapis.com`,
	// `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they
	// will be rejected in new resources. All system annotations in v1 now have a
	// corresponding field in v2 WorkerPool. This field follows Kubernetes
	// annotations' namespacing, limits, and rules.
	Annotations map[string]string `json:"annotations,omitempty"`
	// BinaryAuthorization: Optional. Settings for the Binary Authorization
	// feature.
	BinaryAuthorization *GoogleCloudRunV2BinaryAuthorization `json:"binaryAuthorization,omitempty"`
	// Client: Arbitrary identifier for the API client.
	Client string `json:"client,omitempty"`
	// ClientVersion: Arbitrary version identifier for the API client.
	ClientVersion string `json:"clientVersion,omitempty"`
	// Conditions: Output only. The Conditions of all other associated
	// sub-resources. They contain additional diagnostics information in case the
	// WorkerPool does not reach its Serving state. See comments in `reconciling`
	// for additional information on reconciliation process in Cloud Run.
	Conditions []*GoogleCloudRunV2Condition `json:"conditions,omitempty"`
	// CreateTime: Output only. The creation time.
	CreateTime string `json:"createTime,omitempty"`
	// Creator: Output only. Email address of the authenticated creator.
	Creator string `json:"creator,omitempty"`
	// CustomAudiences: Not supported, and ignored by Cloud Run.
	CustomAudiences []string `json:"customAudiences,omitempty"`
	// DeleteTime: Output only. The deletion time. It is only populated as a
	// response to a Delete request.
	DeleteTime string `json:"deleteTime,omitempty"`
	// Description: User-provided description of the WorkerPool. This field
	// currently has a 512-character limit.
	Description string `json:"description,omitempty"`
	// Etag: Optional. A system-generated fingerprint for this version of the
	// resource. May be used to detect modification conflict during updates.
	Etag string `json:"etag,omitempty"`
	// ExpireTime: Output only. For a deleted resource, the time after which it
	// will be permamently deleted.
	ExpireTime string `json:"expireTime,omitempty"`
	// Generation: Output only. A number that monotonically increases every time
	// the user modifies the desired state. Please note that unlike v1, this is an
	// int64 value. As with most Google APIs, its JSON representation will be a
	// `string` instead of an `integer`.
	Generation int64 `json:"generation,omitempty,string"`
	// InstanceSplitStatuses: Output only. Detailed status information for
	// corresponding instance splits. See comments in `reconciling` for additional
	// information on reconciliation process in Cloud Run.
	InstanceSplitStatuses []*GoogleCloudRunV2InstanceSplitStatus `json:"instanceSplitStatuses,omitempty"`
	// InstanceSplits: Optional. Specifies how to distribute instances over a
	// collection of Revisions belonging to the WorkerPool. If instance split is
	// empty or not provided, defaults to 100% instances assigned to the latest
	// `Ready` Revision.
	InstanceSplits []*GoogleCloudRunV2InstanceSplit `json:"instanceSplits,omitempty"`
	// Labels: Optional. Unstructured key value map that can be used to organize
	// and categorize objects. User-provided labels are shared with Google's
	// billing system, so they can be used to filter, or break down billing charges
	// by team, component, environment, state, etc. For more information, visit
	// https://cloud.google.com/resource-manager/docs/creating-managing-labels or
	// https://cloud.google.com/run/docs/configuring/labels. Cloud Run API v2 does
	// not support labels with `run.googleapis.com`, `cloud.googleapis.com`,
	// `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they
	// will be rejected. All system labels in v1 now have a corresponding field in
	// v2 WorkerPool.
	Labels map[string]string `json:"labels,omitempty"`
	// LastModifier: Output only. Email address of the last authenticated modifier.
	LastModifier string `json:"lastModifier,omitempty"`
	// LatestCreatedRevision: Output only. Name of the last created revision. See
	// comments in `reconciling` for additional information on reconciliation
	// process in Cloud Run.
	LatestCreatedRevision string `json:"latestCreatedRevision,omitempty"`
	// LatestReadyRevision: Output only. Name of the latest revision that is
	// serving workloads. See comments in `reconciling` for additional information
	// on reconciliation process in Cloud Run.
	LatestReadyRevision string `json:"latestReadyRevision,omitempty"`
	// LaunchStage: Optional. The launch stage as defined by Google Cloud Platform
	// Launch Stages (https://cloud.google.com/terms/launch-stages). Cloud Run
	// supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA is assumed.
	// Set the launch stage to a preview stage on input to allow use of preview
	// features in that stage. On read (or output), describes whether the resource
	// uses preview features. For example, if ALPHA is provided as input, but only
	// BETA and GA-level features are used, this field will be BETA on output.
	//
	// Possible values:
	//   "LAUNCH_STAGE_UNSPECIFIED" - Do not use this default value.
	//   "UNIMPLEMENTED" - The feature is not yet implemented. Users can not use
	// it.
	//   "PRELAUNCH" - Prelaunch features are hidden from users and are only
	// visible internally.
	//   "EARLY_ACCESS" - Early Access features are limited to a closed group of
	// testers. To use these features, you must sign up in advance and sign a
	// Trusted Tester agreement (which includes confidentiality provisions). These
	// features may be unstable, changed in backward-incompatible ways, and are not
	// guaranteed to be released.
	//   "ALPHA" - Alpha is a limited availability test for releases before they
	// are cleared for widespread use. By Alpha, all significant design issues are
	// resolved and we are in the process of verifying functionality. Alpha
	// customers need to apply for access, agree to applicable terms, and have
	// their projects allowlisted. Alpha releases don't have to be feature
	// complete, no SLAs are provided, and there are no technical support
	// obligations, but they will be far enough along that customers can actually
	// use them in test environments or for limited-use tests -- just like they
	// would in normal production cases.
	//   "BETA" - Beta is the point at which we are ready to open a release for any
	// customer to use. There are no SLA or technical support obligations in a Beta
	// release. Products will be complete from a feature perspective, but may have
	// some open outstanding issues. Beta releases are suitable for limited
	// production use cases.
	//   "GA" - GA features are open to all developers and are considered stable
	// and fully qualified for production use.
	//   "DEPRECATED" - Deprecated features are scheduled to be shut down and
	// removed. For more information, see the "Deprecation Policy" section of our
	// [Terms of Service](https://cloud.google.com/terms/) and the [Google Cloud
	// Platform Subject to the Deprecation
	// Policy](https://cloud.google.com/terms/deprecation) documentation.
	LaunchStage string `json:"launchStage,omitempty"`
	// Name: The fully qualified name of this WorkerPool. In
	// CreateWorkerPoolRequest, this field is ignored, and instead composed from
	// CreateWorkerPoolRequest.parent and CreateWorkerPoolRequest.worker_id.
	// Format: `projects/{project}/locations/{location}/workerPools/{worker_id}`
	Name string `json:"name,omitempty"`
	// ObservedGeneration: Output only. The generation of this WorkerPool currently
	// serving workloads. See comments in `reconciling` for additional information
	// on reconciliation process in Cloud Run. Please note that unlike v1, this is
	// an int64 value. As with most Google APIs, its JSON representation will be a
	// `string` instead of an `integer`.
	ObservedGeneration int64 `json:"observedGeneration,omitempty,string"`
	// Reconciling: Output only. Returns true if the WorkerPool is currently being
	// acted upon by the system to bring it into the desired state. When a new
	// WorkerPool is created, or an existing one is updated, Cloud Run will
	// asynchronously perform all necessary steps to bring the WorkerPool to the
	// desired serving state. This process is called reconciliation. While
	// reconciliation is in process, `observed_generation`, `latest_ready_revison`,
	// `instance_split_statuses`, and `uri` will have transient values that might
	// mismatch the intended state: Once reconciliation is over (and this field is
	// false), there are two possible outcomes: reconciliation succeeded and the
	// serving state matches the WorkerPool, or there was an error, and
	// reconciliation failed. This state can be found in
	// `terminal_condition.state`. If reconciliation succeeded, the following
	// fields will match: `instance_splits` and `instance_split_statuses`,
	// `observed_generation` and `generation`, `latest_ready_revision` and
	// `latest_created_revision`. If reconciliation failed,
	// `instance_split_statuses`, `observed_generation`, and
	// `latest_ready_revision` will have the state of the last serving revision, or
	// empty for newly created WorkerPools. Additional information on the failure
	// can be found in `terminal_condition` and `conditions`.
	Reconciling bool `json:"reconciling,omitempty"`
	// SatisfiesPzs: Output only. Reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// Scaling: Optional. Specifies worker-pool-level scaling settings
	Scaling *GoogleCloudRunV2WorkerPoolScaling `json:"scaling,omitempty"`
	// Template: Required. The template used to create revisions for this
	// WorkerPool.
	Template *GoogleCloudRunV2WorkerPoolRevisionTemplate `json:"template,omitempty"`
	// TerminalCondition: Output only. The Condition of this WorkerPool, containing
	// its readiness status, and detailed error information in case it did not
	// reach a serving state. See comments in `reconciling` for additional
	// information on reconciliation process in Cloud Run.
	TerminalCondition *GoogleCloudRunV2Condition `json:"terminalCondition,omitempty"`
	// ThreatDetectionEnabled: Output only. Indicates whether Cloud Run Threat
	// Detection monitoring is enabled for the parent project of this worker pool.
	ThreatDetectionEnabled bool `json:"threatDetectionEnabled,omitempty"`
	// Uid: Output only. Server assigned unique identifier for the trigger. The
	// value is a UUID4 string and guaranteed to remain unchanged until the
	// resource is deleted.
	Uid string `json:"uid,omitempty"`
	// UpdateTime: Output only. The last-modified time.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2WorkerPool) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2WorkerPool
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2WorkerPoolRevisionTemplate: WorkerPoolRevisionTemplate
// describes the data a worker pool revision should have when created from a
// template.
type GoogleCloudRunV2WorkerPoolRevisionTemplate struct {
	// Annotations: Optional. Unstructured key value map that may be set by
	// external tools to store and arbitrary metadata. They are not queryable and
	// should be preserved when modifying objects. Cloud Run API v2 does not
	// support annotations with `run.googleapis.com`, `cloud.googleapis.com`,
	// `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they
	// will be rejected. All system annotations in v1 now have a corresponding
	// field in v2 WorkerPoolRevisionTemplate. This field follows Kubernetes
	// annotations' namespacing, limits, and rules.
	Annotations map[string]string `json:"annotations,omitempty"`
	// Containers: Holds list of the containers that defines the unit of execution
	// for this Revision.
	Containers []*GoogleCloudRunV2Container `json:"containers,omitempty"`
	// EncryptionKey: A reference to a customer managed encryption key (CMEK) to
	// use to encrypt this container image. For more information, go to
	// https://cloud.google.com/run/docs/securing/using-cmek
	EncryptionKey string `json:"encryptionKey,omitempty"`
	// EncryptionKeyRevocationAction: Optional. The action to take if the
	// encryption key is revoked.
	//
	// Possible values:
	//   "ENCRYPTION_KEY_REVOCATION_ACTION_UNSPECIFIED" - Unspecified
	//   "PREVENT_NEW" - Prevents the creation of new instances.
	//   "SHUTDOWN" - Shuts down existing instances, and prevents creation of new
	// ones.
	EncryptionKeyRevocationAction string `json:"encryptionKeyRevocationAction,omitempty"`
	// EncryptionKeyShutdownDuration: Optional. If encryption_key_revocation_action
	// is SHUTDOWN, the duration before shutting down all instances. The minimum
	// increment is 1 hour.
	EncryptionKeyShutdownDuration string `json:"encryptionKeyShutdownDuration,omitempty"`
	// GpuZonalRedundancyDisabled: Optional. True if GPU zonal redundancy is
	// disabled on this worker pool.
	GpuZonalRedundancyDisabled bool `json:"gpuZonalRedundancyDisabled,omitempty"`
	// Labels: Optional. Unstructured key value map that can be used to organize
	// and categorize objects. User-provided labels are shared with Google's
	// billing system, so they can be used to filter, or break down billing charges
	// by team, component, environment, state, etc. For more information, visit
	// https://cloud.google.com/resource-manager/docs/creating-managing-labels or
	// https://cloud.google.com/run/docs/configuring/labels. Cloud Run API v2 does
	// not support labels with `run.googleapis.com`, `cloud.googleapis.com`,
	// `serving.knative.dev`, or `autoscaling.knative.dev` namespaces, and they
	// will be rejected. All system labels in v1 now have a corresponding field in
	// v2 WorkerPoolRevisionTemplate.
	Labels map[string]string `json:"labels,omitempty"`
	// NodeSelector: Optional. The node selector for the revision template.
	NodeSelector *GoogleCloudRunV2NodeSelector `json:"nodeSelector,omitempty"`
	// Revision: Optional. The unique name for the revision. If this field is
	// omitted, it will be automatically generated based on the WorkerPool name.
	Revision string `json:"revision,omitempty"`
	// ServiceAccount: Optional. Email address of the IAM service account
	// associated with the revision of the service. The service account represents
	// the identity of the running revision, and determines what permissions the
	// revision has. If not provided, the revision will use the project's default
	// service account.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// ServiceMesh: Optional. Enables service mesh connectivity.
	ServiceMesh *GoogleCloudRunV2ServiceMesh `json:"serviceMesh,omitempty"`
	// Volumes: Optional. A list of Volumes to make available to containers.
	Volumes []*GoogleCloudRunV2Volume `json:"volumes,omitempty"`
	// VpcAccess: Optional. VPC Access configuration to use for this Revision. For
	// more information, visit
	// https://cloud.google.com/run/docs/configuring/connecting-vpc.
	VpcAccess *GoogleCloudRunV2VpcAccess `json:"vpcAccess,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Annotations") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Annotations") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2WorkerPoolRevisionTemplate) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2WorkerPoolRevisionTemplate
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleCloudRunV2WorkerPoolScaling: Worker pool scaling settings.
type GoogleCloudRunV2WorkerPoolScaling struct {
	// ManualInstanceCount: Optional. The total number of instances in manual
	// scaling mode.
	ManualInstanceCount int64 `json:"manualInstanceCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ManualInstanceCount") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ManualInstanceCount") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleCloudRunV2WorkerPoolScaling) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleCloudRunV2WorkerPoolScaling
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1ApprovalConfig: ApprovalConfig describes
// configuration for manual approval of a build.
type GoogleDevtoolsCloudbuildV1ApprovalConfig struct {
	// ApprovalRequired: Whether or not approval is needed. If this is set on a
	// build, it will become pending when created, and will need to be explicitly
	// approved to start.
	ApprovalRequired bool `json:"approvalRequired,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApprovalRequired") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApprovalRequired") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1ApprovalConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1ApprovalConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1ApprovalResult: ApprovalResult describes the
// decision and associated metadata of a manual approval of a build.
type GoogleDevtoolsCloudbuildV1ApprovalResult struct {
	// ApprovalTime: Output only. The time when the approval decision was made.
	ApprovalTime string `json:"approvalTime,omitempty"`
	// ApproverAccount: Output only. Email of the user that called the ApproveBuild
	// API to approve or reject a build at the time that the API was called.
	ApproverAccount string `json:"approverAccount,omitempty"`
	// Comment: Optional. An optional comment for this manual approval result.
	Comment string `json:"comment,omitempty"`
	// Decision: Required. The decision of this manual approval.
	//
	// Possible values:
	//   "DECISION_UNSPECIFIED" - Default enum type. This should not be used.
	//   "APPROVED" - Build is approved.
	//   "REJECTED" - Build is rejected.
	Decision string `json:"decision,omitempty"`
	// Url: Optional. An optional URL tied to this manual approval result. This
	// field is essentially the same as comment, except that it will be rendered by
	// the UI differently. An example use case is a link to an external job that
	// approved this Build.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApprovalTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApprovalTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1ApprovalResult) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1ApprovalResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1ArtifactObjects: Files in the workspace to upload
// to Cloud Storage upon successful completion of all build steps.
type GoogleDevtoolsCloudbuildV1ArtifactObjects struct {
	// Location: Cloud Storage bucket and optional object path, in the form
	// "gs://bucket/path/to/somewhere/". (see Bucket Name Requirements
	// (https://cloud.google.com/storage/docs/bucket-naming#requirements)). Files
	// in the workspace matching any path pattern will be uploaded to Cloud Storage
	// with this location as a prefix.
	Location string `json:"location,omitempty"`
	// Paths: Path globs used to match files in the build's workspace.
	Paths []string `json:"paths,omitempty"`
	// Timing: Output only. Stores timing information for pushing all artifact
	// objects.
	Timing *GoogleDevtoolsCloudbuildV1TimeSpan `json:"timing,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Location") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Location") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1ArtifactObjects) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1ArtifactObjects
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1Artifacts: Artifacts produced by a build that
// should be uploaded upon successful completion of all build steps.
type GoogleDevtoolsCloudbuildV1Artifacts struct {
	// GoModules: Optional. A list of Go modules to be uploaded to Artifact
	// Registry upon successful completion of all build steps. If any objects fail
	// to be pushed, the build is marked FAILURE.
	GoModules []*GoogleDevtoolsCloudbuildV1GoModule `json:"goModules,omitempty"`
	// Images: A list of images to be pushed upon the successful completion of all
	// build steps. The images will be pushed using the builder service account's
	// credentials. The digests of the pushed images will be stored in the Build
	// resource's results field. If any of the images fail to be pushed, the build
	// is marked FAILURE.
	Images []string `json:"images,omitempty"`
	// MavenArtifacts: A list of Maven artifacts to be uploaded to Artifact
	// Registry upon successful completion of all build steps. Artifacts in the
	// workspace matching specified paths globs will be uploaded to the specified
	// Artifact Registry repository using the builder service account's
	// credentials. If any artifacts fail to be pushed, the build is marked
	// FAILURE.
	MavenArtifacts []*GoogleDevtoolsCloudbuildV1MavenArtifact `json:"mavenArtifacts,omitempty"`
	// NpmPackages: A list of npm packages to be uploaded to Artifact Registry upon
	// successful completion of all build steps. Npm packages in the specified
	// paths will be uploaded to the specified Artifact Registry repository using
	// the builder service account's credentials. If any packages fail to be
	// pushed, the build is marked FAILURE.
	NpmPackages []*GoogleDevtoolsCloudbuildV1NpmPackage `json:"npmPackages,omitempty"`
	// Objects: A list of objects to be uploaded to Cloud Storage upon successful
	// completion of all build steps. Files in the workspace matching specified
	// paths globs will be uploaded to the specified Cloud Storage location using
	// the builder service account's credentials. The location and generation of
	// the uploaded objects will be stored in the Build resource's results field.
	// If any objects fail to be pushed, the build is marked FAILURE.
	Objects *GoogleDevtoolsCloudbuildV1ArtifactObjects `json:"objects,omitempty"`
	// PythonPackages: A list of Python packages to be uploaded to Artifact
	// Registry upon successful completion of all build steps. The build service
	// account credentials will be used to perform the upload. If any objects fail
	// to be pushed, the build is marked FAILURE.
	PythonPackages []*GoogleDevtoolsCloudbuildV1PythonPackage `json:"pythonPackages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "GoModules") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "GoModules") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1Artifacts) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1Artifacts
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1Build: A build resource in the Cloud Build API. At
// a high level, a `Build` describes where to find source code, how to build it
// (for example, the builder image to run on the source), and where to store
// the built artifacts. Fields can include the following variables, which will
// be expanded when the build is created: - $PROJECT_ID: the project ID of the
// build. - $PROJECT_NUMBER: the project number of the build. - $LOCATION: the
// location/region of the build. - $BUILD_ID: the autogenerated ID of the
// build. - $REPO_NAME: the source repository name specified by RepoSource. -
// $BRANCH_NAME: the branch name specified by RepoSource. - $TAG_NAME: the tag
// name specified by RepoSource. - $REVISION_ID or $COMMIT_SHA: the commit SHA
// specified by RepoSource or resolved from the specified branch or tag. -
// $SHORT_SHA: first 7 characters of $REVISION_ID or $COMMIT_SHA.
type GoogleDevtoolsCloudbuildV1Build struct {
	// Approval: Output only. Describes this build's approval configuration,
	// status, and result.
	Approval *GoogleDevtoolsCloudbuildV1BuildApproval `json:"approval,omitempty"`
	// Artifacts: Artifacts produced by the build that should be uploaded upon
	// successful completion of all build steps.
	Artifacts *GoogleDevtoolsCloudbuildV1Artifacts `json:"artifacts,omitempty"`
	// AvailableSecrets: Secrets and secret environment variables.
	AvailableSecrets *GoogleDevtoolsCloudbuildV1Secrets `json:"availableSecrets,omitempty"`
	// BuildTriggerId: Output only. The ID of the `BuildTrigger` that triggered
	// this build, if it was triggered automatically.
	BuildTriggerId string `json:"buildTriggerId,omitempty"`
	// CreateTime: Output only. Time at which the request to create the build was
	// received.
	CreateTime string `json:"createTime,omitempty"`
	// Dependencies: Optional. Dependencies that the Cloud Build worker will fetch
	// before executing user steps.
	Dependencies []*GoogleDevtoolsCloudbuildV1Dependency `json:"dependencies,omitempty"`
	// FailureInfo: Output only. Contains information about the build when
	// status=FAILURE.
	FailureInfo *GoogleDevtoolsCloudbuildV1FailureInfo `json:"failureInfo,omitempty"`
	// FinishTime: Output only. Time at which execution of the build was finished.
	// The difference between finish_time and start_time is the duration of the
	// build's execution.
	FinishTime string `json:"finishTime,omitempty"`
	// GitConfig: Optional. Configuration for git operations.
	GitConfig *GoogleDevtoolsCloudbuildV1GitConfig `json:"gitConfig,omitempty"`
	// Id: Output only. Unique identifier of the build.
	Id string `json:"id,omitempty"`
	// Images: A list of images to be pushed upon the successful completion of all
	// build steps. The images are pushed using the builder service account's
	// credentials. The digests of the pushed images will be stored in the `Build`
	// resource's results field. If any of the images fail to be pushed, the build
	// status is marked `FAILURE`.
	Images []string `json:"images,omitempty"`
	// LogUrl: Output only. URL to logs for this build in Google Cloud Console.
	LogUrl string `json:"logUrl,omitempty"`
	// LogsBucket: Cloud Storage bucket where logs should be written (see Bucket
	// Name Requirements
	// (https://cloud.google.com/storage/docs/bucket-naming#requirements)). Logs
	// file names will be of the format `${logs_bucket}/log-${build_id}.txt`.
	LogsBucket string `json:"logsBucket,omitempty"`
	// Name: Output only. The 'Build' name with format:
	// `projects/{project}/locations/{location}/builds/{build}`, where {build} is a
	// unique identifier generated by the service.
	Name string `json:"name,omitempty"`
	// Options: Special options for this build.
	Options *GoogleDevtoolsCloudbuildV1BuildOptions `json:"options,omitempty"`
	// ProjectId: Output only. ID of the project.
	ProjectId string `json:"projectId,omitempty"`
	// QueueTtl: TTL in queue for this build. If provided and the build is enqueued
	// longer than this value, the build will expire and the build status will be
	// `EXPIRED`. The TTL starts ticking from create_time.
	QueueTtl string `json:"queueTtl,omitempty"`
	// Results: Output only. Results of the build.
	Results *GoogleDevtoolsCloudbuildV1Results `json:"results,omitempty"`
	// Secrets: Secrets to decrypt using Cloud Key Management Service. Note: Secret
	// Manager is the recommended technique for managing sensitive data with Cloud
	// Build. Use `available_secrets` to configure builds to access secrets from
	// Secret Manager. For instructions, see:
	// https://cloud.google.com/cloud-build/docs/securing-builds/use-secrets
	Secrets []*GoogleDevtoolsCloudbuildV1Secret `json:"secrets,omitempty"`
	// ServiceAccount: IAM service account whose credentials will be used at build
	// runtime. Must be of the format
	// `projects/{PROJECT_ID}/serviceAccounts/{ACCOUNT}`. ACCOUNT can be email
	// address or uniqueId of the service account.
	ServiceAccount string `json:"serviceAccount,omitempty"`
	// Source: Optional. The location of the source files to build.
	Source *GoogleDevtoolsCloudbuildV1Source `json:"source,omitempty"`
	// SourceProvenance: Output only. A permanent fixed identifier for source.
	SourceProvenance *GoogleDevtoolsCloudbuildV1SourceProvenance `json:"sourceProvenance,omitempty"`
	// StartTime: Output only. Time at which execution of the build was started.
	StartTime string `json:"startTime,omitempty"`
	// Status: Output only. Status of the build.
	//
	// Possible values:
	//   "STATUS_UNKNOWN" - Status of the build is unknown.
	//   "PENDING" - Build has been created and is pending execution and queuing.
	// It has not been queued.
	//   "QUEUED" - Build or step is queued; work has not yet begun.
	//   "WORKING" - Build or step is being executed.
	//   "SUCCESS" - Build or step finished successfully.
	//   "FAILURE" - Build or step failed to complete successfully.
	//   "INTERNAL_ERROR" - Build or step failed due to an internal cause.
	//   "TIMEOUT" - Build or step took longer than was allowed.
	//   "CANCELLED" - Build or step was canceled by a user.
	//   "EXPIRED" - Build was enqueued for longer than the value of `queue_ttl`.
	Status string `json:"status,omitempty"`
	// StatusDetail: Output only. Customer-readable message about the current
	// status.
	StatusDetail string `json:"statusDetail,omitempty"`
	// Steps: Required. The operations to be performed on the workspace.
	Steps []*GoogleDevtoolsCloudbuildV1BuildStep `json:"steps,omitempty"`
	// Substitutions: Substitutions data for `Build` resource.
	Substitutions map[string]string `json:"substitutions,omitempty"`
	// Tags: Tags for annotation of a `Build`. These are not docker tags.
	Tags []string `json:"tags,omitempty"`
	// Timeout: Amount of time that this build should be allowed to run, to second
	// granularity. If this amount of time elapses, work on the build will cease
	// and the build status will be `TIMEOUT`. `timeout` starts ticking from
	// `startTime`. Default time is 60 minutes.
	Timeout string `json:"timeout,omitempty"`
	// Timing: Output only. Stores timing information for phases of the build.
	// Valid keys are: * BUILD: time to execute all build steps. * PUSH: time to
	// push all artifacts including docker images and non docker artifacts. *
	// FETCHSOURCE: time to fetch source. * SETUPBUILD: time to set up build. If
	// the build does not specify source or images, these keys will not be
	// included.
	Timing map[string]GoogleDevtoolsCloudbuildV1TimeSpan `json:"timing,omitempty"`
	// Warnings: Output only. Non-fatal problems encountered during the execution
	// of the build.
	Warnings []*GoogleDevtoolsCloudbuildV1Warning `json:"warnings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Approval") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Approval") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1Build) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1Build
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1BuildApproval: BuildApproval describes a build's
// approval configuration, state, and result.
type GoogleDevtoolsCloudbuildV1BuildApproval struct {
	// Config: Output only. Configuration for manual approval of this build.
	Config *GoogleDevtoolsCloudbuildV1ApprovalConfig `json:"config,omitempty"`
	// Result: Output only. Result of manual approval for this Build.
	Result *GoogleDevtoolsCloudbuildV1ApprovalResult `json:"result,omitempty"`
	// State: Output only. The state of this build's approval.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Default enum type. This should not be used.
	//   "PENDING" - Build approval is pending.
	//   "APPROVED" - Build approval has been approved.
	//   "REJECTED" - Build approval has been rejected.
	//   "CANCELLED" - Build was cancelled while it was still pending approval.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Config") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Config") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1BuildApproval) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1BuildApproval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1BuildOperationMetadata: Metadata for build
// operations.
type GoogleDevtoolsCloudbuildV1BuildOperationMetadata struct {
	// Build: The build that the operation is tracking.
	Build *GoogleDevtoolsCloudbuildV1Build `json:"build,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Build") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Build") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1BuildOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1BuildOperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1BuildOptions: Optional arguments to enable
// specific features of builds.
type GoogleDevtoolsCloudbuildV1BuildOptions struct {
	// AutomapSubstitutions: Option to include built-in and custom substitutions as
	// env variables for all build steps.
	AutomapSubstitutions bool `json:"automapSubstitutions,omitempty"`
	// DefaultLogsBucketBehavior: Optional. Option to specify how default logs
	// buckets are setup.
	//
	// Possible values:
	//   "DEFAULT_LOGS_BUCKET_BEHAVIOR_UNSPECIFIED" - Unspecified.
	//   "REGIONAL_USER_OWNED_BUCKET" - Bucket is located in user-owned project in
	// the same region as the build. The builder service account must have access
	// to create and write to Cloud Storage buckets in the build project.
	//   "LEGACY_BUCKET" - Bucket is located in a Google-owned project and is not
	// regionalized.
	DefaultLogsBucketBehavior string `json:"defaultLogsBucketBehavior,omitempty"`
	// DiskSizeGb: Requested disk size for the VM that runs the build. Note that
	// this is *NOT* "disk free"; some of the space will be used by the operating
	// system and build utilities. Also note that this is the minimum disk size
	// that will be allocated for the build -- the build may run with a larger disk
	// than requested. At present, the maximum disk size is 4000GB; builds that
	// request more than the maximum are rejected with an error.
	DiskSizeGb int64 `json:"diskSizeGb,omitempty,string"`
	// DynamicSubstitutions: Option to specify whether or not to apply bash style
	// string operations to the substitutions. NOTE: this is always enabled for
	// triggered builds and cannot be overridden in the build configuration file.
	DynamicSubstitutions bool `json:"dynamicSubstitutions,omitempty"`
	// EnableStructuredLogging: Optional. Option to specify whether structured
	// logging is enabled. If true, JSON-formatted logs are parsed as structured
	// logs.
	EnableStructuredLogging bool `json:"enableStructuredLogging,omitempty"`
	// Env: A list of global environment variable definitions that will exist for
	// all build steps in this build. If a variable is defined in both globally and
	// in a build step, the variable will use the build step value. The elements
	// are of the form "KEY=VALUE" for the environment variable "KEY" being given
	// the value "VALUE".
	Env []string `json:"env,omitempty"`
	// LogStreamingOption: Option to define build log streaming behavior to Cloud
	// Storage.
	//
	// Possible values:
	//   "STREAM_DEFAULT" - Service may automatically determine build log streaming
	// behavior.
	//   "STREAM_ON" - Build logs should be streamed to Cloud Storage.
	//   "STREAM_OFF" - Build logs should not be streamed to Cloud Storage; they
	// will be written when the build is completed.
	LogStreamingOption string `json:"logStreamingOption,omitempty"`
	// Logging: Option to specify the logging mode, which determines if and where
	// build logs are stored.
	//
	// Possible values:
	//   "LOGGING_UNSPECIFIED" - The service determines the logging mode. The
	// default is `LEGACY`. Do not rely on the default logging behavior as it may
	// change in the future.
	//   "LEGACY" - Build logs are stored in Cloud Logging and Cloud Storage.
	//   "GCS_ONLY" - Build logs are stored in Cloud Storage.
	//   "STACKDRIVER_ONLY" - This option is the same as CLOUD_LOGGING_ONLY.
	//   "CLOUD_LOGGING_ONLY" - Build logs are stored in Cloud Logging. Selecting
	// this option will not allow [logs
	// streaming](https://cloud.google.com/sdk/gcloud/reference/builds/log).
	//   "NONE" - Turn off all logging. No build logs will be captured.
	Logging string `json:"logging,omitempty"`
	// MachineType: Compute Engine machine type on which to run the build.
	//
	// Possible values:
	//   "UNSPECIFIED" - Standard machine type.
	//   "N1_HIGHCPU_8" - Highcpu machine with 8 CPUs.
	//   "N1_HIGHCPU_32" - Highcpu machine with 32 CPUs.
	//   "E2_HIGHCPU_8" - Highcpu e2 machine with 8 CPUs.
	//   "E2_HIGHCPU_32" - Highcpu e2 machine with 32 CPUs.
	//   "E2_MEDIUM" - E2 machine with 1 CPU.
	MachineType string `json:"machineType,omitempty"`
	// Pool: Optional. Specification for execution on a `WorkerPool`. See running
	// builds in a private pool
	// (https://cloud.google.com/build/docs/private-pools/run-builds-in-private-pool)
	// for more information.
	Pool *GoogleDevtoolsCloudbuildV1PoolOption `json:"pool,omitempty"`
	// PubsubTopic: Optional. Option to specify the Pub/Sub topic to receive build
	// status updates.
	PubsubTopic string `json:"pubsubTopic,omitempty"`
	// RequestedVerifyOption: Requested verifiability options.
	//
	// Possible values:
	//   "NOT_VERIFIED" - Not a verifiable build (the default).
	//   "VERIFIED" - Build must be verified.
	RequestedVerifyOption string `json:"requestedVerifyOption,omitempty"`
	// SecretEnv: A list of global environment variables, which are encrypted using
	// a Cloud Key Management Service crypto key. These values must be specified in
	// the build's `Secret`. These variables will be available to all build steps
	// in this build.
	SecretEnv []string `json:"secretEnv,omitempty"`
	// SourceProvenanceHash: Requested hash for SourceProvenance.
	//
	// Possible values:
	//   "NONE" - No hash requested.
	//   "SHA256" - Use a sha256 hash.
	//   "MD5" - Use a md5 hash.
	//   "GO_MODULE_H1" - Dirhash of a Go module's source code which is then
	// hex-encoded.
	//   "SHA512" - Use a sha512 hash.
	SourceProvenanceHash []string `json:"sourceProvenanceHash,omitempty"`
	// SubstitutionOption: Option to specify behavior when there is an error in the
	// substitution checks. NOTE: this is always set to ALLOW_LOOSE for triggered
	// builds and cannot be overridden in the build configuration file.
	//
	// Possible values:
	//   "MUST_MATCH" - Fails the build if error in substitutions checks, like
	// missing a substitution in the template or in the map.
	//   "ALLOW_LOOSE" - Do not fail the build if error in substitutions checks.
	SubstitutionOption string `json:"substitutionOption,omitempty"`
	// Volumes: Global list of volumes to mount for ALL build steps Each volume is
	// created as an empty volume prior to starting the build process. Upon
	// completion of the build, volumes and their contents are discarded. Global
	// volume names and paths cannot conflict with the volumes defined a build
	// step. Using a global volume in a build with only one step is not valid as it
	// is indicative of a build request with an incorrect configuration.
	Volumes []*GoogleDevtoolsCloudbuildV1Volume `json:"volumes,omitempty"`
	// WorkerPool: This field deprecated; please use `pool.name` instead.
	WorkerPool string `json:"workerPool,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutomapSubstitutions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutomapSubstitutions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1BuildOptions) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1BuildOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1BuildStep: A step in the build pipeline.
type GoogleDevtoolsCloudbuildV1BuildStep struct {
	// AllowExitCodes: Allow this build step to fail without failing the entire
	// build if and only if the exit code is one of the specified codes. If
	// allow_failure is also specified, this field will take precedence.
	AllowExitCodes []int64 `json:"allowExitCodes,omitempty"`
	// AllowFailure: Allow this build step to fail without failing the entire
	// build. If false, the entire build will fail if this step fails. Otherwise,
	// the build will succeed, but this step will still have a failure status.
	// Error information will be reported in the failure_detail field.
	AllowFailure bool `json:"allowFailure,omitempty"`
	// Args: A list of arguments that will be presented to the step when it is
	// started. If the image used to run the step's container has an entrypoint,
	// the `args` are used as arguments to that entrypoint. If the image does not
	// define an entrypoint, the first element in args is used as the entrypoint,
	// and the remainder will be used as arguments.
	Args []string `json:"args,omitempty"`
	// AutomapSubstitutions: Option to include built-in and custom substitutions as
	// env variables for this build step. This option will override the global
	// option in BuildOption.
	AutomapSubstitutions bool `json:"automapSubstitutions,omitempty"`
	// Dir: Working directory to use when running this step's container. If this
	// value is a relative path, it is relative to the build's working directory.
	// If this value is absolute, it may be outside the build's working directory,
	// in which case the contents of the path may not be persisted across build
	// step executions, unless a `volume` for that path is specified. If the build
	// specifies a `RepoSource` with `dir` and a step with a `dir`, which specifies
	// an absolute path, the `RepoSource` `dir` is ignored for the step's
	// execution.
	Dir string `json:"dir,omitempty"`
	// Entrypoint: Entrypoint to be used instead of the build step image's default
	// entrypoint. If unset, the image's default entrypoint is used.
	Entrypoint string `json:"entrypoint,omitempty"`
	// Env: A list of environment variable definitions to be used when running a
	// step. The elements are of the form "KEY=VALUE" for the environment variable
	// "KEY" being given the value "VALUE".
	Env []string `json:"env,omitempty"`
	// ExitCode: Output only. Return code from running the step.
	ExitCode int64 `json:"exitCode,omitempty"`
	// Id: Unique identifier for this build step, used in `wait_for` to reference
	// this build step as a dependency.
	Id string `json:"id,omitempty"`
	// Name: Required. The name of the container image that will run this
	// particular build step. If the image is available in the host's Docker
	// daemon's cache, it will be run directly. If not, the host will attempt to
	// pull the image first, using the builder service account's credentials if
	// necessary. The Docker daemon's cache will already have the latest versions
	// of all of the officially supported build steps
	// (https://github.com/GoogleCloudPlatform/cloud-builders
	// (https://github.com/GoogleCloudPlatform/cloud-builders)). The Docker daemon
	// will also have cached many of the layers for some popular images, like
	// "ubuntu", "debian", but they will be refreshed at the time you attempt to
	// use them. If you built an image in a previous build step, it will be stored
	// in the host's Docker daemon's cache and is available to use as the name for
	// a later build step.
	Name string `json:"name,omitempty"`
	// PullTiming: Output only. Stores timing information for pulling this build
	// step's builder image only.
	PullTiming *GoogleDevtoolsCloudbuildV1TimeSpan `json:"pullTiming,omitempty"`
	// Script: A shell script to be executed in the step. When script is provided,
	// the user cannot specify the entrypoint or args.
	Script string `json:"script,omitempty"`
	// SecretEnv: A list of environment variables which are encrypted using a Cloud
	// Key Management Service crypto key. These values must be specified in the
	// build's `Secret`.
	SecretEnv []string `json:"secretEnv,omitempty"`
	// Status: Output only. Status of the build step. At this time, build step
	// status is only updated on build completion; step status is not updated in
	// real-time as the build progresses.
	//
	// Possible values:
	//   "STATUS_UNKNOWN" - Status of the build is unknown.
	//   "PENDING" - Build has been created and is pending execution and queuing.
	// It has not been queued.
	//   "QUEUED" - Build or step is queued; work has not yet begun.
	//   "WORKING" - Build or step is being executed.
	//   "SUCCESS" - Build or step finished successfully.
	//   "FAILURE" - Build or step failed to complete successfully.
	//   "INTERNAL_ERROR" - Build or step failed due to an internal cause.
	//   "TIMEOUT" - Build or step took longer than was allowed.
	//   "CANCELLED" - Build or step was canceled by a user.
	//   "EXPIRED" - Build was enqueued for longer than the value of `queue_ttl`.
	Status string `json:"status,omitempty"`
	// Timeout: Time limit for executing this build step. If not defined, the step
	// has no time limit and will be allowed to continue to run until either it
	// completes or the build itself times out.
	Timeout string `json:"timeout,omitempty"`
	// Timing: Output only. Stores timing information for executing this build
	// step.
	Timing *GoogleDevtoolsCloudbuildV1TimeSpan `json:"timing,omitempty"`
	// Volumes: List of volumes to mount into the build step. Each volume is
	// created as an empty volume prior to execution of the build step. Upon
	// completion of the build, volumes and their contents are discarded. Using a
	// named volume in only one step is not valid as it is indicative of a build
	// request with an incorrect configuration.
	Volumes []*GoogleDevtoolsCloudbuildV1Volume `json:"volumes,omitempty"`
	// WaitFor: The ID(s) of the step(s) that this build step depends on. This
	// build step will not start until all the build steps in `wait_for` have
	// completed successfully. If `wait_for` is empty, this build step will start
	// when all previous build steps in the `Build.Steps` list have completed
	// successfully.
	WaitFor []string `json:"waitFor,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowExitCodes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowExitCodes") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1BuildStep) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1BuildStep
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1BuiltImage: An image built by the pipeline.
type GoogleDevtoolsCloudbuildV1BuiltImage struct {
	// ArtifactRegistryPackage: Output only. Path to the artifact in Artifact
	// Registry.
	ArtifactRegistryPackage string `json:"artifactRegistryPackage,omitempty"`
	// Digest: Docker Registry 2.0 digest.
	Digest string `json:"digest,omitempty"`
	// Name: Name used to push the container image to Google Container Registry, as
	// presented to `docker push`.
	Name string `json:"name,omitempty"`
	// PushTiming: Output only. Stores timing information for pushing the specified
	// image.
	PushTiming *GoogleDevtoolsCloudbuildV1TimeSpan `json:"pushTiming,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArtifactRegistryPackage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArtifactRegistryPackage") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1BuiltImage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1BuiltImage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1ConnectedRepository: Location of the source in a
// 2nd-gen Google Cloud Build repository resource.
type GoogleDevtoolsCloudbuildV1ConnectedRepository struct {
	// Dir: Optional. Directory, relative to the source root, in which to run the
	// build.
	Dir string `json:"dir,omitempty"`
	// Repository: Required. Name of the Google Cloud Build repository, formatted
	// as `projects/*/locations/*/connections/*/repositories/*`.
	Repository string `json:"repository,omitempty"`
	// Revision: Required. The revision to fetch from the Git repository such as a
	// branch, a tag, a commit SHA, or any Git ref.
	Revision string `json:"revision,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dir") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dir") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1ConnectedRepository) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1ConnectedRepository
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1Dependency: A dependency that the Cloud Build
// worker will fetch before executing user steps.
type GoogleDevtoolsCloudbuildV1Dependency struct {
	// Empty: If set to true disable all dependency fetching (ignoring the default
	// source as well).
	Empty bool `json:"empty,omitempty"`
	// GitSource: Represents a git repository as a build dependency.
	GitSource *GoogleDevtoolsCloudbuildV1GitSourceDependency `json:"gitSource,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Empty") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Empty") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1Dependency) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1Dependency
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1DeveloperConnectConfig: This config defines the
// location of a source through Developer Connect.
type GoogleDevtoolsCloudbuildV1DeveloperConnectConfig struct {
	// Dir: Required. Directory, relative to the source root, in which to run the
	// build.
	Dir string `json:"dir,omitempty"`
	// GitRepositoryLink: Required. The Developer Connect Git repository link,
	// formatted as `projects/*/locations/*/connections/*/gitRepositoryLink/*`.
	GitRepositoryLink string `json:"gitRepositoryLink,omitempty"`
	// Revision: Required. The revision to fetch from the Git repository such as a
	// branch, a tag, a commit SHA, or any Git ref.
	Revision string `json:"revision,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dir") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dir") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1DeveloperConnectConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1DeveloperConnectConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1FailureInfo: A fatal problem encountered during
// the execution of the build.
type GoogleDevtoolsCloudbuildV1FailureInfo struct {
	// Detail: Explains the failure issue in more detail using hard-coded text.
	Detail string `json:"detail,omitempty"`
	// Type: The name of the failure.
	//
	// Possible values:
	//   "FAILURE_TYPE_UNSPECIFIED" - Type unspecified
	//   "PUSH_FAILED" - Unable to push the image to the repository.
	//   "PUSH_IMAGE_NOT_FOUND" - Final image not found.
	//   "PUSH_NOT_AUTHORIZED" - Unauthorized push of the final image.
	//   "LOGGING_FAILURE" - Backend logging failures. Should retry.
	//   "USER_BUILD_STEP" - A build step has failed.
	//   "FETCH_SOURCE_FAILED" - The source fetching has failed.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Detail") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Detail") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1FailureInfo) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1FailureInfo
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1FileHashes: Container message for hashes of byte
// content of files, used in SourceProvenance messages to verify integrity of
// source input to the build.
type GoogleDevtoolsCloudbuildV1FileHashes struct {
	// FileHash: Collection of file hashes.
	FileHash []*GoogleDevtoolsCloudbuildV1Hash `json:"fileHash,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileHash") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileHash") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1FileHashes) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1FileHashes
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1GitConfig: GitConfig is a configuration for git
// operations.
type GoogleDevtoolsCloudbuildV1GitConfig struct {
	// Http: Configuration for HTTP related git operations.
	Http *GoogleDevtoolsCloudbuildV1HttpConfig `json:"http,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Http") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Http") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1GitConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1GitConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1GitSource: Location of the source in any
// accessible Git repository.
type GoogleDevtoolsCloudbuildV1GitSource struct {
	// Dir: Optional. Directory, relative to the source root, in which to run the
	// build. This must be a relative path. If a step's `dir` is specified and is
	// an absolute path, this value is ignored for that step's execution.
	Dir string `json:"dir,omitempty"`
	// Revision: Optional. The revision to fetch from the Git repository such as a
	// branch, a tag, a commit SHA, or any Git ref. Cloud Build uses `git fetch` to
	// fetch the revision from the Git repository; therefore make sure that the
	// string you provide for `revision` is parsable by the command. For
	// information on string values accepted by `git fetch`, see
	// https://git-scm.com/docs/gitrevisions#_specifying_revisions. For information
	// on `git fetch`, see https://git-scm.com/docs/git-fetch.
	Revision string `json:"revision,omitempty"`
	// Url: Required. Location of the Git repo to build. This will be used as a
	// `git remote`, see https://git-scm.com/docs/git-remote.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Dir") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Dir") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1GitSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1GitSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1GitSourceDependency: Represents a git repository
// as a build dependency.
type GoogleDevtoolsCloudbuildV1GitSourceDependency struct {
	// Depth: Optional. How much history should be fetched for the build (default
	// 1, -1 for all history).
	Depth int64 `json:"depth,omitempty,string"`
	// DestPath: Required. Where should the files be placed on the worker.
	DestPath string `json:"destPath,omitempty"`
	// RecurseSubmodules: Optional. True if submodules should be fetched too
	// (default false).
	RecurseSubmodules bool `json:"recurseSubmodules,omitempty"`
	// Repository: Required. The kind of repo (url or dev connect).
	Repository *GoogleDevtoolsCloudbuildV1GitSourceRepository `json:"repository,omitempty"`
	// Revision: Required. The revision that we will fetch the repo at.
	Revision string `json:"revision,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Depth") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Depth") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1GitSourceDependency) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1GitSourceDependency
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1GitSourceRepository: A repository for a git
// source.
type GoogleDevtoolsCloudbuildV1GitSourceRepository struct {
	// DeveloperConnect: The Developer Connect Git repository link formatted as
	// `projects/*/locations/*/connections/*/gitRepositoryLink/*`
	DeveloperConnect string `json:"developerConnect,omitempty"`
	// Url: Location of the Git repository.
	Url string `json:"url,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DeveloperConnect") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DeveloperConnect") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1GitSourceRepository) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1GitSourceRepository
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1GoModule: Go module to upload to Artifact Registry
// upon successful completion of all build steps. A module refers to all
// dependencies in a go.mod file.
type GoogleDevtoolsCloudbuildV1GoModule struct {
	// ModulePath: Optional. The Go module's "module path". e.g. example.com/foo/v2
	ModulePath string `json:"modulePath,omitempty"`
	// ModuleVersion: Optional. The Go module's semantic version in the form
	// vX.Y.Z. e.g. v0.1.1 Pre-release identifiers can also be added by appending a
	// dash and dot separated ASCII alphanumeric characters and hyphens. e.g.
	// v0.2.3-alpha.x.12m.5
	ModuleVersion string `json:"moduleVersion,omitempty"`
	// RepositoryLocation: Optional. Location of the Artifact Registry repository.
	// i.e. us-east1 Defaults to the build’s location.
	RepositoryLocation string `json:"repositoryLocation,omitempty"`
	// RepositoryName: Optional. Artifact Registry repository name. Specified Go
	// modules will be zipped and uploaded to Artifact Registry with this location
	// as a prefix. e.g. my-go-repo
	RepositoryName string `json:"repositoryName,omitempty"`
	// RepositoryProjectId: Optional. Project ID of the Artifact Registry
	// repository. Defaults to the build project.
	RepositoryProjectId string `json:"repositoryProjectId,omitempty"`
	// SourcePath: Optional. Source path of the go.mod file in the build's
	// workspace. If not specified, this will default to the current directory.
	// e.g. ~/code/go/mypackage
	SourcePath string `json:"sourcePath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ModulePath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ModulePath") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1GoModule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1GoModule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1Hash: Container message for hash values.
type GoogleDevtoolsCloudbuildV1Hash struct {
	// Type: The type of hash that was performed.
	//
	// Possible values:
	//   "NONE" - No hash requested.
	//   "SHA256" - Use a sha256 hash.
	//   "MD5" - Use a md5 hash.
	//   "GO_MODULE_H1" - Dirhash of a Go module's source code which is then
	// hex-encoded.
	//   "SHA512" - Use a sha512 hash.
	Type string `json:"type,omitempty"`
	// Value: The hash value.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Type") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Type") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1Hash) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1Hash
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1HttpConfig: HttpConfig is a configuration for HTTP
// related git operations.
type GoogleDevtoolsCloudbuildV1HttpConfig struct {
	// ProxySecretVersionName: SecretVersion resource of the HTTP proxy URL. The
	// Service Account used in the build (either the default Service Account or
	// user-specified Service Account) should have `secretmanager.versions.access`
	// permissions on this secret. The proxy URL should be in format
	// `protocol://@]proxyhost[:port]`.
	ProxySecretVersionName string `json:"proxySecretVersionName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ProxySecretVersionName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ProxySecretVersionName") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1HttpConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1HttpConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1InlineSecret: Pairs a set of secret environment
// variables mapped to encrypted values with the Cloud KMS key to use to
// decrypt the value.
type GoogleDevtoolsCloudbuildV1InlineSecret struct {
	// EnvMap: Map of environment variable name to its encrypted value. Secret
	// environment variables must be unique across all of a build's secrets, and
	// must be used by at least one build step. Values can be at most 64 KB in
	// size. There can be at most 100 secret values across all of a build's
	// secrets.
	EnvMap map[string]string `json:"envMap,omitempty"`
	// KmsKeyName: Resource name of Cloud KMS crypto key to decrypt the encrypted
	// value. In format: projects/*/locations/*/keyRings/*/cryptoKeys/*
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EnvMap") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EnvMap") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1InlineSecret) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1InlineSecret
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1MavenArtifact: A Maven artifact to upload to
// Artifact Registry upon successful completion of all build steps.
type GoogleDevtoolsCloudbuildV1MavenArtifact struct {
	// ArtifactId: Maven `artifactId` value used when uploading the artifact to
	// Artifact Registry.
	ArtifactId string `json:"artifactId,omitempty"`
	// DeployFolder: Optional. Path to a folder containing the files to upload to
	// Artifact Registry. This can be either an absolute path, e.g.
	// `/workspace/my-app/target/`, or a relative path from /workspace, e.g.
	// `my-app/target/`. This field is mutually exclusive with the `path` field.
	DeployFolder string `json:"deployFolder,omitempty"`
	// GroupId: Maven `groupId` value used when uploading the artifact to Artifact
	// Registry.
	GroupId string `json:"groupId,omitempty"`
	// Path: Optional. Path to an artifact in the build's workspace to be uploaded
	// to Artifact Registry. This can be either an absolute path, e.g.
	// /workspace/my-app/target/my-app-1.0.SNAPSHOT.jar or a relative path from
	// /workspace, e.g. my-app/target/my-app-1.0.SNAPSHOT.jar.
	Path string `json:"path,omitempty"`
	// Repository: Artifact Registry repository, in the form
	// "https://$REGION-maven.pkg.dev/$PROJECT/$REPOSITORY" Artifact in the
	// workspace specified by path will be uploaded to Artifact Registry with this
	// location as a prefix.
	Repository string `json:"repository,omitempty"`
	// Version: Maven `version` value used when uploading the artifact to Artifact
	// Registry.
	Version string `json:"version,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArtifactId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArtifactId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1MavenArtifact) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1MavenArtifact
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1NpmPackage: Npm package to upload to Artifact
// Registry upon successful completion of all build steps.
type GoogleDevtoolsCloudbuildV1NpmPackage struct {
	// PackagePath: Optional. Path to the package.json. e.g.
	// workspace/path/to/package Only one of `archive` or `package_path` can be
	// specified.
	PackagePath string `json:"packagePath,omitempty"`
	// Repository: Artifact Registry repository, in the form
	// "https://$REGION-npm.pkg.dev/$PROJECT/$REPOSITORY" Npm package in the
	// workspace specified by path will be zipped and uploaded to Artifact Registry
	// with this location as a prefix.
	Repository string `json:"repository,omitempty"`
	// ForceSendFields is a list of field names (e.g. "PackagePath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "PackagePath") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1NpmPackage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1NpmPackage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1PoolOption: Details about how a build should be
// executed on a `WorkerPool`. See running builds in a private pool
// (https://cloud.google.com/build/docs/private-pools/run-builds-in-private-pool)
// for more information.
type GoogleDevtoolsCloudbuildV1PoolOption struct {
	// Name: The `WorkerPool` resource to execute the build on. You must have
	// `cloudbuild.workerpools.use` on the project hosting the WorkerPool. Format
	// projects/{project}/locations/{location}/workerPools/{workerPoolId}
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1PoolOption) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1PoolOption
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1PythonPackage: Python package to upload to
// Artifact Registry upon successful completion of all build steps. A package
// can encapsulate multiple objects to be uploaded to a single repository.
type GoogleDevtoolsCloudbuildV1PythonPackage struct {
	// Paths: Path globs used to match files in the build's workspace. For Python/
	// Twine, this is usually `dist/*`, and sometimes additionally an `.asc` file.
	Paths []string `json:"paths,omitempty"`
	// Repository: Artifact Registry repository, in the form
	// "https://$REGION-python.pkg.dev/$PROJECT/$REPOSITORY" Files in the workspace
	// matching any path pattern will be uploaded to Artifact Registry with this
	// location as a prefix.
	Repository string `json:"repository,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Paths") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Paths") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1PythonPackage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1PythonPackage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1RepoSource: Location of the source in a Google
// Cloud Source Repository.
type GoogleDevtoolsCloudbuildV1RepoSource struct {
	// BranchName: Regex matching branches to build. The syntax of the regular
	// expressions accepted is the syntax accepted by RE2 and described at
	// https://github.com/google/re2/wiki/Syntax
	BranchName string `json:"branchName,omitempty"`
	// CommitSha: Explicit commit SHA to build.
	CommitSha string `json:"commitSha,omitempty"`
	// Dir: Optional. Directory, relative to the source root, in which to run the
	// build. This must be a relative path. If a step's `dir` is specified and is
	// an absolute path, this value is ignored for that step's execution.
	Dir string `json:"dir,omitempty"`
	// InvertRegex: Optional. Only trigger a build if the revision regex does NOT
	// match the revision regex.
	InvertRegex bool `json:"invertRegex,omitempty"`
	// ProjectId: Optional. ID of the project that owns the Cloud Source
	// Repository. If omitted, the project ID requesting the build is assumed.
	ProjectId string `json:"projectId,omitempty"`
	// RepoName: Required. Name of the Cloud Source Repository.
	RepoName string `json:"repoName,omitempty"`
	// Substitutions: Optional. Substitutions to use in a triggered build. Should
	// only be used with RunBuildTrigger
	Substitutions map[string]string `json:"substitutions,omitempty"`
	// TagName: Regex matching tags to build. The syntax of the regular expressions
	// accepted is the syntax accepted by RE2 and described at
	// https://github.com/google/re2/wiki/Syntax
	TagName string `json:"tagName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BranchName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BranchName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1RepoSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1RepoSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1Results: Artifacts created by the build pipeline.
type GoogleDevtoolsCloudbuildV1Results struct {
	// ArtifactManifest: Path to the artifact manifest for non-container artifacts
	// uploaded to Cloud Storage. Only populated when artifacts are uploaded to
	// Cloud Storage.
	ArtifactManifest string `json:"artifactManifest,omitempty"`
	// ArtifactTiming: Time to push all non-container artifacts to Cloud Storage.
	ArtifactTiming *GoogleDevtoolsCloudbuildV1TimeSpan `json:"artifactTiming,omitempty"`
	// BuildStepImages: List of build step digests, in the order corresponding to
	// build step indices.
	BuildStepImages []string `json:"buildStepImages,omitempty"`
	// BuildStepOutputs: List of build step outputs, produced by builder images, in
	// the order corresponding to build step indices. Cloud Builders
	// (https://cloud.google.com/cloud-build/docs/cloud-builders) can produce this
	// output by writing to `$BUILDER_OUTPUT/output`. Only the first 50KB of data
	// is stored. Note that the `$BUILDER_OUTPUT` variable is read-only and can't
	// be substituted.
	BuildStepOutputs []string `json:"buildStepOutputs,omitempty"`
	// GoModules: Optional. Go module artifacts uploaded to Artifact Registry at
	// the end of the build.
	GoModules []*GoogleDevtoolsCloudbuildV1UploadedGoModule `json:"goModules,omitempty"`
	// Images: Container images that were built as a part of the build.
	Images []*GoogleDevtoolsCloudbuildV1BuiltImage `json:"images,omitempty"`
	// MavenArtifacts: Maven artifacts uploaded to Artifact Registry at the end of
	// the build.
	MavenArtifacts []*GoogleDevtoolsCloudbuildV1UploadedMavenArtifact `json:"mavenArtifacts,omitempty"`
	// NpmPackages: Npm packages uploaded to Artifact Registry at the end of the
	// build.
	NpmPackages []*GoogleDevtoolsCloudbuildV1UploadedNpmPackage `json:"npmPackages,omitempty"`
	// NumArtifacts: Number of non-container artifacts uploaded to Cloud Storage.
	// Only populated when artifacts are uploaded to Cloud Storage.
	NumArtifacts int64 `json:"numArtifacts,omitempty,string"`
	// PythonPackages: Python artifacts uploaded to Artifact Registry at the end of
	// the build.
	PythonPackages []*GoogleDevtoolsCloudbuildV1UploadedPythonPackage `json:"pythonPackages,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArtifactManifest") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArtifactManifest") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1Results) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1Results
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1Secret: Pairs a set of secret environment
// variables containing encrypted values with the Cloud KMS key to use to
// decrypt the value. Note: Use `kmsKeyName` with `available_secrets` instead
// of using `kmsKeyName` with `secret`. For instructions see:
// https://cloud.google.com/cloud-build/docs/securing-builds/use-encrypted-credentials.
type GoogleDevtoolsCloudbuildV1Secret struct {
	// KmsKeyName: Cloud KMS key name to use to decrypt these envs.
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// SecretEnv: Map of environment variable name to its encrypted value. Secret
	// environment variables must be unique across all of a build's secrets, and
	// must be used by at least one build step. Values can be at most 64 KB in
	// size. There can be at most 100 secret values across all of a build's
	// secrets.
	SecretEnv map[string]string `json:"secretEnv,omitempty"`
	// ForceSendFields is a list of field names (e.g. "KmsKeyName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "KmsKeyName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1Secret) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1Secret
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1SecretManagerSecret: Pairs a secret environment
// variable with a SecretVersion in Secret Manager.
type GoogleDevtoolsCloudbuildV1SecretManagerSecret struct {
	// Env: Environment variable name to associate with the secret. Secret
	// environment variables must be unique across all of a build's secrets, and
	// must be used by at least one build step.
	Env string `json:"env,omitempty"`
	// VersionName: Resource name of the SecretVersion. In format:
	// projects/*/secrets/*/versions/*
	VersionName string `json:"versionName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Env") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Env") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1SecretManagerSecret) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1SecretManagerSecret
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1Secrets: Secrets and secret environment variables.
type GoogleDevtoolsCloudbuildV1Secrets struct {
	// Inline: Secrets encrypted with KMS key and the associated secret environment
	// variable.
	Inline []*GoogleDevtoolsCloudbuildV1InlineSecret `json:"inline,omitempty"`
	// SecretManager: Secrets in Secret Manager and associated secret environment
	// variable.
	SecretManager []*GoogleDevtoolsCloudbuildV1SecretManagerSecret `json:"secretManager,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Inline") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Inline") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1Secrets) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1Secrets
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1Source: Location of the source in a supported
// storage service.
type GoogleDevtoolsCloudbuildV1Source struct {
	// ConnectedRepository: Optional. If provided, get the source from this 2nd-gen
	// Google Cloud Build repository resource.
	ConnectedRepository *GoogleDevtoolsCloudbuildV1ConnectedRepository `json:"connectedRepository,omitempty"`
	// DeveloperConnectConfig: If provided, get the source from this Developer
	// Connect config.
	DeveloperConnectConfig *GoogleDevtoolsCloudbuildV1DeveloperConnectConfig `json:"developerConnectConfig,omitempty"`
	// GitSource: If provided, get the source from this Git repository.
	GitSource *GoogleDevtoolsCloudbuildV1GitSource `json:"gitSource,omitempty"`
	// RepoSource: If provided, get the source from this location in a Cloud Source
	// Repository.
	RepoSource *GoogleDevtoolsCloudbuildV1RepoSource `json:"repoSource,omitempty"`
	// StorageSource: If provided, get the source from this location in Cloud
	// Storage.
	StorageSource *GoogleDevtoolsCloudbuildV1StorageSource `json:"storageSource,omitempty"`
	// StorageSourceManifest: If provided, get the source from this manifest in
	// Cloud Storage. This feature is in Preview; see description here
	// (https://github.com/GoogleCloudPlatform/cloud-builders/tree/master/gcs-fetcher).
	StorageSourceManifest *GoogleDevtoolsCloudbuildV1StorageSourceManifest `json:"storageSourceManifest,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectedRepository") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectedRepository") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1Source) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1Source
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1SourceProvenance: Provenance of the source. Ways
// to find the original source, or verify that some source was used for this
// build.
type GoogleDevtoolsCloudbuildV1SourceProvenance struct {
	// FileHashes: Output only. Hash(es) of the build source, which can be used to
	// verify that the original source integrity was maintained in the build. Note
	// that `FileHashes` will only be populated if `BuildOptions` has requested a
	// `SourceProvenanceHash`. The keys to this map are file paths used as build
	// source and the values contain the hash values for those files. If the build
	// source came in a single package such as a gzipped tarfile (`.tar.gz`), the
	// `FileHash` will be for the single path to that file.
	FileHashes map[string]GoogleDevtoolsCloudbuildV1FileHashes `json:"fileHashes,omitempty"`
	// ResolvedConnectedRepository: Output only. A copy of the build's
	// `source.connected_repository`, if exists, with any revisions resolved.
	ResolvedConnectedRepository *GoogleDevtoolsCloudbuildV1ConnectedRepository `json:"resolvedConnectedRepository,omitempty"`
	// ResolvedGitSource: Output only. A copy of the build's `source.git_source`,
	// if exists, with any revisions resolved.
	ResolvedGitSource *GoogleDevtoolsCloudbuildV1GitSource `json:"resolvedGitSource,omitempty"`
	// ResolvedRepoSource: A copy of the build's `source.repo_source`, if exists,
	// with any revisions resolved.
	ResolvedRepoSource *GoogleDevtoolsCloudbuildV1RepoSource `json:"resolvedRepoSource,omitempty"`
	// ResolvedStorageSource: A copy of the build's `source.storage_source`, if
	// exists, with any generations resolved.
	ResolvedStorageSource *GoogleDevtoolsCloudbuildV1StorageSource `json:"resolvedStorageSource,omitempty"`
	// ResolvedStorageSourceManifest: A copy of the build's
	// `source.storage_source_manifest`, if exists, with any revisions resolved.
	// This feature is in Preview.
	ResolvedStorageSourceManifest *GoogleDevtoolsCloudbuildV1StorageSourceManifest `json:"resolvedStorageSourceManifest,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FileHashes") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FileHashes") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1SourceProvenance) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1SourceProvenance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1StorageSource: Location of the source in an
// archive file in Cloud Storage.
type GoogleDevtoolsCloudbuildV1StorageSource struct {
	// Bucket: Cloud Storage bucket containing the source (see Bucket Name
	// Requirements
	// (https://cloud.google.com/storage/docs/bucket-naming#requirements)).
	Bucket string `json:"bucket,omitempty"`
	// Generation: Optional. Cloud Storage generation for the object. If the
	// generation is omitted, the latest generation will be used.
	Generation int64 `json:"generation,omitempty,string"`
	// Object: Required. Cloud Storage object containing the source. This object
	// must be a zipped (`.zip`) or gzipped archive file (`.tar.gz`) containing
	// source to build.
	Object string `json:"object,omitempty"`
	// SourceFetcher: Optional. Option to specify the tool to fetch the source file
	// for the build.
	//
	// Possible values:
	//   "SOURCE_FETCHER_UNSPECIFIED" - Unspecified defaults to GSUTIL.
	//   "GSUTIL" - Use the "gsutil" tool to download the source file.
	//   "GCS_FETCHER" - Use the Cloud Storage Fetcher tool to download the source
	// file.
	SourceFetcher string `json:"sourceFetcher,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bucket") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bucket") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1StorageSource) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1StorageSource
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1StorageSourceManifest: Location of the source
// manifest in Cloud Storage. This feature is in Preview; see description here
// (https://github.com/GoogleCloudPlatform/cloud-builders/tree/master/gcs-fetcher).
type GoogleDevtoolsCloudbuildV1StorageSourceManifest struct {
	// Bucket: Required. Cloud Storage bucket containing the source manifest (see
	// Bucket Name Requirements
	// (https://cloud.google.com/storage/docs/bucket-naming#requirements)).
	Bucket string `json:"bucket,omitempty"`
	// Generation: Cloud Storage generation for the object. If the generation is
	// omitted, the latest generation will be used.
	Generation int64 `json:"generation,omitempty,string"`
	// Object: Required. Cloud Storage object containing the source manifest. This
	// object must be a JSON file.
	Object string `json:"object,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bucket") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bucket") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1StorageSourceManifest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1StorageSourceManifest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1TimeSpan: Start and end times for a build
// execution phase.
type GoogleDevtoolsCloudbuildV1TimeSpan struct {
	// EndTime: End of time span.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Start of time span.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1TimeSpan) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1TimeSpan
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1UploadedGoModule: A Go module artifact uploaded to
// Artifact Registry using the GoModule directive.
type GoogleDevtoolsCloudbuildV1UploadedGoModule struct {
	// ArtifactRegistryPackage: Output only. Path to the artifact in Artifact
	// Registry.
	ArtifactRegistryPackage string `json:"artifactRegistryPackage,omitempty"`
	// FileHashes: Hash types and values of the Go Module Artifact.
	FileHashes *GoogleDevtoolsCloudbuildV1FileHashes `json:"fileHashes,omitempty"`
	// PushTiming: Output only. Stores timing information for pushing the specified
	// artifact.
	PushTiming *GoogleDevtoolsCloudbuildV1TimeSpan `json:"pushTiming,omitempty"`
	// Uri: URI of the uploaded artifact.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArtifactRegistryPackage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArtifactRegistryPackage") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1UploadedGoModule) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1UploadedGoModule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1UploadedMavenArtifact: A Maven artifact uploaded
// using the MavenArtifact directive.
type GoogleDevtoolsCloudbuildV1UploadedMavenArtifact struct {
	// ArtifactRegistryPackage: Output only. Path to the artifact in Artifact
	// Registry.
	ArtifactRegistryPackage string `json:"artifactRegistryPackage,omitempty"`
	// FileHashes: Hash types and values of the Maven Artifact.
	FileHashes *GoogleDevtoolsCloudbuildV1FileHashes `json:"fileHashes,omitempty"`
	// PushTiming: Output only. Stores timing information for pushing the specified
	// artifact.
	PushTiming *GoogleDevtoolsCloudbuildV1TimeSpan `json:"pushTiming,omitempty"`
	// Uri: URI of the uploaded artifact.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArtifactRegistryPackage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArtifactRegistryPackage") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1UploadedMavenArtifact) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1UploadedMavenArtifact
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1UploadedNpmPackage: An npm package uploaded to
// Artifact Registry using the NpmPackage directive.
type GoogleDevtoolsCloudbuildV1UploadedNpmPackage struct {
	// ArtifactRegistryPackage: Output only. Path to the artifact in Artifact
	// Registry.
	ArtifactRegistryPackage string `json:"artifactRegistryPackage,omitempty"`
	// FileHashes: Hash types and values of the npm package.
	FileHashes *GoogleDevtoolsCloudbuildV1FileHashes `json:"fileHashes,omitempty"`
	// PushTiming: Output only. Stores timing information for pushing the specified
	// artifact.
	PushTiming *GoogleDevtoolsCloudbuildV1TimeSpan `json:"pushTiming,omitempty"`
	// Uri: URI of the uploaded npm package.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArtifactRegistryPackage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArtifactRegistryPackage") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1UploadedNpmPackage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1UploadedNpmPackage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1UploadedPythonPackage: Artifact uploaded using the
// PythonPackage directive.
type GoogleDevtoolsCloudbuildV1UploadedPythonPackage struct {
	// ArtifactRegistryPackage: Output only. Path to the artifact in Artifact
	// Registry.
	ArtifactRegistryPackage string `json:"artifactRegistryPackage,omitempty"`
	// FileHashes: Hash types and values of the Python Artifact.
	FileHashes *GoogleDevtoolsCloudbuildV1FileHashes `json:"fileHashes,omitempty"`
	// PushTiming: Output only. Stores timing information for pushing the specified
	// artifact.
	PushTiming *GoogleDevtoolsCloudbuildV1TimeSpan `json:"pushTiming,omitempty"`
	// Uri: URI of the uploaded artifact.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ArtifactRegistryPackage") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ArtifactRegistryPackage") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1UploadedPythonPackage) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1UploadedPythonPackage
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1Volume: Volume describes a Docker container volume
// which is mounted into build steps in order to persist files across build
// step execution.
type GoogleDevtoolsCloudbuildV1Volume struct {
	// Name: Name of the volume to mount. Volume names must be unique per build
	// step and must be valid names for Docker volumes. Each named volume must be
	// used by at least two build steps.
	Name string `json:"name,omitempty"`
	// Path: Path at which to mount the volume. Paths must be absolute and cannot
	// conflict with other volume paths on the same build step or with certain
	// reserved volume paths.
	Path string `json:"path,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1Volume) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1Volume
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleDevtoolsCloudbuildV1Warning: A non-fatal problem encountered during
// the execution of the build.
type GoogleDevtoolsCloudbuildV1Warning struct {
	// Priority: The priority for this warning.
	//
	// Possible values:
	//   "PRIORITY_UNSPECIFIED" - Should not be used.
	//   "INFO" - e.g. deprecation warnings and alternative feature highlights.
	//   "WARNING" - e.g. automated detection of possible issues with the build.
	//   "ALERT" - e.g. alerts that a feature used in the build is pending removal
	Priority string `json:"priority,omitempty"`
	// Text: Explanation of the warning generated.
	Text string `json:"text,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Priority") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Priority") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleDevtoolsCloudbuildV1Warning) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleDevtoolsCloudbuildV1Warning
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1AuditConfig: Specifies the audit configuration for a service. The
// configuration determines which permission types are logged, and what
// identities, if any, are exempted from logging. An AuditConfig must have one
// or more AuditLogConfigs. If there are AuditConfigs for both `allServices`
// and a specific service, the union of the two AuditConfigs is used for that
// service: the log_types specified in each AuditConfig are enabled, and the
// exempted_members in each AuditLogConfig are exempted. Example Policy with
// multiple AuditConfigs: { "audit_configs": [ { "service": "allServices",
// "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [
// "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type":
// "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com",
// "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type":
// "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For
// sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ
// logging. It also exempts `jose@example.com` from DATA_READ logging, and
// `aliya@example.com` from DATA_WRITE logging.
type GoogleIamV1AuditConfig struct {
	// AuditLogConfigs: The configuration for logging of each type of permission.
	AuditLogConfigs []*GoogleIamV1AuditLogConfig `json:"auditLogConfigs,omitempty"`
	// Service: Specifies a service that will be enabled for audit logging. For
	// example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices`
	// is a special value that covers all services.
	Service string `json:"service,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AuditLogConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditLogConfigs") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1AuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1AuditConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1AuditLogConfig: Provides the configuration for logging a type of
// permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ",
// "exempted_members": [ "user:jose@example.com" ] }, { "log_type":
// "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while
// exempting jose@example.com from DATA_READ logging.
type GoogleIamV1AuditLogConfig struct {
	// ExemptedMembers: Specifies the identities that do not cause logging for this
	// type of permission. Follows the same format of Binding.members.
	ExemptedMembers []string `json:"exemptedMembers,omitempty"`
	// LogType: The log type that this config enables.
	//
	// Possible values:
	//   "LOG_TYPE_UNSPECIFIED" - Default case. Should never be this.
	//   "ADMIN_READ" - Admin reads. Example: CloudIAM getIamPolicy
	//   "DATA_WRITE" - Data writes. Example: CloudSQL Users create
	//   "DATA_READ" - Data reads. Example: CloudSQL Users list
	LogType string `json:"logType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExemptedMembers") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExemptedMembers") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1AuditLogConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1AuditLogConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1Binding: Associates `members`, or principals, with a `role`.
type GoogleIamV1Binding struct {
	// Condition: The condition that is associated with this binding. If the
	// condition evaluates to `true`, then this binding applies to the current
	// request. If the condition evaluates to `false`, then this binding does not
	// apply to the current request. However, a different role binding might grant
	// the same role to one or more of the principals in this binding. To learn
	// which resources support conditions in their IAM policies, see the IAM
	// documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Condition *GoogleTypeExpr `json:"condition,omitempty"`
	// Members: Specifies the principals requesting access for a Google Cloud
	// resource. `members` can have the following values: * `allUsers`: A special
	// identifier that represents anyone who is on the internet; with or without a
	// Google account. * `allAuthenticatedUsers`: A special identifier that
	// represents anyone who is authenticated with a Google account or a service
	// account. Does not include identities that come from external identity
	// providers (IdPs) through identity federation. * `user:{emailid}`: An email
	// address that represents a specific Google account. For example,
	// `alice@example.com` . * `serviceAccount:{emailid}`: An email address that
	// represents a Google service account. For example,
	// `my-other-app@appspot.gserviceaccount.com`. *
	// `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`: An
	// identifier for a Kubernetes service account
	// (https://cloud.google.com/kubernetes-engine/docs/how-to/kubernetes-service-accounts).
	// For example, `my-project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
	// `group:{emailid}`: An email address that represents a Google group. For
	// example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
	// (primary) that represents all the users of that domain. For example,
	// `google.com` or `example.com`. *
	// `principal://iam.googleapis.com/locations/global/workforcePools/{pool_id}/sub
	// ject/{subject_attribute_value}`: A single identity in a workforce identity
	// pool. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// group/{group_id}`: All workforce identities in a group. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// attribute.{attribute_name}/{attribute_value}`: All workforce identities with
	// a specific attribute value. *
	// `principalSet://iam.googleapis.com/locations/global/workforcePools/{pool_id}/
	// *`: All identities in a workforce identity pool. *
	// `principal://iam.googleapis.com/projects/{project_number}/locations/global/wo
	// rkloadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
	// identity in a workload identity pool. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/group/{group_id}`: A workload identity pool
	// group. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}
	// `: All identities in a workload identity pool with a certain attribute. *
	// `principalSet://iam.googleapis.com/projects/{project_number}/locations/global
	// /workloadIdentityPools/{pool_id}/*`: All identities in a workload identity
	// pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a user that has been recently deleted. For
	// example, `alice@example.com?uid=123456789012345678901`. If the user is
	// recovered, this value reverts to `user:{emailid}` and the recovered user
	// retains the role in the binding. *
	// `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus
	// unique identifier) representing a service account that has been recently
	// deleted. For example,
	// `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
	// service account is undeleted, this value reverts to
	// `serviceAccount:{emailid}` and the undeleted service account retains the
	// role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email
	// address (plus unique identifier) representing a Google group that has been
	// recently deleted. For example,
	// `admins@example.com?uid=123456789012345678901`. If the group is recovered,
	// this value reverts to `group:{emailid}` and the recovered group retains the
	// role in the binding. *
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/{pool
	// _id}/subject/{subject_attribute_value}`: Deleted single identity in a
	// workforce identity pool. For example,
	// `deleted:principal://iam.googleapis.com/locations/global/workforcePools/my-po
	// ol-id/subject/my-subject-attribute-value`.
	Members []string `json:"members,omitempty"`
	// Role: Role that is assigned to the list of `members`, or principals. For
	// example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an overview
	// of the IAM roles and permissions, see the IAM documentation
	// (https://cloud.google.com/iam/docs/roles-overview). For a list of the
	// available pre-defined roles, see here
	// (https://cloud.google.com/iam/docs/understanding-roles).
	Role string `json:"role,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Condition") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Condition") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1Binding) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Binding
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1Policy: An Identity and Access Management (IAM) policy, which
// specifies access controls for Google Cloud resources. A `Policy` is a
// collection of `bindings`. A `binding` binds one or more `members`, or
// principals, to a single `role`. Principals can be user accounts, service
// accounts, Google groups, and domains (such as G Suite). A `role` is a named
// list of permissions; each `role` can be an IAM predefined role or a
// user-created custom role. For some types of Google Cloud resources, a
// `binding` can also specify a `condition`, which is a logical expression that
// allows access to a resource only if the expression evaluates to `true`. A
// condition can add constraints based on attributes of the request, the
// resource, or both. To learn which resources support conditions in their IAM
// policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies). **JSON
// example:** ``` { "bindings": [ { "role":
// "roles/resourcemanager.organizationAdmin", "members": [
// "user:mike@example.com", "group:admins@example.com", "domain:google.com",
// "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
// "roles/resourcemanager.organizationViewer", "members": [
// "user:eve@example.com" ], "condition": { "title": "expirable access",
// "description": "Does not grant access after Sep 2020", "expression":
// "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
// "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
// members: - user:mike@example.com - group:admins@example.com -
// domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
// role: roles/resourcemanager.organizationAdmin - members: -
// user:eve@example.com role: roles/resourcemanager.organizationViewer
// condition: title: expirable access description: Does not grant access after
// Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
// etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
// see the IAM documentation (https://cloud.google.com/iam/docs/).
type GoogleIamV1Policy struct {
	// AuditConfigs: Specifies cloud audit logging configuration for this policy.
	AuditConfigs []*GoogleIamV1AuditConfig `json:"auditConfigs,omitempty"`
	// Bindings: Associates a list of `members`, or principals, with a `role`.
	// Optionally, may specify a `condition` that determines how and when the
	// `bindings` are applied. Each of the `bindings` must contain at least one
	// principal. The `bindings` in a `Policy` can refer to up to 1,500 principals;
	// up to 250 of these principals can be Google groups. Each occurrence of a
	// principal counts towards these limits. For example, if the `bindings` grant
	// 50 different roles to `user:alice@example.com`, and not to any other
	// principal, then you can add another 1,450 principals to the `bindings` in
	// the `Policy`.
	Bindings []*GoogleIamV1Binding `json:"bindings,omitempty"`
	// Etag: `etag` is used for optimistic concurrency control as a way to help
	// prevent simultaneous updates of a policy from overwriting each other. It is
	// strongly suggested that systems make use of the `etag` in the
	// read-modify-write cycle to perform policy updates in order to avoid race
	// conditions: An `etag` is returned in the response to `getIamPolicy`, and
	// systems are expected to put that etag in the request to `setIamPolicy` to
	// ensure that their change will be applied to the same version of the policy.
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost.
	Etag string `json:"etag,omitempty"`
	// Version: Specifies the format of the policy. Valid values are `0`, `1`, and
	// `3`. Requests that specify an invalid value are rejected. Any operation that
	// affects conditional role bindings must specify version `3`. This requirement
	// applies to the following operations: * Getting a policy that includes a
	// conditional role binding * Adding a conditional role binding to a policy *
	// Changing a conditional role binding in a policy * Removing any role binding,
	// with or without a condition, from a policy that includes conditions
	// **Important:** If you use IAM Conditions, you must include the `etag` field
	// whenever you call `setIamPolicy`. If you omit this field, then IAM allows
	// you to overwrite a version `3` policy with a version `1` policy, and all of
	// the conditions in the version `3` policy are lost. If a policy does not
	// include any conditions, operations on that policy may specify any valid
	// version or leave the field unset. To learn which resources support
	// conditions in their IAM policies, see the IAM documentation
	// (https://cloud.google.com/iam/help/conditions/resource-policies).
	Version int64 `json:"version,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AuditConfigs") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AuditConfigs") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1Policy) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1Policy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1SetIamPolicyRequest: Request message for `SetIamPolicy` method.
type GoogleIamV1SetIamPolicyRequest struct {
	// Policy: REQUIRED: The complete policy to be applied to the `resource`. The
	// size of the policy is limited to a few 10s of KB. An empty policy is a valid
	// policy but certain Google Cloud services (such as Projects) might reject
	// them.
	Policy *GoogleIamV1Policy `json:"policy,omitempty"`
	// UpdateMask: OPTIONAL: A FieldMask specifying which fields of the policy to
	// modify. Only the fields in the mask will be modified. If no mask is
	// provided, the following default mask is used: `paths: "bindings, etag"
	UpdateMask string `json:"updateMask,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Policy") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Policy") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1SetIamPolicyRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1SetIamPolicyRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1TestIamPermissionsRequest: Request message for
// `TestIamPermissions` method.
type GoogleIamV1TestIamPermissionsRequest struct {
	// Permissions: The set of permissions to check for the `resource`. Permissions
	// with wildcards (such as `*` or `storage.*`) are not allowed. For more
	// information see IAM Overview
	// (https://cloud.google.com/iam/docs/overview#permissions).
	Permissions []string `json:"permissions,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1TestIamPermissionsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1TestIamPermissionsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleIamV1TestIamPermissionsResponse: Response message for
// `TestIamPermissions` method.
type GoogleIamV1TestIamPermissionsResponse struct {
	// Permissions: A subset of `TestPermissionsRequest.permissions` that the
	// caller is allowed.
	Permissions []string `json:"permissions,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Permissions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Permissions") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleIamV1TestIamPermissionsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleIamV1TestIamPermissionsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningListOperationsResponse: The response message for
// Operations.ListOperations.
type GoogleLongrunningListOperationsResponse struct {
	// NextPageToken: The standard List next-page token.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Operations: A list of operations that matches the specified filter in the
	// request.
	Operations []*GoogleLongrunningOperation `json:"operations,omitempty"`
	// Unreachable: Unordered list. Unreachable resources. Populated when the
	// request sets `ListOperationsRequest.return_partial_success` and reads across
	// collections. For example, when attempting to list all resources across all
	// supported locations.
	Unreachable []string `json:"unreachable,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "NextPageToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NextPageToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningListOperationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningListOperationsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningOperation: This resource represents a long-running
// operation that is the result of a network API call.
type GoogleLongrunningOperation struct {
	// Done: If the value is `false`, it means the operation is still in progress.
	// If `true`, the operation is completed, and either `error` or `response` is
	// available.
	Done bool `json:"done,omitempty"`
	// Error: The error result of the operation in case of failure or cancellation.
	Error *GoogleRpcStatus `json:"error,omitempty"`
	// Metadata: Service-specific metadata associated with the operation. It
	// typically contains progress information and common metadata such as create
	// time. Some services might not provide such metadata. Any method that returns
	// a long-running operation should document the metadata type, if any.
	Metadata googleapi.RawMessage `json:"metadata,omitempty"`
	// Name: The server-assigned name, which is only unique within the same service
	// that originally returns it. If you use the default HTTP mapping, the `name`
	// should be a resource name ending with `operations/{unique_id}`.
	Name string `json:"name,omitempty"`
	// Response: The normal, successful response of the operation. If the original
	// method returns no data on success, such as `Delete`, the response is
	// `google.protobuf.Empty`. If the original method is standard
	// `Get`/`Create`/`Update`, the response should be the resource. For other
	// methods, the response should have the type `XxxResponse`, where `Xxx` is the
	// original method name. For example, if the original method name is
	// `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
	Response googleapi.RawMessage `json:"response,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Done") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Done") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningOperation) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningOperation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleLongrunningWaitOperationRequest: The request message for
// Operations.WaitOperation.
type GoogleLongrunningWaitOperationRequest struct {
	// Timeout: The maximum duration to wait before timing out. If left blank, the
	// wait will be at most the time permitted by the underlying HTTP/RPC protocol.
	// If RPC context deadline is also specified, the shorter one will be used.
	Timeout string `json:"timeout,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Timeout") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Timeout") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleLongrunningWaitOperationRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleLongrunningWaitOperationRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleProtobufEmpty: A generic empty message that you can re-use to avoid
// defining duplicated empty messages in your APIs. A typical example is to use
// it as the request or the response type of an API method. For instance:
// service Foo { rpc Bar(google.protobuf.Empty) returns
// (google.protobuf.Empty); }
type GoogleProtobufEmpty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// GoogleRpcStatus: The `Status` type defines a logical error model that is
// suitable for different programming environments, including REST APIs and RPC
// APIs. It is used by gRPC (https://github.com/grpc). Each `Status` message
// contains three pieces of data: error code, error message, and error details.
// You can find out more about this error model and how to work with it in the
// API Design Guide (https://cloud.google.com/apis/design/errors).
type GoogleRpcStatus struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleRpcStatus) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleRpcStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GoogleTypeExpr: Represents a textual expression in the Common Expression
// Language (CEL) syntax. CEL is a C-like expression language. The syntax and
// semantics of CEL are documented at https://github.com/google/cel-spec.
// Example (Comparison): title: "Summary size limit" description: "Determines
// if a summary is less than 100 chars" expression: "document.summary.size() <
// 100" Example (Equality): title: "Requestor is owner" description:
// "Determines if requestor is the document owner" expression: "document.owner
// == request.auth.claims.email" Example (Logic): title: "Public documents"
// description: "Determine whether the document should be publicly visible"
// expression: "document.type != 'private' && document.type != 'internal'"
// Example (Data Manipulation): title: "Notification string" description:
// "Create a notification string with a timestamp." expression: "'New message
// received at ' + string(document.create_time)" The exact variables and
// functions that may be referenced within an expression are determined by the
// service that evaluates it. See the service documentation for additional
// information.
type GoogleTypeExpr struct {
	// Description: Optional. Description of the expression. This is a longer text
	// which describes the expression, e.g. when hovered over it in a UI.
	Description string `json:"description,omitempty"`
	// Expression: Textual representation of an expression in Common Expression
	// Language syntax.
	Expression string `json:"expression,omitempty"`
	// Location: Optional. String indicating the location of the expression for
	// error reporting, e.g. a file name and a position in the file.
	Location string `json:"location,omitempty"`
	// Title: Optional. Title for the expression, i.e. a short string describing
	// its purpose. This can be used e.g. in UIs which allow to enter the
	// expression.
	Title string `json:"title,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Description") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Description") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GoogleTypeExpr) MarshalJSON() ([]byte, error) {
	type NoMethod GoogleTypeExpr
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Proto2BridgeMessageSet: This is proto2's version of MessageSet. DEPRECATED:
// DO NOT USE FOR NEW FIELDS. If you are using editions or proto2, please make
// your own extendable messages for your use case. If you are using proto3,
// please use `Any` instead. MessageSet was the implementation of extensions
// for proto1. When proto2 was introduced, extensions were implemented as a
// first-class feature. This schema for MessageSet was meant to be a "bridge"
// solution to migrate MessageSet-bearing messages from proto1 to proto2. This
// schema has been open-sourced only to facilitate the migration of Google
// products with MessageSet-bearing messages to open-source environments.
type Proto2BridgeMessageSet struct {
}

// UtilStatusProto: Wire-format for a Status object
type UtilStatusProto struct {
	// CanonicalCode: copybara:strip_begin(b/383363683)
	// copybara:strip_end_and_replace optional int32 canonical_code = 6;
	CanonicalCode int64 `json:"canonicalCode,omitempty"`
	// Code: Numeric code drawn from the space specified below. Often, this is the
	// canonical error space, and code is drawn from google3/util/task/codes.proto
	// copybara:strip_begin(b/383363683) copybara:strip_end_and_replace optional
	// int32 code = 1;
	Code int64 `json:"code,omitempty"`
	// Message: Detail message copybara:strip_begin(b/383363683)
	// copybara:strip_end_and_replace optional string message = 3;
	Message string `json:"message,omitempty"`
	// MessageSet: message_set associates an arbitrary proto message with the
	// status. copybara:strip_begin(b/383363683) copybara:strip_end_and_replace
	// optional proto2.bridge.MessageSet message_set = 5;
	MessageSet *Proto2BridgeMessageSet `json:"messageSet,omitempty"`
	// Space: copybara:strip_begin(b/383363683) Space to which this status belongs
	// copybara:strip_end_and_replace optional string space = 2; // Space to which
	// this status belongs
	Space string `json:"space,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CanonicalCode") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CanonicalCode") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UtilStatusProto) MarshalJSON() ([]byte, error) {
	type NoMethod UtilStatusProto
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ProjectsLocationsExportImageCall struct {
	s                                  *Service
	name                               string
	googlecloudrunv2exportimagerequest *GoogleCloudRunV2ExportImageRequest
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// ExportImage: Export image for a given resource.
//
//   - name: The name of the resource of which image metadata should be exported.
//     Format:
//     `projects/{project_id_or_number}/locations/{location}/services/{service}/re
//     visions/{revision}` for Revision
//     `projects/{project_id_or_number}/locations/{location}/jobs/{job}/executions
//     /{execution}` for Execution.
func (r *ProjectsLocationsService) ExportImage(name string, googlecloudrunv2exportimagerequest *GoogleCloudRunV2ExportImageRequest) *ProjectsLocationsExportImageCall {
	c := &ProjectsLocationsExportImageCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrunv2exportimagerequest = googlecloudrunv2exportimagerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExportImageCall) Fields(s ...googleapi.Field) *ProjectsLocationsExportImageCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExportImageCall) Context(ctx context.Context) *ProjectsLocationsExportImageCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExportImageCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExportImageCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudrunv2exportimagerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:exportImage")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.exportImage", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.exportImage" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRunV2ExportImageResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsExportImageCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRunV2ExportImageResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRunV2ExportImageResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.exportImage", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsExportImageMetadataCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ExportImageMetadata: Export image metadata for a given resource.
//
//   - name: The name of the resource of which image metadata should be exported.
//     Format:
//     `projects/{project_id_or_number}/locations/{location}/services/{service}/re
//     visions/{revision}` for Revision
//     `projects/{project_id_or_number}/locations/{location}/jobs/{job}/executions
//     /{execution}` for Execution.
func (r *ProjectsLocationsService) ExportImageMetadata(name string) *ProjectsLocationsExportImageMetadataCall {
	c := &ProjectsLocationsExportImageMetadataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExportImageMetadataCall) Fields(s ...googleapi.Field) *ProjectsLocationsExportImageMetadataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsExportImageMetadataCall) IfNoneMatch(entityTag string) *ProjectsLocationsExportImageMetadataCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExportImageMetadataCall) Context(ctx context.Context) *ProjectsLocationsExportImageMetadataCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExportImageMetadataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExportImageMetadataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:exportImageMetadata")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.exportImageMetadata", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.exportImageMetadata" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRunV2Metadata.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsExportImageMetadataCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRunV2Metadata, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRunV2Metadata{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.exportImageMetadata", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsExportMetadataCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ExportMetadata: Export generated customer metadata for a given resource.
//
//   - name: The name of the resource of which metadata should be exported.
//     Format:
//     `projects/{project_id_or_number}/locations/{location}/services/{service}`
//     for Service
//     `projects/{project_id_or_number}/locations/{location}/services/{service}/re
//     visions/{revision}` for Revision
//     `projects/{project_id_or_number}/locations/{location}/jobs/{job}/executions
//     /{execution}` for Execution {project_id_or_number} may contains
//     domain-scoped project IDs.
func (r *ProjectsLocationsService) ExportMetadata(name string) *ProjectsLocationsExportMetadataCall {
	c := &ProjectsLocationsExportMetadataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExportMetadataCall) Fields(s ...googleapi.Field) *ProjectsLocationsExportMetadataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsExportMetadataCall) IfNoneMatch(entityTag string) *ProjectsLocationsExportMetadataCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExportMetadataCall) Context(ctx context.Context) *ProjectsLocationsExportMetadataCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExportMetadataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExportMetadataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:exportMetadata")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.exportMetadata", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.exportMetadata" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRunV2Metadata.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsExportMetadataCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRunV2Metadata, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRunV2Metadata{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.exportMetadata", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsExportProjectMetadataCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ExportProjectMetadata: Export generated customer metadata for a given
// project.
//
//   - name: The name of the project of which metadata should be exported.
//     Format: `projects/{project_id_or_number}/locations/{location}` for Project
//     in a given location.
func (r *ProjectsLocationsService) ExportProjectMetadata(name string) *ProjectsLocationsExportProjectMetadataCall {
	c := &ProjectsLocationsExportProjectMetadataCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsExportProjectMetadataCall) Fields(s ...googleapi.Field) *ProjectsLocationsExportProjectMetadataCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsExportProjectMetadataCall) IfNoneMatch(entityTag string) *ProjectsLocationsExportProjectMetadataCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsExportProjectMetadataCall) Context(ctx context.Context) *ProjectsLocationsExportProjectMetadataCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsExportProjectMetadataCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsExportProjectMetadataCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:exportProjectMetadata")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.exportProjectMetadata", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.exportProjectMetadata" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRunV2Metadata.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsExportProjectMetadataCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRunV2Metadata, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRunV2Metadata{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.exportProjectMetadata", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsBuildsSubmitCall struct {
	s                                  *Service
	parent                             string
	googlecloudrunv2submitbuildrequest *GoogleCloudRunV2SubmitBuildRequest
	urlParams_                         gensupport.URLParams
	ctx_                               context.Context
	header_                            http.Header
}

// Submit: Submits a build in a given project.
//
//   - parent: The project and location to build in. Location must be a region,
//     e.g., 'us-central1' or 'global' if the global builder is to be used.
//     Format: `projects/{project}/locations/{location}`.
func (r *ProjectsLocationsBuildsService) Submit(parent string, googlecloudrunv2submitbuildrequest *GoogleCloudRunV2SubmitBuildRequest) *ProjectsLocationsBuildsSubmitCall {
	c := &ProjectsLocationsBuildsSubmitCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudrunv2submitbuildrequest = googlecloudrunv2submitbuildrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsBuildsSubmitCall) Fields(s ...googleapi.Field) *ProjectsLocationsBuildsSubmitCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsBuildsSubmitCall) Context(ctx context.Context) *ProjectsLocationsBuildsSubmitCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsBuildsSubmitCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsBuildsSubmitCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudrunv2submitbuildrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/builds:submit")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.builds.submit", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.builds.submit" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRunV2SubmitBuildResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsBuildsSubmitCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRunV2SubmitBuildResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRunV2SubmitBuildResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.builds.submit", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsJobsCreateCall struct {
	s                   *Service
	parent              string
	googlecloudrunv2job *GoogleCloudRunV2Job
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Create: Creates a Job.
//
//   - parent: The location and project in which this Job should be created.
//     Format: projects/{project}/locations/{location}, where {project} can be
//     project id or number.
func (r *ProjectsLocationsJobsService) Create(parent string, googlecloudrunv2job *GoogleCloudRunV2Job) *ProjectsLocationsJobsCreateCall {
	c := &ProjectsLocationsJobsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudrunv2job = googlecloudrunv2job
	return c
}

// JobId sets the optional parameter "jobId": Required. The unique identifier
// for the Job. The name of the job becomes {parent}/jobs/{job_id}.
func (c *ProjectsLocationsJobsCreateCall) JobId(jobId string) *ProjectsLocationsJobsCreateCall {
	c.urlParams_.Set("jobId", jobId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated and default values populated, without persisting
// the request or creating any resources.
func (c *ProjectsLocationsJobsCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsJobsCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsJobsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsJobsCreateCall) Context(ctx context.Context) *ProjectsLocationsJobsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsJobsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudrunv2job)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/jobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.jobs.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsJobsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsJobsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Job.
//
//   - name: The full name of the Job. Format:
//     projects/{project}/locations/{location}/jobs/{job}, where {project} can be
//     project id or number.
func (r *ProjectsLocationsJobsService) Delete(name string) *ProjectsLocationsJobsDeleteCall {
	c := &ProjectsLocationsJobsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": A system-generated fingerprint for
// this version of the resource. May be used to detect modification conflict
// during updates.
func (c *ProjectsLocationsJobsDeleteCall) Etag(etag string) *ProjectsLocationsJobsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated without actually deleting any resources.
func (c *ProjectsLocationsJobsDeleteCall) ValidateOnly(validateOnly bool) *ProjectsLocationsJobsDeleteCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsJobsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsJobsDeleteCall) Context(ctx context.Context) *ProjectsLocationsJobsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsJobsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.jobs.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsJobsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsJobsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a Job.
//
//   - name: The full name of the Job. Format:
//     projects/{project}/locations/{location}/jobs/{job}, where {project} can be
//     project id or number.
func (r *ProjectsLocationsJobsService) Get(name string) *ProjectsLocationsJobsGetCall {
	c := &ProjectsLocationsJobsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsJobsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsJobsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsJobsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsJobsGetCall) Context(ctx context.Context) *ProjectsLocationsJobsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsJobsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.jobs.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRunV2Job.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsJobsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRunV2Job, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRunV2Job{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsJobsGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the IAM Access Control policy currently in effect for the
// given Job. This result does not include any inherited policies.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsJobsService) GetIamPolicy(resource string) *ProjectsLocationsJobsGetIamPolicyCall {
	c := &ProjectsLocationsJobsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsJobsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsJobsGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsJobsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsJobsGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsJobsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsJobsGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsJobsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsJobsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.jobs.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsJobsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsJobsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Jobs. Results are sorted by creation time, descending.
//
//   - parent: The location and project to list resources on. Format:
//     projects/{project}/locations/{location}, where {project} can be project id
//     or number.
func (r *ProjectsLocationsJobsService) List(parent string) *ProjectsLocationsJobsListCall {
	c := &ProjectsLocationsJobsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of Jobs to
// return in this call.
func (c *ProjectsLocationsJobsListCall) PageSize(pageSize int64) *ProjectsLocationsJobsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous call to ListJobs. All other parameters must match.
func (c *ProjectsLocationsJobsListCall) PageToken(pageToken string) *ProjectsLocationsJobsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": If true, returns
// deleted (but unexpired) resources along with active ones.
func (c *ProjectsLocationsJobsListCall) ShowDeleted(showDeleted bool) *ProjectsLocationsJobsListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsJobsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsJobsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsJobsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsJobsListCall) Context(ctx context.Context) *ProjectsLocationsJobsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsJobsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/jobs")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.jobs.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRunV2ListJobsResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsJobsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRunV2ListJobsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRunV2ListJobsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsJobsListCall) Pages(ctx context.Context, f func(*GoogleCloudRunV2ListJobsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsJobsPatchCall struct {
	s                   *Service
	name                string
	googlecloudrunv2job *GoogleCloudRunV2Job
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Patch: Updates a Job.
//
//   - name: The fully qualified name of this Job. Format:
//     projects/{project}/locations/{location}/jobs/{job}.
func (r *ProjectsLocationsJobsService) Patch(name string, googlecloudrunv2job *GoogleCloudRunV2Job) *ProjectsLocationsJobsPatchCall {
	c := &ProjectsLocationsJobsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrunv2job = googlecloudrunv2job
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to true, and
// if the Job does not exist, it will create a new one. Caller must have both
// create and update permissions for this call if this is set to true.
func (c *ProjectsLocationsJobsPatchCall) AllowMissing(allowMissing bool) *ProjectsLocationsJobsPatchCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated and default values populated, without persisting
// the request or updating any resources.
func (c *ProjectsLocationsJobsPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsJobsPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsJobsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsJobsPatchCall) Context(ctx context.Context) *ProjectsLocationsJobsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsJobsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudrunv2job)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.jobs.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsJobsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsJobsRunCall struct {
	s                             *Service
	name                          string
	googlecloudrunv2runjobrequest *GoogleCloudRunV2RunJobRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// Run: Triggers creation of a new Execution of this Job.
//
//   - name: The full name of the Job. Format:
//     projects/{project}/locations/{location}/jobs/{job}, where {project} can be
//     project id or number.
func (r *ProjectsLocationsJobsService) Run(name string, googlecloudrunv2runjobrequest *GoogleCloudRunV2RunJobRequest) *ProjectsLocationsJobsRunCall {
	c := &ProjectsLocationsJobsRunCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrunv2runjobrequest = googlecloudrunv2runjobrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsJobsRunCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsRunCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsJobsRunCall) Context(ctx context.Context) *ProjectsLocationsJobsRunCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsJobsRunCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsRunCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudrunv2runjobrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:run")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.run", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.jobs.run" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsJobsRunCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.run", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsJobsSetIamPolicyCall struct {
	s                              *Service
	resource                       string
	googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// SetIamPolicy: Sets the IAM Access control policy for the specified Job.
// Overwrites any existing policy.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsJobsService) SetIamPolicy(resource string, googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest) *ProjectsLocationsJobsSetIamPolicyCall {
	c := &ProjectsLocationsJobsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1setiampolicyrequest = googleiamv1setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsJobsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsJobsSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsJobsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsJobsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleiamv1setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.jobs.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsJobsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsJobsTestIamPermissionsCall struct {
	s                                    *Service
	resource                             string
	googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// Project. There are no permissions required for making this API call.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsJobsService) TestIamPermissions(resource string, googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest) *ProjectsLocationsJobsTestIamPermissionsCall {
	c := &ProjectsLocationsJobsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1testiampermissionsrequest = googleiamv1testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsJobsTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsJobsTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsJobsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsJobsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleiamv1testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.jobs.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1TestIamPermissionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsJobsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsJobsExecutionsCancelCall struct {
	s                                      *Service
	name                                   string
	googlecloudrunv2cancelexecutionrequest *GoogleCloudRunV2CancelExecutionRequest
	urlParams_                             gensupport.URLParams
	ctx_                                   context.Context
	header_                                http.Header
}

// Cancel: Cancels an Execution.
//
//   - name: The name of the Execution to cancel. Format:
//     `projects/{project}/locations/{location}/jobs/{job}/executions/{execution}`
//     , where `{project}` can be project id or number.
func (r *ProjectsLocationsJobsExecutionsService) Cancel(name string, googlecloudrunv2cancelexecutionrequest *GoogleCloudRunV2CancelExecutionRequest) *ProjectsLocationsJobsExecutionsCancelCall {
	c := &ProjectsLocationsJobsExecutionsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrunv2cancelexecutionrequest = googlecloudrunv2cancelexecutionrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsJobsExecutionsCancelCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsExecutionsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsJobsExecutionsCancelCall) Context(ctx context.Context) *ProjectsLocationsJobsExecutionsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsJobsExecutionsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsExecutionsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudrunv2cancelexecutionrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.executions.cancel", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.jobs.executions.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsJobsExecutionsCancelCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.executions.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsJobsExecutionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes an Execution.
//
//   - name: The name of the Execution to delete. Format:
//     `projects/{project}/locations/{location}/jobs/{job}/executions/{execution}`
//     , where `{project}` can be project id or number.
func (r *ProjectsLocationsJobsExecutionsService) Delete(name string) *ProjectsLocationsJobsExecutionsDeleteCall {
	c := &ProjectsLocationsJobsExecutionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": A system-generated fingerprint for
// this version of the resource. This may be used to detect modification
// conflict during updates.
func (c *ProjectsLocationsJobsExecutionsDeleteCall) Etag(etag string) *ProjectsLocationsJobsExecutionsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated without actually deleting any resources.
func (c *ProjectsLocationsJobsExecutionsDeleteCall) ValidateOnly(validateOnly bool) *ProjectsLocationsJobsExecutionsDeleteCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsJobsExecutionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsExecutionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsJobsExecutionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsJobsExecutionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsJobsExecutionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsExecutionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.executions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.jobs.executions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsJobsExecutionsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.executions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsJobsExecutionsExportStatusCall struct {
	s            *Service
	name         string
	operationId  string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ExportStatus: Read the status of an image export operation.
//
//   - name: The name of the resource of which image export operation status has
//     to be fetched. Format:
//     `projects/{project_id_or_number}/locations/{location}/services/{service}/re
//     visions/{revision}` for Revision
//     `projects/{project_id_or_number}/locations/{location}/jobs/{job}/executions
//     /{execution}` for Execution.
//   - operationId: The operation id returned from ExportImage.
func (r *ProjectsLocationsJobsExecutionsService) ExportStatus(name string, operationId string) *ProjectsLocationsJobsExecutionsExportStatusCall {
	c := &ProjectsLocationsJobsExecutionsExportStatusCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.operationId = operationId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsJobsExecutionsExportStatusCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsExecutionsExportStatusCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsJobsExecutionsExportStatusCall) IfNoneMatch(entityTag string) *ProjectsLocationsJobsExecutionsExportStatusCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsJobsExecutionsExportStatusCall) Context(ctx context.Context) *ProjectsLocationsJobsExecutionsExportStatusCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsJobsExecutionsExportStatusCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsExecutionsExportStatusCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/{+operationId}:exportStatus")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name":        c.name,
		"operationId": c.operationId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.executions.exportStatus", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.jobs.executions.exportStatus" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRunV2ExportStatusResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsJobsExecutionsExportStatusCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRunV2ExportStatusResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRunV2ExportStatusResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.executions.exportStatus", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsJobsExecutionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about an Execution.
//
//   - name: The full name of the Execution. Format:
//     `projects/{project}/locations/{location}/jobs/{job}/executions/{execution}`
//     , where `{project}` can be project id or number.
func (r *ProjectsLocationsJobsExecutionsService) Get(name string) *ProjectsLocationsJobsExecutionsGetCall {
	c := &ProjectsLocationsJobsExecutionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsJobsExecutionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsExecutionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsJobsExecutionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsJobsExecutionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsJobsExecutionsGetCall) Context(ctx context.Context) *ProjectsLocationsJobsExecutionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsJobsExecutionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsExecutionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.executions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.jobs.executions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRunV2Execution.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsJobsExecutionsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRunV2Execution, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRunV2Execution{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.executions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsJobsExecutionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Executions from a Job. Results are sorted by creation time,
// descending.
//
//   - parent: The Execution from which the Executions should be listed. To list
//     all Executions across Jobs, use "-" instead of Job name. Format:
//     `projects/{project}/locations/{location}/jobs/{job}`, where `{project}`
//     can be project id or number.
func (r *ProjectsLocationsJobsExecutionsService) List(parent string) *ProjectsLocationsJobsExecutionsListCall {
	c := &ProjectsLocationsJobsExecutionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// Executions to return in this call.
func (c *ProjectsLocationsJobsExecutionsListCall) PageSize(pageSize int64) *ProjectsLocationsJobsExecutionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous call to ListExecutions. All other parameters must match.
func (c *ProjectsLocationsJobsExecutionsListCall) PageToken(pageToken string) *ProjectsLocationsJobsExecutionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": If true, returns
// deleted (but unexpired) resources along with active ones.
func (c *ProjectsLocationsJobsExecutionsListCall) ShowDeleted(showDeleted bool) *ProjectsLocationsJobsExecutionsListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsJobsExecutionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsExecutionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsJobsExecutionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsJobsExecutionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsJobsExecutionsListCall) Context(ctx context.Context) *ProjectsLocationsJobsExecutionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsJobsExecutionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsExecutionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/executions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.executions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.jobs.executions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRunV2ListExecutionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsJobsExecutionsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRunV2ListExecutionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRunV2ListExecutionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.executions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsJobsExecutionsListCall) Pages(ctx context.Context, f func(*GoogleCloudRunV2ListExecutionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsJobsExecutionsTasksGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a Task.
//
//   - name: The full name of the Task. Format:
//     projects/{project}/locations/{location}/jobs/{job}/executions/{execution}/t
//     asks/{task}.
func (r *ProjectsLocationsJobsExecutionsTasksService) Get(name string) *ProjectsLocationsJobsExecutionsTasksGetCall {
	c := &ProjectsLocationsJobsExecutionsTasksGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsJobsExecutionsTasksGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsExecutionsTasksGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsJobsExecutionsTasksGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsJobsExecutionsTasksGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsJobsExecutionsTasksGetCall) Context(ctx context.Context) *ProjectsLocationsJobsExecutionsTasksGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsJobsExecutionsTasksGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsExecutionsTasksGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.executions.tasks.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.jobs.executions.tasks.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRunV2Task.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsJobsExecutionsTasksGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRunV2Task, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRunV2Task{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.executions.tasks.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsJobsExecutionsTasksListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Tasks from an Execution of a Job.
//
//   - parent: The Execution from which the Tasks should be listed. To list all
//     Tasks across Executions of a Job, use "-" instead of Execution name. To
//     list all Tasks across Jobs, use "-" instead of Job name. Format:
//     projects/{project}/locations/{location}/jobs/{job}/executions/{execution}.
func (r *ProjectsLocationsJobsExecutionsTasksService) List(parent string) *ProjectsLocationsJobsExecutionsTasksListCall {
	c := &ProjectsLocationsJobsExecutionsTasksListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of Tasks to
// return in this call.
func (c *ProjectsLocationsJobsExecutionsTasksListCall) PageSize(pageSize int64) *ProjectsLocationsJobsExecutionsTasksListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous call to ListTasks. All other parameters must match.
func (c *ProjectsLocationsJobsExecutionsTasksListCall) PageToken(pageToken string) *ProjectsLocationsJobsExecutionsTasksListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": If true, returns
// deleted (but unexpired) resources along with active ones.
func (c *ProjectsLocationsJobsExecutionsTasksListCall) ShowDeleted(showDeleted bool) *ProjectsLocationsJobsExecutionsTasksListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsJobsExecutionsTasksListCall) Fields(s ...googleapi.Field) *ProjectsLocationsJobsExecutionsTasksListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsJobsExecutionsTasksListCall) IfNoneMatch(entityTag string) *ProjectsLocationsJobsExecutionsTasksListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsJobsExecutionsTasksListCall) Context(ctx context.Context) *ProjectsLocationsJobsExecutionsTasksListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsJobsExecutionsTasksListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsJobsExecutionsTasksListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/tasks")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.executions.tasks.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.jobs.executions.tasks.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRunV2ListTasksResponse.ServerResponse.Header or (if a response
// was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsJobsExecutionsTasksListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRunV2ListTasksResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRunV2ListTasksResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.jobs.executions.tasks.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsJobsExecutionsTasksListCall) Pages(ctx context.Context, f func(*GoogleCloudRunV2ListTasksResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsOperationsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a long-running operation. This method indicates that the
// client is no longer interested in the operation result. It does not cancel
// the operation. If the server doesn't support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`.
//
// - name: The name of the operation resource to be deleted.
func (r *ProjectsLocationsOperationsService) Delete(name string) *ProjectsLocationsOperationsDeleteCall {
	c := &ProjectsLocationsOperationsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsDeleteCall) Context(ctx context.Context) *ProjectsLocationsOperationsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.operations.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.operations.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleProtobufEmpty.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsOperationsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleProtobufEmpty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleProtobufEmpty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.operations.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets the latest state of a long-running operation. Clients can use this
// method to poll the operation result at intervals as recommended by the API
// service.
//
// - name: The name of the operation resource.
func (r *ProjectsLocationsOperationsService) Get(name string) *ProjectsLocationsOperationsGetCall {
	c := &ProjectsLocationsOperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsGetCall) Context(ctx context.Context) *ProjectsLocationsOperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsGetCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsOperationsListCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists operations that match the specified filter in the request. If
// the server doesn't support this method, it returns `UNIMPLEMENTED`.
//
// - name: To query for all of the operations for a project.
func (r *ProjectsLocationsOperationsService) List(name string) *ProjectsLocationsOperationsListCall {
	c := &ProjectsLocationsOperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Filter sets the optional parameter "filter": A filter for matching the
// completed or in-progress operations. The supported formats of *filter* are:
// To query for only completed operations: done:true To query for only ongoing
// operations: done:false Must be empty to query for all of the latest
// operations for the given parent project.
func (c *ProjectsLocationsOperationsListCall) Filter(filter string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// records that should be returned. Requested page size cannot exceed 100. If
// not set or set to less than or equal to 0, the default page size is 100. .
func (c *ProjectsLocationsOperationsListCall) PageSize(pageSize int64) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": Token identifying which
// result to start with, which is returned by a previous list call.
func (c *ProjectsLocationsOperationsListCall) PageToken(pageToken string) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ReturnPartialSuccess sets the optional parameter "returnPartialSuccess":
// When set to `true`, operations that are reachable are returned as normal,
// and those that are unreachable are returned in the
// ListOperationsResponse.unreachable field. This can only be `true` when
// reading across collections. For example, when `parent` is set to
// "projects/example/locations/-". This field is not supported by default and
// will result in an `UNIMPLEMENTED` error if set unless explicitly documented
// otherwise in service or product specific documentation.
func (c *ProjectsLocationsOperationsListCall) ReturnPartialSuccess(returnPartialSuccess bool) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("returnPartialSuccess", fmt.Sprint(returnPartialSuccess))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsOperationsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsOperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsListCall) Context(ctx context.Context) *ProjectsLocationsOperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningListOperationsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsListCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningListOperationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningListOperationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsOperationsListCall) Pages(ctx context.Context, f func(*GoogleLongrunningListOperationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsOperationsWaitCall struct {
	s                                     *Service
	name                                  string
	googlelongrunningwaitoperationrequest *GoogleLongrunningWaitOperationRequest
	urlParams_                            gensupport.URLParams
	ctx_                                  context.Context
	header_                               http.Header
}

// Wait: Waits until the specified long-running operation is done or reaches at
// most a specified timeout, returning the latest state. If the operation is
// already done, the latest state is immediately returned. If the timeout
// specified is greater than the default HTTP/RPC timeout, the HTTP/RPC timeout
// is used. If the server does not support this method, it returns
// `google.rpc.Code.UNIMPLEMENTED`. Note that this method is on a best-effort
// basis. It may return the latest state before the specified timeout
// (including immediately), meaning even an immediate response is no guarantee
// that the operation is done.
//
// - name: The name of the operation resource to wait on.
func (r *ProjectsLocationsOperationsService) Wait(name string, googlelongrunningwaitoperationrequest *GoogleLongrunningWaitOperationRequest) *ProjectsLocationsOperationsWaitCall {
	c := &ProjectsLocationsOperationsWaitCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlelongrunningwaitoperationrequest = googlelongrunningwaitoperationrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsOperationsWaitCall) Fields(s ...googleapi.Field) *ProjectsLocationsOperationsWaitCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsOperationsWaitCall) Context(ctx context.Context) *ProjectsLocationsOperationsWaitCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsOperationsWaitCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsOperationsWaitCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlelongrunningwaitoperationrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}:wait")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.operations.wait", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.operations.wait" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsOperationsWaitCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.operations.wait", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServicesCreateCall struct {
	s                       *Service
	parent                  string
	googlecloudrunv2service *GoogleCloudRunV2Service
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// Create: Creates a new Service in a given project and location.
//
//   - parent: The location and project in which this service should be created.
//     Format: projects/{project}/locations/{location}, where {project} can be
//     project id or number. Only lowercase characters, digits, and hyphens.
func (r *ProjectsLocationsServicesService) Create(parent string, googlecloudrunv2service *GoogleCloudRunV2Service) *ProjectsLocationsServicesCreateCall {
	c := &ProjectsLocationsServicesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudrunv2service = googlecloudrunv2service
	return c
}

// ServiceId sets the optional parameter "serviceId": Required. The unique
// identifier for the Service. It must begin with letter, and cannot end with
// hyphen; must contain fewer than 50 characters. The name of the service
// becomes {parent}/services/{service_id}.
func (c *ProjectsLocationsServicesCreateCall) ServiceId(serviceId string) *ProjectsLocationsServicesCreateCall {
	c.urlParams_.Set("serviceId", serviceId)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated and default values populated, without persisting
// the request or creating any resources.
func (c *ProjectsLocationsServicesCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsServicesCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesCreateCall) Context(ctx context.Context) *ProjectsLocationsServicesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudrunv2service)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/services")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.services.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.services.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.services.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServicesDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Service. This will cause the Service to stop serving
// traffic and will delete all revisions.
//
//   - name: The full name of the Service. Format:
//     projects/{project}/locations/{location}/services/{service}, where
//     {project} can be project id or number.
func (r *ProjectsLocationsServicesService) Delete(name string) *ProjectsLocationsServicesDeleteCall {
	c := &ProjectsLocationsServicesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": A system-generated fingerprint for
// this version of the resource. May be used to detect modification conflict
// during updates.
func (c *ProjectsLocationsServicesDeleteCall) Etag(etag string) *ProjectsLocationsServicesDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated without actually deleting any resources.
func (c *ProjectsLocationsServicesDeleteCall) ValidateOnly(validateOnly bool) *ProjectsLocationsServicesDeleteCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesDeleteCall) Context(ctx context.Context) *ProjectsLocationsServicesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.services.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.services.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.services.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServicesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a Service.
//
//   - name: The full name of the Service. Format:
//     projects/{project}/locations/{location}/services/{service}, where
//     {project} can be project id or number.
func (r *ProjectsLocationsServicesService) Get(name string) *ProjectsLocationsServicesGetCall {
	c := &ProjectsLocationsServicesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsServicesGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsServicesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesGetCall) Context(ctx context.Context) *ProjectsLocationsServicesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.services.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.services.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRunV2Service.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRunV2Service, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRunV2Service{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.services.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServicesGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the IAM Access Control policy currently in effect for the
// given Cloud Run Service. This result does not include any inherited
// policies.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsServicesService) GetIamPolicy(resource string) *ProjectsLocationsServicesGetIamPolicyCall {
	c := &ProjectsLocationsServicesGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsServicesGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsServicesGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsServicesGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsServicesGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsServicesGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.services.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.services.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsServicesGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.services.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServicesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Services. Results are sorted by creation time, descending.
//
//   - parent: The location and project to list resources on. Location must be a
//     valid Google Cloud region, and cannot be the "-" wildcard. Format:
//     projects/{project}/locations/{location}, where {project} can be project id
//     or number.
func (r *ProjectsLocationsServicesService) List(parent string) *ProjectsLocationsServicesListCall {
	c := &ProjectsLocationsServicesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of Services
// to return in this call.
func (c *ProjectsLocationsServicesListCall) PageSize(pageSize int64) *ProjectsLocationsServicesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous call to ListServices. All other parameters must match.
func (c *ProjectsLocationsServicesListCall) PageToken(pageToken string) *ProjectsLocationsServicesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": If true, returns
// deleted (but unexpired) resources along with active ones.
func (c *ProjectsLocationsServicesListCall) ShowDeleted(showDeleted bool) *ProjectsLocationsServicesListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesListCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsServicesListCall) IfNoneMatch(entityTag string) *ProjectsLocationsServicesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesListCall) Context(ctx context.Context) *ProjectsLocationsServicesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/services")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.services.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.services.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRunV2ListServicesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRunV2ListServicesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRunV2ListServicesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.services.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsServicesListCall) Pages(ctx context.Context, f func(*GoogleCloudRunV2ListServicesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsServicesPatchCall struct {
	s                       *Service
	name                    string
	googlecloudrunv2service *GoogleCloudRunV2Service
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// Patch: Updates a Service.
//
//   - name: Identifier. The fully qualified name of this Service. In
//     CreateServiceRequest, this field is ignored, and instead composed from
//     CreateServiceRequest.parent and CreateServiceRequest.service_id. Format:
//     projects/{project}/locations/{location}/services/{service_id}.
func (r *ProjectsLocationsServicesService) Patch(name string, googlecloudrunv2service *GoogleCloudRunV2Service) *ProjectsLocationsServicesPatchCall {
	c := &ProjectsLocationsServicesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrunv2service = googlecloudrunv2service
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to true, and
// if the Service does not exist, it will create a new one. The caller must
// have 'run.services.create' permissions if this is set to true and the
// Service does not exist.
func (c *ProjectsLocationsServicesPatchCall) AllowMissing(allowMissing bool) *ProjectsLocationsServicesPatchCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// be updated.
func (c *ProjectsLocationsServicesPatchCall) UpdateMask(updateMask string) *ProjectsLocationsServicesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated and default values populated, without persisting
// the request or updating any resources.
func (c *ProjectsLocationsServicesPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsServicesPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesPatchCall) Context(ctx context.Context) *ProjectsLocationsServicesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudrunv2service)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.services.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.services.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesPatchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.services.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServicesSetIamPolicyCall struct {
	s                              *Service
	resource                       string
	googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// SetIamPolicy: Sets the IAM Access control policy for the specified Service.
// Overwrites any existing policy.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsServicesService) SetIamPolicy(resource string, googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest) *ProjectsLocationsServicesSetIamPolicyCall {
	c := &ProjectsLocationsServicesSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1setiampolicyrequest = googleiamv1setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsServicesSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleiamv1setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.services.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.services.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsServicesSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.services.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServicesTestIamPermissionsCall struct {
	s                                    *Service
	resource                             string
	googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// Project. There are no permissions required for making this API call.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsServicesService) TestIamPermissions(resource string, googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest) *ProjectsLocationsServicesTestIamPermissionsCall {
	c := &ProjectsLocationsServicesTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1testiampermissionsrequest = googleiamv1testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsServicesTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleiamv1testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.services.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.services.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1TestIamPermissionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.services.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServicesRevisionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Revision.
//
//   - name: The name of the Revision to delete. Format:
//     projects/{project}/locations/{location}/services/{service}/revisions/{revis
//     ion}.
func (r *ProjectsLocationsServicesRevisionsService) Delete(name string) *ProjectsLocationsServicesRevisionsDeleteCall {
	c := &ProjectsLocationsServicesRevisionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": A system-generated fingerprint for
// this version of the resource. This may be used to detect modification
// conflict during updates.
func (c *ProjectsLocationsServicesRevisionsDeleteCall) Etag(etag string) *ProjectsLocationsServicesRevisionsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated without actually deleting any resources.
func (c *ProjectsLocationsServicesRevisionsDeleteCall) ValidateOnly(validateOnly bool) *ProjectsLocationsServicesRevisionsDeleteCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesRevisionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesRevisionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesRevisionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsServicesRevisionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesRevisionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesRevisionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.services.revisions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.services.revisions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesRevisionsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.services.revisions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServicesRevisionsExportStatusCall struct {
	s            *Service
	name         string
	operationId  string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ExportStatus: Read the status of an image export operation.
//
//   - name: The name of the resource of which image export operation status has
//     to be fetched. Format:
//     `projects/{project_id_or_number}/locations/{location}/services/{service}/re
//     visions/{revision}` for Revision
//     `projects/{project_id_or_number}/locations/{location}/jobs/{job}/executions
//     /{execution}` for Execution.
//   - operationId: The operation id returned from ExportImage.
func (r *ProjectsLocationsServicesRevisionsService) ExportStatus(name string, operationId string) *ProjectsLocationsServicesRevisionsExportStatusCall {
	c := &ProjectsLocationsServicesRevisionsExportStatusCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.operationId = operationId
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesRevisionsExportStatusCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesRevisionsExportStatusCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsServicesRevisionsExportStatusCall) IfNoneMatch(entityTag string) *ProjectsLocationsServicesRevisionsExportStatusCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesRevisionsExportStatusCall) Context(ctx context.Context) *ProjectsLocationsServicesRevisionsExportStatusCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesRevisionsExportStatusCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesRevisionsExportStatusCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}/{+operationId}:exportStatus")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name":        c.name,
		"operationId": c.operationId,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.services.revisions.exportStatus", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.services.revisions.exportStatus" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRunV2ExportStatusResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesRevisionsExportStatusCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRunV2ExportStatusResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRunV2ExportStatusResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.services.revisions.exportStatus", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServicesRevisionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a Revision.
//
//   - name: The full name of the Revision. Format:
//     projects/{project}/locations/{location}/services/{service}/revisions/{revis
//     ion}.
func (r *ProjectsLocationsServicesRevisionsService) Get(name string) *ProjectsLocationsServicesRevisionsGetCall {
	c := &ProjectsLocationsServicesRevisionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesRevisionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesRevisionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsServicesRevisionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsServicesRevisionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesRevisionsGetCall) Context(ctx context.Context) *ProjectsLocationsServicesRevisionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesRevisionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesRevisionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.services.revisions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.services.revisions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRunV2Revision.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesRevisionsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRunV2Revision, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRunV2Revision{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.services.revisions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsServicesRevisionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Revisions from a given Service, or from a given location.
// Results are sorted by creation time, descending.
//
//   - parent: The Service from which the Revisions should be listed. To list all
//     Revisions across Services, use "-" instead of Service name. Format:
//     projects/{project}/locations/{location}/services/{service}.
func (r *ProjectsLocationsServicesRevisionsService) List(parent string) *ProjectsLocationsServicesRevisionsListCall {
	c := &ProjectsLocationsServicesRevisionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of revisions
// to return in this call.
func (c *ProjectsLocationsServicesRevisionsListCall) PageSize(pageSize int64) *ProjectsLocationsServicesRevisionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous call to ListRevisions. All other parameters must match.
func (c *ProjectsLocationsServicesRevisionsListCall) PageToken(pageToken string) *ProjectsLocationsServicesRevisionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": If true, returns
// deleted (but unexpired) resources along with active ones.
func (c *ProjectsLocationsServicesRevisionsListCall) ShowDeleted(showDeleted bool) *ProjectsLocationsServicesRevisionsListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsServicesRevisionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsServicesRevisionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsServicesRevisionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsServicesRevisionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsServicesRevisionsListCall) Context(ctx context.Context) *ProjectsLocationsServicesRevisionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsServicesRevisionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsServicesRevisionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/revisions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.services.revisions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.services.revisions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRunV2ListRevisionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsServicesRevisionsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRunV2ListRevisionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRunV2ListRevisionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.services.revisions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsServicesRevisionsListCall) Pages(ctx context.Context, f func(*GoogleCloudRunV2ListRevisionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsWorkerPoolsCreateCall struct {
	s                          *Service
	parent                     string
	googlecloudrunv2workerpool *GoogleCloudRunV2WorkerPool
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Create: Creates a new WorkerPool in a given project and location.
//
//   - parent: The location and project in which this worker pool should be
//     created. Format: `projects/{project}/locations/{location}`, where
//     `{project}` can be project id or number. Only lowercase characters,
//     digits, and hyphens.
func (r *ProjectsLocationsWorkerPoolsService) Create(parent string, googlecloudrunv2workerpool *GoogleCloudRunV2WorkerPool) *ProjectsLocationsWorkerPoolsCreateCall {
	c := &ProjectsLocationsWorkerPoolsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.googlecloudrunv2workerpool = googlecloudrunv2workerpool
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated and default values populated, without persisting
// the request or creating any resources.
func (c *ProjectsLocationsWorkerPoolsCreateCall) ValidateOnly(validateOnly bool) *ProjectsLocationsWorkerPoolsCreateCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// WorkerPoolId sets the optional parameter "workerPoolId": Required. The
// unique identifier for the WorkerPool. It must begin with letter, and cannot
// end with hyphen; must contain fewer than 50 characters. The name of the
// worker pool becomes `{parent}/workerPools/{worker_pool_id}`.
func (c *ProjectsLocationsWorkerPoolsCreateCall) WorkerPoolId(workerPoolId string) *ProjectsLocationsWorkerPoolsCreateCall {
	c.urlParams_.Set("workerPoolId", workerPoolId)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkerPoolsCreateCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkerPoolsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkerPoolsCreateCall) Context(ctx context.Context) *ProjectsLocationsWorkerPoolsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkerPoolsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkerPoolsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudrunv2workerpool)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/workerPools")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.create", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.workerPools.create" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkerPoolsCreateCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.create", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWorkerPoolsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a WorkerPool.
//
//   - name: The full name of the WorkerPool. Format:
//     `projects/{project}/locations/{location}/workerPools/{worker_pool}`, where
//     `{project}` can be project id or number.
func (r *ProjectsLocationsWorkerPoolsService) Delete(name string) *ProjectsLocationsWorkerPoolsDeleteCall {
	c := &ProjectsLocationsWorkerPoolsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": A system-generated fingerprint for
// this version of the resource. May be used to detect modification conflict
// during updates.
func (c *ProjectsLocationsWorkerPoolsDeleteCall) Etag(etag string) *ProjectsLocationsWorkerPoolsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated without actually deleting any resources.
func (c *ProjectsLocationsWorkerPoolsDeleteCall) ValidateOnly(validateOnly bool) *ProjectsLocationsWorkerPoolsDeleteCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkerPoolsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkerPoolsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkerPoolsDeleteCall) Context(ctx context.Context) *ProjectsLocationsWorkerPoolsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkerPoolsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkerPoolsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.workerPools.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkerPoolsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWorkerPoolsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a WorkerPool.
//
//   - name: The full name of the WorkerPool. Format:
//     `projects/{project}/locations/{location}/workerPools/{worker_pool}`, where
//     `{project}` can be project id or number.
func (r *ProjectsLocationsWorkerPoolsService) Get(name string) *ProjectsLocationsWorkerPoolsGetCall {
	c := &ProjectsLocationsWorkerPoolsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkerPoolsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkerPoolsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsWorkerPoolsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsWorkerPoolsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkerPoolsGetCall) Context(ctx context.Context) *ProjectsLocationsWorkerPoolsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkerPoolsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkerPoolsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.workerPools.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRunV2WorkerPool.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkerPoolsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRunV2WorkerPool, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRunV2WorkerPool{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWorkerPoolsGetIamPolicyCall struct {
	s            *Service
	resource     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetIamPolicy: Gets the IAM Access Control policy currently in effect for the
// given Cloud Run WorkerPool. This result does not include any inherited
// policies.
//
//   - resource: REQUIRED: The resource for which the policy is being requested.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsWorkerPoolsService) GetIamPolicy(resource string) *ProjectsLocationsWorkerPoolsGetIamPolicyCall {
	c := &ProjectsLocationsWorkerPoolsGetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	return c
}

// OptionsRequestedPolicyVersion sets the optional parameter
// "options.requestedPolicyVersion": The maximum policy version that will be
// used to format the policy. Valid values are 0, 1, and 3. Requests specifying
// an invalid value will be rejected. Requests for policies with any
// conditional role bindings must specify version 3. Policies with no
// conditional role bindings may specify any valid value or leave the field
// unset. The policy in the response might use the policy version that you
// specified, or it might use a lower policy version. For example, if you
// specify version 3, but the policy has no conditional role bindings, the
// response uses version 1. To learn which resources support conditions in
// their IAM policies, see the IAM documentation
// (https://cloud.google.com/iam/help/conditions/resource-policies).
func (c *ProjectsLocationsWorkerPoolsGetIamPolicyCall) OptionsRequestedPolicyVersion(optionsRequestedPolicyVersion int64) *ProjectsLocationsWorkerPoolsGetIamPolicyCall {
	c.urlParams_.Set("options.requestedPolicyVersion", fmt.Sprint(optionsRequestedPolicyVersion))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkerPoolsGetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkerPoolsGetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsWorkerPoolsGetIamPolicyCall) IfNoneMatch(entityTag string) *ProjectsLocationsWorkerPoolsGetIamPolicyCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkerPoolsGetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsWorkerPoolsGetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkerPoolsGetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkerPoolsGetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+resource}:getIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.getIamPolicy", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.workerPools.getIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsWorkerPoolsGetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.getIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWorkerPoolsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists WorkerPools. Results are sorted by creation time, descending.
//
//   - parent: The location and project to list resources on. Location must be a
//     valid Google Cloud region, and cannot be the "-" wildcard. Format:
//     `projects/{project}/locations/{location}`, where `{project}` can be
//     project id or number.
func (r *ProjectsLocationsWorkerPoolsService) List(parent string) *ProjectsLocationsWorkerPoolsListCall {
	c := &ProjectsLocationsWorkerPoolsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of
// WorkerPools to return in this call.
func (c *ProjectsLocationsWorkerPoolsListCall) PageSize(pageSize int64) *ProjectsLocationsWorkerPoolsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous call to ListWorkerPools. All other parameters must match.
func (c *ProjectsLocationsWorkerPoolsListCall) PageToken(pageToken string) *ProjectsLocationsWorkerPoolsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": If true, returns
// deleted (but unexpired) resources along with active ones.
func (c *ProjectsLocationsWorkerPoolsListCall) ShowDeleted(showDeleted bool) *ProjectsLocationsWorkerPoolsListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkerPoolsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkerPoolsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsWorkerPoolsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsWorkerPoolsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkerPoolsListCall) Context(ctx context.Context) *ProjectsLocationsWorkerPoolsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkerPoolsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkerPoolsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/workerPools")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.workerPools.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRunV2ListWorkerPoolsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkerPoolsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRunV2ListWorkerPoolsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRunV2ListWorkerPoolsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsWorkerPoolsListCall) Pages(ctx context.Context, f func(*GoogleCloudRunV2ListWorkerPoolsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsLocationsWorkerPoolsPatchCall struct {
	s                          *Service
	name                       string
	googlecloudrunv2workerpool *GoogleCloudRunV2WorkerPool
	urlParams_                 gensupport.URLParams
	ctx_                       context.Context
	header_                    http.Header
}

// Patch: Updates a WorkerPool.
//
//   - name: The fully qualified name of this WorkerPool. In
//     CreateWorkerPoolRequest, this field is ignored, and instead composed from
//     CreateWorkerPoolRequest.parent and CreateWorkerPoolRequest.worker_id.
//     Format: `projects/{project}/locations/{location}/workerPools/{worker_id}`.
func (r *ProjectsLocationsWorkerPoolsService) Patch(name string, googlecloudrunv2workerpool *GoogleCloudRunV2WorkerPool) *ProjectsLocationsWorkerPoolsPatchCall {
	c := &ProjectsLocationsWorkerPoolsPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.googlecloudrunv2workerpool = googlecloudrunv2workerpool
	return c
}

// AllowMissing sets the optional parameter "allowMissing": If set to true, and
// if the WorkerPool does not exist, it will create a new one. The caller must
// have 'run.workerpools.create' permissions if this is set to true and the
// WorkerPool does not exist.
func (c *ProjectsLocationsWorkerPoolsPatchCall) AllowMissing(allowMissing bool) *ProjectsLocationsWorkerPoolsPatchCall {
	c.urlParams_.Set("allowMissing", fmt.Sprint(allowMissing))
	return c
}

// ForceNewRevision sets the optional parameter "forceNewRevision": If set to
// true, a new revision will be created from the template even if the system
// doesn't detect any changes from the previously deployed revision. This may
// be useful for cases where the underlying resources need to be recreated or
// reinitialized. For example if the image is specified by label, but the
// underlying image digest has changed) or if the container performs deployment
// initialization work that needs to be performed again.
func (c *ProjectsLocationsWorkerPoolsPatchCall) ForceNewRevision(forceNewRevision bool) *ProjectsLocationsWorkerPoolsPatchCall {
	c.urlParams_.Set("forceNewRevision", fmt.Sprint(forceNewRevision))
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields to
// be updated.
func (c *ProjectsLocationsWorkerPoolsPatchCall) UpdateMask(updateMask string) *ProjectsLocationsWorkerPoolsPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated and default values populated, without persisting
// the request or updating any resources.
func (c *ProjectsLocationsWorkerPoolsPatchCall) ValidateOnly(validateOnly bool) *ProjectsLocationsWorkerPoolsPatchCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkerPoolsPatchCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkerPoolsPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkerPoolsPatchCall) Context(ctx context.Context) *ProjectsLocationsWorkerPoolsPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkerPoolsPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkerPoolsPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googlecloudrunv2workerpool)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.workerPools.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkerPoolsPatchCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWorkerPoolsSetIamPolicyCall struct {
	s                              *Service
	resource                       string
	googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// SetIamPolicy: Sets the IAM Access control policy for the specified
// WorkerPool. Overwrites any existing policy.
//
//   - resource: REQUIRED: The resource for which the policy is being specified.
//     See Resource names (https://cloud.google.com/apis/design/resource_names)
//     for the appropriate value for this field.
func (r *ProjectsLocationsWorkerPoolsService) SetIamPolicy(resource string, googleiamv1setiampolicyrequest *GoogleIamV1SetIamPolicyRequest) *ProjectsLocationsWorkerPoolsSetIamPolicyCall {
	c := &ProjectsLocationsWorkerPoolsSetIamPolicyCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1setiampolicyrequest = googleiamv1setiampolicyrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkerPoolsSetIamPolicyCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkerPoolsSetIamPolicyCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkerPoolsSetIamPolicyCall) Context(ctx context.Context) *ProjectsLocationsWorkerPoolsSetIamPolicyCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkerPoolsSetIamPolicyCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkerPoolsSetIamPolicyCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleiamv1setiampolicyrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+resource}:setIamPolicy")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.setIamPolicy", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.workerPools.setIamPolicy" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1Policy.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ProjectsLocationsWorkerPoolsSetIamPolicyCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1Policy, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1Policy{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.setIamPolicy", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWorkerPoolsTestIamPermissionsCall struct {
	s                                    *Service
	resource                             string
	googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// TestIamPermissions: Returns permissions that a caller has on the specified
// Project. There are no permissions required for making this API call.
//
//   - resource: REQUIRED: The resource for which the policy detail is being
//     requested. See Resource names
//     (https://cloud.google.com/apis/design/resource_names) for the appropriate
//     value for this field.
func (r *ProjectsLocationsWorkerPoolsService) TestIamPermissions(resource string, googleiamv1testiampermissionsrequest *GoogleIamV1TestIamPermissionsRequest) *ProjectsLocationsWorkerPoolsTestIamPermissionsCall {
	c := &ProjectsLocationsWorkerPoolsTestIamPermissionsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.resource = resource
	c.googleiamv1testiampermissionsrequest = googleiamv1testiampermissionsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkerPoolsTestIamPermissionsCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkerPoolsTestIamPermissionsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkerPoolsTestIamPermissionsCall) Context(ctx context.Context) *ProjectsLocationsWorkerPoolsTestIamPermissionsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkerPoolsTestIamPermissionsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkerPoolsTestIamPermissionsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.googleiamv1testiampermissionsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+resource}:testIamPermissions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"resource": c.resource,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.testIamPermissions", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.workerPools.testIamPermissions" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleIamV1TestIamPermissionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkerPoolsTestIamPermissionsCall) Do(opts ...googleapi.CallOption) (*GoogleIamV1TestIamPermissionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleIamV1TestIamPermissionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.testIamPermissions", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWorkerPoolsRevisionsDeleteCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Revision.
//
//   - name: The name of the Revision to delete. Format:
//     projects/{project}/locations/{location}/services/{service}/revisions/{revis
//     ion}.
func (r *ProjectsLocationsWorkerPoolsRevisionsService) Delete(name string) *ProjectsLocationsWorkerPoolsRevisionsDeleteCall {
	c := &ProjectsLocationsWorkerPoolsRevisionsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Etag sets the optional parameter "etag": A system-generated fingerprint for
// this version of the resource. This may be used to detect modification
// conflict during updates.
func (c *ProjectsLocationsWorkerPoolsRevisionsDeleteCall) Etag(etag string) *ProjectsLocationsWorkerPoolsRevisionsDeleteCall {
	c.urlParams_.Set("etag", etag)
	return c
}

// ValidateOnly sets the optional parameter "validateOnly": Indicates that the
// request should be validated without actually deleting any resources.
func (c *ProjectsLocationsWorkerPoolsRevisionsDeleteCall) ValidateOnly(validateOnly bool) *ProjectsLocationsWorkerPoolsRevisionsDeleteCall {
	c.urlParams_.Set("validateOnly", fmt.Sprint(validateOnly))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkerPoolsRevisionsDeleteCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkerPoolsRevisionsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkerPoolsRevisionsDeleteCall) Context(ctx context.Context) *ProjectsLocationsWorkerPoolsRevisionsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkerPoolsRevisionsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkerPoolsRevisionsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.revisions.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.workerPools.revisions.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleLongrunningOperation.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkerPoolsRevisionsDeleteCall) Do(opts ...googleapi.CallOption) (*GoogleLongrunningOperation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleLongrunningOperation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.revisions.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWorkerPoolsRevisionsGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Gets information about a Revision.
//
//   - name: The full name of the Revision. Format:
//     projects/{project}/locations/{location}/services/{service}/revisions/{revis
//     ion}.
func (r *ProjectsLocationsWorkerPoolsRevisionsService) Get(name string) *ProjectsLocationsWorkerPoolsRevisionsGetCall {
	c := &ProjectsLocationsWorkerPoolsRevisionsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkerPoolsRevisionsGetCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkerPoolsRevisionsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsWorkerPoolsRevisionsGetCall) IfNoneMatch(entityTag string) *ProjectsLocationsWorkerPoolsRevisionsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkerPoolsRevisionsGetCall) Context(ctx context.Context) *ProjectsLocationsWorkerPoolsRevisionsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkerPoolsRevisionsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkerPoolsRevisionsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.revisions.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.workerPools.revisions.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRunV2Revision.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkerPoolsRevisionsGetCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRunV2Revision, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRunV2Revision{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.revisions.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsLocationsWorkerPoolsRevisionsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists Revisions from a given Service, or from a given location.
// Results are sorted by creation time, descending.
//
//   - parent: The Service from which the Revisions should be listed. To list all
//     Revisions across Services, use "-" instead of Service name. Format:
//     projects/{project}/locations/{location}/services/{service}.
func (r *ProjectsLocationsWorkerPoolsRevisionsService) List(parent string) *ProjectsLocationsWorkerPoolsRevisionsListCall {
	c := &ProjectsLocationsWorkerPoolsRevisionsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": Maximum number of revisions
// to return in this call.
func (c *ProjectsLocationsWorkerPoolsRevisionsListCall) PageSize(pageSize int64) *ProjectsLocationsWorkerPoolsRevisionsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token received
// from a previous call to ListRevisions. All other parameters must match.
func (c *ProjectsLocationsWorkerPoolsRevisionsListCall) PageToken(pageToken string) *ProjectsLocationsWorkerPoolsRevisionsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// ShowDeleted sets the optional parameter "showDeleted": If true, returns
// deleted (but unexpired) resources along with active ones.
func (c *ProjectsLocationsWorkerPoolsRevisionsListCall) ShowDeleted(showDeleted bool) *ProjectsLocationsWorkerPoolsRevisionsListCall {
	c.urlParams_.Set("showDeleted", fmt.Sprint(showDeleted))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsLocationsWorkerPoolsRevisionsListCall) Fields(s ...googleapi.Field) *ProjectsLocationsWorkerPoolsRevisionsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsLocationsWorkerPoolsRevisionsListCall) IfNoneMatch(entityTag string) *ProjectsLocationsWorkerPoolsRevisionsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsLocationsWorkerPoolsRevisionsListCall) Context(ctx context.Context) *ProjectsLocationsWorkerPoolsRevisionsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsLocationsWorkerPoolsRevisionsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsLocationsWorkerPoolsRevisionsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2/{+parent}/revisions")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.revisions.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "run.projects.locations.workerPools.revisions.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *GoogleCloudRunV2ListRevisionsResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsLocationsWorkerPoolsRevisionsListCall) Do(opts ...googleapi.CallOption) (*GoogleCloudRunV2ListRevisionsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GoogleCloudRunV2ListRevisionsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "run.projects.locations.workerPools.revisions.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *ProjectsLocationsWorkerPoolsRevisionsListCall) Pages(ctx context.Context, f func(*GoogleCloudRunV2ListRevisionsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}
