// Copyright 2025 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package sqladmin provides access to the Cloud SQL Admin API.
//
// For product documentation, see: https://cloud.google.com/sql/docs
//
// # Library status
//
// These client libraries are officially supported by Google. However, this
// library is considered complete and is in maintenance mode. This means
// that we will address critical bugs and security issues but will not add
// any new features.
//
// When possible, we recommend using our newer
// [Cloud Client Libraries for Go](https://pkg.go.dev/cloud.google.com/go)
// that are still actively being worked and iterated on.
//
// # Creating a client
//
// Usage example:
//
//	import "google.golang.org/api/sqladmin/v1beta4"
//	...
//	ctx := context.Background()
//	sqladminService, err := sqladmin.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for
// authentication. For information on how to create and obtain Application
// Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// # Other authentication options
//
// By default, all available scopes (see "Constants") are used to authenticate.
// To restrict scopes, use [google.golang.org/api/option.WithScopes]:
//
//	sqladminService, err := sqladmin.NewService(ctx, option.WithScopes(sqladmin.SqlserviceAdminScope))
//
// To use an API key for authentication (note: some APIs do not support API
// keys), use [google.golang.org/api/option.WithAPIKey]:
//
//	sqladminService, err := sqladmin.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth
// flow, use [google.golang.org/api/option.WithTokenSource]:
//
//	config := &oauth2.Config{...}
//	// ...
//	token, err := config.Exchange(ctx, ...)
//	sqladminService, err := sqladmin.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See [google.golang.org/api/option.ClientOption] for details on options.
package sqladmin // import "google.golang.org/api/sqladmin/v1beta4"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"log/slog"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	"github.com/googleapis/gax-go/v2/internallog"
	googleapi "google.golang.org/api/googleapi"
	internal "google.golang.org/api/internal"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint
var _ = internal.Version
var _ = internallog.New

const apiId = "sqladmin:v1beta4"
const apiName = "sqladmin"
const apiVersion = "v1beta4"
const basePath = "https://sqladmin.googleapis.com/"
const basePathTemplate = "https://sqladmin.UNIVERSE_DOMAIN/"
const mtlsBasePath = "https://sqladmin.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the email
	// address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"

	// Manage your Google SQL Service instances
	SqlserviceAdminScope = "https://www.googleapis.com/auth/sqlservice.admin"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := internaloption.WithDefaultScopes(
		"https://www.googleapis.com/auth/cloud-platform",
		"https://www.googleapis.com/auth/sqlservice.admin",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultEndpointTemplate(basePathTemplate))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	opts = append(opts, internaloption.EnableNewAuthLibrary())
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s := &Service{client: client, BasePath: basePath, logger: internaloption.GetLogger(opts)}
	s.BackupRuns = NewBackupRunsService(s)
	s.Backups = NewBackupsService(s)
	s.Connect = NewConnectService(s)
	s.Databases = NewDatabasesService(s)
	s.Flags = NewFlagsService(s)
	s.Instances = NewInstancesService(s)
	s.Operations = NewOperationsService(s)
	s.Projects = NewProjectsService(s)
	s.SslCerts = NewSslCertsService(s)
	s.Tiers = NewTiersService(s)
	s.Users = NewUsersService(s)
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	return NewService(context.TODO(), option.WithHTTPClient(client))
}

type Service struct {
	client    *http.Client
	logger    *slog.Logger
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	BackupRuns *BackupRunsService

	Backups *BackupsService

	Connect *ConnectService

	Databases *DatabasesService

	Flags *FlagsService

	Instances *InstancesService

	Operations *OperationsService

	Projects *ProjectsService

	SslCerts *SslCertsService

	Tiers *TiersService

	Users *UsersService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewBackupRunsService(s *Service) *BackupRunsService {
	rs := &BackupRunsService{s: s}
	return rs
}

type BackupRunsService struct {
	s *Service
}

func NewBackupsService(s *Service) *BackupsService {
	rs := &BackupsService{s: s}
	return rs
}

type BackupsService struct {
	s *Service
}

func NewConnectService(s *Service) *ConnectService {
	rs := &ConnectService{s: s}
	return rs
}

type ConnectService struct {
	s *Service
}

func NewDatabasesService(s *Service) *DatabasesService {
	rs := &DatabasesService{s: s}
	return rs
}

type DatabasesService struct {
	s *Service
}

func NewFlagsService(s *Service) *FlagsService {
	rs := &FlagsService{s: s}
	return rs
}

type FlagsService struct {
	s *Service
}

func NewInstancesService(s *Service) *InstancesService {
	rs := &InstancesService{s: s}
	return rs
}

type InstancesService struct {
	s *Service
}

func NewOperationsService(s *Service) *OperationsService {
	rs := &OperationsService{s: s}
	return rs
}

type OperationsService struct {
	s *Service
}

func NewProjectsService(s *Service) *ProjectsService {
	rs := &ProjectsService{s: s}
	rs.Instances = NewProjectsInstancesService(s)
	return rs
}

type ProjectsService struct {
	s *Service

	Instances *ProjectsInstancesService
}

func NewProjectsInstancesService(s *Service) *ProjectsInstancesService {
	rs := &ProjectsInstancesService{s: s}
	return rs
}

type ProjectsInstancesService struct {
	s *Service
}

func NewSslCertsService(s *Service) *SslCertsService {
	rs := &SslCertsService{s: s}
	return rs
}

type SslCertsService struct {
	s *Service
}

func NewTiersService(s *Service) *TiersService {
	rs := &TiersService{s: s}
	return rs
}

type TiersService struct {
	s *Service
}

func NewUsersService(s *Service) *UsersService {
	rs := &UsersService{s: s}
	return rs
}

type UsersService struct {
	s *Service
}

// AclEntry: An entry for an Access Control list.
type AclEntry struct {
	// ExpirationTime: The time when this access control entry expires in RFC 3339
	// (https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	ExpirationTime string `json:"expirationTime,omitempty"`
	// Kind: This is always `sql#aclEntry`.
	Kind string `json:"kind,omitempty"`
	// Name: Optional. A label to identify this entry.
	Name string `json:"name,omitempty"`
	// Value: The allowlisted value for the access control list.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExpirationTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExpirationTime") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AclEntry) MarshalJSON() ([]byte, error) {
	type NoMethod AclEntry
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AcquireSsrsLeaseContext: Acquire SSRS lease context.
type AcquireSsrsLeaseContext struct {
	// Duration: Lease duration needed for the SSRS setup.
	Duration string `json:"duration,omitempty"`
	// ReportDatabase: The report database to be used for the SSRS setup.
	ReportDatabase string `json:"reportDatabase,omitempty"`
	// ServiceLogin: The username to be used as the service login to connect to the
	// report database for SSRS setup.
	ServiceLogin string `json:"serviceLogin,omitempty"`
	// SetupLogin: The username to be used as the setup login to connect to the
	// database server for SSRS setup.
	SetupLogin string `json:"setupLogin,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Duration") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Duration") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AcquireSsrsLeaseContext) MarshalJSON() ([]byte, error) {
	type NoMethod AcquireSsrsLeaseContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AdvancedMachineFeatures: Specifies options for controlling advanced machine
// features.
type AdvancedMachineFeatures struct {
	// ThreadsPerCore: The number of threads per physical core.
	ThreadsPerCore int64 `json:"threadsPerCore,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ThreadsPerCore") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ThreadsPerCore") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AdvancedMachineFeatures) MarshalJSON() ([]byte, error) {
	type NoMethod AdvancedMachineFeatures
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ApiWarning: An Admin API warning message.
type ApiWarning struct {
	// Code: Code to uniquely identify the warning type.
	//
	// Possible values:
	//   "SQL_API_WARNING_CODE_UNSPECIFIED" - An unknown or unset warning type from
	// Cloud SQL API.
	//   "REGION_UNREACHABLE" - Warning when one or more regions are not reachable.
	// The returned result set may be incomplete.
	//   "MAX_RESULTS_EXCEEDS_LIMIT" - Warning when user provided maxResults
	// parameter exceeds the limit. The returned result set may be incomplete.
	//   "COMPROMISED_CREDENTIALS" - Warning when user tries to create/update a
	// user with credentials that have previously been compromised by a public data
	// breach.
	//   "INTERNAL_STATE_FAILURE" - Warning when the operation succeeds but some
	// non-critical workflow state failed.
	Code string `json:"code,omitempty"`
	// Message: The warning message.
	Message string `json:"message,omitempty"`
	// Region: The region name for REGION_UNREACHABLE warning.
	Region string `json:"region,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ApiWarning) MarshalJSON() ([]byte, error) {
	type NoMethod ApiWarning
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// AvailableDatabaseVersion: An available database version. It can be a major
// or a minor version.
type AvailableDatabaseVersion struct {
	// DisplayName: The database version's display name.
	DisplayName string `json:"displayName,omitempty"`
	// MajorVersion: The version's major version name.
	MajorVersion string `json:"majorVersion,omitempty"`
	// Name: The database version name. For MySQL 8.0, this string provides the
	// database major and minor version.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisplayName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s AvailableDatabaseVersion) MarshalJSON() ([]byte, error) {
	type NoMethod AvailableDatabaseVersion
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Backup: A backup resource.
type Backup struct {
	// BackupInterval: Output only. This output contains the following values:
	// start_time: All database writes up to this time are available. end_time: Any
	// database writes after this time aren't available.
	BackupInterval *Interval `json:"backupInterval,omitempty"`
	// BackupKind: Output only. Specifies the kind of backup, PHYSICAL or
	// DEFAULT_SNAPSHOT.
	//
	// Possible values:
	//   "SQL_BACKUP_KIND_UNSPECIFIED" - This is an unknown BackupKind.
	//   "SNAPSHOT" - Snapshot-based backups.
	//   "PHYSICAL" - Physical backups.
	BackupKind string `json:"backupKind,omitempty"`
	// BackupRun: Output only. The mapping to backup run resource used for IAM
	// validations.
	BackupRun string `json:"backupRun,omitempty"`
	// DatabaseVersion: Output only. The database version of the instance of at the
	// time this backup was made.
	//
	// Possible values:
	//   "SQL_DATABASE_VERSION_UNSPECIFIED" - This is an unknown database version.
	//   "MYSQL_5_1" - The database version is MySQL 5.1.
	//   "MYSQL_5_5" - The database version is MySQL 5.5.
	//   "MYSQL_5_6" - The database version is MySQL 5.6.
	//   "MYSQL_5_7" - The database version is MySQL 5.7.
	//   "MYSQL_8_0" - The database version is MySQL 8.
	//   "MYSQL_8_0_18" - The database major version is MySQL 8.0 and the minor
	// version is 18.
	//   "MYSQL_8_0_26" - The database major version is MySQL 8.0 and the minor
	// version is 26.
	//   "MYSQL_8_0_27" - The database major version is MySQL 8.0 and the minor
	// version is 27.
	//   "MYSQL_8_0_28" - The database major version is MySQL 8.0 and the minor
	// version is 28.
	//   "MYSQL_8_0_29" - The database major version is MySQL 8.0 and the minor
	// version is 29.
	//   "MYSQL_8_0_30" - The database major version is MySQL 8.0 and the minor
	// version is 30.
	//   "MYSQL_8_0_31" - The database major version is MySQL 8.0 and the minor
	// version is 31.
	//   "MYSQL_8_0_32" - The database major version is MySQL 8.0 and the minor
	// version is 32.
	//   "MYSQL_8_0_33" - The database major version is MySQL 8.0 and the minor
	// version is 33.
	//   "MYSQL_8_0_34" - The database major version is MySQL 8.0 and the minor
	// version is 34.
	//   "MYSQL_8_0_35" - The database major version is MySQL 8.0 and the minor
	// version is 35.
	//   "MYSQL_8_0_36" - The database major version is MySQL 8.0 and the minor
	// version is 36.
	//   "MYSQL_8_0_37" - The database major version is MySQL 8.0 and the minor
	// version is 37.
	//   "MYSQL_8_0_39" - The database major version is MySQL 8.0 and the minor
	// version is 39.
	//   "MYSQL_8_0_40" - The database major version is MySQL 8.0 and the minor
	// version is 40.
	//   "MYSQL_8_0_41" - The database major version is MySQL 8.0 and the minor
	// version is 41.
	//   "MYSQL_8_0_42" - The database major version is MySQL 8.0 and the minor
	// version is 42.
	//   "MYSQL_8_0_43" - The database major version is MySQL 8.0 and the minor
	// version is 43.
	//   "MYSQL_8_0_44" - The database major version is MySQL 8.0 and the minor
	// version is 44.
	//   "MYSQL_8_0_45" - The database major version is MySQL 8.0 and the minor
	// version is 45.
	//   "MYSQL_8_0_46" - The database major version is MySQL 8.0 and the minor
	// version is 46.
	//   "MYSQL_8_4" - The database version is MySQL 8.4.
	//   "SQLSERVER_2017_STANDARD" - The database version is SQL Server 2017
	// Standard.
	//   "SQLSERVER_2017_ENTERPRISE" - The database version is SQL Server 2017
	// Enterprise.
	//   "SQLSERVER_2017_EXPRESS" - The database version is SQL Server 2017
	// Express.
	//   "SQLSERVER_2017_WEB" - The database version is SQL Server 2017 Web.
	//   "POSTGRES_9_6" - The database version is PostgreSQL 9.6.
	//   "POSTGRES_10" - The database version is PostgreSQL 10.
	//   "POSTGRES_11" - The database version is PostgreSQL 11.
	//   "POSTGRES_12" - The database version is PostgreSQL 12.
	//   "POSTGRES_13" - The database version is PostgreSQL 13.
	//   "POSTGRES_14" - The database version is PostgreSQL 14.
	//   "POSTGRES_15" - The database version is PostgreSQL 15.
	//   "POSTGRES_16" - The database version is PostgreSQL 16.
	//   "POSTGRES_17" - The database version is PostgreSQL 17.
	//   "POSTGRES_18" - The database version is PostgreSQL 18.
	//   "SQLSERVER_2019_STANDARD" - The database version is SQL Server 2019
	// Standard.
	//   "SQLSERVER_2019_ENTERPRISE" - The database version is SQL Server 2019
	// Enterprise.
	//   "SQLSERVER_2019_EXPRESS" - The database version is SQL Server 2019
	// Express.
	//   "SQLSERVER_2019_WEB" - The database version is SQL Server 2019 Web.
	//   "SQLSERVER_2022_STANDARD" - The database version is SQL Server 2022
	// Standard.
	//   "SQLSERVER_2022_ENTERPRISE" - The database version is SQL Server 2022
	// Enterprise.
	//   "SQLSERVER_2022_EXPRESS" - The database version is SQL Server 2022
	// Express.
	//   "SQLSERVER_2022_WEB" - The database version is SQL Server 2022 Web.
	DatabaseVersion string `json:"databaseVersion,omitempty"`
	// Description: The description of this backup.
	Description string `json:"description,omitempty"`
	// Error: Output only. Information about why the backup operation fails (for
	// example, when the backup state fails).
	Error *OperationError `json:"error,omitempty"`
	// ExpiryTime: Backup expiration time. A UTC timestamp of when this resource
	// expired.
	ExpiryTime string `json:"expiryTime,omitempty"`
	// Instance: The name of the database instance.
	Instance string `json:"instance,omitempty"`
	// InstanceDeletionTime: Optional. Output only. Timestamp in UTC of when the
	// instance associated with this backup is deleted.
	InstanceDeletionTime string `json:"instanceDeletionTime,omitempty"`
	// InstanceSettings: Optional. Output only. Instance setting of the source
	// instance that's associated with this backup.
	InstanceSettings *DatabaseInstance `json:"instanceSettings,omitempty"`
	// Kind: Output only. This is always `sql#backup`.
	Kind string `json:"kind,omitempty"`
	// KmsKey: Output only. This output contains the encryption configuration for a
	// backup and the resource name of the KMS key for disk encryption.
	KmsKey string `json:"kmsKey,omitempty"`
	// KmsKeyVersion: Output only. This output contains the encryption status for a
	// backup and the version of the KMS key that's used to encrypt the Cloud SQL
	// instance.
	KmsKeyVersion string `json:"kmsKeyVersion,omitempty"`
	// Location: The storage location of the backups. The location can be
	// multi-regional.
	Location string `json:"location,omitempty"`
	// MaxChargeableBytes: Output only. The maximum chargeable bytes for the
	// backup.
	MaxChargeableBytes int64 `json:"maxChargeableBytes,omitempty,string"`
	// Name: Output only. The resource name of the backup. Format:
	// projects/{project}/backups/{backup}.
	Name string `json:"name,omitempty"`
	// SatisfiesPzi: Output only. This status indicates whether the backup
	// satisfies PZI. The status is reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: Output only. This status indicates whether the backup
	// satisfies PZS. The status is reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// SelfLink: Output only. The URI of this resource.
	SelfLink string `json:"selfLink,omitempty"`
	// State: Output only. The state of this backup.
	//
	// Possible values:
	//   "SQL_BACKUP_STATE_UNSPECIFIED" - The state of the backup is unknown.
	//   "ENQUEUED" - The backup that's added to a queue.
	//   "RUNNING" - The backup is in progress.
	//   "FAILED" - The backup failed.
	//   "SUCCESSFUL" - The backup is successful.
	//   "DELETING" - The backup is being deleted.
	//   "DELETION_FAILED" - Deletion of the backup failed.
	State string `json:"state,omitempty"`
	// TimeZone: Output only. This output contains a backup time zone. If a Cloud
	// SQL for SQL Server instance has a different time zone from the backup's time
	// zone, then the restore to the instance doesn't happen.
	TimeZone string `json:"timeZone,omitempty"`
	// TtlDays: Input only. The time-to-live (TTL) interval for this resource (in
	// days). For example: ttlDays:7, means 7 days from the current time. The
	// expiration time can't exceed 365 days from the time that the backup is
	// created.
	TtlDays int64 `json:"ttlDays,omitempty,string"`
	// Type: Output only. The type of this backup. The type can be "AUTOMATED",
	// "ON_DEMAND", or “FINAL”.
	//
	// Possible values:
	//   "SQL_BACKUP_TYPE_UNSPECIFIED" - This is an unknown backup type.
	//   "AUTOMATED" - The backup schedule triggers a backup automatically.
	//   "ON_DEMAND" - The user triggers a backup manually.
	//   "FINAL" - The backup that's created when the instance is deleted.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BackupInterval") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackupInterval") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Backup) MarshalJSON() ([]byte, error) {
	type NoMethod Backup
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BackupConfiguration: Database instance backup configuration.
type BackupConfiguration struct {
	// BackupRetentionSettings: Backup retention settings.
	BackupRetentionSettings *BackupRetentionSettings `json:"backupRetentionSettings,omitempty"`
	// BackupTier: Output only. Backup tier that manages the backups for the
	// instance.
	//
	// Possible values:
	//   "BACKUP_TIER_UNSPECIFIED" - Unspecified.
	//   "STANDARD" - Instance is managed by Cloud SQL.
	//   "ADVANCED" - Deprecated: ADVANCED is deprecated. Please use ENHANCED
	// instead.
	//   "ENHANCED" - Instance is managed by Google Cloud Backup and DR Service.
	BackupTier string `json:"backupTier,omitempty"`
	// BinaryLogEnabled: (MySQL only) Whether binary log is enabled. If backup
	// configuration is disabled, binarylog must be disabled as well.
	BinaryLogEnabled bool `json:"binaryLogEnabled,omitempty"`
	// Enabled: Whether this configuration is enabled.
	Enabled bool `json:"enabled,omitempty"`
	// Kind: This is always `sql#backupConfiguration`.
	Kind string `json:"kind,omitempty"`
	// Location: Location of the backup
	Location string `json:"location,omitempty"`
	// PointInTimeRecoveryEnabled: Whether point in time recovery is enabled.
	PointInTimeRecoveryEnabled bool `json:"pointInTimeRecoveryEnabled,omitempty"`
	// ReplicationLogArchivingEnabled: Reserved for future use.
	ReplicationLogArchivingEnabled bool `json:"replicationLogArchivingEnabled,omitempty"`
	// StartTime: Start time for the daily backup configuration in UTC timezone in
	// the 24 hour format - `HH:MM`.
	StartTime string `json:"startTime,omitempty"`
	// TransactionLogRetentionDays: The number of days of transaction logs we
	// retain for point in time restore, from 1-7.
	TransactionLogRetentionDays int64 `json:"transactionLogRetentionDays,omitempty"`
	// TransactionalLogStorageState: Output only. This value contains the storage
	// location of transactional logs for the database for point-in-time recovery.
	//
	// Possible values:
	//   "TRANSACTIONAL_LOG_STORAGE_STATE_UNSPECIFIED" - Unspecified.
	//   "DISK" - The transaction logs used for PITR for the instance are stored on
	// a data disk.
	//   "SWITCHING_TO_CLOUD_STORAGE" - The transaction logs used for PITR for the
	// instance are switching from being stored on a data disk to being stored in
	// Cloud Storage. Only applicable to MySQL.
	//   "SWITCHED_TO_CLOUD_STORAGE" - The transaction logs used for PITR for the
	// instance are now stored in Cloud Storage. Previously, they were stored on a
	// data disk. Only applicable to MySQL.
	//   "CLOUD_STORAGE" - The transaction logs used for PITR for the instance are
	// stored in Cloud Storage. Only applicable to MySQL and PostgreSQL.
	TransactionalLogStorageState string `json:"transactionalLogStorageState,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BackupRetentionSettings") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackupRetentionSettings") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BackupConfiguration) MarshalJSON() ([]byte, error) {
	type NoMethod BackupConfiguration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BackupContext: Backup context.
type BackupContext struct {
	// BackupId: The identifier of the backup.
	BackupId int64 `json:"backupId,omitempty,string"`
	// Kind: This is always `sql#backupContext`.
	Kind string `json:"kind,omitempty"`
	// Name: The name of the backup. Format: projects/{project}/backups/{backup}
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BackupId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackupId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BackupContext) MarshalJSON() ([]byte, error) {
	type NoMethod BackupContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BackupReencryptionConfig: Backup Reencryption Config
type BackupReencryptionConfig struct {
	// BackupLimit: Backup re-encryption limit
	BackupLimit int64 `json:"backupLimit,omitempty"`
	// BackupType: Type of backups users want to re-encrypt.
	//
	// Possible values:
	//   "BACKUP_TYPE_UNSPECIFIED" - Unknown backup type, will be defaulted to
	// AUTOMATIC backup type
	//   "AUTOMATED" - Reencrypt automatic backups
	//   "ON_DEMAND" - Reencrypt on-demand backups
	BackupType string `json:"backupType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BackupLimit") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackupLimit") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BackupReencryptionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod BackupReencryptionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BackupRetentionSettings: We currently only support backup retention by
// specifying the number of backups we will retain.
type BackupRetentionSettings struct {
	// RetainedBackups: Depending on the value of retention_unit, this is used to
	// determine if a backup needs to be deleted. If retention_unit is 'COUNT', we
	// will retain this many backups.
	RetainedBackups int64 `json:"retainedBackups,omitempty"`
	// RetentionUnit: The unit that 'retained_backups' represents.
	//
	// Possible values:
	//   "RETENTION_UNIT_UNSPECIFIED" - Backup retention unit is unspecified, will
	// be treated as COUNT.
	//   "COUNT" - Retention will be by count, eg. "retain the most recent 7
	// backups".
	RetentionUnit string `json:"retentionUnit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RetainedBackups") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RetainedBackups") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BackupRetentionSettings) MarshalJSON() ([]byte, error) {
	type NoMethod BackupRetentionSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BackupRun: A BackupRun resource.
type BackupRun struct {
	// BackupKind: Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.
	//
	// Possible values:
	//   "SQL_BACKUP_KIND_UNSPECIFIED" - This is an unknown BackupKind.
	//   "SNAPSHOT" - Snapshot-based backups.
	//   "PHYSICAL" - Physical backups.
	BackupKind string `json:"backupKind,omitempty"`
	// DatabaseVersion: Output only. The instance database version at the time this
	// backup was made.
	//
	// Possible values:
	//   "SQL_DATABASE_VERSION_UNSPECIFIED" - This is an unknown database version.
	//   "MYSQL_5_1" - The database version is MySQL 5.1.
	//   "MYSQL_5_5" - The database version is MySQL 5.5.
	//   "MYSQL_5_6" - The database version is MySQL 5.6.
	//   "MYSQL_5_7" - The database version is MySQL 5.7.
	//   "MYSQL_8_0" - The database version is MySQL 8.
	//   "MYSQL_8_0_18" - The database major version is MySQL 8.0 and the minor
	// version is 18.
	//   "MYSQL_8_0_26" - The database major version is MySQL 8.0 and the minor
	// version is 26.
	//   "MYSQL_8_0_27" - The database major version is MySQL 8.0 and the minor
	// version is 27.
	//   "MYSQL_8_0_28" - The database major version is MySQL 8.0 and the minor
	// version is 28.
	//   "MYSQL_8_0_29" - The database major version is MySQL 8.0 and the minor
	// version is 29.
	//   "MYSQL_8_0_30" - The database major version is MySQL 8.0 and the minor
	// version is 30.
	//   "MYSQL_8_0_31" - The database major version is MySQL 8.0 and the minor
	// version is 31.
	//   "MYSQL_8_0_32" - The database major version is MySQL 8.0 and the minor
	// version is 32.
	//   "MYSQL_8_0_33" - The database major version is MySQL 8.0 and the minor
	// version is 33.
	//   "MYSQL_8_0_34" - The database major version is MySQL 8.0 and the minor
	// version is 34.
	//   "MYSQL_8_0_35" - The database major version is MySQL 8.0 and the minor
	// version is 35.
	//   "MYSQL_8_0_36" - The database major version is MySQL 8.0 and the minor
	// version is 36.
	//   "MYSQL_8_0_37" - The database major version is MySQL 8.0 and the minor
	// version is 37.
	//   "MYSQL_8_0_39" - The database major version is MySQL 8.0 and the minor
	// version is 39.
	//   "MYSQL_8_0_40" - The database major version is MySQL 8.0 and the minor
	// version is 40.
	//   "MYSQL_8_0_41" - The database major version is MySQL 8.0 and the minor
	// version is 41.
	//   "MYSQL_8_0_42" - The database major version is MySQL 8.0 and the minor
	// version is 42.
	//   "MYSQL_8_0_43" - The database major version is MySQL 8.0 and the minor
	// version is 43.
	//   "MYSQL_8_0_44" - The database major version is MySQL 8.0 and the minor
	// version is 44.
	//   "MYSQL_8_0_45" - The database major version is MySQL 8.0 and the minor
	// version is 45.
	//   "MYSQL_8_0_46" - The database major version is MySQL 8.0 and the minor
	// version is 46.
	//   "MYSQL_8_4" - The database version is MySQL 8.4.
	//   "SQLSERVER_2017_STANDARD" - The database version is SQL Server 2017
	// Standard.
	//   "SQLSERVER_2017_ENTERPRISE" - The database version is SQL Server 2017
	// Enterprise.
	//   "SQLSERVER_2017_EXPRESS" - The database version is SQL Server 2017
	// Express.
	//   "SQLSERVER_2017_WEB" - The database version is SQL Server 2017 Web.
	//   "POSTGRES_9_6" - The database version is PostgreSQL 9.6.
	//   "POSTGRES_10" - The database version is PostgreSQL 10.
	//   "POSTGRES_11" - The database version is PostgreSQL 11.
	//   "POSTGRES_12" - The database version is PostgreSQL 12.
	//   "POSTGRES_13" - The database version is PostgreSQL 13.
	//   "POSTGRES_14" - The database version is PostgreSQL 14.
	//   "POSTGRES_15" - The database version is PostgreSQL 15.
	//   "POSTGRES_16" - The database version is PostgreSQL 16.
	//   "POSTGRES_17" - The database version is PostgreSQL 17.
	//   "POSTGRES_18" - The database version is PostgreSQL 18.
	//   "SQLSERVER_2019_STANDARD" - The database version is SQL Server 2019
	// Standard.
	//   "SQLSERVER_2019_ENTERPRISE" - The database version is SQL Server 2019
	// Enterprise.
	//   "SQLSERVER_2019_EXPRESS" - The database version is SQL Server 2019
	// Express.
	//   "SQLSERVER_2019_WEB" - The database version is SQL Server 2019 Web.
	//   "SQLSERVER_2022_STANDARD" - The database version is SQL Server 2022
	// Standard.
	//   "SQLSERVER_2022_ENTERPRISE" - The database version is SQL Server 2022
	// Enterprise.
	//   "SQLSERVER_2022_EXPRESS" - The database version is SQL Server 2022
	// Express.
	//   "SQLSERVER_2022_WEB" - The database version is SQL Server 2022 Web.
	DatabaseVersion string `json:"databaseVersion,omitempty"`
	// Description: The description of this run, only applicable to on-demand
	// backups.
	Description string `json:"description,omitempty"`
	// DiskEncryptionConfiguration: Encryption configuration specific to a backup.
	DiskEncryptionConfiguration *DiskEncryptionConfiguration `json:"diskEncryptionConfiguration,omitempty"`
	// DiskEncryptionStatus: Encryption status specific to a backup.
	DiskEncryptionStatus *DiskEncryptionStatus `json:"diskEncryptionStatus,omitempty"`
	// EndTime: The time the backup operation completed in UTC timezone in RFC 3339
	// (https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	EndTime string `json:"endTime,omitempty"`
	// EnqueuedTime: The time the run was enqueued in UTC timezone in RFC 3339
	// (https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	EnqueuedTime string `json:"enqueuedTime,omitempty"`
	// Error: Information about why the backup operation failed. This is only
	// present if the run has the FAILED status.
	Error *OperationError `json:"error,omitempty"`
	// Id: The identifier for this backup run. Unique only for a specific Cloud SQL
	// instance.
	Id int64 `json:"id,omitempty,string"`
	// Instance: Name of the database instance.
	Instance string `json:"instance,omitempty"`
	// Kind: This is always `sql#backupRun`.
	Kind string `json:"kind,omitempty"`
	// Location: Location of the backups.
	Location string `json:"location,omitempty"`
	// MaxChargeableBytes: Output only. The maximum chargeable bytes for the
	// backup.
	MaxChargeableBytes int64 `json:"maxChargeableBytes,omitempty,string"`
	// SelfLink: The URI of this resource.
	SelfLink string `json:"selfLink,omitempty"`
	// StartTime: The time the backup operation actually started in UTC timezone in
	// RFC 3339 (https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	StartTime string `json:"startTime,omitempty"`
	// Status: The status of this run.
	//
	// Possible values:
	//   "SQL_BACKUP_RUN_STATUS_UNSPECIFIED" - The status of the run is unknown.
	//   "ENQUEUED" - The backup operation was enqueued.
	//   "OVERDUE" - The backup is overdue across a given backup window. Indicates
	// a problem. Example: Long-running operation in progress during the whole
	// window.
	//   "RUNNING" - The backup is in progress.
	//   "FAILED" - The backup failed.
	//   "SUCCESSFUL" - The backup was successful.
	//   "SKIPPED" - The backup was skipped (without problems) for a given backup
	// window. Example: Instance was idle.
	//   "DELETION_PENDING" - The backup is about to be deleted.
	//   "DELETION_FAILED" - The backup deletion failed.
	//   "DELETED" - The backup has been deleted.
	Status string `json:"status,omitempty"`
	// TimeZone: Backup time zone to prevent restores to an instance with a
	// different time zone. Now relevant only for SQL Server.
	TimeZone string `json:"timeZone,omitempty"`
	// Type: The type of this run; can be either "AUTOMATED" or "ON_DEMAND" or
	// "FINAL". This field defaults to "ON_DEMAND" and is ignored, when specified
	// for insert requests.
	//
	// Possible values:
	//   "SQL_BACKUP_RUN_TYPE_UNSPECIFIED" - This is an unknown BackupRun type.
	//   "AUTOMATED" - The backup schedule automatically triggers a backup.
	//   "ON_DEMAND" - The user manually triggers a backup.
	Type string `json:"type,omitempty"`
	// WindowStartTime: The start time of the backup window during which this the
	// backup was attempted in RFC 3339 (https://tools.ietf.org/html/rfc3339)
	// format, for example `2012-11-15T16:19:00.094Z`.
	WindowStartTime string `json:"windowStartTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BackupKind") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackupKind") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BackupRun) MarshalJSON() ([]byte, error) {
	type NoMethod BackupRun
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BackupRunsListResponse: Backup run list results.
type BackupRunsListResponse struct {
	// Items: A list of backup runs in reverse chronological order of the enqueued
	// time.
	Items []*BackupRun `json:"items,omitempty"`
	// Kind: This is always `sql#backupRunsList`.
	Kind string `json:"kind,omitempty"`
	// NextPageToken: The continuation token, used to page through large result
	// sets. Provide this value in a subsequent request to return the next page of
	// results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BackupRunsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod BackupRunsListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// BinLogCoordinates: Binary log coordinates.
type BinLogCoordinates struct {
	// BinLogFileName: Name of the binary log file for a Cloud SQL instance.
	BinLogFileName string `json:"binLogFileName,omitempty"`
	// BinLogPosition: Position (offset) within the binary log file.
	BinLogPosition int64 `json:"binLogPosition,omitempty,string"`
	// Kind: This is always `sql#binLogCoordinates`.
	Kind string `json:"kind,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BinLogFileName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BinLogFileName") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s BinLogCoordinates) MarshalJSON() ([]byte, error) {
	type NoMethod BinLogCoordinates
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// CloneContext: Database instance clone context.
type CloneContext struct {
	// AllocatedIpRange: The name of the allocated ip range for the private ip
	// Cloud SQL instance. For example: "google-managed-services-default". If set,
	// the cloned instance ip will be created in the allocated range. The range
	// name must comply with RFC 1035 (https://tools.ietf.org/html/rfc1035).
	// Specifically, the name must be 1-63 characters long and match the regular
	// expression a-z ([-a-z0-9]*[a-z0-9])?. Reserved for future use.
	AllocatedIpRange string `json:"allocatedIpRange,omitempty"`
	// BinLogCoordinates: Binary log coordinates, if specified, identify the
	// position up to which the source instance is cloned. If not specified, the
	// source instance is cloned up to the most recent binary log coordinates.
	BinLogCoordinates *BinLogCoordinates `json:"binLogCoordinates,omitempty"`
	// DatabaseNames: (SQL Server only) Clone only the specified databases from the
	// source instance. Clone all databases if empty.
	DatabaseNames []string `json:"databaseNames,omitempty"`
	// DestinationInstanceName: Name of the Cloud SQL instance to be created as a
	// clone.
	DestinationInstanceName string `json:"destinationInstanceName,omitempty"`
	// Kind: This is always `sql#cloneContext`.
	Kind string `json:"kind,omitempty"`
	// PitrTimestampMs: Reserved for future use.
	PitrTimestampMs int64 `json:"pitrTimestampMs,omitempty,string"`
	// PointInTime: Timestamp, if specified, identifies the time to which the
	// source instance is cloned.
	PointInTime string `json:"pointInTime,omitempty"`
	// PreferredSecondaryZone: Optional. Copy clone and point-in-time recovery
	// clone of a regional instance in the specified zones. If not specified, clone
	// to the same secondary zone as the source instance. This value cannot be the
	// same as the preferred_zone field.
	PreferredSecondaryZone string `json:"preferredSecondaryZone,omitempty"`
	// PreferredZone: Optional. Copy clone and point-in-time recovery clone of an
	// instance to the specified zone. If no zone is specified, clone to the same
	// primary zone as the source instance.
	PreferredZone string `json:"preferredZone,omitempty"`
	// SourceInstanceDeletionTime: The timestamp used to identify the time when the
	// source instance is deleted. If this instance is deleted, then you must set
	// the timestamp.
	SourceInstanceDeletionTime string `json:"sourceInstanceDeletionTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllocatedIpRange") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllocatedIpRange") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s CloneContext) MarshalJSON() ([]byte, error) {
	type NoMethod CloneContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Column: Contains the name and datatype of a column.
type Column struct {
	// Name: Name of the column.
	Name string `json:"name,omitempty"`
	// Type: Datatype of the column.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Column) MarshalJSON() ([]byte, error) {
	type NoMethod Column
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConnectPoolNodeConfig: Details of a single read pool node of a read pool.
type ConnectPoolNodeConfig struct {
	// DnsName: Output only. The DNS name of the read pool node.
	DnsName string `json:"dnsName,omitempty"`
	// DnsNames: Output only. The list of DNS names used by this read pool node.
	DnsNames []*DnsNameMapping `json:"dnsNames,omitempty"`
	// IpAddresses: Output only. Mappings containing IP addresses that can be used
	// to connect to the read pool node.
	IpAddresses []*IpMapping `json:"ipAddresses,omitempty"`
	// Name: Output only. The name of the read pool node. Doesn't include the
	// project ID.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DnsName") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DnsName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConnectPoolNodeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ConnectPoolNodeConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConnectSettings: Connect settings retrieval response.
type ConnectSettings struct {
	// BackendType: `SECOND_GEN`: Cloud SQL database instance. `EXTERNAL`: A
	// database server that is not managed by Google. This property is read-only;
	// use the `tier` property in the `settings` object to determine the database
	// type.
	//
	// Possible values:
	//   "SQL_BACKEND_TYPE_UNSPECIFIED" - This is an unknown backend type for
	// instance.
	//   "FIRST_GEN" - V1 speckle instance.
	//   "SECOND_GEN" - V2 speckle instance.
	//   "EXTERNAL" - On premises instance.
	BackendType string `json:"backendType,omitempty"`
	// CustomSubjectAlternativeNames: Custom subject alternative names for the
	// server certificate.
	CustomSubjectAlternativeNames []string `json:"customSubjectAlternativeNames,omitempty"`
	// DatabaseVersion: The database engine type and version. The `databaseVersion`
	// field cannot be changed after instance creation. MySQL instances:
	// `MYSQL_8_0`, `MYSQL_5_7` (default), or `MYSQL_5_6`. PostgreSQL instances:
	// `POSTGRES_9_6`, `POSTGRES_10`, `POSTGRES_11` or `POSTGRES_12` (default),
	// `POSTGRES_13`, or `POSTGRES_14`. SQL Server instances:
	// `SQLSERVER_2017_STANDARD` (default), `SQLSERVER_2017_ENTERPRISE`,
	// `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`, `SQLSERVER_2019_STANDARD`,
	// `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`, or
	// `SQLSERVER_2019_WEB`.
	//
	// Possible values:
	//   "SQL_DATABASE_VERSION_UNSPECIFIED" - This is an unknown database version.
	//   "MYSQL_5_1" - The database version is MySQL 5.1.
	//   "MYSQL_5_5" - The database version is MySQL 5.5.
	//   "MYSQL_5_6" - The database version is MySQL 5.6.
	//   "MYSQL_5_7" - The database version is MySQL 5.7.
	//   "MYSQL_8_0" - The database version is MySQL 8.
	//   "MYSQL_8_0_18" - The database major version is MySQL 8.0 and the minor
	// version is 18.
	//   "MYSQL_8_0_26" - The database major version is MySQL 8.0 and the minor
	// version is 26.
	//   "MYSQL_8_0_27" - The database major version is MySQL 8.0 and the minor
	// version is 27.
	//   "MYSQL_8_0_28" - The database major version is MySQL 8.0 and the minor
	// version is 28.
	//   "MYSQL_8_0_29" - The database major version is MySQL 8.0 and the minor
	// version is 29.
	//   "MYSQL_8_0_30" - The database major version is MySQL 8.0 and the minor
	// version is 30.
	//   "MYSQL_8_0_31" - The database major version is MySQL 8.0 and the minor
	// version is 31.
	//   "MYSQL_8_0_32" - The database major version is MySQL 8.0 and the minor
	// version is 32.
	//   "MYSQL_8_0_33" - The database major version is MySQL 8.0 and the minor
	// version is 33.
	//   "MYSQL_8_0_34" - The database major version is MySQL 8.0 and the minor
	// version is 34.
	//   "MYSQL_8_0_35" - The database major version is MySQL 8.0 and the minor
	// version is 35.
	//   "MYSQL_8_0_36" - The database major version is MySQL 8.0 and the minor
	// version is 36.
	//   "MYSQL_8_0_37" - The database major version is MySQL 8.0 and the minor
	// version is 37.
	//   "MYSQL_8_0_39" - The database major version is MySQL 8.0 and the minor
	// version is 39.
	//   "MYSQL_8_0_40" - The database major version is MySQL 8.0 and the minor
	// version is 40.
	//   "MYSQL_8_0_41" - The database major version is MySQL 8.0 and the minor
	// version is 41.
	//   "MYSQL_8_0_42" - The database major version is MySQL 8.0 and the minor
	// version is 42.
	//   "MYSQL_8_0_43" - The database major version is MySQL 8.0 and the minor
	// version is 43.
	//   "MYSQL_8_0_44" - The database major version is MySQL 8.0 and the minor
	// version is 44.
	//   "MYSQL_8_0_45" - The database major version is MySQL 8.0 and the minor
	// version is 45.
	//   "MYSQL_8_0_46" - The database major version is MySQL 8.0 and the minor
	// version is 46.
	//   "MYSQL_8_4" - The database version is MySQL 8.4.
	//   "SQLSERVER_2017_STANDARD" - The database version is SQL Server 2017
	// Standard.
	//   "SQLSERVER_2017_ENTERPRISE" - The database version is SQL Server 2017
	// Enterprise.
	//   "SQLSERVER_2017_EXPRESS" - The database version is SQL Server 2017
	// Express.
	//   "SQLSERVER_2017_WEB" - The database version is SQL Server 2017 Web.
	//   "POSTGRES_9_6" - The database version is PostgreSQL 9.6.
	//   "POSTGRES_10" - The database version is PostgreSQL 10.
	//   "POSTGRES_11" - The database version is PostgreSQL 11.
	//   "POSTGRES_12" - The database version is PostgreSQL 12.
	//   "POSTGRES_13" - The database version is PostgreSQL 13.
	//   "POSTGRES_14" - The database version is PostgreSQL 14.
	//   "POSTGRES_15" - The database version is PostgreSQL 15.
	//   "POSTGRES_16" - The database version is PostgreSQL 16.
	//   "POSTGRES_17" - The database version is PostgreSQL 17.
	//   "POSTGRES_18" - The database version is PostgreSQL 18.
	//   "SQLSERVER_2019_STANDARD" - The database version is SQL Server 2019
	// Standard.
	//   "SQLSERVER_2019_ENTERPRISE" - The database version is SQL Server 2019
	// Enterprise.
	//   "SQLSERVER_2019_EXPRESS" - The database version is SQL Server 2019
	// Express.
	//   "SQLSERVER_2019_WEB" - The database version is SQL Server 2019 Web.
	//   "SQLSERVER_2022_STANDARD" - The database version is SQL Server 2022
	// Standard.
	//   "SQLSERVER_2022_ENTERPRISE" - The database version is SQL Server 2022
	// Enterprise.
	//   "SQLSERVER_2022_EXPRESS" - The database version is SQL Server 2022
	// Express.
	//   "SQLSERVER_2022_WEB" - The database version is SQL Server 2022 Web.
	DatabaseVersion string `json:"databaseVersion,omitempty"`
	// DnsName: The dns name of the instance.
	DnsName string `json:"dnsName,omitempty"`
	// DnsNames: Output only. The list of DNS names used by this instance.
	DnsNames []*DnsNameMapping `json:"dnsNames,omitempty"`
	// IpAddresses: The assigned IP addresses for the instance.
	IpAddresses []*IpMapping `json:"ipAddresses,omitempty"`
	// Kind: This is always `sql#connectSettings`.
	Kind string `json:"kind,omitempty"`
	// MdxProtocolSupport: Optional. Output only. mdx_protocol_support controls how
	// the client uses metadata exchange when connecting to the instance. The
	// values in the list representing parts of the MDX protocol that are supported
	// by this instance. When the list is empty, the instance does not support MDX,
	// so the client must not send an MDX request. The default is empty.
	//
	// Possible values:
	//   "MDX_PROTOCOL_SUPPORT_UNSPECIFIED" - Not specified.
	//   "CLIENT_PROTOCOL_TYPE" - Client should send the client protocol type in
	// the MDX request.
	MdxProtocolSupport []string `json:"mdxProtocolSupport,omitempty"`
	// NodeCount: The number of read pool nodes in a read pool.
	NodeCount int64 `json:"nodeCount,omitempty"`
	// Nodes: Output only. Entries containing information about each read pool node
	// of the read pool.
	Nodes []*ConnectPoolNodeConfig `json:"nodes,omitempty"`
	// PscEnabled: Whether PSC connectivity is enabled for this instance.
	PscEnabled bool `json:"pscEnabled,omitempty"`
	// Region: The cloud region for the instance. e.g. `us-central1`,
	// `europe-west1`. The region cannot be changed after instance creation.
	Region string `json:"region,omitempty"`
	// ServerCaCert: SSL configuration.
	ServerCaCert *SslCert `json:"serverCaCert,omitempty"`
	// ServerCaMode: Specify what type of CA is used for the server certificate.
	//
	// Possible values:
	//   "CA_MODE_UNSPECIFIED" - CA mode is unspecified. It is effectively the same
	// as `GOOGLE_MANAGED_INTERNAL_CA`.
	//   "GOOGLE_MANAGED_INTERNAL_CA" - Google-managed self-signed internal CA.
	//   "GOOGLE_MANAGED_CAS_CA" - Google-managed regional CA part of root CA
	// hierarchy hosted on Google Cloud's Certificate Authority Service (CAS).
	//   "CUSTOMER_MANAGED_CAS_CA" - Customer-managed CA hosted on Google Cloud's
	// Certificate Authority Service (CAS).
	ServerCaMode string `json:"serverCaMode,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "BackendType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackendType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConnectSettings) MarshalJSON() ([]byte, error) {
	type NoMethod ConnectSettings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConnectionPoolConfig: The managed connection pooling configuration.
type ConnectionPoolConfig struct {
	// ConnectionPoolingEnabled: Whether managed connection pooling is enabled.
	ConnectionPoolingEnabled bool `json:"connectionPoolingEnabled,omitempty"`
	// Flags: Optional. List of connection pool configuration flags.
	Flags []*ConnectionPoolFlags `json:"flags,omitempty"`
	// PoolerCount: Output only. Number of connection poolers.
	PoolerCount int64 `json:"poolerCount,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectionPoolingEnabled")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectionPoolingEnabled") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConnectionPoolConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ConnectionPoolConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ConnectionPoolFlags: Connection pool flags for Cloud SQL instances managed
// connection pool configuration.
type ConnectionPoolFlags struct {
	// Name: Required. The name of the flag.
	Name string `json:"name,omitempty"`
	// Value: Required. The value of the flag. Boolean flags are set to `on` for
	// true and `off` for false. This field must be omitted if the flag doesn't
	// take a value.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ConnectionPoolFlags) MarshalJSON() ([]byte, error) {
	type NoMethod ConnectionPoolFlags
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DataCacheConfig: Data cache configurations.
type DataCacheConfig struct {
	// DataCacheEnabled: Whether data cache is enabled for the instance.
	DataCacheEnabled bool `json:"dataCacheEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DataCacheEnabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DataCacheEnabled") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DataCacheConfig) MarshalJSON() ([]byte, error) {
	type NoMethod DataCacheConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Database: Represents a SQL database on the Cloud SQL instance.
type Database struct {
	// Charset: The Cloud SQL charset value.
	Charset string `json:"charset,omitempty"`
	// Collation: The Cloud SQL collation value.
	Collation string `json:"collation,omitempty"`
	// Etag: This field is deprecated and will be removed from a future version of
	// the API.
	Etag string `json:"etag,omitempty"`
	// Instance: The name of the Cloud SQL instance. This does not include the
	// project ID.
	Instance string `json:"instance,omitempty"`
	// Kind: This is always `sql#database`.
	Kind string `json:"kind,omitempty"`
	// Name: The name of the database in the Cloud SQL instance. This does not
	// include the project ID or instance name.
	Name string `json:"name,omitempty"`
	// Project: The project ID of the project containing the Cloud SQL database.
	// The Google apps domain is prefixed if applicable.
	Project string `json:"project,omitempty"`
	// SelfLink: The URI of this resource.
	SelfLink                 string                    `json:"selfLink,omitempty"`
	SqlserverDatabaseDetails *SqlServerDatabaseDetails `json:"sqlserverDatabaseDetails,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Charset") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Charset") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Database) MarshalJSON() ([]byte, error) {
	type NoMethod Database
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatabaseFlags: Database flags for Cloud SQL instances.
type DatabaseFlags struct {
	// Name: The name of the flag. These flags are passed at instance startup, so
	// include both server options and system variables. Flags are specified with
	// underscores, not hyphens. For more information, see Configuring Database
	// Flags (https://cloud.google.com/sql/docs/mysql/flags) in the Cloud SQL
	// documentation.
	Name string `json:"name,omitempty"`
	// Value: The value of the flag. Boolean flags are set to `on` for true and
	// `off` for false. This field must be omitted if the flag doesn't take a
	// value.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatabaseFlags) MarshalJSON() ([]byte, error) {
	type NoMethod DatabaseFlags
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatabaseInstance: A Cloud SQL instance resource.
type DatabaseInstance struct {
	// AvailableMaintenanceVersions: Output only. List all maintenance versions
	// applicable on the instance
	AvailableMaintenanceVersions []string `json:"availableMaintenanceVersions,omitempty"`
	// BackendType: The backend type. `SECOND_GEN`: Cloud SQL database instance.
	// `EXTERNAL`: A database server that is not managed by Google. This property
	// is read-only; use the `tier` property in the `settings` object to determine
	// the database type.
	//
	// Possible values:
	//   "SQL_BACKEND_TYPE_UNSPECIFIED" - This is an unknown backend type for
	// instance.
	//   "FIRST_GEN" - V1 speckle instance.
	//   "SECOND_GEN" - V2 speckle instance.
	//   "EXTERNAL" - On premises instance.
	BackendType string `json:"backendType,omitempty"`
	// ConnectionName: Connection name of the Cloud SQL instance used in connection
	// strings.
	ConnectionName string `json:"connectionName,omitempty"`
	// CreateTime: Output only. The time when the instance was created in RFC 3339
	// (https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	CreateTime string `json:"createTime,omitempty"`
	// CurrentDiskSize: The current disk usage of the instance in bytes. This
	// property has been deprecated. Use the
	// "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud
	// Monitoring API instead. Please see this announcement
	// (https://groups.google.com/d/msg/google-cloud-sql-announce/I_7-F9EBhT0/BtvFtdFeAgAJ)
	// for details.
	CurrentDiskSize int64 `json:"currentDiskSize,omitempty,string"`
	// DatabaseInstalledVersion: Output only. Stores the current database version
	// running on the instance including minor version such as `MYSQL_8_0_18`.
	DatabaseInstalledVersion string `json:"databaseInstalledVersion,omitempty"`
	// DatabaseVersion: The database engine type and version. The `databaseVersion`
	// field cannot be changed after instance creation.
	//
	// Possible values:
	//   "SQL_DATABASE_VERSION_UNSPECIFIED" - This is an unknown database version.
	//   "MYSQL_5_1" - The database version is MySQL 5.1.
	//   "MYSQL_5_5" - The database version is MySQL 5.5.
	//   "MYSQL_5_6" - The database version is MySQL 5.6.
	//   "MYSQL_5_7" - The database version is MySQL 5.7.
	//   "MYSQL_8_0" - The database version is MySQL 8.
	//   "MYSQL_8_0_18" - The database major version is MySQL 8.0 and the minor
	// version is 18.
	//   "MYSQL_8_0_26" - The database major version is MySQL 8.0 and the minor
	// version is 26.
	//   "MYSQL_8_0_27" - The database major version is MySQL 8.0 and the minor
	// version is 27.
	//   "MYSQL_8_0_28" - The database major version is MySQL 8.0 and the minor
	// version is 28.
	//   "MYSQL_8_0_29" - The database major version is MySQL 8.0 and the minor
	// version is 29.
	//   "MYSQL_8_0_30" - The database major version is MySQL 8.0 and the minor
	// version is 30.
	//   "MYSQL_8_0_31" - The database major version is MySQL 8.0 and the minor
	// version is 31.
	//   "MYSQL_8_0_32" - The database major version is MySQL 8.0 and the minor
	// version is 32.
	//   "MYSQL_8_0_33" - The database major version is MySQL 8.0 and the minor
	// version is 33.
	//   "MYSQL_8_0_34" - The database major version is MySQL 8.0 and the minor
	// version is 34.
	//   "MYSQL_8_0_35" - The database major version is MySQL 8.0 and the minor
	// version is 35.
	//   "MYSQL_8_0_36" - The database major version is MySQL 8.0 and the minor
	// version is 36.
	//   "MYSQL_8_0_37" - The database major version is MySQL 8.0 and the minor
	// version is 37.
	//   "MYSQL_8_0_39" - The database major version is MySQL 8.0 and the minor
	// version is 39.
	//   "MYSQL_8_0_40" - The database major version is MySQL 8.0 and the minor
	// version is 40.
	//   "MYSQL_8_0_41" - The database major version is MySQL 8.0 and the minor
	// version is 41.
	//   "MYSQL_8_0_42" - The database major version is MySQL 8.0 and the minor
	// version is 42.
	//   "MYSQL_8_0_43" - The database major version is MySQL 8.0 and the minor
	// version is 43.
	//   "MYSQL_8_0_44" - The database major version is MySQL 8.0 and the minor
	// version is 44.
	//   "MYSQL_8_0_45" - The database major version is MySQL 8.0 and the minor
	// version is 45.
	//   "MYSQL_8_0_46" - The database major version is MySQL 8.0 and the minor
	// version is 46.
	//   "MYSQL_8_4" - The database version is MySQL 8.4.
	//   "SQLSERVER_2017_STANDARD" - The database version is SQL Server 2017
	// Standard.
	//   "SQLSERVER_2017_ENTERPRISE" - The database version is SQL Server 2017
	// Enterprise.
	//   "SQLSERVER_2017_EXPRESS" - The database version is SQL Server 2017
	// Express.
	//   "SQLSERVER_2017_WEB" - The database version is SQL Server 2017 Web.
	//   "POSTGRES_9_6" - The database version is PostgreSQL 9.6.
	//   "POSTGRES_10" - The database version is PostgreSQL 10.
	//   "POSTGRES_11" - The database version is PostgreSQL 11.
	//   "POSTGRES_12" - The database version is PostgreSQL 12.
	//   "POSTGRES_13" - The database version is PostgreSQL 13.
	//   "POSTGRES_14" - The database version is PostgreSQL 14.
	//   "POSTGRES_15" - The database version is PostgreSQL 15.
	//   "POSTGRES_16" - The database version is PostgreSQL 16.
	//   "POSTGRES_17" - The database version is PostgreSQL 17.
	//   "POSTGRES_18" - The database version is PostgreSQL 18.
	//   "SQLSERVER_2019_STANDARD" - The database version is SQL Server 2019
	// Standard.
	//   "SQLSERVER_2019_ENTERPRISE" - The database version is SQL Server 2019
	// Enterprise.
	//   "SQLSERVER_2019_EXPRESS" - The database version is SQL Server 2019
	// Express.
	//   "SQLSERVER_2019_WEB" - The database version is SQL Server 2019 Web.
	//   "SQLSERVER_2022_STANDARD" - The database version is SQL Server 2022
	// Standard.
	//   "SQLSERVER_2022_ENTERPRISE" - The database version is SQL Server 2022
	// Enterprise.
	//   "SQLSERVER_2022_EXPRESS" - The database version is SQL Server 2022
	// Express.
	//   "SQLSERVER_2022_WEB" - The database version is SQL Server 2022 Web.
	DatabaseVersion string `json:"databaseVersion,omitempty"`
	// DiskEncryptionConfiguration: Disk encryption configuration specific to an
	// instance.
	DiskEncryptionConfiguration *DiskEncryptionConfiguration `json:"diskEncryptionConfiguration,omitempty"`
	// DiskEncryptionStatus: Disk encryption status specific to an instance.
	DiskEncryptionStatus *DiskEncryptionStatus `json:"diskEncryptionStatus,omitempty"`
	// DnsName: Output only. The dns name of the instance.
	DnsName string `json:"dnsName,omitempty"`
	// DnsNames: Output only. The list of DNS names used by this instance.
	DnsNames []*DnsNameMapping `json:"dnsNames,omitempty"`
	// Etag: This field is deprecated and will be removed from a future version of
	// the API. Use the `settings.settingsVersion` field instead.
	Etag string `json:"etag,omitempty"`
	// FailoverReplica: The name and status of the failover replica.
	FailoverReplica *DatabaseInstanceFailoverReplica `json:"failoverReplica,omitempty"`
	// GceZone: The Compute Engine zone that the instance is currently serving
	// from. This value could be different from the zone that was specified when
	// the instance was created if the instance has failed over to its secondary
	// zone. WARNING: Changing this might restart the instance.
	GceZone string `json:"gceZone,omitempty"`
	// GeminiConfig: Gemini instance configuration.
	GeminiConfig *GeminiInstanceConfig `json:"geminiConfig,omitempty"`
	// IncludeReplicasForMajorVersionUpgrade: Input only. Determines whether an
	// in-place major version upgrade of replicas happens when an in-place major
	// version upgrade of a primary instance is initiated.
	IncludeReplicasForMajorVersionUpgrade bool `json:"includeReplicasForMajorVersionUpgrade,omitempty"`
	// InstanceType: The instance type.
	//
	// Possible values:
	//   "SQL_INSTANCE_TYPE_UNSPECIFIED" - This is an unknown Cloud SQL instance
	// type.
	//   "CLOUD_SQL_INSTANCE" - A regular Cloud SQL instance that is not
	// replicating from a primary instance.
	//   "ON_PREMISES_INSTANCE" - An instance running on the customer's premises
	// that is not managed by Cloud SQL.
	//   "READ_REPLICA_INSTANCE" - A Cloud SQL instance acting as a read-replica.
	//   "READ_POOL_INSTANCE" - A Cloud SQL read pool.
	InstanceType string `json:"instanceType,omitempty"`
	// IpAddresses: The assigned IP addresses for the instance.
	IpAddresses []*IpMapping `json:"ipAddresses,omitempty"`
	// Ipv6Address: The IPv6 address assigned to the instance. (Deprecated) This
	// property was applicable only to First Generation instances.
	Ipv6Address string `json:"ipv6Address,omitempty"`
	// Kind: This is always `sql#instance`.
	Kind string `json:"kind,omitempty"`
	// MaintenanceVersion: The current software version on the instance.
	MaintenanceVersion string `json:"maintenanceVersion,omitempty"`
	// MasterInstanceName: The name of the instance which will act as primary in
	// the replication setup.
	MasterInstanceName string `json:"masterInstanceName,omitempty"`
	// MaxDiskSize: The maximum disk size of the instance in bytes.
	MaxDiskSize int64 `json:"maxDiskSize,omitempty,string"`
	// Name: Name of the Cloud SQL instance. This does not include the project ID.
	Name string `json:"name,omitempty"`
	// NodeCount: The number of read pool nodes in a read pool.
	NodeCount int64 `json:"nodeCount,omitempty"`
	// Nodes: Output only. Entries containing information about each read pool node
	// of the read pool.
	Nodes []*PoolNodeConfig `json:"nodes,omitempty"`
	// OnPremisesConfiguration: Configuration specific to on-premises instances.
	OnPremisesConfiguration *OnPremisesConfiguration `json:"onPremisesConfiguration,omitempty"`
	// OutOfDiskReport: This field represents the report generated by the proactive
	// database wellness job for OutOfDisk issues. * Writers: * the proactive
	// database wellness job for OOD. * Readers: * the proactive database wellness
	// job
	OutOfDiskReport *SqlOutOfDiskReport `json:"outOfDiskReport,omitempty"`
	// PrimaryDnsName: Output only. DEPRECATED: please use write_endpoint instead.
	PrimaryDnsName string `json:"primaryDnsName,omitempty"`
	// Project: The project ID of the project containing the Cloud SQL instance.
	// The Google apps domain is prefixed if applicable.
	Project string `json:"project,omitempty"`
	// PscServiceAttachmentLink: Output only. The link to service attachment of PSC
	// instance.
	PscServiceAttachmentLink string `json:"pscServiceAttachmentLink,omitempty"`
	// Region: The geographical region of the Cloud SQL instance. It can be one of
	// the regions (https://cloud.google.com/sql/docs/mysql/locations#location-r)
	// where Cloud SQL operates: For example, `asia-east1`, `europe-west1`, and
	// `us-central1`. The default value is `us-central1`.
	Region string `json:"region,omitempty"`
	// ReplicaConfiguration: Configuration specific to failover replicas and read
	// replicas.
	ReplicaConfiguration *ReplicaConfiguration `json:"replicaConfiguration,omitempty"`
	// ReplicaNames: The replicas of the instance.
	ReplicaNames []string `json:"replicaNames,omitempty"`
	// ReplicationCluster: A primary instance and disaster recovery (DR) replica
	// pair. A DR replica is a cross-region replica that you designate for failover
	// in the event that the primary instance experiences regional failure.
	// Applicable to MySQL and PostgreSQL.
	ReplicationCluster *ReplicationCluster `json:"replicationCluster,omitempty"`
	// RootPassword: Initial root password. Use only on creation. You must set root
	// passwords before you can connect to PostgreSQL instances.
	RootPassword string `json:"rootPassword,omitempty"`
	// SatisfiesPzi: Output only. This status indicates whether the instance
	// satisfies PZI. The status is reserved for future use.
	SatisfiesPzi bool `json:"satisfiesPzi,omitempty"`
	// SatisfiesPzs: This status indicates whether the instance satisfies PZS. The
	// status is reserved for future use.
	SatisfiesPzs bool `json:"satisfiesPzs,omitempty"`
	// ScheduledMaintenance: The start time of any upcoming scheduled maintenance
	// for this instance.
	ScheduledMaintenance *SqlScheduledMaintenance `json:"scheduledMaintenance,omitempty"`
	// SecondaryGceZone: The Compute Engine zone that the failover instance is
	// currently serving from for a regional instance. This value could be
	// different from the zone that was specified when the instance was created if
	// the instance has failed over to its secondary/failover zone.
	SecondaryGceZone string `json:"secondaryGceZone,omitempty"`
	// SelfLink: The URI of this resource.
	SelfLink string `json:"selfLink,omitempty"`
	// ServerCaCert: SSL configuration.
	ServerCaCert *SslCert `json:"serverCaCert,omitempty"`
	// ServiceAccountEmailAddress: The service account email address assigned to
	// the instance. \This property is read-only.
	ServiceAccountEmailAddress string `json:"serviceAccountEmailAddress,omitempty"`
	// Settings: The user settings.
	Settings *Settings `json:"settings,omitempty"`
	// SqlNetworkArchitecture: The SQL network architecture for the instance.
	//
	// Possible values:
	//   "SQL_NETWORK_ARCHITECTURE_UNSPECIFIED"
	//   "NEW_NETWORK_ARCHITECTURE" - The instance uses the new network
	// architecture.
	//   "OLD_NETWORK_ARCHITECTURE" - The instance uses the old network
	// architecture.
	SqlNetworkArchitecture string `json:"sqlNetworkArchitecture,omitempty"`
	// State: The current serving state of the Cloud SQL instance.
	//
	// Possible values:
	//   "SQL_INSTANCE_STATE_UNSPECIFIED" - The state of the instance is unknown.
	//   "RUNNABLE" - The instance is running, or has been stopped by owner.
	//   "SUSPENDED" - The instance is not available, for example due to problems
	// with billing.
	//   "PENDING_DELETE" - The instance is being deleted.
	//   "PENDING_CREATE" - The instance is being created.
	//   "MAINTENANCE" - The instance is down for maintenance.
	//   "FAILED" - The creation of the instance failed or a fatal error occurred
	// during maintenance.
	//   "ONLINE_MAINTENANCE" - Deprecated
	//   "REPAIRING" - (Applicable to read pool nodes only.) The read pool node
	// needs to be repaired. The database might be unavailable.
	State string `json:"state,omitempty"`
	// SuspensionReason: If the instance state is SUSPENDED, the reason for the
	// suspension.
	//
	// Possible values:
	//   "SQL_SUSPENSION_REASON_UNSPECIFIED" - This is an unknown suspension
	// reason.
	//   "BILLING_ISSUE" - The instance is suspended due to billing issues (for
	// example:, account issue)
	//   "LEGAL_ISSUE" - The instance is suspended due to illegal content (for
	// example:, child pornography, copyrighted material, etc.).
	//   "OPERATIONAL_ISSUE" - The instance is causing operational issues (for
	// example:, causing the database to crash).
	//   "KMS_KEY_ISSUE" - The KMS key used by the instance is either revoked or
	// denied access to
	SuspensionReason []string `json:"suspensionReason,omitempty"`
	// SwitchTransactionLogsToCloudStorageEnabled: Input only. Whether Cloud SQL is
	// enabled to switch storing point-in-time recovery log files from a data disk
	// to Cloud Storage.
	SwitchTransactionLogsToCloudStorageEnabled bool `json:"switchTransactionLogsToCloudStorageEnabled,omitempty"`
	// Tags: Optional. Input only. Immutable. Tag keys and tag values that are
	// bound to this instance. You must represent each item in the map as: "" :
	// "". For example, a single resource can have the following tags: ```
	// "123/environment": "production", "123/costCenter": "marketing", ``` For more
	// information on tag creation and management, see
	// https://cloud.google.com/resource-manager/docs/tags/tags-overview.
	Tags map[string]string `json:"tags,omitempty"`
	// UpgradableDatabaseVersions: Output only. All database versions that are
	// available for upgrade.
	UpgradableDatabaseVersions []*AvailableDatabaseVersion `json:"upgradableDatabaseVersions,omitempty"`
	// WriteEndpoint: Output only. The dns name of the primary instance in a
	// replication group.
	WriteEndpoint string `json:"writeEndpoint,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g.
	// "AvailableMaintenanceVersions") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields
	// for more details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AvailableMaintenanceVersions") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatabaseInstance) MarshalJSON() ([]byte, error) {
	type NoMethod DatabaseInstance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatabaseInstanceFailoverReplica: The name and status of the failover
// replica.
type DatabaseInstanceFailoverReplica struct {
	// Available: The availability status of the failover replica. A false status
	// indicates that the failover replica is out of sync. The primary instance can
	// only failover to the failover replica when the status is true.
	Available bool `json:"available,omitempty"`
	// Name: The name of the failover replica. If specified at instance creation, a
	// failover replica is created for the instance. The name doesn't include the
	// project ID.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Available") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Available") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatabaseInstanceFailoverReplica) MarshalJSON() ([]byte, error) {
	type NoMethod DatabaseInstanceFailoverReplica
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DatabasesListResponse: Database list response.
type DatabasesListResponse struct {
	// Items: List of database resources in the instance.
	Items []*Database `json:"items,omitempty"`
	// Kind: This is always `sql#databasesList`.
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DatabasesListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DatabasesListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DemoteContext: This context is used to demote an existing standalone
// instance to be a Cloud SQL read replica for an external database server.
type DemoteContext struct {
	// Kind: This is always `sql#demoteContext`.
	Kind string `json:"kind,omitempty"`
	// SourceRepresentativeInstanceName: Required. The name of the instance which
	// acts as an on-premises primary instance in the replication setup.
	SourceRepresentativeInstanceName string `json:"sourceRepresentativeInstanceName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DemoteContext) MarshalJSON() ([]byte, error) {
	type NoMethod DemoteContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DemoteMasterConfiguration: Read-replica configuration for connecting to the
// on-premises primary instance.
type DemoteMasterConfiguration struct {
	// Kind: This is always `sql#demoteMasterConfiguration`.
	Kind string `json:"kind,omitempty"`
	// MysqlReplicaConfiguration: MySQL specific configuration when replicating
	// from a MySQL on-premises primary instance. Replication configuration
	// information such as the username, password, certificates, and keys are not
	// stored in the instance metadata. The configuration information is used only
	// to set up the replication connection and is stored by MySQL in a file named
	// `master.info` in the data directory.
	MysqlReplicaConfiguration *DemoteMasterMySqlReplicaConfiguration `json:"mysqlReplicaConfiguration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DemoteMasterConfiguration) MarshalJSON() ([]byte, error) {
	type NoMethod DemoteMasterConfiguration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DemoteMasterContext: Database instance demote primary instance context.
type DemoteMasterContext struct {
	// Kind: This is always `sql#demoteMasterContext`.
	Kind string `json:"kind,omitempty"`
	// MasterInstanceName: The name of the instance which will act as on-premises
	// primary instance in the replication setup.
	MasterInstanceName string `json:"masterInstanceName,omitempty"`
	// ReplicaConfiguration: Configuration specific to read-replicas replicating
	// from the on-premises primary instance.
	ReplicaConfiguration *DemoteMasterConfiguration `json:"replicaConfiguration,omitempty"`
	// SkipReplicationSetup: Flag to skip replication setup on the instance.
	SkipReplicationSetup bool `json:"skipReplicationSetup,omitempty"`
	// VerifyGtidConsistency: Verify the GTID consistency for demote operation.
	// Default value: `True`. Setting this flag to `false` enables you to bypass
	// the GTID consistency check between on-premises primary instance and Cloud
	// SQL instance during the demotion operation but also exposes you to the risk
	// of future replication failures. Change the value only if you know the reason
	// for the GTID divergence and are confident that doing so will not cause any
	// replication issues.
	VerifyGtidConsistency bool `json:"verifyGtidConsistency,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DemoteMasterContext) MarshalJSON() ([]byte, error) {
	type NoMethod DemoteMasterContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DemoteMasterMySqlReplicaConfiguration: Read-replica configuration specific
// to MySQL databases.
type DemoteMasterMySqlReplicaConfiguration struct {
	// CaCertificate: PEM representation of the trusted CA's x509 certificate.
	CaCertificate string `json:"caCertificate,omitempty"`
	// ClientCertificate: PEM representation of the replica's x509 certificate.
	ClientCertificate string `json:"clientCertificate,omitempty"`
	// ClientKey: PEM representation of the replica's private key. The
	// corresponding public key is encoded in the client's certificate. The format
	// of the replica's private key can be either PKCS #1 or PKCS #8.
	ClientKey string `json:"clientKey,omitempty"`
	// Kind: This is always `sql#demoteMasterMysqlReplicaConfiguration`.
	Kind string `json:"kind,omitempty"`
	// Password: The password for the replication connection.
	Password string `json:"password,omitempty"`
	// Username: The username for the replication connection.
	Username string `json:"username,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaCertificate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaCertificate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DemoteMasterMySqlReplicaConfiguration) MarshalJSON() ([]byte, error) {
	type NoMethod DemoteMasterMySqlReplicaConfiguration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DenyMaintenancePeriod: Deny Maintenance Periods. This specifies a date range
// during when all CSA rollout will be denied.
type DenyMaintenancePeriod struct {
	// EndDate: "deny maintenance period" end date. If the year of the end date is
	// empty, the year of the start date also must be empty. In this case, it means
	// the deny maintenance period recurs every year. The date is in format
	// yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
	EndDate string `json:"endDate,omitempty"`
	// StartDate: "deny maintenance period" start date. If the year of the start
	// date is empty, the year of the end date also must be empty. In this case, it
	// means the deny maintenance period recurs every year. The date is in format
	// yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
	StartDate string `json:"startDate,omitempty"`
	// Time: Time in UTC when the "deny maintenance period" starts on start_date
	// and ends on end_date. The time is in format: HH:mm:SS, i.e., 00:00:00
	Time string `json:"time,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndDate") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndDate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DenyMaintenancePeriod) MarshalJSON() ([]byte, error) {
	type NoMethod DenyMaintenancePeriod
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiskEncryptionConfiguration: Disk encryption configuration for an instance.
type DiskEncryptionConfiguration struct {
	// Kind: This is always `sql#diskEncryptionConfiguration`.
	Kind string `json:"kind,omitempty"`
	// KmsKeyName: Resource name of KMS key for disk encryption
	KmsKeyName string `json:"kmsKeyName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiskEncryptionConfiguration) MarshalJSON() ([]byte, error) {
	type NoMethod DiskEncryptionConfiguration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DiskEncryptionStatus: Disk encryption status for an instance.
type DiskEncryptionStatus struct {
	// Kind: This is always `sql#diskEncryptionStatus`.
	Kind string `json:"kind,omitempty"`
	// KmsKeyVersionName: KMS key version used to encrypt the Cloud SQL instance
	// resource
	KmsKeyVersionName string `json:"kmsKeyVersionName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DiskEncryptionStatus) MarshalJSON() ([]byte, error) {
	type NoMethod DiskEncryptionStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// DnsNameMapping: DNS metadata.
type DnsNameMapping struct {
	// ConnectionType: Output only. The connection type of the DNS name.
	//
	// Possible values:
	//   "CONNECTION_TYPE_UNSPECIFIED" - Unknown connection type.
	//   "PUBLIC" - Public IP.
	//   "PRIVATE_SERVICES_ACCESS" - Private services access (private IP).
	//   "PRIVATE_SERVICE_CONNECT" - Private Service Connect.
	ConnectionType string `json:"connectionType,omitempty"`
	// DnsScope: Output only. The scope that the DNS name applies to.
	//
	// Possible values:
	//   "DNS_SCOPE_UNSPECIFIED" - Unknown DNS scope.
	//   "INSTANCE" - Indicates a instance-level DNS name.
	DnsScope string `json:"dnsScope,omitempty"`
	// Name: The DNS name.
	Name string `json:"name,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConnectionType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConnectionType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s DnsNameMapping) MarshalJSON() ([]byte, error) {
	type NoMethod DnsNameMapping
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Empty: A generic empty message that you can re-use to avoid defining
// duplicated empty messages in your APIs. A typical example is to use it as
// the request or the response type of an API method. For instance: service Foo
// { rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
type Empty struct {
	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
}

// ExecuteSqlPayload: The request payload used to execute SQL statements.
type ExecuteSqlPayload struct {
	// AutoIamAuthn: Optional. When set to true, the API caller identity associated
	// with the request is used for database authentication. The API caller must be
	// an IAM user in the database.
	AutoIamAuthn bool `json:"autoIamAuthn,omitempty"`
	// Database: Optional. Name of the database on which the statement will be
	// executed.
	Database string `json:"database,omitempty"`
	// PartialResultMode: Optional. Controls how the API should respond when the
	// SQL execution result is incomplete due to the size limit or another error.
	// The default mode is to throw an error.
	//
	// Possible values:
	//   "PARTIAL_RESULT_MODE_UNSPECIFIED" - Unspecified mode, effectively the same
	// as `FAIL_PARTIAL_RESULT`.
	//   "FAIL_PARTIAL_RESULT" - Throw an error if the result exceeds 10 MB or if a
	// partial result can be retrieved. Don't return the result.
	//   "ALLOW_PARTIAL_RESULT" - Return a truncated result and set
	// `partial_result` to true if the result exceeds 10 MB or if only a partial
	// result can be retrieved due to error. Don't throw an error.
	PartialResultMode string `json:"partialResultMode,omitempty"`
	// RowLimit: Optional. The maximum number of rows returned per SQL statement.
	RowLimit int64 `json:"rowLimit,omitempty,string"`
	// SqlStatement: Required. SQL statements to run on the database. It can be a
	// single statement or a sequence of statements separated by semicolons.
	SqlStatement string `json:"sqlStatement,omitempty"`
	// User: Optional. The name of an existing database user to connect to the
	// database. When `auto_iam_authn` is set to true, this field is ignored and
	// the API caller's IAM user is used.
	User string `json:"user,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AutoIamAuthn") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AutoIamAuthn") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExecuteSqlPayload) MarshalJSON() ([]byte, error) {
	type NoMethod ExecuteSqlPayload
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExportContext: Database instance export context.
type ExportContext struct {
	// BakExportOptions: Options for exporting BAK files (SQL Server-only)
	BakExportOptions *ExportContextBakExportOptions `json:"bakExportOptions,omitempty"`
	// CsvExportOptions: Options for exporting data as CSV. `MySQL` and
	// `PostgreSQL` instances only.
	CsvExportOptions *ExportContextCsvExportOptions `json:"csvExportOptions,omitempty"`
	// Databases: Databases to be exported. `MySQL instances:` If `fileType` is
	// `SQL` and no database is specified, all databases are exported, except for
	// the `mysql` system database. If `fileType` is `CSV`, you can specify one
	// database, either by using this property or by using the
	// `csvExportOptions.selectQuery` property, which takes precedence over this
	// property. `PostgreSQL instances:` If you don't specify a database by name,
	// all user databases in the instance are exported. This excludes system
	// databases and Cloud SQL databases used to manage internal operations.
	// Exporting all user databases is only available for directory-formatted
	// parallel export. If `fileType` is `CSV`, this database must match the one
	// specified in the `csvExportOptions.selectQuery` property. `SQL Server
	// instances:` You must specify one database to be exported, and the `fileType`
	// must be `BAK`.
	Databases []string `json:"databases,omitempty"`
	// FileType: The file type for the specified uri.
	//
	// Possible values:
	//   "SQL_FILE_TYPE_UNSPECIFIED" - Unknown file type.
	//   "SQL" - File containing SQL statements.
	//   "CSV" - File in CSV format.
	//   "BAK"
	//   "TDE" - TDE certificate.
	FileType string `json:"fileType,omitempty"`
	// Kind: This is always `sql#exportContext`.
	Kind string `json:"kind,omitempty"`
	// Offload: Whether to perform a serverless export.
	Offload bool `json:"offload,omitempty"`
	// SqlExportOptions: Options for exporting data as SQL statements.
	SqlExportOptions *ExportContextSqlExportOptions `json:"sqlExportOptions,omitempty"`
	// TdeExportOptions: Optional. Export parameters specific to SQL Server TDE
	// certificates
	TdeExportOptions *ExportContextTdeExportOptions `json:"tdeExportOptions,omitempty"`
	// Uri: The path to the file in Google Cloud Storage where the export will be
	// stored. The URI is in the form `gs://bucketName/fileName`. If the file
	// already exists, the request succeeds, but the operation fails. If `fileType`
	// is `SQL` and the filename ends with .gz, the contents are compressed.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BakExportOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BakExportOptions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExportContext) MarshalJSON() ([]byte, error) {
	type NoMethod ExportContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExportContextBakExportOptions: Options for exporting BAK files (SQL
// Server-only)
type ExportContextBakExportOptions struct {
	// BakType: Type of this bak file will be export, FULL or DIFF, SQL Server only
	//
	// Possible values:
	//   "BAK_TYPE_UNSPECIFIED" - Default type.
	//   "FULL" - Full backup.
	//   "DIFF" - Differential backup.
	//   "TLOG" - SQL Server Transaction Log
	BakType string `json:"bakType,omitempty"`
	// CopyOnly: Deprecated: copy_only is deprecated. Use differential_base instead
	CopyOnly bool `json:"copyOnly,omitempty"`
	// DifferentialBase: Whether or not the backup can be used as a differential
	// base copy_only backup can not be served as differential base
	DifferentialBase bool `json:"differentialBase,omitempty"`
	// ExportLogEndTime: Optional. The end timestamp when transaction log will be
	// included in the export operation. RFC 3339
	// (https://tools.ietf.org/html/rfc3339) format (for example,
	// `2023-10-01T16:19:00.094`) in UTC. When omitted, all available logs until
	// current time will be included. Only applied to Cloud SQL for SQL Server.
	ExportLogEndTime string `json:"exportLogEndTime,omitempty"`
	// ExportLogStartTime: Optional. The begin timestamp when transaction log will
	// be included in the export operation. RFC 3339
	// (https://tools.ietf.org/html/rfc3339) format (for example,
	// `2023-10-01T16:19:00.094`) in UTC. When omitted, all available logs from the
	// beginning of retention period will be included. Only applied to Cloud SQL
	// for SQL Server.
	ExportLogStartTime string `json:"exportLogStartTime,omitempty"`
	// StripeCount: Option for specifying how many stripes to use for the export.
	// If blank, and the value of the striped field is true, the number of stripes
	// is automatically chosen.
	StripeCount int64 `json:"stripeCount,omitempty"`
	// Striped: Whether or not the export should be striped.
	Striped bool `json:"striped,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BakType") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BakType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExportContextBakExportOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ExportContextBakExportOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExportContextCsvExportOptions: Options for exporting data as CSV. `MySQL`
// and `PostgreSQL` instances only.
type ExportContextCsvExportOptions struct {
	// EscapeCharacter: Specifies the character that should appear before a data
	// character that needs to be escaped.
	EscapeCharacter string `json:"escapeCharacter,omitempty"`
	// FieldsTerminatedBy: Specifies the character that separates columns within
	// each row (line) of the file.
	FieldsTerminatedBy string `json:"fieldsTerminatedBy,omitempty"`
	// LinesTerminatedBy: This is used to separate lines. If a line does not
	// contain all fields, the rest of the columns are set to their default values.
	LinesTerminatedBy string `json:"linesTerminatedBy,omitempty"`
	// QuoteCharacter: Specifies the quoting character to be used when a data value
	// is quoted.
	QuoteCharacter string `json:"quoteCharacter,omitempty"`
	// SelectQuery: The select query used to extract the data.
	SelectQuery string `json:"selectQuery,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EscapeCharacter") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EscapeCharacter") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExportContextCsvExportOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ExportContextCsvExportOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExportContextSqlExportOptions: Options for exporting data as SQL statements.
type ExportContextSqlExportOptions struct {
	// MysqlExportOptions: Options for exporting from MySQL.
	MysqlExportOptions *ExportContextSqlExportOptionsMysqlExportOptions `json:"mysqlExportOptions,omitempty"`
	// Parallel: Optional. Whether or not the export should be parallel.
	Parallel bool `json:"parallel,omitempty"`
	// PostgresExportOptions: Options for exporting from a Cloud SQL for PostgreSQL
	// instance.
	PostgresExportOptions *ExportContextSqlExportOptionsPostgresExportOptions `json:"postgresExportOptions,omitempty"`
	// SchemaOnly: Export only schemas.
	SchemaOnly bool `json:"schemaOnly,omitempty"`
	// Tables: Tables to export, or that were exported, from the specified
	// database. If you specify tables, specify one and only one database. For
	// PostgreSQL instances, you can specify only one table.
	Tables []string `json:"tables,omitempty"`
	// Threads: Optional. The number of threads to use for parallel export.
	Threads int64 `json:"threads,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MysqlExportOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MysqlExportOptions") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExportContextSqlExportOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ExportContextSqlExportOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExportContextSqlExportOptionsMysqlExportOptions: Options for exporting from
// MySQL.
type ExportContextSqlExportOptionsMysqlExportOptions struct {
	// MasterData: Option to include SQL statement required to set up replication.
	// If set to `1`, the dump file includes a CHANGE MASTER TO statement with the
	// binary log coordinates, and --set-gtid-purged is set to ON. If set to `2`,
	// the CHANGE MASTER TO statement is written as a SQL comment and has no
	// effect. If set to any value other than `1`, --set-gtid-purged is set to OFF.
	MasterData int64 `json:"masterData,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MasterData") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MasterData") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExportContextSqlExportOptionsMysqlExportOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ExportContextSqlExportOptionsMysqlExportOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExportContextSqlExportOptionsPostgresExportOptions: Options for exporting
// from a Cloud SQL for PostgreSQL instance.
type ExportContextSqlExportOptionsPostgresExportOptions struct {
	// Clean: Optional. Use this option to include DROP <object> SQL statements.
	// Use these statements to delete database objects before running the import
	// operation.
	Clean bool `json:"clean,omitempty"`
	// IfExists: Optional. Option to include an IF EXISTS SQL statement with each
	// DROP statement produced by clean.
	IfExists bool `json:"ifExists,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Clean") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Clean") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExportContextSqlExportOptionsPostgresExportOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ExportContextSqlExportOptionsPostgresExportOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExportContextTdeExportOptions: Optional. Export parameters specific to SQL
// Server TDE certificates
type ExportContextTdeExportOptions struct {
	// CertificatePath: Required. Path to the TDE certificate public key in the
	// form gs://bucketName/fileName. The instance must have write access to the
	// location. Applicable only for SQL Server instances.
	CertificatePath string `json:"certificatePath,omitempty"`
	// Name: Required. Certificate name. Applicable only for SQL Server instances.
	Name string `json:"name,omitempty"`
	// PrivateKeyPassword: Required. Password that encrypts the private key.
	PrivateKeyPassword string `json:"privateKeyPassword,omitempty"`
	// PrivateKeyPath: Required. Path to the TDE certificate private key in the
	// form gs://bucketName/fileName. The instance must have write access to the
	// location. Applicable only for SQL Server instances.
	PrivateKeyPath string `json:"privateKeyPath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CertificatePath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertificatePath") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExportContextTdeExportOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ExportContextTdeExportOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ExternalSyncSelectedObject: The selected object that Cloud SQL migrates.
type ExternalSyncSelectedObject struct {
	// Database: The name of the database that Cloud SQL migrates.
	Database string `json:"database,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Database") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Database") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ExternalSyncSelectedObject) MarshalJSON() ([]byte, error) {
	type NoMethod ExternalSyncSelectedObject
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FailoverContext: Database instance failover context.
type FailoverContext struct {
	// Kind: This is always `sql#failoverContext`.
	Kind string `json:"kind,omitempty"`
	// SettingsVersion: The current settings version of this instance. Request will
	// be rejected if this version doesn't match the current settings version.
	SettingsVersion int64 `json:"settingsVersion,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FailoverContext) MarshalJSON() ([]byte, error) {
	type NoMethod FailoverContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FinalBackupConfig: Config used to determine the final backup settings for
// the instance.
type FinalBackupConfig struct {
	// Enabled: Whether the final backup is enabled for the instance.
	Enabled bool `json:"enabled,omitempty"`
	// RetentionDays: The number of days to retain the final backup after the
	// instance deletion. The final backup will be purged at
	// (time_of_instance_deletion + retention_days).
	RetentionDays int64 `json:"retentionDays,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FinalBackupConfig) MarshalJSON() ([]byte, error) {
	type NoMethod FinalBackupConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Flag: A flag resource.
type Flag struct {
	// AllowedIntValues: Use this field if only certain integers are accepted. Can
	// be combined with min_value and max_value to add additional values.
	AllowedIntValues googleapi.Int64s `json:"allowedIntValues,omitempty"`
	// AllowedStringValues: For `STRING` flags, a list of strings that the value
	// can be set to.
	AllowedStringValues []string `json:"allowedStringValues,omitempty"`
	// AppliesTo: The database version this flag applies to. Can be MySQL
	// instances: `MYSQL_8_0`, `MYSQL_8_0_18`, `MYSQL_8_0_26`, `MYSQL_5_7`, or
	// `MYSQL_5_6`. PostgreSQL instances: `POSTGRES_9_6`, `POSTGRES_10`,
	// `POSTGRES_11` or `POSTGRES_12`. SQL Server instances:
	// `SQLSERVER_2017_STANDARD`, `SQLSERVER_2017_ENTERPRISE`,
	// `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`, `SQLSERVER_2019_STANDARD`,
	// `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`, or
	// `SQLSERVER_2019_WEB`. See the complete list
	// (/sql/docs/mysql/admin-api/rest/v1/SqlDatabaseVersion).
	//
	// Possible values:
	//   "SQL_DATABASE_VERSION_UNSPECIFIED" - This is an unknown database version.
	//   "MYSQL_5_1" - The database version is MySQL 5.1.
	//   "MYSQL_5_5" - The database version is MySQL 5.5.
	//   "MYSQL_5_6" - The database version is MySQL 5.6.
	//   "MYSQL_5_7" - The database version is MySQL 5.7.
	//   "MYSQL_8_0" - The database version is MySQL 8.
	//   "MYSQL_8_0_18" - The database major version is MySQL 8.0 and the minor
	// version is 18.
	//   "MYSQL_8_0_26" - The database major version is MySQL 8.0 and the minor
	// version is 26.
	//   "MYSQL_8_0_27" - The database major version is MySQL 8.0 and the minor
	// version is 27.
	//   "MYSQL_8_0_28" - The database major version is MySQL 8.0 and the minor
	// version is 28.
	//   "MYSQL_8_0_29" - The database major version is MySQL 8.0 and the minor
	// version is 29.
	//   "MYSQL_8_0_30" - The database major version is MySQL 8.0 and the minor
	// version is 30.
	//   "MYSQL_8_0_31" - The database major version is MySQL 8.0 and the minor
	// version is 31.
	//   "MYSQL_8_0_32" - The database major version is MySQL 8.0 and the minor
	// version is 32.
	//   "MYSQL_8_0_33" - The database major version is MySQL 8.0 and the minor
	// version is 33.
	//   "MYSQL_8_0_34" - The database major version is MySQL 8.0 and the minor
	// version is 34.
	//   "MYSQL_8_0_35" - The database major version is MySQL 8.0 and the minor
	// version is 35.
	//   "MYSQL_8_0_36" - The database major version is MySQL 8.0 and the minor
	// version is 36.
	//   "MYSQL_8_0_37" - The database major version is MySQL 8.0 and the minor
	// version is 37.
	//   "MYSQL_8_0_39" - The database major version is MySQL 8.0 and the minor
	// version is 39.
	//   "MYSQL_8_0_40" - The database major version is MySQL 8.0 and the minor
	// version is 40.
	//   "MYSQL_8_0_41" - The database major version is MySQL 8.0 and the minor
	// version is 41.
	//   "MYSQL_8_0_42" - The database major version is MySQL 8.0 and the minor
	// version is 42.
	//   "MYSQL_8_0_43" - The database major version is MySQL 8.0 and the minor
	// version is 43.
	//   "MYSQL_8_0_44" - The database major version is MySQL 8.0 and the minor
	// version is 44.
	//   "MYSQL_8_0_45" - The database major version is MySQL 8.0 and the minor
	// version is 45.
	//   "MYSQL_8_0_46" - The database major version is MySQL 8.0 and the minor
	// version is 46.
	//   "MYSQL_8_4" - The database version is MySQL 8.4.
	//   "SQLSERVER_2017_STANDARD" - The database version is SQL Server 2017
	// Standard.
	//   "SQLSERVER_2017_ENTERPRISE" - The database version is SQL Server 2017
	// Enterprise.
	//   "SQLSERVER_2017_EXPRESS" - The database version is SQL Server 2017
	// Express.
	//   "SQLSERVER_2017_WEB" - The database version is SQL Server 2017 Web.
	//   "POSTGRES_9_6" - The database version is PostgreSQL 9.6.
	//   "POSTGRES_10" - The database version is PostgreSQL 10.
	//   "POSTGRES_11" - The database version is PostgreSQL 11.
	//   "POSTGRES_12" - The database version is PostgreSQL 12.
	//   "POSTGRES_13" - The database version is PostgreSQL 13.
	//   "POSTGRES_14" - The database version is PostgreSQL 14.
	//   "POSTGRES_15" - The database version is PostgreSQL 15.
	//   "POSTGRES_16" - The database version is PostgreSQL 16.
	//   "POSTGRES_17" - The database version is PostgreSQL 17.
	//   "POSTGRES_18" - The database version is PostgreSQL 18.
	//   "SQLSERVER_2019_STANDARD" - The database version is SQL Server 2019
	// Standard.
	//   "SQLSERVER_2019_ENTERPRISE" - The database version is SQL Server 2019
	// Enterprise.
	//   "SQLSERVER_2019_EXPRESS" - The database version is SQL Server 2019
	// Express.
	//   "SQLSERVER_2019_WEB" - The database version is SQL Server 2019 Web.
	//   "SQLSERVER_2022_STANDARD" - The database version is SQL Server 2022
	// Standard.
	//   "SQLSERVER_2022_ENTERPRISE" - The database version is SQL Server 2022
	// Enterprise.
	//   "SQLSERVER_2022_EXPRESS" - The database version is SQL Server 2022
	// Express.
	//   "SQLSERVER_2022_WEB" - The database version is SQL Server 2022 Web.
	AppliesTo []string `json:"appliesTo,omitempty"`
	// FlagScope: Scope of flag.
	//
	// Possible values:
	//   "SQL_FLAG_SCOPE_UNSPECIFIED" - Assume database flags if unspecified
	//   "SQL_FLAG_SCOPE_DATABASE" - database flags
	//   "SQL_FLAG_SCOPE_CONNECTION_POOL" - connection pool configuration flags
	FlagScope string `json:"flagScope,omitempty"`
	// InBeta: Whether or not the flag is considered in beta.
	InBeta bool `json:"inBeta,omitempty"`
	// Kind: This is always `sql#flag`.
	Kind string `json:"kind,omitempty"`
	// MaxValue: For `INTEGER` flags, the maximum allowed value.
	MaxValue int64 `json:"maxValue,omitempty,string"`
	// MinValue: For `INTEGER` flags, the minimum allowed value.
	MinValue int64 `json:"minValue,omitempty,string"`
	// Name: This is the name of the flag. Flag names always use underscores, not
	// hyphens, for example: `max_allowed_packet`
	Name string `json:"name,omitempty"`
	// RecommendedIntValue: Recommended flag value in integer format for UI
	// display.
	RecommendedIntValue int64 `json:"recommendedIntValue,omitempty,string"`
	// RecommendedStringValue: Recommended flag value in string format for UI
	// display.
	RecommendedStringValue string `json:"recommendedStringValue,omitempty"`
	// RequiresRestart: Indicates whether changing this flag will trigger a
	// database restart. Only applicable to Second Generation instances.
	RequiresRestart bool `json:"requiresRestart,omitempty"`
	// Type: The type of the flag. Flags are typed to being `BOOLEAN`, `STRING`,
	// `INTEGER` or `NONE`. `NONE` is used for flags which do not take a value,
	// such as `skip_grant_tables`.
	//
	// Possible values:
	//   "SQL_FLAG_TYPE_UNSPECIFIED" - This is an unknown flag type.
	//   "BOOLEAN" - Boolean type flag.
	//   "STRING" - String type flag.
	//   "INTEGER" - Integer type flag.
	//   "NONE" - Flag type used for a server startup option.
	//   "MYSQL_TIMEZONE_OFFSET" - Type introduced specially for MySQL TimeZone
	// offset. Accept a string value with the format [-12:59, 13:00].
	//   "FLOAT" - Float type flag.
	//   "REPEATED_STRING" - Comma-separated list of the strings in a SqlFlagType
	// enum.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedIntValues") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedIntValues") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Flag) MarshalJSON() ([]byte, error) {
	type NoMethod Flag
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// FlagsListResponse: Flags list response.
type FlagsListResponse struct {
	// Items: List of flags.
	Items []*Flag `json:"items,omitempty"`
	// Kind: This is always `sql#flagsList`.
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s FlagsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod FlagsListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GeminiInstanceConfig: Gemini instance configuration.
type GeminiInstanceConfig struct {
	// ActiveQueryEnabled: Output only. Whether the active query is enabled.
	ActiveQueryEnabled bool `json:"activeQueryEnabled,omitempty"`
	// Entitled: Output only. Whether Gemini is enabled.
	Entitled bool `json:"entitled,omitempty"`
	// FlagRecommenderEnabled: Output only. Whether the flag recommender is
	// enabled.
	FlagRecommenderEnabled bool `json:"flagRecommenderEnabled,omitempty"`
	// GoogleVacuumMgmtEnabled: Output only. Whether the vacuum management is
	// enabled.
	GoogleVacuumMgmtEnabled bool `json:"googleVacuumMgmtEnabled,omitempty"`
	// IndexAdvisorEnabled: Output only. Whether the index advisor is enabled.
	IndexAdvisorEnabled bool `json:"indexAdvisorEnabled,omitempty"`
	// OomSessionCancelEnabled: Output only. Whether canceling the out-of-memory
	// (OOM) session is enabled.
	OomSessionCancelEnabled bool `json:"oomSessionCancelEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActiveQueryEnabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveQueryEnabled") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GeminiInstanceConfig) MarshalJSON() ([]byte, error) {
	type NoMethod GeminiInstanceConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenerateEphemeralCertRequest: Ephemeral certificate creation request.
type GenerateEphemeralCertRequest struct {
	// AccessToken: Optional. Access token to include in the signed certificate.
	AccessToken string `json:"access_token,omitempty"`
	// PublicKey: PEM encoded public key to include in the signed certificate.
	PublicKey string `json:"public_key,omitempty"`
	// ReadTime: Optional. Optional snapshot read timestamp to trade freshness for
	// performance.
	ReadTime string `json:"readTime,omitempty"`
	// ValidDuration: Optional. If set, it will contain the cert valid duration.
	ValidDuration string `json:"validDuration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateEphemeralCertRequest) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateEphemeralCertRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// GenerateEphemeralCertResponse: Ephemeral certificate creation request.
type GenerateEphemeralCertResponse struct {
	// EphemeralCert: Generated cert
	EphemeralCert *SslCert `json:"ephemeralCert,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EphemeralCert") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EphemeralCert") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s GenerateEphemeralCertResponse) MarshalJSON() ([]byte, error) {
	type NoMethod GenerateEphemeralCertResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportContext: Database instance import context.
type ImportContext struct {
	// BakImportOptions: Import parameters specific to SQL Server .BAK files
	BakImportOptions *ImportContextBakImportOptions `json:"bakImportOptions,omitempty"`
	// CsvImportOptions: Options for importing data as CSV.
	CsvImportOptions *ImportContextCsvImportOptions `json:"csvImportOptions,omitempty"`
	// Database: The target database for the import. If `fileType` is `SQL`, this
	// field is required only if the import file does not specify a database, and
	// is overridden by any database specification in the import file. For entire
	// instance parallel import operations, the database is overridden by the
	// database name stored in subdirectory name. If `fileType` is `CSV`, one
	// database must be specified.
	Database string `json:"database,omitempty"`
	// FileType: The file type for the specified uri. * `SQL`: The file contains
	// SQL statements. * `CSV`: The file contains CSV data. * `BAK`: The file
	// contains backup data for a SQL Server instance.
	//
	// Possible values:
	//   "SQL_FILE_TYPE_UNSPECIFIED" - Unknown file type.
	//   "SQL" - File containing SQL statements.
	//   "CSV" - File in CSV format.
	//   "BAK"
	//   "TDE" - TDE certificate.
	FileType string `json:"fileType,omitempty"`
	// ImportUser: The PostgreSQL user for this import operation. PostgreSQL
	// instances only.
	ImportUser string `json:"importUser,omitempty"`
	// Kind: This is always `sql#importContext`.
	Kind string `json:"kind,omitempty"`
	// SqlImportOptions: Optional. Options for importing data from SQL statements.
	SqlImportOptions *ImportContextSqlImportOptions `json:"sqlImportOptions,omitempty"`
	// TdeImportOptions: Optional. Import parameters specific to SQL Server .TDE
	// files Import parameters specific to SQL Server TDE certificates
	TdeImportOptions *ImportContextTdeImportOptions `json:"tdeImportOptions,omitempty"`
	// Uri: Path to the import file in Cloud Storage, in the form
	// `gs://bucketName/fileName`. Compressed gzip files (.gz) are supported when
	// `fileType` is `SQL`. The instance must have write permissions to the bucket
	// and read access to the file.
	Uri string `json:"uri,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BakImportOptions") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BakImportOptions") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportContext) MarshalJSON() ([]byte, error) {
	type NoMethod ImportContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportContextBakImportOptions: Import parameters specific to SQL Server .BAK
// files
type ImportContextBakImportOptions struct {
	// BakType: Type of the bak content, FULL or DIFF.
	//
	// Possible values:
	//   "BAK_TYPE_UNSPECIFIED" - Default type.
	//   "FULL" - Full backup.
	//   "DIFF" - Differential backup.
	//   "TLOG" - SQL Server Transaction Log
	BakType           string                                          `json:"bakType,omitempty"`
	EncryptionOptions *ImportContextBakImportOptionsEncryptionOptions `json:"encryptionOptions,omitempty"`
	// NoRecovery: Whether or not the backup importing will restore database with
	// NORECOVERY option. Applies only to Cloud SQL for SQL Server.
	NoRecovery bool `json:"noRecovery,omitempty"`
	// RecoveryOnly: Whether or not the backup importing request will just bring
	// database online without downloading Bak content only one of "no_recovery"
	// and "recovery_only" can be true otherwise error will return. Applies only to
	// Cloud SQL for SQL Server.
	RecoveryOnly bool `json:"recoveryOnly,omitempty"`
	// StopAt: Optional. The timestamp when the import should stop. This timestamp
	// is in the RFC 3339 (https://tools.ietf.org/html/rfc3339) format (for
	// example, `2023-10-01T16:19:00.094`). This field is equivalent to the STOPAT
	// keyword and applies to Cloud SQL for SQL Server only.
	StopAt string `json:"stopAt,omitempty"`
	// StopAtMark: Optional. The marked transaction where the import should stop.
	// This field is equivalent to the STOPATMARK keyword and applies to Cloud SQL
	// for SQL Server only.
	StopAtMark string `json:"stopAtMark,omitempty"`
	// Striped: Whether or not the backup set being restored is striped. Applies
	// only to Cloud SQL for SQL Server.
	Striped bool `json:"striped,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BakType") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BakType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportContextBakImportOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ImportContextBakImportOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type ImportContextBakImportOptionsEncryptionOptions struct {
	// CertPath: Path to the Certificate (.cer) in Cloud Storage, in the form
	// `gs://bucketName/fileName`. The instance must have write permissions to the
	// bucket and read access to the file.
	CertPath string `json:"certPath,omitempty"`
	// KeepEncrypted: Optional. Whether the imported file remains encrypted.
	KeepEncrypted bool `json:"keepEncrypted,omitempty"`
	// PvkPassword: Password that encrypts the private key
	PvkPassword string `json:"pvkPassword,omitempty"`
	// PvkPath: Path to the Certificate Private Key (.pvk) in Cloud Storage, in the
	// form `gs://bucketName/fileName`. The instance must have write permissions to
	// the bucket and read access to the file.
	PvkPath string `json:"pvkPath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CertPath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertPath") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportContextBakImportOptionsEncryptionOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ImportContextBakImportOptionsEncryptionOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportContextCsvImportOptions: Options for importing data as CSV.
type ImportContextCsvImportOptions struct {
	// Columns: The columns to which CSV data is imported. If not specified, all
	// columns of the database table are loaded with CSV data.
	Columns []string `json:"columns,omitempty"`
	// EscapeCharacter: Specifies the character that should appear before a data
	// character that needs to be escaped.
	EscapeCharacter string `json:"escapeCharacter,omitempty"`
	// FieldsTerminatedBy: Specifies the character that separates columns within
	// each row (line) of the file.
	FieldsTerminatedBy string `json:"fieldsTerminatedBy,omitempty"`
	// LinesTerminatedBy: This is used to separate lines. If a line does not
	// contain all fields, the rest of the columns are set to their default values.
	LinesTerminatedBy string `json:"linesTerminatedBy,omitempty"`
	// QuoteCharacter: Specifies the quoting character to be used when a data value
	// is quoted.
	QuoteCharacter string `json:"quoteCharacter,omitempty"`
	// Table: The table to which CSV data is imported.
	Table string `json:"table,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Columns") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Columns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportContextCsvImportOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ImportContextCsvImportOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportContextSqlImportOptions: Optional. Options for importing data from SQL
// statements.
type ImportContextSqlImportOptions struct {
	// Parallel: Optional. Whether or not the import should be parallel.
	Parallel bool `json:"parallel,omitempty"`
	// PostgresImportOptions: Optional. Options for importing from a Cloud SQL for
	// PostgreSQL instance.
	PostgresImportOptions *ImportContextSqlImportOptionsPostgresImportOptions `json:"postgresImportOptions,omitempty"`
	// Threads: Optional. The number of threads to use for parallel import.
	Threads int64 `json:"threads,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Parallel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Parallel") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportContextSqlImportOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ImportContextSqlImportOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportContextSqlImportOptionsPostgresImportOptions: Optional. Options for
// importing from a Cloud SQL for PostgreSQL instance.
type ImportContextSqlImportOptionsPostgresImportOptions struct {
	// Clean: Optional. The --clean flag for the pg_restore utility. This flag
	// applies only if you enabled Cloud SQL to import files in parallel.
	Clean bool `json:"clean,omitempty"`
	// IfExists: Optional. The --if-exists flag for the pg_restore utility. This
	// flag applies only if you enabled Cloud SQL to import files in parallel.
	IfExists bool `json:"ifExists,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Clean") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Clean") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportContextSqlImportOptionsPostgresImportOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ImportContextSqlImportOptionsPostgresImportOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ImportContextTdeImportOptions: Optional. Import parameters specific to SQL
// Server .TDE files Import parameters specific to SQL Server TDE certificates
type ImportContextTdeImportOptions struct {
	// CertificatePath: Required. Path to the TDE certificate public key in the
	// form gs://bucketName/fileName. The instance must have read access to the
	// file. Applicable only for SQL Server instances.
	CertificatePath string `json:"certificatePath,omitempty"`
	// Name: Required. Certificate name. Applicable only for SQL Server instances.
	Name string `json:"name,omitempty"`
	// PrivateKeyPassword: Required. Password that encrypts the private key.
	PrivateKeyPassword string `json:"privateKeyPassword,omitempty"`
	// PrivateKeyPath: Required. Path to the TDE certificate private key in the
	// form gs://bucketName/fileName. The instance must have read access to the
	// file. Applicable only for SQL Server instances.
	PrivateKeyPath string `json:"privateKeyPath,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CertificatePath") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertificatePath") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ImportContextTdeImportOptions) MarshalJSON() ([]byte, error) {
	type NoMethod ImportContextTdeImportOptions
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InsightsConfig: Insights configuration. This specifies when Cloud SQL
// Insights feature is enabled and optional configuration.
type InsightsConfig struct {
	// QueryInsightsEnabled: Whether Query Insights feature is enabled.
	QueryInsightsEnabled bool `json:"queryInsightsEnabled,omitempty"`
	// QueryPlansPerMinute: Number of query execution plans captured by Insights
	// per minute for all queries combined. Default is 5.
	QueryPlansPerMinute int64 `json:"queryPlansPerMinute,omitempty"`
	// QueryStringLength: Maximum query length stored in bytes. Default value: 1024
	// bytes. Range: 256-4500 bytes. Query lengths greater than this field value
	// will be truncated to this value. When unset, query length will be the
	// default value. Changing query length will restart the database.
	QueryStringLength int64 `json:"queryStringLength,omitempty"`
	// RecordApplicationTags: Whether Query Insights will record application tags
	// from query when enabled.
	RecordApplicationTags bool `json:"recordApplicationTags,omitempty"`
	// RecordClientAddress: Whether Query Insights will record client address when
	// enabled.
	RecordClientAddress bool `json:"recordClientAddress,omitempty"`
	// ForceSendFields is a list of field names (e.g. "QueryInsightsEnabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "QueryInsightsEnabled") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InsightsConfig) MarshalJSON() ([]byte, error) {
	type NoMethod InsightsConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstanceReference: Reference to another Cloud SQL instance.
type InstanceReference struct {
	// Name: The name of the Cloud SQL instance being referenced. This does not
	// include the project ID.
	Name string `json:"name,omitempty"`
	// Project: The project ID of the Cloud SQL instance being referenced. The
	// default is the same project ID as the instance references it.
	Project string `json:"project,omitempty"`
	// Region: The region of the Cloud SQL instance being referenced.
	Region string `json:"region,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstanceReference) MarshalJSON() ([]byte, error) {
	type NoMethod InstanceReference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstancesAcquireSsrsLeaseRequest: Request to acquire an SSRS lease for an
// instance.
type InstancesAcquireSsrsLeaseRequest struct {
	// AcquireSsrsLeaseContext: Contains details about the acquire SSRS lease
	// operation.
	AcquireSsrsLeaseContext *AcquireSsrsLeaseContext `json:"acquireSsrsLeaseContext,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AcquireSsrsLeaseContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcquireSsrsLeaseContext") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstancesAcquireSsrsLeaseRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesAcquireSsrsLeaseRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstancesCloneRequest: Database instance clone request.
type InstancesCloneRequest struct {
	// CloneContext: Contains details about the clone operation.
	CloneContext *CloneContext `json:"cloneContext,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CloneContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CloneContext") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstancesCloneRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesCloneRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstancesDemoteMasterRequest: Database demote primary instance request.
type InstancesDemoteMasterRequest struct {
	// DemoteMasterContext: Contains details about the demoteMaster operation.
	DemoteMasterContext *DemoteMasterContext `json:"demoteMasterContext,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DemoteMasterContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DemoteMasterContext") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstancesDemoteMasterRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesDemoteMasterRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstancesDemoteRequest: This request is used to demote an existing
// standalone instance to be a Cloud SQL read replica for an external database
// server.
type InstancesDemoteRequest struct {
	// DemoteContext: Required. This context is used to demote an existing
	// standalone instance to be a Cloud SQL read replica for an external database
	// server.
	DemoteContext *DemoteContext `json:"demoteContext,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DemoteContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DemoteContext") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstancesDemoteRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesDemoteRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstancesExportRequest: Database instance export request.
type InstancesExportRequest struct {
	// ExportContext: Contains details about the export operation.
	ExportContext *ExportContext `json:"exportContext,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ExportContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ExportContext") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstancesExportRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesExportRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstancesFailoverRequest: Instance failover request.
type InstancesFailoverRequest struct {
	// FailoverContext: Failover Context.
	FailoverContext *FailoverContext `json:"failoverContext,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FailoverContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FailoverContext") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstancesFailoverRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesFailoverRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstancesImportRequest: Database instance import request.
type InstancesImportRequest struct {
	// ImportContext: Contains details about the import operation.
	ImportContext *ImportContext `json:"importContext,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ImportContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ImportContext") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstancesImportRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesImportRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstancesListEntraIdCertificatesResponse: Instances ListEntraIdCertificates
// response.
type InstancesListEntraIdCertificatesResponse struct {
	// ActiveVersion: The `sha1_fingerprint` of the active certificate from
	// `certs`.
	ActiveVersion string `json:"activeVersion,omitempty"`
	// Certs: List of Entra ID certificates for the instance.
	Certs []*SslCert `json:"certs,omitempty"`
	// Kind: This is always `sql#instancesListEntraIdCertificates`.
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ActiveVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstancesListEntraIdCertificatesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesListEntraIdCertificatesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstancesListResponse: Database instances list response.
type InstancesListResponse struct {
	// Items: List of database instance resources.
	Items []*DatabaseInstance `json:"items,omitempty"`
	// Kind: This is always `sql#instancesList`.
	Kind string `json:"kind,omitempty"`
	// NextPageToken: The continuation token, used to page through large result
	// sets. Provide this value in a subsequent request to return the next page of
	// results.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Warnings: List of warnings that occurred while handling the request.
	Warnings []*ApiWarning `json:"warnings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstancesListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstancesListServerCasResponse: Instances ListServerCas response.
type InstancesListServerCasResponse struct {
	ActiveVersion string `json:"activeVersion,omitempty"`
	// Certs: List of server CA certificates for the instance.
	Certs []*SslCert `json:"certs,omitempty"`
	// Kind: This is always `sql#instancesListServerCas`.
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ActiveVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstancesListServerCasResponse) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesListServerCasResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstancesListServerCertificatesResponse: Instances ListServerCertificatess
// response.
type InstancesListServerCertificatesResponse struct {
	// ActiveVersion: The `sha1_fingerprint` of the active certificate from
	// `server_certs`.
	ActiveVersion string `json:"activeVersion,omitempty"`
	// CaCerts: List of server CA certificates for the instance.
	CaCerts []*SslCert `json:"caCerts,omitempty"`
	// Kind: This is always `sql#instancesListServerCertificates`.
	Kind string `json:"kind,omitempty"`
	// ServerCerts: List of server certificates for the instance, signed by the
	// corresponding CA from the `ca_certs` list.
	ServerCerts []*SslCert `json:"serverCerts,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ActiveVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActiveVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstancesListServerCertificatesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesListServerCertificatesResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstancesPreCheckMajorVersionUpgradeRequest: Request for Pre-checks for MVU
type InstancesPreCheckMajorVersionUpgradeRequest struct {
	// PreCheckMajorVersionUpgradeContext: Required. Contains details about the
	// pre-check major version upgrade operation.
	PreCheckMajorVersionUpgradeContext *PreCheckMajorVersionUpgradeContext `json:"preCheckMajorVersionUpgradeContext,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "PreCheckMajorVersionUpgradeContext") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g.
	// "PreCheckMajorVersionUpgradeContext") to include in API requests with the
	// JSON null value. By default, fields with empty values are omitted from API
	// requests. See https://pkg.go.dev/google.golang.org/api#hdr-NullFields for
	// more details.
	NullFields []string `json:"-"`
}

func (s InstancesPreCheckMajorVersionUpgradeRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesPreCheckMajorVersionUpgradeRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstancesReencryptRequest: Database Instance reencrypt request.
type InstancesReencryptRequest struct {
	// BackupReencryptionConfig: Configuration specific to backup re-encryption
	BackupReencryptionConfig *BackupReencryptionConfig `json:"backupReencryptionConfig,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BackupReencryptionConfig")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackupReencryptionConfig") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstancesReencryptRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesReencryptRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstancesRestoreBackupRequest: Database instance restore backup request.
type InstancesRestoreBackupRequest struct {
	// Backup: The name of the backup that's used to restore a Cloud SQL instance:
	// Format: projects/{project-id}/backups/{backup-uid}. Only one of
	// restore_backup_context, backup, backupdr_backup can be passed to the input.
	Backup string `json:"backup,omitempty"`
	// BackupdrBackup: The name of the backup that's used to restore a Cloud SQL
	// instance: Format:
	// "projects/{project-id}/locations/{location}/backupVaults/{backupvault}/dataSo
	// urces/{datasource}/backups/{backup-uid}". Only one of
	// restore_backup_context, backup, backupdr_backup can be passed to the input.
	BackupdrBackup string `json:"backupdrBackup,omitempty"`
	// RestoreBackupContext: Parameters required to perform the restore backup
	// operation.
	RestoreBackupContext *RestoreBackupContext `json:"restoreBackupContext,omitempty"`
	// RestoreInstanceClearOverridesFieldNames: Optional. This field has the same
	// purpose as restore_instance_settings, changes any instance settings stored
	// in the backup you are restoring from. With the difference that these fields
	// are cleared in the settings.
	RestoreInstanceClearOverridesFieldNames []string `json:"restoreInstanceClearOverridesFieldNames,omitempty"`
	// RestoreInstanceSettings: Optional. By using this parameter, Cloud SQL
	// overrides any instance settings stored in the backup you are restoring from.
	// You can't change the instance's major database version and you can only
	// increase the disk size. You can use this field to restore new instances
	// only. This field is not applicable for restore to existing instances.
	RestoreInstanceSettings *DatabaseInstance `json:"restoreInstanceSettings,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Backup") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Backup") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstancesRestoreBackupRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesRestoreBackupRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstancesRotateEntraIdCertificateRequest: Rotate Entra ID Certificate
// request.
type InstancesRotateEntraIdCertificateRequest struct {
	// RotateEntraIdCertificateContext: Optional. Contains details about the rotate
	// Entra ID certificate operation.
	RotateEntraIdCertificateContext *RotateEntraIdCertificateContext `json:"rotateEntraIdCertificateContext,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "RotateEntraIdCertificateContext") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RotateEntraIdCertificateContext")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstancesRotateEntraIdCertificateRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesRotateEntraIdCertificateRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstancesRotateServerCaRequest: Rotate Server CA request.
type InstancesRotateServerCaRequest struct {
	// RotateServerCaContext: Contains details about the rotate server CA
	// operation.
	RotateServerCaContext *RotateServerCaContext `json:"rotateServerCaContext,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RotateServerCaContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RotateServerCaContext") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstancesRotateServerCaRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesRotateServerCaRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstancesRotateServerCertificateRequest: Rotate Server Certificate request.
type InstancesRotateServerCertificateRequest struct {
	// RotateServerCertificateContext: Optional. Contains details about the rotate
	// server CA operation.
	RotateServerCertificateContext *RotateServerCertificateContext `json:"rotateServerCertificateContext,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "RotateServerCertificateContext") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RotateServerCertificateContext")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstancesRotateServerCertificateRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesRotateServerCertificateRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// InstancesTruncateLogRequest: Instance truncate log request.
type InstancesTruncateLogRequest struct {
	// TruncateLogContext: Contains details about the truncate log operation.
	TruncateLogContext *TruncateLogContext `json:"truncateLogContext,omitempty"`
	// ForceSendFields is a list of field names (e.g. "TruncateLogContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TruncateLogContext") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s InstancesTruncateLogRequest) MarshalJSON() ([]byte, error) {
	type NoMethod InstancesTruncateLogRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Interval: Represents a time interval, encoded as a Timestamp start
// (inclusive) and a Timestamp end (exclusive). The start must be less than or
// equal to the end. When the start equals the end, the interval is empty
// (matches no time). When both start and end are unspecified, the interval
// matches any time.
type Interval struct {
	// EndTime: Optional. Exclusive end of the interval. If specified, a Timestamp
	// matching this interval will have to be before the end.
	EndTime string `json:"endTime,omitempty"`
	// StartTime: Optional. Inclusive start of the interval. If specified, a
	// Timestamp matching this interval will have to be the same or after the
	// start.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "EndTime") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EndTime") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Interval) MarshalJSON() ([]byte, error) {
	type NoMethod Interval
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IpConfiguration: IP Management configuration.
type IpConfiguration struct {
	// AllocatedIpRange: The name of the allocated ip range for the private ip
	// Cloud SQL instance. For example: "google-managed-services-default". If set,
	// the instance ip will be created in the allocated range. The range name must
	// comply with RFC 1035 (https://tools.ietf.org/html/rfc1035). Specifically,
	// the name must be 1-63 characters long and match the regular expression
	// `[a-z]([-a-z0-9]*[a-z0-9])?.`
	AllocatedIpRange string `json:"allocatedIpRange,omitempty"`
	// AuthorizedNetworks: The list of external networks that are allowed to
	// connect to the instance using the IP. In 'CIDR' notation, also known as
	// 'slash' notation (for example: `157.197.200.0/24`).
	AuthorizedNetworks []*AclEntry `json:"authorizedNetworks,omitempty"`
	// CustomSubjectAlternativeNames: Optional. Custom Subject Alternative
	// Name(SAN)s for a Cloud SQL instance.
	CustomSubjectAlternativeNames []string `json:"customSubjectAlternativeNames,omitempty"`
	// EnablePrivatePathForGoogleCloudServices: Controls connectivity to private IP
	// instances from Google services, such as BigQuery.
	EnablePrivatePathForGoogleCloudServices bool `json:"enablePrivatePathForGoogleCloudServices,omitempty"`
	// Ipv4Enabled: Whether the instance is assigned a public IP address or not.
	Ipv4Enabled bool `json:"ipv4Enabled,omitempty"`
	// PrivateNetwork: The resource link for the VPC network from which the Cloud
	// SQL instance is accessible for private IP. For example,
	// `/projects/myProject/global/networks/default`. This setting can be updated,
	// but it cannot be removed after it is set.
	PrivateNetwork string `json:"privateNetwork,omitempty"`
	// PscConfig: PSC settings for this instance.
	PscConfig *PscConfig `json:"pscConfig,omitempty"`
	// RequireSsl: Use `ssl_mode` instead. Whether SSL/TLS connections over IP are
	// enforced. If set to false, then allow both non-SSL/non-TLS and SSL/TLS
	// connections. For SSL/TLS connections, the client certificate won't be
	// verified. If set to true, then only allow connections encrypted with SSL/TLS
	// and with valid client certificates. If you want to enforce SSL/TLS without
	// enforcing the requirement for valid client certificates, then use the
	// `ssl_mode` flag instead of the legacy `require_ssl` flag.
	RequireSsl bool `json:"requireSsl,omitempty"`
	// ServerCaMode: Specify what type of CA is used for the server certificate.
	//
	// Possible values:
	//   "CA_MODE_UNSPECIFIED" - CA mode is unspecified. It is effectively the same
	// as `GOOGLE_MANAGED_INTERNAL_CA`.
	//   "GOOGLE_MANAGED_INTERNAL_CA" - Google-managed self-signed internal CA.
	//   "GOOGLE_MANAGED_CAS_CA" - Google-managed regional CA part of root CA
	// hierarchy hosted on Google Cloud's Certificate Authority Service (CAS).
	//   "CUSTOMER_MANAGED_CAS_CA" - Customer-managed CA hosted on Google Cloud's
	// Certificate Authority Service (CAS).
	ServerCaMode string `json:"serverCaMode,omitempty"`
	// ServerCaPool: Optional. The resource name of the server CA pool for an
	// instance with `CUSTOMER_MANAGED_CAS_CA` as the `server_ca_mode`. Format:
	// projects/{PROJECT}/locations/{REGION}/caPools/{CA_POOL_ID}
	ServerCaPool string `json:"serverCaPool,omitempty"`
	// ServerCertificateRotationMode: Optional. Controls the automatic server
	// certificate rotation feature. This feature is disabled by default. When
	// enabled, the server certificate will be automatically rotated during Cloud
	// SQL scheduled maintenance or self-service maintenance updates up to six
	// months before it expires. This setting can only be set if server_ca_mode is
	// either GOOGLE_MANAGED_CAS_CA or CUSTOMER_MANAGED_CAS_CA.
	//
	// Possible values:
	//   "SERVER_CERTIFICATE_ROTATION_MODE_UNSPECIFIED" - Unspecified: no automatic
	// server certificate rotation.
	//   "NO_AUTOMATIC_ROTATION" - No automatic server certificate rotation. The
	// user must [manage server certificate
	// rotation](/sql/docs/mysql/manage-ssl-instance#rotate-server-certificate-cas)
	// on their side.
	//   "AUTOMATIC_ROTATION_DURING_MAINTENANCE" - Automatic server certificate
	// rotation during Cloud SQL scheduled maintenance or self-service maintenance
	// updates. Requires `server_ca_mode` to be `GOOGLE_MANAGED_CAS_CA` or
	// `CUSTOMER_MANAGED_CAS_CA`.
	ServerCertificateRotationMode string `json:"serverCertificateRotationMode,omitempty"`
	// SslMode: Specify how SSL/TLS is enforced in database connections. If you
	// must use the `require_ssl` flag for backward compatibility, then only the
	// following value pairs are valid: For PostgreSQL and MySQL: *
	// `ssl_mode=ALLOW_UNENCRYPTED_AND_ENCRYPTED` and `require_ssl=false` *
	// `ssl_mode=ENCRYPTED_ONLY` and `require_ssl=false` *
	// `ssl_mode=TRUSTED_CLIENT_CERTIFICATE_REQUIRED` and `require_ssl=true` For
	// SQL Server: * `ssl_mode=ALLOW_UNENCRYPTED_AND_ENCRYPTED` and
	// `require_ssl=false` * `ssl_mode=ENCRYPTED_ONLY` and `require_ssl=true` The
	// value of `ssl_mode` has priority over the value of `require_ssl`. For
	// example, for the pair `ssl_mode=ENCRYPTED_ONLY` and `require_ssl=false`,
	// `ssl_mode=ENCRYPTED_ONLY` means accept only SSL connections, while
	// `require_ssl=false` means accept both non-SSL and SSL connections. In this
	// case, MySQL and PostgreSQL databases respect `ssl_mode` and accepts only SSL
	// connections.
	//
	// Possible values:
	//   "SSL_MODE_UNSPECIFIED" - The SSL mode is unknown.
	//   "ALLOW_UNENCRYPTED_AND_ENCRYPTED" - Allow non-SSL/non-TLS and SSL/TLS
	// connections. For SSL connections to MySQL and PostgreSQL, the client
	// certificate isn't verified. When this value is used, the legacy
	// `require_ssl` flag must be false or cleared to avoid a conflict between the
	// values of the two flags.
	//   "ENCRYPTED_ONLY" - Only allow connections encrypted with SSL/TLS. For SSL
	// connections to MySQL and PostgreSQL, the client certificate isn't verified.
	// When this value is used, the legacy `require_ssl` flag must be false or
	// cleared to avoid a conflict between the values of the two flags.
	//   "TRUSTED_CLIENT_CERTIFICATE_REQUIRED" - Only allow connections encrypted
	// with SSL/TLS and with valid client certificates. When this value is used,
	// the legacy `require_ssl` flag must be true or cleared to avoid the conflict
	// between values of two flags. PostgreSQL clients or users that connect using
	// IAM database authentication must use either the [Cloud SQL Auth
	// Proxy](https://cloud.google.com/sql/docs/postgres/connect-auth-proxy) or
	// [Cloud SQL
	// Connectors](https://cloud.google.com/sql/docs/postgres/connect-connectors)
	// to enforce client identity verification. Only applicable to MySQL and
	// PostgreSQL. Not applicable to SQL Server.
	SslMode string `json:"sslMode,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllocatedIpRange") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllocatedIpRange") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IpConfiguration) MarshalJSON() ([]byte, error) {
	type NoMethod IpConfiguration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// IpMapping: Database instance IP mapping
type IpMapping struct {
	// IpAddress: The IP address assigned.
	IpAddress string `json:"ipAddress,omitempty"`
	// TimeToRetire: The due time for this IP to be retired in RFC 3339
	// (https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`. This field is only available when the IP is
	// scheduled to be retired.
	TimeToRetire string `json:"timeToRetire,omitempty"`
	// Type: The type of this IP address. A `PRIMARY` address is a public address
	// that can accept incoming connections. A `PRIVATE` address is a private
	// address that can accept incoming connections. An `OUTGOING` address is the
	// source address of connections originating from the instance, if supported.
	//
	// Possible values:
	//   "SQL_IP_ADDRESS_TYPE_UNSPECIFIED" - This is an unknown IP address type.
	//   "PRIMARY" - IP address the customer is supposed to connect to. Usually
	// this is the load balancer's IP address
	//   "OUTGOING" - Source IP address of the connection a read replica
	// establishes to its external primary instance. This IP address can be
	// allowlisted by the customer in case it has a firewall that filters incoming
	// connection to its on premises primary instance.
	//   "PRIVATE" - Private IP used when using private IPs and network peering.
	//   "MIGRATED_1ST_GEN" - V1 IP of a migrated instance. We want the user to
	// decommission this IP as soon as the migration is complete. Note: V1
	// instances with V1 ip addresses will be counted as PRIMARY.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "IpAddress") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "IpAddress") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s IpMapping) MarshalJSON() ([]byte, error) {
	type NoMethod IpMapping
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ListBackupsResponse: The response payload containing a list of the backups.
type ListBackupsResponse struct {
	// Backups: A list of backups.
	Backups []*Backup `json:"backups,omitempty"`
	// NextPageToken: A token, which can be sent as `page_token` to retrieve the
	// next page. If this field is omitted, then there aren't subsequent pages.
	NextPageToken string `json:"nextPageToken,omitempty"`
	// Warnings: If a region isn't unavailable or if an unknown error occurs, then
	// a warning message is returned.
	Warnings []*ApiWarning `json:"warnings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Backups") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Backups") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ListBackupsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListBackupsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// LocationPreference: Preferred location. This specifies where a Cloud SQL
// instance is located. Note that if the preferred location is not available,
// the instance will be located as close as possible within the region. Only
// one location may be specified.
type LocationPreference struct {
	// FollowGaeApplication: The App Engine application to follow, it must be in
	// the same region as the Cloud SQL instance. WARNING: Changing this might
	// restart the instance.
	FollowGaeApplication string `json:"followGaeApplication,omitempty"`
	// Kind: This is always `sql#locationPreference`.
	Kind string `json:"kind,omitempty"`
	// SecondaryZone: The preferred Compute Engine zone for the secondary/failover
	// (for example: us-central1-a, us-central1-b, etc.). To disable this field,
	// set it to 'no_secondary_zone'.
	SecondaryZone string `json:"secondaryZone,omitempty"`
	// Zone: The preferred Compute Engine zone (for example: us-central1-a,
	// us-central1-b, etc.). WARNING: Changing this might restart the instance.
	Zone string `json:"zone,omitempty"`
	// ForceSendFields is a list of field names (e.g. "FollowGaeApplication") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "FollowGaeApplication") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s LocationPreference) MarshalJSON() ([]byte, error) {
	type NoMethod LocationPreference
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MaintenanceWindow: Maintenance window. This specifies when a Cloud SQL
// instance is restarted for system maintenance purposes.
type MaintenanceWindow struct {
	// Day: Day of week - `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`,
	// `SATURDAY`, or `SUNDAY`. Specify in the UTC time zone. Returned in output as
	// an integer, 1 to 7, where `1` equals Monday.
	Day int64 `json:"day,omitempty"`
	// Hour: Hour of day - 0 to 23. Specify in the UTC time zone.
	Hour int64 `json:"hour,omitempty"`
	// Kind: This is always `sql#maintenanceWindow`.
	Kind string `json:"kind,omitempty"`
	// UpdateTrack: Maintenance timing settings: `canary`, `stable`, or `week5`.
	// For more information, see About maintenance on Cloud SQL instances
	// (https://cloud.google.com/sql/docs/mysql/maintenance).
	//
	// Possible values:
	//   "SQL_UPDATE_TRACK_UNSPECIFIED" - This is an unknown maintenance timing
	// preference.
	//   "canary" - For an instance with a scheduled maintenance window, this
	// maintenance timing indicates that the maintenance update is scheduled 7 to
	// 14 days after the notification is sent out. Also referred to as `Week 1`
	// (Console) and `preview` (gcloud CLI).
	//   "stable" - For an instance with a scheduled maintenance window, this
	// maintenance timing indicates that the maintenance update is scheduled 15 to
	// 21 days after the notification is sent out. Also referred to as `Week 2`
	// (Console) and `production` (gcloud CLI).
	//   "week5" - For instance with a scheduled maintenance window, this
	// maintenance timing indicates that the maintenance update is scheduled 35 to
	// 42 days after the notification is sent out.
	UpdateTrack string `json:"updateTrack,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Day") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Day") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MaintenanceWindow) MarshalJSON() ([]byte, error) {
	type NoMethod MaintenanceWindow
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Message: Represents a notice or warning message from the database.
type Message struct {
	// Message: The full message string. For PostgreSQL, this is a formatted string
	// that may include severity, code, and the notice/warning message. For MySQL,
	// this contains the warning message.
	Message string `json:"message,omitempty"`
	// Severity: The severity of the message (e.g., "NOTICE" for PostgreSQL,
	// "WARNING" for MySQL).
	Severity string `json:"severity,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Message") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Message") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Message) MarshalJSON() ([]byte, error) {
	type NoMethod Message
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Metadata: The additional metadata information regarding the execution of the
// SQL statements.
type Metadata struct {
	// SqlStatementExecutionTime: The time taken to execute the SQL statements.
	SqlStatementExecutionTime string `json:"sqlStatementExecutionTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "SqlStatementExecutionTime")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SqlStatementExecutionTime") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Metadata) MarshalJSON() ([]byte, error) {
	type NoMethod Metadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MySqlReplicaConfiguration: Read-replica configuration specific to MySQL
// databases.
type MySqlReplicaConfiguration struct {
	// CaCertificate: PEM representation of the trusted CA's x509 certificate.
	CaCertificate string `json:"caCertificate,omitempty"`
	// ClientCertificate: PEM representation of the replica's x509 certificate.
	ClientCertificate string `json:"clientCertificate,omitempty"`
	// ClientKey: PEM representation of the replica's private key. The
	// corresponding public key is encoded in the client's certificate.
	ClientKey string `json:"clientKey,omitempty"`
	// ConnectRetryInterval: Seconds to wait between connect retries. MySQL's
	// default is 60 seconds.
	ConnectRetryInterval int64 `json:"connectRetryInterval,omitempty"`
	// DumpFilePath: Path to a SQL dump file in Google Cloud Storage from which the
	// replica instance is to be created. The URI is in the form
	// gs://bucketName/fileName. Compressed gzip files (.gz) are also supported.
	// Dumps have the binlog co-ordinates from which replication begins. This can
	// be accomplished by setting --master-data to 1 when using mysqldump.
	DumpFilePath string `json:"dumpFilePath,omitempty"`
	// Kind: This is always `sql#mysqlReplicaConfiguration`.
	Kind string `json:"kind,omitempty"`
	// MasterHeartbeatPeriod: Interval in milliseconds between replication
	// heartbeats.
	MasterHeartbeatPeriod int64 `json:"masterHeartbeatPeriod,omitempty,string"`
	// Password: The password for the replication connection.
	Password string `json:"password,omitempty"`
	// SslCipher: A list of permissible ciphers to use for SSL encryption.
	SslCipher string `json:"sslCipher,omitempty"`
	// Username: The username for the replication connection.
	Username string `json:"username,omitempty"`
	// VerifyServerCertificate: Whether or not to check the primary instance's
	// Common Name value in the certificate that it sends during the SSL handshake.
	VerifyServerCertificate bool `json:"verifyServerCertificate,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaCertificate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaCertificate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MySqlReplicaConfiguration) MarshalJSON() ([]byte, error) {
	type NoMethod MySqlReplicaConfiguration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// MySqlSyncConfig: MySQL-specific external server sync settings.
type MySqlSyncConfig struct {
	// InitialSyncFlags: Flags to use for the initial dump.
	InitialSyncFlags []*SyncFlags `json:"initialSyncFlags,omitempty"`
	// ForceSendFields is a list of field names (e.g. "InitialSyncFlags") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "InitialSyncFlags") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s MySqlSyncConfig) MarshalJSON() ([]byte, error) {
	type NoMethod MySqlSyncConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OnPremisesConfiguration: On-premises instance configuration.
type OnPremisesConfiguration struct {
	// CaCertificate: PEM representation of the trusted CA's x509 certificate.
	CaCertificate string `json:"caCertificate,omitempty"`
	// ClientCertificate: PEM representation of the replica's x509 certificate.
	ClientCertificate string `json:"clientCertificate,omitempty"`
	// ClientKey: PEM representation of the replica's private key. The
	// corresponding public key is encoded in the client's certificate.
	ClientKey string `json:"clientKey,omitempty"`
	// DumpFilePath: The dump file to create the Cloud SQL replica.
	DumpFilePath string `json:"dumpFilePath,omitempty"`
	// HostPort: The host and port of the on-premises instance in host:port format
	HostPort string `json:"hostPort,omitempty"`
	// Kind: This is always `sql#onPremisesConfiguration`.
	Kind string `json:"kind,omitempty"`
	// Password: The password for connecting to on-premises instance.
	Password string `json:"password,omitempty"`
	// SelectedObjects: Optional. A list of objects that the user selects for
	// replication from an external source instance.
	SelectedObjects []*SelectedObjects `json:"selectedObjects,omitempty"`
	// SourceInstance: The reference to Cloud SQL instance if the source is Cloud
	// SQL.
	SourceInstance *InstanceReference `json:"sourceInstance,omitempty"`
	// SslOption: Optional. SslOption for replica connection to the on-premises
	// source.
	//
	// Possible values:
	//   "SSL_OPTION_UNSPECIFIED" - Unknown SSL option i.e. SSL option not
	// specified by user.
	//   "DISABLE" - SSL is disabled for replica connection to the on-premises
	// source.
	//   "REQUIRE" - SSL is required for replica connection to the on-premises
	// source.
	//   "VERIFY_CA" - Verify CA is required for replica connection to the
	// on-premises source.
	SslOption string `json:"sslOption,omitempty"`
	// Username: The username for connecting to on-premises instance.
	Username string `json:"username,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CaCertificate") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CaCertificate") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OnPremisesConfiguration) MarshalJSON() ([]byte, error) {
	type NoMethod OnPremisesConfiguration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Operation: An Operation resource. For successful operations that return an
// Operation resource, only the fields relevant to the operation are populated
// in the resource.
type Operation struct {
	// AcquireSsrsLeaseContext: The context for acquire SSRS lease operation, if
	// applicable.
	AcquireSsrsLeaseContext *AcquireSsrsLeaseContext `json:"acquireSsrsLeaseContext,omitempty"`
	// ApiWarning: An Admin API warning message.
	ApiWarning *ApiWarning `json:"apiWarning,omitempty"`
	// BackupContext: The context for backup operation, if applicable.
	BackupContext *BackupContext `json:"backupContext,omitempty"`
	// EndTime: The time this operation finished in UTC timezone in RFC 3339
	// (https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	EndTime string `json:"endTime,omitempty"`
	// Error: If errors occurred during processing of this operation, this field
	// will be populated.
	Error *OperationErrors `json:"error,omitempty"`
	// ExportContext: The context for export operation, if applicable.
	ExportContext *ExportContext `json:"exportContext,omitempty"`
	// ImportContext: The context for import operation, if applicable.
	ImportContext *ImportContext `json:"importContext,omitempty"`
	// InsertTime: The time this operation was enqueued in UTC timezone in RFC 3339
	// (https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	InsertTime string `json:"insertTime,omitempty"`
	// Kind: This is always `sql#operation`.
	Kind string `json:"kind,omitempty"`
	// Name: An identifier that uniquely identifies the operation. You can use this
	// identifier to retrieve the Operations resource that has information about
	// the operation.
	Name string `json:"name,omitempty"`
	// OperationType: The type of the operation. Valid values are: * `CREATE` *
	// `DELETE` * `UPDATE` * `RESTART` * `IMPORT` * `EXPORT` * `BACKUP_VOLUME` *
	// `RESTORE_VOLUME` * `CREATE_USER` * `DELETE_USER` * `CREATE_DATABASE` *
	// `DELETE_DATABASE`
	//
	// Possible values:
	//   "SQL_OPERATION_TYPE_UNSPECIFIED" - Unknown operation type.
	//   "IMPORT" - Imports data into a Cloud SQL instance.
	//   "EXPORT" - Exports data from a Cloud SQL instance to a Cloud Storage
	// bucket.
	//   "CREATE" - Creates a new Cloud SQL instance.
	//   "UPDATE" - Updates the settings of a Cloud SQL instance.
	//   "DELETE" - Deletes a Cloud SQL instance.
	//   "RESTART" - Restarts the Cloud SQL instance.
	//   "BACKUP"
	//   "SNAPSHOT"
	//   "BACKUP_VOLUME" - Performs instance backup.
	//   "DELETE_VOLUME" - Deletes an instance backup.
	//   "RESTORE_VOLUME" - Restores an instance backup.
	//   "INJECT_USER" - Injects a privileged user in mysql for MOB instances.
	//   "CLONE" - Clones a Cloud SQL instance.
	//   "STOP_REPLICA" - Stops replication on a Cloud SQL read replica instance.
	//   "START_REPLICA" - Starts replication on a Cloud SQL read replica instance.
	//   "PROMOTE_REPLICA" - Promotes a Cloud SQL replica instance.
	//   "CREATE_REPLICA" - Creates a Cloud SQL replica instance.
	//   "CREATE_USER" - Creates a new user in a Cloud SQL instance.
	//   "DELETE_USER" - Deletes a user from a Cloud SQL instance.
	//   "UPDATE_USER" - Updates an existing user in a Cloud SQL instance.
	//   "CREATE_DATABASE" - Creates a database in the Cloud SQL instance.
	//   "DELETE_DATABASE" - Deletes a database in the Cloud SQL instance.
	//   "UPDATE_DATABASE" - Updates a database in the Cloud SQL instance.
	//   "FAILOVER" - Performs failover of an HA-enabled Cloud SQL failover
	// replica.
	//   "DELETE_BACKUP" - Deletes the backup taken by a backup run.
	//   "RECREATE_REPLICA"
	//   "TRUNCATE_LOG" - Truncates a general or slow log table in MySQL.
	//   "DEMOTE_MASTER" - Demotes the stand-alone instance to be a Cloud SQL read
	// replica for an external database server.
	//   "MAINTENANCE" - Indicates that the instance is currently in maintenance.
	// Maintenance typically causes the instance to be unavailable for 1-3 minutes.
	//   "ENABLE_PRIVATE_IP" - This field is deprecated, and will be removed in
	// future version of API.
	//   "DEFER_MAINTENANCE"
	//   "CREATE_CLONE" - Creates clone instance.
	//   "RESCHEDULE_MAINTENANCE" - Reschedule maintenance to another time.
	//   "START_EXTERNAL_SYNC" - Starts external sync of a Cloud SQL EM replica to
	// an external primary instance.
	//   "LOG_CLEANUP" - Recovers logs from an instance's old data disk.
	//   "AUTO_RESTART" - Performs auto-restart of an HA-enabled Cloud SQL database
	// for auto recovery.
	//   "REENCRYPT" - Re-encrypts CMEK instances with latest key version.
	//   "SWITCHOVER" - Switches the roles of the primary and replica pair. The
	// target instance should be the replica.
	//   "UPDATE_BACKUP" - Update a backup.
	//   "ACQUIRE_SSRS_LEASE" - Acquire a lease for the setup of SQL Server
	// Reporting Services (SSRS).
	//   "RELEASE_SSRS_LEASE" - Release a lease for the setup of SQL Server
	// Reporting Services (SSRS).
	//   "RECONFIGURE_OLD_PRIMARY" - Reconfigures old primary after a promote
	// replica operation. Effect of a promote operation to the old primary is
	// executed in this operation, asynchronously from the promote replica
	// operation executed to the replica.
	//   "CLUSTER_MAINTENANCE" - Indicates that the instance, its read replicas,
	// and its cascading replicas are in maintenance. Maintenance typically gets
	// initiated on groups of replicas first, followed by the primary instance. For
	// each instance, maintenance typically causes the instance to be unavailable
	// for 1-3 minutes.
	//   "SELF_SERVICE_MAINTENANCE" - Indicates that the instance (and any of its
	// replicas) are currently in maintenance. This is initiated as a self-service
	// request by using SSM. Maintenance typically causes the instance to be
	// unavailable for 1-3 minutes.
	//   "SWITCHOVER_TO_REPLICA" - Switches a primary instance to a replica. This
	// operation runs as part of a switchover operation to the original primary
	// instance.
	//   "MAJOR_VERSION_UPGRADE" - Updates the major version of a Cloud SQL
	// instance.
	//   "ADVANCED_BACKUP" - Deprecated: ADVANCED_BACKUP is deprecated. Use
	// ENHANCED_BACKUP instead.
	//   "MANAGE_BACKUP" - Changes the BackupTier of a Cloud SQL instance.
	//   "ENHANCED_BACKUP" - Creates a backup for an Enhanced BackupTier Cloud SQL
	// instance.
	//   "REPAIR_READ_POOL" - Repairs entire read pool or specified read pool nodes
	// in the read pool.
	//   "CREATE_READ_POOL" - Creates a Cloud SQL read pool instance.
	OperationType string `json:"operationType,omitempty"`
	// PreCheckMajorVersionUpgradeContext: The context for pre-check major version
	// upgrade operation, if applicable. This field is only populated when the
	// operation_type is PRE_CHECK_MAJOR_VERSION_UPGRADE. The
	// PreCheckMajorVersionUpgradeContext message itself contains the details for
	// that pre-check, such as the target database version for the upgrade and the
	// results of the check (including any warnings or errors found).
	PreCheckMajorVersionUpgradeContext *PreCheckMajorVersionUpgradeContext `json:"preCheckMajorVersionUpgradeContext,omitempty"`
	// SelfLink: The URI of this resource.
	SelfLink string `json:"selfLink,omitempty"`
	// StartTime: The time this operation actually started in UTC timezone in RFC
	// 3339 (https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	StartTime string `json:"startTime,omitempty"`
	// Status: The status of an operation.
	//
	// Possible values:
	//   "SQL_OPERATION_STATUS_UNSPECIFIED" - The state of the operation is
	// unknown.
	//   "PENDING" - The operation has been queued, but has not started yet.
	//   "RUNNING" - The operation is running.
	//   "DONE" - The operation completed.
	Status string `json:"status,omitempty"`
	// SubOperationType: Optional. The sub operation based on the operation type.
	SubOperationType *SqlSubOperationType `json:"subOperationType,omitempty"`
	// TargetId: Name of the resource on which this operation runs.
	TargetId   string `json:"targetId,omitempty"`
	TargetLink string `json:"targetLink,omitempty"`
	// TargetProject: The project ID of the target instance related to this
	// operation.
	TargetProject string `json:"targetProject,omitempty"`
	// User: The email address of the user who initiated this operation.
	User string `json:"user,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "AcquireSsrsLeaseContext") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AcquireSsrsLeaseContext") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Operation) MarshalJSON() ([]byte, error) {
	type NoMethod Operation
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationError: Database instance operation error.
type OperationError struct {
	// Code: Identifies the specific error that occurred.
	Code string `json:"code,omitempty"`
	// Kind: This is always `sql#operationError`.
	Kind string `json:"kind,omitempty"`
	// Message: Additional information about the error encountered.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationError) MarshalJSON() ([]byte, error) {
	type NoMethod OperationError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationErrors: Database instance operation errors list wrapper.
type OperationErrors struct {
	// Errors: The list of errors encountered while processing this operation.
	Errors []*OperationError `json:"errors,omitempty"`
	// Kind: This is always `sql#operationErrors`.
	Kind string `json:"kind,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationErrors) MarshalJSON() ([]byte, error) {
	type NoMethod OperationErrors
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationMetadata: Represents the metadata of the long-running operation.
type OperationMetadata struct {
	// ApiVersion: Output only. API version used to start the operation.
	ApiVersion string `json:"apiVersion,omitempty"`
	// CancelRequested: Output only. Identifies whether the user has requested
	// cancellation of the operation. Operations that have been cancelled
	// successfully have google.longrunning.Operation.error value with a
	// google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.
	CancelRequested bool `json:"cancelRequested,omitempty"`
	// CreateTime: Output only. The time the operation was created.
	CreateTime string `json:"createTime,omitempty"`
	// EndTime: Output only. The time the operation finished running.
	EndTime string `json:"endTime,omitempty"`
	// StatusDetail: Output only. Human-readable status of the operation, if any.
	StatusDetail string `json:"statusDetail,omitempty"`
	// Target: Output only. Server-defined resource path for the target of the
	// operation.
	Target string `json:"target,omitempty"`
	// Verb: Output only. Name of the verb executed by the operation.
	Verb string `json:"verb,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApiVersion") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApiVersion") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod OperationMetadata
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// OperationsListResponse: Operations list response.
type OperationsListResponse struct {
	// Items: List of operation resources.
	Items []*Operation `json:"items,omitempty"`
	// Kind: This is always `sql#operationsList`.
	Kind string `json:"kind,omitempty"`
	// NextPageToken: The continuation token, used to page through large result
	// sets. Provide this value in a subsequent request to return the next page of
	// results.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s OperationsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod OperationsListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PasswordStatus: Read-only password status.
type PasswordStatus struct {
	// Locked: If true, user does not have login privileges.
	Locked bool `json:"locked,omitempty"`
	// PasswordExpirationTime: The expiration time of the current password.
	PasswordExpirationTime string `json:"passwordExpirationTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Locked") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Locked") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PasswordStatus) MarshalJSON() ([]byte, error) {
	type NoMethod PasswordStatus
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PasswordValidationPolicy: Database instance local user password validation
// policy. This message defines the password policy for local database users.
// When enabled, it enforces constraints on password complexity, length, and
// reuse. Keep this policy enabled to help prevent unauthorized access.
type PasswordValidationPolicy struct {
	// Complexity: The complexity of the password.
	//
	// Possible values:
	//   "COMPLEXITY_UNSPECIFIED" - Complexity check is not specified.
	//   "COMPLEXITY_DEFAULT" - A combination of lowercase, uppercase, numeric, and
	// non-alphanumeric characters.
	Complexity string `json:"complexity,omitempty"`
	// DisallowCompromisedCredentials: This field is deprecated and will be removed
	// in a future version of the API.
	DisallowCompromisedCredentials bool `json:"disallowCompromisedCredentials,omitempty"`
	// DisallowUsernameSubstring: Disallow username as a part of the password.
	DisallowUsernameSubstring bool `json:"disallowUsernameSubstring,omitempty"`
	// EnablePasswordPolicy: Whether to enable the password policy or not. When
	// enabled, passwords must meet complexity requirements. Keep this policy
	// enabled to help prevent unauthorized access. Disabling this policy allows
	// weak passwords.
	EnablePasswordPolicy bool `json:"enablePasswordPolicy,omitempty"`
	// MinLength: Minimum number of characters allowed.
	MinLength int64 `json:"minLength,omitempty"`
	// PasswordChangeInterval: Minimum interval after which the password can be
	// changed. This flag is only supported for PostgreSQL.
	PasswordChangeInterval string `json:"passwordChangeInterval,omitempty"`
	// ReuseInterval: Number of previous passwords that cannot be reused.
	ReuseInterval int64 `json:"reuseInterval,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Complexity") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Complexity") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PasswordValidationPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod PasswordValidationPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PerformDiskShrinkContext: Perform disk shrink context.
type PerformDiskShrinkContext struct {
	// TargetSizeGb: The target disk shrink size in GigaBytes.
	TargetSizeGb int64 `json:"targetSizeGb,omitempty,string"`
	// ForceSendFields is a list of field names (e.g. "TargetSizeGb") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "TargetSizeGb") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PerformDiskShrinkContext) MarshalJSON() ([]byte, error) {
	type NoMethod PerformDiskShrinkContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PerformanceCaptureConfig: Performance Capture configuration.
type PerformanceCaptureConfig struct {
	// Enabled: Optional. Enable or disable the Performance Capture.
	Enabled bool `json:"enabled,omitempty"`
	// ProbeThreshold: Optional. The minimum number of consecutive readings above
	// threshold that triggers instance state capture.
	ProbeThreshold int64 `json:"probeThreshold,omitempty"`
	// ProbingIntervalSeconds: Optional. The time interval in seconds between any
	// two probes.
	ProbingIntervalSeconds int64 `json:"probingIntervalSeconds,omitempty"`
	// RunningThreadsThreshold: Optional. The minimum number of server threads
	// running to trigger the capture on primary.
	RunningThreadsThreshold int64 `json:"runningThreadsThreshold,omitempty"`
	// SecondsBehindSourceThreshold: Optional. The minimum number of seconds
	// replica must be lagging behind primary to trigger capture on replica.
	SecondsBehindSourceThreshold int64 `json:"secondsBehindSourceThreshold,omitempty"`
	// TransactionDurationThreshold: Optional. The amount of time in seconds that a
	// transaction needs to have been open before the watcher starts recording it.
	TransactionDurationThreshold int64 `json:"transactionDurationThreshold,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Enabled") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Enabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PerformanceCaptureConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PerformanceCaptureConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PointInTimeRestoreContext: Context to perform a point-in-time restore of an
// instance managed by Backup and Disaster Recovery (DR) Service.
type PointInTimeRestoreContext struct {
	// AllocatedIpRange: Optional. The name of the allocated IP range for the
	// internal IP Cloud SQL instance. For example:
	// "google-managed-services-default". If you set this, then Cloud SQL creates
	// the IP address for the cloned instance in the allocated range. This range
	// must comply with RFC 1035 (https://tools.ietf.org/html/rfc1035) standards.
	// Specifically, the name must be 1-63 characters long and match the regular
	// expression a-z ([-a-z0-9]*[a-z0-9])?. Reserved for future use.
	AllocatedIpRange string `json:"allocatedIpRange,omitempty"`
	// Datasource: The Backup and Disaster Recovery (DR) Service Datasource URI.
	// Format:
	// projects/{project}/locations/{region}/backupVaults/{backupvault}/dataSources/
	// {datasource}.
	Datasource string `json:"datasource,omitempty"`
	// PointInTime: Required. The date and time to which you want to restore the
	// instance.
	PointInTime string `json:"pointInTime,omitempty"`
	// PreferredSecondaryZone: Optional. Point-in-time recovery of a regional
	// instance in the specified zones. If not specified, clone to the same
	// secondary zone as the source instance. This value cannot be the same as the
	// preferred_zone field.
	PreferredSecondaryZone string `json:"preferredSecondaryZone,omitempty"`
	// PreferredZone: Optional. Point-in-time recovery of an instance to the
	// specified zone. If no zone is specified, then clone to the same primary zone
	// as the source instance.
	PreferredZone string `json:"preferredZone,omitempty"`
	// PrivateNetwork: Optional. The resource link for the VPC network from which
	// the Cloud SQL instance is accessible for private IP. For example,
	// `/projects/myProject/global/networks/default`.
	PrivateNetwork string `json:"privateNetwork,omitempty"`
	// TargetInstance: Target instance name.
	TargetInstance string `json:"targetInstance,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllocatedIpRange") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllocatedIpRange") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PointInTimeRestoreContext) MarshalJSON() ([]byte, error) {
	type NoMethod PointInTimeRestoreContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PoolNodeConfig: Details of a single read pool node of a read pool.
type PoolNodeConfig struct {
	// DnsName: Output only. The DNS name of the read pool node.
	DnsName string `json:"dnsName,omitempty"`
	// DnsNames: Output only. The list of DNS names used by this read pool node.
	DnsNames []*DnsNameMapping `json:"dnsNames,omitempty"`
	// GceZone: Output only. The zone of the read pool node.
	GceZone string `json:"gceZone,omitempty"`
	// IpAddresses: Output only. Mappings containing IP addresses that can be used
	// to connect to the read pool node.
	IpAddresses []*IpMapping `json:"ipAddresses,omitempty"`
	// Name: Output only. The name of the read pool node, to be used for retrieving
	// metrics and logs.
	Name string `json:"name,omitempty"`
	// PscAutoConnections: Output only. The list of settings for requested
	// automatically-setup Private Service Connect (PSC) consumer endpoints that
	// can be used to connect to this read pool node.
	PscAutoConnections []*PscAutoConnectionConfig `json:"pscAutoConnections,omitempty"`
	// PscServiceAttachmentLink: Output only. The Private Service Connect (PSC)
	// service attachment of the read pool node.
	PscServiceAttachmentLink string `json:"pscServiceAttachmentLink,omitempty"`
	// State: Output only. The current state of the read pool node.
	//
	// Possible values:
	//   "SQL_INSTANCE_STATE_UNSPECIFIED" - The state of the instance is unknown.
	//   "RUNNABLE" - The instance is running, or has been stopped by owner.
	//   "SUSPENDED" - The instance is not available, for example due to problems
	// with billing.
	//   "PENDING_DELETE" - The instance is being deleted.
	//   "PENDING_CREATE" - The instance is being created.
	//   "MAINTENANCE" - The instance is down for maintenance.
	//   "FAILED" - The creation of the instance failed or a fatal error occurred
	// during maintenance.
	//   "ONLINE_MAINTENANCE" - Deprecated
	//   "REPAIRING" - (Applicable to read pool nodes only.) The read pool node
	// needs to be repaired. The database might be unavailable.
	State string `json:"state,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DnsName") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DnsName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PoolNodeConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PoolNodeConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PreCheckMajorVersionUpgradeContext: Pre-check major version upgrade context.
type PreCheckMajorVersionUpgradeContext struct {
	// Kind: Optional. This is always `sql#preCheckMajorVersionUpgradeContext`.
	Kind string `json:"kind,omitempty"`
	// PreCheckResponse: Output only. The responses from the precheck operation.
	PreCheckResponse []*PreCheckResponse `json:"preCheckResponse,omitempty"`
	// TargetDatabaseVersion: Required. The target database version to upgrade to.
	//
	// Possible values:
	//   "SQL_DATABASE_VERSION_UNSPECIFIED" - This is an unknown database version.
	//   "MYSQL_5_1" - The database version is MySQL 5.1.
	//   "MYSQL_5_5" - The database version is MySQL 5.5.
	//   "MYSQL_5_6" - The database version is MySQL 5.6.
	//   "MYSQL_5_7" - The database version is MySQL 5.7.
	//   "MYSQL_8_0" - The database version is MySQL 8.
	//   "MYSQL_8_0_18" - The database major version is MySQL 8.0 and the minor
	// version is 18.
	//   "MYSQL_8_0_26" - The database major version is MySQL 8.0 and the minor
	// version is 26.
	//   "MYSQL_8_0_27" - The database major version is MySQL 8.0 and the minor
	// version is 27.
	//   "MYSQL_8_0_28" - The database major version is MySQL 8.0 and the minor
	// version is 28.
	//   "MYSQL_8_0_29" - The database major version is MySQL 8.0 and the minor
	// version is 29.
	//   "MYSQL_8_0_30" - The database major version is MySQL 8.0 and the minor
	// version is 30.
	//   "MYSQL_8_0_31" - The database major version is MySQL 8.0 and the minor
	// version is 31.
	//   "MYSQL_8_0_32" - The database major version is MySQL 8.0 and the minor
	// version is 32.
	//   "MYSQL_8_0_33" - The database major version is MySQL 8.0 and the minor
	// version is 33.
	//   "MYSQL_8_0_34" - The database major version is MySQL 8.0 and the minor
	// version is 34.
	//   "MYSQL_8_0_35" - The database major version is MySQL 8.0 and the minor
	// version is 35.
	//   "MYSQL_8_0_36" - The database major version is MySQL 8.0 and the minor
	// version is 36.
	//   "MYSQL_8_0_37" - The database major version is MySQL 8.0 and the minor
	// version is 37.
	//   "MYSQL_8_0_39" - The database major version is MySQL 8.0 and the minor
	// version is 39.
	//   "MYSQL_8_0_40" - The database major version is MySQL 8.0 and the minor
	// version is 40.
	//   "MYSQL_8_0_41" - The database major version is MySQL 8.0 and the minor
	// version is 41.
	//   "MYSQL_8_0_42" - The database major version is MySQL 8.0 and the minor
	// version is 42.
	//   "MYSQL_8_0_43" - The database major version is MySQL 8.0 and the minor
	// version is 43.
	//   "MYSQL_8_0_44" - The database major version is MySQL 8.0 and the minor
	// version is 44.
	//   "MYSQL_8_0_45" - The database major version is MySQL 8.0 and the minor
	// version is 45.
	//   "MYSQL_8_0_46" - The database major version is MySQL 8.0 and the minor
	// version is 46.
	//   "MYSQL_8_4" - The database version is MySQL 8.4.
	//   "SQLSERVER_2017_STANDARD" - The database version is SQL Server 2017
	// Standard.
	//   "SQLSERVER_2017_ENTERPRISE" - The database version is SQL Server 2017
	// Enterprise.
	//   "SQLSERVER_2017_EXPRESS" - The database version is SQL Server 2017
	// Express.
	//   "SQLSERVER_2017_WEB" - The database version is SQL Server 2017 Web.
	//   "POSTGRES_9_6" - The database version is PostgreSQL 9.6.
	//   "POSTGRES_10" - The database version is PostgreSQL 10.
	//   "POSTGRES_11" - The database version is PostgreSQL 11.
	//   "POSTGRES_12" - The database version is PostgreSQL 12.
	//   "POSTGRES_13" - The database version is PostgreSQL 13.
	//   "POSTGRES_14" - The database version is PostgreSQL 14.
	//   "POSTGRES_15" - The database version is PostgreSQL 15.
	//   "POSTGRES_16" - The database version is PostgreSQL 16.
	//   "POSTGRES_17" - The database version is PostgreSQL 17.
	//   "POSTGRES_18" - The database version is PostgreSQL 18.
	//   "SQLSERVER_2019_STANDARD" - The database version is SQL Server 2019
	// Standard.
	//   "SQLSERVER_2019_ENTERPRISE" - The database version is SQL Server 2019
	// Enterprise.
	//   "SQLSERVER_2019_EXPRESS" - The database version is SQL Server 2019
	// Express.
	//   "SQLSERVER_2019_WEB" - The database version is SQL Server 2019 Web.
	//   "SQLSERVER_2022_STANDARD" - The database version is SQL Server 2022
	// Standard.
	//   "SQLSERVER_2022_ENTERPRISE" - The database version is SQL Server 2022
	// Enterprise.
	//   "SQLSERVER_2022_EXPRESS" - The database version is SQL Server 2022
	// Express.
	//   "SQLSERVER_2022_WEB" - The database version is SQL Server 2022 Web.
	TargetDatabaseVersion string `json:"targetDatabaseVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PreCheckMajorVersionUpgradeContext) MarshalJSON() ([]byte, error) {
	type NoMethod PreCheckMajorVersionUpgradeContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PreCheckResponse: Structured PreCheckResponse containing message, type, and
// required actions.
type PreCheckResponse struct {
	// ActionsRequired: The actions that the user needs to take. Use repeated for
	// multiple actions.
	ActionsRequired []string `json:"actionsRequired,omitempty"`
	// Message: The message to be displayed to the user.
	Message string `json:"message,omitempty"`
	// MessageType: The type of message whether it is an info, warning, or error.
	//
	// Possible values:
	//   "MESSAGE_TYPE_UNSPECIFIED" - Default unspecified value to prevent
	// unintended behavior changes.
	//   "INFO" - General informational messages that don't require action.
	//   "WARNING" - Warnings that might impact the upgrade but don't block it.
	//   "ERROR" - Errors that a user must resolve before proceeding with the
	// upgrade.
	MessageType string `json:"messageType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActionsRequired") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActionsRequired") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PreCheckResponse) MarshalJSON() ([]byte, error) {
	type NoMethod PreCheckResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PscAutoConnectionConfig: Settings for an automatically-setup Private Service
// Connect consumer endpoint that is used to connect to a Cloud SQL instance.
type PscAutoConnectionConfig struct {
	// ConsumerNetwork: Optional. The consumer network of this consumer endpoint.
	// This must be a resource path that includes both the host project and the
	// network name. For example, `projects/project1/global/networks/network1`. The
	// consumer host project of this network might be different from the consumer
	// service project.
	ConsumerNetwork string `json:"consumerNetwork,omitempty"`
	// ConsumerNetworkStatus: The connection policy status of the consumer network.
	ConsumerNetworkStatus string `json:"consumerNetworkStatus,omitempty"`
	// ConsumerProject: Optional. This is the project ID of consumer service
	// project of this consumer endpoint. Optional. This is only applicable if
	// consumer_network is a shared vpc network.
	ConsumerProject string `json:"consumerProject,omitempty"`
	// IpAddress: The IP address of the consumer endpoint.
	IpAddress string `json:"ipAddress,omitempty"`
	// Status: The connection status of the consumer endpoint.
	Status string `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ConsumerNetwork") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ConsumerNetwork") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PscAutoConnectionConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PscAutoConnectionConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// PscConfig: PSC settings for a Cloud SQL instance.
type PscConfig struct {
	// AllowedConsumerProjects: Optional. The list of consumer projects that are
	// allow-listed for PSC connections to this instance. This instance can be
	// connected to with PSC from any network in these projects. Each consumer
	// project in this list may be represented by a project number (numeric) or by
	// a project id (alphanumeric).
	AllowedConsumerProjects []string `json:"allowedConsumerProjects,omitempty"`
	// NetworkAttachmentUri: Optional. The network attachment of the consumer
	// network that the Private Service Connect enabled Cloud SQL instance is
	// authorized to connect via PSC interface. format:
	// projects/PROJECT/regions/REGION/networkAttachments/ID
	NetworkAttachmentUri string `json:"networkAttachmentUri,omitempty"`
	// PscAutoConnections: Optional. The list of settings for requested Private
	// Service Connect consumer endpoints that can be used to connect to this Cloud
	// SQL instance.
	PscAutoConnections []*PscAutoConnectionConfig `json:"pscAutoConnections,omitempty"`
	// PscEnabled: Whether PSC connectivity is enabled for this instance.
	PscEnabled bool `json:"pscEnabled,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedConsumerProjects") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedConsumerProjects") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s PscConfig) MarshalJSON() ([]byte, error) {
	type NoMethod PscConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// QueryResult: QueryResult contains the result of executing a single SQL
// statement.
type QueryResult struct {
	// Columns: List of columns included in the result. This also includes the data
	// type of the column.
	Columns []*Column `json:"columns,omitempty"`
	// Message: Message related to the SQL execution result.
	Message string `json:"message,omitempty"`
	// PartialResult: Set to true if the SQL execution's result is truncated due to
	// size limits or an error retrieving results.
	PartialResult bool `json:"partialResult,omitempty"`
	// Rows: Rows returned by the SQL statement.
	Rows []*Row `json:"rows,omitempty"`
	// Status: If results were truncated due to an error, details of that error.
	Status *Status `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Columns") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Columns") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s QueryResult) MarshalJSON() ([]byte, error) {
	type NoMethod QueryResult
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReadPoolAutoScaleConfig: The read pool auto-scale configuration.
type ReadPoolAutoScaleConfig struct {
	// DisableScaleIn: Indicates whether read pool auto scaling supports scale in
	// operations (removing nodes).
	DisableScaleIn bool `json:"disableScaleIn,omitempty"`
	// Enabled: Indicates whether read pool auto scaling is enabled.
	Enabled bool `json:"enabled,omitempty"`
	// MaxNodeCount: Maximum number of read pool nodes to be maintained.
	MaxNodeCount int64 `json:"maxNodeCount,omitempty"`
	// MinNodeCount: Minimum number of read pool nodes to be maintained.
	MinNodeCount int64 `json:"minNodeCount,omitempty"`
	// ScaleInCooldownSeconds: The cooldown period for scale in operations.
	ScaleInCooldownSeconds int64 `json:"scaleInCooldownSeconds,omitempty"`
	// ScaleOutCooldownSeconds: The cooldown period for scale out operations.
	ScaleOutCooldownSeconds int64 `json:"scaleOutCooldownSeconds,omitempty"`
	// TargetMetrics: Optional. Target metrics for read pool auto scaling.
	TargetMetrics []*TargetMetric `json:"targetMetrics,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DisableScaleIn") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DisableScaleIn") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReadPoolAutoScaleConfig) MarshalJSON() ([]byte, error) {
	type NoMethod ReadPoolAutoScaleConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReplicaConfiguration: Read-replica configuration for connecting to the
// primary instance.
type ReplicaConfiguration struct {
	// CascadableReplica: Optional. Specifies if a SQL Server replica is a
	// cascadable replica. A cascadable replica is a SQL Server cross region
	// replica that supports replica(s) under it.
	CascadableReplica bool `json:"cascadableReplica,omitempty"`
	// FailoverTarget: Specifies if the replica is the failover target. If the
	// field is set to `true` the replica will be designated as a failover replica.
	// In case the primary instance fails, the replica instance will be promoted as
	// the new primary instance. Only one replica can be specified as failover
	// target, and the replica has to be in different zone with the primary
	// instance.
	FailoverTarget bool `json:"failoverTarget,omitempty"`
	// Kind: This is always `sql#replicaConfiguration`.
	Kind string `json:"kind,omitempty"`
	// MysqlReplicaConfiguration: MySQL specific configuration when replicating
	// from a MySQL on-premises primary instance. Replication configuration
	// information such as the username, password, certificates, and keys are not
	// stored in the instance metadata. The configuration information is used only
	// to set up the replication connection and is stored by MySQL in a file named
	// `master.info` in the data directory.
	MysqlReplicaConfiguration *MySqlReplicaConfiguration `json:"mysqlReplicaConfiguration,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CascadableReplica") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CascadableReplica") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReplicaConfiguration) MarshalJSON() ([]byte, error) {
	type NoMethod ReplicaConfiguration
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// ReplicationCluster: A primary instance and disaster recovery (DR) replica
// pair. A DR replica is a cross-region replica that you designate for failover
// in the event that the primary instance has regional failure. Applicable to
// MySQL and PostgreSQL.
type ReplicationCluster struct {
	// DrReplica: Output only. Read-only field that indicates whether the replica
	// is a DR replica. This field is not set if the instance is a primary
	// instance.
	DrReplica bool `json:"drReplica,omitempty"`
	// FailoverDrReplicaName: Optional. If the instance is a primary instance, then
	// this field identifies the disaster recovery (DR) replica. A DR replica is an
	// optional configuration for Enterprise Plus edition instances. If the
	// instance is a read replica, then the field is not set. Set this field to a
	// replica name to designate a DR replica for a primary instance. Remove the
	// replica name to remove the DR replica designation.
	FailoverDrReplicaName string `json:"failoverDrReplicaName,omitempty"`
	// PsaWriteEndpoint: Output only. If set, this field indicates this instance
	// has a private service access (PSA) DNS endpoint that is pointing to the
	// primary instance of the cluster. If this instance is the primary, then the
	// DNS endpoint points to this instance. After a switchover or replica failover
	// operation, this DNS endpoint points to the promoted instance. This is a
	// read-only field, returned to the user as information. This field can exist
	// even if a standalone instance doesn't have a DR replica yet or the DR
	// replica is deleted.
	PsaWriteEndpoint string `json:"psaWriteEndpoint,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DrReplica") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DrReplica") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s ReplicationCluster) MarshalJSON() ([]byte, error) {
	type NoMethod ReplicationCluster
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type Reschedule struct {
	// RescheduleType: Required. The type of the reschedule.
	//
	// Possible values:
	//   "RESCHEDULE_TYPE_UNSPECIFIED"
	//   "IMMEDIATE" - Reschedules maintenance to happen now (within 5 minutes).
	//   "NEXT_AVAILABLE_WINDOW" - Reschedules maintenance to occur within one week
	// from the originally scheduled day and time.
	//   "SPECIFIC_TIME" - Reschedules maintenance to a specific time and day.
	RescheduleType string `json:"rescheduleType,omitempty"`
	// ScheduleTime: Optional. Timestamp when the maintenance shall be rescheduled
	// to if reschedule_type=SPECIFIC_TIME, in RFC 3339
	// (https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	ScheduleTime string `json:"scheduleTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "RescheduleType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "RescheduleType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Reschedule) MarshalJSON() ([]byte, error) {
	type NoMethod Reschedule
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RestoreBackupContext: Database instance restore from backup context. Backup
// context contains source instance id and project id.
type RestoreBackupContext struct {
	// BackupRunId: The ID of the backup run to restore from.
	BackupRunId int64 `json:"backupRunId,omitempty,string"`
	// InstanceId: The ID of the instance that the backup was taken from.
	InstanceId string `json:"instanceId,omitempty"`
	// Kind: This is always `sql#restoreBackupContext`.
	Kind string `json:"kind,omitempty"`
	// Project: The full project ID of the source instance.
	Project string `json:"project,omitempty"`
	// ForceSendFields is a list of field names (e.g. "BackupRunId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "BackupRunId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RestoreBackupContext) MarshalJSON() ([]byte, error) {
	type NoMethod RestoreBackupContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RotateEntraIdCertificateContext: Instance rotate Entra ID certificate
// context.
type RotateEntraIdCertificateContext struct {
	// Kind: Optional. This is always `sql#rotateEntraIdCertificateContext`.
	Kind string `json:"kind,omitempty"`
	// NextVersion: Optional. The fingerprint of the next version to be rotated to.
	// If left unspecified, will be rotated to the most recently added Entra ID
	// certificate version.
	NextVersion string `json:"nextVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RotateEntraIdCertificateContext) MarshalJSON() ([]byte, error) {
	type NoMethod RotateEntraIdCertificateContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RotateServerCaContext: Instance rotate server CA context.
type RotateServerCaContext struct {
	// Kind: This is always `sql#rotateServerCaContext`.
	Kind string `json:"kind,omitempty"`
	// NextVersion: The fingerprint of the next version to be rotated to. If left
	// unspecified, will be rotated to the most recently added server CA version.
	NextVersion string `json:"nextVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RotateServerCaContext) MarshalJSON() ([]byte, error) {
	type NoMethod RotateServerCaContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// RotateServerCertificateContext: Instance rotate server certificate context.
type RotateServerCertificateContext struct {
	// Kind: Optional. This is always `sql#rotateServerCertificateContext`.
	Kind string `json:"kind,omitempty"`
	// NextVersion: Optional. The fingerprint of the next version to be rotated to.
	// If left unspecified, will be rotated to the most recently added server
	// certificate version.
	NextVersion string `json:"nextVersion,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s RotateServerCertificateContext) MarshalJSON() ([]byte, error) {
	type NoMethod RotateServerCertificateContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Row: Contains the values for a row.
type Row struct {
	// Values: The values for the row.
	Values []*Value `json:"values,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Values") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Values") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Row) MarshalJSON() ([]byte, error) {
	type NoMethod Row
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SelectedObjects: A list of objects that the user selects for replication
// from an external source instance.
type SelectedObjects struct {
	// Database: Required. The name of the database to migrate.
	Database string `json:"database,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Database") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Database") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SelectedObjects) MarshalJSON() ([]byte, error) {
	type NoMethod SelectedObjects
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Settings: Database instance settings.
type Settings struct {
	// ActivationPolicy: The activation policy specifies when the instance is
	// activated; it is applicable only when the instance state is RUNNABLE. Valid
	// values: * `ALWAYS`: The instance is on, and remains so even in the absence
	// of connection requests. * `NEVER`: The instance is off; it is not activated,
	// even if a connection request arrives.
	//
	// Possible values:
	//   "SQL_ACTIVATION_POLICY_UNSPECIFIED" - Unknown activation plan.
	//   "ALWAYS" - The instance is always up and running.
	//   "NEVER" - The instance never starts.
	//   "ON_DEMAND" - The instance starts upon receiving requests.
	ActivationPolicy string `json:"activationPolicy,omitempty"`
	// ActiveDirectoryConfig: Active Directory configuration, relevant only for
	// Cloud SQL for SQL Server.
	ActiveDirectoryConfig *SqlActiveDirectoryConfig `json:"activeDirectoryConfig,omitempty"`
	// AdvancedMachineFeatures: Specifies advanced machine configuration for the
	// instances relevant only for SQL Server.
	AdvancedMachineFeatures *AdvancedMachineFeatures `json:"advancedMachineFeatures,omitempty"`
	// AuthorizedGaeApplications: The App Engine app IDs that can access this
	// instance. (Deprecated) Applied to First Generation instances only.
	AuthorizedGaeApplications []string `json:"authorizedGaeApplications,omitempty"`
	// AutoUpgradeEnabled: Optional. Cloud SQL for MySQL auto-upgrade
	// configuration. When this parameter is set to true, auto-upgrade is enabled
	// for MySQL 8.0 minor versions. The MySQL version must be 8.0.35 or higher.
	AutoUpgradeEnabled bool `json:"autoUpgradeEnabled,omitempty"`
	// AvailabilityType: Availability type. Potential values: * `ZONAL`: The
	// instance serves data from only one zone. Outages in that zone affect data
	// accessibility. * `REGIONAL`: The instance can serve data from more than one
	// zone in a region (it is highly available)./ For more information, see
	// Overview of the High Availability Configuration
	// (https://cloud.google.com/sql/docs/mysql/high-availability).
	//
	// Possible values:
	//   "SQL_AVAILABILITY_TYPE_UNSPECIFIED" - This is an unknown Availability
	// type.
	//   "ZONAL" - Zonal available instance.
	//   "REGIONAL" - Regional available instance.
	AvailabilityType string `json:"availabilityType,omitempty"`
	// BackupConfiguration: The daily backup configuration for the instance.
	BackupConfiguration *BackupConfiguration `json:"backupConfiguration,omitempty"`
	// Collation: The name of server Instance collation.
	Collation string `json:"collation,omitempty"`
	// ConnectionPoolConfig: Optional. The managed connection pooling configuration
	// for the instance.
	ConnectionPoolConfig *ConnectionPoolConfig `json:"connectionPoolConfig,omitempty"`
	// ConnectorEnforcement: Specifies if connections must use Cloud SQL
	// connectors. Option values include the following: `NOT_REQUIRED` (Cloud SQL
	// instances can be connected without Cloud SQL Connectors) and `REQUIRED`
	// (Only allow connections that use Cloud SQL Connectors) Note that using
	// REQUIRED disables all existing authorized networks. If this field is not
	// specified when creating a new instance, NOT_REQUIRED is used. If this field
	// is not specified when patching or updating an existing instance, it is left
	// unchanged in the instance.
	//
	// Possible values:
	//   "CONNECTOR_ENFORCEMENT_UNSPECIFIED" - The requirement for Cloud SQL
	// connectors is unknown.
	//   "NOT_REQUIRED" - Do not require Cloud SQL connectors.
	//   "REQUIRED" - Require all connections to use Cloud SQL connectors,
	// including the Cloud SQL Auth Proxy and Cloud SQL Java, Python, and Go
	// connectors. Note: This disables all existing authorized networks.
	ConnectorEnforcement string `json:"connectorEnforcement,omitempty"`
	// CrashSafeReplicationEnabled: Configuration specific to read replica
	// instances. Indicates whether database flags for crash-safe replication are
	// enabled. This property was only applicable to First Generation instances.
	CrashSafeReplicationEnabled bool `json:"crashSafeReplicationEnabled,omitempty"`
	// DataApiAccess: This parameter controls whether to allow using ExecuteSql API
	// to connect to the instance. Not allowed by default.
	//
	// Possible values:
	//   "DATA_API_ACCESS_UNSPECIFIED" - Unspecified, effectively the same as
	// `DISALLOW_DATA_API`.
	//   "DISALLOW_DATA_API" - Disallow using ExecuteSql API to connect to the
	// instance.
	//   "ALLOW_DATA_API" - Allow using ExecuteSql API to connect to the instance.
	// For private IP instances, this allows authorized users to access the
	// instance from the public internet using ExecuteSql API.
	DataApiAccess string `json:"dataApiAccess,omitempty"`
	// DataCacheConfig: Configuration for data cache.
	DataCacheConfig *DataCacheConfig `json:"dataCacheConfig,omitempty"`
	// DataDiskProvisionedIops: Optional. Provisioned number of I/O operations per
	// second for the data disk. This field is only used for hyperdisk-balanced
	// disk types.
	DataDiskProvisionedIops int64 `json:"dataDiskProvisionedIops,omitempty,string"`
	// DataDiskProvisionedThroughput: Optional. Provisioned throughput measured in
	// MiB per second for the data disk. This field is only used for
	// hyperdisk-balanced disk types.
	DataDiskProvisionedThroughput int64 `json:"dataDiskProvisionedThroughput,omitempty,string"`
	// DataDiskSizeGb: The size of data disk, in GB. The data disk size minimum is
	// 10GB.
	DataDiskSizeGb int64 `json:"dataDiskSizeGb,omitempty,string"`
	// DataDiskType: The type of data disk: `PD_SSD` (default) or `PD_HDD`. Not
	// used for First Generation instances.
	//
	// Possible values:
	//   "SQL_DATA_DISK_TYPE_UNSPECIFIED" - This is an unknown data disk type.
	//   "PD_SSD" - An SSD data disk.
	//   "PD_HDD" - An HDD data disk.
	//   "OBSOLETE_LOCAL_SSD" - This field is deprecated and will be removed from a
	// future version of the API.
	//   "HYPERDISK_BALANCED" - A Hyperdisk Balanced data disk.
	DataDiskType string `json:"dataDiskType,omitempty"`
	// DatabaseFlags: The database flags passed to the instance at startup.
	DatabaseFlags []*DatabaseFlags `json:"databaseFlags,omitempty"`
	// DatabaseReplicationEnabled: Configuration specific to read replica
	// instances. Indicates whether replication is enabled or not. WARNING:
	// Changing this restarts the instance.
	DatabaseReplicationEnabled bool `json:"databaseReplicationEnabled,omitempty"`
	// DeletionProtectionEnabled: Configuration to protect against accidental
	// instance deletion.
	DeletionProtectionEnabled bool `json:"deletionProtectionEnabled,omitempty"`
	// DenyMaintenancePeriods: Deny maintenance periods
	DenyMaintenancePeriods []*DenyMaintenancePeriod `json:"denyMaintenancePeriods,omitempty"`
	// Edition: Optional. The edition of the instance.
	//
	// Possible values:
	//   "EDITION_UNSPECIFIED" - The instance did not specify the edition.
	//   "ENTERPRISE" - The instance is an enterprise edition.
	//   "ENTERPRISE_PLUS" - The instance is an Enterprise Plus edition.
	Edition string `json:"edition,omitempty"`
	// EnableDataplexIntegration: Optional. By default, Cloud SQL instances have
	// schema extraction disabled for Dataplex. When this parameter is set to true,
	// schema extraction for Dataplex on Cloud SQL instances is activated.
	EnableDataplexIntegration bool `json:"enableDataplexIntegration,omitempty"`
	// EnableGoogleMlIntegration: Optional. When this parameter is set to true,
	// Cloud SQL instances can connect to Vertex AI to pass requests for real-time
	// predictions and insights to the AI. The default value is false. This applies
	// only to Cloud SQL for MySQL and Cloud SQL for PostgreSQL instances.
	EnableGoogleMlIntegration bool `json:"enableGoogleMlIntegration,omitempty"`
	// EntraidConfig: Optional. The Microsoft Entra ID configuration for the SQL
	// Server instance.
	EntraidConfig *SqlServerEntraIdConfig `json:"entraidConfig,omitempty"`
	// FinalBackupConfig: Optional. The final backup configuration for the
	// instance.
	FinalBackupConfig *FinalBackupConfig `json:"finalBackupConfig,omitempty"`
	// InsightsConfig: Insights configuration, for now relevant only for Postgres.
	InsightsConfig *InsightsConfig `json:"insightsConfig,omitempty"`
	// IpConfiguration: The settings for IP Management. This allows to enable or
	// disable the instance IP and manage which external networks can connect to
	// the instance. The IPv4 address cannot be disabled for Second Generation
	// instances.
	IpConfiguration *IpConfiguration `json:"ipConfiguration,omitempty"`
	// Kind: This is always `sql#settings`.
	Kind string `json:"kind,omitempty"`
	// LocationPreference: The location preference settings. This allows the
	// instance to be located as near as possible to either an App Engine app or
	// Compute Engine zone for better performance. App Engine co-location was only
	// applicable to First Generation instances.
	LocationPreference *LocationPreference `json:"locationPreference,omitempty"`
	// MaintenanceWindow: The maintenance window for this instance. This specifies
	// when the instance can be restarted for maintenance purposes.
	MaintenanceWindow *MaintenanceWindow `json:"maintenanceWindow,omitempty"`
	// PasswordValidationPolicy: The local user password validation policy of the
	// instance.
	PasswordValidationPolicy *PasswordValidationPolicy `json:"passwordValidationPolicy,omitempty"`
	// PerformanceCaptureConfig: Optional. Configuration for Performance Capture,
	// provides diagnostic metrics during high load situations.
	PerformanceCaptureConfig *PerformanceCaptureConfig `json:"performanceCaptureConfig,omitempty"`
	// PricingPlan: The pricing plan for this instance. This can be either
	// `PER_USE` or `PACKAGE`. Only `PER_USE` is supported for Second Generation
	// instances.
	//
	// Possible values:
	//   "SQL_PRICING_PLAN_UNSPECIFIED" - This is an unknown pricing plan for this
	// instance.
	//   "PACKAGE" - The instance is billed at a monthly flat rate.
	//   "PER_USE" - The instance is billed per usage.
	PricingPlan string `json:"pricingPlan,omitempty"`
	// ReadPoolAutoScaleConfig: Optional. The read pool auto-scale configuration
	// for the instance.
	ReadPoolAutoScaleConfig *ReadPoolAutoScaleConfig `json:"readPoolAutoScaleConfig,omitempty"`
	// ReplicationLagMaxSeconds: Optional. Configuration value for recreation of
	// replica after certain replication lag.
	ReplicationLagMaxSeconds int64 `json:"replicationLagMaxSeconds,omitempty"`
	// ReplicationType: The type of replication this instance uses. This can be
	// either `ASYNCHRONOUS` or `SYNCHRONOUS`. (Deprecated) This property was only
	// applicable to First Generation instances.
	//
	// Possible values:
	//   "SQL_REPLICATION_TYPE_UNSPECIFIED" - This is an unknown replication type
	// for a Cloud SQL instance.
	//   "SYNCHRONOUS" - The synchronous replication mode for First Generation
	// instances. It is the default value.
	//   "ASYNCHRONOUS" - The asynchronous replication mode for First Generation
	// instances. It provides a slight performance gain, but if an outage occurs
	// while this option is set to asynchronous, you can lose up to a few seconds
	// of updates to your data.
	ReplicationType string `json:"replicationType,omitempty"`
	// RetainBackupsOnDelete: Optional. When this parameter is set to true, Cloud
	// SQL retains backups of the instance even after the instance is deleted. The
	// ON_DEMAND backup will be retained until customer deletes the backup or the
	// project. The AUTOMATED backup will be retained based on the backups
	// retention setting.
	RetainBackupsOnDelete bool `json:"retainBackupsOnDelete,omitempty"`
	// SettingsVersion: The version of instance settings. This is a required field
	// for update method to make sure concurrent updates are handled properly.
	// During update, use the most recent settingsVersion value for this instance
	// and do not try to update this value.
	SettingsVersion int64 `json:"settingsVersion,omitempty,string"`
	// SqlServerAuditConfig: SQL Server specific audit configuration.
	SqlServerAuditConfig *SqlServerAuditConfig `json:"sqlServerAuditConfig,omitempty"`
	// StorageAutoResize: Configuration to increase storage size automatically. The
	// default value is true.
	StorageAutoResize *bool `json:"storageAutoResize,omitempty"`
	// StorageAutoResizeLimit: The maximum size to which storage capacity can be
	// automatically increased. The default value is 0, which specifies that there
	// is no limit.
	StorageAutoResizeLimit int64 `json:"storageAutoResizeLimit,omitempty,string"`
	// Tier: The tier (or machine type) for this instance, for example
	// `db-custom-1-3840`. WARNING: Changing this restarts the instance.
	Tier string `json:"tier,omitempty"`
	// TimeZone: Server timezone, relevant only for Cloud SQL for SQL Server.
	TimeZone string `json:"timeZone,omitempty"`
	// UserLabels: User-provided labels, represented as a dictionary where each
	// label is a single key value pair.
	UserLabels map[string]string `json:"userLabels,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ActivationPolicy") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ActivationPolicy") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Settings) MarshalJSON() ([]byte, error) {
	type NoMethod Settings
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlActiveDirectoryConfig: Active Directory configuration, relevant only for
// Cloud SQL for SQL Server.
type SqlActiveDirectoryConfig struct {
	// AdminCredentialSecretName: Optional. The secret manager key storing the
	// administrator credential. (e.g., projects/{project}/secrets/{secret}).
	AdminCredentialSecretName string `json:"adminCredentialSecretName,omitempty"`
	// DnsServers: Optional. Domain controller IPv4 addresses used to bootstrap
	// Active Directory.
	DnsServers []string `json:"dnsServers,omitempty"`
	// Domain: The name of the domain (e.g., mydomain.com).
	Domain string `json:"domain,omitempty"`
	// Kind: This is always sql#activeDirectoryConfig.
	Kind string `json:"kind,omitempty"`
	// Mode: Optional. The mode of the Active Directory configuration.
	//
	// Possible values:
	//   "ACTIVE_DIRECTORY_MODE_UNSPECIFIED" - Unspecified mode.
	//   "MANAGED_ACTIVE_DIRECTORY" - Managed Active Directory mode. This is the
	// fallback option to maintain backward compatibility.
	//   "SELF_MANAGED_ACTIVE_DIRECTORY" - Deprecated: Use
	// CUSTOMER_MANAGED_ACTIVE_DIRECTORY instead.
	//   "CUSTOMER_MANAGED_ACTIVE_DIRECTORY" - Customer-managed Active Directory
	// mode.
	Mode string `json:"mode,omitempty"`
	// OrganizationalUnit: Optional. The organizational unit distinguished name.
	// This is the full hierarchical path to the organizational unit.
	OrganizationalUnit string `json:"organizationalUnit,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AdminCredentialSecretName")
	// to unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AdminCredentialSecretName") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlActiveDirectoryConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SqlActiveDirectoryConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlExternalSyncSettingError: External primary instance migration setting
// error/warning.
type SqlExternalSyncSettingError struct {
	// Detail: Additional information about the error encountered.
	Detail string `json:"detail,omitempty"`
	// Kind: Can be `sql#externalSyncSettingError` or
	// `sql#externalSyncSettingWarning`.
	Kind string `json:"kind,omitempty"`
	// Type: Identifies the specific error that occurred.
	//
	// Possible values:
	//   "SQL_EXTERNAL_SYNC_SETTING_ERROR_TYPE_UNSPECIFIED"
	//   "CONNECTION_FAILURE"
	//   "BINLOG_NOT_ENABLED"
	//   "INCOMPATIBLE_DATABASE_VERSION"
	//   "REPLICA_ALREADY_SETUP"
	//   "INSUFFICIENT_PRIVILEGE" - The replication user is missing privileges that
	// are required.
	//   "UNSUPPORTED_MIGRATION_TYPE" - Unsupported migration type.
	//   "NO_PGLOGICAL_INSTALLED" - No pglogical extension installed on databases,
	// applicable for postgres.
	//   "PGLOGICAL_NODE_ALREADY_EXISTS" - pglogical node already exists on
	// databases, applicable for postgres.
	//   "INVALID_WAL_LEVEL" - The value of parameter wal_level is not set to
	// logical.
	//   "INVALID_SHARED_PRELOAD_LIBRARY" - The value of parameter
	// shared_preload_libraries does not include pglogical.
	//   "INSUFFICIENT_MAX_REPLICATION_SLOTS" - The value of parameter
	// max_replication_slots is not sufficient.
	//   "INSUFFICIENT_MAX_WAL_SENDERS" - The value of parameter max_wal_senders is
	// not sufficient.
	//   "INSUFFICIENT_MAX_WORKER_PROCESSES" - The value of parameter
	// max_worker_processes is not sufficient.
	//   "UNSUPPORTED_EXTENSIONS" - Extensions installed are either not supported
	// or having unsupported versions
	//   "INVALID_RDS_LOGICAL_REPLICATION" - The value of parameter
	// rds.logical_replication is not set to 1.
	//   "INVALID_LOGGING_SETUP" - The primary instance logging setup doesn't allow
	// EM sync.
	//   "INVALID_DB_PARAM" - The primary instance database parameter setup doesn't
	// allow EM sync.
	//   "UNSUPPORTED_GTID_MODE" - The gtid_mode is not supported, applicable for
	// MySQL.
	//   "SQLSERVER_AGENT_NOT_RUNNING" - SQL Server Agent is not running.
	//   "UNSUPPORTED_TABLE_DEFINITION" - The table definition is not support due
	// to missing primary key or replica identity, applicable for postgres. Note
	// that this is a warning and won't block the migration.
	//   "UNSUPPORTED_DEFINER" - The customer has a definer that will break EM
	// setup.
	//   "SQLSERVER_SERVERNAME_MISMATCH" - SQL Server @@SERVERNAME does not match
	// actual host name.
	//   "PRIMARY_ALREADY_SETUP" - The primary instance has been setup and will
	// fail the setup.
	//   "UNSUPPORTED_BINLOG_FORMAT" - The primary instance has unsupported binary
	// log format.
	//   "BINLOG_RETENTION_SETTING" - The primary instance's binary log retention
	// setting.
	//   "UNSUPPORTED_STORAGE_ENGINE" - The primary instance has tables with
	// unsupported storage engine.
	//   "LIMITED_SUPPORT_TABLES" - Source has tables with limited support eg:
	// PostgreSQL tables without primary keys.
	//   "EXISTING_DATA_IN_REPLICA" - The replica instance contains existing data.
	//   "MISSING_OPTIONAL_PRIVILEGES" - The replication user is missing privileges
	// that are optional.
	//   "RISKY_BACKUP_ADMIN_PRIVILEGE" - Additional BACKUP_ADMIN privilege is
	// granted to the replication user which may lock source MySQL 8 instance for
	// DDLs during initial sync.
	//   "INSUFFICIENT_GCS_PERMISSIONS" - The Cloud Storage bucket is missing
	// necessary permissions.
	//   "INVALID_FILE_INFO" - The Cloud Storage bucket has an error in the file or
	// contains invalid file information.
	//   "UNSUPPORTED_DATABASE_SETTINGS" - The source instance has unsupported
	// database settings for migration.
	//   "MYSQL_PARALLEL_IMPORT_INSUFFICIENT_PRIVILEGE" - The replication user is
	// missing parallel import specific privileges. (e.g. LOCK TABLES) for MySQL.
	//   "LOCAL_INFILE_OFF" - The global variable local_infile is off on external
	// server replica.
	//   "TURN_ON_PITR_AFTER_PROMOTE" - This code instructs customers to turn on
	// point-in-time recovery manually for the instance after promoting the Cloud
	// SQL for PostgreSQL instance.
	//   "INCOMPATIBLE_DATABASE_MINOR_VERSION" - The minor version of replica
	// database is incompatible with the source.
	//   "SOURCE_MAX_SUBSCRIPTIONS" - This warning message indicates that Cloud SQL
	// uses the maximum number of subscriptions to migrate data from the source to
	// the destination.
	//   "UNABLE_TO_VERIFY_DEFINERS" - Unable to verify definers on the source for
	// MySQL.
	//   "SUBSCRIPTION_CALCULATION_STATUS" - If a time out occurs while the
	// subscription counts are calculated, then this value is set to 1. Otherwise,
	// this value is set to 2.
	//   "PG_SUBSCRIPTION_COUNT" - Count of subscriptions needed to sync source
	// data for PostgreSQL database.
	//   "PG_SYNC_PARALLEL_LEVEL" - Final parallel level that is used to do
	// migration.
	//   "INSUFFICIENT_DISK_SIZE" - The disk size of the replica instance is
	// smaller than the data size of the source instance.
	//   "INSUFFICIENT_MACHINE_TIER" - The data size of the source instance is
	// greater than 1 TB, the number of cores of the replica instance is less than
	// 8, and the memory of the replica is less than 32 GB.
	//   "UNSUPPORTED_EXTENSIONS_NOT_MIGRATED" - The warning message indicates the
	// unsupported extensions will not be migrated to the destination.
	//   "EXTENSIONS_NOT_MIGRATED" - The warning message indicates the pg_cron
	// extension and settings will not be migrated to the destination.
	//   "PG_CRON_FLAG_ENABLED_IN_REPLICA" - The error message indicates that
	// pg_cron flags are enabled on the destination which is not supported during
	// the migration.
	//   "EXTENSIONS_NOT_ENABLED_IN_REPLICA" - This error message indicates that
	// the specified extensions are not enabled on destination instance. For
	// example, before you can migrate data to the destination instance, you must
	// enable the PGAudit extension on the instance.
	//   "UNSUPPORTED_COLUMNS" - The source database has generated columns that
	// can't be migrated. Please change them to regular columns before migration.
	//   "USERS_NOT_CREATED_IN_REPLICA" - The source database has users that aren't
	// created in the replica. First, create all users, which are in the
	// pg_user_mappings table of the source database, in the destination instance.
	// Then, perform the migration.
	//   "UNSUPPORTED_SYSTEM_OBJECTS" - The selected objects include system objects
	// that aren't supported for migration.
	//   "UNSUPPORTED_TABLES_WITH_REPLICA_IDENTITY" - The source database has
	// tables with the FULL or NOTHING replica identity. Before starting your
	// migration, either remove the identity or change it to DEFAULT. Note that
	// this is an error and will block the migration.
	//   "SELECTED_OBJECTS_NOT_EXIST_ON_SOURCE" - The selected objects don't exist
	// on the source instance.
	//   "PSC_ONLY_INSTANCE_WITH_NO_NETWORK_ATTACHMENT_URI" - PSC only destination
	// instance does not have a network attachment URI.
	//   "SELECTED_OBJECTS_REFERENCE_UNSELECTED_OBJECTS" - Selected objects
	// reference unselected objects. Based on their object type (foreign key
	// constraint or view), selected objects will fail during migration.
	//   "PROMPT_DELETE_EXISTING" - The migration will delete existing data in the
	// replica; set replica_overwrite_enabled in the request to acknowledge this.
	// This is an error. MySQL only.
	//   "WILL_DELETE_EXISTING" - The migration will delete existing data in the
	// replica; replica_overwrite_enabled was set in the request acknowledging
	// this. This is a warning rather than an error. MySQL only.
	//   "PG_DDL_REPLICATION_INSUFFICIENT_PRIVILEGE" - The replication user is
	// missing specific privileges to setup DDL replication. (e.g. CREATE EVENT
	// TRIGGER, CREATE SCHEMA) for PostgreSQL.
	Type string `json:"type,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Detail") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Detail") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlExternalSyncSettingError) MarshalJSON() ([]byte, error) {
	type NoMethod SqlExternalSyncSettingError
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlInstancesAcquireSsrsLeaseResponse: Acquire SSRS lease response.
type SqlInstancesAcquireSsrsLeaseResponse struct {
	// OperationId: The unique identifier for this operation.
	OperationId string `json:"operationId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "OperationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OperationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlInstancesAcquireSsrsLeaseResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SqlInstancesAcquireSsrsLeaseResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlInstancesExecuteSqlResponse: Execute SQL statements response.
type SqlInstancesExecuteSqlResponse struct {
	// Messages: A list of notices and warnings generated during query execution.
	// For PostgreSQL, this includes all notices and warnings. For MySQL, this
	// includes warnings generated by the last executed statement. To retrieve all
	// warnings for a multi-statement query, `SHOW WARNINGS` must be executed after
	// each statement.
	Messages []*Message `json:"messages,omitempty"`
	// Metadata: The additional metadata information regarding the execution of the
	// SQL statements.
	Metadata *Metadata `json:"metadata,omitempty"`
	// Results: The list of results after executing all the SQL statements.
	Results []*QueryResult `json:"results,omitempty"`
	// Status: Contains the error from the database if the SQL execution failed.
	Status *Status `json:"status,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Messages") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Messages") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlInstancesExecuteSqlResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SqlInstancesExecuteSqlResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlInstancesGetDiskShrinkConfigResponse: Instance get disk shrink config
// response.
type SqlInstancesGetDiskShrinkConfigResponse struct {
	// Kind: This is always `sql#getDiskShrinkConfig`.
	Kind string `json:"kind,omitempty"`
	// Message: Additional message to customers.
	Message string `json:"message,omitempty"`
	// MinimalTargetSizeGb: The minimum size to which a disk can be shrunk in
	// GigaBytes.
	MinimalTargetSizeGb int64 `json:"minimalTargetSizeGb,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlInstancesGetDiskShrinkConfigResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SqlInstancesGetDiskShrinkConfigResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlInstancesGetLatestRecoveryTimeResponse: Instance get latest recovery time
// response.
type SqlInstancesGetLatestRecoveryTimeResponse struct {
	// EarliestRecoveryTime: Timestamp, identifies the earliest recovery time of
	// the source instance.
	EarliestRecoveryTime string `json:"earliestRecoveryTime,omitempty"`
	// Kind: This is always `sql#getLatestRecoveryTime`.
	Kind string `json:"kind,omitempty"`
	// LatestRecoveryTime: Timestamp, identifies the latest recovery time of the
	// source instance.
	LatestRecoveryTime string `json:"latestRecoveryTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "EarliestRecoveryTime") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "EarliestRecoveryTime") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlInstancesGetLatestRecoveryTimeResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SqlInstancesGetLatestRecoveryTimeResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlInstancesReleaseSsrsLeaseResponse: The response for the release of the
// SSRS lease.
type SqlInstancesReleaseSsrsLeaseResponse struct {
	// OperationId: The operation ID.
	OperationId string `json:"operationId,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "OperationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "OperationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlInstancesReleaseSsrsLeaseResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SqlInstancesReleaseSsrsLeaseResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlInstancesRescheduleMaintenanceRequestBody: Reschedule options for
// maintenance windows.
type SqlInstancesRescheduleMaintenanceRequestBody struct {
	// Reschedule: Required. The type of the reschedule the user wants.
	Reschedule *Reschedule `json:"reschedule,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Reschedule") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Reschedule") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlInstancesRescheduleMaintenanceRequestBody) MarshalJSON() ([]byte, error) {
	type NoMethod SqlInstancesRescheduleMaintenanceRequestBody
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlInstancesResetReplicaSizeRequest: Instance reset replica size request.
type SqlInstancesResetReplicaSizeRequest struct {
}

type SqlInstancesStartExternalSyncRequest struct {
	// MigrationType: Optional. MigrationType configures the migration to use
	// physical files or logical dump files. If not set, then the logical dump file
	// configuration is used. Valid values are `LOGICAL` or `PHYSICAL`. Only
	// applicable to MySQL.
	//
	// Possible values:
	//   "MIGRATION_TYPE_UNSPECIFIED" - Default value is a logical dump file-based
	// migration
	//   "LOGICAL" - Logical dump file-based migration
	//   "PHYSICAL" - Physical file-based migration
	MigrationType string `json:"migrationType,omitempty"`
	// MysqlSyncConfig: MySQL-specific settings for start external sync.
	MysqlSyncConfig *MySqlSyncConfig `json:"mysqlSyncConfig,omitempty"`
	// ReplicaOverwriteEnabled: Optional. MySQL only. True if end-user has
	// confirmed that this SES call will wipe replica databases overlapping with
	// the proposed selected_objects. If this field is not set and there are both
	// overlapping and additional databases proposed, an error will be returned.
	ReplicaOverwriteEnabled bool `json:"replicaOverwriteEnabled,omitempty"`
	// SkipVerification: Whether to skip the verification step (VESS).
	SkipVerification bool `json:"skipVerification,omitempty"`
	// SyncMode: External sync mode.
	//
	// Possible values:
	//   "EXTERNAL_SYNC_MODE_UNSPECIFIED" - Unknown external sync mode, will be
	// defaulted to ONLINE mode
	//   "ONLINE" - Online external sync will set up replication after initial data
	// external sync
	//   "OFFLINE" - Offline external sync only dumps and loads a one-time snapshot
	// of the primary instance's data
	SyncMode string `json:"syncMode,omitempty"`
	// SyncParallelLevel: Optional. Parallel level for initial data sync. Currently
	// only applicable for MySQL.
	//
	// Possible values:
	//   "EXTERNAL_SYNC_PARALLEL_LEVEL_UNSPECIFIED" - Unknown sync parallel level.
	// Will be defaulted to OPTIMAL.
	//   "MIN" - Minimal parallel level.
	//   "OPTIMAL" - Optimal parallel level.
	//   "MAX" - Maximum parallel level.
	SyncParallelLevel string `json:"syncParallelLevel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MigrationType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MigrationType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlInstancesStartExternalSyncRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SqlInstancesStartExternalSyncRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type SqlInstancesVerifyExternalSyncSettingsRequest struct {
	// MigrationType: Optional. MigrationType configures the migration to use
	// physical files or logical dump files. If not set, then the logical dump file
	// configuration is used. Valid values are `LOGICAL` or `PHYSICAL`. Only
	// applicable to MySQL.
	//
	// Possible values:
	//   "MIGRATION_TYPE_UNSPECIFIED" - Default value is a logical dump file-based
	// migration
	//   "LOGICAL" - Logical dump file-based migration
	//   "PHYSICAL" - Physical file-based migration
	MigrationType string `json:"migrationType,omitempty"`
	// MysqlSyncConfig: Optional. MySQL-specific settings for start external sync.
	MysqlSyncConfig *MySqlSyncConfig `json:"mysqlSyncConfig,omitempty"`
	// SelectedObjects: Optional. Migrate only the specified objects from the
	// source instance. If this field is empty, then migrate all objects.
	SelectedObjects []*ExternalSyncSelectedObject `json:"selectedObjects,omitempty"`
	// SyncMode: External sync mode
	//
	// Possible values:
	//   "EXTERNAL_SYNC_MODE_UNSPECIFIED" - Unknown external sync mode, will be
	// defaulted to ONLINE mode
	//   "ONLINE" - Online external sync will set up replication after initial data
	// external sync
	//   "OFFLINE" - Offline external sync only dumps and loads a one-time snapshot
	// of the primary instance's data
	SyncMode string `json:"syncMode,omitempty"`
	// SyncParallelLevel: Optional. Parallel level for initial data sync. Only
	// applicable for PostgreSQL.
	//
	// Possible values:
	//   "EXTERNAL_SYNC_PARALLEL_LEVEL_UNSPECIFIED" - Unknown sync parallel level.
	// Will be defaulted to OPTIMAL.
	//   "MIN" - Minimal parallel level.
	//   "OPTIMAL" - Optimal parallel level.
	//   "MAX" - Maximum parallel level.
	SyncParallelLevel string `json:"syncParallelLevel,omitempty"`
	// VerifyConnectionOnly: Flag to enable verifying connection only
	VerifyConnectionOnly bool `json:"verifyConnectionOnly,omitempty"`
	// VerifyReplicationOnly: Optional. Flag to verify settings required by
	// replication setup only
	VerifyReplicationOnly bool `json:"verifyReplicationOnly,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MigrationType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MigrationType") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlInstancesVerifyExternalSyncSettingsRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SqlInstancesVerifyExternalSyncSettingsRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlInstancesVerifyExternalSyncSettingsResponse: Instance verify external
// sync settings response.
type SqlInstancesVerifyExternalSyncSettingsResponse struct {
	// Errors: List of migration violations.
	Errors []*SqlExternalSyncSettingError `json:"errors,omitempty"`
	// Kind: This is always `sql#migrationSettingErrorList`.
	Kind string `json:"kind,omitempty"`
	// Warnings: List of migration warnings.
	Warnings []*SqlExternalSyncSettingError `json:"warnings,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Errors") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Errors") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlInstancesVerifyExternalSyncSettingsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SqlInstancesVerifyExternalSyncSettingsResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlOutOfDiskReport: This message wraps up the information written by
// out-of-disk detection job.
type SqlOutOfDiskReport struct {
	// SqlMinRecommendedIncreaseSizeGb: The minimum recommended increase size in
	// GigaBytes This field is consumed by the frontend * Writers: * the proactive
	// database wellness job for OOD. * Readers:
	SqlMinRecommendedIncreaseSizeGb int64 `json:"sqlMinRecommendedIncreaseSizeGb,omitempty"`
	// SqlOutOfDiskState: This field represents the state generated by the
	// proactive database wellness job for OutOfDisk issues. * Writers: * the
	// proactive database wellness job for OOD. * Readers: * the proactive database
	// wellness job
	//
	// Possible values:
	//   "SQL_OUT_OF_DISK_STATE_UNSPECIFIED" - Unspecified state
	//   "NORMAL" - The instance has plenty space on data disk
	//   "SOFT_SHUTDOWN" - Data disk is almost used up. It is shutdown to prevent
	// data corruption.
	SqlOutOfDiskState string `json:"sqlOutOfDiskState,omitempty"`
	// ForceSendFields is a list of field names (e.g.
	// "SqlMinRecommendedIncreaseSizeGb") to unconditionally include in API
	// requests. By default, fields with empty or default values are omitted from
	// API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "SqlMinRecommendedIncreaseSizeGb")
	// to include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlOutOfDiskReport) MarshalJSON() ([]byte, error) {
	type NoMethod SqlOutOfDiskReport
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlScheduledMaintenance: Any scheduled maintenance for this instance.
type SqlScheduledMaintenance struct {
	CanDefer bool `json:"canDefer,omitempty"`
	// CanReschedule: If the scheduled maintenance can be rescheduled.
	CanReschedule bool `json:"canReschedule,omitempty"`
	// ScheduleDeadlineTime: Maintenance cannot be rescheduled to start beyond this
	// deadline.
	ScheduleDeadlineTime string `json:"scheduleDeadlineTime,omitempty"`
	// StartTime: The start time of any upcoming scheduled maintenance for this
	// instance.
	StartTime string `json:"startTime,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CanDefer") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CanDefer") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlScheduledMaintenance) MarshalJSON() ([]byte, error) {
	type NoMethod SqlScheduledMaintenance
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlServerAuditConfig: SQL Server specific audit configuration.
type SqlServerAuditConfig struct {
	// Bucket: The name of the destination bucket (e.g., gs://mybucket).
	Bucket string `json:"bucket,omitempty"`
	// Kind: This is always sql#sqlServerAuditConfig
	Kind string `json:"kind,omitempty"`
	// RetentionInterval: How long to keep generated audit files.
	RetentionInterval string `json:"retentionInterval,omitempty"`
	// UploadInterval: How often to upload generated audit files.
	UploadInterval string `json:"uploadInterval,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Bucket") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Bucket") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlServerAuditConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SqlServerAuditConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlServerDatabaseDetails: Represents a Sql Server database on the Cloud SQL
// instance.
type SqlServerDatabaseDetails struct {
	// CompatibilityLevel: The version of SQL Server with which the database is to
	// be made compatible
	CompatibilityLevel int64 `json:"compatibilityLevel,omitempty"`
	// RecoveryModel: The recovery model of a SQL Server database
	RecoveryModel string `json:"recoveryModel,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CompatibilityLevel") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CompatibilityLevel") to include
	// in API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlServerDatabaseDetails) MarshalJSON() ([]byte, error) {
	type NoMethod SqlServerDatabaseDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlServerEntraIdConfig: SQL Server Entra ID configuration.
type SqlServerEntraIdConfig struct {
	// ApplicationId: Optional. The application ID for the Entra ID configuration.
	ApplicationId string `json:"applicationId,omitempty"`
	// Kind: Output only. This is always sql#sqlServerEntraIdConfig
	Kind string `json:"kind,omitempty"`
	// TenantId: Optional. The tenant ID for the Entra ID configuration.
	TenantId string `json:"tenantId,omitempty"`
	// ForceSendFields is a list of field names (e.g. "ApplicationId") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ApplicationId") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlServerEntraIdConfig) MarshalJSON() ([]byte, error) {
	type NoMethod SqlServerEntraIdConfig
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlServerUserDetails: Represents a Sql Server user on the Cloud SQL
// instance.
type SqlServerUserDetails struct {
	// Disabled: If the user has been disabled
	Disabled bool `json:"disabled,omitempty"`
	// ServerRoles: The server roles for this user
	ServerRoles []string `json:"serverRoles,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Disabled") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Disabled") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlServerUserDetails) MarshalJSON() ([]byte, error) {
	type NoMethod SqlServerUserDetails
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SqlSubOperationType: The sub operation type based on the operation type.
type SqlSubOperationType struct {
	// MaintenanceType: The type of maintenance to be performed on the instance.
	//
	// Possible values:
	//   "SQL_MAINTENANCE_TYPE_UNSPECIFIED" - Maintenance type is unspecified.
	//   "INSTANCE_MAINTENANCE" - Indicates that a standalone instance is
	// undergoing maintenance. The instance can be either a primary instance or a
	// replica.
	//   "REPLICA_INCLUDED_MAINTENANCE" - Indicates that the primary instance and
	// all of its replicas, including cascading replicas, are undergoing
	// maintenance. Maintenance is performed on groups of replicas first, followed
	// by the primary instance.
	//   "INSTANCE_SELF_SERVICE_MAINTENANCE" - Indicates that the standalone
	// instance is undergoing maintenance, initiated by self-service. The instance
	// can be either a primary instance or a replica.
	//   "REPLICA_INCLUDED_SELF_SERVICE_MAINTENANCE" - Indicates that the primary
	// instance and all of its replicas are undergoing maintenance, initiated by
	// self-service. Maintenance is performed on groups of replicas first, followed
	// by the primary instance.
	MaintenanceType string `json:"maintenanceType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "MaintenanceType") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "MaintenanceType") to include in
	// API requests with the JSON null value. By default, fields with empty values
	// are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SqlSubOperationType) MarshalJSON() ([]byte, error) {
	type NoMethod SqlSubOperationType
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SslCert: SslCerts Resource
type SslCert struct {
	// Cert: PEM representation.
	Cert string `json:"cert,omitempty"`
	// CertSerialNumber: Serial number, as extracted from the certificate.
	CertSerialNumber string `json:"certSerialNumber,omitempty"`
	// CommonName: User supplied name. Constrained to [a-zA-Z.-_ ]+.
	CommonName string `json:"commonName,omitempty"`
	// CreateTime: The time when the certificate was created in RFC 3339
	// (https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	CreateTime string `json:"createTime,omitempty"`
	// ExpirationTime: The time when the certificate expires in RFC 3339
	// (https://tools.ietf.org/html/rfc3339) format, for example
	// `2012-11-15T16:19:00.094Z`.
	ExpirationTime string `json:"expirationTime,omitempty"`
	// Instance: Name of the database instance.
	Instance string `json:"instance,omitempty"`
	// Kind: This is always `sql#sslCert`.
	Kind string `json:"kind,omitempty"`
	// SelfLink: The URI of this resource.
	SelfLink string `json:"selfLink,omitempty"`
	// Sha1Fingerprint: Sha1 Fingerprint.
	Sha1Fingerprint string `json:"sha1Fingerprint,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Cert") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Cert") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SslCert) MarshalJSON() ([]byte, error) {
	type NoMethod SslCert
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SslCertDetail: SslCertDetail.
type SslCertDetail struct {
	// CertInfo: The public information about the cert.
	CertInfo *SslCert `json:"certInfo,omitempty"`
	// CertPrivateKey: The private key for the client cert, in pem format. Keep
	// private in order to protect your security.
	CertPrivateKey string `json:"certPrivateKey,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CertInfo") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CertInfo") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SslCertDetail) MarshalJSON() ([]byte, error) {
	type NoMethod SslCertDetail
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SslCertsCreateEphemeralRequest: SslCerts create ephemeral certificate
// request.
type SslCertsCreateEphemeralRequest struct {
	// AccessToken: Access token to include in the signed certificate.
	AccessToken string `json:"access_token,omitempty"`
	// PublicKey: PEM encoded public key to include in the signed certificate.
	PublicKey string `json:"public_key,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AccessToken") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AccessToken") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SslCertsCreateEphemeralRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SslCertsCreateEphemeralRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SslCertsInsertRequest: SslCerts insert request.
type SslCertsInsertRequest struct {
	// CommonName: User supplied name. Must be a distinct name from the other
	// certificates for this instance.
	CommonName string `json:"commonName,omitempty"`
	// ForceSendFields is a list of field names (e.g. "CommonName") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "CommonName") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SslCertsInsertRequest) MarshalJSON() ([]byte, error) {
	type NoMethod SslCertsInsertRequest
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SslCertsInsertResponse: SslCert insert response.
type SslCertsInsertResponse struct {
	// ClientCert: The new client certificate and private key.
	ClientCert *SslCertDetail `json:"clientCert,omitempty"`
	// Kind: This is always `sql#sslCertsInsert`.
	Kind string `json:"kind,omitempty"`
	// Operation: The operation to track the ssl certs insert request.
	Operation *Operation `json:"operation,omitempty"`
	// ServerCaCert: The server Certificate Authority's certificate. If this is
	// missing you can force a new one to be generated by calling resetSslConfig
	// method on instances resource.
	ServerCaCert *SslCert `json:"serverCaCert,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "ClientCert") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "ClientCert") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SslCertsInsertResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SslCertsInsertResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SslCertsListResponse: SslCerts list response.
type SslCertsListResponse struct {
	// Items: List of client certificates for the instance.
	Items []*SslCert `json:"items,omitempty"`
	// Kind: This is always `sql#sslCertsList`.
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SslCertsListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SslCertsListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Status: The `Status` type defines a logical error model that is suitable for
// different programming environments, including REST APIs and RPC APIs. It is
// used by gRPC (https://github.com/grpc). Each `Status` message contains three
// pieces of data: error code, error message, and error details. You can find
// out more about this error model and how to work with it in the API Design
// Guide (https://cloud.google.com/apis/design/errors).
type Status struct {
	// Code: The status code, which should be an enum value of google.rpc.Code.
	Code int64 `json:"code,omitempty"`
	// Details: A list of messages that carry the error details. There is a common
	// set of message types for APIs to use.
	Details []googleapi.RawMessage `json:"details,omitempty"`
	// Message: A developer-facing error message, which should be in English. Any
	// user-facing error message should be localized and sent in the
	// google.rpc.Status.details field, or localized by the client.
	Message string `json:"message,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Code") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Code") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Status) MarshalJSON() ([]byte, error) {
	type NoMethod Status
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// SyncFlags: Initial sync flags for certain Cloud SQL APIs. Currently used for
// the MySQL external server initial dump.
type SyncFlags struct {
	// Name: The name of the flag.
	Name string `json:"name,omitempty"`
	// Value: The value of the flag. This field must be omitted if the flag doesn't
	// take a value.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Name") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Name") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s SyncFlags) MarshalJSON() ([]byte, error) {
	type NoMethod SyncFlags
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TargetMetric: Target metric for read pool auto scaling.
type TargetMetric struct {
	// Metric: The metric name to be used for auto scaling.
	Metric string `json:"metric,omitempty"`
	// TargetValue: The target value for the metric.
	TargetValue float64 `json:"targetValue,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Metric") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Metric") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TargetMetric) MarshalJSON() ([]byte, error) {
	type NoMethod TargetMetric
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

func (s *TargetMetric) UnmarshalJSON(data []byte) error {
	type NoMethod TargetMetric
	var s1 struct {
		TargetValue gensupport.JSONFloat64 `json:"targetValue"`
		*NoMethod
	}
	s1.NoMethod = (*NoMethod)(s)
	if err := json.Unmarshal(data, &s1); err != nil {
		return err
	}
	s.TargetValue = float64(s1.TargetValue)
	return nil
}

// Tier: A Google Cloud SQL service tier resource.
type Tier struct {
	// DiskQuota: The maximum disk size of this tier in bytes.
	DiskQuota int64 `json:"DiskQuota,omitempty,string"`
	// RAM: The maximum RAM usage of this tier in bytes.
	RAM int64 `json:"RAM,omitempty,string"`
	// Kind: This is always `sql#tier`.
	Kind string `json:"kind,omitempty"`
	// Region: The applicable regions for this tier.
	Region []string `json:"region,omitempty"`
	// Tier: An identifier for the machine type, for example, `db-custom-1-3840`.
	// For related information, see Pricing (/sql/pricing).
	Tier string `json:"tier,omitempty"`
	// ForceSendFields is a list of field names (e.g. "DiskQuota") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DiskQuota") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Tier) MarshalJSON() ([]byte, error) {
	type NoMethod Tier
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TiersListResponse: Tiers list response.
type TiersListResponse struct {
	// Items: List of tiers.
	Items []*Tier `json:"items,omitempty"`
	// Kind: This is always `sql#tiersList`.
	Kind string `json:"kind,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TiersListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod TiersListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// TruncateLogContext: Database Instance truncate log context.
type TruncateLogContext struct {
	// Kind: This is always `sql#truncateLogContext`.
	Kind string `json:"kind,omitempty"`
	// LogType: The type of log to truncate. Valid values are `MYSQL_GENERAL_TABLE`
	// and `MYSQL_SLOW_TABLE`.
	LogType string `json:"logType,omitempty"`
	// ForceSendFields is a list of field names (e.g. "Kind") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Kind") to include in API requests
	// with the JSON null value. By default, fields with empty values are omitted
	// from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s TruncateLogContext) MarshalJSON() ([]byte, error) {
	type NoMethod TruncateLogContext
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// User: A Cloud SQL user resource.
type User struct {
	// DatabaseRoles: Optional. Role memberships of the user
	DatabaseRoles []string `json:"databaseRoles,omitempty"`
	// DualPasswordType: Dual password status for the user.
	//
	// Possible values:
	//   "DUAL_PASSWORD_TYPE_UNSPECIFIED" - The default value.
	//   "NO_MODIFY_DUAL_PASSWORD" - Do not update the user's dual password status.
	//   "NO_DUAL_PASSWORD" - No dual password usable for connecting using this
	// user.
	//   "DUAL_PASSWORD" - Dual password usable for connecting using this user.
	DualPasswordType string `json:"dualPasswordType,omitempty"`
	// Etag: This field is deprecated and will be removed from a future version of
	// the API.
	Etag string `json:"etag,omitempty"`
	// Host: Optional. The host from which the user can connect. For `insert`
	// operations, host defaults to an empty string. For `update` operations, host
	// is specified as part of the request URL. The host name cannot be updated
	// after insertion. For a MySQL instance, it's required; for a PostgreSQL or
	// SQL Server instance, it's optional.
	Host string `json:"host,omitempty"`
	// IamEmail: Optional. The full email for an IAM user. For normal database
	// users, this will not be filled. Only applicable to MySQL database users.
	IamEmail string `json:"iamEmail,omitempty"`
	// IamStatus: Indicates if a group is active or inactive for IAM database
	// authentication.
	//
	// Possible values:
	//   "IAM_STATUS_UNSPECIFIED" - The default value for users that are not of
	// type CLOUD_IAM_GROUP. Only CLOUD_IAM_GROUP users will be inactive or active.
	// Users with an IamStatus of IAM_STATUS_UNSPECIFIED will not display whether
	// they are active or inactive as that is not applicable to them.
	//   "INACTIVE" - INACTIVE indicates a group is not available for IAM database
	// authentication.
	//   "ACTIVE" - ACTIVE indicates a group is available for IAM database
	// authentication.
	IamStatus string `json:"iamStatus,omitempty"`
	// Instance: The name of the Cloud SQL instance. This does not include the
	// project ID. Can be omitted for *update* because it is already specified on
	// the URL.
	Instance string `json:"instance,omitempty"`
	// Kind: This is always `sql#user`.
	Kind string `json:"kind,omitempty"`
	// Name: The name of the user in the Cloud SQL instance. Can be omitted for
	// `update` because it is already specified in the URL.
	Name string `json:"name,omitempty"`
	// Password: The password for the user.
	Password string `json:"password,omitempty"`
	// PasswordPolicy: User level password validation policy.
	PasswordPolicy *UserPasswordValidationPolicy `json:"passwordPolicy,omitempty"`
	// Project: The project ID of the project containing the Cloud SQL database.
	// The Google apps domain is prefixed if applicable. Can be omitted for
	// *update* because it is already specified on the URL.
	Project              string                `json:"project,omitempty"`
	SqlserverUserDetails *SqlServerUserDetails `json:"sqlserverUserDetails,omitempty"`
	// Type: The user type. It determines the method to authenticate the user
	// during login. The default is the database's built-in user type.
	//
	// Possible values:
	//   "BUILT_IN" - The database's built-in user type.
	//   "CLOUD_IAM_USER" - Cloud IAM user.
	//   "CLOUD_IAM_SERVICE_ACCOUNT" - Cloud IAM service account.
	//   "CLOUD_IAM_GROUP" - Cloud IAM group. Not used for login.
	//   "CLOUD_IAM_GROUP_USER" - Read-only. Login for a user that belongs to the
	// Cloud IAM group.
	//   "CLOUD_IAM_GROUP_SERVICE_ACCOUNT" - Read-only. Login for a service account
	// that belongs to the Cloud IAM group.
	//   "ENTRAID_USER" - Microsoft Entra ID user.
	Type string `json:"type,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "DatabaseRoles") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "DatabaseRoles") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s User) MarshalJSON() ([]byte, error) {
	type NoMethod User
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UserPasswordValidationPolicy: User level password validation policy.
type UserPasswordValidationPolicy struct {
	// AllowedFailedAttempts: Number of failed login attempts allowed before user
	// get locked.
	AllowedFailedAttempts int64 `json:"allowedFailedAttempts,omitempty"`
	// EnableFailedAttemptsCheck: If true, failed login attempts check will be
	// enabled.
	EnableFailedAttemptsCheck bool `json:"enableFailedAttemptsCheck,omitempty"`
	// EnablePasswordVerification: If true, the user must specify the current
	// password before changing the password. This flag is supported only for
	// MySQL.
	EnablePasswordVerification bool `json:"enablePasswordVerification,omitempty"`
	// PasswordExpirationDuration: Expiration duration after password is updated.
	PasswordExpirationDuration string `json:"passwordExpirationDuration,omitempty"`
	// Status: Output only. Read-only password status.
	Status *PasswordStatus `json:"status,omitempty"`
	// ForceSendFields is a list of field names (e.g. "AllowedFailedAttempts") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "AllowedFailedAttempts") to
	// include in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UserPasswordValidationPolicy) MarshalJSON() ([]byte, error) {
	type NoMethod UserPasswordValidationPolicy
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// UsersListResponse: User list response.
type UsersListResponse struct {
	// Items: List of user resources in the instance.
	Items []*User `json:"items,omitempty"`
	// Kind: This is always *sql#usersList*.
	Kind string `json:"kind,omitempty"`
	// NextPageToken: Unused.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the server.
	googleapi.ServerResponse `json:"-"`
	// ForceSendFields is a list of field names (e.g. "Items") to unconditionally
	// include in API requests. By default, fields with empty or default values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "Items") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s UsersListResponse) MarshalJSON() ([]byte, error) {
	type NoMethod UsersListResponse
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

// Value: The cell value of the table.
type Value struct {
	// NullValue: If cell value is null, then this flag will be set to true.
	NullValue bool `json:"nullValue,omitempty"`
	// Value: The cell value represented in string format.
	Value string `json:"value,omitempty"`
	// ForceSendFields is a list of field names (e.g. "NullValue") to
	// unconditionally include in API requests. By default, fields with empty or
	// default values are omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-ForceSendFields for more
	// details.
	ForceSendFields []string `json:"-"`
	// NullFields is a list of field names (e.g. "NullValue") to include in API
	// requests with the JSON null value. By default, fields with empty values are
	// omitted from API requests. See
	// https://pkg.go.dev/google.golang.org/api#hdr-NullFields for more details.
	NullFields []string `json:"-"`
}

func (s Value) MarshalJSON() ([]byte, error) {
	type NoMethod Value
	return gensupport.MarshalJSON(NoMethod(s), s.ForceSendFields, s.NullFields)
}

type BackupRunsDeleteCall struct {
	s          *Service
	project    string
	instance   string
	id         int64
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes the backup taken by a backup run.
//
//   - id: The ID of the backup run to delete. To find a backup run ID, use the
//     list
//     (https://cloud.google.com/sql/docs/mysql/admin-api/rest/v1beta4/backupRuns/list)
//     method.
//   - instance: Cloud SQL instance ID. This does not include the project ID.
//   - project: Project ID of the project that contains the instance.
func (r *BackupRunsService) Delete(project string, instance string, id int64) *BackupRunsDeleteCall {
	c := &BackupRunsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.id = id
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BackupRunsDeleteCall) Fields(s ...googleapi.Field) *BackupRunsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BackupRunsDeleteCall) Context(ctx context.Context) *BackupRunsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BackupRunsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BackupRunsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/backupRuns/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
		"id":       strconv.FormatInt(c.id, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.backupRuns.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.backupRuns.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BackupRunsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.backupRuns.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BackupRunsGetCall struct {
	s            *Service
	project      string
	instance     string
	id           int64
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a resource containing information about a backup run.
//
// - id: The ID of this backup run.
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *BackupRunsService) Get(project string, instance string, id int64) *BackupRunsGetCall {
	c := &BackupRunsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.id = id
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BackupRunsGetCall) Fields(s ...googleapi.Field) *BackupRunsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BackupRunsGetCall) IfNoneMatch(entityTag string) *BackupRunsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BackupRunsGetCall) Context(ctx context.Context) *BackupRunsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BackupRunsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BackupRunsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/backupRuns/{id}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
		"id":       strconv.FormatInt(c.id, 10),
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.backupRuns.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.backupRuns.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *BackupRun.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BackupRunsGetCall) Do(opts ...googleapi.CallOption) (*BackupRun, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BackupRun{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.backupRuns.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BackupRunsInsertCall struct {
	s          *Service
	project    string
	instance   string
	backuprun  *BackupRun
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Creates a new backup run on demand.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *BackupRunsService) Insert(project string, instance string, backuprun *BackupRun) *BackupRunsInsertCall {
	c := &BackupRunsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.backuprun = backuprun
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BackupRunsInsertCall) Fields(s ...googleapi.Field) *BackupRunsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BackupRunsInsertCall) Context(ctx context.Context) *BackupRunsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BackupRunsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BackupRunsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.backuprun)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/backupRuns")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.backupRuns.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.backupRuns.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BackupRunsInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.backupRuns.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BackupRunsListCall struct {
	s            *Service
	project      string
	instance     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all backup runs associated with the project or a given instance
// and configuration in the reverse chronological order of the backup
// initiation time.
//
//   - instance: Cloud SQL instance ID, or "-" for all instances. This does not
//     include the project ID.
//   - project: Project ID of the project that contains the instance.
func (r *BackupRunsService) List(project string, instance string) *BackupRunsListCall {
	c := &BackupRunsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// MaxResults sets the optional parameter "maxResults": Maximum number of
// backup runs per response.
func (c *BackupRunsListCall) MaxResults(maxResults int64) *BackupRunsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": A previously-returned
// page token representing part of the larger set of results to view.
func (c *BackupRunsListCall) PageToken(pageToken string) *BackupRunsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BackupRunsListCall) Fields(s ...googleapi.Field) *BackupRunsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BackupRunsListCall) IfNoneMatch(entityTag string) *BackupRunsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BackupRunsListCall) Context(ctx context.Context) *BackupRunsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BackupRunsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BackupRunsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/backupRuns")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.backupRuns.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.backupRuns.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *BackupRunsListResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BackupRunsListCall) Do(opts ...googleapi.CallOption) (*BackupRunsListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &BackupRunsListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.backupRuns.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BackupRunsListCall) Pages(ctx context.Context, f func(*BackupRunsListResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BackupsCreateBackupCall struct {
	s          *Service
	parent     string
	backup     *Backup
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// CreateBackup: Creates a backup for a Cloud SQL instance. This API can be
// used only to create on-demand backups.
//
//   - parent: The parent resource where this backup is created. Format:
//     projects/{project}.
func (r *BackupsService) CreateBackup(parent string, backup *Backup) *BackupsCreateBackupCall {
	c := &BackupsCreateBackupCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.backup = backup
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BackupsCreateBackupCall) Fields(s ...googleapi.Field) *BackupsCreateBackupCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BackupsCreateBackupCall) Context(ctx context.Context) *BackupsCreateBackupCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BackupsCreateBackupCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BackupsCreateBackupCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.backup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/{+parent}/backups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.backups.createBackup", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.backups.createBackup" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BackupsCreateBackupCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.backups.createBackup", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BackupsDeleteBackupCall struct {
	s          *Service
	name       string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// DeleteBackup: Deletes the backup.
//
//   - name: The name of the backup to delete. Format:
//     projects/{project}/backups/{backup}.
func (r *BackupsService) DeleteBackup(name string) *BackupsDeleteBackupCall {
	c := &BackupsDeleteBackupCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BackupsDeleteBackupCall) Fields(s ...googleapi.Field) *BackupsDeleteBackupCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BackupsDeleteBackupCall) Context(ctx context.Context) *BackupsDeleteBackupCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BackupsDeleteBackupCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BackupsDeleteBackupCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.backups.deleteBackup", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.backups.deleteBackup" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BackupsDeleteBackupCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.backups.deleteBackup", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BackupsGetBackupCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetBackup: Retrieves a resource containing information about a backup.
//
//   - name: The name of the backup to retrieve. Format:
//     projects/{project}/backups/{backup}.
func (r *BackupsService) GetBackup(name string) *BackupsGetBackupCall {
	c := &BackupsGetBackupCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BackupsGetBackupCall) Fields(s ...googleapi.Field) *BackupsGetBackupCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BackupsGetBackupCall) IfNoneMatch(entityTag string) *BackupsGetBackupCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BackupsGetBackupCall) Context(ctx context.Context) *BackupsGetBackupCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BackupsGetBackupCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BackupsGetBackupCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.backups.getBackup", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.backups.getBackup" call.
// Any non-2xx status code is an error. Response headers are in either
// *Backup.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BackupsGetBackupCall) Do(opts ...googleapi.CallOption) (*Backup, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Backup{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.backups.getBackup", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type BackupsListBackupsCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListBackups: Lists all backups associated with the project.
//
//   - parent: The parent that owns this collection of backups. Format:
//     projects/{project}.
func (r *BackupsService) ListBackups(parent string) *BackupsListBackupsCall {
	c := &BackupsListBackupsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": Multiple filter queries are
// separated by spaces. For example, 'instance:abc AND type:FINAL,
// 'location:us', 'backupInterval.startTime>=1950-01-01T01:01:25.771Z'. You can
// filter by type, instance, backupInterval.startTime (creation time), or
// location.
func (c *BackupsListBackupsCall) Filter(filter string) *BackupsListBackupsCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number of
// backups to return per response. The service might return fewer backups than
// this value. If a value for this parameter isn't specified, then, at most,
// 500 backups are returned. The maximum value is 2,000. Any values that you
// set, which are greater than 2,000, are changed to 2,000.
func (c *BackupsListBackupsCall) PageSize(pageSize int64) *BackupsListBackupsCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A page token, received
// from a previous `ListBackups` call. Provide this to retrieve the subsequent
// page. When paginating, all other parameters provided to `ListBackups` must
// match the call that provided the page token.
func (c *BackupsListBackupsCall) PageToken(pageToken string) *BackupsListBackupsCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BackupsListBackupsCall) Fields(s ...googleapi.Field) *BackupsListBackupsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *BackupsListBackupsCall) IfNoneMatch(entityTag string) *BackupsListBackupsCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BackupsListBackupsCall) Context(ctx context.Context) *BackupsListBackupsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BackupsListBackupsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BackupsListBackupsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/{+parent}/backups")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.backups.listBackups", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.backups.listBackups" call.
// Any non-2xx status code is an error. Response headers are in either
// *ListBackupsResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *BackupsListBackupsCall) Do(opts ...googleapi.CallOption) (*ListBackupsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ListBackupsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.backups.listBackups", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *BackupsListBackupsCall) Pages(ctx context.Context, f func(*ListBackupsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type BackupsUpdateBackupCall struct {
	s          *Service
	name       string
	backup     *Backup
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// UpdateBackup: Updates the retention period and the description of the
// backup. You can use this API to update final backups only.
//
//   - name: Output only. The resource name of the backup. Format:
//     projects/{project}/backups/{backup}.
func (r *BackupsService) UpdateBackup(name string, backup *Backup) *BackupsUpdateBackupCall {
	c := &BackupsUpdateBackupCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.backup = backup
	return c
}

// UpdateMask sets the optional parameter "updateMask": The list of fields that
// you can update. You can update only the description and retention period of
// the final backup.
func (c *BackupsUpdateBackupCall) UpdateMask(updateMask string) *BackupsUpdateBackupCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *BackupsUpdateBackupCall) Fields(s ...googleapi.Field) *BackupsUpdateBackupCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *BackupsUpdateBackupCall) Context(ctx context.Context) *BackupsUpdateBackupCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *BackupsUpdateBackupCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *BackupsUpdateBackupCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.backup)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.backups.updateBackup", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.backups.updateBackup" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *BackupsUpdateBackupCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.backups.updateBackup", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ConnectGenerateEphemeralCertCall struct {
	s                            *Service
	project                      string
	instance                     string
	generateephemeralcertrequest *GenerateEphemeralCertRequest
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// GenerateEphemeralCert: Generates a short-lived X509 certificate containing
// the provided public key and signed by a private key specific to the target
// instance. Users may use the certificate to authenticate as themselves when
// connecting to the database.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *ConnectService) GenerateEphemeralCert(project string, instance string, generateephemeralcertrequest *GenerateEphemeralCertRequest) *ConnectGenerateEphemeralCertCall {
	c := &ConnectGenerateEphemeralCertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.generateephemeralcertrequest = generateephemeralcertrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ConnectGenerateEphemeralCertCall) Fields(s ...googleapi.Field) *ConnectGenerateEphemeralCertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ConnectGenerateEphemeralCertCall) Context(ctx context.Context) *ConnectGenerateEphemeralCertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ConnectGenerateEphemeralCertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ConnectGenerateEphemeralCertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.generateephemeralcertrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}:generateEphemeralCert")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.connect.generateEphemeral", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.connect.generateEphemeral" call.
// Any non-2xx status code is an error. Response headers are in either
// *GenerateEphemeralCertResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ConnectGenerateEphemeralCertCall) Do(opts ...googleapi.CallOption) (*GenerateEphemeralCertResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &GenerateEphemeralCertResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.connect.generateEphemeral", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ConnectGetCall struct {
	s            *Service
	project      string
	instance     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves connect settings about a Cloud SQL instance.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *ConnectService) Get(project string, instance string) *ConnectGetCall {
	c := &ConnectGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// ReadTime sets the optional parameter "readTime": Optional snapshot read
// timestamp to trade freshness for performance.
func (c *ConnectGetCall) ReadTime(readTime string) *ConnectGetCall {
	c.urlParams_.Set("readTime", readTime)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ConnectGetCall) Fields(s ...googleapi.Field) *ConnectGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ConnectGetCall) IfNoneMatch(entityTag string) *ConnectGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ConnectGetCall) Context(ctx context.Context) *ConnectGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ConnectGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ConnectGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/connectSettings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.connect.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.connect.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *ConnectSettings.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *ConnectGetCall) Do(opts ...googleapi.CallOption) (*ConnectSettings, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &ConnectSettings{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.connect.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DatabasesDeleteCall struct {
	s          *Service
	project    string
	instance   string
	database   string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a database from a Cloud SQL instance.
//
// - database: Name of the database to be deleted in the instance.
// - instance: Database instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *DatabasesService) Delete(project string, instance string, database string) *DatabasesDeleteCall {
	c := &DatabasesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.database = database
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatabasesDeleteCall) Fields(s ...googleapi.Field) *DatabasesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatabasesDeleteCall) Context(ctx context.Context) *DatabasesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatabasesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatabasesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/databases/{database}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
		"database": c.database,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.databases.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.databases.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DatabasesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.databases.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DatabasesGetCall struct {
	s            *Service
	project      string
	instance     string
	database     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a resource containing information about a database inside a
// Cloud SQL instance.
//
// - database: Name of the database in the instance.
// - instance: Database instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *DatabasesService) Get(project string, instance string, database string) *DatabasesGetCall {
	c := &DatabasesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.database = database
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatabasesGetCall) Fields(s ...googleapi.Field) *DatabasesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DatabasesGetCall) IfNoneMatch(entityTag string) *DatabasesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatabasesGetCall) Context(ctx context.Context) *DatabasesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatabasesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatabasesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/databases/{database}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
		"database": c.database,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.databases.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.databases.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Database.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DatabasesGetCall) Do(opts ...googleapi.CallOption) (*Database, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Database{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.databases.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DatabasesInsertCall struct {
	s          *Service
	project    string
	instance   string
	database   *Database
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Inserts a resource containing information about a database inside a
// Cloud SQL instance. **Note:** You can't modify the default character set and
// collation.
//
// - instance: Database instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *DatabasesService) Insert(project string, instance string, database *Database) *DatabasesInsertCall {
	c := &DatabasesInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.database = database
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatabasesInsertCall) Fields(s ...googleapi.Field) *DatabasesInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatabasesInsertCall) Context(ctx context.Context) *DatabasesInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatabasesInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatabasesInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.database)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/databases")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.databases.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.databases.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DatabasesInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.databases.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DatabasesListCall struct {
	s            *Service
	project      string
	instance     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists databases in the specified Cloud SQL instance.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *DatabasesService) List(project string, instance string) *DatabasesListCall {
	c := &DatabasesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatabasesListCall) Fields(s ...googleapi.Field) *DatabasesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *DatabasesListCall) IfNoneMatch(entityTag string) *DatabasesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatabasesListCall) Context(ctx context.Context) *DatabasesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatabasesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatabasesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/databases")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.databases.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.databases.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *DatabasesListResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *DatabasesListCall) Do(opts ...googleapi.CallOption) (*DatabasesListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DatabasesListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.databases.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DatabasesPatchCall struct {
	s          *Service
	project    string
	instance   string
	database   string
	database2  *Database
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Partially updates a resource containing information about a database
// inside a Cloud SQL instance. This method supports patch semantics.
//
// - database: Name of the database to be updated in the instance.
// - instance: Database instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *DatabasesService) Patch(project string, instance string, database string, database2 *Database) *DatabasesPatchCall {
	c := &DatabasesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.database = database
	c.database2 = database2
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatabasesPatchCall) Fields(s ...googleapi.Field) *DatabasesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatabasesPatchCall) Context(ctx context.Context) *DatabasesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatabasesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatabasesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.database2)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/databases/{database}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
		"database": c.database,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.databases.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.databases.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DatabasesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.databases.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type DatabasesUpdateCall struct {
	s          *Service
	project    string
	instance   string
	database   string
	database2  *Database
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates a resource containing information about a database inside a
// Cloud SQL instance.
//
// - database: Name of the database to be updated in the instance.
// - instance: Database instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *DatabasesService) Update(project string, instance string, database string, database2 *Database) *DatabasesUpdateCall {
	c := &DatabasesUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.database = database
	c.database2 = database2
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *DatabasesUpdateCall) Fields(s ...googleapi.Field) *DatabasesUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *DatabasesUpdateCall) Context(ctx context.Context) *DatabasesUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *DatabasesUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *DatabasesUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.database2)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/databases/{database}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
		"database": c.database,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.databases.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.databases.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *DatabasesUpdateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.databases.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type FlagsListCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all available database flags for Cloud SQL instances.
func (r *FlagsService) List() *FlagsListCall {
	c := &FlagsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// DatabaseVersion sets the optional parameter "databaseVersion": Database type
// and version you want to retrieve flags for. By default, this method returns
// flags for all database types and versions.
func (c *FlagsListCall) DatabaseVersion(databaseVersion string) *FlagsListCall {
	c.urlParams_.Set("databaseVersion", databaseVersion)
	return c
}

// FlagScope sets the optional parameter "flagScope": Specify the scope of
// flags to be returned by SqlFlagsListService. Return list of database flags
// if unspecified.
//
// Possible values:
//
//	"SQL_FLAG_SCOPE_UNSPECIFIED" - Assume database flags if unspecified
//	"SQL_FLAG_SCOPE_DATABASE" - database flags
//	"SQL_FLAG_SCOPE_CONNECTION_POOL" - connection pool configuration flags
func (c *FlagsListCall) FlagScope(flagScope string) *FlagsListCall {
	c.urlParams_.Set("flagScope", flagScope)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *FlagsListCall) Fields(s ...googleapi.Field) *FlagsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *FlagsListCall) IfNoneMatch(entityTag string) *FlagsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *FlagsListCall) Context(ctx context.Context) *FlagsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *FlagsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *FlagsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/flags")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.flags.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.flags.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *FlagsListResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *FlagsListCall) Do(opts ...googleapi.CallOption) (*FlagsListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &FlagsListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.flags.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesListEntraIdCertificatesCall struct {
	s            *Service
	project      string
	instance     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListEntraIdCertificates: Lists all versions of EntraID certificates for the
// specified instance. There can be up to three sets of certificates listed:
// the certificate that is currently in use, a future that has been added but
// not yet used to sign a certificate, and a certificate that has been rotated
// out.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *InstancesService) ListEntraIdCertificates(project string, instance string) *InstancesListEntraIdCertificatesCall {
	c := &InstancesListEntraIdCertificatesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesListEntraIdCertificatesCall) Fields(s ...googleapi.Field) *InstancesListEntraIdCertificatesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *InstancesListEntraIdCertificatesCall) IfNoneMatch(entityTag string) *InstancesListEntraIdCertificatesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesListEntraIdCertificatesCall) Context(ctx context.Context) *InstancesListEntraIdCertificatesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesListEntraIdCertificatesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesListEntraIdCertificatesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/listEntraIdCertificates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.ListEntraIdCertificates", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.ListEntraIdCertificates" call.
// Any non-2xx status code is an error. Response headers are in either
// *InstancesListEntraIdCertificatesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *InstancesListEntraIdCertificatesCall) Do(opts ...googleapi.CallOption) (*InstancesListEntraIdCertificatesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InstancesListEntraIdCertificatesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.ListEntraIdCertificates", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesListServerCertificatesCall struct {
	s            *Service
	project      string
	instance     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListServerCertificates: Lists all versions of server certificates and
// certificate authorities (CAs) for the specified instance. There can be up to
// three sets of certs listed: the certificate that is currently in use, a
// future that has been added but not yet used to sign a certificate, and a
// certificate that has been rotated out. For instances not using Certificate
// Authority Service (CAS) server CA, use ListServerCas instead.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *InstancesService) ListServerCertificates(project string, instance string) *InstancesListServerCertificatesCall {
	c := &InstancesListServerCertificatesCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesListServerCertificatesCall) Fields(s ...googleapi.Field) *InstancesListServerCertificatesCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *InstancesListServerCertificatesCall) IfNoneMatch(entityTag string) *InstancesListServerCertificatesCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesListServerCertificatesCall) Context(ctx context.Context) *InstancesListServerCertificatesCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesListServerCertificatesCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesListServerCertificatesCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/listServerCertificates")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.ListServerCertificates", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.ListServerCertificates" call.
// Any non-2xx status code is an error. Response headers are in either
// *InstancesListServerCertificatesResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *InstancesListServerCertificatesCall) Do(opts ...googleapi.CallOption) (*InstancesListServerCertificatesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InstancesListServerCertificatesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.ListServerCertificates", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesRotateEntraIdCertificateCall struct {
	s                                        *Service
	project                                  string
	instance                                 string
	instancesrotateentraidcertificaterequest *InstancesRotateEntraIdCertificateRequest
	urlParams_                               gensupport.URLParams
	ctx_                                     context.Context
	header_                                  http.Header
}

// RotateEntraIdCertificate: Rotates the Entra Id certificate version to one
// previously added with the addEntraIdCertificate method.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *InstancesService) RotateEntraIdCertificate(project string, instance string, instancesrotateentraidcertificaterequest *InstancesRotateEntraIdCertificateRequest) *InstancesRotateEntraIdCertificateCall {
	c := &InstancesRotateEntraIdCertificateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.instancesrotateentraidcertificaterequest = instancesrotateentraidcertificaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesRotateEntraIdCertificateCall) Fields(s ...googleapi.Field) *InstancesRotateEntraIdCertificateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesRotateEntraIdCertificateCall) Context(ctx context.Context) *InstancesRotateEntraIdCertificateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesRotateEntraIdCertificateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesRotateEntraIdCertificateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instancesrotateentraidcertificaterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/rotateEntraIdCertificate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.RotateEntraIdCertificate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.RotateEntraIdCertificate" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesRotateEntraIdCertificateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.RotateEntraIdCertificate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesRotateServerCertificateCall struct {
	s                                       *Service
	project                                 string
	instance                                string
	instancesrotateservercertificaterequest *InstancesRotateServerCertificateRequest
	urlParams_                              gensupport.URLParams
	ctx_                                    context.Context
	header_                                 http.Header
}

// RotateServerCertificate: Rotates the server certificate version to one
// previously added with the addServerCertificate method. For instances not
// using Certificate Authority Service (CAS) server CA, use RotateServerCa
// instead.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *InstancesService) RotateServerCertificate(project string, instance string, instancesrotateservercertificaterequest *InstancesRotateServerCertificateRequest) *InstancesRotateServerCertificateCall {
	c := &InstancesRotateServerCertificateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.instancesrotateservercertificaterequest = instancesrotateservercertificaterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesRotateServerCertificateCall) Fields(s ...googleapi.Field) *InstancesRotateServerCertificateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesRotateServerCertificateCall) Context(ctx context.Context) *InstancesRotateServerCertificateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesRotateServerCertificateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesRotateServerCertificateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instancesrotateservercertificaterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/rotateServerCertificate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.RotateServerCertificate", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.RotateServerCertificate" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesRotateServerCertificateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.RotateServerCertificate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesAcquireSsrsLeaseCall struct {
	s                                *Service
	project                          string
	instance                         string
	instancesacquiressrsleaserequest *InstancesAcquireSsrsLeaseRequest
	urlParams_                       gensupport.URLParams
	ctx_                             context.Context
	header_                          http.Header
}

// AcquireSsrsLease: Acquire a lease for the setup of SQL Server Reporting
// Services (SSRS).
//
//   - instance: Cloud SQL instance ID. This doesn't include the project ID. It's
//     composed of lowercase letters, numbers, and hyphens, and it must start
//     with a letter. The total length must be 98 characters or less (Example:
//     instance-id).
//   - project: ID of the project that contains the instance (Example:
//     project-id).
func (r *InstancesService) AcquireSsrsLease(project string, instance string, instancesacquiressrsleaserequest *InstancesAcquireSsrsLeaseRequest) *InstancesAcquireSsrsLeaseCall {
	c := &InstancesAcquireSsrsLeaseCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.instancesacquiressrsleaserequest = instancesacquiressrsleaserequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesAcquireSsrsLeaseCall) Fields(s ...googleapi.Field) *InstancesAcquireSsrsLeaseCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesAcquireSsrsLeaseCall) Context(ctx context.Context) *InstancesAcquireSsrsLeaseCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesAcquireSsrsLeaseCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesAcquireSsrsLeaseCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instancesacquiressrsleaserequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/acquireSsrsLease")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.acquireSsrsLease", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.acquireSsrsLease" call.
// Any non-2xx status code is an error. Response headers are in either
// *SqlInstancesAcquireSsrsLeaseResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *InstancesAcquireSsrsLeaseCall) Do(opts ...googleapi.CallOption) (*SqlInstancesAcquireSsrsLeaseResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SqlInstancesAcquireSsrsLeaseResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.acquireSsrsLease", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesAddEntraIdCertificateCall struct {
	s          *Service
	project    string
	instance   string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// AddEntraIdCertificate: Adds a new Entra ID certificate for the specified
// instance. If an Entra ID certificate was previously added but never used in
// a certificate rotation, this operation replaces that version.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *InstancesService) AddEntraIdCertificate(project string, instance string) *InstancesAddEntraIdCertificateCall {
	c := &InstancesAddEntraIdCertificateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesAddEntraIdCertificateCall) Fields(s ...googleapi.Field) *InstancesAddEntraIdCertificateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesAddEntraIdCertificateCall) Context(ctx context.Context) *InstancesAddEntraIdCertificateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesAddEntraIdCertificateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesAddEntraIdCertificateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/addEntraIdCertificate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.addEntraIdCertificate", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.addEntraIdCertificate" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesAddEntraIdCertificateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.addEntraIdCertificate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesAddServerCaCall struct {
	s          *Service
	project    string
	instance   string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// AddServerCa: Add a new trusted Certificate Authority (CA) version for the
// specified instance. Required to prepare for a certificate rotation. If a CA
// version was previously added but never used in a certificate rotation, this
// operation replaces that version. There cannot be more than one CA version
// waiting to be rotated in. For instances that have enabled Certificate
// Authority Service (CAS) based server CA, use AddServerCertificate to add a
// new server certificate.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *InstancesService) AddServerCa(project string, instance string) *InstancesAddServerCaCall {
	c := &InstancesAddServerCaCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesAddServerCaCall) Fields(s ...googleapi.Field) *InstancesAddServerCaCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesAddServerCaCall) Context(ctx context.Context) *InstancesAddServerCaCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesAddServerCaCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesAddServerCaCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/addServerCa")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.addServerCa", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.addServerCa" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesAddServerCaCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.addServerCa", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesAddServerCertificateCall struct {
	s          *Service
	project    string
	instance   string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// AddServerCertificate: Add a new trusted server certificate version for the
// specified instance using Certificate Authority Service (CAS) server CA.
// Required to prepare for a certificate rotation. If a server certificate
// version was previously added but never used in a certificate rotation, this
// operation replaces that version. There cannot be more than one certificate
// version waiting to be rotated in. For instances not using CAS server CA, use
// AddServerCa instead.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *InstancesService) AddServerCertificate(project string, instance string) *InstancesAddServerCertificateCall {
	c := &InstancesAddServerCertificateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesAddServerCertificateCall) Fields(s ...googleapi.Field) *InstancesAddServerCertificateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesAddServerCertificateCall) Context(ctx context.Context) *InstancesAddServerCertificateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesAddServerCertificateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesAddServerCertificateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/addServerCertificate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.addServerCertificate", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.addServerCertificate" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesAddServerCertificateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.addServerCertificate", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesCloneCall struct {
	s                     *Service
	project               string
	instance              string
	instancesclonerequest *InstancesCloneRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Clone: Creates a Cloud SQL instance as a clone of the source instance. Using
// this operation might cause your instance to restart.
//
//   - instance: The ID of the Cloud SQL instance to be cloned (source). This
//     does not include the project ID.
//   - project: Project ID of the source as well as the clone Cloud SQL instance.
func (r *InstancesService) Clone(project string, instance string, instancesclonerequest *InstancesCloneRequest) *InstancesCloneCall {
	c := &InstancesCloneCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.instancesclonerequest = instancesclonerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesCloneCall) Fields(s ...googleapi.Field) *InstancesCloneCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesCloneCall) Context(ctx context.Context) *InstancesCloneCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesCloneCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesCloneCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instancesclonerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/clone")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.clone", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.clone" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesCloneCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.clone", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesDeleteCall struct {
	s          *Service
	project    string
	instance   string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a Cloud SQL instance.
//
//   - instance: Cloud SQL instance ID. This does not include the project ID.
//   - project: Project ID of the project that contains the instance to be
//     deleted.
func (r *InstancesService) Delete(project string, instance string) *InstancesDeleteCall {
	c := &InstancesDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// EnableFinalBackup sets the optional parameter "enableFinalBackup": Flag to
// opt-in for final backup. By default, it is turned off.
func (c *InstancesDeleteCall) EnableFinalBackup(enableFinalBackup bool) *InstancesDeleteCall {
	c.urlParams_.Set("enableFinalBackup", fmt.Sprint(enableFinalBackup))
	return c
}

// FinalBackupDescription sets the optional parameter "finalBackupDescription":
// The description of the final backup.
func (c *InstancesDeleteCall) FinalBackupDescription(finalBackupDescription string) *InstancesDeleteCall {
	c.urlParams_.Set("finalBackupDescription", finalBackupDescription)
	return c
}

// FinalBackupExpiryTime sets the optional parameter "finalBackupExpiryTime":
// Final Backup expiration time. Timestamp in UTC of when this resource is
// considered expired.
func (c *InstancesDeleteCall) FinalBackupExpiryTime(finalBackupExpiryTime string) *InstancesDeleteCall {
	c.urlParams_.Set("finalBackupExpiryTime", finalBackupExpiryTime)
	return c
}

// FinalBackupTtlDays sets the optional parameter "finalBackupTtlDays":
// Retention period of the final backup.
func (c *InstancesDeleteCall) FinalBackupTtlDays(finalBackupTtlDays int64) *InstancesDeleteCall {
	c.urlParams_.Set("finalBackupTtlDays", fmt.Sprint(finalBackupTtlDays))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesDeleteCall) Fields(s ...googleapi.Field) *InstancesDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesDeleteCall) Context(ctx context.Context) *InstancesDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesDemoteCall struct {
	s                      *Service
	project                string
	instance               string
	instancesdemoterequest *InstancesDemoteRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Demote: Demotes an existing standalone instance to be a Cloud SQL read
// replica for an external database server.
//
// - instance: The name of the Cloud SQL instance.
// - project: The project ID of the project that contains the instance.
func (r *InstancesService) Demote(project string, instance string, instancesdemoterequest *InstancesDemoteRequest) *InstancesDemoteCall {
	c := &InstancesDemoteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.instancesdemoterequest = instancesdemoterequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesDemoteCall) Fields(s ...googleapi.Field) *InstancesDemoteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesDemoteCall) Context(ctx context.Context) *InstancesDemoteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesDemoteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesDemoteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instancesdemoterequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/demote")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.demote", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.demote" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesDemoteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.demote", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesDemoteMasterCall struct {
	s                            *Service
	project                      string
	instance                     string
	instancesdemotemasterrequest *InstancesDemoteMasterRequest
	urlParams_                   gensupport.URLParams
	ctx_                         context.Context
	header_                      http.Header
}

// DemoteMaster: Demotes the stand-alone instance to be a Cloud SQL read
// replica for an external database server.
//
// - instance: Cloud SQL instance name.
// - project: ID of the project that contains the instance.
func (r *InstancesService) DemoteMaster(project string, instance string, instancesdemotemasterrequest *InstancesDemoteMasterRequest) *InstancesDemoteMasterCall {
	c := &InstancesDemoteMasterCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.instancesdemotemasterrequest = instancesdemotemasterrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesDemoteMasterCall) Fields(s ...googleapi.Field) *InstancesDemoteMasterCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesDemoteMasterCall) Context(ctx context.Context) *InstancesDemoteMasterCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesDemoteMasterCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesDemoteMasterCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instancesdemotemasterrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/demoteMaster")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.demoteMaster", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.demoteMaster" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesDemoteMasterCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.demoteMaster", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesExecuteSqlCall struct {
	s                 *Service
	project           string
	instance          string
	executesqlpayload *ExecuteSqlPayload
	urlParams_        gensupport.URLParams
	ctx_              context.Context
	header_           http.Header
}

// ExecuteSql: Execute SQL statements.
//
// - instance: Database instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *InstancesService) ExecuteSql(project string, instance string, executesqlpayload *ExecuteSqlPayload) *InstancesExecuteSqlCall {
	c := &InstancesExecuteSqlCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.executesqlpayload = executesqlpayload
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesExecuteSqlCall) Fields(s ...googleapi.Field) *InstancesExecuteSqlCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesExecuteSqlCall) Context(ctx context.Context) *InstancesExecuteSqlCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesExecuteSqlCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesExecuteSqlCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.executesqlpayload)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/executeSql")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.executeSql", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.executeSql" call.
// Any non-2xx status code is an error. Response headers are in either
// *SqlInstancesExecuteSqlResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *InstancesExecuteSqlCall) Do(opts ...googleapi.CallOption) (*SqlInstancesExecuteSqlResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SqlInstancesExecuteSqlResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.executeSql", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesExportCall struct {
	s                      *Service
	project                string
	instance               string
	instancesexportrequest *InstancesExportRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Export: Exports data from a Cloud SQL instance to a Cloud Storage bucket as
// a SQL dump or CSV file.
//
//   - instance: The Cloud SQL instance ID. This doesn't include the project ID.
//   - project: Project ID of the project that contains the instance to be
//     exported.
func (r *InstancesService) Export(project string, instance string, instancesexportrequest *InstancesExportRequest) *InstancesExportCall {
	c := &InstancesExportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.instancesexportrequest = instancesexportrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesExportCall) Fields(s ...googleapi.Field) *InstancesExportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesExportCall) Context(ctx context.Context) *InstancesExportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesExportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesExportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instancesexportrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/export")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.export", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.export" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesExportCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.export", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesFailoverCall struct {
	s                        *Service
	project                  string
	instance                 string
	instancesfailoverrequest *InstancesFailoverRequest
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// Failover: Initiates a manual failover of a high availability (HA) primary
// instance to a standby instance, which becomes the primary instance. Users
// are then rerouted to the new primary. For more information, see the Overview
// of high availability
// (https://cloud.google.com/sql/docs/mysql/high-availability) page in the
// Cloud SQL documentation. If using Legacy HA (MySQL only), this causes the
// instance to failover to its failover replica instance.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: ID of the project that contains the read replica.
func (r *InstancesService) Failover(project string, instance string, instancesfailoverrequest *InstancesFailoverRequest) *InstancesFailoverCall {
	c := &InstancesFailoverCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.instancesfailoverrequest = instancesfailoverrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesFailoverCall) Fields(s ...googleapi.Field) *InstancesFailoverCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesFailoverCall) Context(ctx context.Context) *InstancesFailoverCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesFailoverCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesFailoverCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instancesfailoverrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/failover")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.failover", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.failover" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesFailoverCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.failover", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesGetCall struct {
	s            *Service
	project      string
	instance     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a resource containing information about a Cloud SQL instance.
//
// - instance: Database instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *InstancesService) Get(project string, instance string) *InstancesGetCall {
	c := &InstancesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesGetCall) Fields(s ...googleapi.Field) *InstancesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *InstancesGetCall) IfNoneMatch(entityTag string) *InstancesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesGetCall) Context(ctx context.Context) *InstancesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *DatabaseInstance.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *InstancesGetCall) Do(opts ...googleapi.CallOption) (*DatabaseInstance, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &DatabaseInstance{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesImportCall struct {
	s                      *Service
	project                string
	instance               string
	instancesimportrequest *InstancesImportRequest
	urlParams_             gensupport.URLParams
	ctx_                   context.Context
	header_                http.Header
}

// Import: Imports data into a Cloud SQL instance from a SQL dump or CSV file
// in Cloud Storage.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *InstancesService) Import(project string, instance string, instancesimportrequest *InstancesImportRequest) *InstancesImportCall {
	c := &InstancesImportCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.instancesimportrequest = instancesimportrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesImportCall) Fields(s ...googleapi.Field) *InstancesImportCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesImportCall) Context(ctx context.Context) *InstancesImportCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesImportCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesImportCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instancesimportrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/import")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.import", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.import" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesImportCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.import", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesInsertCall struct {
	s                *Service
	project          string
	databaseinstance *DatabaseInstance
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Insert: Creates a new Cloud SQL instance.
//
//   - project: Project ID of the project to which the newly created Cloud SQL
//     instances should belong.
func (r *InstancesService) Insert(project string, databaseinstance *DatabaseInstance) *InstancesInsertCall {
	c := &InstancesInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.databaseinstance = databaseinstance
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesInsertCall) Fields(s ...googleapi.Field) *InstancesInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesInsertCall) Context(ctx context.Context) *InstancesInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.databaseinstance)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesListCall struct {
	s            *Service
	project      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists instances under a given project.
//
// - project: Project ID of the project for which to list Cloud SQL instances.
func (r *InstancesService) List(project string) *InstancesListCall {
	c := &InstancesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	return c
}

// Filter sets the optional parameter "filter": A filter expression that
// filters resources listed in the response. The expression is in the form of
// field:value. For example, 'instanceType:CLOUD_SQL_INSTANCE'. Fields can be
// nested as needed as per their JSON representation, such as
// 'settings.userLabels.auto_start:true'. Multiple filter queries are
// space-separated. For example. 'state:RUNNABLE
// instanceType:CLOUD_SQL_INSTANCE'. By default, each expression is an AND
// expression. However, you can include AND and OR expressions explicitly.
func (c *InstancesListCall) Filter(filter string) *InstancesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// MaxResults sets the optional parameter "maxResults": The maximum number of
// instances to return. The service may return fewer than this value. If
// unspecified, at most 500 instances are returned. The maximum value is 1000;
// values above 1000 are coerced to 1000.
func (c *InstancesListCall) MaxResults(maxResults int64) *InstancesListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": A previously-returned
// page token representing part of the larger set of results to view.
func (c *InstancesListCall) PageToken(pageToken string) *InstancesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesListCall) Fields(s ...googleapi.Field) *InstancesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *InstancesListCall) IfNoneMatch(entityTag string) *InstancesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesListCall) Context(ctx context.Context) *InstancesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *InstancesListResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *InstancesListCall) Do(opts ...googleapi.CallOption) (*InstancesListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InstancesListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *InstancesListCall) Pages(ctx context.Context, f func(*InstancesListResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type InstancesListServerCasCall struct {
	s            *Service
	project      string
	instance     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// ListServerCas: Lists all of the trusted Certificate Authorities (CAs) for
// the specified instance. There can be up to three CAs listed: the CA that was
// used to sign the certificate that is currently in use, a CA that has been
// added but not yet used to sign a certificate, and a CA used to sign a
// certificate that has previously rotated out.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *InstancesService) ListServerCas(project string, instance string) *InstancesListServerCasCall {
	c := &InstancesListServerCasCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesListServerCasCall) Fields(s ...googleapi.Field) *InstancesListServerCasCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *InstancesListServerCasCall) IfNoneMatch(entityTag string) *InstancesListServerCasCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesListServerCasCall) Context(ctx context.Context) *InstancesListServerCasCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesListServerCasCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesListServerCasCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/listServerCas")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.listServerCas", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.listServerCas" call.
// Any non-2xx status code is an error. Response headers are in either
// *InstancesListServerCasResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *InstancesListServerCasCall) Do(opts ...googleapi.CallOption) (*InstancesListServerCasResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &InstancesListServerCasResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.listServerCas", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesPatchCall struct {
	s                *Service
	project          string
	instance         string
	databaseinstance *DatabaseInstance
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Patch: Partially updates settings of a Cloud SQL instance by merging the
// request with the current configuration. This method supports patch
// semantics.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *InstancesService) Patch(project string, instance string, databaseinstance *DatabaseInstance) *InstancesPatchCall {
	c := &InstancesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.databaseinstance = databaseinstance
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesPatchCall) Fields(s ...googleapi.Field) *InstancesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesPatchCall) Context(ctx context.Context) *InstancesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.databaseinstance)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.patch", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.patch" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesPatchCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.patch", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesPointInTimeRestoreCall struct {
	s                         *Service
	parent                    string
	pointintimerestorecontext *PointInTimeRestoreContext
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// PointInTimeRestore: Point in time restore for an instance managed by Google
// Cloud Backup and Disaster Recovery.
//
//   - parent: The parent resource where you created this instance. Format:
//     projects/{project}.
func (r *InstancesService) PointInTimeRestore(parent string, pointintimerestorecontext *PointInTimeRestoreContext) *InstancesPointInTimeRestoreCall {
	c := &InstancesPointInTimeRestoreCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.pointintimerestorecontext = pointintimerestorecontext
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesPointInTimeRestoreCall) Fields(s ...googleapi.Field) *InstancesPointInTimeRestoreCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesPointInTimeRestoreCall) Context(ctx context.Context) *InstancesPointInTimeRestoreCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesPointInTimeRestoreCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesPointInTimeRestoreCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.pointintimerestorecontext)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/{+parent}:pointInTimeRestore")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.pointInTimeRestore", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.pointInTimeRestore" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesPointInTimeRestoreCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.pointInTimeRestore", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesPreCheckMajorVersionUpgradeCall struct {
	s                                           *Service
	project                                     string
	instance                                    string
	instancesprecheckmajorversionupgraderequest *InstancesPreCheckMajorVersionUpgradeRequest
	urlParams_                                  gensupport.URLParams
	ctx_                                        context.Context
	header_                                     http.Header
}

// PreCheckMajorVersionUpgrade: Execute MVU Pre-checks
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *InstancesService) PreCheckMajorVersionUpgrade(project string, instance string, instancesprecheckmajorversionupgraderequest *InstancesPreCheckMajorVersionUpgradeRequest) *InstancesPreCheckMajorVersionUpgradeCall {
	c := &InstancesPreCheckMajorVersionUpgradeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.instancesprecheckmajorversionupgraderequest = instancesprecheckmajorversionupgraderequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesPreCheckMajorVersionUpgradeCall) Fields(s ...googleapi.Field) *InstancesPreCheckMajorVersionUpgradeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesPreCheckMajorVersionUpgradeCall) Context(ctx context.Context) *InstancesPreCheckMajorVersionUpgradeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesPreCheckMajorVersionUpgradeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesPreCheckMajorVersionUpgradeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instancesprecheckmajorversionupgraderequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/preCheckMajorVersionUpgrade")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.preCheckMajorVersionUpgrade", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.preCheckMajorVersionUpgrade" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesPreCheckMajorVersionUpgradeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.preCheckMajorVersionUpgrade", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesPromoteReplicaCall struct {
	s          *Service
	project    string
	instance   string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// PromoteReplica: Promotes the read replica instance to be an independent
// Cloud SQL primary instance. Using this operation might cause your instance
// to restart.
//
// - instance: Cloud SQL read replica instance name.
// - project: ID of the project that contains the read replica.
func (r *InstancesService) PromoteReplica(project string, instance string) *InstancesPromoteReplicaCall {
	c := &InstancesPromoteReplicaCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// Failover sets the optional parameter "failover": Set to true to invoke a
// replica failover to the DR replica. As part of replica failover, the promote
// operation attempts to add the original primary instance as a replica of the
// promoted DR replica when the original primary instance comes back online. If
// set to false or not specified, then the original primary instance becomes an
// independent Cloud SQL primary instance.
func (c *InstancesPromoteReplicaCall) Failover(failover bool) *InstancesPromoteReplicaCall {
	c.urlParams_.Set("failover", fmt.Sprint(failover))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesPromoteReplicaCall) Fields(s ...googleapi.Field) *InstancesPromoteReplicaCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesPromoteReplicaCall) Context(ctx context.Context) *InstancesPromoteReplicaCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesPromoteReplicaCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesPromoteReplicaCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/promoteReplica")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.promoteReplica", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.promoteReplica" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesPromoteReplicaCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.promoteReplica", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesReencryptCall struct {
	s                         *Service
	project                   string
	instance                  string
	instancesreencryptrequest *InstancesReencryptRequest
	urlParams_                gensupport.URLParams
	ctx_                      context.Context
	header_                   http.Header
}

// Reencrypt: Reencrypt CMEK instance with latest key version.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: ID of the project that contains the instance.
func (r *InstancesService) Reencrypt(project string, instance string, instancesreencryptrequest *InstancesReencryptRequest) *InstancesReencryptCall {
	c := &InstancesReencryptCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.instancesreencryptrequest = instancesreencryptrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesReencryptCall) Fields(s ...googleapi.Field) *InstancesReencryptCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesReencryptCall) Context(ctx context.Context) *InstancesReencryptCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesReencryptCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesReencryptCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instancesreencryptrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/reencrypt")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.reencrypt", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.reencrypt" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesReencryptCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.reencrypt", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesReleaseSsrsLeaseCall struct {
	s          *Service
	project    string
	instance   string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// ReleaseSsrsLease: Release a lease for the setup of SQL Server Reporting
// Services (SSRS).
//
//   - instance: The Cloud SQL instance ID. This doesn't include the project ID.
//     It's composed of lowercase letters, numbers, and hyphens, and it must
//     start with a letter. The total length must be 98 characters or less
//     (Example: instance-id).
//   - project: The ID of the project that contains the instance (Example:
//     project-id).
func (r *InstancesService) ReleaseSsrsLease(project string, instance string) *InstancesReleaseSsrsLeaseCall {
	c := &InstancesReleaseSsrsLeaseCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesReleaseSsrsLeaseCall) Fields(s ...googleapi.Field) *InstancesReleaseSsrsLeaseCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesReleaseSsrsLeaseCall) Context(ctx context.Context) *InstancesReleaseSsrsLeaseCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesReleaseSsrsLeaseCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesReleaseSsrsLeaseCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/releaseSsrsLease")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.releaseSsrsLease", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.releaseSsrsLease" call.
// Any non-2xx status code is an error. Response headers are in either
// *SqlInstancesReleaseSsrsLeaseResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *InstancesReleaseSsrsLeaseCall) Do(opts ...googleapi.CallOption) (*SqlInstancesReleaseSsrsLeaseResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SqlInstancesReleaseSsrsLeaseResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.releaseSsrsLease", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesResetSslConfigCall struct {
	s          *Service
	project    string
	instance   string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// ResetSslConfig: Deletes all client certificates and generates a new server
// SSL certificate for the instance.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *InstancesService) ResetSslConfig(project string, instance string) *InstancesResetSslConfigCall {
	c := &InstancesResetSslConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// Mode sets the optional parameter "mode": Reset SSL mode to use.
//
// Possible values:
//
//	"RESET_SSL_MODE_UNSPECIFIED" - Reset SSL mode is not specified.
//	"ALL" - Refresh all TLS configs. This is the default behaviour.
//	"SYNC_FROM_PRIMARY" - Refreshes the replication-related TLS configuration
//
// settings provided by the primary instance. Not applicable to on-premises
// replication instances.
func (c *InstancesResetSslConfigCall) Mode(mode string) *InstancesResetSslConfigCall {
	c.urlParams_.Set("mode", mode)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesResetSslConfigCall) Fields(s ...googleapi.Field) *InstancesResetSslConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesResetSslConfigCall) Context(ctx context.Context) *InstancesResetSslConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesResetSslConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesResetSslConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/resetSslConfig")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.resetSslConfig", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.resetSslConfig" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesResetSslConfigCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.resetSslConfig", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesRestartCall struct {
	s          *Service
	project    string
	instance   string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Restart: Restarts a Cloud SQL instance.
//
//   - instance: Cloud SQL instance ID. This does not include the project ID.
//   - project: Project ID of the project that contains the instance to be
//     restarted.
func (r *InstancesService) Restart(project string, instance string) *InstancesRestartCall {
	c := &InstancesRestartCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesRestartCall) Fields(s ...googleapi.Field) *InstancesRestartCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesRestartCall) Context(ctx context.Context) *InstancesRestartCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesRestartCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesRestartCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/restart")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.restart", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.restart" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesRestartCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.restart", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesRestoreBackupCall struct {
	s                             *Service
	project                       string
	instance                      string
	instancesrestorebackuprequest *InstancesRestoreBackupRequest
	urlParams_                    gensupport.URLParams
	ctx_                          context.Context
	header_                       http.Header
}

// RestoreBackup: Restores a backup of a Cloud SQL instance. Using this
// operation might cause your instance to restart.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *InstancesService) RestoreBackup(project string, instance string, instancesrestorebackuprequest *InstancesRestoreBackupRequest) *InstancesRestoreBackupCall {
	c := &InstancesRestoreBackupCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.instancesrestorebackuprequest = instancesrestorebackuprequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesRestoreBackupCall) Fields(s ...googleapi.Field) *InstancesRestoreBackupCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesRestoreBackupCall) Context(ctx context.Context) *InstancesRestoreBackupCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesRestoreBackupCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesRestoreBackupCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instancesrestorebackuprequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/restoreBackup")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.restoreBackup", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.restoreBackup" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesRestoreBackupCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.restoreBackup", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesRotateServerCaCall struct {
	s                              *Service
	project                        string
	instance                       string
	instancesrotateservercarequest *InstancesRotateServerCaRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// RotateServerCa: Rotates the server certificate to one signed by the
// Certificate Authority (CA) version previously added with the addServerCA
// method. For instances that have enabled Certificate Authority Service (CAS)
// based server CA, use RotateServerCertificate to rotate the server
// certificate.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *InstancesService) RotateServerCa(project string, instance string, instancesrotateservercarequest *InstancesRotateServerCaRequest) *InstancesRotateServerCaCall {
	c := &InstancesRotateServerCaCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.instancesrotateservercarequest = instancesrotateservercarequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesRotateServerCaCall) Fields(s ...googleapi.Field) *InstancesRotateServerCaCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesRotateServerCaCall) Context(ctx context.Context) *InstancesRotateServerCaCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesRotateServerCaCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesRotateServerCaCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instancesrotateservercarequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/rotateServerCa")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.rotateServerCa", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.rotateServerCa" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesRotateServerCaCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.rotateServerCa", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesStartReplicaCall struct {
	s          *Service
	project    string
	instance   string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// StartReplica: Starts the replication in the read replica instance.
//
// - instance: Cloud SQL read replica instance name.
// - project: ID of the project that contains the read replica.
func (r *InstancesService) StartReplica(project string, instance string) *InstancesStartReplicaCall {
	c := &InstancesStartReplicaCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesStartReplicaCall) Fields(s ...googleapi.Field) *InstancesStartReplicaCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesStartReplicaCall) Context(ctx context.Context) *InstancesStartReplicaCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesStartReplicaCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesStartReplicaCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/startReplica")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.startReplica", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.startReplica" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesStartReplicaCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.startReplica", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesStopReplicaCall struct {
	s          *Service
	project    string
	instance   string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// StopReplica: Stops the replication in the read replica instance.
//
// - instance: Cloud SQL read replica instance name.
// - project: ID of the project that contains the read replica.
func (r *InstancesService) StopReplica(project string, instance string) *InstancesStopReplicaCall {
	c := &InstancesStopReplicaCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesStopReplicaCall) Fields(s ...googleapi.Field) *InstancesStopReplicaCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesStopReplicaCall) Context(ctx context.Context) *InstancesStopReplicaCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesStopReplicaCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesStopReplicaCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/stopReplica")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.stopReplica", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.stopReplica" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesStopReplicaCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.stopReplica", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesSwitchoverCall struct {
	s          *Service
	project    string
	instance   string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Switchover: Switches over from the primary instance to the DR replica
// instance.
//
// - instance: Cloud SQL read replica instance name.
// - project: ID of the project that contains the replica.
func (r *InstancesService) Switchover(project string, instance string) *InstancesSwitchoverCall {
	c := &InstancesSwitchoverCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// DbTimeout sets the optional parameter "dbTimeout": (MySQL and PostgreSQL
// only) Cloud SQL instance operations timeout, which is a sum of all database
// operations. Default value is 10 minutes and can be modified to a maximum
// value of 24 hours.
func (c *InstancesSwitchoverCall) DbTimeout(dbTimeout string) *InstancesSwitchoverCall {
	c.urlParams_.Set("dbTimeout", dbTimeout)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesSwitchoverCall) Fields(s ...googleapi.Field) *InstancesSwitchoverCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesSwitchoverCall) Context(ctx context.Context) *InstancesSwitchoverCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesSwitchoverCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesSwitchoverCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/switchover")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.switchover", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.switchover" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesSwitchoverCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.switchover", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesTruncateLogCall struct {
	s                           *Service
	project                     string
	instance                    string
	instancestruncatelogrequest *InstancesTruncateLogRequest
	urlParams_                  gensupport.URLParams
	ctx_                        context.Context
	header_                     http.Header
}

// TruncateLog: Truncate MySQL general and slow query log tables MySQL only.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the Cloud SQL project.
func (r *InstancesService) TruncateLog(project string, instance string, instancestruncatelogrequest *InstancesTruncateLogRequest) *InstancesTruncateLogCall {
	c := &InstancesTruncateLogCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.instancestruncatelogrequest = instancestruncatelogrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesTruncateLogCall) Fields(s ...googleapi.Field) *InstancesTruncateLogCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesTruncateLogCall) Context(ctx context.Context) *InstancesTruncateLogCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesTruncateLogCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesTruncateLogCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.instancestruncatelogrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/truncateLog")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.truncateLog", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.truncateLog" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesTruncateLogCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.truncateLog", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type InstancesUpdateCall struct {
	s                *Service
	project          string
	instance         string
	databaseinstance *DatabaseInstance
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Update: Updates settings of a Cloud SQL instance. Using this operation might
// cause your instance to restart.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *InstancesService) Update(project string, instance string, databaseinstance *DatabaseInstance) *InstancesUpdateCall {
	c := &InstancesUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.databaseinstance = databaseinstance
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *InstancesUpdateCall) Fields(s ...googleapi.Field) *InstancesUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *InstancesUpdateCall) Context(ctx context.Context) *InstancesUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *InstancesUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *InstancesUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.databaseinstance)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.instances.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.instances.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *InstancesUpdateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.instances.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OperationsCancelCall struct {
	s          *Service
	project    string
	operation  string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Cancel: Cancels an instance operation that has been performed on an
// instance. Ordinarily, this method name should be `CancelSqlOperation`.
//
// - operation: Instance operation ID.
// - project: Project ID of the project that contains the instance.
func (r *OperationsService) Cancel(project string, operation string) *OperationsCancelCall {
	c := &OperationsCancelCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.operation = operation
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OperationsCancelCall) Fields(s ...googleapi.Field) *OperationsCancelCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OperationsCancelCall) Context(ctx context.Context) *OperationsCancelCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OperationsCancelCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OperationsCancelCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/operations/{operation}/cancel")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":   c.project,
		"operation": c.operation,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.operations.cancel", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.operations.cancel" call.
// Any non-2xx status code is an error. Response headers are in either
// *Empty.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OperationsCancelCall) Do(opts ...googleapi.CallOption) (*Empty, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Empty{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.operations.cancel", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OperationsGetCall struct {
	s            *Service
	project      string
	operation    string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves an instance operation that has been performed on an instance.
//
// - operation: Instance operation ID.
// - project: Project ID of the project that contains the instance.
func (r *OperationsService) Get(project string, operation string) *OperationsGetCall {
	c := &OperationsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.operation = operation
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OperationsGetCall) Fields(s ...googleapi.Field) *OperationsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OperationsGetCall) IfNoneMatch(entityTag string) *OperationsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OperationsGetCall) Context(ctx context.Context) *OperationsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OperationsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OperationsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/operations/{operation}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":   c.project,
		"operation": c.operation,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.operations.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.operations.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *OperationsGetCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.operations.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type OperationsListCall struct {
	s            *Service
	project      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all instance operations that have been performed on the given
// Cloud SQL instance in the reverse chronological order of the start time.
//
// - project: Project ID of the project that contains the instance.
func (r *OperationsService) List(project string) *OperationsListCall {
	c := &OperationsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	return c
}

// Instance sets the optional parameter "instance": Cloud SQL instance ID. This
// does not include the project ID.
func (c *OperationsListCall) Instance(instance string) *OperationsListCall {
	c.urlParams_.Set("instance", instance)
	return c
}

// MaxResults sets the optional parameter "maxResults": Maximum number of
// operations per response.
func (c *OperationsListCall) MaxResults(maxResults int64) *OperationsListCall {
	c.urlParams_.Set("maxResults", fmt.Sprint(maxResults))
	return c
}

// PageToken sets the optional parameter "pageToken": A previously-returned
// page token representing part of the larger set of results to view.
func (c *OperationsListCall) PageToken(pageToken string) *OperationsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *OperationsListCall) Fields(s ...googleapi.Field) *OperationsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *OperationsListCall) IfNoneMatch(entityTag string) *OperationsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *OperationsListCall) Context(ctx context.Context) *OperationsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *OperationsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *OperationsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/operations")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.operations.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.operations.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *OperationsListResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *OperationsListCall) Do(opts ...googleapi.CallOption) (*OperationsListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &OperationsListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.operations.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *OperationsListCall) Pages(ctx context.Context, f func(*OperationsListResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken"))
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

type ProjectsInstancesGetDiskShrinkConfigCall struct {
	s            *Service
	project      string
	instance     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetDiskShrinkConfig: Get Disk Shrink Config for a given instance.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *ProjectsInstancesService) GetDiskShrinkConfig(project string, instance string) *ProjectsInstancesGetDiskShrinkConfigCall {
	c := &ProjectsInstancesGetDiskShrinkConfigCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsInstancesGetDiskShrinkConfigCall) Fields(s ...googleapi.Field) *ProjectsInstancesGetDiskShrinkConfigCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsInstancesGetDiskShrinkConfigCall) IfNoneMatch(entityTag string) *ProjectsInstancesGetDiskShrinkConfigCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsInstancesGetDiskShrinkConfigCall) Context(ctx context.Context) *ProjectsInstancesGetDiskShrinkConfigCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsInstancesGetDiskShrinkConfigCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsInstancesGetDiskShrinkConfigCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/getDiskShrinkConfig")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.projects.instances.getDiskShrinkConfig", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.projects.instances.getDiskShrinkConfig" call.
// Any non-2xx status code is an error. Response headers are in either
// *SqlInstancesGetDiskShrinkConfigResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsInstancesGetDiskShrinkConfigCall) Do(opts ...googleapi.CallOption) (*SqlInstancesGetDiskShrinkConfigResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SqlInstancesGetDiskShrinkConfigResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.projects.instances.getDiskShrinkConfig", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsInstancesGetLatestRecoveryTimeCall struct {
	s            *Service
	project      string
	instance     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// GetLatestRecoveryTime: Get Latest Recovery Time for a given instance.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *ProjectsInstancesService) GetLatestRecoveryTime(project string, instance string) *ProjectsInstancesGetLatestRecoveryTimeCall {
	c := &ProjectsInstancesGetLatestRecoveryTimeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// SourceInstanceDeletionTime sets the optional parameter
// "sourceInstanceDeletionTime": The timestamp used to identify the time when
// the source instance is deleted. If this instance is deleted, then you must
// set the timestamp.
func (c *ProjectsInstancesGetLatestRecoveryTimeCall) SourceInstanceDeletionTime(sourceInstanceDeletionTime string) *ProjectsInstancesGetLatestRecoveryTimeCall {
	c.urlParams_.Set("sourceInstanceDeletionTime", sourceInstanceDeletionTime)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsInstancesGetLatestRecoveryTimeCall) Fields(s ...googleapi.Field) *ProjectsInstancesGetLatestRecoveryTimeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *ProjectsInstancesGetLatestRecoveryTimeCall) IfNoneMatch(entityTag string) *ProjectsInstancesGetLatestRecoveryTimeCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsInstancesGetLatestRecoveryTimeCall) Context(ctx context.Context) *ProjectsInstancesGetLatestRecoveryTimeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsInstancesGetLatestRecoveryTimeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsInstancesGetLatestRecoveryTimeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/getLatestRecoveryTime")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.projects.instances.getLatestRecoveryTime", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.projects.instances.getLatestRecoveryTime" call.
// Any non-2xx status code is an error. Response headers are in either
// *SqlInstancesGetLatestRecoveryTimeResponse.ServerResponse.Header or (if a
// response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsInstancesGetLatestRecoveryTimeCall) Do(opts ...googleapi.CallOption) (*SqlInstancesGetLatestRecoveryTimeResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SqlInstancesGetLatestRecoveryTimeResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.projects.instances.getLatestRecoveryTime", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsInstancesPerformDiskShrinkCall struct {
	s                        *Service
	project                  string
	instance                 string
	performdiskshrinkcontext *PerformDiskShrinkContext
	urlParams_               gensupport.URLParams
	ctx_                     context.Context
	header_                  http.Header
}

// PerformDiskShrink: Perform Disk Shrink on primary instance.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *ProjectsInstancesService) PerformDiskShrink(project string, instance string, performdiskshrinkcontext *PerformDiskShrinkContext) *ProjectsInstancesPerformDiskShrinkCall {
	c := &ProjectsInstancesPerformDiskShrinkCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.performdiskshrinkcontext = performdiskshrinkcontext
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsInstancesPerformDiskShrinkCall) Fields(s ...googleapi.Field) *ProjectsInstancesPerformDiskShrinkCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsInstancesPerformDiskShrinkCall) Context(ctx context.Context) *ProjectsInstancesPerformDiskShrinkCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsInstancesPerformDiskShrinkCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsInstancesPerformDiskShrinkCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.performdiskshrinkcontext)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/performDiskShrink")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.projects.instances.performDiskShrink", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.projects.instances.performDiskShrink" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsInstancesPerformDiskShrinkCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.projects.instances.performDiskShrink", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsInstancesRescheduleMaintenanceCall struct {
	s                                            *Service
	project                                      string
	instance                                     string
	sqlinstancesreschedulemaintenancerequestbody *SqlInstancesRescheduleMaintenanceRequestBody
	urlParams_                                   gensupport.URLParams
	ctx_                                         context.Context
	header_                                      http.Header
}

// RescheduleMaintenance: Reschedules the maintenance on the given instance.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: ID of the project that contains the instance.
func (r *ProjectsInstancesService) RescheduleMaintenance(project string, instance string, sqlinstancesreschedulemaintenancerequestbody *SqlInstancesRescheduleMaintenanceRequestBody) *ProjectsInstancesRescheduleMaintenanceCall {
	c := &ProjectsInstancesRescheduleMaintenanceCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.sqlinstancesreschedulemaintenancerequestbody = sqlinstancesreschedulemaintenancerequestbody
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsInstancesRescheduleMaintenanceCall) Fields(s ...googleapi.Field) *ProjectsInstancesRescheduleMaintenanceCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsInstancesRescheduleMaintenanceCall) Context(ctx context.Context) *ProjectsInstancesRescheduleMaintenanceCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsInstancesRescheduleMaintenanceCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsInstancesRescheduleMaintenanceCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.sqlinstancesreschedulemaintenancerequestbody)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/rescheduleMaintenance")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.projects.instances.rescheduleMaintenance", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.projects.instances.rescheduleMaintenance" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsInstancesRescheduleMaintenanceCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.projects.instances.rescheduleMaintenance", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsInstancesResetReplicaSizeCall struct {
	s                                   *Service
	project                             string
	instance                            string
	sqlinstancesresetreplicasizerequest *SqlInstancesResetReplicaSizeRequest
	urlParams_                          gensupport.URLParams
	ctx_                                context.Context
	header_                             http.Header
}

// ResetReplicaSize: Reset Replica Size to primary instance disk size.
//
// - instance: Cloud SQL read replica instance name.
// - project: ID of the project that contains the read replica.
func (r *ProjectsInstancesService) ResetReplicaSize(project string, instance string, sqlinstancesresetreplicasizerequest *SqlInstancesResetReplicaSizeRequest) *ProjectsInstancesResetReplicaSizeCall {
	c := &ProjectsInstancesResetReplicaSizeCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.sqlinstancesresetreplicasizerequest = sqlinstancesresetreplicasizerequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsInstancesResetReplicaSizeCall) Fields(s ...googleapi.Field) *ProjectsInstancesResetReplicaSizeCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsInstancesResetReplicaSizeCall) Context(ctx context.Context) *ProjectsInstancesResetReplicaSizeCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsInstancesResetReplicaSizeCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsInstancesResetReplicaSizeCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.sqlinstancesresetreplicasizerequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/resetReplicaSize")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.projects.instances.resetReplicaSize", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.projects.instances.resetReplicaSize" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsInstancesResetReplicaSizeCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.projects.instances.resetReplicaSize", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsInstancesStartExternalSyncCall struct {
	s                                    *Service
	project                              string
	instance                             string
	sqlinstancesstartexternalsyncrequest *SqlInstancesStartExternalSyncRequest
	urlParams_                           gensupport.URLParams
	ctx_                                 context.Context
	header_                              http.Header
}

// StartExternalSync: Start External primary instance migration.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: ID of the project that contains the instance.
func (r *ProjectsInstancesService) StartExternalSync(project string, instance string, sqlinstancesstartexternalsyncrequest *SqlInstancesStartExternalSyncRequest) *ProjectsInstancesStartExternalSyncCall {
	c := &ProjectsInstancesStartExternalSyncCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.sqlinstancesstartexternalsyncrequest = sqlinstancesstartexternalsyncrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsInstancesStartExternalSyncCall) Fields(s ...googleapi.Field) *ProjectsInstancesStartExternalSyncCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsInstancesStartExternalSyncCall) Context(ctx context.Context) *ProjectsInstancesStartExternalSyncCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsInstancesStartExternalSyncCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsInstancesStartExternalSyncCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.sqlinstancesstartexternalsyncrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/startExternalSync")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.projects.instances.startExternalSync", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.projects.instances.startExternalSync" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *ProjectsInstancesStartExternalSyncCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.projects.instances.startExternalSync", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type ProjectsInstancesVerifyExternalSyncSettingsCall struct {
	s                                             *Service
	project                                       string
	instance                                      string
	sqlinstancesverifyexternalsyncsettingsrequest *SqlInstancesVerifyExternalSyncSettingsRequest
	urlParams_                                    gensupport.URLParams
	ctx_                                          context.Context
	header_                                       http.Header
}

// VerifyExternalSyncSettings: Verify External primary instance external sync
// settings.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *ProjectsInstancesService) VerifyExternalSyncSettings(project string, instance string, sqlinstancesverifyexternalsyncsettingsrequest *SqlInstancesVerifyExternalSyncSettingsRequest) *ProjectsInstancesVerifyExternalSyncSettingsCall {
	c := &ProjectsInstancesVerifyExternalSyncSettingsCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.sqlinstancesverifyexternalsyncsettingsrequest = sqlinstancesverifyexternalsyncsettingsrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *ProjectsInstancesVerifyExternalSyncSettingsCall) Fields(s ...googleapi.Field) *ProjectsInstancesVerifyExternalSyncSettingsCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *ProjectsInstancesVerifyExternalSyncSettingsCall) Context(ctx context.Context) *ProjectsInstancesVerifyExternalSyncSettingsCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *ProjectsInstancesVerifyExternalSyncSettingsCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *ProjectsInstancesVerifyExternalSyncSettingsCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.sqlinstancesverifyexternalsyncsettingsrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/verifyExternalSyncSettings")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.projects.instances.verifyExternalSyncSettings", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.projects.instances.verifyExternalSyncSettings" call.
// Any non-2xx status code is an error. Response headers are in either
// *SqlInstancesVerifyExternalSyncSettingsResponse.ServerResponse.Header or (if
// a response was returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *ProjectsInstancesVerifyExternalSyncSettingsCall) Do(opts ...googleapi.CallOption) (*SqlInstancesVerifyExternalSyncSettingsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SqlInstancesVerifyExternalSyncSettingsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.projects.instances.verifyExternalSyncSettings", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type SslCertsCreateEphemeralCall struct {
	s                              *Service
	project                        string
	instance                       string
	sslcertscreateephemeralrequest *SslCertsCreateEphemeralRequest
	urlParams_                     gensupport.URLParams
	ctx_                           context.Context
	header_                        http.Header
}

// CreateEphemeral: Generates a short-lived X509 certificate containing the
// provided public key and signed by a private key specific to the target
// instance. Users may use the certificate to authenticate as themselves when
// connecting to the database.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the Cloud SQL project.
func (r *SslCertsService) CreateEphemeral(project string, instance string, sslcertscreateephemeralrequest *SslCertsCreateEphemeralRequest) *SslCertsCreateEphemeralCall {
	c := &SslCertsCreateEphemeralCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.sslcertscreateephemeralrequest = sslcertscreateephemeralrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *SslCertsCreateEphemeralCall) Fields(s ...googleapi.Field) *SslCertsCreateEphemeralCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *SslCertsCreateEphemeralCall) Context(ctx context.Context) *SslCertsCreateEphemeralCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *SslCertsCreateEphemeralCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SslCertsCreateEphemeralCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.sslcertscreateephemeralrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/createEphemeral")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.sslCerts.createEphemeral", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.sslCerts.createEphemeral" call.
// Any non-2xx status code is an error. Response headers are in either
// *SslCert.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *SslCertsCreateEphemeralCall) Do(opts ...googleapi.CallOption) (*SslCert, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SslCert{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.sslCerts.createEphemeral", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type SslCertsDeleteCall struct {
	s               *Service
	project         string
	instance        string
	sha1Fingerprint string
	urlParams_      gensupport.URLParams
	ctx_            context.Context
	header_         http.Header
}

// Delete: Deletes the SSL certificate. For First Generation instances, the
// certificate remains valid until the instance is restarted.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
// - sha1Fingerprint: Sha1 FingerPrint.
func (r *SslCertsService) Delete(project string, instance string, sha1Fingerprint string) *SslCertsDeleteCall {
	c := &SslCertsDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.sha1Fingerprint = sha1Fingerprint
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *SslCertsDeleteCall) Fields(s ...googleapi.Field) *SslCertsDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *SslCertsDeleteCall) Context(ctx context.Context) *SslCertsDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *SslCertsDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SslCertsDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/sslCerts/{sha1Fingerprint}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":         c.project,
		"instance":        c.instance,
		"sha1Fingerprint": c.sha1Fingerprint,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.sslCerts.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.sslCerts.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *SslCertsDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.sslCerts.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type SslCertsGetCall struct {
	s               *Service
	project         string
	instance        string
	sha1Fingerprint string
	urlParams_      gensupport.URLParams
	ifNoneMatch_    string
	ctx_            context.Context
	header_         http.Header
}

// Get: Retrieves a particular SSL certificate. Does not include the private
// key (required for usage). The private key must be saved from the response to
// initial creation.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
// - sha1Fingerprint: Sha1 FingerPrint.
func (r *SslCertsService) Get(project string, instance string, sha1Fingerprint string) *SslCertsGetCall {
	c := &SslCertsGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.sha1Fingerprint = sha1Fingerprint
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *SslCertsGetCall) Fields(s ...googleapi.Field) *SslCertsGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *SslCertsGetCall) IfNoneMatch(entityTag string) *SslCertsGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *SslCertsGetCall) Context(ctx context.Context) *SslCertsGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *SslCertsGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SslCertsGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/sslCerts/{sha1Fingerprint}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":         c.project,
		"instance":        c.instance,
		"sha1Fingerprint": c.sha1Fingerprint,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.sslCerts.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.sslCerts.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *SslCert.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *SslCertsGetCall) Do(opts ...googleapi.CallOption) (*SslCert, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SslCert{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.sslCerts.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type SslCertsInsertCall struct {
	s                     *Service
	project               string
	instance              string
	sslcertsinsertrequest *SslCertsInsertRequest
	urlParams_            gensupport.URLParams
	ctx_                  context.Context
	header_               http.Header
}

// Insert: Creates an SSL certificate and returns it along with the private key
// and server certificate authority. The new certificate will not be usable
// until the instance is restarted.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *SslCertsService) Insert(project string, instance string, sslcertsinsertrequest *SslCertsInsertRequest) *SslCertsInsertCall {
	c := &SslCertsInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.sslcertsinsertrequest = sslcertsinsertrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *SslCertsInsertCall) Fields(s ...googleapi.Field) *SslCertsInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *SslCertsInsertCall) Context(ctx context.Context) *SslCertsInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *SslCertsInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SslCertsInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.sslcertsinsertrequest)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/sslCerts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.sslCerts.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.sslCerts.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *SslCertsInsertResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *SslCertsInsertCall) Do(opts ...googleapi.CallOption) (*SslCertsInsertResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SslCertsInsertResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.sslCerts.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type SslCertsListCall struct {
	s            *Service
	project      string
	instance     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all of the current SSL certificates for the instance.
//
// - instance: Cloud SQL instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *SslCertsService) List(project string, instance string) *SslCertsListCall {
	c := &SslCertsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *SslCertsListCall) Fields(s ...googleapi.Field) *SslCertsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *SslCertsListCall) IfNoneMatch(entityTag string) *SslCertsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *SslCertsListCall) Context(ctx context.Context) *SslCertsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *SslCertsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *SslCertsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/sslCerts")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.sslCerts.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.sslCerts.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *SslCertsListResponse.ServerResponse.Header or (if a response was returned
// at all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *SslCertsListCall) Do(opts ...googleapi.CallOption) (*SslCertsListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &SslCertsListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.sslCerts.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type TiersListCall struct {
	s            *Service
	project      string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists all available machine types (tiers) for Cloud SQL, for example,
// `db-custom-1-3840`. For related information, see Pricing (/sql/pricing).
//
// - project: Project ID of the project for which to list tiers.
func (r *TiersService) List(project string) *TiersListCall {
	c := &TiersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *TiersListCall) Fields(s ...googleapi.Field) *TiersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *TiersListCall) IfNoneMatch(entityTag string) *TiersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *TiersListCall) Context(ctx context.Context) *TiersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *TiersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *TiersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/tiers")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project": c.project,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.tiers.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.tiers.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *TiersListResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *TiersListCall) Do(opts ...googleapi.CallOption) (*TiersListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &TiersListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.tiers.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type UsersDeleteCall struct {
	s          *Service
	project    string
	instance   string
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Delete: Deletes a user from a Cloud SQL instance.
//
// - instance: Database instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *UsersService) Delete(project string, instance string) *UsersDeleteCall {
	c := &UsersDeleteCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// Host sets the optional parameter "host": Host of the user in the instance.
func (c *UsersDeleteCall) Host(host string) *UsersDeleteCall {
	c.urlParams_.Set("host", host)
	return c
}

// Name sets the optional parameter "name": Name of the user in the instance.
func (c *UsersDeleteCall) Name(name string) *UsersDeleteCall {
	c.urlParams_.Set("name", name)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersDeleteCall) Fields(s ...googleapi.Field) *UsersDeleteCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersDeleteCall) Context(ctx context.Context) *UsersDeleteCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersDeleteCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersDeleteCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/users")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("DELETE", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.users.delete", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.users.delete" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *UsersDeleteCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.users.delete", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type UsersGetCall struct {
	s            *Service
	project      string
	instance     string
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieves a resource containing information about a user.
//
// - instance: Database instance ID. This does not include the project ID.
// - name: User of the instance.
// - project: Project ID of the project that contains the instance.
func (r *UsersService) Get(project string, instance string, name string) *UsersGetCall {
	c := &UsersGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.name = name
	return c
}

// Host sets the optional parameter "host": Host of a user of the instance.
func (c *UsersGetCall) Host(host string) *UsersGetCall {
	c.urlParams_.Set("host", host)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersGetCall) Fields(s ...googleapi.Field) *UsersGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *UsersGetCall) IfNoneMatch(entityTag string) *UsersGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersGetCall) Context(ctx context.Context) *UsersGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/users/{name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
		"name":     c.name,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.users.get", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.users.get" call.
// Any non-2xx status code is an error. Response headers are in either
// *User.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *UsersGetCall) Do(opts ...googleapi.CallOption) (*User, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &User{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.users.get", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type UsersInsertCall struct {
	s          *Service
	project    string
	instance   string
	user       *User
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Insert: Creates a new user in a Cloud SQL instance.
//
// - instance: Database instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *UsersService) Insert(project string, instance string, user *User) *UsersInsertCall {
	c := &UsersInsertCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.user = user
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersInsertCall) Fields(s ...googleapi.Field) *UsersInsertCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersInsertCall) Context(ctx context.Context) *UsersInsertCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersInsertCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersInsertCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.user)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/users")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.users.insert", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.users.insert" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *UsersInsertCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.users.insert", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type UsersListCall struct {
	s            *Service
	project      string
	instance     string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Lists users in the specified Cloud SQL instance.
//
// - instance: Database instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *UsersService) List(project string, instance string) *UsersListCall {
	c := &UsersListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersListCall) Fields(s ...googleapi.Field) *UsersListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets an optional parameter which makes the operation fail if the
// object's ETag matches the given value. This is useful for getting updates
// only after the object has changed since the last request.
func (c *UsersListCall) IfNoneMatch(entityTag string) *UsersListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersListCall) Context(ctx context.Context) *UsersListCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "", c.header_)
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/users")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, nil)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.users.list", "request", internallog.HTTPRequest(req, nil))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.users.list" call.
// Any non-2xx status code is an error. Response headers are in either
// *UsersListResponse.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified was
// returned.
func (c *UsersListCall) Do(opts ...googleapi.CallOption) (*UsersListResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &UsersListResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.users.list", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}

type UsersUpdateCall struct {
	s          *Service
	project    string
	instance   string
	user       *User
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Update: Updates an existing user in a Cloud SQL instance.
//
// - instance: Database instance ID. This does not include the project ID.
// - project: Project ID of the project that contains the instance.
func (r *UsersService) Update(project string, instance string, user *User) *UsersUpdateCall {
	c := &UsersUpdateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.project = project
	c.instance = instance
	c.user = user
	return c
}

// DatabaseRoles sets the optional parameter "databaseRoles": List of database
// roles to grant to the user. body.database_roles will be ignored for update
// request.
func (c *UsersUpdateCall) DatabaseRoles(databaseRoles ...string) *UsersUpdateCall {
	c.urlParams_.SetMulti("databaseRoles", append([]string{}, databaseRoles...))
	return c
}

// Host sets the optional parameter "host": Host of the user in the instance.
func (c *UsersUpdateCall) Host(host string) *UsersUpdateCall {
	c.urlParams_.Set("host", host)
	return c
}

// Name sets the optional parameter "name": Name of the user in the instance.
func (c *UsersUpdateCall) Name(name string) *UsersUpdateCall {
	c.urlParams_.Set("name", name)
	return c
}

// RevokeExistingRoles sets the optional parameter "revokeExistingRoles":
// revoke the existing roles granted to the user.
func (c *UsersUpdateCall) RevokeExistingRoles(revokeExistingRoles bool) *UsersUpdateCall {
	c.urlParams_.Set("revokeExistingRoles", fmt.Sprint(revokeExistingRoles))
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse for more
// details.
func (c *UsersUpdateCall) Fields(s ...googleapi.Field) *UsersUpdateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method.
func (c *UsersUpdateCall) Context(ctx context.Context) *UsersUpdateCall {
	c.ctx_ = ctx
	return c
}

// Header returns a http.Header that can be modified by the caller to add
// headers to the request.
func (c *UsersUpdateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *UsersUpdateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := gensupport.SetHeaders(c.s.userAgent(), "application/json", c.header_)
	body, err := googleapi.WithoutDataWrapper.JSONBuffer(c.user)
	if err != nil {
		return nil, err
	}
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "sql/v1beta4/projects/{project}/instances/{instance}/users")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PUT", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"project":  c.project,
		"instance": c.instance,
	})
	c.s.logger.DebugContext(c.ctx_, "api request", "serviceName", apiName, "rpcName", "sql.users.update", "request", internallog.HTTPRequest(req, body.Bytes()))
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "sql.users.update" call.
// Any non-2xx status code is an error. Response headers are in either
// *Operation.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was returned.
func (c *UsersUpdateCall) Do(opts ...googleapi.CallOption) (*Operation, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, gensupport.WrapError(&googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		})
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, gensupport.WrapError(err)
	}
	ret := &Operation{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	b, err := gensupport.DecodeResponseBytes(target, res)
	if err != nil {
		return nil, err
	}
	c.s.logger.DebugContext(c.ctx_, "api response", "serviceName", apiName, "rpcName", "sql.users.update", "response", internallog.HTTPResponse(res, b))
	return ret, nil
}
