// Copyright 2022 The CCGO Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

package ccgo // import "modernc.org/ccgo/v4/lib"

var testExecKnownFails = map[string]struct{}{
	// ==== EXEC FAIL - compiles and builds but fails when executed.

	// // Won't fix: setjmp/longjmp
	// `assets/github.com/vnmakarov/mir/c-benchmarks/except.c`: {},
	// `assets/github.com/vnmakarov/mir/c-tests/new/setjmp.c`:  {},
	// `assets/github.com/vnmakarov/mir/c-tests/new/setjmp2.c`: {},

	// // Won't fix: sigfpe
	// `assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20101011-1.c`:                    {},
	// `assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-1.c`:                 {},
	// `assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-2.c`:                 {},
	// `assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-3.c`:                 {},
	// `assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20101011-1.c`:    {},
	// `assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-1.c`: {},
	// `assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-2.c`: {},
	// `assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/fp-cmp-3.c`: {},

	// Won't fix: Architecture specific conversion overflow.
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20031003-1.c`:                 {},
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20031003-1.c`: {},

	// Won't fix: implementation defined bit fields
	// `assets/github.com/vnmakarov/mir/c-tests/lacc/bitfield-basic.c`:         {},
	`assets/github.com/vnmakarov/mir/c-tests/lacc/bitfield-pack-next.c`:     {},
	`assets/github.com/vnmakarov/mir/c-tests/lacc/bitfield-trailing-zero.c`: {},
	`assets/github.com/vnmakarov/mir/c-tests/lacc/bitfield-types-init.c`:    {},

	// Won't fix: long double
	`assets/github.com/vnmakarov/mir/c-tests/lacc/long-double-load.c`: {},

	// Won't fix: return_addr
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/return-addr.c`: {},

	// // Won't fix, puts particular return value isn't specified
	// `assets/github.com/vnmakarov/mir/c-tests/lacc/macro-paste.c`: {},
	// `assets/github.com/vnmakarov/mir/c-tests/lacc/whitespace.c`:  {},

	// Won't fix, other.
	`assets/tcc-0.9.27/tests/tests2/73_arm64.c`:        {}, // EXEC FAIL
	`assets/tcc-0.9.27/tests/tests2/79_vla_continue.c`: {}, // EXEC FAIL

	// Won't fix OOM
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/991014-1.c`:                 {}, // EXEC FAIL: assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/991014-1.c: runtime: out of memory: cannot allocate 2147483648-byte block (4063232 in use)
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/991014-1.c`: {}, // EXEC FAIL: assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/991014-1.c: runtime: out of memory: cannot allocate 2147483648-byte block (4063232 in use)

	// Won't fix, C exit code is wrong
	`assets/github.com/vnmakarov/mir/c-tests/lacc/declaration-default-int.c`:   {}, // EXEC FAIL: assets/github.com/vnmakarov/mir/c-tests/lacc/declaration-default-int.c: : FAIL: exit status 51 (.:0:: .:0:: asm_386.s:1363:goexit: asm_386.s:1363:goexit: all_test.go:444:1: all_test.go:600:testExec1:)
	`assets/github.com/vnmakarov/mir/c-tests/lacc/function-implicit-declare.c`: {}, // EXEC FAIL: assets/github.com/vnmakarov/mir/c-tests/lacc/function-implicit-declare.c: : FAIL: exit status 42 (.:0:: .:0:: asm_386.s:1363:goexit: asm_386.s:1363:goexit: all_test.go:444:1: all_test.go:600:testExec1:)

	// Won't fix, FP arithmetic rounding
	`assets/github.com/vnmakarov/mir/c-tests/lacc/float-arithmetic.c`: {}, // EXEC FAIL

	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010904-2.c`:                 {}, // EXEC FAIL: assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010904-2.c: panic: 36
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/align-3.c`:                    {}, // EXEC FAIL: assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/align-3.c: libc_windows.go:1794:Xabort: TODOTODO
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010904-2.c`: {}, // EXEC FAIL: assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010904-2.c: panic: 36
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/align-3.c`:    {}, // EXEC FAIL: assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/align-3.c: libc_windows.go:1794:Xabort: TODOTODO

	//TODO
	`assets/CompCert-3.6/test/c/mandelbrot.c`:                                                           {}, // EXEC FAIL
	`assets/benchmarksgame-team.pages.debian.net/fasta-3.c`:                                             {}, // EXEC FAIL
	`assets/benchmarksgame-team.pages.debian.net/fasta-8.c`:                                             {}, // EXEC FAIL
	`assets/benchmarksgame-team.pages.debian.net/mandelbrot-9.c`:                                        {}, // EXEC FAIL
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/builtin-types-compatible-p.c`:                 {}, // EXEC FAIL: assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/builtin-types-compatible-p.c: : FAIL: exit status 3 (.:0:: .:0:: asm_386.s:1363:goexit: asm_386.s:1363:goexit: all_test.go:444:1: all_test.go:600:testExec1:)
	`assets/github.com/AbsInt/CompCert/test/c/mandelbrot.c`:                                             {}, // EXEC FAIL
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/builtin-types-compatible-p.c`: {}, // EXEC FAIL: assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/builtin-types-compatible-p.c: : FAIL: exit status 3 (.:0:: .:0:: asm_386.s:1363:goexit: asm_386.s:1363:goexit: all_test.go:444:1: all_test.go:600:testExec1:)
	`assets/github.com/vnmakarov/mir/c-benchmarks/mandelbrot.c`:                                         {}, // EXEC FAIL
	`assets/github.com/vnmakarov/mir/c-tests/lacc/string-conversion.c`:                                  {}, // EXEC FAIL
	`assets/github.com/vnmakarov/mir/c-tests/lacc/vararg-complex-2.c`:                                   {}, // EXEC FAIL

	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr36093.c`: {}, // EXEC FAIL: assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr36093.c: panic: 544

	// ==== BUILD FAIL - compiles but does not build.

	`assets/benchmarksgame-team.pages.debian.net/reverse-complement-4.c`: {}, // BUILD FAIL: "exit status 1"
	`assets/ccgo/bug/sqlite.c`: {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20020118-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20021127-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030323-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030811-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040308-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040709-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040709-2.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040709-3.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040811-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041114-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20060102-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20060905-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20070614-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20070824-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20080502-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20090113-2.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20090113-3.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20120105-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20120808-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20180921-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20181120-1.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/align-nest.c`:                        {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/built-in-setjmp.c`:                   {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/builtin-bitops-1.c`:                  {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/doloop-1.c`:                          {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/doloop-2.c`:                          {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ffs-1.c`:                             {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ffs-2.c`:                             {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/floatunsisf-1.c`:                     {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/fprintf-chk-1.c`:                     {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/20030331-1.c`:                   {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/compare-fp-1.c`:                 {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/memchr-1.c`:                          {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/postmod-1.c`:                         {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr28289.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr31072.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr33870-1.c`:                         {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr35456.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr36321.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr37780.c`:                           {}, // BUILD FAIL
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr38819.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr39228.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr39240.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr42570.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr43220.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr47237.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr47337.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr51466.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr53160.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr57281.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr58277-2.c`:                         {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr58431.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr58662.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr60003.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr61725.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr64006.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr64756.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr65216.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr66556.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr67037.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71631.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr7284-1.c`:                          {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr78622.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr79286.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr79327.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85529-1.c`:                         {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr86528.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr89195.c`:                           {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/stdarg-3.c`:                          {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/strlen-2.c`:                          {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/strlen-3.c`:                          {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/strlen-4.c`:                          {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/strlen-6.c`:                          {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/va-arg-22.c`:                         {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/va-arg-pack-1.c`:                     {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/vfprintf-chk-1.c`:                    {}, // BUILD FAIL: "exit status 1"
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/vla-dealloc-1.c`:                     {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20020118-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20021127-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030323-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030811-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040308-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040709-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040709-2.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040709-3.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040811-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041114-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20060102-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20060905-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20070614-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20070824-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20080502-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20090113-2.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20090113-3.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20120105-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20120808-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20180921-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20181120-1.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/align-nest.c`:        {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/built-in-setjmp.c`:   {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/builtin-bitops-1.c`:  {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/doloop-1.c`:          {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/doloop-2.c`:          {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ffs-1.c`:             {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ffs-2.c`:             {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/floatunsisf-1.c`:     {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/fprintf-chk-1.c`:     {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/20030331-1.c`:   {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/compare-fp-1.c`: {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/memchr-1.c`:          {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/postmod-1.c`:         {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr28289.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr31072.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr33870-1.c`:         {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr35456.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr36321.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr37780.c`:           {}, // BUILD FAIL
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr38819.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr39228.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr39240.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr42570.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr43220.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr47237.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr47337.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr51466.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr53160.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr57281.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr58277-2.c`:         {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr58431.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr58662.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr60003.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr61725.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr64006.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr64242.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr64756.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr65216.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr66556.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr67037.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71631.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr7284-1.c`:          {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr78622.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr79286.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr79327.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr84521.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr85529-1.c`:         {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr86528.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr89195.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr92904.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr93249.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr93494.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94134.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94567.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr97325.c`:           {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr97421-1.c`:         {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/stdarg-3.c`:          {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/strlen-2.c`:          {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/strlen-3.c`:          {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/strlen-4.c`:          {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/strlen-6.c`:          {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/va-arg-22.c`:         {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/va-arg-pack-1.c`:     {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/vfprintf-chk-1.c`:    {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/vla-dealloc-1.c`:     {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/vnmakarov/mir/c-tests/lacc/pointer.c`:                                   {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/vnmakarov/mir/c-tests/lacc/qualifier-repeat.c`:                          {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/vnmakarov/mir/c-tests/lacc/vararg-complex-1.c`:                          {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/vnmakarov/mir/c-tests/lacc/vararg.c`:                                    {}, // BUILD FAIL: "exit status 1"
	`assets/github.com/vnmakarov/mir/c-tests/new/var-size-in-var-initializer.c`:                {}, // BUILD FAIL: "exit status 1"
	`assets/tcc-0.9.27/tests/tests2/81_types.c`:                                                {}, // BUILD FAIL: "exit status 1"

	// ==== COMPILE FAIL - does not compile.

	`assets/benchmarksgame-team.pages.debian.net/binary-trees-5.c`:       {}, // COMPILE FAIL: "binary-trees-5.o.go:1274:3: undefined: \"pthread_create\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:)"
	`assets/benchmarksgame-team.pages.debian.net/mandelbrot-8.c`:         {}, // COMPILE FAIL: "\"mandelbrot-8.c:16:30: unsupported vector type: Vec (expr.go:1234:checkVolatileExpr: expr.go:101:expr: expr.go:565:expr0: expr.go:1724:unaryExpression: type.go:407:isValidType: type.go:440:isValidType..."
	`assets/benchmarksgame-team.pages.debian.net/reverse-complement-2.c`: {}, // COMPILE FAIL: "reverse-complement-2.o.go:1250:3: undefined: \"pthread_create\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:)"
	`assets/ccgo/bug/union.c`: {}, // COMPILE FAIL: "\"TODO exprUintptr (expr.go:2870:postfixExpressionSelect: expr.go:101:expr: expr.go:559:expr0: expr.go:4209:primaryExpression: expr.go:529:expr0: expr.go:3813:assignmentExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20000326-2.c`:                     {}, // COMPILE FAIL: "\"20000326-2.c:7:3: label declarations not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:401:functionDefinition0: stmt.go:330:compoundState..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20000405-3.c`:                     {}, // COMPILE FAIL: "\"20000405-3.c:1:1: unsupported alignment 32 of struct foo {entry array of 40 pointer to void} (decl.go:297:externalDeclaration: decl.go:943:declaration: type.go:559:defineStructType: type.go:494:struc..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20000518-1.c`:                     {}, // COMPILE FAIL: "\"20000518-1.c:7:2: label declarations not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:401:functionDefinition0: stmt.go:330:compoundState..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010202-1.c`:                     {}, // COMPILE FAIL: "\"20010202-1.c:3:5: incomplete type: array of array of char (decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:381:functionDefinition0: type.go:459:isValidType1: type.go:383:isVa..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010226-1.c`:                     {}, // COMPILE FAIL: "\"20010226-1.c:16:12: nested functions not supported (stmt.go:366:blockItem: stmt.go:42:statement: stmt.go:402:selectionStatement: stmt.go:695:bracedStatement: stmt.go:704:unbracedStatement: stmt.go:36..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010605-1.c`:                     {}, // COMPILE FAIL: "\"20010605-1.c:9:9: nested functions not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:457:functionDefinition0: stmt.go:330:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20010903-2.c`:                     {}, // COMPILE FAIL: "\"20010903-2.c:9:14: nested functions not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:457:functionDefinition0: stmt.go:330:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20011023-1.c`:                     {}, // COMPILE FAIL: "\"20011023-1.c:8:8: nested functions not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:457:functionDefinition0: stmt.go:330:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20020309-1.c`:                     {}, // COMPILE FAIL: "\"20020309-1.c:8:5: nested functions not supported (decl.go:457:functionDefinition0: stmt.go:330:compoundStatement: stmt.go:366:blockItem: stmt.go:26:statement: stmt.go:704:unbracedStatement: stmt.go:3..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20021108-1.c`:                     {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (expr.go:1214:additiveExpression: expr.go:1229:binopArgs: expr.go:1234:checkVolatileExpr: expr.go:101:expr: expr.go:565:expr0: expr.go:1733:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20021204-1.c`:                     {}, // COMPILE FAIL: "\"20021204-1.c:8:7: nested functions not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:457:functionDefinition0: stmt.go:330:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030418-1.c`:                     {}, // COMPILE FAIL: "\"20030418-1.c:13:8: nested functions not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:457:functionDefinition0: stmt.go:330:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030716-1.c`:                     {}, // COMPILE FAIL: "\"20030716-1.c:3:6: incomplete type: array of int (decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:381:functionDefinition0: type.go:459:isValidType1: type.go:383:isValidParamTy..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030903-1.c`:                     {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:529:expr0: expr.go:3803:assignmentExpression: expr.go:101:expr: expr.go:565:expr0: expr.go:1759:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20030910-1.c`:                     {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:529:expr0: expr.go:3808:assignmentExpression: expr.go:101:expr: expr.go:565:expr0: expr.go:1759:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20031011-1.c`:                     {}, // COMPILE FAIL: "\"20031011-1.c:15:8: nested functions not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:457:functionDefinition0: stmt.go:330:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040317-1.c`:                     {}, // COMPILE FAIL: "\"20040317-1.c:1:5: incomplete type: array of array of char (decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:381:functionDefinition0: type.go:459:isValidType1: type.go:383:isVa..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040323-1.c`:                     {}, // COMPILE FAIL: "\"20040323-1.c:10:16: nested functions not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:457:functionDefinition0: stmt.go:330:compoundState..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20040614-1.c`:                     {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20050113-1.c`:                     {}, // COMPILE FAIL: "\"20050113-1.c:11:20: unsupported vector type: V2SF (expr.go:559:expr0: expr.go:4192:primaryExpression: expr.go:4664:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVa..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20050119-1.c`:                     {}, // COMPILE FAIL: "\"20050119-1.c:7:8: nested functions not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:457:functionDefinition0: stmt.go:330:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20050122-2.c`:                     {}, // COMPILE FAIL: "\"20050122-2.c:10:3: label declarations not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:401:functionDefinition0: stmt.go:330:compoundStat..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20070603-1.c`:                     {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:1197:additiveExpression: expr.go:1229:binopArgs: expr.go:1234:checkVolatileExpr: expr.go:101:expr: expr.go:565:expr0: expr.go:1759:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20070603-2.c`:                     {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:1197:additiveExpression: expr.go:1229:binopArgs: expr.go:1234:checkVolatileExpr: expr.go:101:expr: expr.go:565:expr0: expr.go:1759:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20070919-1.c`:                     {}, // COMPILE FAIL: "\"TODO exprUintptr (expr.go:101:expr: expr.go:565:expr0: expr.go:1647:unaryExpression: expr.go:101:expr: expr.go:557:expr0: expr.go:2187:postfixExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20110131-1.c`:                     {}, // COMPILE FAIL: "\"-: TODO (expr.go:1234:checkVolatileExpr: expr.go:101:expr: expr.go:541:expr0: expr.go:949:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/20121107-1.c`:                     {}, // COMPILE FAIL: "\"-: TODO (expr.go:559:expr0: expr.go:4209:primaryExpression: expr.go:541:expr0: expr.go:949:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/981001-4.c`:                       {}, // COMPILE FAIL: "\"-: TODO (expr.go:559:expr0: expr.go:4209:primaryExpression: expr.go:541:expr0: expr.go:949:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/981006-1.c`:                       {}, // COMPILE FAIL: "\"981006-1.c:14:3: label declarations not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:401:functionDefinition0: stmt.go:330:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/981223-1.c`:                       {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:1302:equalityExpression: expr.go:1229:binopArgs: expr.go:1234:checkVolatileExpr: expr.go:101:expr: expr.go:565:expr0: expr.go:1759:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/991213-1.c`:                       {}, // COMPILE FAIL: "\"TODO UnaryExpressionImag (expr.go:70:topExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:4209:primaryExpression: expr.go:565:expr0: expr.go:1757:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/991213-3.c`:                       {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-1.c`:                      {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (expr.go:70:topExpr: expr.go:115:expr: expr.go:169:convert: expr.go:353:convertType: type.go:30:helper: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-2.c`:                      {}, // COMPILE FAIL: "\"TODO UnaryExpressionImag (expr.go:101:expr: expr.go:529:expr0: expr.go:3803:assignmentExpression: expr.go:101:expr: expr.go:565:expr0: expr.go:1757:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-3.c`:                      {}, // COMPILE FAIL: "\"TODO UnaryExpressionImag (expr.go:1197:additiveExpression: expr.go:1229:binopArgs: expr.go:1234:checkVolatileExpr: expr.go:101:expr: expr.go:565:expr0: expr.go:1757:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-4.c`:                      {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:529:expr0: expr.go:3803:assignmentExpression: expr.go:101:expr: expr.go:565:expr0: expr.go:1759:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/complex-5.c`:                      {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (expr.go:101:expr: expr.go:559:expr0: expr.go:4190:primaryExpression: expr.go:4643:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/icfmatch.c`:                       {}, // COMPILE FAIL: "\"icfmatch.c:4:14: unsupported vector type: v4qi (expr.go:101:expr: expr.go:559:expr0: expr.go:4101:primaryExpression: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/labels-3.c`:                       {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/nested-1.c`:                       {}, // COMPILE FAIL: "\"nested-1.c:15:24: incomplete type: array of char (expr.go:101:expr: expr.go:565:expr0: expr.go:1700:unaryExpression: type.go:395:isValidType: type.go:407:isValidType: type.go:471:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/nested-2.c`:                       {}, // COMPILE FAIL: "\"nested-2.c:9:7: nested functions not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:457:functionDefinition0: stmt.go:330:compoundStatement..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/nested-3.c`:                       {}, // COMPILE FAIL: "\"nested-3.c:13:7: nested functions not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:457:functionDefinition0: stmt.go:330:compoundStatemen..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr17913.c`:                        {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr18903.c`:                        {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (stmt.go:366:blockItem: stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:565:expr0: expr.go:1733:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr21356.c`:                        {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr21728.c`:                        {}, // COMPILE FAIL: "\"pr21728.c:5:3: label declarations not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:401:functionDefinition0: stmt.go:330:compoundStatemen..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr22422.c`:                        {}, // COMPILE FAIL: "\"TODO pr22422.c:27:3: from pointer to int, exprUintptr to pointer to int exprVoid, src '&d->c [d->n]', buf '((((aad))+4)+(((ppuintptr(((*tsD)(iqunsafe.ppPointer((aad))).fdn))))*4))' (stmt.go:366:block..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr25224.c`:                        {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr27341-1.c`:                      {}, // COMPILE FAIL: "\"TODO UnaryExpressionImag (expr.go:101:expr: expr.go:529:expr0: expr.go:3803:assignmentExpression: expr.go:101:expr: expr.go:565:expr0: expr.go:1757:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr27889.c`:                        {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:434:functionDefinition0: decl.go:917:signature: type.go:48:typ2: type.go:15..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr30984.c`:                        {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr33617.c`:                        {}, // COMPILE FAIL: "\".: unsupported vector type: V8SF (asm_386.s:1363:goexit: asm_386.s:1363:goexit: compile.go:513:compile: decl.go:878:signature: type.go:383:isValidParamType: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr34856.c`:                        {}, // COMPILE FAIL: "\"pr34856.c:13:13: unsupported vector type: qword (expr.go:101:expr: expr.go:559:expr0: expr.go:4101:primaryExpression: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr35431.c`:                        {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (expr.go:101:expr: expr.go:559:expr0: expr.go:4190:primaryExpression: expr.go:4643:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr38771.c`:                        {}, // COMPILE FAIL: "\"-: TODO (expr.go:559:expr0: expr.go:4209:primaryExpression: expr.go:541:expr0: expr.go:949:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr40233.c`:                        {}, // COMPILE FAIL: "\"pr40233.c:2:1: unsupported alignment 64 of struct Frame {i aligned} (decl.go:297:externalDeclaration: decl.go:943:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:65:typ0..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr41987.c`:                        {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex char _Complex char (expr.go:101:expr: expr.go:559:expr0: expr.go:4190:primaryExpression: expr.go:4643:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42196-1.c`:                      {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:297:externalDeclaration: decl.go:945:declaration: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:312:typ0: type.go:159:typ0:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42196-2.c`:                      {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:297:externalDeclaration: decl.go:945:declaration: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:323:typ0: type.go:159:typ0:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42196-3.c`:                      {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:297:externalDeclaration: decl.go:945:declaration: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:323:typ0: type.go:159:typ0:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42559.c`:                        {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (init.go:30:initializerOuter: init.go:82:initializer: expr.go:70:topExpr: expr.go:101:expr: expr.go:565:expr0: expr.go:1733:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42716.c`:                        {}, // COMPILE FAIL: "\"-: TODO (expr.go:1234:checkVolatileExpr: expr.go:101:expr: expr.go:541:expr0: expr.go:949:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr42717.c`:                        {}, // COMPILE FAIL: "\"-: TODO (expr.go:1234:checkVolatileExpr: expr.go:101:expr: expr.go:541:expr0: expr.go:949:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr44119.c`:                        {}, // COMPILE FAIL: "\"-: TODO (expr.go:1234:checkVolatileExpr: expr.go:101:expr: expr.go:541:expr0: expr.go:949:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr46107.c`:                        {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr51354.c`:                        {}, // COMPILE FAIL: "\"pr51354.c:15:6: unsupported alignment 32 of ai (decl.go:457:functionDefinition0: stmt.go:261:compoundStatement: decl.go:230:declareLocals: type.go:42:typ: type.go:65:typ0: type.go:426:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr51495.c`:                        {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr52750.c`:                        {}, // COMPILE FAIL: "\"pr52750.c:8:11: unsupported vector type: V (expr.go:559:expr0: expr.go:4190:primaryExpression: expr.go:4643:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr53410-2.c`:                      {}, // COMPILE FAIL: "\"pr53410-2.c:9:3: unsupported vector type: V (expr.go:101:expr: expr.go:565:expr0: expr.go:1647:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr53748.c`:                        {}, // COMPILE FAIL: "\"pr53748.c:8:3: unsupported vector type: V (expr.go:101:expr: expr.go:565:expr0: expr.go:1647:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr54713-1.c`:                      {}, // COMPILE FAIL: "\"pr54713-1.c:15:3: unsupported vector type: V (expr.go:101:expr: expr.go:565:expr0: expr.go:1647:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr54713-2.c`:                      {}, // COMPILE FAIL: "\"pr54713-1.c:15:3: unsupported vector type: V (expr.go:101:expr: expr.go:565:expr0: expr.go:1647:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr54713-3.c`:                      {}, // COMPILE FAIL: "\"pr54713-1.c:15:3: unsupported vector type: V (expr.go:101:expr: expr.go:565:expr0: expr.go:1647:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr56571.c`:                        {}, // COMPILE FAIL: "\"-: TODO (expr.go:559:expr0: expr.go:4209:primaryExpression: expr.go:541:expr0: expr.go:949:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr58164.c`:                        {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr60502.c`:                        {}, // COMPILE FAIL: "\"pr60502.c:9:16: unsupported vector type: v16i8 (expr.go:115:expr: expr.go:169:convert: expr.go:351:convertType: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70199.c`:                        {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70633.c`:                        {}, // COMPILE FAIL: "\"pr70633.c:10:5: unsupported vector type: V (decl.go:457:functionDefinition0: stmt.go:261:compoundStatement: decl.go:230:declareLocals: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr70916.c`:                        {}, // COMPILE FAIL: "\"-: TODO (expr.go:3808:assignmentExpression: expr.go:101:expr: expr.go:541:expr0: expr.go:949:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr71109.c`:                        {}, // COMPILE FAIL: "\"pr71109.c:15:7: too few arguments to function 'foo', type 'function(int, struct S, struct T)' in 'foo (bar, a)' (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:557:expr0: expr.go..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-1.c`:                      {}, // COMPILE FAIL: "\"pr77754-1.c:5:13: incomplete type: array of array of int (asm_386.s:1363:goexit: asm_386.s:1363:goexit: compile.go:513:compile: decl.go:878:signature: type.go:383:isValidParamType: type.go:471:isVali..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-2.c`:                      {}, // COMPILE FAIL: "\"pr77754-2.c:5:6: incomplete type: array of array of int (type.go:658:defineType0: type.go:658:defineType0: type.go:646:defineType0: type.go:459:isValidType1: type.go:383:isValidParamType: type.go:471..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-3.c`:                      {}, // COMPILE FAIL: "\"pr77754-3.c:5:14: incomplete type: array of array of int (type.go:642:defineType: type.go:658:defineType0: type.go:646:defineType0: type.go:459:isValidType1: type.go:383:isValidParamType: type.go:471..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-4.c`:                      {}, // COMPILE FAIL: "\"pr77754-4.c:5:14: incomplete type: array of array of int (type.go:642:defineType: type.go:658:defineType0: type.go:646:defineType0: type.go:459:isValidType1: type.go:383:isValidParamType: type.go:471..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr77754-5.c`:                      {}, // COMPILE FAIL: "\"pr77754-5.c:6:6: incomplete type: array of array of int (decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:381:functionDefinition0: type.go:459:isValidType1: type.go:383:isVali..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr82564.c`:                        {}, // COMPILE FAIL: "\"pr82564.c:9:5: invalid type size: -1 (decl.go:457:functionDefinition0: stmt.go:261:compoundStatement: decl.go:239:declareLocals: type.go:42:typ: type.go:65:typ0: type.go:478:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr84136.c`:                        {}, // COMPILE FAIL: "\"TODO UnaryExpressionLabelAddr (expr.go:529:expr0: expr.go:3762:assignmentExpression: expr.go:1234:checkVolatileExpr: expr.go:101:expr: expr.go:565:expr0: expr.go:1733:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr84305.c`:                        {}, // COMPILE FAIL: "\"pr84305.c:3:34: TODO (expr.go:1915:postfixExpressionIndex: expr.go:101:expr: expr.go:557:expr0: expr.go:1998:postfixExpression: expr.go:1831:postfixExpressionIndex: expr.go:1781:mul:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr84960.c`:                        {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr85704.c`:                        {}, // COMPILE FAIL: "\"pr85704.c:9:26: TODO \\\"tsC{}\\\" from=struct C {c struct {}} struct 0 exprDefault -> to=struct D {d int; e struct C; f int} struct 8 exprDefault (pr85704.c:9:26:) (expr.go:557:expr0: expr.go:2297:postf..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr85945.c`:                        {}, // COMPILE FAIL: "\"pr85945.c:4:1: unsupported vector type: V (decl.go:945:declaration: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:323:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr86122.c`:                        {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (expr.go:101:expr: expr.go:559:expr0: expr.go:4190:primaryExpression: expr.go:4643:primaryExpressionIntConst: type.go:30:helper: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr86123.c`:                        {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex unsigned _Complex unsigned (expr.go:101:expr: expr.go:559:expr0: expr.go:4190:primaryExpression: expr.go:4643:primaryExpressionIntConst: type.go:30:helper: type.go:15..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr89655.c`:                        {}, // COMPILE FAIL: "\"-: TODO (expr.go:559:expr0: expr.go:4209:primaryExpression: expr.go:541:expr0: expr.go:949:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/pr90139.c`:                        {}, // COMPILE FAIL: "\"pr90139.c:10:5: unsupported vector type: V (decl.go:457:functionDefinition0: stmt.go:261:compoundStatement: decl.go:239:declareLocals: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-1.c`:                         {}, // COMPILE FAIL: "\"simd-1.c:5:16: unsupported vector type: v2si (expr.go:559:expr0: expr.go:4190:primaryExpression: expr.go:4626:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-2.c`:                         {}, // COMPILE FAIL: "\"simd-2.c:14:9: unsupported vector type: floatvect2 (expr.go:557:expr0: expr.go:2114:postfixExpression: expr.go:2870:postfixExpressionSelect: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-3.c`:                         {}, // COMPILE FAIL: "\"simd-3.c:19:9: unsupported vector type: floatvect2 (expr.go:557:expr0: expr.go:2114:postfixExpression: expr.go:2870:postfixExpressionSelect: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-4.c`:                         {}, // COMPILE FAIL: "\"simd-4.c:11:26: unsupported vector type: floatvect2 (expr.go:101:expr: expr.go:565:expr0: expr.go:1647:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/simd-6.c`:                         {}, // COMPILE FAIL: "\"simd-6.c:5:11: unsupported vector type: vec (init.go:99:initializer: init.go:174:initializerArray: type.go:42:typ: type.go:337:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/sra-1.c`:                          {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:1331:relationExpression: expr.go:1229:binopArgs: expr.go:1234:checkVolatileExpr: expr.go:101:expr: expr.go:565:expr0: expr.go:1759:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/struct-non-lval-2.c`:              {}, // COMPILE FAIL: "\"struct-non-lval-2.c:6:3: TODO \\\"ccv1\\\" from=struct foo {x char; y char; z array of 2 char} struct 4 exprUintptr -> to=pointer to struct foo pointer 4 exprUintptr (struct-non-lval-2.c:6:3:) (expr.go:5..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/struct-non-lval-3.c`:              {}, // COMPILE FAIL: "\"TODO exprUintptr (expr.go:2968:postfixExpressionSelect: expr.go:101:expr: expr.go:559:expr0: expr.go:4209:primaryExpression: expr.go:529:expr0: expr.go:3813:assignmentExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-1.c`:                       {}, // COMPILE FAIL: "\"vector-1.c:3:1: unsupported vector type: float (decl.go:943:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-2.c`:                       {}, // COMPILE FAIL: "\"vector-2.c:3:1: unsupported vector type: float (decl.go:943:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-4.c`:                       {}, // COMPILE FAIL: "\"vector-4.c:7:47: unsupported vector type: signed char (decl.go:297:externalDeclaration: decl.go:953:declaration: decl.go:1148:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/compile/vector-align-1.c`:                 {}, // COMPILE FAIL: "\"vector-align-1.c:11:6: unsupported alignment 128 of char (decl.go:297:externalDeclaration: decl.go:953:declaration: decl.go:1148:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:426:isValidTy..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010122-1.c`:                     {}, // COMPILE FAIL: "20010122-1.o.go:377:11: undefined: \"alloca\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_tes..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20010605-1.c`:                     {}, // COMPILE FAIL: "\"20010605-1.c:5:14: nested functions not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:457:functionDefinition0: stmt.go:330:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20020411-1.c`:                     {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:529:expr0: expr.go:3803:assignmentExpression: expr.go:101:expr: expr.go:565:expr0: expr.go:1759:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20020412-1.c`:                     {}, // COMPILE FAIL: "\"20020412-1.c:31:7: invalid type size: -1 (expr.go:4209:primaryExpression: expr.go:565:expr0: expr.go:1628:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:478:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20030330-1.c`:                     {}, // COMPILE FAIL: "20030330-1.o.go:354:4: undefined: \"link_error\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040302-1.c`:                     {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20040520-1.c`:                     {}, // COMPILE FAIL: "\"20040520-1.c:6:13: nested functions not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:457:functionDefinition0: stmt.go:330:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041201-1.c`:                     {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex char _Complex char (decl.go:297:externalDeclaration: decl.go:953:declaration: decl.go:1118:initDeclarator: type.go:18:typedef: type.go:263:typ0: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041214-1.c`:                     {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20041218-2.c`:                     {}, // COMPILE FAIL: "\"20041218-2.c:7:17: incomplete type: array of char (expr.go:101:expr: expr.go:565:expr0: expr.go:1724:unaryExpression: type.go:395:isValidType: type.go:407:isValidType: type.go:471:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050121-1.c`:                     {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:529:expr0: expr.go:3803:assignmentExpression: expr.go:101:expr: expr.go:565:expr0: expr.go:1759:unaryExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050316-1.c`:                     {}, // COMPILE FAIL: "\"20050316-1.c:15:29: unsupported vector type: V2SI (expr.go:559:expr0: expr.go:4190:primaryExpression: expr.go:4643:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidTy..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050316-2.c`:                     {}, // COMPILE FAIL: "\"20050316-2.c:38:14: unsupported vector type: V2SF (expr.go:559:expr0: expr.go:4192:primaryExpression: expr.go:4664:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVa..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050316-3.c`:                     {}, // COMPILE FAIL: "\"20050316-3.c:29:3: unsupported vector type: V2USI (expr.go:557:expr0: expr.go:2114:postfixExpression: expr.go:2870:postfixExpressionSelect: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050604-1.c`:                     {}, // COMPILE FAIL: "\"20050604-1.c:16:3: unsupported vector type: v4hi (decl.go:953:declaration: decl.go:1148:initDeclarator: type.go:42:typ: type.go:323:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20050607-1.c`:                     {}, // COMPILE FAIL: "\"20050607-1.c:12:32: unsupported vector type: V2SI (expr.go:559:expr0: expr.go:4190:primaryExpression: expr.go:4626:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVali..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20060420-1.c`:                     {}, // COMPILE FAIL: "\"20060420-1.c:8:19: unsupported vector type: v4flt (expr.go:1234:checkVolatileExpr: expr.go:101:expr: expr.go:565:expr0: expr.go:1724:unaryExpression: type.go:407:isValidType: type.go:440:isValidType1..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20070919-1.c`:                     {}, // COMPILE FAIL: "\"20070919-1.c:31:7: invalid type size: -1 (expr.go:559:expr0: expr.go:4222:primaryExpression: decl.go:175:newAutovar: type.go:42:typ: type.go:65:typ0: type.go:478:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20071210-1.c`:                     {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20090219-1.c`:                     {}, // COMPILE FAIL: "\"20090219-1.c:12:8: nested functions not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:457:functionDefinition0: stmt.go:330:compoundStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20101011-1.c`:                     {}, // COMPILE FAIL: "20101011-1.o.go:485:2: undefined: \"signal\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_test..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/20171008-1.c`:                     {}, // COMPILE FAIL: "\"20171008-1.c:16:1: unsupported alignment 4 of function(void) returning struct S (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.g..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/comp-goto-1.c`:                    {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/complex-6.c`:                      {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:434:functionDefinition0: decl.go:896:signature: type.go:48:typ2: type.go:15..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/complex-7.c`:                      {}, // COMPILE FAIL: "\"TODO 2.2iL *cc.ComplexLongDoubleValue from=_Complex long t=long double mode=exprDefault (expr.go:1229:binopArgs: expr.go:1234:checkVolatileExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:4192:prim..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/fprintf-2.c`:                      {}, // COMPILE FAIL: "fprintf-2.o.go:734:19: undefined: \"fscanf\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_test..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/pr30704.c`:                   {}, // COMPILE FAIL: "\"ieee\\\\pr30704.c:35:48: undefined: __DBL_MIN_EXP__ (check.go:5000:check:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/ieee/pr72824-2.c`:                 {}, // COMPILE FAIL: "\"pr72824-2.c:17:17: unsupported vector type: V (expr.go:559:expr0: expr.go:4192:primaryExpression: expr.go:4674:primaryExpressionFloatConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidType..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/medce-1.c`:                        {}, // COMPILE FAIL: "medce-1.o.go:367:2: undefined: \"link_error\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_tes..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nest-align-1.c`:                   {}, // COMPILE FAIL: "\"nest-align-1.c:25:8: nested functions not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:457:functionDefinition0: stmt.go:330:compoundStat..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-5.c`:                     {}, // COMPILE FAIL: "\"nestfunc-5.c:8:3: label declarations not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:401:functionDefinition0: stmt.go:330:compoundState..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-6.c`:                     {}, // COMPILE FAIL: "\"nestfunc-6.c:13:3: label declarations not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:401:functionDefinition0: stmt.go:330:compoundStat..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/nestfunc-7.c`:                     {}, // COMPILE FAIL: "\"nestfunc-7.c:15:12: nested functions not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:457:functionDefinition0: stmt.go:330:compoundState..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr23135.c`:                        {}, // COMPILE FAIL: "\"pr23135.c:19:14: unsupported vector type: vecint (expr.go:559:expr0: expr.go:4190:primaryExpression: expr.go:4626:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValid..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr23324.c`:                        {}, // COMPILE FAIL: "\"TODO (decl.go:1210:initDeclaratorInit: type.go:642:defineType: type.go:656:defineType0: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:315:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr24135.c`:                        {}, // COMPILE FAIL: "\"pr24135.c:7:3: label declarations not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:401:functionDefinition0: stmt.go:330:compoundStatemen..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr34154.c`:                        {}, // COMPILE FAIL: "\"TODO SelectionStatementSwitch (decl.go:401:functionDefinition0: stmt.go:330:compoundStatement: stmt.go:366:blockItem: stmt.go:42:statement: stmt.go:454:selectionStatement: stmt.go:671:selectionStatem..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr38151.c`:                        {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:297:externalDeclaration: decl.go:943:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263:typ0: type.go:159:typ..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr41935.c`:                        {}, // COMPILE FAIL: "\"pr41935.c:10:10: TODO (expr.go:1947:postfixExpressionIndex: expr.go:101:expr: expr.go:557:expr0: expr.go:1998:postfixExpression: expr.go:1831:postfixExpressionIndex: expr.go:1781:mul:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr51447.c`:                        {}, // COMPILE FAIL: "\"pr51447.c:16:3: label declarations not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:401:functionDefinition0: stmt.go:330:compoundStateme..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr53645-2.c`:                      {}, // COMPILE FAIL: "\"pr53645-2.c:41:1: unsupported vector type: UV (expr.go:101:expr: expr.go:565:expr0: expr.go:1647:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr53645.c`:                        {}, // COMPILE FAIL: "\"pr53645.c:41:1: unsupported vector type: UV (expr.go:101:expr: expr.go:565:expr0: expr.go:1647:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr56837.c`:                        {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:297:externalDeclaration: decl.go:953:declaration: decl.go:1148:initDeclarator: type.go:42:typ: type.go:337:typ0: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr58831.c`:                        {}, // COMPILE FAIL: "pr58831.o.go:489:3: undefined: \"_assert\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_test.g..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr60960.c`:                        {}, // COMPILE FAIL: "\"pr60960.c:26:14: unsupported vector type: v4qi (expr.go:559:expr0: expr.go:4190:primaryExpression: expr.go:4632:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidTy..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr65427.c`:                        {}, // COMPILE FAIL: "\"pr65427.c:4:3: unsupported vector type: V (decl.go:297:externalDeclaration: decl.go:953:declaration: decl.go:1148:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr68249.c`:                        {}, // COMPILE FAIL: "\"-: TODO (expr.go:3808:assignmentExpression: expr.go:101:expr: expr.go:541:expr0: expr.go:949:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr68381.c`:                        {}, // COMPILE FAIL: "\"TODO unsigned short * unsigned short -> int (stmt.go:42:statement: stmt.go:401:selectionStatement: expr.go:101:expr: expr.go:557:expr0: expr.go:2057:postfixExpression: expr.go:2336:mulOverflow:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr70460.c`:                        {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr70903.c`:                        {}, // COMPILE FAIL: "\"TODO (expr.go:3492:postfixExpressionCall: expr.go:70:topExpr: expr.go:101:expr: expr.go:557:expr0: expr.go:2297:postfixExpression: init.go:51:initializer:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71494.c`:                        {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71554.c`:                        {}, // COMPILE FAIL: "\"TODO unsigned * int -> int (stmt.go:42:statement: stmt.go:401:selectionStatement: expr.go:101:expr: expr.go:557:expr0: expr.go:2057:postfixExpression: expr.go:2336:mulOverflow:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71626-1.c`:                      {}, // COMPILE FAIL: "\"TODO PostfixExpressionIndex (expr.go:1305:equalityExpression: expr.go:1229:binopArgs: expr.go:1234:checkVolatileExpr: expr.go:101:expr: expr.go:557:expr0: expr.go:2005:postfixExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr71626-2.c`:                      {}, // COMPILE FAIL: "\"TODO PostfixExpressionIndex (expr.go:1305:equalityExpression: expr.go:1229:binopArgs: expr.go:1234:checkVolatileExpr: expr.go:101:expr: expr.go:557:expr0: expr.go:2005:postfixExpression:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr77767.c`:                        {}, // COMPILE FAIL: "\"pr77767.c:4:1: incomplete type: array of int (decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:381:functionDefinition0: type.go:459:isValidType1: type.go:383:isValidParamType:..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr80692.c`:                        {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Decimal64 _Decimal64 (expr.go:101:expr: expr.go:559:expr0: expr.go:4192:primaryExpression: expr.go:4654:primaryExpressionFloatConst: type.go:30:helper: type.go:159:typ0:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr82210.c`:                        {}, // COMPILE FAIL: "\"pr82210.c:14:5: unsupported alignment 16 of struct T {c short} (expr.go:557:expr0: expr.go:1998:postfixExpression: expr.go:1915:postfixExpressionIndex: type.go:42:typ: type.go:65:typ0: type.go:426:is..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr84169.c`:                        {}, // COMPILE FAIL: "\"TODO unsigned char * int -> T (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:557:expr0: expr.go:2057:postfixExpression: expr.go:2336:mulOverflow:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85169.c`:                        {}, // COMPILE FAIL: "\"pr85169.c:8:9: unsupported vector type: V (expr.go:101:expr: expr.go:565:expr0: expr.go:1647:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr85331.c`:                        {}, // COMPILE FAIL: "\"pr85331.c:9:11: unsupported vector type: V (expr.go:559:expr0: expr.go:4192:primaryExpression: expr.go:4664:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr88739.c`:                        {}, // COMPILE FAIL: "\"TODO exprUintptr (expr.go:2114:postfixExpression: expr.go:2834:postfixExpressionSelect: expr.go:101:expr: expr.go:557:expr0: expr.go:2114:postfixExpression: expr.go:2949:postfixExpressionSelect:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/pr89434.c`:                        {}, // COMPILE FAIL: "\"TODO int * long -> unsigned (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:557:expr0: expr.go:2057:postfixExpression: expr.go:2336:mulOverflow:)\""
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/printf-2.c`:                       {}, // COMPILE FAIL: "printf-2.o.go:741:19: undefined: \"fscanf\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_test...."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/printf-chk-1.c`:                   {}, // COMPILE FAIL: "printf-chk-1.o.go:793:10: undefined: \"vprintf\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/scal-to-vec1.c`:                   {}, // COMPILE FAIL: "scal-to-vec1.o.go:347:17: undefined: \"main\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_tes..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/scal-to-vec2.c`:                   {}, // COMPILE FAIL: "scal-to-vec2.o.go:361:17: undefined: \"main\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_tes..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/scal-to-vec3.c`:                   {}, // COMPILE FAIL: "scal-to-vec3.o.go:345:17: undefined: \"main\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_tes..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/simd-6.c`:                         {}, // COMPILE FAIL: "\"simd-6.c:13:14: unsupported vector type: v8qi (expr.go:559:expr0: expr.go:4190:primaryExpression: expr.go:4632:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidTyp..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/string-opt-18.c`:                  {}, // COMPILE FAIL: "string-opt-18.o.go:355:5: undefined: \"mempcpy\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/user-printf.c`:                    {}, // COMPILE FAIL: "user-printf.o.go:744:19: undefined: \"fscanf\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_te..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/va-arg-21.c`:                      {}, // COMPILE FAIL: "va-arg-21.o.go:710:2: undefined: \"vprintf\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_test..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/vprintf-1.c`:                      {}, // COMPILE FAIL: "vprintf-1.o.go:796:3: undefined: \"vprintf\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_test..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/vprintf-chk-1.c`:                  {}, // COMPILE FAIL: "vprintf-chk-1.o.go:789:9: undefined: \"vprintf\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_..."
	`assets/gcc-9.1.0/gcc/testsuite/gcc.c-torture/execute/zero-struct-2.c`:                  {}, // COMPILE FAIL: "\"zero-struct-2.c:15:48: TODO \\\"Xone_raw_spinlock(cgtls)\\\" from=raw_spinlock_t struct 0 exprDefault -> to=spinlock_t struct 0 exprDefault (zero-struct-2.c:15:48:) (expr.go:557:expr0: expr.go:2297:postf..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010122-1.c`:     {}, // COMPILE FAIL: "20010122-1.o.go:377:11: undefined: \"alloca\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_tes..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20010605-1.c`:     {}, // COMPILE FAIL: "\"20010605-1.c:5:14: nested functions not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:457:functionDefinition0: stmt.go:330:compoundStatem..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20020411-1.c`:     {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:529:expr0: expr.go:3803:assignmentExpression: expr.go:101:expr: expr.go:565:expr0: expr.go:1759:unaryExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20020412-1.c`:     {}, // COMPILE FAIL: "\"20020412-1.c:31:7: invalid type size: -1 (expr.go:4209:primaryExpression: expr.go:565:expr0: expr.go:1628:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:478:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20030330-1.c`:     {}, // COMPILE FAIL: "20030330-1.o.go:354:4: undefined: \"link_error\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040302-1.c`:     {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20040520-1.c`:     {}, // COMPILE FAIL: "\"20040520-1.c:6:13: nested functions not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:457:functionDefinition0: stmt.go:330:compoundStatem..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041201-1.c`:     {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex char _Complex char (decl.go:297:externalDeclaration: decl.go:953:declaration: decl.go:1118:initDeclarator: type.go:18:typedef: type.go:263:typ0: type.go:159:typ0:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041214-1.c`:     {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20041218-2.c`:     {}, // COMPILE FAIL: "\"20041218-2.c:7:17: incomplete type: array of char (expr.go:101:expr: expr.go:565:expr0: expr.go:1724:unaryExpression: type.go:395:isValidType: type.go:407:isValidType: type.go:471:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050121-1.c`:     {}, // COMPILE FAIL: "\"TODO UnaryExpressionReal (expr.go:101:expr: expr.go:529:expr0: expr.go:3803:assignmentExpression: expr.go:101:expr: expr.go:565:expr0: expr.go:1759:unaryExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050316-1.c`:     {}, // COMPILE FAIL: "\"20050316-1.c:15:29: unsupported vector type: V2SI (expr.go:559:expr0: expr.go:4190:primaryExpression: expr.go:4643:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidTy..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050316-2.c`:     {}, // COMPILE FAIL: "\"20050316-2.c:38:14: unsupported vector type: V2SF (expr.go:559:expr0: expr.go:4192:primaryExpression: expr.go:4664:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVa..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050316-3.c`:     {}, // COMPILE FAIL: "\"20050316-3.c:29:3: unsupported vector type: V2USI (expr.go:557:expr0: expr.go:2114:postfixExpression: expr.go:2870:postfixExpressionSelect: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050604-1.c`:     {}, // COMPILE FAIL: "\"20050604-1.c:16:3: unsupported vector type: v4hi (decl.go:953:declaration: decl.go:1148:initDeclarator: type.go:42:typ: type.go:323:typ0: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20050607-1.c`:     {}, // COMPILE FAIL: "\"20050607-1.c:12:32: unsupported vector type: V2SI (expr.go:559:expr0: expr.go:4190:primaryExpression: expr.go:4626:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isVali..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20060420-1.c`:     {}, // COMPILE FAIL: "\"20060420-1.c:8:19: unsupported vector type: v4flt (expr.go:1234:checkVolatileExpr: expr.go:101:expr: expr.go:565:expr0: expr.go:1724:unaryExpression: type.go:407:isValidType: type.go:440:isValidType1..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20070919-1.c`:     {}, // COMPILE FAIL: "\"20070919-1.c:31:7: invalid type size: -1 (expr.go:559:expr0: expr.go:4222:primaryExpression: decl.go:175:newAutovar: type.go:42:typ: type.go:65:typ0: type.go:478:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20071210-1.c`:     {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20090219-1.c`:     {}, // COMPILE FAIL: "\"20090219-1.c:12:8: nested functions not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:457:functionDefinition0: stmt.go:330:compoundStatem..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20101011-1.c`:     {}, // COMPILE FAIL: "20101011-1.o.go:485:2: undefined: \"signal\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_test..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/20171008-1.c`:     {}, // COMPILE FAIL: "\"20171008-1.c:16:1: unsupported alignment 4 of function(void) returning struct S (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.g..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/comp-goto-1.c`:    {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/complex-6.c`:      {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:434:functionDefinition0: decl.go:896:signature: type.go:48:typ2: type.go:15..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/complex-7.c`:      {}, // COMPILE FAIL: "\"TODO 2.2iL *cc.ComplexLongDoubleValue from=_Complex long t=long double mode=exprDefault (expr.go:1229:binopArgs: expr.go:1234:checkVolatileExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:4192:prim..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/fprintf-2.c`:      {}, // COMPILE FAIL: "fprintf-2.o.go:734:19: undefined: \"fscanf\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_test..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/pr30704.c`:   {}, // COMPILE FAIL: "\"gcc.c-torture\\\\execute\\\\ieee\\\\pr30704.c:35:48: undefined: __DBL_MIN_EXP__ (check.go:5000:check:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/ieee/pr72824-2.c`: {}, // COMPILE FAIL: "\"pr72824-2.c:17:17: unsupported vector type: V (expr.go:559:expr0: expr.go:4192:primaryExpression: expr.go:4674:primaryExpressionFloatConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidType..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/medce-1.c`:        {}, // COMPILE FAIL: "medce-1.o.go:367:2: undefined: \"link_error\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_tes..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nest-align-1.c`:   {}, // COMPILE FAIL: "\"nest-align-1.c:25:8: nested functions not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:457:functionDefinition0: stmt.go:330:compoundStat..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-5.c`:     {}, // COMPILE FAIL: "\"nestfunc-5.c:8:3: label declarations not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:401:functionDefinition0: stmt.go:330:compoundState..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-6.c`:     {}, // COMPILE FAIL: "\"nestfunc-6.c:13:3: label declarations not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:401:functionDefinition0: stmt.go:330:compoundStat..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/nestfunc-7.c`:     {}, // COMPILE FAIL: "\"nestfunc-7.c:15:12: nested functions not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:457:functionDefinition0: stmt.go:330:compoundState..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr23135.c`:        {}, // COMPILE FAIL: "\"pr23135.c:19:14: unsupported vector type: vecint (expr.go:559:expr0: expr.go:4190:primaryExpression: expr.go:4626:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValid..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr23324.c`:        {}, // COMPILE FAIL: "\"TODO (decl.go:1210:initDeclaratorInit: type.go:642:defineType: type.go:656:defineType0: type.go:578:defineUnionType: type.go:488:unionLiteral: type.go:315:typ0:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr24135.c`:        {}, // COMPILE FAIL: "\"pr24135.c:7:3: label declarations not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:401:functionDefinition0: stmt.go:330:compoundStatemen..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr34154.c`:        {}, // COMPILE FAIL: "\"TODO SelectionStatementSwitch (decl.go:401:functionDefinition0: stmt.go:330:compoundStatement: stmt.go:366:blockItem: stmt.go:42:statement: stmt.go:454:selectionStatement: stmt.go:671:selectionStatem..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr38151.c`:        {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:297:externalDeclaration: decl.go:943:declaration: type.go:559:defineStructType: type.go:494:structLiteral: type.go:263:typ0: type.go:159:typ..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr41935.c`:        {}, // COMPILE FAIL: "\"pr41935.c:10:10: TODO (expr.go:1947:postfixExpressionIndex: expr.go:101:expr: expr.go:557:expr0: expr.go:1998:postfixExpression: expr.go:1831:postfixExpressionIndex: expr.go:1781:mul:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr51447.c`:        {}, // COMPILE FAIL: "\"pr51447.c:16:3: label declarations not supported (compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:401:functionDefinition0: stmt.go:330:compoundStateme..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr53645-2.c`:      {}, // COMPILE FAIL: "\"pr53645-2.c:41:1: unsupported vector type: UV (expr.go:101:expr: expr.go:565:expr0: expr.go:1647:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr53645.c`:        {}, // COMPILE FAIL: "\"pr53645.c:41:1: unsupported vector type: UV (expr.go:101:expr: expr.go:565:expr0: expr.go:1647:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr56837.c`:        {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Complex int _Complex int (decl.go:297:externalDeclaration: decl.go:953:declaration: decl.go:1148:initDeclarator: type.go:42:typ: type.go:337:typ0: type.go:159:typ0:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr58831.c`:        {}, // COMPILE FAIL: "pr58831.o.go:489:3: undefined: \"_assert\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_test.g..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr60960.c`:        {}, // COMPILE FAIL: "\"pr60960.c:26:14: unsupported vector type: v4qi (expr.go:559:expr0: expr.go:4190:primaryExpression: expr.go:4632:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidTy..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr65427.c`:        {}, // COMPILE FAIL: "\"pr65427.c:4:3: unsupported vector type: V (decl.go:297:externalDeclaration: decl.go:953:declaration: decl.go:1148:initDeclarator: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr68249.c`:        {}, // COMPILE FAIL: "\"-: TODO (expr.go:3808:assignmentExpression: expr.go:101:expr: expr.go:541:expr0: expr.go:949:conditionalExpression: expr.go:70:topExpr: expr.go:85:expr:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr68381.c`:        {}, // COMPILE FAIL: "\"TODO unsigned short * unsigned short -> int (stmt.go:42:statement: stmt.go:401:selectionStatement: expr.go:101:expr: expr.go:557:expr0: expr.go:2057:postfixExpression: expr.go:2336:mulOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr70460.c`:        {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr70903.c`:        {}, // COMPILE FAIL: "\"TODO (expr.go:3492:postfixExpressionCall: expr.go:70:topExpr: expr.go:101:expr: expr.go:557:expr0: expr.go:2297:postfixExpression: init.go:51:initializer:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71494.c`:        {}, // COMPILE FAIL: "\"TODO <nil> (asm_386.s:1363:goexit: compile.go:460:compile: decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:387:functionDefinition0: decl.go:105:newFnCtx:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71554.c`:        {}, // COMPILE FAIL: "\"TODO unsigned * int -> int (stmt.go:42:statement: stmt.go:401:selectionStatement: expr.go:101:expr: expr.go:557:expr0: expr.go:2057:postfixExpression: expr.go:2336:mulOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71626-1.c`:      {}, // COMPILE FAIL: "\"TODO PostfixExpressionIndex (expr.go:1305:equalityExpression: expr.go:1229:binopArgs: expr.go:1234:checkVolatileExpr: expr.go:101:expr: expr.go:557:expr0: expr.go:2005:postfixExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr71626-2.c`:      {}, // COMPILE FAIL: "\"TODO PostfixExpressionIndex (expr.go:1305:equalityExpression: expr.go:1229:binopArgs: expr.go:1234:checkVolatileExpr: expr.go:101:expr: expr.go:557:expr0: expr.go:2005:postfixExpression:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr77767.c`:        {}, // COMPILE FAIL: "\"pr77767.c:4:1: incomplete type: array of int (decl.go:295:externalDeclaration: decl.go:361:functionDefinition: decl.go:381:functionDefinition0: type.go:459:isValidType1: type.go:383:isValidParamType:..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr80692.c`:        {}, // COMPILE FAIL: "\"TODO *cc.PredefinedType _Decimal64 _Decimal64 (expr.go:101:expr: expr.go:559:expr0: expr.go:4192:primaryExpression: expr.go:4654:primaryExpressionFloatConst: type.go:30:helper: type.go:159:typ0:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr82210.c`:        {}, // COMPILE FAIL: "\"pr82210.c:14:5: unsupported alignment 16 of struct T {c short} (expr.go:557:expr0: expr.go:1998:postfixExpression: expr.go:1915:postfixExpressionIndex: type.go:42:typ: type.go:65:typ0: type.go:426:is..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr84169.c`:        {}, // COMPILE FAIL: "\"TODO unsigned char * int -> T (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:557:expr0: expr.go:2057:postfixExpression: expr.go:2336:mulOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr85169.c`:        {}, // COMPILE FAIL: "\"pr85169.c:8:9: unsupported vector type: V (expr.go:101:expr: expr.go:565:expr0: expr.go:1647:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr85331.c`:        {}, // COMPILE FAIL: "\"pr85331.c:10:11: unsupported vector type: V (expr.go:559:expr0: expr.go:4192:primaryExpression: expr.go:4664:primaryExpressionFloatConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidTyp..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr88739.c`:        {}, // COMPILE FAIL: "\"TODO exprUintptr (expr.go:2114:postfixExpression: expr.go:2834:postfixExpressionSelect: expr.go:101:expr: expr.go:557:expr0: expr.go:2114:postfixExpression: expr.go:2949:postfixExpressionSelect:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr89434.c`:        {}, // COMPILE FAIL: "\"TODO int * long -> unsigned (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:557:expr0: expr.go:2057:postfixExpression: expr.go:2336:mulOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr90311.c`:        {}, // COMPILE FAIL: "\"TODO unsigned char + int -> unsigned (stmt.go:38:statement: expr.go:70:topExpr: expr.go:101:expr: expr.go:557:expr0: expr.go:2059:postfixExpression: expr.go:2387:addOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr91450-1.c`:      {}, // COMPILE FAIL: "\"TODO int * int -> unsigned long long (expr.go:1680:unaryExpression: expr.go:1234:checkVolatileExpr: expr.go:101:expr: expr.go:557:expr0: expr.go:2057:postfixExpression: expr.go:2336:mulOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr91450-2.c`:      {}, // COMPILE FAIL: "\"TODO int * int -> unsigned long long (stmt.go:42:statement: stmt.go:401:selectionStatement: expr.go:101:expr: expr.go:557:expr0: expr.go:2057:postfixExpression: expr.go:2336:mulOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr91635.c`:        {}, // COMPILE FAIL: "\"TODO int + int -> unsigned short (expr.go:529:expr0: expr.go:3923:assignmentExpression: expr.go:101:expr: expr.go:557:expr0: expr.go:2059:postfixExpression: expr.go:2387:addOverflow:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr92618.c`:        {}, // COMPILE FAIL: "\"pr92618.c:33:3: unsupported vector type: __m128i (expr.go:101:expr: expr.go:565:expr0: expr.go:1647:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94412.c`:        {}, // COMPILE FAIL: "\"pr94412.c:8:3: unsupported vector type: V (expr.go:101:expr: expr.go:565:expr0: expr.go:1647:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94524-1.c`:      {}, // COMPILE FAIL: "\"pr94524-1.c:15:20: unsupported vector type: V (expr.go:559:expr0: expr.go:4190:primaryExpression: expr.go:4643:primaryExpressionIntConst: type.go:30:helper: type.go:65:typ0: type.go:440:isValidType1:..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94524-2.c`:      {}, // COMPILE FAIL: "\"pr94524-2.c:15:20: unsupported vector type: V (expr.go:115:expr: expr.go:169:convert: expr.go:351:convertType: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/pr94591.c`:        {}, // COMPILE FAIL: "\"pr94591.c:9:3: unsupported vector type: V2SI_d (expr.go:101:expr: expr.go:565:expr0: expr.go:1647:unaryExpression: type.go:42:typ: type.go:65:typ0: type.go:440:isValidType1:)\""
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/printf-2.c`:       {}, // COMPILE FAIL: "printf-2.o.go:741:19: undefined: \"fscanf\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_test...."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/printf-chk-1.c`:   {}, // COMPILE FAIL: "printf-chk-1.o.go:793:10: undefined: \"vprintf\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/scal-to-vec1.c`:   {}, // COMPILE FAIL: "scal-to-vec1.o.go:347:17: undefined: \"main\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_tes..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/scal-to-vec2.c`:   {}, // COMPILE FAIL: "scal-to-vec2.o.go:361:17: undefined: \"main\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_tes..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/scal-to-vec3.c`:   {}, // COMPILE FAIL: "scal-to-vec3.o.go:345:17: undefined: \"main\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_tes..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/simd-6.c`:         {}, // COMPILE FAIL: "\"simd-6.c:13:14: unsupported vector type: v8qi (expr.go:559:expr0: expr.go:4190:primaryExpression: expr.go:4632:primaryExpressionIntConst: type.go:60:verifyTyp: type.go:65:typ0: type.go:440:isValidTyp..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/string-opt-18.c`:  {}, // COMPILE FAIL: "string-opt-18.o.go:355:5: undefined: \"mempcpy\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/user-printf.c`:    {}, // COMPILE FAIL: "user-printf.o.go:744:19: undefined: \"fscanf\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_te..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/va-arg-21.c`:      {}, // COMPILE FAIL: "va-arg-21.o.go:710:2: undefined: \"vprintf\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_test..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/vprintf-1.c`:      {}, // COMPILE FAIL: "vprintf-1.o.go:796:3: undefined: \"vprintf\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_test..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/vprintf-chk-1.c`:  {}, // COMPILE FAIL: "vprintf-chk-1.o.go:789:9: undefined: \"vprintf\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_..."
	`assets/github.com/gcc-mirror/gcc/gcc/testsuite/gcc.c-torture/execute/zero-struct-2.c`:  {}, // COMPILE FAIL: "\"zero-struct-2.c:15:48: TODO \\\"Xone_raw_spinlock(cgtls)\\\" from=raw_spinlock_t struct 0 exprDefault -> to=spinlock_t struct 0 exprDefault (zero-struct-2.c:15:48:) (expr.go:557:expr0: expr.go:2297:postf..."
	`assets/github.com/vnmakarov/mir/c-benchmarks/except.c`:                                 {}, // COMPILE FAIL: "except.o.go:734:5: undefined: \"_setjmp3\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_test.g..."
	`assets/github.com/vnmakarov/mir/c-benchmarks/hash.c`:                                   {}, // COMPILE FAIL: "hash.o.go:967:9: undefined: \"strdup\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_test.go:53..."
	`assets/github.com/vnmakarov/mir/c-benchmarks/hash2.c`:                                  {}, // COMPILE FAIL: "hash2.o.go:967:9: undefined: \"strdup\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_test.go:5..."
	`assets/github.com/vnmakarov/mir/c-tests/lacc/float-compare.c`:                          {}, // COMPILE FAIL: "float-compare.o.go:470:4: undefined: \"_assert\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_..."
	`assets/github.com/vnmakarov/mir/c-tests/lacc/function-incomplete.c`:                    {}, // COMPILE FAIL: "\"function-incomplete.c:6:9: too few arguments to function 'foo', type 'function(pointer to char) returning int' in 'foo()' (expr.go:1229:binopArgs: expr.go:1234:checkVolatileExpr: expr.go:101:expr: ex..."
	`assets/github.com/vnmakarov/mir/c-tests/lacc/identifier.c`:                             {}, // COMPILE FAIL: "invalid object file: multiple defintions of c (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:260:link: link.go:532:getFileSymbols:)"
	`assets/github.com/vnmakarov/mir/c-tests/lacc/initialize-call.c`:                        {}, // COMPILE FAIL: "\"initialize-call.c:25:9: TODO \\\"sigetobj(cgtls, (ppint32(2)), (ppint32(8)), (ppint32(1)))\\\" from=struct obj {s array of 3 short} struct 6 exprDefault -> to=struct {t struct obj} struct 6 exprDefault (..."
	`assets/github.com/vnmakarov/mir/c-tests/lacc/initialize-string.c`:                      {}, // COMPILE FAIL: "\"initialize-string.c:14:14: TODO \\\"\\\\\\\"wat\\\\\\\\x00\\\\\\\"\\\" from=pointer to char pointer 4 exprDefault -> to=array of 7 char array 7 exprDefault (initialize-string.c:14:14:) (decl.go:1278:initDeclaratorIn..."
	`assets/github.com/vnmakarov/mir/c-tests/lacc/pointer-immediate.c`:                      {}, // COMPILE FAIL: "pointer-immediate.o.go:542:3: undefined: \"_assert\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: ..."
	`assets/github.com/vnmakarov/mir/c-tests/lacc/string-addr.c`:                            {}, // COMPILE FAIL: "\"string-addr.c:4:16: TODO array of 6 char pointer to array of 6 char pointer to array of 6 char \\\"Hello\\\\x00\\\" (expr.go:565:expr0: expr.go:1599:unaryExpression: expr.go:101:expr: expr.go:559:expr0: ex..."
	`assets/github.com/vnmakarov/mir/c-tests/lacc/stringify.c`:                              {}, // COMPILE FAIL: "\"TODO `'\\\\xA'` -> invalid syntax (expr.go:3921:assignmentExpression: expr.go:70:topExpr: expr.go:101:expr: expr.go:559:expr0: expr.go:4194:primaryExpression: expr.go:4472:primaryExpressionCharConst:)\""
	`assets/github.com/vnmakarov/mir/c-tests/lacc/struct-padding.c`:                         {}, // COMPILE FAIL: "struct-padding.o.go:515:3: undefined: \"_assert\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all..."
	`assets/github.com/vnmakarov/mir/c-tests/new/setjmp.c`:                                  {}, // COMPILE FAIL: "setjmp.o.go:506:5: undefined: \"_setjmp3\" external (all_test.go:444:1: all_test.go:536:testExec1: ccgo.go:197:Main: ccgo.go:659:main: link.go:302:link: link.go:862:link:) (all_test.go:444:1: all_test.g..."
	`assets/tcc-0.9.27/tests/tests2/76_dollars_in_identifiers.c`:                            {}, // COMPILE FAIL: "\"76_dollars_in_identifiers.c: gofmt: exit status 2 (.:0:: asm_386.s:1363:goexit: asm_386.s:1363:goexit: asm_386.s:1363:goexit: compile.go:530:compile: compile.go:530:compile:)\""
	`assets/tcc-0.9.27/tests/tests2/87_dead_code.c`:                                         {}, // COMPILE FAIL: "\"87_dead_code.c: gofmt: exit status 2 (.:0:: asm_386.s:1363:goexit: asm_386.s:1363:goexit: asm_386.s:1363:goexit: compile.go:530:compile: compile.go:530:compile:)\""
	`assets/tcc-0.9.27/tests/tests2/95_bitfields.c`:                                         {}, // COMPILE FAIL: "\"95_bitfields.c:27:5: unsupported alignment 16 of char (expr.go:101:expr: expr.go:565:expr0: expr.go:1700:unaryExpression: type.go:395:isValidType: type.go:407:isValidType: type.go:426:isValidType1:)\""
	`assets/tcc-0.9.27/tests/tests2/95_bitfields_ms.c`:                                      {}, // COMPILE FAIL: "\"95_bitfields.c:27:5: unsupported alignment 16 of char (expr.go:101:expr: expr.go:565:expr0: expr.go:1700:unaryExpression: type.go:395:isValidType: type.go:407:isValidType: type.go:426:isValidType1:)\""
}
