/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import java.io.Serializable;
import java.time.Duration;
import java.util.Objects;

public final class EvolutionDurations
implements Comparable<EvolutionDurations>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final EvolutionDurations ZERO = EvolutionDurations.of(Duration.ZERO, Duration.ZERO, Duration.ZERO, Duration.ZERO, Duration.ZERO, Duration.ZERO, Duration.ZERO);
    private final Duration _offspringSelectionDuration;
    private final Duration _survivorsSelectionDuration;
    private final Duration _offspringAlterDuration;
    private final Duration _offspringFilterDuration;
    private final Duration _survivorFilterDuration;
    private final Duration _evaluationDuration;
    private final Duration _evolveDuration;

    EvolutionDurations(Duration offspringSelectionDuration, Duration survivorsSelectionDuration, Duration offspringAlterDuration, Duration offspringFilterDuration, Duration survivorFilterDuration, Duration evaluationDuration, Duration evolveDuration) {
        this._offspringSelectionDuration = Objects.requireNonNull(offspringSelectionDuration);
        this._survivorsSelectionDuration = Objects.requireNonNull(survivorsSelectionDuration);
        this._offspringAlterDuration = Objects.requireNonNull(offspringAlterDuration);
        this._offspringFilterDuration = Objects.requireNonNull(offspringFilterDuration);
        this._survivorFilterDuration = Objects.requireNonNull(survivorFilterDuration);
        this._evaluationDuration = Objects.requireNonNull(evaluationDuration);
        this._evolveDuration = Objects.requireNonNull(evolveDuration);
    }

    public Duration getOffspringSelectionDuration() {
        return this._offspringSelectionDuration;
    }

    public Duration getSurvivorsSelectionDuration() {
        return this._survivorsSelectionDuration;
    }

    public Duration getOffspringAlterDuration() {
        return this._offspringAlterDuration;
    }

    public Duration getOffspringFilterDuration() {
        return this._offspringFilterDuration;
    }

    public Duration getSurvivorFilterDuration() {
        return this._survivorFilterDuration;
    }

    public Duration getEvaluationDuration() {
        return this._evaluationDuration;
    }

    public Duration getEvolveDuration() {
        return this._evolveDuration;
    }

    public EvolutionDurations plus(EvolutionDurations other) {
        Objects.requireNonNull(other);
        return EvolutionDurations.of(this._offspringSelectionDuration.plus(other._offspringSelectionDuration), this._survivorsSelectionDuration.plus(other._survivorsSelectionDuration), this._offspringAlterDuration.plus(other._offspringAlterDuration), this._offspringFilterDuration.plus(other._offspringFilterDuration), this._survivorFilterDuration.plus(other._survivorFilterDuration), this._evaluationDuration.plus(other._evaluationDuration), this._evolveDuration.plus(other._evolveDuration));
    }

    @Override
    public int compareTo(EvolutionDurations other) {
        return this._evolveDuration.compareTo(other._evolveDuration);
    }

    public int hashCode() {
        int hash = 17;
        hash += 31 * Objects.hashCode(this._offspringSelectionDuration) + 17;
        hash += 31 * Objects.hashCode(this._survivorsSelectionDuration) + 17;
        hash += 31 * Objects.hashCode(this._offspringAlterDuration) + 17;
        hash += 31 * Objects.hashCode(this._offspringFilterDuration) + 17;
        hash += 31 * Objects.hashCode(this._survivorFilterDuration) + 17;
        hash += 31 * Objects.hashCode(this._evaluationDuration) + 17;
        return hash += 31 * Objects.hashCode(this._evolveDuration) + 17;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof EvolutionDurations && Objects.equals(this._offspringSelectionDuration, ((EvolutionDurations)obj)._offspringSelectionDuration) && Objects.equals(this._survivorsSelectionDuration, ((EvolutionDurations)obj)._survivorsSelectionDuration) && Objects.equals(this._offspringAlterDuration, ((EvolutionDurations)obj)._offspringAlterDuration) && Objects.equals(this._offspringFilterDuration, ((EvolutionDurations)obj)._offspringFilterDuration) && Objects.equals(this._survivorFilterDuration, ((EvolutionDurations)obj)._survivorFilterDuration) && Objects.equals(this._evaluationDuration, ((EvolutionDurations)obj)._evaluationDuration) && Objects.equals(this._evolveDuration, ((EvolutionDurations)obj)._evolveDuration);
    }

    public static EvolutionDurations of(Duration offspringSelectionDuration, Duration survivorsSelectionDuration, Duration offspringAlterDuration, Duration offspringFilterDuration, Duration survivorFilterDuration, Duration evaluationDuration, Duration evolveDuration) {
        return new EvolutionDurations(offspringSelectionDuration, survivorsSelectionDuration, offspringAlterDuration, offspringFilterDuration, survivorFilterDuration, evaluationDuration, evolveDuration);
    }
}

