/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.engine;

import io.jenetics.engine.EvolutionResult;
import io.jenetics.stat.DoubleMomentStatistics;
import io.jenetics.stat.DoubleMoments;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

final class PopulationConvergenceLimit<N extends Number>
implements Predicate<EvolutionResult<?, N>> {
    private final BiPredicate<Double, DoubleMoments> _proceed;

    PopulationConvergenceLimit(BiPredicate<Double, DoubleMoments> proceed) {
        this._proceed = Objects.requireNonNull(proceed);
    }

    @Override
    public boolean test(EvolutionResult<?, N> result) {
        DoubleMomentStatistics fitness = new DoubleMomentStatistics();
        result.getPopulation().forEach(p -> fitness.accept(((Number)p.getFitness()).doubleValue()));
        return result.getTotalGenerations() <= 1L || this._proceed.test(result.getBestFitness() != null ? ((Number)result.getBestFitness()).doubleValue() : Double.NaN, DoubleMoments.of(fitness));
    }
}

