/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics.internal.math;

import io.jenetics.internal.math.DoubleAdder;
import io.jenetics.internal.util.require;
import io.jenetics.stat.LongSummary;

public final class base {
    private base() {
        require.noInstance();
    }

    public static double[] normalize(double[] values) {
        double sum = 1.0 / DoubleAdder.sum(values);
        int i = values.length;
        while (--i >= 0) {
            values[i] = values[i] * sum;
        }
        return values;
    }

    public static double[] normalize(long[] values) {
        double[] result = new double[values.length];
        double sum = 1.0 / (double)LongSummary.sum(values);
        int i = values.length;
        while (--i >= 0) {
            result[i] = (double)values[i] * sum;
        }
        return result;
    }

    public static void divide(double[] values, double divisor) {
        int i = values.length;
        while (--i >= 0) {
            int n = i;
            values[n] = values[n] / divisor;
        }
    }

    public static long pow(long b, long e) {
        long base2 = b;
        long exp = e;
        long result = 1L;
        while (exp != 0L) {
            if ((exp & 1L) != 0L) {
                result *= base2;
            }
            exp >>>= 1;
            base2 *= base2;
        }
        return result;
    }

    public static boolean isMultiplicationSave(int a, int b) {
        long m = (long)a * (long)b;
        return (long)((int)m) == m;
    }

    public static double clamp(double v, double lo, double hi) {
        return v < lo ? lo : (v > hi ? hi : v);
    }

    public static long ulpDistance(double a, double b) {
        return Math.subtractExact(base.ulpPosition(a), base.ulpPosition(b));
    }

    public static long ulpPosition(double a) {
        long t = Double.doubleToLongBits(a);
        if (t < 0L) {
            t = Long.MIN_VALUE - t;
        }
        return t;
    }
}

