/*
 * Decompiled with CFR 0.152.
 */
package io.jenetics;

import io.jenetics.AbstractBoundedChromosome;
import io.jenetics.LongGene;
import io.jenetics.NumericChromosome;
import io.jenetics.internal.util.Equality;
import io.jenetics.internal.util.Hash;
import io.jenetics.internal.util.reflect;
import io.jenetics.util.ISeq;
import io.jenetics.util.IntRange;
import io.jenetics.util.LongRange;
import io.jenetics.util.MSeq;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class LongChromosome
extends AbstractBoundedChromosome<Long, LongGene>
implements NumericChromosome<Long, LongGene>,
Serializable {
    private static final long serialVersionUID = 2L;

    protected LongChromosome(ISeq<LongGene> genes, IntRange lengthRange) {
        super(genes, lengthRange);
    }

    public LongChromosome(Long min, Long max, IntRange lengthRange) {
        this(LongGene.seq(min, max, lengthRange), lengthRange);
        this._valid = true;
    }

    public LongChromosome(Long min, Long max, int length) {
        this(min, max, IntRange.of(length));
    }

    public LongChromosome(Long min, Long max) {
        this(min, max, 1);
    }

    public long[] toArray(long[] array2) {
        long[] a = array2.length >= this.length() ? array2 : new long[this.length()];
        int i = this.length();
        while (--i >= 0) {
            a[i] = this.longValue(i);
        }
        return a;
    }

    public long[] toArray() {
        return this.toArray(new long[this.length()]);
    }

    public static LongChromosome of(LongGene ... genes) {
        return new LongChromosome(ISeq.of(genes), IntRange.of(genes.length));
    }

    public static LongChromosome of(long min, long max, IntRange lengthRange) {
        return new LongChromosome((Long)min, (Long)max, lengthRange);
    }

    public static LongChromosome of(long min, long max, int length) {
        return new LongChromosome((Long)min, (Long)max, length);
    }

    public static LongChromosome of(LongRange range, IntRange lengthRange) {
        return new LongChromosome((Long)range.getMin(), (Long)range.getMax(), lengthRange);
    }

    public static LongChromosome of(LongRange range, int length) {
        return new LongChromosome((Long)range.getMin(), (Long)range.getMax(), length);
    }

    public static LongChromosome of(long min, long max) {
        return new LongChromosome(min, max);
    }

    public static LongChromosome of(LongRange range) {
        return new LongChromosome(range.getMin(), range.getMax());
    }

    public LongChromosome newInstance(ISeq<LongGene> genes) {
        return new LongChromosome(genes, this.lengthRange());
    }

    @Override
    public LongChromosome newInstance() {
        return new LongChromosome((Long)this._min, (Long)this._max, this.lengthRange());
    }

    @Override
    public int hashCode() {
        return Hash.of(this.getClass()).and(super.hashCode()).value();
    }

    @Override
    public boolean equals(Object obj) {
        return Equality.of(this, obj).test(x$0 -> super.equals(x$0));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.length());
        out.writeObject(this.lengthRange());
        out.writeLong((Long)this._min);
        out.writeLong((Long)this._max);
        for (LongGene gene : this._genes) {
            out.writeLong((Long)gene.getAllele());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        MSeq<LongGene> genes = MSeq.ofLength(in.readInt());
        reflect.setField(this, "_lengthRange", in.readObject());
        reflect.setField(this, "_min", in.readLong());
        reflect.setField(this, "_max", in.readLong());
        for (int i = 0; i < genes.length(); ++i) {
            genes.set(i, new LongGene(in.readLong(), (Long)this._min, (Long)this._max));
        }
        reflect.setField(this, "_genes", genes.toISeq());
    }
}

