/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.traverse;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jgrapht.DirectedGraph;
import org.jgrapht.Graph;
import org.jgrapht.event.ConnectedComponentTraversalEvent;
import org.jgrapht.event.EdgeTraversalEvent;
import org.jgrapht.event.TraversalListener;
import org.jgrapht.event.VertexTraversalEvent;
import org.jgrapht.traverse.GraphIterator;

public abstract class AbstractGraphIterator<V, E>
implements GraphIterator<V, E> {
    private List<TraversalListener<V, E>> traversalListeners = new ArrayList<TraversalListener<V, E>>();
    private boolean crossComponentTraversal = true;
    private boolean reuseEvents = false;
    protected int nListeners = 0;
    protected FlyweightEdgeEvent<V, E> reusableEdgeEvent;
    protected FlyweightVertexEvent<V> reusableVertexEvent;
    protected Specifics<V, E> specifics;

    public void setCrossComponentTraversal(boolean crossComponentTraversal) {
        this.crossComponentTraversal = crossComponentTraversal;
    }

    @Override
    public boolean isCrossComponentTraversal() {
        return this.crossComponentTraversal;
    }

    @Override
    public void setReuseEvents(boolean reuseEvents) {
        this.reuseEvents = reuseEvents;
    }

    @Override
    public boolean isReuseEvents() {
        return this.reuseEvents;
    }

    @Override
    public void addTraversalListener(TraversalListener<V, E> l) {
        if (!this.traversalListeners.contains(l)) {
            this.traversalListeners.add(l);
            this.nListeners = this.traversalListeners.size();
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeTraversalListener(TraversalListener<V, E> l) {
        this.traversalListeners.remove(l);
        this.nListeners = this.traversalListeners.size();
    }

    protected void fireConnectedComponentFinished(ConnectedComponentTraversalEvent e) {
        for (int i = 0; i < this.nListeners; ++i) {
            TraversalListener<V, E> l = this.traversalListeners.get(i);
            l.connectedComponentFinished(e);
        }
    }

    protected void fireConnectedComponentStarted(ConnectedComponentTraversalEvent e) {
        for (int i = 0; i < this.nListeners; ++i) {
            TraversalListener<V, E> l = this.traversalListeners.get(i);
            l.connectedComponentStarted(e);
        }
    }

    protected void fireEdgeTraversed(EdgeTraversalEvent<E> e) {
        for (int i = 0; i < this.nListeners; ++i) {
            TraversalListener<V, E> l = this.traversalListeners.get(i);
            l.edgeTraversed(e);
        }
    }

    protected void fireVertexTraversed(VertexTraversalEvent<V> e) {
        for (int i = 0; i < this.nListeners; ++i) {
            TraversalListener<V, E> l = this.traversalListeners.get(i);
            l.vertexTraversed(e);
        }
    }

    protected void fireVertexFinished(VertexTraversalEvent<V> e) {
        for (int i = 0; i < this.nListeners; ++i) {
            TraversalListener<V, E> l = this.traversalListeners.get(i);
            l.vertexFinished(e);
        }
    }

    static <V, E> Specifics<V, E> createGraphSpecifics(Graph<V, E> g) {
        if (g instanceof DirectedGraph) {
            return new DirectedSpecifics((DirectedGraph)g);
        }
        return new UndirectedSpecifics<V, E>(g);
    }

    static class UndirectedSpecifics<VV, EE>
    extends Specifics<VV, EE> {
        private Graph<VV, EE> graph;

        public UndirectedSpecifics(Graph<VV, EE> g) {
            this.graph = g;
        }

        @Override
        public Set<EE> edgesOf(VV vertex) {
            return this.graph.edgesOf(vertex);
        }
    }

    static class DirectedSpecifics<VV, EE>
    extends Specifics<VV, EE> {
        private DirectedGraph<VV, EE> graph;

        public DirectedSpecifics(DirectedGraph<VV, EE> g) {
            this.graph = g;
        }

        @Override
        public Set<? extends EE> edgesOf(VV vertex) {
            return this.graph.outgoingEdgesOf(vertex);
        }
    }

    static abstract class Specifics<VV, EE> {
        Specifics() {
        }

        public abstract Set<? extends EE> edgesOf(VV var1);
    }

    static class FlyweightVertexEvent<VV>
    extends VertexTraversalEvent<VV> {
        private static final long serialVersionUID = 3834024753848399924L;

        public FlyweightVertexEvent(Object eventSource, VV vertex) {
            super(eventSource, vertex);
        }

        protected void setVertex(VV vertex) {
            this.vertex = vertex;
        }
    }

    static class FlyweightEdgeEvent<VV, localE>
    extends EdgeTraversalEvent<localE> {
        private static final long serialVersionUID = 4051327833765000755L;

        public FlyweightEdgeEvent(Object eventSource, localE edge) {
            super(eventSource, edge);
        }

        protected void setEdge(localE edge) {
            this.edge = edge;
        }
    }
}

