/*
 * Decompiled with CFR 0.152.
 */
package com.axlradius.radclient4.dictionary;

import com.axlradius.radclient4.RADIUSException;
import com.axlradius.radclient4.attributes.Attribute;
import com.axlradius.radclient4.attributes.VendorSpecific;
import java.io.IOException;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RADIUSDictionary
implements Comparable {
    private String p;
    private ArrayDeque<b> b = new ArrayDeque();
    private Map<Integer, c> c = new HashMap<Integer, c>();
    private Map<String, c> d = new HashMap<String, c>();
    private Map<String, Map<String, Integer>> e = new HashMap<String, Map<String, Integer>>();
    private Map<String, a> f = new HashMap<String, a>();
    private Map<String, a> g = new HashMap<String, a>();
    private int al = 0;
    private boolean w = false;
    private int hashCode;
    private long i;
    public static final int UNKNOWN_VENDOR = 0;
    public static final int UNKNOWN_TAG = 0;
    public static final int UNKNOWN_TYPE = 0;
    public static final int UNKNOWN_VALUE = -1;
    public static final int INTEGER = 1;
    public static final int OCTETS = 2;
    public static final int STRING = 4;
    public static final int DATE = 8;
    public static final int IPADDRESS = 16;
    public static final int TUNNEL = 32;
    public static final int ENCRYPT1 = 64;
    public static final int ENCRYPT2 = 128;
    public static final int ENCRYPT3 = 256;
    public static final int IPV6ADDRESS = 512;
    public static final int IPV6PREFIX = 1024;
    public static final int ETHER = 2048;
    public static final int IFID = 4096;
    public static final int ABINARY = 8192;
    public static final int BYTE = 16384;
    public static final int SHORT = 32768;
    public static final int TLV = 65536;
    public static final int COMBO_IP = 131072;
    public static final int TEXT = 262144;
    public static final int SIGNED = 524288;
    public static final int WIMAX_TLV = 0x100000;
    public static final boolean SHORT_TAGS = false;
    public static final boolean LONG_TAGS = true;

    public RADIUSDictionary(String string) throws IOException {
        this.p = string;
        new a(this);
        this.addVendor("", 0);
        this.i = System.currentTimeMillis();
        this.read();
    }

    public RADIUSDictionary() {
        this.p = "No souce file";
        new a(this);
        this.addVendor("", 0);
        this.i = System.currentTimeMillis();
    }

    public void read() throws IOException {
        throw new IOException("This method must be overridden by a parser for a particular style of dictionary.");
    }

    public String getDictionaryFileName() {
        return this.p;
    }

    public void add(String string, int n2, int n3) {
        this.add(string, n2, n3, this.al, false);
    }

    public void add(String string, int n2, int n3, int n4) {
        this.add(string, n2, n3, n4, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String object, int n2, int n3, int n4, boolean bl) {
        Map<String, a> map = this.f;
        synchronized (map) {
            object = new a(this, (String)object, n2, n3, n4);
            if (bl) {
                ((a)object).n();
            }
            this.f.put(((a)object).b(), (a)object);
            this.g.put(((a)object).c(), (a)object);
            return;
        }
    }

    public void add(String string, String string2, String string3, String string4) throws IOException {
        this.add(string, string2, string3, string4, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String object, String string, String string2, String string3, boolean bl) throws IOException {
        Map<String, a> map = this.f;
        synchronized (map) {
            object = new a(this, (String)object, string, string2, string3);
            if (bl) {
                ((a)object).n();
            }
            this.f.put(((a)object).b(), (a)object);
            this.g.put(((a)object).c(), (a)object);
            return;
        }
    }

    public Attribute createAttribute(String string, String string2) {
        int n2;
        String[] stringArray;
        if (string.indexOf(".") > 0 && (stringArray = string.split("\\.")).length == 2 && (n2 = this.getVendorId(stringArray[0])) != 0) {
            return this.createAttribute(n2, stringArray[1], string2);
        }
        return this.createAttribute(this.al, string, string2);
    }

    public Attribute createAttribute(String string, byte[] byArray) {
        int n2;
        String[] stringArray;
        if (string.indexOf(".") > 0 && (stringArray = string.split("\\.")).length == 2 && (n2 = this.getVendorId(stringArray[0])) != 0) {
            return this.createAttribute(n2, stringArray[1], byArray);
        }
        return this.createAttribute(this.al, string, byArray);
    }

    public Attribute createAttribute(int n2, String string, String string2) {
        int n3 = this.getTag(n2, string);
        if (n3 == 0) {
            return null;
        }
        int n4 = this.a(n2, string, string2);
        if (n4 == -1) {
            return null;
        }
        byte[] byArray = com.axlradius.misc.b.a(n4);
        if (n2 > 0) {
            VendorSpecific vendorSpecific = new VendorSpecific(n2, this.getVendorTagLength(n2));
            vendorSpecific.add(n3, byArray);
            return vendorSpecific.getAttribute();
        }
        return new Attribute(n3, byArray);
    }

    public Attribute createAttribute(int n2, String string, byte[] byArray) {
        int n3 = this.getTag(n2, string);
        if (n3 == 0) {
            return null;
        }
        return this.createAttribute(n2, n3, byArray);
    }

    public Attribute createAttribute(int n2, int n3, byte[] byArray) {
        if (n2 > 0) {
            VendorSpecific vendorSpecific = new VendorSpecific(n2, this.getVendorTagLength(n2));
            vendorSpecific.add(n3, byArray);
            return vendorSpecific.getAttribute();
        }
        return new Attribute(n3, byArray);
    }

    public Attribute createAttribute(String string, InetAddress inetAddress) {
        int n2;
        String[] stringArray;
        if (string.indexOf(".") > 0 && (stringArray = string.split("\\.")).length == 2 && (n2 = this.getVendorId(stringArray[0])) != 0) {
            return this.createAttribute(n2, stringArray[1], inetAddress.getAddress());
        }
        return this.createAttribute(this.al, string, inetAddress.getAddress());
    }

    public Attribute createAttribute(String string, int n2) {
        int n3;
        String[] stringArray;
        if (string.indexOf(".") > 0 && (stringArray = string.split("\\.")).length == 2 && (n3 = this.getVendorId(stringArray[0])) != 0) {
            return this.createAttribute(n3, stringArray[1], n2);
        }
        return this.createAttribute(this.al, string, n2);
    }

    public Attribute createAttribute(int n2, String string, int n3) {
        byte[] byArray;
        int n4 = this.getTag(n2, string);
        if (n4 == 0) {
            return null;
        }
        if (this.getDataType(n2, n4) == 32768) {
            byte[] byArray2 = new byte[2];
            byArray = byArray2;
            byArray2[0] = (byte)(n3 >> 8);
            byArray[1] = (byte)n3;
        } else {
            byArray = com.axlradius.misc.b.a(n3);
        }
        return this.createAttribute(n2, n4, byArray);
    }

    public void setVendorId(int n2) {
        this.al = n2;
    }

    public int getVendorId() {
        return this.al;
    }

    public int getDataType(int n2) {
        return this.getDataType(this.al, n2);
    }

    public int getDataType(int n2, int n3) {
        a a2 = this.f.get(a.c(n2, n3));
        if (a2 == null) {
            return 0;
        }
        return a2.type;
    }

    public String getDataTypeName(int n2) {
        String string = "";
        if ((n2 & 0x20) == 32) {
            string = "TUNNEL / ";
            n2 &= 0xFFFFFFDF;
        }
        if ((n2 & 0x40) == 64) {
            string = "ENCRYPT1 / ";
            n2 &= 0xFFFFFFBF;
        }
        if ((n2 & 0x80) == 128) {
            string = "ENCRYPT2 / ";
            n2 &= 0xFFFFFF7F;
        }
        if ((n2 & 0x100) == 256) {
            string = "ENCRYPT3 / ";
            n2 &= 0xFFFFFEFF;
        }
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                string = string + "INTEGER";
                break;
            }
            case 2: {
                string = string + "OCTETS";
                break;
            }
            case 4: {
                string = string + "STRING";
                break;
            }
            case 8: {
                string = string + "DATE";
                break;
            }
            case 16: {
                string = string + "IPADDRESS";
                break;
            }
            case 512: {
                string = string + "IPV6ADDRESS";
                break;
            }
            case 1024: {
                string = string + "IPV6PREFIX";
                break;
            }
            case 2048: {
                string = string + "ETHER";
                break;
            }
            case 4096: {
                string = string + "IFID";
                break;
            }
            case 8192: {
                string = string + "ABINARY";
                break;
            }
            case 16384: {
                string = string + "BYTE";
                break;
            }
            case 32768: {
                string = string + "SHORT";
                break;
            }
            case 65536: {
                string = string + "TLV";
                break;
            }
            case 131072: {
                string = string + "COMBO_IP";
                break;
            }
            case 262144: {
                string = string + "TEXT";
                break;
            }
            case 524288: {
                string = string + "SIGNED";
                break;
            }
            default: {
                string = string + "UNKNOWN (" + n2 + ")";
            }
        }
        return string;
    }

    public int getTag(int n2, String string) {
        a a2 = this.g.get(a.a(n2, string));
        if (a2 == null) {
            return 0;
        }
        return a2.tag;
    }

    public int getTag(String string) {
        return this.getTag(this.al, string);
    }

    public int getVendorId(String object) {
        if ((object = this.d.get(object)) == null) {
            return 0;
        }
        return ((c)object).Q;
    }

    public String getName(int n2, int n3) {
        a a2 = this.f.get(a.c(n2, n3));
        if (a2 == null) {
            return null;
        }
        return a2.name;
    }

    public String getName(int n2) {
        return this.getName(this.al, n2);
    }

    public boolean hasValue(int n2) {
        return this.hasValue(this.al, n2);
    }

    public boolean hasValue(String string) {
        return this.e.get(string) != null;
    }

    public int getEncryptionType(int n2) {
        return this.getEncryptionType(this.al, n2);
    }

    public int getEncryptionType(int n2, int n3) {
        a a2 = this.f.get(a.c(n2, n3));
        if (a2 == null) {
            return 0;
        }
        return a2.type & 0xC0;
    }

    public void setEncryptionType(int n2, int n3) {
        this.setEncryptionType(this.al, n2, n3);
    }

    public void setEncryptionType(int n2, int n3, int n4) {
        a a2 = this.f.get(a.c(n2, n3));
        if (a2 != null) {
            n3 = n4;
            a2.type |= n3;
        }
    }

    public void setTLVType(int n2, int n3) {
        this.setTLVType(this.al, n2, n3);
    }

    public void setTLVType(int n2, int n3, int n4) {
        a a2 = this.f.get(a.c(n2, n3));
        if (a2 != null) {
            n3 = n4;
            a2.type |= n3;
        }
    }

    public int getDataTypeFlags(int n2) {
        return this.getDataTypeFlags(this.al, n2);
    }

    public int getDataTypeFlags(int n2, int n3) {
        a a2 = this.f.get(a.c(n2, n3));
        if (a2 != null) {
            return a2.type;
        }
        return 0;
    }

    public boolean hasValue(int n2, int n3) {
        String string = this.getName(n2, n3);
        return this.e.get(string) != null;
    }

    public Iterator attributeIterator() {
        return this.attributeIterator(this.al);
    }

    public Iterator<String> attributeIterator(int n2) {
        return new com.axlradius.radclient4.dictionary.a(this, n2);
    }

    public boolean isVSA(int n2) {
        return n2 == 26;
    }

    public boolean isVSA(String string) {
        return string.equals("Vendor-Specific");
    }

    public void setTunnel(int n2) {
        this.setTunnel(this.al, n2);
    }

    public void setTunnel(int n2, int n3) {
        this.f.get(a.c(n2, n3)).n();
    }

    public boolean isTunnel(int n2) {
        return this.isTunnel(this.al, n2);
    }

    public boolean isTunnel(int n2, int n3) {
        return (this.f.get((Object)a.c((int)n2, (int)n3)).type & 0x20) == 32;
    }

    public int getIntValue(int n2, String string) {
        String string2 = this.getName(n2);
        if (string2 == null) {
            return -1;
        }
        RADIUSDictionary rADIUSDictionary = this;
        String string3 = string2;
        string2 = string;
        string = string3;
        return rADIUSDictionary.a(rADIUSDictionary.al, string, string2);
    }

    public int getIntValue(int n2, int n3, String string) {
        String string2 = this.getName(n2, n3);
        if (string2 == null) {
            return -1;
        }
        return this.a(n2, string2, string);
    }

    public String getValueName(int n2, int n3) {
        String string = this.getName(n2);
        return this.a(string, n3);
    }

    public String[] getAllValueNames(int n2, String stringArray) {
        Object object = a.a(n2, (String)stringArray);
        stringArray = new String[]{};
        if ((object = this.e.get(object)) == null) {
            return stringArray;
        }
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(object.keySet());
        return arrayList.toArray(stringArray);
    }

    public String[] getAllValueNames(String string) {
        return this.getAllValueNames(this.al, string);
    }

    public String getValueName(int n2, int n3, int n4) {
        String string = this.getName(n2, n3);
        return this.a(string, n4);
    }

    public void addVendor(String string, String string2) throws IllegalArgumentException {
        try {
            int n2 = Integer.parseInt(string2);
            this.addVendor(string, n2);
            return;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(this.getIncludeInformation() + " '" + string2 + "' Expecting a number.");
        }
    }

    public void addVendor(String string, int n2) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("Vendor name is null");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Vendor ID is negative");
        }
        if (n2 == 0 && string.length() != 0) {
            throw new IllegalArgumentException("Vendor ID is 0 but there is a vendor name present.");
        }
        if (string.length() == 0 && n2 != 0) {
            throw new IllegalArgumentException("Vendor name length is 0 but there is a non-zero vendor id present.");
        }
        c c2 = new c(n2, string);
        this.c.put(n2, c2);
        this.d.put(string, c2);
        this.w = true;
    }

    public String[] getVendorNames() {
        String[] stringArray = new String[this.d.size() - 1];
        int n2 = 0;
        for (String string : this.d.keySet()) {
            if (string.length() == 0) continue;
            stringArray[n2++] = string;
        }
        return stringArray;
    }

    public int[] getVendorIds() {
        String[] stringArray = this.getVendorNames();
        int[] nArray = new int[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            nArray[i2] = this.getVendorId(stringArray[i2]);
        }
        return nArray;
    }

    public String getVendorName(int n2) {
        c c2 = this.c.get(n2);
        if (c2 != null) {
            return c2.vendorName;
        }
        return null;
    }

    public void setVendorTagLength(boolean bl) {
        if (this.al == 0) {
            return;
        }
        this.setVendorTagLength(this.al, bl);
    }

    public void setVendorTagLength(int n2, boolean bl) {
        if (n2 == 0) {
            return;
        }
        c c2 = this.c.get(n2);
        if (c2 != null) {
            c2.x = bl;
        }
    }

    public boolean getVendorTagLength() {
        return this.getVendorTagLength(this.al);
    }

    public boolean getVendorTagLength(int n2) {
        c c2 = this.c.get(n2);
        if (c2 != null) {
            return c2.x;
        }
        return false;
    }

    public void merge(RADIUSDictionary rADIUSDictionary) {
        int n2;
        Object[] objectArray = rADIUSDictionary.getVendorNames();
        String[] stringArray = new String[objectArray.length + 1];
        System.arraycopy(objectArray, 0, stringArray, 0, objectArray.length);
        stringArray[objectArray.length] = "";
        objectArray = new int[stringArray.length + 1];
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            objectArray[n2] = (String)rADIUSDictionary.getVendorId(stringArray[n2]);
        }
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            String string = objectArray[n2];
            Iterator<String> iterator = rADIUSDictionary.attributeIterator((int)string);
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                int n3 = rADIUSDictionary.getTag((int)string, string2);
                int n4 = rADIUSDictionary.getDataType((int)string, n3);
                int n5 = rADIUSDictionary.getEncryptionType((int)string, n3);
                int n6 = rADIUSDictionary.isTunnel((int)string, n3);
                this.add(string2, n3, n4, (int)string, n6 != 0);
                this.setEncryptionType((int)string, n3, n5);
                for (String string3 : rADIUSDictionary.getAllValueNames(string2)) {
                    int n7 = rADIUSDictionary.getIntValue((int)string, n3, string3);
                    this.setSymbolicIntValue((int)string, string2, string3, n7);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\nVendors: (").append(this.d.size()).append(')').append("\n");
        Map<String, c> map = this.d;
        synchronized (map) {
            for (Map.Entry<String, c> entry : this.d.entrySet()) {
                if (entry.getKey().equals("")) continue;
                stringBuilder.append("   ").append((Object)entry.getKey()).append("\n");
            }
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toVerboseString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getName());
        stringBuilder.append(this.toString()).append("\n");
        stringBuilder.append("Attributes:\n");
        Map<String, a> map = this.f;
        synchronized (map) {
            Iterator<Map.Entry<String, a>> iterator = this.f.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next().getValue();
                stringBuilder.append("     ").append(object).append("\n");
                object = this.e.get(((a)object).name);
                if (object == null) continue;
                for (Map.Entry entry : object.entrySet()) {
                    stringBuilder.append("          ").append(entry.getKey()).append("->").append(entry.getValue());
                    stringBuilder.append("\n");
                }
            }
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public void pushIncludeFile(String object, LineNumberReader lineNumberReader) {
        object = new b((String)object, lineNumberReader);
        this.b.push((b)object);
    }

    public void popIncludeFile() {
        this.b.pop();
    }

    public String getIncludeInformation() {
        b b2 = this.b.peek();
        return b2.getFileName() + "':" + b2.a().getLineNumber();
    }

    public void setSymbolicIntValue(String string, String string2, int n2) {
        this.setSymbolicIntValue(this.al, string, string2, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSymbolicIntValue(int n2, String object, String string, int n3) {
        String string2 = a.a(n2, (String)object);
        object = this.e;
        synchronized (object) {
            Map<String, Integer> map = this.e.get(string2);
            if (map == null) {
                map = new HashMap<String, Integer>();
                this.e.put(string2, map);
            }
            map.put(string, n3);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int a(int n2, String object, String string) {
        Object object2 = a.a(n2, (String)object);
        object = this.e;
        synchronized (object) {
            object2 = this.e.get(object2);
            if (object2 == null) {
                return -1;
            }
            int n3 = (object2 = (Integer)object2.get(string)) == null ? -1 : (Integer)object2;
            return n3;
        }
    }

    private String a(String string, int n2) {
        return this.a(this.al, string, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String a(int n2, String object, int n3) {
        Iterator iterator = a.a(n2, (String)object);
        object = this.e;
        synchronized (object) {
            iterator = this.e.get(iterator);
            if (iterator == null) {
                return null;
            }
            for (Map.Entry entry : iterator.entrySet()) {
                if ((Integer)entry.getValue() != n3) continue;
                return (String)entry.getKey();
            }
            return null;
        }
    }

    public boolean equals(Object object) {
        String string;
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.hashCode() == object.hashCode() && (string = RADIUSDictionary.a(((RADIUSDictionary)object).getVendorNames())).equals(object = RADIUSDictionary.a(this.getVendorNames()));
    }

    public int compareTo(Object object) {
        int n2 = this.hashCode() - object.hashCode();
        long l2 = ((RADIUSDictionary)object).getCreationTime();
        if (this.getCreationTime() > l2) {
            ++n2;
        }
        return n2;
    }

    public long getCreationTime() {
        return this.i;
    }

    public boolean isLater(RADIUSDictionary rADIUSDictionary) {
        if (!this.equals(rADIUSDictionary)) {
            return false;
        }
        return this.getCreationTime() > rADIUSDictionary.getCreationTime();
    }

    public int hashCode() {
        if (this.w || this.hashCode == 0) {
            String string = RADIUSDictionary.a(this.getVendorNames());
            this.hashCode = string.hashCode();
            this.w = false;
        }
        return this.hashCode;
    }

    private static String a(String[] stringArray) {
        Arrays.sort(stringArray);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string.toLowerCase()).append(":");
        }
        return stringBuilder.toString();
    }

    static /* synthetic */ Map a(RADIUSDictionary rADIUSDictionary) {
        return rADIUSDictionary.f;
    }

    final class b {
        private LineNumberReader a;
        private String fileName;

        b(String string, LineNumberReader lineNumberReader) {
            this.fileName = string;
            this.a = lineNumberReader;
        }

        final LineNumberReader a() {
            return this.a;
        }

        final String getFileName() {
            return this.fileName;
        }
    }

    final class a {
        String name;
        int tag;
        int type;
        int Q;
        private /* synthetic */ RADIUSDictionary a;

        a(RADIUSDictionary rADIUSDictionary) {
            this.a = rADIUSDictionary;
        }

        a(RADIUSDictionary rADIUSDictionary, String object, String string, String string2, String string3) throws RADIUSException {
            this.a = rADIUSDictionary;
            this.name = object;
            try {
                this.tag = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    object = string.substring(2);
                    this.tag = Integer.parseInt((String)object, 16);
                }
                catch (NumberFormatException numberFormatException2) {
                    throw new RADIUSException(rADIUSDictionary.getIncludeInformation() + " Expecting a number, found '" + string + "'");
                }
            }
            this.type = string2.equalsIgnoreCase("string") ? 4 : (string2.equalsIgnoreCase("integer") ? 1 : (string2.equalsIgnoreCase("ipaddr") ? 16 : (string2.equalsIgnoreCase("ipv6addr") ? 512 : (string2.equalsIgnoreCase("ipv6prefix") ? 1024 : (string2.equalsIgnoreCase("ether") ? 2048 : (string2.equalsIgnoreCase("ifid") ? 4096 : (string2.equalsIgnoreCase("abinary") ? 8192 : (string2.equalsIgnoreCase("byte") ? 16384 : (string2.equalsIgnoreCase("date") ? 8 : (string2.equalsIgnoreCase("octets") ? 2 : (string2.equalsIgnoreCase("short") ? 32768 : (string2.equalsIgnoreCase("ether") ? 2048 : (string2.equalsIgnoreCase("tlv") ? 65536 : (string2.equalsIgnoreCase("combo-ip") ? 131072 : 0))))))))))))));
            if (string3 != null && !string3.equals("")) {
                object = (c)rADIUSDictionary.d.get(string3);
                if (object == null) {
                    throw new RADIUSException(rADIUSDictionary.getIncludeInformation() + " No such vendor as '" + string3 + "'");
                }
                this.Q = ((c)object).Q;
                return;
            }
            this.Q = 0;
        }

        a(RADIUSDictionary rADIUSDictionary, String string, int n2, int n3, int n4) {
            this.a = rADIUSDictionary;
            this.name = string;
            this.tag = n2;
            this.type = n3;
            this.Q = n4;
        }

        final String b() {
            return com.axlradius.radclient4.dictionary.RADIUSDictionary$a.c(this.Q, this.tag);
        }

        final String c() {
            return com.axlradius.radclient4.dictionary.RADIUSDictionary$a.a(this.Q, this.name);
        }

        static String c(int n2, int n3) {
            if (n2 == 0) {
                return "0:" + n3;
            }
            return n2 + ":" + n3;
        }

        static String a(int n2, String string) {
            if (n2 == 0) {
                return "0:" + string;
            }
            return n2 + ":" + string;
        }

        final void n() {
            this.type |= 0x20;
        }

        public final String toString() {
            StringBuilder stringBuilder = new StringBuilder("AttributeData: ");
            if (this.Q > 0) {
                c c2 = (c)this.a.c.get(this.Q);
                stringBuilder.append(c2.vendorName).append(" (").append(c2.Q).append("): ");
                if (c2.x) {
                    stringBuilder.append("Long Tags, ");
                }
            }
            stringBuilder.append("Attr ").append(this.name).append("(").append(this.tag).append("), ");
            stringBuilder.append("Type=");
            switch (this.type) {
                case 2: {
                    stringBuilder.append("octets");
                    break;
                }
                case 4: {
                    stringBuilder.append("string");
                    break;
                }
                case 1: {
                    stringBuilder.append("integer");
                    break;
                }
                case 8: {
                    stringBuilder.append("date");
                    break;
                }
                case 16: {
                    stringBuilder.append("ipaddr");
                    break;
                }
                case 512: {
                    stringBuilder.append("ipV6addr");
                    break;
                }
                case 1024: {
                    stringBuilder.append("ipv6prefix");
                    break;
                }
                case 4096: {
                    stringBuilder.append("ifid");
                    break;
                }
                case 2048: {
                    stringBuilder.append("ether");
                    break;
                }
                case 8192: {
                    stringBuilder.append("abinary");
                    break;
                }
                case 65536: {
                    stringBuilder.append("tlv");
                    break;
                }
                default: {
                    stringBuilder.append("unknown");
                }
            }
            return stringBuilder.toString();
        }
    }

    final class c {
        int Q;
        String vendorName;
        boolean x = false;

        c(int n2, String string) {
            this.Q = n2;
            this.vendorName = string;
        }
    }
}

