/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.java.impl.Bundle;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.utils.StringUtils;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.api.ProfilerStorage;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.WindowManager;

class JavaDiffDumpSelector {
    private static final Icon memoryIcon = Icons.getIcon((String)"ProfilerIcons.HeapDump");
    private static JFileChooser snapshotFileChooser;
    private HeapContext context;
    private boolean compareRetained;
    private SelectSecondSnapshotPanel secondSnapshotSelector;
    private static final String HPROF_HEADER = "JAVA PROFILE 1.0";
    private static final long MIN_HPROF_SIZE = 0x100000L;
    private static final String HEAPDUMP_PREFIX = "heapdump-";
    private static final long MINIMAL_TIMESTAMP = 946684800000L;

    private JavaDiffDumpSelector(HeapContext context, boolean compareRetained) {
        this.context = context;
        this.compareRetained = compareRetained;
    }

    static void checkObjectSizes(Heap heap1, Heap heap2) {
        JavaClass objcls1 = heap1.getJavaClassByName("java.lang.Object");
        JavaClass objcls2 = heap2.getJavaClassByName("java.lang.Object");
        if (objcls1.getInstanceSize() != objcls2.getInstanceSize()) {
            ProfilerDialogs.displayWarningDNSA((String)Bundle.CompareSnapshotsHelper_DifferentObjectSize(), (String)Bundle.CompareSnapshotsHelper_CaptionWarning(), null, (String)"CompareSnapshotsHelper.checkObjectSizes", (boolean)false);
        }
    }

    static Result selectSnapshot(HeapContext context, boolean compareRetained) {
        JavaDiffDumpSelector helper = new JavaDiffDumpSelector(context, compareRetained);
        SelectSecondSnapshotPanel panel = helper.getSecondSnapshotSelector();
        panel.populateSnapshotsList();
        DialogDescriptor desc = new DialogDescriptor((Object)panel, Bundle.CompareSnapshotsHelper_SelectDialogCaption(), true, new Object[]{panel.getOKButton(), DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
        Object res = DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
        return !res.equals(panel.getOKButton()) ? null : new Result(panel.getSnapshot(), panel.computeRetained());
    }

    private static JFileChooser getSnapshotFileChooser() {
        if (snapshotFileChooser == null) {
            snapshotFileChooser = new JFileChooser();
            snapshotFileChooser.setAcceptAllFileFilterUsed(false);
            snapshotFileChooser.setFileSelectionMode(0);
            snapshotFileChooser.setMultiSelectionEnabled(false);
            snapshotFileChooser.setDialogType(0);
            snapshotFileChooser.setDialogTitle(Bundle.CompareSnapshotsHelper_OpenChooserCaption());
            snapshotFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return f.isDirectory() || JavaDiffDumpSelector.checkHprofFile(f);
                }

                @Override
                public String getDescription() {
                    return Bundle.CompareSnapshotsHelper_OpenChooserFilter();
                }
            });
        }
        return snapshotFileChooser;
    }

    private SelectSecondSnapshotPanel getSecondSnapshotSelector() {
        if (this.secondSnapshotSelector == null) {
            this.secondSnapshotSelector = new SelectSecondSnapshotPanel();
        }
        return this.secondSnapshotSelector;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean checkHprofFile(File file) {
        if (!file.isFile()) return false;
        if (!file.canRead()) return false;
        if (file.length() <= 0x100000L) return false;
        byte[] prefix = new byte[HPROF_HEADER.length() + 4];
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            raf.readFully(prefix);
            if (!new String(prefix).startsWith(HPROF_HEADER)) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            return false;
        }
    }

    static FileObject[] listSavedHeapdumps(File directory) {
        try {
            FileObject snapshotsFolder = null;
            snapshotsFolder = directory != null ? FileUtil.toFileObject((File)directory) : ProfilerStorage.getGlobalFolder((boolean)false);
            if (snapshotsFolder == null) {
                return new FileObject[0];
            }
            snapshotsFolder.refresh();
            FileObject[] children = snapshotsFolder.getChildren();
            ArrayList<FileObject> files = new ArrayList<FileObject>();
            for (FileObject child : children) {
                if (!JavaDiffDumpSelector.checkHprofFile(FileUtil.toFile((FileObject)child))) continue;
                files.add(child);
            }
            files.sort((o1, o2) -> o1.getName().compareTo(o2.getName()));
            return files.toArray(new FileObject[0]);
        }
        catch (IOException e) {
            return new FileObject[0];
        }
    }

    static String getHeapDumpDisplayName(String fileName) {
        String displayName;
        block5: {
            if (fileName.startsWith(HEAPDUMP_PREFIX)) {
                String time = fileName.substring(HEAPDUMP_PREFIX.length());
                try {
                    long timeStamp = Long.parseLong(time);
                    if (timeStamp > 946684800000L) {
                        displayName = StringUtils.formatUserDate((Date)new Date(timeStamp));
                        break block5;
                    }
                    displayName = fileName;
                }
                catch (NumberFormatException e) {
                    displayName = fileName;
                }
            } else {
                displayName = fileName;
            }
        }
        return displayName;
    }

    static class Result {
        private File file;
        private boolean compareRetained;

        Result(File file, boolean compareRetained) {
            this.file = file;
            this.compareRetained = compareRetained;
        }

        File getFile() {
            return this.file;
        }

        boolean compareRetained() {
            return this.compareRetained;
        }
    }

    private class SelectSecondSnapshotPanel
    extends JPanel {
        private JButton externalFileButton;
        private JButton okButton;
        private JLabel externalFileHintLabel;
        private JLabel projectSnapshotsHintLabel;
        private JLabel selectSnapshotLabel;
        private JList projectSnapshotsList;
        private JRadioButton fromFileRadio;
        private JRadioButton fromProjectRadio;
        private JTextField externalFileField;
        private JCheckBox compareRetainedCheckBox;

        SelectSecondSnapshotPanel() {
            this.initComponents();
        }

        JButton getOKButton() {
            return this.okButton;
        }

        File getSnapshot() {
            if (this.fromProjectRadio.isSelected()) {
                Object selectedItem = this.projectSnapshotsList.getSelectedValue();
                if (!(selectedItem instanceof FileObject)) {
                    return null;
                }
                return FileUtil.toFile((FileObject)((FileObject)selectedItem));
            }
            if (this.fromFileRadio.isSelected()) {
                File s;
                String sf = this.externalFileField.getText();
                if (!sf.isEmpty() && (s = new File(sf)).exists() && s.isFile()) {
                    return s;
                }
                return null;
            }
            return null;
        }

        boolean computeRetained() {
            return this.compareRetainedCheckBox.isSelected();
        }

        void populateSnapshotsList() {
            DefaultListModel listModel = (DefaultListModel)this.projectSnapshotsList.getModel();
            listModel.removeAllElements();
            File heapdumpFile = JavaDiffDumpSelector.this.context.getFile();
            final File heapdumpDir = heapdumpFile != null ? heapdumpFile.getParentFile() : null;
            FileObject[] snapshotsOnDisk = JavaDiffDumpSelector.listSavedHeapdumps(heapdumpDir);
            FileObject snapshotFile = heapdumpFile != null ? FileUtil.toFileObject((File)heapdumpFile) : null;
            for (FileObject snapshotsOnDisk1 : snapshotsOnDisk) {
                if (snapshotsOnDisk1.equals(snapshotFile)) continue;
                listModel.addElement(snapshotsOnDisk1);
            }
            if (listModel.getSize() == 0) {
                listModel.addElement(Bundle.CompareSnapshotsHelper_NoComparableSnapshotsFoundMsg());
                this.fromFileRadio.setSelected(true);
                this.externalFileField.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if ((e.getChangeFlags() & 4L) != 0L && SelectSecondSnapshotPanel.this.externalFileField.isShowing()) {
                            SelectSecondSnapshotPanel.this.externalFileField.removeHierarchyListener(this);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SelectSecondSnapshotPanel.this.externalFileField.requestFocusInWindow();
                                }
                            });
                        }
                    }
                });
            } else {
                this.projectSnapshotsList.setSelectedIndex(0);
                this.projectSnapshotsList.addHierarchyListener(new HierarchyListener(){

                    @Override
                    public void hierarchyChanged(HierarchyEvent e) {
                        if ((e.getChangeFlags() & 4L) != 0L && SelectSecondSnapshotPanel.this.externalFileField.isShowing()) {
                            SelectSecondSnapshotPanel.this.projectSnapshotsList.removeHierarchyListener(this);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    SelectSecondSnapshotPanel.this.projectSnapshotsList.requestFocusInWindow();
                                }
                            });
                        }
                    }
                });
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Mnemonics.setLocalizedText((AbstractButton)SelectSecondSnapshotPanel.this.fromProjectRadio, (String)Bundle.CompareSnapshotsHelper_FromCurrentLocationRadioText());
                    SelectSecondSnapshotPanel.this.fromProjectRadio.setToolTipText(heapdumpDir != null ? heapdumpDir.getAbsolutePath() : null);
                }
            });
        }

        private void initComponents() {
            this.okButton = new JButton(Bundle.CompareSnapshotsHelper_OkButtonText());
            this.setLayout(new GridBagLayout());
            ButtonGroup group = new ButtonGroup();
            this.selectSnapshotLabel = new JLabel(Bundle.CompareSnapshotsHelper_SelectSnapshotString());
            GridBagConstraints c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(15, 10, 8, 10);
            this.add((Component)this.selectSnapshotLabel, c);
            this.fromProjectRadio = new JRadioButton();
            Mnemonics.setLocalizedText((AbstractButton)this.fromProjectRadio, (String)Bundle.CompareSnapshotsHelper_FromProjectRadioText());
            group.add(this.fromProjectRadio);
            this.fromProjectRadio.getAccessibleContext().setAccessibleDescription(Bundle.CompareSnapshotsHelper_SelectSnapshotString() + Bundle.CompareSnapshotsHelper_FromProjectRadioText());
            this.fromProjectRadio.setSelected(true);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(0, 15, 0, 10);
            this.add((Component)this.fromProjectRadio, c);
            this.projectSnapshotsList = new JList(new DefaultListModel());
            this.projectSnapshotsList.getAccessibleContext().setAccessibleName(Bundle.CompareSnapshotsHelper_SnapshotsListAccessDescr());
            this.projectSnapshotsList.setVisibleRowCount(5);
            this.projectSnapshotsList.setSelectionMode(0);
            JScrollPane projectSnapshotsListScroll = new JScrollPane(this.projectSnapshotsList, 20, 31);
            projectSnapshotsListScroll.setPreferredSize(new Dimension(1, projectSnapshotsListScroll.getPreferredSize().height));
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 2;
            c.weighty = 1.0;
            c.gridwidth = 0;
            c.anchor = 18;
            c.fill = 1;
            c.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 10);
            this.add((Component)projectSnapshotsListScroll, c);
            this.projectSnapshotsHintLabel = new JLabel(" ");
            this.projectSnapshotsHintLabel.setForeground(Color.darkGray);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 3;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 10);
            this.add((Component)this.projectSnapshotsHintLabel, c);
            this.fromFileRadio = new JRadioButton(Bundle.CompareSnapshotsHelper_FromFileRadioText());
            Mnemonics.setLocalizedText((AbstractButton)this.fromFileRadio, (String)Bundle.CompareSnapshotsHelper_FromFileRadioText());
            group.add(this.fromFileRadio);
            this.fromProjectRadio.getAccessibleContext().setAccessibleDescription(Bundle.CompareSnapshotsHelper_SelectSnapshotString() + Bundle.CompareSnapshotsHelper_FromFileRadioText());
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 4;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(5, 15, 0, 10);
            this.add((Component)this.fromFileRadio, c);
            this.externalFileField = new JTextField();
            this.externalFileField.setPreferredSize(new Dimension(250, this.externalFileField.getPreferredSize().height));
            this.externalFileField.setEnabled(false);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 5;
            c.weightx = 1.0;
            c.gridwidth = 2;
            c.anchor = 17;
            c.fill = 2;
            c.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 5);
            this.add((Component)this.externalFileField, c);
            this.externalFileButton = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.externalFileButton, (String)Bundle.CompareSnapshotsHelper_BrowseButtonText());
            this.externalFileButton.getAccessibleContext().setAccessibleDescription(Bundle.CompareSnapshotsHelper_BrowseButtonAccessDescr());
            this.externalFileButton.setEnabled(false);
            c = new GridBagConstraints();
            c.gridx = 2;
            c.gridy = 5;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(0, 5, 5, 10);
            this.add((Component)this.externalFileButton, c);
            this.externalFileHintLabel = new JLabel(" ");
            this.externalFileHintLabel.setForeground(Color.darkGray);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 6;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 10);
            this.add((Component)this.externalFileHintLabel, c);
            this.compareRetainedCheckBox = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this.compareRetainedCheckBox, (String)Bundle.CompareSnapshotsHelper_CompareRetainedRadio());
            this.compareRetainedCheckBox.getAccessibleContext().setAccessibleDescription(Bundle.CompareSnapshotsHelper_CompareRetainedRadioAccessDescr());
            this.compareRetainedCheckBox.setSelected(JavaDiffDumpSelector.this.compareRetained);
            c = new GridBagConstraints();
            c.gridx = 0;
            c.gridy = 7;
            c.gridwidth = 0;
            c.anchor = 17;
            c.fill = 0;
            c.insets = new Insets(5, 15, 0, 10);
            this.add((Component)this.compareRetainedCheckBox, c);
            if (!JavaDiffDumpSelector.this.compareRetained) {
                JLabel compareRetainedHintLabel = new JLabel(Bundle.CompareSnapshotsHelper_CompareRetainedHint());
                compareRetainedHintLabel.setForeground(Color.darkGray);
                c = new GridBagConstraints();
                c.gridx = 0;
                c.gridy = 8;
                c.gridwidth = 0;
                c.anchor = 17;
                c.insets = new Insets(0, 15 + new JRadioButton((String)"").getPreferredSize().width, 5, 10);
                this.add((Component)compareRetainedHintLabel, c);
            }
            this.projectSnapshotsList.setCellRenderer(new DefaultListCellRenderer(){

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    JLabel c = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    if (value instanceof FileObject) {
                        FileObject fo = (FileObject)value;
                        c.setIcon(memoryIcon);
                        c.setText(JavaDiffDumpSelector.getHeapDumpDisplayName(fo.getName()));
                    }
                    return c;
                }
            });
            this.projectSnapshotsList.addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            });
            this.projectSnapshotsList.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getButton() == 1 && e.getClickCount() == 2 && SelectSecondSnapshotPanel.this.projectSnapshotsList.getSelectedValue() != null) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                SelectSecondSnapshotPanel.this.okButton.doClick();
                            }
                        });
                    }
                }
            });
            this.fromProjectRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SelectSecondSnapshotPanel.this.projectSnapshotsList.setEnabled(SelectSecondSnapshotPanel.this.fromProjectRadio.isSelected());
                    SelectSecondSnapshotPanel.this.projectSnapshotsHintLabel.setText(" ");
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            });
            this.fromFileRadio.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    SelectSecondSnapshotPanel.this.externalFileField.setEnabled(SelectSecondSnapshotPanel.this.fromFileRadio.isSelected());
                    SelectSecondSnapshotPanel.this.externalFileButton.setEnabled(SelectSecondSnapshotPanel.this.fromFileRadio.isSelected());
                    if (!SelectSecondSnapshotPanel.this.fromFileRadio.isSelected()) {
                        SelectSecondSnapshotPanel.this.externalFileHintLabel.setText(" ");
                    }
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            });
            DocumentListener documentListener = new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    SelectSecondSnapshotPanel.this.updateOKButton();
                }
            };
            this.externalFileField.getDocument().addDocumentListener(documentListener);
            this.externalFileButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    File file;
                    JFileChooser snapshotChooser = JavaDiffDumpSelector.getSnapshotFileChooser();
                    snapshotChooser.setCurrentDirectory(new File(SelectSecondSnapshotPanel.this.externalFileField.getText()));
                    if (snapshotChooser.showOpenDialog(WindowManager.getDefault().getMainWindow()) == 0 && (file = snapshotChooser.getSelectedFile()) != null) {
                        SelectSecondSnapshotPanel.this.externalFileField.setText(file.getAbsolutePath());
                    }
                }
            });
            this.updateOKButton();
        }

        private void updateOKButton() {
            if (this.fromProjectRadio.isSelected()) {
                Object selectedItem = this.projectSnapshotsList.getSelectedValue();
                this.okButton.setEnabled(selectedItem != null && !(selectedItem instanceof String));
            } else if (this.fromFileRadio.isSelected()) {
                String sf = this.externalFileField.getText();
                if (!sf.isEmpty()) {
                    File s = new File(sf);
                    if (s.exists() && JavaDiffDumpSelector.checkHprofFile(s)) {
                        if (s.equals(JavaDiffDumpSelector.this.context.getFile())) {
                            this.externalFileHintLabel.setText(Bundle.CompareSnapshotsHelper_ComparingSameSnapshotsMsg());
                            this.okButton.setEnabled(false);
                        } else {
                            this.externalFileHintLabel.setText(" ");
                            this.okButton.setEnabled(true);
                        }
                    } else {
                        this.externalFileHintLabel.setText(Bundle.CompareSnapshotsHelper_InvalidFileMsg());
                        this.okButton.setEnabled(false);
                    }
                } else {
                    this.externalFileHintLabel.setText(Bundle.CompareSnapshotsHelper_EnterFileMsg());
                    this.okButton.setEnabled(false);
                }
            } else {
                this.okButton.setEnabled(false);
            }
        }
    }
}

