"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.COVERAGE_TOOL_TIP = exports.COMPARE_SEARCH_RESULTS_TITLE = exports.BackendEndpoints = void 0;
Object.defineProperty(exports, "DISABLED_BACKEND_PLUGIN_MESSAGE", {
  enumerable: true,
  get: function () {
    return _error_handling.DISABLED_BACKEND_PLUGIN_MESSAGE;
  }
});
exports.ServiceEndpoints = exports.SavedObjectIds = exports.SEARCH_RELEVANCE_EXPERIMENTAL_WORKBENCH_UI_EXPERIENCE_ENABLED = exports.SEARCH_API = exports.Routes = exports.RouteTemplateType = exports.RBO90_TOOL_TIP = exports.RBO50_TOOL_TIP = exports.QUERY_NUMBER_TWO = exports.QUERY_NUMBER_ONE = exports.PRECISION_TOOL_TIP = exports.PLUGIN_NAME = exports.PLUGIN_ID = exports.NDCG_TOOL_TIP = exports.ML_MODEL_ROUTE_PREFIX = exports.MAP_TOOL_TIP = exports.JACCARD_TOOL_TIP = exports.FREQUENCY_WEIGHTED_TOOL_TIP = void 0;
Object.defineProperty(exports, "extractUserMessageFromError", {
  enumerable: true,
  get: function () {
    return _error_handling.extractUserMessageFromError;
  }
});
var _error_handling = require("./error_handling");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const PLUGIN_ID = exports.PLUGIN_ID = 'searchRelevance';
const PLUGIN_NAME = exports.PLUGIN_NAME = 'Search Relevance';
const COMPARE_SEARCH_RESULTS_TITLE = exports.COMPARE_SEARCH_RESULTS_TITLE = 'Compare Search Results';
const SEARCH_RELEVANCE_EXPERIMENTAL_WORKBENCH_UI_EXPERIENCE_ENABLED = exports.SEARCH_RELEVANCE_EXPERIMENTAL_WORKBENCH_UI_EXPERIENCE_ENABLED = 'search-relevance:experimental_workbench_ui_enabled';
const SEARCH_RELEVANCE_WORKBENCH_BASE_PATH = '/api/relevancy';
const ServiceEndpoints = exports.ServiceEndpoints = Object.freeze({
  // OpenSearch node APIs
  GetIndexes: `${SEARCH_RELEVANCE_WORKBENCH_BASE_PATH}/search/indexes`,
  GetPipelines: `${SEARCH_RELEVANCE_WORKBENCH_BASE_PATH}/search/pipelines`,
  GetSearchResults: `${SEARCH_RELEVANCE_WORKBENCH_BASE_PATH}/search`,
  GetSingleSearchResults: `${SEARCH_RELEVANCE_WORKBENCH_BASE_PATH}/single_search`,
  GetStats: `${SEARCH_RELEVANCE_WORKBENCH_BASE_PATH}/stats`,
  GetClusterSettings: `${SEARCH_RELEVANCE_WORKBENCH_BASE_PATH}/cluster_settings`,
  GetModels: `${SEARCH_RELEVANCE_WORKBENCH_BASE_PATH}/models`,
  // Search Relevance node APIs
  QuerySets: `${SEARCH_RELEVANCE_WORKBENCH_BASE_PATH}/query_sets`,
  SearchConfigurations: `${SEARCH_RELEVANCE_WORKBENCH_BASE_PATH}/search_configurations`,
  Judgments: `${SEARCH_RELEVANCE_WORKBENCH_BASE_PATH}/judgments`,
  Experiments: `${SEARCH_RELEVANCE_WORKBENCH_BASE_PATH}/experiments`
});
const SEARCH_RELEVANCE_PLUGIN_BASE_PATH = '/_plugins/_search_relevance';
const BackendEndpoints = exports.BackendEndpoints = Object.freeze({
  QuerySets: `${SEARCH_RELEVANCE_PLUGIN_BASE_PATH}/query_sets`,
  SearchConfigurations: `${SEARCH_RELEVANCE_PLUGIN_BASE_PATH}/search_configurations`,
  Judgments: `${SEARCH_RELEVANCE_PLUGIN_BASE_PATH}/judgments`,
  Experiments: `${SEARCH_RELEVANCE_PLUGIN_BASE_PATH}/experiments`
});
const ML_COMMON_PLUGIN_BASE_PATH = '_plugins/_ml';
const ML_MODEL_ROUTE_PREFIX = exports.ML_MODEL_ROUTE_PREFIX = `${ML_COMMON_PLUGIN_BASE_PATH}/models`;
const SEARCH_API = exports.SEARCH_API = '/_search';

// Query1 for the left search and Query2 for the right search page
const QUERY_NUMBER_ONE = exports.QUERY_NUMBER_ONE = '1';
const QUERY_NUMBER_TWO = exports.QUERY_NUMBER_TWO = '2';
let RouteTemplateType = exports.RouteTemplateType = /*#__PURE__*/function (RouteTemplateType) {
  RouteTemplateType["SingleQueryComparison"] = "singleQueryComparison";
  RouteTemplateType["QuerySetComparison"] = "querySetComparison";
  RouteTemplateType["SearchEvaluation"] = "searchEvaluation";
  RouteTemplateType["HybridOptimizer"] = "hybridOptimizer";
  return RouteTemplateType;
}({});
let Routes = exports.Routes = function (Routes) {
  Routes["Home"] = "/";
  Routes["ExperimentListing"] = "/experiment";
  Routes["ExperimentView"] = "/experiment/view/:entityId";
  Routes["ExperimentViewPrefix"] = "/experiment/view";
  Routes["ExperimentCreate"] = "/experiment/create";
  Routes["ExperimentCreateSingleQueryComparison"] = "/experiment/create/singleQueryComparison";
  Routes["ExperimentCreateQuerySetComparison"] = "/experiment/create/querySetComparison";
  Routes["ExperimentCreateSearchEvaluation"] = "/experiment/create/searchEvaluation";
  Routes["ExperimentCreateHybridOptimizer"] = "/experiment/create/hybridOptimizer";
  Routes[Routes["ExperimentCreateTemplate"] = `/experiment/create/:templateId(${Object.values(RouteTemplateType).join('|')})`] = "ExperimentCreateTemplate";
  Routes["QuerySetListing"] = "/querySet";
  Routes["QuerySetView"] = "/querySet/view/:entityId";
  Routes["QuerySetViewPrefix"] = "/querySet/view";
  Routes["QuerySetCreate"] = "/querySet/create";
  Routes["SearchConfigurationListing"] = "/searchConfiguration";
  Routes["SearchConfigurationView"] = "/searchConfiguration/view/:entityId";
  Routes["SearchConfigurationViewPrefix"] = "/searchConfiguration/view";
  Routes["SearchConfigurationCreate"] = "/searchConfiguration/create";
  Routes["JudgmentListing"] = "/judgment";
  Routes["JudgmentView"] = "/judgment/view/:entityId";
  Routes["JudgmentViewPrefix"] = "/judgment/view";
  Routes["JudgmentCreate"] = "/judgment/create";
  return Routes;
}({});
let SavedObjectIds = exports.SavedObjectIds = /*#__PURE__*/function (SavedObjectIds) {
  SavedObjectIds["ExperimentDeepDive"] = "75b6ca00-58af-11f0-a87e-4d769b1dbd6c";
  SavedObjectIds["ExperimentVariantComparison"] = "fbf11670-58c8-11f0-a340-41deff9f2f7f";
  SavedObjectIds["SearchEvaluationIndexPattern"] = "1f5d2be0-57f1-11f0-8f39-7b4ad0195873";
  return SavedObjectIds;
}({}); // tool tip texts
const JACCARD_TOOL_TIP = exports.JACCARD_TOOL_TIP = 'Jaccard index measures the similarity between two sets of documents, defined as the size of the intersection divided by the size of the union of the sets. A higher value indicates greater overlap.';
const RBO50_TOOL_TIP = exports.RBO50_TOOL_TIP = 'Rank-Biased Overlap (RBO) measures the similarity of two ranked lists. A higher value indicates more similar rankings, especially at the top. rbo50 stands for a 50% chance a hypothetical user continues to the next rank. The lower the number the stronger the top ranks are weighted.';
const RBO90_TOOL_TIP = exports.RBO90_TOOL_TIP = 'Rank-Biased Overlap (RBO) measures the similarity of two ranked lists. A higher value indicates more similar rankings, especially at the top. rbo90 stands for a 90% chance a hypothetical user continues to the next rank. The lower the number the stronger the top ranks are weighted.';
const FREQUENCY_WEIGHTED_TOOL_TIP = exports.FREQUENCY_WEIGHTED_TOOL_TIP = 'frequencyWeighted measures the similarity of two sets of documents without duplicates. It gives higher weights to documents occurring in both result lists.';
const NDCG_TOOL_TIP = exports.NDCG_TOOL_TIP = 'Normalized Discounted Cumulative Gain (NDCG) measures the usefulness, or gain, of documents based on their position in the result list. The gain is accumulated from the top of the result list to the bottom, with documents at lower ranks being "discounted". The normalization ensures the score is between 0 and 1, where 1 is a perfect ranking.';
const PRECISION_TOOL_TIP = exports.PRECISION_TOOL_TIP = 'Precision measures the proportion of retrieved documents that are relevant. For a given rank K, Precision@K is the number of relevant documents among the top K retrieved documents, divided by K.';
const MAP_TOOL_TIP = exports.MAP_TOOL_TIP = 'Mean Average Precision (MAP) is a single-figure measure of quality across recall levels. For a single query, Average Precision (AP) is the average of the Precision values calculated at the rank of each relevant document. MAP is the mean of these Average Precision scores across multiple queries.';
const COVERAGE_TOOL_TIP = exports.COVERAGE_TOOL_TIP = 'Coverage represents the ratio of query-document pairs in the search results for which a relevance judgment exists. It indicates how much of the returned data has been evaluated for relevance.';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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